/*! \file CreateLoadsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsThermal(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int    dim;
	int    numberofvertices;

	/*DataSet*/
	Loads*    loads    = NULL;
	Pengrid*    pengrid  = NULL;

	/*Recover pointer: */
	loads=*ploads;

	/*Fetch parameters: */
	iomodel->Constant(&dim,MeshDimensionEnum);
	iomodel->Constant(&numberofvertices,NumberOfVerticesEnum);

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	/*return if 2d mesh*/
	if (dim==2) _error_("2d meshes not supported yet");

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(2,ThermalSpctemperatureEnum,ElementsEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for (i=0;i<numberofvertices;i++){
	
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){
			if (isnan(iomodel->Data(ThermalSpctemperatureEnum)[i])){ //No penalty applied on spc nodes!
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,ThermalAnalysisEnum));
			}
		}
	}
	iomodel->DeleteData(2,ThermalSpctemperatureEnum,ElementsEnum);

	/*Assign output pointer: */
	*ploads=loads;
}
