%MESH class definition
%
%   Usage:
%      mesh=mesh();

classdef mesh
	properties (SetAccess=public) 
		average_vertex_connectivity = modelfield('default',0,'marshall',true,'format','Integer');
		extractedvertices           = modelfield('default',NaN,'marshall',false);
		extractedelements           = modelfield('default',NaN,'marshall',false);
		vertexonboundary            = modelfield('default',NaN,'marshall',false);
		lat        = modelfield('default',NaN,'marshall',false);
		long       = modelfield('default',NaN,'marshall',false);
		hemisphere = modelfield('default',NaN,'marshall',false);
		segments             = modelfield('default',NaN,'marshall',false);
		segmentmarkers       = modelfield('default',NaN,'marshall',false);
	end
	methods
		function obj = mesh(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%the connectivity is the avergaded number of nodes linked to a
			%given node through an edge. This connectivity is used to initially
			%allocate memory to the stiffness matrix. A value of 16 seems to
			%give a good memory/time ration. This value can be checked in
			%trunk/test/Miscellaneous/runme.m
			obj.average_vertex_connectivity=25;
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Mesh:')); 

			if obj.dim==3,
				disp(sprintf('\n      Elements and nodes of the original 2d mesh:'));
				fielddisplay(obj,'numberofelements2d','number of elements');
				fielddisplay(obj,'numberofnodes2d','number of nodes');
				fielddisplay(obj,'elements2d','index into (x,y,z), coordinates of the nodes');
				fielddisplay(obj,'x2d','nodes x coordinate');
				fielddisplay(obj,'y2d','nodes y coordinate');

				disp(sprintf('\n      Elements and nodes of the extruded 3d mesh:'));
			else
				disp(sprintf('\n      Elements and nodes:'));
			end
			fielddisplay(obj,'numberofelements','number of elements');
			fielddisplay(obj,'numberofnodes','number of nodes');
			fielddisplay(obj,'elements','index into (x,y,z), coordinates of the nodes');
			fielddisplay(obj,'elements_type','element types');
			fielddisplay(obj,'x','nodes x coordinate');
			fielddisplay(obj,'y','nodes y coordinate');
			fielddisplay(obj,'z','nodes z coordinate');
			fielddisplay(obj,'edges','edges of the 2d mesh (node1 node2 element1 element2)');

			disp(sprintf('\n      Properties:'));
			fielddisplay(obj,'dim','mesh dimension (2d or 3d)');
			fielddisplay(obj,'numlayers','number of extrusion layers');
			fielddisplay(obj,'penalties','penalties list');
			fielddisplay(obj,'nodeonbed','lower nodes flags list');
			fielddisplay(obj,'elementonbed','lower elements flags list');
			fielddisplay(obj,'nodeonsurface','upper nodes flags list');
			fielddisplay(obj,'elementonsurface','upper elements flags list');
		end % }}}
	end
end
