/*! \file
  
  \brief Declarations for the ReachConsts::Interface implementation of 
         interprocedural ReachConsts results.

  \authors Michelle Strout, Barbara Kreaseck
  \version $Id: InterReachConsts.hpp,v 1.2 2005/06/10 02:32:04 mstrout Exp $

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef InterReachConsts_H
#define InterReachConsts_H

#include <OpenAnalysis/ReachConsts/Interface.hpp>
#include <OpenAnalysis/ReachConsts/ReachConsts.hpp>
#include <OpenAnalysis/ReachConsts/CSReachConsts.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Alias/Interface.hpp>
#include <map>

namespace OA {
  namespace ReachConsts {

    class InterReachConsts : public virtual Annotation {
  public:
    InterReachConsts() {}
    virtual ~InterReachConsts() {}

    //! Returns ReachConsts results for the given procedure
    OA_ptr<ReachConsts::Interface> getReachConsts(ProcHandle proc);
        
    //*****************************************************************
    // Annotation Interface
    //*****************************************************************
    void output(OA::IRHandlesIRInterface& ir) const { 
        std::cout << "Please add Alias::Interface" << std::endl; 
        assert(0); 
    }
    void output(OA::IRHandlesIRInterface& ir,
                Alias::Interface &alias) const;

    //*****************************************************************
    // Output
    //*****************************************************************
    //! debugging output
    void dump(std::ostream& os, OA_ptr<IRHandlesIRInterface> ir);
   
    //*****************************************************************
    // Construction methods 
    //*****************************************************************

    //! attach ReachConsts interface to procedure
    void mapProcToReachConsts(ProcHandle proc, 
                              OA_ptr<ReachConsts::Interface> rcs)
      { mProcToReachConstsMap[proc] = rcs; }


  private:
  std::map<ProcHandle,OA_ptr<ReachConsts::Interface> > 
      mProcToReachConstsMap;


};

  } // end of ReachConsts namespace
} // end of OA namespace

#endif

