/*! \file
  
  \brief Implementation of DataFlow::CCDFSPair

  \author Michelle Strout, Barbara Kreaseck
  \version $Id: CCDFSPair.cpp,v 1.7 2005/03/18 18:14:16 ntallent Exp $

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/


#include "CCDFSPair.hpp"
#include <OpenAnalysis/Utils/Util.hpp>
//#include <OpenAnalysis/Utils/OutputBuilder.hpp>

namespace OA {
  namespace DataFlow {

static bool debug = false;


//! ===============================================================
//! CCDFSPair methods
//! ===============================================================


CCDFSPair::CCDFSPair(OA_ptr<Alias::CallContext> cc, 
               OA_ptr<DataFlowSet> dfs) 
{
  OA_DEBUG_CTRL_MACRO("DEBUG_CCDFSPair:ALL", debug);
  mCCPtr = cc;
  mDFSetPtr = dfs; 
}

    // copies, does not clone ==> send clone in if needed
CCDFSPair::CCDFSPair(const CCDFSPair& other) 
{
  mCCPtr = other.mCCPtr;
  mDFSetPtr = other.mDFSetPtr;	
}


    // copies, does not clone ==> send clone in if needed
CCDFSPair& CCDFSPair::operator=(const CCDFSPair& other) {

  mCCPtr = other.mCCPtr;
  mDFSetPtr = other.mDFSetPtr;
  return *this;
}

OA_ptr<CCDFSPair> CCDFSPair::clone() {
  OA_ptr<CCDFSPair> retval;
  retval = new CCDFSPair(mCCPtr->clone(), mDFSetPtr->clone());
  return retval;
}


CCDFSPair::~CCDFSPair() { }




OA_ptr<Alias::CallContext> CCDFSPair::getContextPtr() const { 
  return mCCPtr; 
}



OA_ptr<DataFlowSet> CCDFSPair::getDFSetPtr() const { 
  return mDFSetPtr; 
}



bool CCDFSPair::operator== (const CCDFSPair &other) const {
  bool retval=false;
  
  if (!mCCPtr.ptrEqual(0) && !other.getContextPtr().ptrEqual(0)) {
    if (mDFSetPtr.ptrEqual(0)
        && (other.getDFSetPtr()).ptrEqual(0))
      {
        retval = true; 
      }
    else if (!mDFSetPtr.ptrEqual(0)&&
             !other.getDFSetPtr().ptrEqual(0)) 
      {
	//        if (mDFSetPtr->operator==(*(other.getDFSetPtr())) 
        if (mDFSetPtr==(other.getDFSetPtr())) // will this call mDFSetPtr->operator==()??? 
          { 
            retval = true; 
          }
      }
  }

  return retval;
}




bool CCDFSPair::operator< (const CCDFSPair &other) const 
{ 
  bool retval = false;

  if (*mCCPtr < *(other.mCCPtr)) { 
    retval = true; 
  } else if (*(other.mCCPtr) < *mCCPtr) {
    retval = false;
  } else {
    // if equal CallContext, we have no way to compare DataFlowSets.
    // and ... actually, the way we plan to use these, we will be putting them
    // in sets, but there should only be one CCDFSPair in the set with any given
    // CallContext.
    retval = false;
  }
  
  return retval;
}



bool CCDFSPair::operator!= (const CCDFSPair &other) const 
{ return !(*this==other); }



 


//! =========================================================================
//! CCDFSPair output methods
//! =========================================================================


void CCDFSPair::output(IRHandlesIRInterface& ir) const {

  // DataFlowSet::output can only be called with ir.
  
  //     std::cout << "Please call output with alias::Interface"
  //               << std::endl;
  //     assert(0);

  sOutBuild->objStart("CCDFSPair");
      
  sOutBuild->fieldStart("mCCPtr");
    mCCPtr->output(ir);
  sOutBuild->fieldEnd("mCCPtr");
      
  sOutBuild->fieldStart("mDFSetPtr");
  
  mDFSetPtr->output(ir);
  sOutBuild->fieldEnd("mDFSetPtr");
  
  sOutBuild->objEnd("CCDFSPair");


}





void CCDFSPair::output(OA::IRHandlesIRInterface &ir,
                    Alias::Interface &alias) const
{
  output(ir);
}
    



void CCDFSPair::dump(std::ostream &os, OA_ptr<IRHandlesIRInterface> pIR) 
{
  os << "[ ";
  mCCPtr->dump(os,*pIR);
  os << ", ";
  mDFSetPtr->dump(os,pIR);
  os << " ]\n";  
}


  } // end of DataFlow namespace
} // end of OA namespace

