/* Useful.hpp
   NOTE: This file was automatically generated by DFAGen.  It is the interface
         for the Useful analysis results.
*/

#ifndef Useful_hpp
#define Useful_hpp

#include <cassert>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/IRInterface/auto_UsefulIRInterface.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/GenOutputTool.hpp>
#include <OpenAnalysis/Alias/AliasTag.hpp>
#include <OpenAnalysis/ExprTree/ExprTree.hpp>
#include <OpenAnalysis/DataFlow/DataFlowSetImpl.hpp>
#include <OpenAnalysis/DataFlow/DFSetBitImpl.hpp>
#include <OpenAnalysis/DataFlow/IRHandleDataFlowSet.hpp>
#include <OpenAnalysis/Utils/Util.hpp>

namespace OA {
  namespace Useful {

typedef DataFlow::DataFlowSetImpl<Alias::AliasTag >  UsefulDFSet;

class Useful : public virtual Annotation {
  public:
    //*****************************************************************
    // Construction methods
    //*****************************************************************
    Useful(ProcHandle p, OA_ptr<UsefulIRInterface> _ir) {
        mIR = _ir;
        mExitUseful = new UsefulDFSet();
    }
    ~Useful() {}


    //*****************************************************************
    // Query methods
    //*****************************************************************
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > getUsefulIterator(StmtHandle s) const;

    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > getExitUsefulIterator() const;

    OA_ptr<UsefulDFSet> getUsefulSet(StmtHandle s) {
        map<StmtHandle, OA_ptr<UsefulDFSet> >::iterator element =
            mUseful.find(s);

        if(element == mUseful.end()) {
            mUseful[s] = new UsefulDFSet();
            element = mUseful.find(s);
        }

        return (*element).second;
    }


    //*****************************************************************
    // Modifier methods
    //*****************************************************************
    void insert(StmtHandle s, Alias::AliasTag  val) {
        if(mUseful[s].ptrEqual(0)) {
            mUseful[s] = new UsefulDFSet();
        }
        mUseful[s]->insert(val);
    }

    void insertExit(Alias::AliasTag  val) {
        mExitUseful->insert(val);
    }


    //*****************************************************************
    // Output
    //*****************************************************************
    void output(IRHandlesIRInterface& pIR) const;

    void dump(std::ostream& os,
        OA_ptr<IRHandlesIRInterface> ir,
        Alias::Interface& aliasResults) const;



  private:
    map<StmtHandle, OA_ptr<UsefulDFSet> > mUseful;
    OA_ptr<UsefulDFSet>  mExitUseful;
    OA_ptr<UsefulIRInterface> mIR;
};

  } // end of Liveness namespace
} // end of OA namespace

#endif

