/* ReachingDefs.hpp
   NOTE: This file was automatically generated by DFAGen.  It is the interface
         for the ReachingDefs analysis results.
*/

#ifndef ReachingDefs_hpp
#define ReachingDefs_hpp

#include <cassert>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/IRInterface/auto_ReachingDefsIRInterface.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/GenOutputTool.hpp>
#include <OpenAnalysis/Alias/AliasTag.hpp>
#include <OpenAnalysis/ExprTree/ExprTree.hpp>
#include <OpenAnalysis/DataFlow/DataFlowSetImpl.hpp>
#include <OpenAnalysis/DataFlow/DFSetBitImpl.hpp>
#include <OpenAnalysis/DataFlow/IRHandleDataFlowSet.hpp>
#include <OpenAnalysis/Utils/Util.hpp>

namespace OA {
  namespace ReachingDefs {

typedef DataFlow::DataFlowSetImpl<StmtHandle >  ReachingDefsDFSet;

class ReachingDefs : public virtual Annotation {
  public:
    //*****************************************************************
    // Construction methods
    //*****************************************************************
    ReachingDefs(ProcHandle p, OA_ptr<ReachingDefsIRInterface> _ir) {
        mIR = _ir;
        mExitReachingDefs = new ReachingDefsDFSet();
    }
    ~ReachingDefs() {}


    //*****************************************************************
    // Query methods
    //*****************************************************************
    OA_ptr<DataFlow::DataFlowSetImplIterator<StmtHandle > > getReachingDefsIterator(StmtHandle s) const;

    OA_ptr<DataFlow::DataFlowSetImplIterator<StmtHandle > > getExitReachingDefsIterator() const;

    OA_ptr<ReachingDefsDFSet> getReachingDefsSet(StmtHandle s) {
        map<StmtHandle, OA_ptr<ReachingDefsDFSet> >::iterator element =
            mReachingDefs.find(s);

        if(element == mReachingDefs.end()) {
            mReachingDefs[s] = new ReachingDefsDFSet();
            element = mReachingDefs.find(s);
        }

        return (*element).second;
    }


    //*****************************************************************
    // Modifier methods
    //*****************************************************************
    void insert(StmtHandle s, StmtHandle  val) {
        if(mReachingDefs[s].ptrEqual(0)) {
            mReachingDefs[s] = new ReachingDefsDFSet();
        }
        mReachingDefs[s]->insert(val);
    }

    void insertExit(StmtHandle  val) {
        mExitReachingDefs->insert(val);
    }


    //*****************************************************************
    // Output
    //*****************************************************************
    void output(IRHandlesIRInterface& pIR) const;

    void dump(std::ostream& os,
        OA_ptr<IRHandlesIRInterface> ir,
        Alias::Interface& aliasResults) const;



  private:
    map<StmtHandle, OA_ptr<ReachingDefsDFSet> > mReachingDefs;
    OA_ptr<ReachingDefsDFSet>  mExitReachingDefs;
    OA_ptr<ReachingDefsIRInterface> mIR;
};

  } // end of Liveness namespace
} // end of OA namespace

#endif

