
/* LivenessStandard.hpp
   NOTE: This file was automatically generated by DFAGen.  It is the interface
         for the Liveness analysis results.
*/

#ifndef LivenessStandard_hpp
#define LivenessStandard_hpp

#include <cassert>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/IRInterface/LivenessIRInterface.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/GenOutputTool.hpp>
#include <OpenAnalysis/Location/Location.hpp>
#include <OpenAnalysis/DataFlow/DFAGenDFSet.hpp>
#include <OpenAnalysis/Utils/Util.hpp>

namespace OA {
  namespace Liveness {

typedef DataFlow::DFAGenDFSet<OA_ptr<Location> > LivenessDFSet;

class LivenessStandard : public virtual Annotation {
  public:
    LivenessStandard(ProcHandle p, OA_ptr<LivenessIRInterface> _ir) {
        mIR = _ir;
        mExitLiveness = new LivenessDFSet();
    }
    ~LivenessStandard() {}

    LivenessDFSet::iterator getLivenessIterator(StmtHandle s);

    LivenessDFSet::iterator getExitLivenessIterator();

    void insert(StmtHandle s, OA_ptr<Location>  val) {
        if(mLiveness[s].ptrEqual(0)) {
            mLiveness[s] = new LivenessDFSet();
        }
        mLiveness[s]->insert(val);
    }

    void insertExit(OA_ptr<Location>  val) {
        mExitLiveness->insert(val);
    }

    OA_ptr<LivenessDFSet> getLivenessSet(StmtHandle s) {
        map<StmtHandle, OA_ptr<LivenessDFSet> >::iterator element =
            mLiveness.find(s);

        if(element == mLiveness.end()) {
            mLiveness[s] = new LivenessDFSet();
            element = mLiveness.find(s);
        }

        return (*element).second;
    }

    void output(IRHandlesIRInterface& pIR);

    void dump(std::ostream& os, OA_ptr<IRHandlesIRInterface> ir);

  private:
    map<StmtHandle, OA_ptr<LivenessDFSet> > mLiveness;
    OA_ptr<LivenessDFSet>  mExitLiveness;
    OA_ptr<LivenessIRInterface> mIR;
};

  } // end of Liveness namespace
} // end of OA namespace

#endif

