/* Liveness.cpp
   NOTE: This file was automatically generated by DFAGen.  It is the
         implementation of the class for Liveness analysis results.
*/


#include "auto_Liveness.hpp"

namespace OA {
  namespace Liveness {


OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > Liveness::getLivenessIterator(StmtHandle s) const {
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > retval;

    if(mLiveness.find(s) == mLiveness.end()) {
        retval = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > ();
    } else {
        retval = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (
            mLiveness.find(s)->second);
    }

    return retval;
}


OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > Liveness::getExitLivenessIterator() const {
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > retval;

    retval = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (mExitLiveness);
    return retval;
}


void Liveness::output(IRHandlesIRInterface& ir) const {
    sOutBuild->objStart("Liveness");

    sOutBuild->mapStart("mLiveness", "StmtHandle", "OA_ptr<LivenessDFSet>");

    std::map<StmtHandle,OA_ptr<LivenessDFSet> >::const_iterator mapIter;
    for (mapIter = mLiveness.begin(); mapIter != mLiveness.end(); mapIter++) {
        StmtHandle s = mapIter->first;
        OA_ptr<LivenessDFSet> rdset = mapIter->second;
        if ( rdset.ptrEqual(0) ) continue;

        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();
        sOutBuild->outputIRHandle(s, ir);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart();


        sOutBuild->listStart();
        OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > setIter;
        setIter = getLivenessIterator(s);
        for ( ; setIter->isValid(); (*setIter)++ ) {
             sOutBuild->listItemStart();
             setIter->current().output(ir);
             sOutBuild->listItemEnd();
        }
        sOutBuild->listEnd();
        sOutBuild->mapValueEnd();
        sOutBuild->mapEntryEnd();
    }
    sOutBuild->mapEnd("mLiveness");
    sOutBuild->objEnd("Liveness");
}


void Liveness::dump(
    std::ostream& os,
    OA_ptr<IRHandlesIRInterface> ir,
    Alias::Interface& aliasResults) const
{
    os << "Liveness Analysis results." << endl;
    std::map<StmtHandle, OA_ptr<LivenessDFSet> >::const_iterator mapIter;

    for (mapIter = mLiveness.begin(); mapIter != mLiveness.end(); mapIter++) {
        os << "\tstmt = " << ir->toString(mapIter->first) << std::endl;
        OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > iter;
        iter = getLivenessIterator(mapIter->first);

        for ( ; iter->isValid(); (*iter)++) {
            os << "\t\t";
        iter->current().dump(os, *mIR, aliasResults);
            os << std::endl;
        }
    }
}


  } // end of Liveness namespace
} // end of OA namespace
