/* AvailExpr.hpp
   NOTE: This file was automatically generated by DFAGen.  It is the interface
         for the AvailExpr analysis results.
*/

#ifndef AvailExpr_hpp
#define AvailExpr_hpp

#include <cassert>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/IRInterface/auto_AvailExprIRInterface.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/GenOutputTool.hpp>
#include <OpenAnalysis/Alias/AliasTag.hpp>
#include <OpenAnalysis/ExprTree/ExprTree.hpp>
#include <OpenAnalysis/DataFlow/DataFlowSetImpl.hpp>
#include <OpenAnalysis/DataFlow/DFSetBitImpl.hpp>
#include <OpenAnalysis/DataFlow/IRHandleDataFlowSet.hpp>
#include <OpenAnalysis/Utils/Util.hpp>

namespace OA {
  namespace AvailExpr {

typedef DataFlow::DataFlowSetImpl<OA_ptr<ExprTree> >  AvailExprDFSet;

class AvailExpr : public virtual Annotation {
  public:
    //*****************************************************************
    // Construction methods
    //*****************************************************************
    AvailExpr(ProcHandle p, OA_ptr<AvailExprIRInterface> _ir) {
        mIR = _ir;
        mExitAvailExpr = new AvailExprDFSet();
    }
    ~AvailExpr() {}


    //*****************************************************************
    // Query methods
    //*****************************************************************
    OA_ptr<DataFlow::DataFlowSetImplIterator<OA_ptr<ExprTree> > > getAvailExprIterator(StmtHandle s) const;

    OA_ptr<DataFlow::DataFlowSetImplIterator<OA_ptr<ExprTree> > > getExitAvailExprIterator() const;

    OA_ptr<AvailExprDFSet> getAvailExprSet(StmtHandle s) {
        map<StmtHandle, OA_ptr<AvailExprDFSet> >::iterator element =
            mAvailExpr.find(s);

        if(element == mAvailExpr.end()) {
            mAvailExpr[s] = new AvailExprDFSet();
            element = mAvailExpr.find(s);
        }

        return (*element).second;
    }


    //*****************************************************************
    // Modifier methods
    //*****************************************************************
    void insert(StmtHandle s, OA_ptr<ExprTree>  val) {
        if(mAvailExpr[s].ptrEqual(0)) {
            mAvailExpr[s] = new AvailExprDFSet();
        }
        mAvailExpr[s]->insert(val);
    }

    void insertExit(OA_ptr<ExprTree>  val) {
        mExitAvailExpr->insert(val);
    }


    //*****************************************************************
    // Output
    //*****************************************************************
    void output(IRHandlesIRInterface& pIR) const;

    void dump(std::ostream& os,
        OA_ptr<IRHandlesIRInterface> ir,
        Alias::Interface& aliasResults) const;



  private:
    map<StmtHandle, OA_ptr<AvailExprDFSet> > mAvailExpr;
    OA_ptr<AvailExprDFSet>  mExitAvailExpr;
    OA_ptr<AvailExprIRInterface> mIR;
};

  } // end of Liveness namespace
} // end of OA namespace

#endif

