// ManagerActivity.cpp

#include "auto_ManagerActivity.hpp"

using namespace std;
using namespace OA::DataFlow;
using namespace OA::CFG;
using namespace OA::Alias;
using namespace OA::SideEffect;

namespace OA {
  namespace Activity {

static bool debug = false;


ManagerActivity::ManagerActivity(
    OA_ptr<ActivityIRInterface> _ir)
    :
    mIR(_ir)
{
    // Check OA_DEBUG environmental variable to see if we should turn debugging
    // mode on.
    OA_DEBUG_CTRL_MACRO("DEBUG_ManagerActivity:ALL", debug);

    // Initialize member data
    mSolver = new CFGDFSolver(CFGDFSolver::Forward, *this);
}


OA_ptr<Activity> ManagerActivity::performAnalysis(
    ProcHandle proc,
    OA_ptr<CFGInterface> cfg,
    OA_ptr<OA::Alias::Interface> alias,
    OA_ptr<InterSideEffectInterface> interSE,
        std::map<StmtHandle, set<Alias::AliasTag> > &mayUseful,
        std::map<StmtHandle, set<Alias::AliasTag> > &mayVary
    )
{
    if (debug) {
        cout << "In Activity::ManagerActivity::performAnalysis"
             << endl;
    }

    // create the object we'll store results in
    mActivityMap = new Activity(proc, mIR);

    // store Alias information for use within the transfer function
    mAlias = alias;

    {

        // maycode for defs[s]
        OA_ptr<IRStmtIterator> stmtIter;
        stmtIter = mIR->getStmtIterator(proc);
        for(; stmtIter->isValid(); ++(*stmtIter)) {
            StmtHandle stmt = stmtIter->current();

            OA_ptr<MemRefHandleIterator> defsIter;
            defsIter = mIR->getDefMemRefs(stmt);
            for (; defsIter->isValid(); (*defsIter)++) {
                MemRefHandle ref = defsIter->current();

                OA_ptr<AliasTagSet> tagSet;
                tagSet = alias->getAliasTags(ref);
                OA_ptr<AliasTagIterator> tagIter;
                tagIter = tagSet->getIterator();
                for(; tagIter->isValid(); ++(*tagIter)) {
                    mStmt2MayDefMap[stmt].insert(tagIter->current());
                }
            }
        }
    } {

        // mustcode for defs[s]
        OA_ptr<IRStmtIterator> stmtIter;
        stmtIter = mIR->getStmtIterator(proc);
        for(; stmtIter->isValid(); ++(*stmtIter)) {
            StmtHandle stmt = stmtIter->current();

            OA_ptr<MemRefHandleIterator> defsIter;
            defsIter = mIR->getDefMemRefs(stmt);
            for (; defsIter->isValid(); (*defsIter)++) {
                MemRefHandle ref = defsIter->current();

                OA_ptr<AliasTagSet> tagSet;
                tagSet = alias->getAliasTags(ref);
                if(tagSet->isMust()) {
                    OA_ptr<AliasTagIterator> tagIter;
                    tagIter = tagSet->getIterator();
                    for(; tagIter->isValid(); ++(*tagIter)) {
                        mStmt2MustDefMap[stmt].insert(tagIter->current());
                    }
                }
            }
        }
    }
    {
} {
}
    {

        // maycode for uses[s]
        OA_ptr<IRStmtIterator> stmtIter;
        stmtIter = mIR->getStmtIterator(proc);
        for(; stmtIter->isValid(); ++(*stmtIter)) {
            StmtHandle stmt = stmtIter->current();

            OA_ptr<MemRefHandleIterator> usesIter;
            usesIter= mIR->getUseMemRefs(stmt);
            for (; usesIter->isValid(); (*usesIter)++) {
                MemRefHandle ref = usesIter->current();
                
                OA_ptr<AliasTagSet> tagSet;
                tagSet = alias->getAliasTags(ref);
                OA_ptr<AliasTagIterator> tagIter;
                tagIter = tagSet->getIterator();
                for(; tagIter->isValid(); ++(*tagIter)) {
                    mStmt2MayUseMap[stmt].insert(tagIter->current());
                }
            }
        }
    } {

        // maycode for uses[s]
        OA_ptr<IRStmtIterator> stmtIter;
        stmtIter = mIR->getStmtIterator(proc);
        for(; stmtIter->isValid(); ++(*stmtIter)) {
            StmtHandle stmt = stmtIter->current();

            OA_ptr<MemRefHandleIterator> usesIter;
            usesIter= mIR->getUseMemRefs(stmt);
            for (; usesIter->isValid(); (*usesIter)++) {
                MemRefHandle ref = usesIter->current();
                
                OA_ptr<AliasTagSet> tagSet;
                tagSet = alias->getAliasTags(ref);
                if(tagSet->isMust()) {
                    OA_ptr<AliasTagIterator> tagIter;
                    tagIter = tagSet->getIterator();
                    for(; tagIter->isValid(); ++(*tagIter)) {
                        mStmt2MustUseMap[stmt].insert(tagIter->current());
                    }
                }
            }
        }
    }
    {
} {
}

this->mayUseful = &mayUseful;
this->mayVary = &mayVary;

    // use the dataflow solver to get the In and Out sets for the
    // basic blocks (BBs).
    mSolver->solve(cfg, ITERATIVE);

    // get exit node for CFG and determine what data flow values exit it.
    // store these data flow values in the result's exit information.
    OA_ptr<NodeInterface> node;
    node = cfg->getExit();
    OA_ptr<DataFlowSet> x = mSolver->getOutSet(node);
    OA_ptr<ActivityDFSet> exitSet =
        x.convert<ActivityDFSet>();
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > i;
    i = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (exitSet);
    for(; i->isValid(); (*i)++)
    {
        mActivityMap->insertExit(i->current());
    }


    return mActivityMap;
}



OA_ptr<DataFlowSet> ManagerActivity::initializeTop()
{
    OA_ptr<ActivityDFSet> retval;
    retval = new ActivityDFSet();
    return retval;
}


OA_ptr<DataFlowSet> ManagerActivity::initializeBottom()
{
    OA_ptr<ActivityDFSet> retval;
    retval = new ActivityDFSet();
    return retval;
}


OA_ptr<DataFlowSet>
ManagerActivity::initializeNodeIN(OA_ptr<NodeInterface> n)
{
    OA_ptr<ActivityDFSet> retval;
    retval = new ActivityDFSet();

    #if 1
        OA_ptr<NodeStatementsIteratorInterface> iter;
        iter = n->getNodeStatementsIterator();
        for(; iter->isValid(); ++(*iter)) {
            StmtHandle stmt = iter->current();
        }
    #endif

    return retval;
}


OA_ptr<DataFlowSet>
ManagerActivity::initializeNodeOUT(OA_ptr<NodeInterface> n)
{
    OA_ptr<ActivityDFSet> retval;
    retval = new ActivityDFSet();

    #if 0
        OA_ptr<NodeStatementsIteratorInterface> iter;
        iter = n->getNodeStatementsIterator();
        for(; iter->isValid(); ++(*iter)) {
            StmtHandle stmt = iter->current();
        }
    #endif

    return retval;
}



void ManagerActivity::dumpset(OA_ptr<ActivityDFSet> inSet) {
    Alias::Interface& aliasResults = *mAlias;
    std::ostream& os = std::cout;

    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > iter;
    iter = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (
        inSet);
    for ( ; iter->isValid(); (*iter)++) {
        if(!iter->isFirst()) {
            cout << ",";
        }
        iter->current().dump(os, *mIR, aliasResults);
    }
    cout << endl;
}


OA_ptr<DataFlowSet>
ManagerActivity::meet(
    OA_ptr<DataFlowSet> set1orig,
    OA_ptr<DataFlowSet> set2orig)
{
    // convert the incoming sets to sets of the specific flow value.
    OA_ptr<ActivityDFSet> set1 = set1orig.convert<ActivityDFSet>();
    OA_ptr<ActivityDFSet> set2 = set2orig.convert<ActivityDFSet>();

    if (debug) {
        cout << "ManagerActivity::meet" << endl;
        cout << "\tset1 = ";
        dumpset(set1);
        cout << "\tset2 = ";
        dumpset(set2);
    }

    // perform the meet operator on the left hand set.  It's okay to modify the
    // set and return it as a result [since the solver passes a temporary set
    // in as set1.  See the CFGDFProblem header for more info.
    set1->unionEqu(*set2);

    if (debug) {
        cout << endl << "\tcalculated set = ";
        dumpset(set1);
    }

    return set1;
}

OA_ptr<DataFlowSet> ManagerActivity::genSet(
    StmtHandle stmt, OA_ptr<DataFlowSet> xdfset)
{
    OA_ptr<ActivityDFSet> x;
    x = xdfset.convert<ActivityDFSet>();

    OA_ptr<ActivityDFSet> genSet;
    genSet =  new ActivityDFSet();

    // Generate GEN code:
    OA_ptr<ActivityDFSet> set1;
    set1 = new ActivityDFSet((*mayVary)[stmt]);
    OA_ptr<ActivityDFSet> set2;
    set2 = new ActivityDFSet((*mayUseful)[stmt]);
    OA_ptr<ActivityDFSet> set3;
    set3 = set1;
    set3->intersectEqu(*set2);
    genSet = set3;

    return genSet;
}

OA_ptr<DataFlowSet> ManagerActivity::killSet(
    StmtHandle stmt, OA_ptr<DataFlowSet> xdfset)
{
    OA_ptr<ActivityDFSet> x;
    x = xdfset.convert<ActivityDFSet>();

    OA_ptr<ActivityDFSet> killSet;
    killSet = new ActivityDFSet();

    // Generate KILL code:
    OA_ptr<ActivityDFSet> set4;
    set4 = new ActivityDFSet();
    killSet = set4;

    return killSet;
}

// Currently the transfer function used by DFAGen is assumed to be:
// Y = gen[n] U (X - kill[n]).
OA_ptr<DataFlowSet>
ManagerActivity::transfer(
    OA_ptr<DataFlowSet> xdfset,
    StmtHandle stmt)
{
    OA_ptr<ActivityDFSet> xdfgenset;
    xdfgenset = xdfset.convert<ActivityDFSet>();

    OA_ptr<ActivityDFSet> x;
    x = new ActivityDFSet(*xdfgenset);

    // if debug mode is on print information about transfer function
    if (debug) {
        cout << "In transfer: " << endl;
        cout << "\t Stmt  = " << mIR->toString(stmt) << endl;
        cout << "\t X     = ";
        dumpset(x);
    }

    OA_ptr<DataFlowSet> genBaseObj = genSet(stmt, x);
    OA_ptr<ActivityDFSet> gen = genBaseObj.convert<ActivityDFSet>();

    OA_ptr<DataFlowSet> killBaseObj = killSet(stmt, x);
    OA_ptr<ActivityDFSet> kill = killBaseObj.convert<ActivityDFSet>();


    // Add gen[n] to Y
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > genIter;
    genIter = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (gen);
    for(; genIter->isValid(); ++(*genIter)) {
        Alias::AliasTag  genVal;
        genVal = genIter->current();
        mActivityMap->insert(stmt, genVal);
    }
    // Add X - kill[n] to Y
    x->minusEqu(*kill);
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > xIter;
    xIter = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (x);
    for(; xIter->isValid(); ++(*xIter)) {
        Alias::AliasTag  xVal;
        xVal = xIter->current();
        mActivityMap->insert(stmt, xVal);
    }

    // if debug mode is on print information about transfer function
    if(debug) {
        cout << "\t gen  = ";
        dumpset(gen);
        cout << "\t kill = ";
        dumpset(kill);
        cout << "\t Y    = ";
        dumpset(mActivityMap->getActivitySet(stmt));
    }

    return mActivityMap->getActivitySet(stmt);
}

  } // end of namespace Activity
} // end of namespace OA
