/* Activity.hpp
   NOTE: This file was automatically generated by DFAGen.  It is the interface
         for the Activity analysis results.
*/

#ifndef Activity_hpp
#define Activity_hpp

#include <cassert>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/IRInterface/auto_ActivityIRInterface.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/GenOutputTool.hpp>
#include <OpenAnalysis/Alias/AliasTag.hpp>
#include <OpenAnalysis/ExprTree/ExprTree.hpp>
#include <OpenAnalysis/DataFlow/DataFlowSetImpl.hpp>
#include <OpenAnalysis/DataFlow/DFSetBitImpl.hpp>
#include <OpenAnalysis/DataFlow/IRHandleDataFlowSet.hpp>
#include <OpenAnalysis/Utils/Util.hpp>

namespace OA {
  namespace Activity {

typedef DataFlow::DataFlowSetImpl<Alias::AliasTag >  ActivityDFSet;

class Activity : public virtual Annotation {
  public:
    //*****************************************************************
    // Construction methods
    //*****************************************************************
    Activity(ProcHandle p, OA_ptr<ActivityIRInterface> _ir) {
        mIR = _ir;
        mExitActivity = new ActivityDFSet();
    }
    ~Activity() {}


    //*****************************************************************
    // Query methods
    //*****************************************************************
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > getActivityIterator(StmtHandle s) const;

    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > getExitActivityIterator() const;

    OA_ptr<ActivityDFSet> getActivitySet(StmtHandle s) {
        map<StmtHandle, OA_ptr<ActivityDFSet> >::iterator element =
            mActivity.find(s);

        if(element == mActivity.end()) {
            mActivity[s] = new ActivityDFSet();
            element = mActivity.find(s);
        }

        return (*element).second;
    }


    //*****************************************************************
    // Modifier methods
    //*****************************************************************
    void insert(StmtHandle s, Alias::AliasTag  val) {
        if(mActivity[s].ptrEqual(0)) {
            mActivity[s] = new ActivityDFSet();
        }
        mActivity[s]->insert(val);
    }

    void insertExit(Alias::AliasTag  val) {
        mExitActivity->insert(val);
    }


    //*****************************************************************
    // Output
    //*****************************************************************
    void output(IRHandlesIRInterface& pIR) const;

    void dump(std::ostream& os,
        OA_ptr<IRHandlesIRInterface> ir,
        Alias::Interface& aliasResults) const;



  private:
    map<StmtHandle, OA_ptr<ActivityDFSet> > mActivity;
    OA_ptr<ActivityDFSet>  mExitActivity;
    OA_ptr<ActivityIRInterface> mIR;
};

  } // end of Liveness namespace
} // end of OA namespace

#endif

