/* Activity.cpp
   NOTE: This file was automatically generated by DFAGen.  It is the
         implementation of the class for Activity analysis results.
*/


#include "auto_Activity.hpp"

namespace OA {
  namespace Activity {


OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > Activity::getActivityIterator(StmtHandle s) const {
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > retval;

    if(mActivity.find(s) == mActivity.end()) {
        retval = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > ();
    } else {
        retval = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (
            mActivity.find(s)->second);
    }

    return retval;
}


OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > Activity::getExitActivityIterator() const {
    OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > retval;

    retval = new DataFlow::DataFlowSetImplIterator<Alias::AliasTag > (mExitActivity);
    return retval;
}


void Activity::output(IRHandlesIRInterface& ir) const {
    sOutBuild->objStart("Activity");

    sOutBuild->mapStart("mActivity", "StmtHandle", "OA_ptr<ActivityDFSet>");

    std::map<StmtHandle,OA_ptr<ActivityDFSet> >::const_iterator mapIter;
    for (mapIter = mActivity.begin(); mapIter != mActivity.end(); mapIter++) {
        StmtHandle s = mapIter->first;
        OA_ptr<ActivityDFSet> rdset = mapIter->second;
        if ( rdset.ptrEqual(0) ) continue;

        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();
        sOutBuild->outputIRHandle(s, ir);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart();


        sOutBuild->listStart();
        OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > setIter;
        setIter = getActivityIterator(s);
        for ( ; setIter->isValid(); (*setIter)++ ) {
             sOutBuild->listItemStart();
             setIter->current().output(ir);
             sOutBuild->listItemEnd();
        }
        sOutBuild->listEnd();
        sOutBuild->mapValueEnd();
        sOutBuild->mapEntryEnd();
    }
    sOutBuild->mapEnd("mActivity");
    sOutBuild->objEnd("Activity");
}


void Activity::dump(
    std::ostream& os,
    OA_ptr<IRHandlesIRInterface> ir,
    Alias::Interface& aliasResults) const
{
    os << "Activity Analysis results." << endl;
    std::map<StmtHandle, OA_ptr<ActivityDFSet> >::const_iterator mapIter;

    for (mapIter = mActivity.begin(); mapIter != mActivity.end(); mapIter++) {
        os << "\tstmt = " << ir->toString(mapIter->first) << std::endl;
        OA_ptr<DataFlow::DataFlowSetImplIterator<Alias::AliasTag > > iter;
        iter = getActivityIterator(mapIter->first);

        for ( ; iter->isValid(); (*iter)++) {
            os << "\t\t";
        iter->current().dump(os, *mIR, aliasResults);
            os << std::endl;
        }
    }
}


  } // end of Activity namespace
} // end of OA namespace
