/*! \file
  
  \brief Represents a wrapper for StmtHandle + CallContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef StmtHwContext_H
#define StmtHwContext_H

#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/OutputBuilder.hpp>
#include <OpenAnalysis/Alias/CallContext.hpp>
#include <OpenAnalysis/Alias/Interface.hpp>

namespace OA {
  namespace Alias {

class StmtHwContext : public Annotation {
public:
  StmtHwContext(StmtHandle stmt, OA_ptr<CallContext> cc);
  StmtHwContext(OA_ptr<StmtHwContext> other);
  ~StmtHwContext();

  StmtHandle getStmt();
  OA_ptr<CallContext> getCallContext();

  bool operator ==(const StmtHwContext& other) const;

  bool operator <(const StmtHwContext& other) const;
  
  OA_ptr<StmtHwContext> clone();

  StmtHwContext& operator=( StmtHwContext& other);

  // ************************************************************
  //  Output
  // ************************************************************
  virtual void output(OA::IRHandlesIRInterface& ir) const;

  virtual void output(OA::IRHandlesIRInterface& ir,
		      const Alias::Interface& aliasResults) const;

  void dump(std::ostream& os,
	    IRHandlesIRInterface& ir);

private:
  StmtHandle mStmtH;
  OA_ptr<CallContext> mCallContext;

}; // end of StmtHwContext


  } // end of Alias namespace
} // end of OA namespace

#endif
