/*! \file
  
  \brief Implementation of StmtHwContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#include "StmtHwContext.hpp"

namespace OA {
  namespace Alias {


// *******************************************************
// Beginning of StmtHwContext code
// *******************************************************


StmtHwContext::StmtHwContext(StmtHandle stmt, OA_ptr<CallContext> cc)
{
  mStmtH = stmt;
  mCallContext = cc;
}

StmtHwContext::StmtHwContext(OA_ptr<StmtHwContext> other)
{
  mStmtH = other->mStmtH;
  mCallContext = other->mCallContext;

  // to clone or not to clone ... =)
  /*
  mStmtH = other->mStmtH;
  mCallContext = (other->mCallContext)->clone();
  */
}

StmtHwContext::~StmtHwContext()
{

}

StmtHandle StmtHwContext::getStmt()
{
  return mStmtH;
}

OA_ptr<CallContext> StmtHwContext::getCallContext()
{
  return mCallContext;
}

bool StmtHwContext::operator ==(const StmtHwContext& other) const
{
  if (mStmtH == other.mStmtH) { 
    // do I need to deref the callContexts?
    if ((*mCallContext)==(*(other.mCallContext))) {
      return true;
    }
  }
  return false;
}
  
bool StmtHwContext::operator <(const StmtHwContext& other) const
{
  if (mStmtH < other.mStmtH) {
    return true;
  } 
  else if (mStmtH == other.mStmtH) {
    if ((*mCallContext) < (*(other.mCallContext))) {
      return true;
    } 
  }
  return false; 
}

OA_ptr<StmtHwContext> StmtHwContext::clone()
{
  OA_ptr<StmtHwContext> result;
  result = new StmtHwContext(mStmtH, mCallContext->clone());
  return result;
}

StmtHwContext& StmtHwContext::operator=( StmtHwContext& other)
{
  // This copies, not clones.  
  mStmtH = other.mStmtH;
  mCallContext = other.mCallContext;
  return *this;
}

void StmtHwContext::output(OA::IRHandlesIRInterface& ir) const
{
  sOutBuild->objStart("StmtHwContext");
  sOutBuild->fieldStart("mStmtH");
  sOutBuild->outputIRHandle(mStmtH, ir);
  sOutBuild->fieldEnd("mStmtH");
  sOutBuild->fieldStart("mCallContext");
  mCallContext->output(ir);
  sOutBuild->fieldEnd("mCallContext");
  sOutBuild->objEnd("StmtHwContext");
}

void StmtHwContext::output(OA::IRHandlesIRInterface& ir,
                           const Alias::Interface& aliasResults) const
{
  output(ir);
}

void StmtHwContext::dump(std::ostream& os,
                         IRHandlesIRInterface& ir)
{
  os << "[ StmtHwContext: \n";
  os << ir.toString(mStmtH);
  mCallContext->dump(os,ir);
  os << "\n]";
}

  } // end of Alias namespace
} // end of OA namespace
