/*! \file
  
  \brief Represents a wrapper for ProcHandle + CallContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef ProcHwContext_H
#define ProcHwContext_H

#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/OutputBuilder.hpp>
#include <OpenAnalysis/Alias/CallContext.hpp>
#include <OpenAnalysis/Alias/Interface.hpp>

namespace OA {
  namespace Alias {

class ProcHwContext : public Annotation {
public:
  ProcHwContext(ProcHandle proc, OA_ptr<CallContext> cc);
  ProcHwContext(OA_ptr<ProcHwContext> other);
  ~ProcHwContext();

  ProcHandle getProc();
  OA_ptr<CallContext> getCallContext();

  bool operator ==(const ProcHwContext& other) const;

  bool operator <(const ProcHwContext& other) const;
  
  OA_ptr<ProcHwContext> clone();

  ProcHwContext& operator=( ProcHwContext& other);

  // ************************************************************
  //  Output
  // ************************************************************
  virtual void output(OA::IRHandlesIRInterface& ir) const;

  virtual void output(OA::IRHandlesIRInterface& ir,
		      const Alias::Interface& aliasResults) const;

  void dump(std::ostream& os,
	    IRHandlesIRInterface& ir);

private:
  ProcHandle mProcH;
  OA_ptr<CallContext> mCallContext;

}; // end of ProcHwContext


  } // end of Alias namespace
} // end of OA namespace

#endif
