/*! \file
  
  \brief Implementation of ProcHwContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#include "ProcHwContext.hpp"

namespace OA {
  namespace Alias {


// *******************************************************
// Beginning of ProcHwContext code
// *******************************************************


ProcHwContext::ProcHwContext(ProcHandle proc, OA_ptr<CallContext> cc)
{
  mProcH = proc;
  mCallContext = cc;
}

ProcHwContext::ProcHwContext(OA_ptr<ProcHwContext> other)
{
  mProcH = other->mProcH;
  mCallContext = other->mCallContext;

  // to clone or not to clone ... =)
  /*
  mProcH = other->mProcH;
  mCallContext = (other->mCallContext)->clone();
  */
}

ProcHwContext::~ProcHwContext()
{

}

ProcHandle ProcHwContext::getProc()
{
  return mProcH;
}

OA_ptr<CallContext> ProcHwContext::getCallContext()
{
  return mCallContext;
}

bool ProcHwContext::operator ==(const ProcHwContext& other) const
{
  if (mProcH == other.mProcH) { 
    // do I need to deref the callContexts?
    if ((*mCallContext)==(*(other.mCallContext))) {
      return true;
    }
  }
  return false;
}
  
bool ProcHwContext::operator <(const ProcHwContext& other) const
{
  if (mProcH < other.mProcH) {
    return true;
  } 
  else if (mProcH == other.mProcH) {
    if ((*mCallContext) < (*(other.mCallContext))) {
      return true;
    } 
  }
  return false; 
}

OA_ptr<ProcHwContext> ProcHwContext::clone()
{
  OA_ptr<ProcHwContext> result;
  result = new ProcHwContext(mProcH, mCallContext->clone());
  return result;
}

ProcHwContext& ProcHwContext::operator=( ProcHwContext& other)
{
  // This copies, not clones.  
  mProcH = other.mProcH;
  mCallContext = other.mCallContext;
  return *this;
}

void ProcHwContext::output(OA::IRHandlesIRInterface& ir) const
{
  sOutBuild->objStart("ProcHwContext");
  sOutBuild->fieldStart("mProcH");
  sOutBuild->outputIRHandle(mProcH, ir);
  sOutBuild->fieldEnd("mProcH");
  sOutBuild->fieldStart("mCallContext");
  mCallContext->output(ir);
  sOutBuild->fieldEnd("mCallContext");
  sOutBuild->objEnd("ProcHwContext");
}

void ProcHwContext::output(OA::IRHandlesIRInterface& ir,
                           const Alias::Interface& aliasResults) const
{
  output(ir);
}

void ProcHwContext::dump(std::ostream& os,
                         IRHandlesIRInterface& ir)
{
  os << "[ ProcHwContext: \n";
  os << ir.toString(mProcH);
  mCallContext->dump(os,ir);
  os << "\n]";
}

  } // end of Alias namespace
} // end of OA namespace
