/*! \file
  
  \brief Declarations of a Visitor over memory reference
   expressions that determines if there is some kind of 
   RefOp performed and if so creates a version of the outermost 
   RefOp that does not point to the underlying MemRefExpr.
   For example, if mre is Deref(NamedRef(a)) then 
   getOuterRefOp will return a Deref().

  \authors Michelle Strout, Brian White

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef OuterRefOpVisitor_H
#define OuterRefOpVisitor_H

//--------------------------------------------------------------------
#include <OpenAnalysis/Utils/UnionFindUniverse.hpp>
#include <OpenAnalysis/MemRefExpr/MemRefExprVisitor.hpp>

namespace OA {
  namespace Alias {

class OuterRefOpVisitor : public virtual MemRefExprVisitor {
  public:
  OuterRefOpVisitor();
  ~OuterRefOpVisitor();

  OA_ptr<RefOp> getOuterRefOp();

  void visitNamedRef(NamedRef& ref);
  void visitUnnamedRef(UnnamedRef& ref);
  void visitUnknownRef(UnknownRef& ref);
  void visitAddressOf(AddressOf& ref);
  void visitDeref(Deref& ref);

  // default handling of more specific SubSet specificiations
  void visitSubSetRef(SubSetRef& ref);
  void visitIdxAccess(IdxAccess& ref);

  void visitFieldAccess(FieldAccess& ref);
  
  private:
    OA_ptr<RefOp> mOuterRefOp;
};

  }
}

#endif // OuterRefOpVisitor_H
