/*! \file
  
  \brief Declarations of the AnnotationManager that generates AliasTag
         results from CSFIAlias.

  \authors Michelle Strout, Brian White, Barbara Kreaseck

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef ManagerCSFIAliasAliasTag_H
#define ManagerCSFIAliasAliasTag_H

//--------------------------------------------------------------------

// OpenAnalysis headers
#include <OpenAnalysis/Alias/ManagerCSFIAlias.hpp>
#include <OpenAnalysis/Alias/CSFIAliasTagResults.hpp>
#include <map>

namespace OA {
  namespace Alias {

/*! 
*/
class ManagerCSFIAliasAliasTag : public ManagerCSFIAlias 
{ 
public:
  ManagerCSFIAliasAliasTag(OA_ptr<AliasIRInterface> _ir);
  ~ManagerCSFIAliasAliasTag () {}

  //! Perform the inter-procedural FIAlias analysis.
  OA_ptr<Alias::Interface> 
  performAnalysis(OA_ptr<CallGraph::CallGraphInterface> callGraph,
                  OA_ptr<Alias::CCSetPerProc> ccResults,
                  FIAliasImplement implement = ALL_PROCS );

private:

  //! given the union-find datastructure that groups together MREs
  //! create the AliasTagResults datastructure
  void buildAliasMaps( OA_ptr<UnionFindUniverse> ufset );

};

  } // end of Alias namespace
} // end of OA namespace

#endif
