/*! \file
  
  \brief Represents a wrapper for MemRefHandle + CallContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef MRHwContext_H
#define MRHwContext_H

#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/OutputBuilder.hpp>
#include <OpenAnalysis/MemRefExpr/MemRefExpr.hpp>
#include "CallContext.hpp"

namespace OA {
  namespace Alias {

class MRHwContext : public Annotation {
public:
  MRHwContext(MemRefHandle mrh, OA_ptr<CallContext> cc);
  MRHwContext(OA_ptr<MRHwContext> other);
  ~MRHwContext();

  MemRefHandle getMRH();
  OA_ptr<CallContext> getCallContext();

  bool operator ==(const MRHwContext& other) const;

  bool operator <(const MRHwContext& other) const;
  
  OA_ptr<MRHwContext> clone();

  MRHwContext& operator=( MRHwContext& other);

  // ************************************************************
  //  Output
  // ************************************************************
  virtual void output(OA::IRHandlesIRInterface& ir) const;

  virtual void output(OA::IRHandlesIRInterface& ir,
		      const Alias::Interface& aliasResults) const;

  void dump(std::ostream& os,
	    IRHandlesIRInterface& ir,
	    Interface& aliasResults);

private:
  MemRefHandle mMRH;
  OA_ptr<CallContext> mCallContext;

}; // end of MRHwContext


  }
}

#endif
