/*! \file
  
  \brief Implementation of CallHwContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#include "CallHwContext.hpp"

namespace OA {
  namespace Alias {


// *******************************************************
// Beginning of CallHwContext code
// *******************************************************


CallHwContext::CallHwContext(CallHandle call, OA_ptr<CallContext> cc)
{
  mCallH = call;
  mCallContext = cc;
}

CallHwContext::CallHwContext(OA_ptr<CallHwContext> other)
{
  mCallH = other->mCallH;
  mCallContext = other->mCallContext;

  // to clone or not to clone ... =)
  /*
  mCallH = other->mCallH;
  mCallContext = (other->mCallContext)->clone();
  */
}

CallHwContext::~CallHwContext()
{

}

CallHandle CallHwContext::getCall()
{
  return mCallH;
}

OA_ptr<CallContext> CallHwContext::getCallContext()
{
  return mCallContext;
}

bool CallHwContext::operator ==(const CallHwContext& other) const
{
  if (mCallH == other.mCallH) { 
    // do I need to deref the callContexts?
    if ((*mCallContext)==(*(other.mCallContext))) {
      return true;
    }
  }
  return false;
}
  
bool CallHwContext::operator <(const CallHwContext& other) const
{
  if (mCallH < other.mCallH) {
    return true;
  } 
  else if (mCallH == other.mCallH) {
    if ((*mCallContext) < (*(other.mCallContext))) {
      return true;
    } 
  }
  return false; 
}

OA_ptr<CallHwContext> CallHwContext::clone()
{
  OA_ptr<CallHwContext> result;
  result = new CallHwContext(mCallH, mCallContext->clone());
  return result;
}

CallHwContext& CallHwContext::operator=( CallHwContext& other)
{
  // This copies, not clones.  
  mCallH = other.mCallH;
  mCallContext = other.mCallContext;
  return *this;
}

void CallHwContext::output(OA::IRHandlesIRInterface& ir) const
{
  sOutBuild->objStart("CallHwContext");
  sOutBuild->fieldStart("mCallH");
  sOutBuild->outputIRHandle(mCallH, ir);
  sOutBuild->fieldEnd("mCallH");
  sOutBuild->fieldStart("mCallContext");
  mCallContext->output(ir);
  sOutBuild->fieldEnd("mCallContext");
  sOutBuild->objEnd("CallHwContext");
}

void CallHwContext::output(OA::IRHandlesIRInterface& ir,
                           const Alias::Interface& aliasResults) const
{
  output(ir);
}

void CallHwContext::dump(std::ostream& os,
                         IRHandlesIRInterface& ir)
{
  os << "[ CallHwContext: \n";
  os << ir.toString(mCallH);
  mCallContext->dump(os,ir);
  os << "\n]";
}

  } // end of Alias namespace
} // end of OA namespace
