//     This file has been modified from its original GenOutputTool version
//     specifically:
//          - AliasTag objects are now being passed a pointer to this results (this)
//          - Now uses MREwContext rather than MemRefExpr
//          - Now uses MRHwContext rather than MemRefHandle

#include "CSFIAliasTagResults.hpp"

namespace OA { 
    namespace Alias { 

void CSFIAliasTagResults::output(OA::IRHandlesIRInterface &ir) const
{
    sOutBuild->objStart("CSFIAliasTagResults");
    sOutBuild->mapStart("mMREwCToTags", "MREwContext ", "OA::OA_ptr<AliasTagSet> ");
    std::map<MREwContext , OA::OA_ptr<AliasTagSet> >::const_iterator reg_mMREwCToTags_iterator;
    for(reg_mMREwCToTags_iterator = mMREwCToTags.begin();
        reg_mMREwCToTags_iterator != mMREwCToTags.end();
        reg_mMREwCToTags_iterator++)
    {
        const MREwContext &mrewc = reg_mMREwCToTags_iterator->first;
        const OA::OA_ptr<AliasTagSet>  &second = reg_mMREwCToTags_iterator->second;
        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();	
        mrewc.output(ir);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart();
        second->output(ir);
        //sOutBuild->listStart();
        //std::set<AliasTag>::const_iterator reg_second_iterator;
        //for(reg_second_iterator  = second->begin();
        //    reg_second_iterator != second->end();
        //    reg_second_iterator++)
       // {
        //    AliasTag item = *reg_second_iterator;
        //    sOutBuild->listItemStart();
        //    item.output(ir, *this);
        //    sOutBuild->listItemEnd();
       // }
        //sOutBuild->listEnd();
        sOutBuild->mapValueEnd();
        sOutBuild->mapEntryEnd();
    }
    sOutBuild->mapEnd("mMREwCToTags");

    sOutBuild->mapStart("mTagToMREwCs", "AliasTag", "OA::OA_ptr<std::set<MREwContext> > ");
    std::map<AliasTag, OA::OA_ptr<std::set<MREwContext> > >::const_iterator reg_mTagToMREwCs_iterator;
    for(reg_mTagToMREwCs_iterator = mTagToMREwCs.begin();
        reg_mTagToMREwCs_iterator != mTagToMREwCs.end();
        reg_mTagToMREwCs_iterator++)
    {
        AliasTag first = reg_mTagToMREwCs_iterator->first;
        OA::OA_ptr<std::set<MREwContext> >  second = reg_mTagToMREwCs_iterator->second;
        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();
        first.output(ir, *this);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart();
        sOutBuild->listStart();
        std::set<MREwContext>::const_iterator reg_second_iterator;
        for(reg_second_iterator  = second->begin();
            reg_second_iterator != second->end();
            reg_second_iterator++)
        {
            MREwContext  item = *reg_second_iterator;
            sOutBuild->listItemStart();
            item.output(ir);
            sOutBuild->listItemEnd();
        }
        sOutBuild->listEnd();
        sOutBuild->mapValueEnd();
        sOutBuild->mapEntryEnd();
    }
    sOutBuild->mapEnd("mTagToMREwCs");

    sOutBuild->mapStart("mMemRefwCToTags", "MRHwContext", "OA::OA_ptr<AliasTagSet> ");
    std::map<MRHwContext, OA::OA_ptr<AliasTagSet> >::const_iterator reg_mMemRefwCToTags_iterator;
    for(reg_mMemRefwCToTags_iterator = mMemRefwCToTags.begin();
        reg_mMemRefwCToTags_iterator != mMemRefwCToTags.end();
        reg_mMemRefwCToTags_iterator++)
    {
        const MRHwContext &first = reg_mMemRefwCToTags_iterator->first;
        const OA::OA_ptr<AliasTagSet>  &second = reg_mMemRefwCToTags_iterator->second;
        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();
        first.output(ir);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart();
        second->output(ir);
        //sOutBuild->listStart();
        //std::set<AliasTag>::const_iterator reg_second_iterator;
        //for(reg_second_iterator  = second->begin();
        //    reg_second_iterator != second->end();
        //    reg_second_iterator++)
       // {
        //    AliasTag item = *reg_second_iterator;
        //    sOutBuild->listItemStart();
        //    item.output(ir, *this);
        //    sOutBuild->listItemEnd();
       // }
        //sOutBuild->listEnd();
        sOutBuild->mapValueEnd();
        sOutBuild->mapEntryEnd();
    }
    sOutBuild->mapEnd("mMemRefwCToTags");

    sOutBuild->mapStart("mMREwCToMustFlag", "MREwContext", "bool");
    std::map<MREwContext , bool>::const_iterator reg_mMREwCToMustFlag_iterator;
    for(reg_mMREwCToMustFlag_iterator = mMREwCToMustFlag.begin();
        reg_mMREwCToMustFlag_iterator != mMREwCToMustFlag.end();
        reg_mMREwCToMustFlag_iterator++)
    {
        const MREwContext  &first = reg_mMREwCToMustFlag_iterator->first;
        bool second = reg_mMREwCToMustFlag_iterator->second;
        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();
        first.output(ir);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValue(bool2string(second));
        sOutBuild->mapEntryEnd();
    }
    sOutBuild->mapEnd("mMREwCToMustFlag");

    sOutBuild->mapStart("mMemRefwCToMustFlag", "MRHwContext", "bool");
    std::map<MRHwContext, bool>::const_iterator reg_mMemRefwCToMustFlag_iterator;
    for(reg_mMemRefwCToMustFlag_iterator = mMemRefwCToMustFlag.begin();
        reg_mMemRefwCToMustFlag_iterator != mMemRefwCToMustFlag.end();
        reg_mMemRefwCToMustFlag_iterator++)
    {
        MRHwContext first = reg_mMemRefwCToMustFlag_iterator->first;
        bool second = reg_mMemRefwCToMustFlag_iterator->second;
        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();
        first.output(ir);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValue(bool2string(second));
        sOutBuild->mapEntryEnd();
    }
    sOutBuild->mapEnd("mMemRefwCToMustFlag");

    sOutBuild->mapStart("mMREToCCSet","MemRefExpr","CallContextSet");
    std::map<OA_ptr<MemRefExpr>, OA_ptr<CallContextSet> >::const_iterator iter;
    for (iter = mMREToCCSet.begin();
         iter != mMREToCCSet.end();
         iter++)
      {
        OA_ptr<MemRefExpr> mre = iter->first;
        OA_ptr<CallContextSet> ccSet = iter->second;
        sOutBuild->mapEntryStart();
        sOutBuild->mapKeyStart();
        mre->output(ir);
        sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart();
        ccSet->output(ir);
        sOutBuild->mapValueEnd();
        sOutBuild->mapEntryEnd();
      }
    sOutBuild->mapEnd("mMREToCCSet");

    sOutBuild->objEnd("CSFIAliasTagResults");
}


    } // end of Alias namespace
} // end of OA namespace
