/*! \file
  
  \brief Maps ProcHandles to CallContextSet

  \authors Barbara Kreaseck

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef CCSetPerProc_hpp
#define CCSetPerProc_hpp

#include <cassert>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Alias/CallContextSet.hpp>

namespace OA {
  namespace Alias {
    
    
    
    class CCSetPerProc : public virtual Annotation {
    public:
      CCSetPerProc();
      ~CCSetPerProc() {}
      
      //! =========== For Procedures ==============
      
      //! returns an iterator over a set of CallContexts for given proc
      OA_ptr<CallContextSetIterator> getCallContextSet(ProcHandle proc);

      //! return size of CallContextSet for given proc
      int getCCSetSize(ProcHandle proc);
      
      //! returns the number of call contexts for entire call graph
      int getNumCallContexts();
      
      // *****************************************************************
      // Construction methods 
      // *****************************************************************
      
      //! ========= For the Procedure =============
      
      //! set the InActive set for the statement
      void recordCallContextSet(ProcHandle proc, 
                                OA_ptr<CallContextSet> ccset);
      
      
      //! set number of call contexts for entire call graph
      void setNumCCs(int n);
      
      // *****************************************************************
      // Annotation Interface
      // *****************************************************************
      void output(IRHandlesIRInterface &ir) const;
      
      // *****************************************************************
      // Output
      // *****************************************************************
      
      //! incomplete output of info for debugging
      void dump(std::ostream& os, IRHandlesIRInterface &ir);
      
    private:
      // data members
      std::map<ProcHandle, OA_ptr<CallContextSet> > mProcToCCSet;
      int mNumCCs;
    };
    
  } // end of Alias namespace
} // end of OA namespace

#endif

