/*! \file
  
  \brief Implementation of Activity::CSUseful

  \author Michelle Strout, Barbara Kreaseck

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#include <OpenAnalysis/Activity/CSUseful.hpp>

using namespace std;

namespace OA {
  namespace Activity {

CSUseful::CSUseful(ProcHandle p)
{ 
    // initially mDepTagSet just points to null
    // don't want to make empty set because then have to know max size
    // FIXME: see insertDepTag for how we get maxTag
    
    mNumIter = 0;
}

/*
OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> >
 CSUseful::getDepSetIterator() 
{ 
    OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> > retval;
    retval = new DataFlow::DFSetBitImplIterator<Alias::AliasTag>(mDepTagSet);
    return retval;
}
*/

OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> >
 CSUseful::getInUsefulIterator(StmtHandle s, OA_ptr<Alias::CallContext> cc)
{
    OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> > retval;
    //if (mInUseful[s].ptrEqual(0)) {
    //    mInUseful[s] = new DataFlow::DFSetBitImpl<Alias::AliasTag>();
    //}

    // wrap stmt and cc
    Alias::StmtHwContext shwc(s,cc);

    retval = new DataFlow::DFSetBitImplIterator<Alias::AliasTag>(mInUseful[shwc]);
    return retval;
}

OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> >
 CSUseful::getOutUsefulIterator(StmtHandle s, OA_ptr<Alias::CallContext> cc)
{
    OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> > retval;
    //if (mOutUseful[s].ptrEqual(0)) {
    //    mOutUseful[s] = new DataFlow::DFSetBitImpl<Alias::AliasTag>();
    //}

    // wrap stmt and cc
    Alias::StmtHwContext shwc(s,cc);

    retval = new DataFlow::DFSetBitImplIterator<Alias::AliasTag>(mOutUseful[shwc]);
    return retval;
}



OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> >
 CSUseful::getInUsefulIterator(CallHandle c, OA_ptr<Alias::CallContext> cc)
{
    OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> > retval;
    //if (mCallInUseful[c].ptrEqual(0)) {
    //    mCallInUseful[c] = new DataFlow::DFSetBitImpl<Alias::AliasTag>();
    //}

    // wrap call and cc
    Alias::CallHwContext chwc(c,cc);

    retval = new DataFlow::DFSetBitImplIterator<Alias::AliasTag>(mCallInUseful[chwc]);
    return retval;
}

OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> >
 CSUseful::getOutUsefulIterator(CallHandle c, OA_ptr<Alias::CallContext> cc)
{
    OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag> > retval;
    //if (mCallOutUseful[c].ptrEqual(0)) {
    //    mCallOutUseful[c] = new DataFlow::DFSetBitImpl<Alias::AliasTag>();
    //}

    // wrap call and cc
    Alias::CallHwContext chwc(c,cc);

    retval = new DataFlow::DFSetBitImplIterator<Alias::AliasTag>(mCallOutUseful[chwc]);
    return retval;
}


int CSUseful::getNumIter() { 
  return mNumIter; 
}


void CSUseful::copyIntoInUseful(StmtHandle s, OA_ptr<Alias::CallContext> cc,
                                OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > dfset)
{
  OA_ptr<DataFlow::DataFlowSet> cloneDFset = dfset->clone();
  // wrap stmt and cc
  Alias::StmtHwContext shwc(s,cc);

  mInUseful[shwc] = cloneDFset.convert<DataFlow::DFSetBitImpl<Alias::AliasTag> >();
}


void CSUseful::copyIntoOutUseful(StmtHandle s, OA_ptr<Alias::CallContext> cc,
                                 OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > dfset)
{
  OA_ptr<DataFlow::DataFlowSet> cloneDFset = dfset->clone();
  // wrap stmt and cc
  Alias::StmtHwContext shwc(s,cc);

  mOutUseful[shwc] = cloneDFset.convert<DataFlow::DFSetBitImpl<Alias::AliasTag> >();
}


void CSUseful::copyIntoCallInUseful(CallHandle c, OA_ptr<Alias::CallContext> cc,
                                    OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > dfset)
{
  OA_ptr<DataFlow::DataFlowSet> cloneDFset = dfset->clone();
  // wrap call and cc
  Alias::CallHwContext chwc(c,cc);

  mCallInUseful[chwc] = cloneDFset.convert<DataFlow::DFSetBitImpl<Alias::AliasTag> >();
}


void CSUseful::copyIntoCallOutUseful(CallHandle c, OA_ptr<Alias::CallContext> cc,
                                     OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > dfset)
{
  OA_ptr<DataFlow::DataFlowSet> cloneDFset = dfset->clone();
  // wrap call and cc
  Alias::CallHwContext chwc(c,cc);

  mCallOutUseful[chwc] = cloneDFset.convert<DataFlow::DFSetBitImpl<Alias::AliasTag> >();
}


void CSUseful::setNumIter(int n) 
{ 
  mNumIter = n; 
}



//*****************************************************************
// Output 
//*****************************************************************


//! incomplete output of info for debugging
void CSUseful::dump(std::ostream& os, OA_ptr<IRHandlesIRInterface> ir)
{
    os << "=================================== CSUseful" << std::endl;
    //os << "DepSet = " << std::endl;
    //mDepTagSet->dump(os,ir);

    // iterate over all stmts we know about
    std::map<Alias::StmtHwContext, 
             OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > >::iterator mapIter;
    for (mapIter = mInUseful.begin(); mapIter != mInUseful.end(); mapIter++) {
        Alias::StmtHwContext shwc = mapIter->first;
        shwc.dump(os,*ir);
        os << "\tInUseful: " << std::endl;
        mapIter->second->dump(os,ir);
    }

    // iterate over all calls we know about
    std::map<Alias::CallHwContext, 
             OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > >::iterator cIter;
    for (cIter = mCallInUseful.begin(); cIter != mCallInUseful.end(); cIter++) {
        Alias::CallHwContext chwc = cIter->first;
        chwc.dump(os,*ir);
        os << "\tInUseful: " << std::endl;
        cIter->second->dump(os,ir);
    }
}

//*****************************************************************
// Annotation Interface
//*****************************************************************
void CSUseful::output(IRHandlesIRInterface &ir) const
{
  sOutBuild->objStart("mNumIter"); {
    ostringstream oss;
    oss << mNumIter;
    sOutBuild->outputString( oss.str() );
  } sOutBuild->objEnd("mNumIter");

  //sOutBuild->objStart("mDepTagSet"); {
  //  mDepTagSet->output(ir);
  //} sOutBuild->objEnd("mTagLocSet");

  sOutBuild->mapStart("mStmtToUsefulSetsMap","StmtHwContext","UsefulSets"); {
    std::map<Alias::StmtHwContext,
      OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > >::const_iterator
        mapIter;
    for (mapIter = mInUseful.begin(); mapIter != mInUseful.end(); mapIter++) {
      Alias::StmtHwContext shwc = mapIter->first;
      OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > inUsefulSet =
        mapIter->second;
      OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > outUsefulSet =
        mOutUseful.find(shwc)->second;
      // should have a outUseful for every inUseful, but just in case ...
      if (outUsefulSet.ptrEqual(0)) { 
        outUsefulSet = new DataFlow::DFSetBitImpl<Alias::AliasTag>(1); 
      }

      sOutBuild->mapEntryStart(); {
        sOutBuild->mapKeyStart(); {
          shwc.output(ir);
        } sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart(); {
          sOutBuild->fieldStart("InUsefulSet"); {
            inUsefulSet->output(ir);
          } sOutBuild->fieldEnd("InUsefulSet");
          sOutBuild->fieldStart("OutUsefulSet"); {
            outUsefulSet->output(ir);
          } sOutBuild->fieldEnd("OutUsefulSet");
        } sOutBuild->mapValueEnd();
      } sOutBuild->mapEntryEnd();
    }
  } sOutBuild->mapEnd("mStmtToInUsefulSetMap");

  sOutBuild->mapStart("mCallToUsefulSetsMap","CallHwContext","UsefulSets"); {
    std::map<Alias::CallHwContext,
      OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > >::const_iterator
        cIter;
    for (cIter = mCallInUseful.begin(); cIter != mCallInUseful.end(); cIter++) {
      Alias::CallHwContext chwc = cIter->first;
      OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > inUsefulSet =
        cIter->second;
      OA_ptr<DataFlow::DFSetBitImpl<Alias::AliasTag> > outUsefulSet =
        mCallOutUseful.find(chwc)->second;
      // should have a outUseful for every inUseful, but just in case ...
      if (outUsefulSet.ptrEqual(0)) { 
        outUsefulSet = new DataFlow::DFSetBitImpl<Alias::AliasTag>(1); 
      }

      sOutBuild->mapEntryStart(); {
        sOutBuild->mapKeyStart(); {
          chwc.output(ir);
        } sOutBuild->mapKeyEnd();
        sOutBuild->mapValueStart(); {
          sOutBuild->fieldStart("InUsefulSet"); {
            inUsefulSet->output(ir);
          } sOutBuild->fieldEnd("InUsefulSet");
          sOutBuild->fieldStart("OutUsefulSet"); {
            outUsefulSet->output(ir);
          } sOutBuild->fieldEnd("OutUsefulSet");
        } sOutBuild->mapValueEnd();
      } sOutBuild->mapEntryEnd();
    }
  } sOutBuild->mapEnd("mCallToInUsefulSetMap");


}


  } // end of Activity namespace
} // end of OA namespace
