///////////////////////////////////////////////////////////////////////////////
// expr1.hpp
// Contains definition of expr\<\>::operator() overloads.
//
//  Copyright 2008 Eric Niebler. Distributed under the Boost
//  Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_PP_IS_ITERATING
#error Do not include this file directly
#endif

#define N BOOST_PP_ITERATION()

    /// \overload
    ///
    template<BOOST_PP_ENUM_PARAMS(N, typename A)>
    typename result_of::BOOST_PP_CAT(funop, N)<
        expr const
      , default_domain BOOST_PP_ENUM_TRAILING_PARAMS(N, const A)
    >::type const
    operator ()(BOOST_PP_ENUM_BINARY_PARAMS(N, A, const &a)) const
    {
        return result_of::BOOST_PP_CAT(funop, N)<
            expr const
          , default_domain BOOST_PP_ENUM_TRAILING_PARAMS(N, const A)
        >::call(*this BOOST_PP_ENUM_TRAILING_PARAMS(N, a));
    }

    #ifdef BOOST_PROTO_DEFINE_TERMINAL
    /// \overload
    ///
    template<BOOST_PP_ENUM_PARAMS(N, typename A)>
    typename result_of::BOOST_PP_CAT(funop, N)<
        expr
      , default_domain BOOST_PP_ENUM_TRAILING_PARAMS(N, const A)
    >::type const
    operator ()(BOOST_PP_ENUM_BINARY_PARAMS(N, A, const &a))
    {
        return result_of::BOOST_PP_CAT(funop, N)<
            expr
          , default_domain BOOST_PP_ENUM_TRAILING_PARAMS(N, const A)
        >::call(*this BOOST_PP_ENUM_TRAILING_PARAMS(N, a));
    }
    #endif

#undef N
