//  Copyright (c) 2007 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 3>, 360> bessel_j_data = {
      SC_(0.4430477856658399105072021484375e-3), SC_(0.553809732082299888134002685546875e-4), SC_(0.9956156809860747445801192500664050062602e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.69304020144045352935791015625e-4), SC_(0.9957146107589140226790508756099801328105e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.23264062474481761455535888671875e-3), SC_(0.9962489699005580621378590557841736186861e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.4480001516640186309814453125e-3), SC_(0.9965382149919219697926696508657333563376e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.5502865533344447612762451171875e-3), SC_(0.9966289891095531217170976766456612311928e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.19227224402129650115966796875e-2), SC_(0.9971807065952682162692966068389032708599e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.37370622158050537109375e-2), SC_(0.9974717909688313208758556750808530574188e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.47696642577648162841796875e-2), SC_(0.997577426859888822291081757361344556863e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.1275280676782131195068359375e-1), SC_(0.9979773067040365116413896458097958587041e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.20440109074115753173828125e-1), SC_(0.9981222651757299264986454464589469235334e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.3429813683032989501953125e-1), SC_(0.9981619333713874456307490264513905997672e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.96701286733150482177734375e-1), SC_(0.9965812006107194383507063599312965181976e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.159812271595001220703125e0), SC_(0.9927699251072058869431015490774723070186e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.297095477581024169921875e0), SC_(0.9774885373571948238761430963137133013962e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.77344071865081787109375e0), SC_(0.8558678749290511288516105356098172615967e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.1992881298065185546875e1), SC_(0.2283524941992771533363988837045423832888e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.3915013790130615234375e1), SC_(-0.401360440349915932533731778088781472183e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.79858455657958984375e1), SC_(0.1751115157942275375093377805999900633628e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.1571910858154296875e2), SC_(-0.1426234585704966197380052262204215409713e0), 
      SC_(0.4430477856658399105072021484375e-3), SC_(0.31483119964599609375e2), SC_(0.1066310031567526427476684436417433539043e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.553809732082299888134002685546875e-4), SC_(0.9945164185569587230213539870667972875692e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.69304020144045352935791015625e-4), SC_(0.9946400847213057054537534776624837878946e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.23264062474481761455535888671875e-3), SC_(0.9953081108718330939070656828660938331342e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.4480001516640186309814453125e-3), SC_(0.9956697541222540255647650289685550550287e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.5502865533344447612762451171875e-3), SC_(0.9957832579906576456563607224027456916251e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.19227224402129650115966796875e-2), SC_(0.9964733546229106923992847311503904080801e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.37370622158050537109375e-2), SC_(0.9968380173570457415468434756113694340878e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.47696642577648162841796875e-2), SC_(0.9969706788099270079524162776507030382138e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.1275280676782131195068359375e-1), SC_(0.9974795810399399980819372250486803819028e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.20440109074115753173828125e-1), SC_(0.99767689617703742799168249521337668749e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.3429813683032989501953125e-1), SC_(0.997774089399990647214931657780519793888e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.96701286733150482177734375e-1), SC_(0.9963092188861358436843828984354699213759e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.159812271595001220703125e0), SC_(0.9925549713148663125876374807339340488473e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.297095477581024169921875e0), SC_(0.9773461257455259400626571167158074279339e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.77344071865081787109375e0), SC_(0.8558479783471517562239377557029974866496e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.1992881298065185546875e1), SC_(0.2284416118095148413691988171034857034998e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.3915013790130615234375e1), SC_(-0.4013573659865744373419228392808844392131e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.79858455657958984375e1), SC_(0.1751502024658724728242948804818811752031e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.1571910858154296875e2), SC_(-0.1425986283388769556266104448492207320811e0), 
      SC_(0.554432161152362823486328125e-3), SC_(0.31483119964599609375e2), SC_(0.1066145438340245056954574795725125118984e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.553809732082299888134002685546875e-4), SC_(0.9817093353081942469816526285068995358612e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.69304020144045352935791015625e-4), SC_(0.9821191746862947666429796292865148899257e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.23264062474481761455535888671875e-3), SC_(0.9843351663379732777023812441892374028968e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.4480001516640186309814453125e-3), SC_(0.9855363506977195696759812664468424040665e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.5502865533344447612762451171875e-3), SC_(0.9859135941901516415721117055805978018756e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.19227224402129650115966796875e-2), SC_(0.9882110091337713422555556649984351858334e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.37370622158050537109375e-2), SC_(0.9894314739398718125445096933051219189052e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.47696642577648162841796875e-2), SC_(0.9898786773968001423681957632107335237307e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.1275280676782131195068359375e-1), SC_(0.9916575656584680781858750626325680648059e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.20440109074115753173828125e-1), SC_(0.9924654079000974647945374252001453718364e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.3429813683032989501953125e-1), SC_(0.9932338692418333674513222303931472051914e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.96701286733150482177734375e-1), SC_(0.9931225190063597669143919008613986546829e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.159812271595001220703125e0), SC_(0.9900352203814238880722659452483734427322e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.297095477581024169921875e0), SC_(0.9756754635104943903830166510741270074568e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.77344071865081787109375e0), SC_(0.8556130162510752278666332268905263436046e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.1992881298065185546875e1), SC_(0.2294863665034258649591045326467545257489e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.3915013790130615234375e1), SC_(-0.4013203973956146567802727002608565844354e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.79858455657958984375e1), SC_(0.1756036258093201067742480797203249679677e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.1571910858154296875e2), SC_(-0.1423070182265885360371078443389686783143e0), 
      SC_(0.186112499795854091644287109375e-2), SC_(0.31483119964599609375e2), SC_(0.1064212124432705753393290287137815754319e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.553809732082299888134002685546875e-4), SC_(0.9650707876272019770134952457282249740739e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.69304020144045352935791015625e-4), SC_(0.9658467964630894046501757076218342927801e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.23264062474481761455535888671875e-3), SC_(0.9700478597469915082824318140123835180869e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.4480001516640186309814453125e-3), SC_(0.9723287476406665086749967542371269571234e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.5502865533344447612762451171875e-3), SC_(0.9730456263943909567987631022793046602603e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.19227224402129650115966796875e-2), SC_(0.9774175323141709829066403138557060923786e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.37370622158050537109375e-2), SC_(0.9797457898312132593210429697126849835518e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.47696642577648162841796875e-2), SC_(0.9806007189648424616267897116538953898626e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.1275280676782131195068359375e-1), SC_(0.9840289261106419257463048917206926912931e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.20440109074115753173828125e-1), SC_(0.9856314206424828761679016945348314437259e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.3429813683032989501953125e-1), SC_(0.9872749179206597028494401845390763149145e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.96701286733150482177734375e-1), SC_(0.988932179910175424589294675055202246355e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.159812271595001220703125e0), SC_(0.9867184436488505284336133268536754401756e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.297095477581024169921875e0), SC_(0.9734727764095169166354550030712991853188e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.77344071865081787109375e0), SC_(0.8552988701003771721146721734619235915706e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.1992881298065185546875e1), SC_(0.2308618505494366249905008758109493850602e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.3915013790130615234375e1), SC_(-0.4012691147847807908816435949894823168188e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.79858455657958984375e1), SC_(0.1762002663351808150861701687808126150305e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.1571910858154296875e2), SC_(-0.1419216381983571259124926406653600173921e0), 
      SC_(0.35840012133121490478515625e-2), SC_(0.31483119964599609375e2), SC_(0.1061656276058522622372436370913678330655e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.553809732082299888134002685546875e-4), SC_(0.9572656431203538165112750398451169576976e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.69304020144045352935791015625e-4), SC_(0.9582112064201335261630997112342307287719e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.23264062474481761455535888671875e-3), SC_(0.9633331943281124926230864636692210997818e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.4480001516640186309814453125e-3), SC_(0.9661162109066795212283435150515623357621e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.5502865533344447612762451171875e-3), SC_(0.9669912189279992303843912808888387671473e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.19227224402129650115966796875e-2), SC_(0.9723308178532373593917839240834483621504e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.37370622158050537109375e-2), SC_(0.9751771194142703096718649204073811795873e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.47696642577648162841796875e-2), SC_(0.9762229407760513009389469194046638514027e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.1275280676782131195068359375e-1), SC_(0.9804245691270382739486838438029335140198e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.20440109074115753173828125e-1), SC_(0.9824004047135082246753499791797478879785e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.3429813683032989501953125e-1), SC_(0.984455534869400551529392629224463906169e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.96701286733150482177734375e-1), SC_(0.9869464641414984822321264268443877210374e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.159812271595001220703125e0), SC_(0.9851453236176178426246334004315599658192e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.297095477581024169921875e0), SC_(0.9724266380293597530681971818509394699107e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.77344071865081787109375e0), SC_(0.8551479374909868558451585757714077368885e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.1992881298065185546875e1), SC_(0.2315143366636852187122636336456783890548e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.3915013790130615234375e1), SC_(-0.4012437467987236172826231041979925126909e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.79858455657958984375e1), SC_(0.1764831660585815769139232327821739009943e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.1571910858154296875e2), SC_(-0.141738245001420054185073262290736677654e0), 
      SC_(0.44022924266755580902099609375e-2), SC_(0.31483119964599609375e2), SC_(0.1060439666746798582094286827426883845277e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.553809732082299888134002685546875e-4), SC_(0.8583550718928807401873869793432711772123e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.69304020144045352935791015625e-4), SC_(0.8613211858377698265154743164108225752525e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.23264062474481761455535888671875e-3), SC_(0.8775155467383213075302534757015686484876e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.4480001516640186309814453125e-3), SC_(0.8864053008371523114095454773126426698364e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.5502865533344447612762451171875e-3), SC_(0.8892135905171034893591713316993284208759e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.19227224402129650115966796875e-2), SC_(0.9064901212601688965759347721137705112888e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.37370622158050537109375e-2), SC_(0.9158015418805685482235588249392599592902e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.47696642577648162841796875e-2), SC_(0.9192428186392203993848388684430042172008e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.1275280676782131195068359375e-1), SC_(0.9332223307473034116584470457618562398406e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.20440109074115753173828125e-1), SC_(0.9399596619873951705188067685798880880034e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.3429813683032989501953125e-1), SC_(0.9472960471681579227807169947416445529388e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.96701286733150482177734375e-1), SC_(0.9605839617426718586595605703751608602502e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.159812271595001220703125e0), SC_(0.9641764996837634701730700137586435692646e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.297095477581024169921875e0), SC_(0.9583945505286128951225013946649214254347e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.77344071865081787109375e0), SC_(0.8530164071194849300470063837901880488803e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.1992881298065185546875e1), SC_(0.240218372332627080573838868778527182005e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.3915013790130615234375e1), SC_(-0.4008405522603801038591381630933706393324e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.79858455657958984375e1), SC_(0.1802489691416901537345121978807193189784e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.1571910858154296875e2), SC_(-0.1392556457999181096425233280329944929325e0), 
      SC_(0.153817795217037200927734375e-1), SC_(0.31483119964599609375e2), SC_(0.1043949105890340963995171034261672283363e0), 
      SC_(0.298964977264404296875e-1), SC_(0.553809732082299888134002685546875e-4), SC_(0.742884755887697115977351911781125907627e0), 
      SC_(0.298964977264404296875e-1), SC_(0.69304020144045352935791015625e-4), SC_(0.7478823790829247834932307935127306054769e0), 
      SC_(0.298964977264404296875e-1), SC_(0.23264062474481761455535888671875e-3), SC_(0.7754551326679408121223091135554781991498e0), 
      SC_(0.298964977264404296875e-1), SC_(0.4480001516640186309814453125e-3), SC_(0.7907969426857135091277230622821305711136e0), 
      SC_(0.298964977264404296875e-1), SC_(0.5502865533344447612762451171875e-3), SC_(0.7956737841544445768430498354850849698267e0), 
      SC_(0.298964977264404296875e-1), SC_(0.19227224402129650115966796875e-2), SC_(0.8259966511221832755858705775881757660762e0), 
      SC_(0.298964977264404296875e-1), SC_(0.37370622158050537109375e-2), SC_(0.8425695187557287349775070878883918917836e0), 
      SC_(0.298964977264404296875e-1), SC_(0.47696642577648162841796875e-2), SC_(0.8487359057359733335063723107462504359251e0), 
      SC_(0.298964977264404296875e-1), SC_(0.1275280676782131195068359375e-1), SC_(0.8740316507444012343914751545412959743395e0), 
      SC_(0.298964977264404296875e-1), SC_(0.20440109074115753173828125e-1), SC_(0.886391079139498777007192966317958160095e0), 
      SC_(0.298964977264404296875e-1), SC_(0.3429813683032989501953125e-1), SC_(0.9000481701003951036457086504770705772399e0), 
      SC_(0.298964977264404296875e-1), SC_(0.96701286733150482177734375e-1), SC_(0.9265346574320327852130484364760647803115e0), 
      SC_(0.298964977264404296875e-1), SC_(0.159812271595001220703125e0), SC_(0.9368589195346616414310636250516773534604e0), 
      SC_(0.298964977264404296875e-1), SC_(0.297095477581024169921875e0), SC_(0.9398678208615801421745490322757890186537e0), 
      SC_(0.298964977264404296875e-1), SC_(0.77344071865081787109375e0), SC_(0.8499012519470720593166607729886371802792e0), 
      SC_(0.298964977264404296875e-1), SC_(0.1992881298065185546875e1), SC_(0.2515780672390681588351321732986617026347e0), 
      SC_(0.298964977264404296875e-1), SC_(0.3915013790130615234375e1), SC_(-0.4001289935988788691267947472714059973845e0), 
      SC_(0.298964977264404296875e-1), SC_(0.79858455657958984375e1), SC_(0.1851403466337968000141195478049479374839e0), 
      SC_(0.298964977264404296875e-1), SC_(0.1571910858154296875e2), SC_(-0.1359120805184338686368388592303485950658e0), 
      SC_(0.298964977264404296875e-1), SC_(0.31483119964599609375e2), SC_(0.1021679170423707311154153818173894031606e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.553809732082299888134002685546875e-4), SC_(0.6841420299325285630130897536364936747643e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.69304020144045352935791015625e-4), SC_(0.6900216413679779551556201528526453387394e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.23264062474481761455535888671875e-3), SC_(0.7226544366131223950228834783456152605754e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.4480001516640186309814453125e-3), SC_(0.7409517829280971667458533848115659780144e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.5502865533344447612762451171875e-3), SC_(0.7467887977417584608136463615613360082868e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.19227224402129650115966796875e-2), SC_(0.7833022340177641505811477263523586590019e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.37370622158050537109375e-2), SC_(0.8034169983227660471989683377181643874041e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.47696642577648162841796875e-2), SC_(0.8109295949487911713922913635940285964383e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.1275280676782131195068359375e-1), SC_(0.8419110219154533706755463279080150807209e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.20440109074115753173828125e-1), SC_(0.8571504961090591474324139612398431475369e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.3429813683032989501953125e-1), SC_(0.8740877238077575501391719499843064674293e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.96701286733150482177734375e-1), SC_(0.9075624274998725403726052596212149221215e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.159812271595001220703125e0), SC_(0.9215205268089440982144689663486354608066e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.297095477581024169921875e0), SC_(0.9293421706048407737874025281709292937407e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.77344071865081787109375e0), SC_(0.8479814260052627324635659368076800003767e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.1992881298065185546875e1), SC_(0.2579673330760711478868236151210265224189e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.3915013790130615234375e1), SC_(-0.3996338564915260965885550628131890788051e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.79858455657958984375e1), SC_(0.1878792246069015970888990916599081627329e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.1571910858154296875e2), SC_(-0.1339784634600578760332134085441073471374e0), 
      SC_(0.381573140621185302734375e-1), SC_(0.31483119964599609375e2), SC_(0.100876996327549944249344479925538884532e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.553809732082299888134002685546875e-4), SC_(0.3606165352044069393831350891047765483003e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.69304020144045352935791015625e-4), SC_(0.3689626486805358814480741299029355981601e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.23264062474481761455535888671875e-3), SC_(0.4174829799241447295048315790401886916946e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.4480001516640186309814453125e-3), SC_(0.4463480033025776786832515229187416030614e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.5502865533344447612762451171875e-3), SC_(0.4558115094446283324562214840153242542871e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.19227224402129650115966796875e-2), SC_(0.5178650207127426471775316254220911383178e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.37370622158050537109375e-2), SC_(0.5541925039216886380975838806332594009211e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.47696642577648162841796875e-2), SC_(0.5681589129485432012257678833259897519727e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.1275280676782131195068359375e-1), SC_(0.6281041540102595477794290368911151843408e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.20440109074115753173828125e-1), SC_(0.6590352185809360608371672991603233118586e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.3429813683032989501953125e-1), SC_(0.6946519128324876690915696733589771202802e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.96701286733150482177734375e-1), SC_(0.7707046606989733770250126276311699296637e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.159812271595001220703125e0), SC_(0.8082562254820549527428553025014375386755e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.297095477581024169921875e0), SC_(0.8487974946765730744564092334654307469559e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.77344071865081787109375e0), SC_(0.8298066178791086006349441593017042218955e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.1992881298065185546875e1), SC_(0.3054343300062091738974399358601827644068e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.3915013790130615234375e1), SC_(-0.3936401467474671244724786149362722727073e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.79858455657958984375e1), SC_(0.2079075751648681425192154503326445363098e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.1571910858154296875e2), SC_(-0.1183197505805322445014652724968664131902e0), 
      SC_(0.10202245414257049560546875e0), SC_(0.31483119964599609375e2), SC_(0.9034937163020660492669231458325337256655e-1), 
      SC_(0.163520872592926025390625e0), SC_(0.553809732082299888134002685546875e-4), SC_(0.1935765400863987429813801338918793416835e0), 
      SC_(0.163520872592926025390625e0), SC_(0.69304020144045352935791015625e-4), SC_(0.2008072106338149495223798543091882605684e0), 
      SC_(0.163520872592926025390625e0), SC_(0.23264062474481761455535888671875e-3), SC_(0.2447819339896590712661783460825717003235e0), 
      SC_(0.163520872592926025390625e0), SC_(0.4480001516640186309814453125e-3), SC_(0.2724684237231234324363787603307965238357e0), 
      SC_(0.163520872592926025390625e0), SC_(0.5502865533344447612762451171875e-3), SC_(0.2817866018678791425942242567578780018964e0), 
      SC_(0.163520872592926025390625e0), SC_(0.19227224402129650115966796875e-2), SC_(0.3457525898001358494852590808597670355534e0), 
      SC_(0.163520872592926025390625e0), SC_(0.37370622158050537109375e-2), SC_(0.3854418375100269152289095951487202696446e0), 
      SC_(0.163520872592926025390625e0), SC_(0.47696642577648162841796875e-2), SC_(0.4011292146115097022811728131521138974364e0), 
      SC_(0.163520872592926025390625e0), SC_(0.1275280676782131195068359375e-1), SC_(0.4711009097421660901146172076469919302745e0), 
      SC_(0.163520872592926025390625e0), SC_(0.20440109074115753173828125e-1), SC_(0.5088524475025423064259545555342309369868e0), 
      SC_(0.163520872592926025390625e0), SC_(0.3429813683032989501953125e-1), SC_(0.5537050642023393215162737912683735722478e0), 
      SC_(0.163520872592926025390625e0), SC_(0.96701286733150482177734375e-1), SC_(0.654826290486799846435084426005197154546e0), 
      SC_(0.163520872592926025390625e0), SC_(0.159812271595001220703125e0), SC_(0.708417798536071944638243041597473973128e0), 
      SC_(0.163520872592926025390625e0), SC_(0.297095477581024169921875e0), SC_(0.7734579959585943711276462664242659276933e0), 
      SC_(0.163520872592926025390625e0), SC_(0.77344071865081787109375e0), SC_(0.8073868060584113423014122796250092474989e0), 
      SC_(0.163520872592926025390625e0), SC_(0.1992881298065185546875e1), SC_(0.3477579001706517006791481727902424569584e0), 
      SC_(0.163520872592926025390625e0), SC_(0.3915013790130615234375e1), SC_(-0.3843633305258631298586157270838438240094e0), 
      SC_(0.163520872592926025390625e0), SC_(0.79858455657958984375e1), SC_(0.2251683658539084282442650061831272437155e0), 
      SC_(0.163520872592926025390625e0), SC_(0.1571910858154296875e2), SC_(-0.102164231881092586707016718170101606631e0), 
      SC_(0.163520872592926025390625e0), SC_(0.31483119964599609375e2), SC_(0.7936891271499253168434546053762560949488e-1), 
      SC_(0.27438509464263916015625e0), SC_(0.553809732082299888134002685546875e-4), SC_(0.6228420712447870814285199552872701596776e-1), 
      SC_(0.27438509464263916015625e0), SC_(0.69304020144045352935791015625e-4), SC_(0.6623727493409701153735818363331462769764e-1), 
      SC_(0.27438509464263916015625e0), SC_(0.23264062474481761455535888671875e-3), SC_(0.9234407117578245720954148716726511312456e-1), 
      SC_(0.27438509464263916015625e0), SC_(0.4480001516640186309814453125e-3), SC_(0.1105342767528907252128512094065852917468e0), 
      SC_(0.27438509464263916015625e0), SC_(0.5502865533344447612762451171875e-3), SC_(0.1169506125790863061630031566039819079126e0), 
      SC_(0.27438509464263916015625e0), SC_(0.19227224402129650115966796875e-2), SC_(0.164847829249976942985975327390198531889e0), 
      SC_(0.27438509464263916015625e0), SC_(0.37370622158050537109375e-2), SC_(0.1978215790949422197428770971627606477192e0), 
      SC_(0.27438509464263916015625e0), SC_(0.47696642577648162841796875e-2), SC_(0.2115173854011710893803581877981094936686e0), 
      SC_(0.27438509464263916015625e0), SC_(0.1275280676782131195068359375e-1), SC_(0.2770313741041427777559243253878892289249e0), 
      SC_(0.27438509464263916015625e0), SC_(0.20440109074115753173828125e-1), SC_(0.3152989535782268394242187238779405447919e0), 
      SC_(0.27438509464263916015625e0), SC_(0.3429813683032989501953125e-1), SC_(0.3633592225389310683611636886724262055726e0), 
      SC_(0.27438509464263916015625e0), SC_(0.96701286733150482177734375e-1), SC_(0.4821221372847714604352567046948535165623e0), 
      SC_(0.27438509464263916015625e0), SC_(0.159812271595001220703125e0), SC_(0.5516206453467267319728144901434690238286e0), 
      SC_(0.27438509464263916015625e0), SC_(0.297095477581024169921875e0), SC_(0.6458892967673327408733141872284902076157e0), 
      SC_(0.27438509464263916015625e0), SC_(0.77344071865081787109375e0), SC_(0.7574871943872145834141576741841520880101e0), 
      SC_(0.27438509464263916015625e0), SC_(0.1992881298065185546875e1), SC_(0.4151603630848462540526709866685185049035e0), 
      SC_(0.27438509464263916015625e0), SC_(0.3915013790130615234375e1), SC_(-0.3595525462795827708789543875034136996309e0), 
      SC_(0.27438509464263916015625e0), SC_(0.79858455657958984375e1), SC_(0.2508669266659111537260665836716160218675e0), 
      SC_(0.27438509464263916015625e0), SC_(0.1571910858154296875e2), SC_(-0.7088009880511567432681382070126536719863e-1), 
      SC_(0.27438509464263916015625e0), SC_(0.31483119964599609375e2), SC_(0.5782732937293368719231009402701038060308e-1), 
      SC_(0.773610293865203857421875e0), SC_(0.553809732082299888134002685546875e-4), SC_(0.3222296261070960267506583626328336605603e-3), 
      SC_(0.773610293865203857421875e0), SC_(0.69304020144045352935791015625e-4), SC_(0.3832776033740372365543338166881198158245e-3), 
      SC_(0.773610293865203857421875e0), SC_(0.23264062474481761455535888671875e-3), SC_(0.9780838301186048514554659570989124966569e-3), 
      SC_(0.773610293865203857421875e0), SC_(0.4480001516640186309814453125e-3), SC_(0.162382730307963675651648352167036650681e-2), 
      SC_(0.773610293865203857421875e0), SC_(0.5502865533344447612762451171875e-3), SC_(0.1903844793429706661570830196435423250832e-2), 
      SC_(0.773610293865203857421875e0), SC_(0.19227224402129650115966796875e-2), SC_(0.501135570740291264003109085072842029352e-2), 
      SC_(0.773610293865203857421875e0), SC_(0.37370622158050537109375e-2), SC_(0.8379713230161554466309376293974021298272e-2), 
      SC_(0.773610293865203857421875e0), SC_(0.47696642577648162841796875e-2), SC_(0.1012041722486074483696280603462161354426e-1), 
      SC_(0.773610293865203857421875e0), SC_(0.1275280676782131195068359375e-1), SC_(0.216577188640219307250185271553412447577e-1), 
      SC_(0.773610293865203857421875e0), SC_(0.20440109074115753173828125e-1), SC_(0.311955308334793282568797636287326993782e-1), 
      SC_(0.773610293865203857421875e0), SC_(0.3429813683032989501953125e-1), SC_(0.4655257690662710372539264892660562067193e-1), 
      SC_(0.773610293865203857421875e0), SC_(0.96701286733150482177734375e-1), SC_(0.1036795032424837724132280968505410966204e0), 
      SC_(0.773610293865203857421875e0), SC_(0.159812271595001220703125e0), SC_(0.1525758006523497861594698948383510302805e0), 
      SC_(0.773610293865203857421875e0), SC_(0.297095477581024169921875e0), SC_(0.2443188793148582054843189696741113031701e0), 
      SC_(0.773610293865203857421875e0), SC_(0.77344071865081787109375e0), SC_(0.4760335268988334891374071772729661423144e0), 
      SC_(0.773610293865203857421875e0), SC_(0.1992881298065185546875e1), SC_(0.5738140731345578470194054669386198530524e0), 
      SC_(0.773610293865203857421875e0), SC_(0.3915013790130615234375e1), SC_(-0.152977982927187208229664701583316444495e0), 
      SC_(0.773610293865203857421875e0), SC_(0.79858455657958984375e1), SC_(0.2720029809232263356561781252102629824753e0), 
      SC_(0.773610293865203857421875e0), SC_(0.1571910858154296875e2), SC_(0.7979891128478667330490354169806520568541e-1), 
      SC_(0.773610293865203857421875e0), SC_(0.31483119964599609375e2), SC_(-0.4970658304875028592254320548176144098148e-1), 
      SC_(0.1278498172760009765625e1), SC_(0.553809732082299888134002685546875e-4), SC_(0.1293042877451174959752415317453290989549e-5), 
      SC_(0.1278498172760009765625e1), SC_(0.69304020144045352935791015625e-4), SC_(0.1722407437992625778019526669549314786717e-5), 
      SC_(0.1278498172760009765625e1), SC_(0.23264062474481761455535888671875e-3), SC_(0.8100890500258348601835497121888057691765e-5), 
      SC_(0.1278498172760009765625e1), SC_(0.4480001516640186309814453125e-3), SC_(0.1872336402519189482379901626968705848331e-4), 
      SC_(0.1278498172760009765625e1), SC_(0.5502865533344447612762451171875e-3), SC_(0.2435384252982741484249166134205283819448e-4), 
      SC_(0.1278498172760009765625e1), SC_(0.19227224402129650115966796875e-2), SC_(0.1205620978482445248571933261980048308611e-3), 
      SC_(0.1278498172760009765625e1), SC_(0.37370622158050537109375e-2), SC_(0.2819696969201040501731691258249980108852e-3), 
      SC_(0.1278498172760009765625e1), SC_(0.47696642577648162841796875e-2), SC_(0.3851842008874816937945807840767328664892e-3), 
      SC_(0.1278498172760009765625e1), SC_(0.1275280676782131195068359375e-1), SC_(0.1354351344969989133582417432988553465356e-2), 
      SC_(0.1278498172760009765625e1), SC_(0.20440109074115753173828125e-1), SC_(0.2475452537371515965476163695361837528907e-2), 
      SC_(0.1278498172760009765625e1), SC_(0.3429813683032989501953125e-1), SC_(0.4797429857204974956432283042366526858553e-2), 
      SC_(0.1278498172760009765625e1), SC_(0.96701286733150482177734375e-1), SC_(0.1803640453854063494252322440013642039371e-1), 
      SC_(0.1278498172760009765625e1), SC_(0.159812271595001220703125e0), SC_(0.3422300234134881051695002634665810825229e-1), 
      SC_(0.1278498172760009765625e1), SC_(0.297095477581024169921875e0), SC_(0.7509395505166360503639976232203552453175e-1), 
      SC_(0.1278498172760009765625e1), SC_(0.77344071865081787109375e0), SC_(0.2411436940173849956429561964466706747216e0), 
      SC_(0.1278498172760009765625e1), SC_(0.1992881298065185546875e1), SC_(0.5404138641444118039922709928024339259041e0), 
      SC_(0.1278498172760009765625e1), SC_(0.3915013790130615234375e1), SC_(0.1125617657254339590832781377108694478819e0), 
      SC_(0.1278498172760009765625e1), SC_(0.79858455657958984375e1), SC_(0.1522182099368662078139588491031563608345e0), 
      SC_(0.1278498172760009765625e1), SC_(0.1571910858154296875e2), SC_(0.1853779722844880544471765776954848178162e0), 
      SC_(0.1278498172760009765625e1), SC_(0.31483119964599609375e2), SC_(-0.1288757401823690223291744655835744635071e0), 
      SC_(0.2376763820648193359375e1), SC_(0.553809732082299888134002685546875e-4), SC_(0.5056586192203856045910471595498124462596e-11), 
      SC_(0.2376763820648193359375e1), SC_(0.69304020144045352935791015625e-4), SC_(0.8616860991796920863644006764866027042152e-11), 
      SC_(0.2376763820648193359375e1), SC_(0.23264062474481761455535888671875e-3), SC_(0.1532334765930977771102515339639802324861e-9), 
      SC_(0.2376763820648193359375e1), SC_(0.4480001516640186309814453125e-3), SC_(0.7273828528370972876878238428839518376154e-9), 
      SC_(0.2376763820648193359375e1), SC_(0.5502865533344447612762451171875e-3), SC_(0.1185860464394239101691199317159293833879e-8), 
      SC_(0.2376763820648193359375e1), SC_(0.19227224402129650115966796875e-2), SC_(0.2319503797697066104304367743047597833322e-7), 
      SC_(0.2376763820648193359375e1), SC_(0.37370622158050537109375e-2), SC_(0.1125541303882382369653700619816305958189e-6), 
      SC_(0.2376763820648193359375e1), SC_(0.47696642577648162841796875e-2), SC_(0.2010004653396484530098091684494825339958e-6), 
      SC_(0.2376763820648193359375e1), SC_(0.1275280676782131195068359375e-1), SC_(0.2081378683926122164460443936660037148164e-5), 
      SC_(0.2376763820648193359375e1), SC_(0.20440109074115753173828125e-1), SC_(0.6386871239519502743466959676485268954914e-5), 
      SC_(0.2376763820648193359375e1), SC_(0.3429813683032989501953125e-1), SC_(0.2185395974871662899753176702325896507127e-4), 
      SC_(0.2376763820648193359375e1), SC_(0.96701286733150482177734375e-1), SC_(0.25656379472828044772240144209934575006e-3), 
      SC_(0.2376763820648193359375e1), SC_(0.159812271595001220703125e0), SC_(0.845730449100299183956699628010590519736e-3), 
      SC_(0.2376763820648193359375e1), SC_(0.297095477581024169921875e0), SC_(0.3674871979280675321301756071429237649275e-2), 
      SC_(0.2376763820648193359375e1), SC_(0.77344071865081787109375e0), SC_(0.3438496811568474491355241340053475579032e-1), 
      SC_(0.2376763820648193359375e1), SC_(0.1992881298065185546875e1), SC_(0.2513901336569734693859406681568671211021e0), 
      SC_(0.2376763820648193359375e1), SC_(0.3915013790130615234375e1), SC_(0.4411924952040898535595925619755816956809e0), 
      SC_(0.2376763820648193359375e1), SC_(0.79858455657958984375e1), SC_(-0.2273576855576674689369594664643423033118e0), 
      SC_(0.2376763820648193359375e1), SC_(0.1571910858154296875e2), SC_(0.7438347444997647796963367146274908500004e-1), 
      SC_(0.2376763820648193359375e1), SC_(0.31483119964599609375e2), SC_(-0.4835996250612980219088832147311470184396e-1), 
      SC_(0.618752574920654296875e1), SC_(0.553809732082299888134002685546875e-4), SC_(0.6141678216085436111176451400063635126985e-31), 
      SC_(0.618752574920654296875e1), SC_(0.69304020144045352935791015625e-4), SC_(0.246002051024745363814461774049739325662e-30), 
      SC_(0.618752574920654296875e1), SC_(0.23264062474481761455535888671875e-3), SC_(0.4416989561874068641789782319112059701685e-27), 
      SC_(0.618752574920654296875e1), SC_(0.4480001516640186309814453125e-3), SC_(0.2547126098161636865969703324599457436971e-25), 
      SC_(0.618752574920654296875e1), SC_(0.5502865533344447612762451171875e-3), SC_(0.9092073652119249745125219238269278791216e-25), 
      SC_(0.618752574920654296875e1), SC_(0.19227224402129650115966796875e-2), SC_(0.2091784753137493653036354140039919926587e-21), 
      SC_(0.618752574920654296875e1), SC_(0.37370622158050537109375e-2), SC_(0.1277384798655490775905658138944681765305e-19), 
      SC_(0.618752574920654296875e1), SC_(0.47696642577648162841796875e-2), SC_(0.5780112025030309280393501135304190431747e-19), 
      SC_(0.618752574920654296875e1), SC_(0.1275280676782131195068359375e-1), SC_(0.2539437786678802679382159611357475659317e-16), 
      SC_(0.618752574920654296875e1), SC_(0.20440109074115753173828125e-1), SC_(0.4703466931802969431139418828811047045971e-15), 
      SC_(0.618752574920654296875e1), SC_(0.3429813683032989501953125e-1), SC_(0.1156868416120739652892078422418971652898e-13), 
      SC_(0.618752574920654296875e1), SC_(0.96701286733150482177734375e-1), SC_(0.7055823940609916725367183770341485771641e-11), 
      SC_(0.618752574920654296875e1), SC_(0.159812271595001220703125e0), SC_(0.157864460888642548494771779237446860121e-9), 
      SC_(0.618752574920654296875e1), SC_(0.297095477581024169921875e0), SC_(0.7303821609272158309492823142947445732176e-8), 
      SC_(0.618752574920654296875e1), SC_(0.77344071865081787109375e0), SC_(0.2672664548632283509874594371971735667516e-5), 
      SC_(0.618752574920654296875e1), SC_(0.1992881298065185546875e1), SC_(0.8296436579220156802866858143435702375141e-3), 
      SC_(0.618752574920654296875e1), SC_(0.3915013790130615234375e1), SC_(0.3582497898452286859296846783634361347323e-1), 
      SC_(0.618752574920654296875e1), SC_(0.79858455657958984375e1), SC_(0.3457617746872806174549271704484687317651e0), 
      SC_(0.618752574920654296875e1), SC_(0.1571910858154296875e2), SC_(0.2072660158578431354057405902818480142787e0), 
      SC_(0.618752574920654296875e1), SC_(0.31483119964599609375e2), SC_(-0.1318618402231476532997477360412655763119e0), 
      SC_(0.15943050384521484375e2), SC_(0.553809732082299888134002685546875e-4), SC_(0.121765325971199235226950916196533478569e-85), 
      SC_(0.15943050384521484375e2), SC_(0.69304020144045352935791015625e-4), SC_(0.4348529040889526305872634896082273962461e-84), 
      SC_(0.15943050384521484375e2), SC_(0.23264062474481761455535888671875e-3), SC_(0.1054933471529069744215328306932288735002e-75), 
      SC_(0.15943050384521484375e2), SC_(0.4480001516640186309814453125e-3), SC_(0.3634957360230243469527303257192252467733e-71), 
      SC_(0.15943050384521484375e2), SC_(0.5502865533344447612762451171875e-3), SC_(0.9646837024091091333308495040848415220353e-70), 
      SC_(0.15943050384521484375e2), SC_(0.19227224402129650115966796875e-2), SC_(0.4432877465512047439464155651452389042106e-61), 
      SC_(0.15943050384521484375e2), SC_(0.37370622158050537109375e-2), SC_(0.1770390010617740019194413844748485420908e-56), 
      SC_(0.15943050384521484375e2), SC_(0.47696642577648162841796875e-2), SC_(0.8656739708490917931260774639401847905445e-55), 
      SC_(0.15943050384521484375e2), SC_(0.1275280676782131195068359375e-1), SC_(0.5583631811182531205165895051362489723946e-48), 
      SC_(0.15943050384521484375e2), SC_(0.20440109074115753173828125e-1), SC_(0.103106565969855434312386168894543598243e-44), 
      SC_(0.15943050384521484375e2), SC_(0.3429813683032989501953125e-1), SC_(0.3954367464083906354438402796246817522015e-41), 
      SC_(0.15943050384521484375e2), SC_(0.96701286733150482177734375e-1), SC_(0.5942588953071692102183170727631542245108e-34), 
      SC_(0.15943050384521484375e2), SC_(0.159812271595001220703125e0), SC_(0.1787692223274770382718402566108351637629e-30), 
      SC_(0.15943050384521484375e2), SC_(0.297095477581024169921875e0), SC_(0.3508566459949628001757525016826509424779e-26), 
      SC_(0.15943050384521484375e2), SC_(0.77344071865081787109375e0), SC_(0.1467886618883000652209178210120183048119e-19), 
      SC_(0.15943050384521484375e2), SC_(0.1992881298065185546875e1), SC_(0.4994542214744224454151505315307238073221e-13), 
      SC_(0.15943050384521484375e2), SC_(0.3915013790130615234375e1), SC_(0.1997414520429768177432880178694168079225e-8), 
      SC_(0.15943050384521484375e2), SC_(0.79858455657958984375e1), SC_(0.8220903046865285045445582707996957424813e-4), 
      SC_(0.15943050384521484375e2), SC_(0.1571910858154296875e2), SC_(0.1635793592300323171799133620913882844268e0), 
      SC_(0.15943050384521484375e2), SC_(0.31483119964599609375e2), SC_(-0.1436476010691620533772737806011732529468e0), 
      SC_(0.31320110321044921875e2), SC_(0.553809732082299888134002685546875e-4), SC_(0.720999514635082944998486378462042065548e-177), 
      SC_(0.31320110321044921875e2), SC_(0.69304020144045352935791015625e-4), SC_(0.8099276041615658852408040879405710425224e-174), 
      SC_(0.31320110321044921875e2), SC_(0.23264062474481761455535888671875e-3), SC_(0.2401827789365385723264959328048209544024e-157), 
      SC_(0.31320110321044921875e2), SC_(0.4480001516640186309814453125e-3), SC_(0.1967948222206320595051933567795148903452e-148), 
      SC_(0.31320110321044921875e2), SC_(0.5502865533344447612762451171875e-3), SC_(0.1233774769381781535909728004063264007336e-145), 
      SC_(0.31320110321044921875e2), SC_(0.19227224402129650115966796875e-2), SC_(0.1283273428485489536447676425815813056886e-128), 
      SC_(0.31320110321044921875e2), SC_(0.37370622158050537109375e-2), SC_(0.1405183787621580648869621961084314778533e-119), 
      SC_(0.31320110321044921875e2), SC_(0.47696642577648162841796875e-2), SC_(0.2926396097007299560785500719585898203219e-116), 
      SC_(0.31320110321044921875e2), SC_(0.1275280676782131195068359375e-1), SC_(0.6977736543795536782997046101038445558663e-103), 
      SC_(0.31320110321044921875e2), SC_(0.20440109074115753173828125e-1), SC_(0.1821786218163979826416197870670171130133e-96), 
      SC_(0.31320110321044921875e2), SC_(0.3429813683032989501953125e-1), SC_(0.1999210450604504410914425432107629502991e-89), 
      SC_(0.31320110321044921875e2), SC_(0.96701286733150482177734375e-1), SC_(0.251157366530045646437718994576632141369e-75), 
      SC_(0.31320110321044921875e2), SC_(0.159812271595001220703125e0), SC_(0.1710986365304126142935808274616325811609e-68), 
      SC_(0.31320110321044921875e2), SC_(0.297095477581024169921875e0), SC_(0.4646227131059059595427604644829875800615e-60), 
      SC_(0.31320110321044921875e2), SC_(0.77344071865081787109375e0), SC_(0.4784799239708328602598193913379505621018e-47), 
      SC_(0.31320110321044921875e2), SC_(0.1992881298065185546875e1), SC_(0.3489752451870321457103722660567152768057e-34), 
      SC_(0.31320110321044921875e2), SC_(0.3915013790130615234375e1), SC_(0.4889245759333297227698619173071154698185e-25), 
      SC_(0.31320110321044921875e2), SC_(0.79858455657958984375e1), SC_(0.1664515950791679187310431924442476923109e-15), 
      SC_(0.31320110321044921875e2), SC_(0.1571910858154296875e2), SC_(0.6205404214654629687787121851824504334876e-7), 
      SC_(0.31320110321044921875e2), SC_(0.31483119964599609375e2), SC_(0.1484545929446900561639094358967123117739e0), 
      SC_(0.638867645263671875e2), SC_(0.553809732082299888134002685546875e-4), SC_(0.8446839048780569280474710663682619972041e-380), 
      SC_(0.638867645263671875e2), SC_(0.69304020144045352935791015625e-4), SC_(0.1409702153899462689202357620502522957131e-373), 
      SC_(0.638867645263671875e2), SC_(0.23264062474481761455535888671875e-3), SC_(0.5609316393869461530695885033806074145071e-340), 
      SC_(0.638867645263671875e2), SC_(0.4480001516640186309814453125e-3), SC_(0.8523357694224079855215503041727333034429e-322), 
      SC_(0.638867645263671875e2), SC_(0.5502865533344447612762451171875e-3), SC_(0.4328973281194721121716411716842618698591e-316), 
      SC_(0.638867645263671875e2), SC_(0.19227224402129650115966796875e-2), SC_(0.2227580314514104775209901151215137968262e-281), 
      SC_(0.638867645263671875e2), SC_(0.37370622158050537109375e-2), SC_(0.6115485831827422144019763064445038756912e-263), 
      SC_(0.638867645263671875e2), SC_(0.47696642577648162841796875e-2), SC_(0.3595105306082387449978056548902672235759e-256), 
      SC_(0.638867645263671875e2), SC_(0.1275280676782131195068359375e-1), SC_(0.6964605680269546994812846826702862289074e-229), 
      SC_(0.638867645263671875e2), SC_(0.20440109074115753173828125e-1), SC_(0.8547757957801666890816087207766370541757e-216), 
      SC_(0.638867645263671875e2), SC_(0.3429813683032989501953125e-1), SC_(0.1962390821047959905705920637771295517402e-201), 
      SC_(0.638867645263671875e2), SC_(0.96701286733150482177734375e-1), SC_(0.1127581411317236750982950580839608146603e-172), 
      SC_(0.638867645263671875e2), SC_(0.159812271595001220703125e0), SC_(0.9790370659506770228693171342289984428576e-159), 
      SC_(0.638867645263671875e2), SC_(0.297095477581024169921875e0), SC_(0.1564948684865165000775450621480811627558e-141), 
      SC_(0.638867645263671875e2), SC_(0.77344071865081787109375e0), SC_(0.5502719787681308363007881451048037707171e-115), 
      SC_(0.638867645263671875e2), SC_(0.1992881298065185546875e1), SC_(0.9905301122130665466055237290421121475096e-89), 
      SC_(0.638867645263671875e2), SC_(0.3915013790130615234375e1), SC_(0.5149539828266276213224902637532044041335e-70), 
      SC_(0.638867645263671875e2), SC_(0.79858455657958984375e1), SC_(0.2564876610067021281696593047029893911603e-50), 
      SC_(0.638867645263671875e2), SC_(0.1571910858154296875e2), SC_(0.7745090555307013050588237027600011961354e-32), 
      SC_(0.638867645263671875e2), SC_(0.31483119964599609375e2), SC_(0.7349468722273911955644415269211426919788e-14)
   };
#undef SC_


