//  Copyright (c) 2006 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Test data for RF, each row contains in order:
//
// x, y, z, p, RF(x, y, z, p)
//
#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 5>, 801> ellint_rj_data = {
      SC_(0.17778719640226356167347852945229440308832650104108e-30), SC_(0.140657017848070144e19), SC_(0.1004598712921142578125e2), SC_(-0.482979822802320768460049293935298919677734375e-9), SC_(-0.25179478604244669733973586875090503552089558764187e-9), 
      SC_(0.17971096343704528451751984491965084147481741634467e-30), SC_(0.89101844176293009628514463216220065078232437372208e-17), SC_(0.83764338663550372334498751058362691151424505491344e-28), SC_(0.25525904358368192101317869568e29), SC_(0.55264196567924337745014728862252651162552511364961e-18), 
      SC_(0.3374483874642825322028299383742755000492569610633e-30), SC_(0.46577155087788907954176e23), SC_(0.46983051300048828125e0), SC_(-0.4337557424349824941600672900676727294921875e-8), SC_(-0.29586494691174345632763961304004697052773087913144e-10), 
      SC_(0.34628584803331255547073953716003532083475191421235e-30), SC_(0.303861990424576e15), SC_(0.4400977e7), SC_(0.8120083456e10), SC_(0.94406118682435306969091503176397574982473232273954e-16), 
      SC_(0.52529654597568598687401224634973212611437919511155e-30), SC_(0.58548273201185353977823232e26), SC_(0.20248201901919065867629932142790494253858923912048e-14), SC_(-0.18734671312196414516097698394344282521492941247926e-27), SC_(0.33644488398603828475913952425044358424278852139661e8), 
      SC_(0.62221619626030569058053553009209074892000950850727e-30), SC_(0.343400804652490021666816e24), SC_(0.67300522327423095703125e0), SC_(-0.27625999903489739661921475999406538903713226318359e-12), SC_(-0.75889847310956721783906856673041055044273454295232e-11), 
      SC_(0.62687453931329231730011467674071804187172354186889e-30), SC_(0.26256847716031594952568184453411959111690521240234e-12), SC_(0.1063940752263547436662784e25), SC_(-0.136451337486336e15), SC_(-0.67037231980991720071044018087634320636670369191284e-24), 
      SC_(0.68459855298386769923242872813539959368599538368623e-30), SC_(0.3576658041416457175462348437019377323527317041928e-28), SC_(0.182191292416e12), SC_(-0.363291968e9), SC_(-0.83523497967218414236437029496187282518142685409801e-12), 
      SC_(0.79319377739814275716610132815898742724164603635128e-30), SC_(0.149536081295309486449696123600006103515625e-7), SC_(0.110968975e7), SC_(0.39225603641135470576542739402404764287313199133678e-22), SC_(0.58404081910170394697384547096361115025170471880191e13), 
      SC_(0.89048248588914662625862647642457234630028429798521e-30), SC_(0.19709305012440588607850390271996382609153184795395e-27), SC_(0.11493865037410894201880001018568858790897452128896e-30), SC_(-0.12642370874130226532372489600675180554389953613281e-11), SC_(-0.63945430527093703240104260994490070888470387853874e27), 
      SC_(0.91680349711592282765605796247359202706042027867974e-30), SC_(0.734585367784587264e18), SC_(0.1052182232419898336993917357499253478604839479385e-26), SC_(0.2412866171048483705123448575434206360597333418383e-23), SC_(0.65770139664720747088672501472576668594088104855097e16), 
      SC_(0.10737441240523986959769665275538259586246072191374e-29), SC_(0.17000503652400689169610359385842457413673400878906e-11), SC_(0.18877310806851385273422393249673449514610540367343e-24), SC_(-0.11655765639250777695895033508093171243654281372297e-28), SC_(0.43166762266635358600263434023771743134211282555865e33), 
      SC_(0.11714106834475308811660531464919355963339235126279e-29), SC_(0.24252292633056640625e2), SC_(0.367521736353615183872e22), SC_(-0.4790649536162908709687890753434018342726830042011e-21), SC_(0.22701967082264264796089141494292880179559115582815e-4), 
      SC_(0.15170719443124775223923085751802832491502232570833e-29), SC_(0.5680430348320442135445773601531982421875e-8), SC_(0.264763527397376e15), SC_(0.13735858601648942567408084869384765625e-5), SC_(0.46218215900161368547332976532325866494807961652724e0), 
      SC_(0.16414311592283418833973460759110207528131746805707e-29), SC_(0.2019777626058022108969416021903358834932440402099e-21), SC_(0.2589416226816e13), SC_(-0.8526492879801228497171905473805963993072509765625e-11), SC_(-0.28262895694754696636159676198309944171160827781306e7), 
      SC_(0.18514118780253326139548161460302589871739700953216e-29), SC_(0.386711545288562774658203125e-1), SC_(0.23784641790813854100861135520972311496734619140625e-12), SC_(-0.1573566764023808e16), SC_(-0.13857417194455984598251280402623707809865243033107e-12), 
      SC_(0.27003399803360749163257433233715641043057849874222e-29), SC_(0.4438962912167515363689288870188763384827534963506e-23), SC_(0.75457567458852864e17), SC_(-0.11436019672743120284552631460428528953343629837036e-13), SC_(-0.11008238028815716178378898314905171879133537621566e8), 
      SC_(0.27604985838665253543615615843832173935883006238474e-29), SC_(0.25638719488e11), SC_(0.441928942759635320832e22), SC_(0.880926163517870008945465087890625e-4), SC_(0.47167946924686267794681000601586718795332807589313e-13), 
      SC_(0.27727679237026680624547360688641283050751007274628e-29), SC_(0.574552528560161590576171875e-1), SC_(0.599083490669727325439453125e-1), SC_(0.326562033434624e15), SC_(0.59574348217068678836770193704601663452299198297862e-13), 
      SC_(0.30817991819236751066216748295709401603164490197841e-29), SC_(0.20504934709643312615865232140244245329085970297456e-17), SC_(0.73745083851314552802870354829278820574245401076041e-19), SC_(0.2719417170737870037555694580078125e-4), SC_(0.23633334716008312781302835692937431199979037634428e15), 
      SC_(0.40116172822941619726509594554900420026234064360422e-29), SC_(0.273342628705129491070976e24), SC_(0.13233334255616e14), SC_(-0.1860324374547417392022907733917236328125e-6), SC_(-0.41662640839102650251726859519844649467351936743988e-24), 
      SC_(0.41366469991877353664505423235416110752209856263632e-29), SC_(0.1080339869874636584075679427013641468012674864323e-29), SC_(0.31354745663454523796342954256033408455550670623779e-15), SC_(-0.55809874055512409540824592113494873046875e-7), SC_(-0.51464305863761418392864887639923614413758733102008e17), 
      SC_(0.42974403323689182985245685819973216614391367995564e-29), SC_(0.1226755567577137036837375827502683023340068757534e-15), SC_(0.73181544029618176e17), SC_(0.356656491756439208984375e0), SC_(0.57511100808304419237998619538080396492131651332701e-6), 
      SC_(0.43727979838159528482554219689363356095561935561375e-29), SC_(0.7798122348544e13), SC_(0.8588943201947652980736e22), SC_(-0.45831213261398661135397416775299529474035908904739e-23), SC_(0.52890106746769770489956114049541553965288744960747e-8), 
      SC_(0.44767214645416419053919245787147718165594030426536e-29), SC_(0.26553176031232e14), SC_(0.2085586588137791946752e23), SC_(0.790340763648e12), SC_(0.64331758941919291277431102504836936943662726638851e-23), 
      SC_(0.56396991515163736959758100092886750224006554485772e-29), SC_(0.164767579074269378772992e24), SC_(0.96442290460109492133966568871983326971530914306641e-14), SC_(-0.182207055936620593152e21), SC_(-0.16288586324488794352121434520748982365641475834901e-29), 
      SC_(0.71060984495908924431726061148159195715493970237986e-29), SC_(0.61842984e8), SC_(0.3555642664432525634765625e0), SC_(0.133759144e9), SC_(0.28834216749836541937606611695450951218706212147855e-10), 
      SC_(0.80490202086679616440767211156605911864354431197377e-29), SC_(0.263248904192e12), SC_(0.297980882347216843954978816e27), SC_(0.140897846221923828125e1), SC_(0.44824022549527823491543784090039049377556207542239e-18), 
      SC_(0.93229513968235881657927660254990574951111859851663e-29), SC_(0.366241894662380218505859375e-1), SC_(0.4340599750656e13), SC_(0.105478806095575292710985138176e30), SC_(0.24012124307552155152973805705552466780637562428371e-33), 
      SC_(0.98984072271443418184618106348812926220946298945177e-29), SC_(0.96973053952e11), SC_(0.1032632680728338890752e22), SC_(-0.34396671690046787261962890625e-2), SC_(-0.96271364111058320397683919234948561206704260148431e-21), 
      SC_(0.13796957375375282521258282185313922946375173684891e-28), SC_(0.603357184e9), SC_(0.56249721609616214201832207209008629433810710906982e-14), SC_(-0.58723545944948736e17), SC_(-0.58028697480534659570212041732835661494029465370265e-19), 
      SC_(0.14087878121271588812030448853437982084687159586205e-28), SC_(0.53508747383344354605481852928e29), SC_(0.62704322937005693765167776976277025369199691340327e-17), SC_(0.235499138513371136e18), SC_(0.22302880199358479320924395693872038333122707229792e-29), 
      SC_(0.19187669896268843882106199046212790333876075179759e-28), SC_(0.26183668812773328027354580171959241852164268493652e-13), SC_(0.5970707e7), SC_(0.3312188584361984e16), SC_(0.92017241034815941174045547113765004391798006057029e-17), 
      SC_(0.19696330564073048658818435820590984305819001943432e-28), SC_(0.32238440243425309843308409068705787565729120602853e-24), SC_(0.292186842467552253181952e24), SC_(-0.3806432217839128513100120064e28), SC_(-0.82513020195805722794885738700643372535526082646992e-37), 
      SC_(0.20092729076345475268161641680692456393259236283608e-28), SC_(0.5697601591236889362335205078125e-4), SC_(0.1162191569964638329110528e26), SC_(-0.16412856978298360348657569008246504688175448904985e-21), SC_(0.31839738515206016513063561009026484616216098410256e-2), 
      SC_(0.20426069933899679481125376462984716200236491481616e-28), SC_(0.3943929741312e13), SC_(0.23412235260009765625e2), SC_(0.10193842560436084643201024e26), SC_(0.21207853870411859766389282691659616682682417758342e-29), 
      SC_(0.22881844270846610652749196737333504046746971403743e-28), SC_(0.2179837304525471795325908264118197621428407728672e-16), SC_(0.86233940750171127054952112389596408092984347604215e-19), SC_(0.368157728e9), SC_(0.72529706319504487456480463098377420100634724772411e1), 
      SC_(0.27790564235134654243337661318427908127768828411199e-28), SC_(0.21656921296023725949679903214975529301966616912978e-20), SC_(0.16200692698475904762744903564453125e-4), SC_(0.1635257538336499151053522635820185529564874116204e-22), SC_(0.58938880546601329124832820085911559407364943754411e25), 
      SC_(0.38307908170359829668907275664710825900011835075561e-28), SC_(0.14482298173190688572731232852675020694732666015625e-10), SC_(0.28193880243627888738304e23), SC_(0.589604375e6), SC_(0.60047466992965579411135347476169935325115071814017e-15), 
      SC_(0.44431992244584514654678755926404518943295031559691e-28), SC_(0.48174394645500255940076463501836601110994706687052e-19), SC_(0.111553230384106831872e21), SC_(0.26075669569036418811408302358884491864634006858979e-29), SC_(0.41939587045610674859432459314508206490215441802069e15), 
      SC_(0.45190074381881787947113833644192369803258850957835e-28), SC_(0.903221837196690095865856e24), SC_(0.197033285648384e15), SC_(0.32623424794930855341590358875691890716552734375e-10), SC_(0.61845676096363676818434676933016847521984818056106e-13), 
      SC_(0.67043661646154515272860423358014245865689394675811e-28), SC_(0.27387009957888e14), SC_(0.11955467241431342253831366051651271417622290817867e-26), SC_(0.87310802944e11), SC_(0.28933511748345186860086749976012259395216961852377e-15), 
      SC_(0.72950579063556310785863719706888276620113808904403e-28), SC_(0.590493896484375e4), SC_(0.99392208896e11), SC_(-0.19527980804443359375e2), SC_(-0.16079545628777305110796074754669542322724883666308e-8), 
      SC_(0.94777901458212457182664258521518150736237789261152e-28), SC_(0.4428201e7), SC_(0.2530101420741656313673562390278253679619336276427e-31), SC_(0.26171386241912841796875e1), SC_(0.18205396527964645652297231995003573026647291521867e-1), 
      SC_(0.11153434660579423094016106021221904046901687488323e-27), SC_(0.750879536326465313322842121124267578125e-7), SC_(0.9310612177071408979145417106337845325469970703125e-12), SC_(0.31839368781345048800513961029245990630442975088954e-17), SC_(0.99763610438792567414792334839900304053722628109961e19), 
      SC_(0.11969815900999513257745596351318014772377229309672e-27), SC_(0.1668161242237629641861967998969556656319035425895e-21), SC_(0.2847195703125e5), SC_(-0.12113708519078755261729959946670476256258552893996e-18), SC_(-0.58469912606844089535572230231066119898125245972777e18), 
      SC_(0.14718026449967740426353456716434433271883469801847e-27), SC_(0.14995603510614981277719965857381914152826921874523e-28), SC_(0.1111803961616105472e19), SC_(0.508679587341021033353172242641448974609375e-8), SC_(0.12814521532382957625567079334028430774339053692899e2), 
      SC_(0.15284006704962108878625465914339150556459706251089e-27), SC_(0.1302969292737543582916259765625e-2), SC_(0.354480992801311143493632e24), SC_(0.37605104e9), SC_(0.18607859430748510805274307470148837042692731526225e-18), 
      SC_(0.16409516553343363785084154944027139734674650595365e-27), SC_(0.21342112026081242375155966654008687921617593019619e-20), SC_(0.78913960056218451777354516707418952137231826782227e-14), SC_(-0.1775841411699730088002979755401611328125e-6), SC_(-0.17015599078079798684750666220401593398087597887802e16), 
      SC_(0.18215559766104924690332214579658583558792903588607e-27), SC_(0.214253668673336505889892578125e-4), SC_(0.7301043754462531075178496e25), SC_(0.1068455829996046990704172685582307167351245880127e-12), SC_(0.11526214590948729311397784489864538809888995731212e-2), 
      SC_(0.20347543751535935665284243442334458135561822645851e-27), SC_(0.440987377729536e16), SC_(0.287391328125e5), SC_(-0.9624498046875e4), SC_(-0.12941824082139400213634919237534112886628905903587e-11), 
      SC_(0.21993065518257681430269719956396304729998221211967e-27), SC_(0.187684774264479346476449792e27), SC_(0.12580362244240480345597811588829353208161820898425e-23), SC_(0.22742198944091796875e2), SC_(0.28653876882240678152315201694479234788889731288981e-12), 
      SC_(0.24529570625501572181775218266146503325173309053089e-27), SC_(0.25641463683753128890529908445738982436523656360805e-17), SC_(0.48869192600250244140625e-1), SC_(0.58277403084650757214336531275763466589806549578157e-23), SC_(0.54865012310632304234244856782916104369657655425137e22), 
      SC_(0.27311316429626442094674415847188181871613594240214e-27), SC_(0.10845691548033613824e20), SC_(0.400673984e9), SC_(-0.570043214020987676349250250495970249176025390625e-10), SC_(0.10919983255480397150227388381021408564707003279548e-16), 
      SC_(0.37335468826546041784004659441927058513915150877657e-27), SC_(0.1305863312148020278771843072e28), SC_(0.19190377849874556560638664818693364076673812945728e-22), SC_(0.35540905350329594324527042329539745259270322463863e-24), SC_(0.45016943962136224233438107072525001952123968791903e11), 
      SC_(0.39141497594833019784983821157723932951078514835136e-27), SC_(0.357364711819011162112e22), SC_(0.667275905609130859375e1), SC_(0.1113973178760695906304e22), SC_(0.10731044892019837510186483399833963183503696610428e-29), 
      SC_(0.39262368958142762707121614333400562989589966094578e-27), SC_(0.37141335660505858048e20), SC_(0.94974504335262194265609991816745605319738388061523e-13), SC_(0.95415474769800466547930994920534431003034114837646e-14), SC_(0.21521859153131137835830879033751142752868026118185e5), 
      SC_(0.55263283825603576259688637477087526891102295303199e-27), SC_(0.14570690537170526341649579027404115549870766699314e-16), SC_(0.12941088853490731622934705547460304161866623869764e-26), SC_(-0.1672545540175947482997020898665141430683434009552e-14), SC_(-0.5848805184248221012929348390290312121931490384609e25), 
      SC_(0.56127809703514701593677302775789618452802567406812e-27), SC_(0.9228809556838246663801328395493328571319580078125e-11), SC_(0.86422194270699415064029835775727406144142150878906e-12), SC_(-0.562820141665652672823296e24), SC_(-0.45778174553622802307533432403667235723940695422331e-17), 
      SC_(0.60846516215783285252980856413082379488997881219342e-27), SC_(0.132249495194510903163748352e27), SC_(0.12553589416499227737881426975438926936441333025911e-29), SC_(-0.18909737802843239184991119827827787958085536956787e-13), SC_(-0.22324611373365460783950827801522919902882544645988e3), 
      SC_(0.70854346356424203118456450594757848872274827445317e-27), SC_(0.17661992750974924766497868057479880832261187606491e-19), SC_(0.13503679168512e14), SC_(0.99978050734272746818492337364912077787941683637389e-28), SC_(0.40708318789691990117035501094747887529655008140322e18), 
      SC_(0.95094302859126114224783559857815715520763821290429e-27), SC_(0.24968204839583968605398571483089398270749370567501e-17), SC_(0.9045842452906072139739990234375e-3), SC_(-0.3141900802028363415274725412018597126007080078125e-11), SC_(-0.2449539203496388975798784873357620168741296674017e15), 
      SC_(0.12077864904222012060382706089847400011033683522865e-26), SC_(0.3538321875e5), SC_(0.13553274662644757345142387805481121176853775978088e-14), SC_(-0.46783368374000422384529373153595852453251469071915e-23), SC_(0.32058124445420069844687161314261210407880181015443e16), 
      SC_(0.16793731632787596740420928687663819571897812904515e-26), SC_(0.3518738464768e13), SC_(0.98092148011034996368806559985387139022350311279297e-13), SC_(0.7575111198086004736e19), SC_(0.65039496025983965665832815009530617268807417944382e-23), 
      SC_(0.21755331614817437617422269623130535179188855751664e-26), SC_(0.2500394162552321830617074738256633281707763671875e-10), SC_(0.72982407463299740342380286062361920775211799206766e-27), SC_(0.247376342155264e15), SC_(0.4709775015194030811246957863705675568998476920662e-7), 
      SC_(0.21971093546487139650040130832038324586684679279314e-26), SC_(0.63975672837429094514688e23), SC_(0.4539182297546489856e19), SC_(0.84259974327325996997237890661914493965691137777885e-26), SC_(0.72996868550237370924565332261049662117667604966241e-7), 
      SC_(0.22982227952519826732488902867652779863117686563745e-26), SC_(0.33525770516606100656031852480509769520722329616547e-15), SC_(0.2606888e9), SC_(-0.99916063843772263862794266384148578197255119448528e-19), SC_(-0.54923986434781063090698390941147979292728868719051e12), 
      SC_(0.30925962897528140638428209777131250534488266998312e-26), SC_(0.31183890647663858874949482924421317875385284423828e-12), SC_(0.3378834198657619609917574050322202662555159946578e-22), SC_(-0.194349398430869870379794432e27), SC_(-0.35519121360496594488824546721514240372537441259534e-18), 
      SC_(0.31280255044167672158720534423471231179079217639416e-26), SC_(0.11511761115021312e17), SC_(0.152494848e11), SC_(-0.42399032147968e14), SC_(-0.30751500494692020409607948030330780776185524378836e-20), 
      SC_(0.38344456302173223195286237326130017242619817813276e-26), SC_(0.1287535325337014953720268054032123824574619620157e-27), SC_(0.13705567485615801022446745431989965211687137938007e-26), SC_(0.1571656949818134307861328125e-1), SC_(0.53674187831070133121718983787847933752259275058477e16), 
      SC_(0.42244364291200267661460233749011480646438909669627e-26), SC_(0.477498138427734375e3), SC_(0.17728046030944125033074269511337850424581574770855e-19), SC_(0.13287486274745846826646551445217506469372131620437e-29), SC_(0.74967099308934474834018743849676453308904253460129e23), 
      SC_(0.44974670432440498891960159215184658369128360699829e-26), SC_(0.7166851806640625e3), SC_(0.1690176772380537639327398519769468654416755271086e-22), SC_(-0.13255775939261839335703285769341164268553256988525e-13), SC_(-0.92291020959456172138416167756711444546699678378756e14), 
      SC_(0.48457483625271488463909528606996389233426292958429e-26), SC_(0.34402809559391418553704811749276853293953368218006e-26), SC_(0.3426654976e10), SC_(-0.8123994140625e3), SC_(-0.21276722575609983508506693538149322464940493370722e-5), 
      SC_(0.51977933341075693398899317919762114747383096799438e-26), SC_(0.266911591494591876579813490688e30), SC_(0.53580234866956732986409406294114887714385986328125e-11), SC_(0.254200357322752e15), SC_(0.69110368402320022163407013192490694398911620896064e-27), 
      SC_(0.58142380573592359976870182103182017051176385183386e-26), SC_(0.37084538151638864883485879886393377091735601425171e-14), SC_(0.369338253312e12), SC_(-0.415793875e7), SC_(-0.29594443532795804955924762850953266350160249353608e-10), 
      SC_(0.60865414403362585004788968196643994088311036341765e-26), SC_(0.123742392e9), SC_(0.10912435391066719332460695603753930316446923640128e-25), SC_(-0.21994551145136128e17), SC_(-0.49089646351075138912034407328455569366471571417599e-18), 
      SC_(0.65415581823232869460973666676192176842397421610009e-26), SC_(0.6010023046875e5), SC_(0.234649834188006464409305088e27), SC_(0.9448992204852402210235595703125e-4), SC_(0.12908899786201586710341222112186672810536915287797e-12), 
      SC_(0.77196710997203362544532626020513746761754665659527e-26), SC_(0.9461145951093060124066579601815525318148601685575e-25), SC_(0.12432433352443051997396992e26), SC_(-0.5228e6), SC_(-0.58320270863535593455030526710289059054679659475945e-16), 
      SC_(0.92003714929119307170488305653901118029522766122996e-26), SC_(0.207550390625e6), SC_(0.2457815154404734489393749563568292160198325291276e-16), SC_(-0.60690097317509052778401497088e30), SC_(-0.28894533691941038650796939790571157096636712776553e-30), 
      SC_(0.11635736870608811874540057457479948586226165679891e-25), SC_(0.17671186639527258161297881214290347985361303510387e-28), SC_(0.22745186078595230213685116928e29), SC_(0.15040896827392e14), SC_(0.60417643323129282335411977676602262754782289036307e-25), 
      SC_(0.11837831633021164326650292224515978315498715423004e-25), SC_(0.27219574150194603134877979755401611328125e-7), SC_(0.15386248307178551019952166983379913769903023636025e-28), SC_(0.87460832e8), SC_(0.46759013370870059772614259918741759451044911410075e-2), 
      SC_(0.17550213803783570336671080151775868003491756774714e-25), SC_(0.5815067891204096e17), SC_(0.8830627750050583805952e22), SC_(-0.11121447374743291820226533572930904814057839757879e-20), SC_(0.15769698742831680011244511894063175456041078597779e-10), 
      SC_(0.21288901426793981534691419438692370107505096726852e-25), SC_(0.5289344906157640122368e23), SC_(0.11510209314816e14), SC_(0.4249272918701171875e2), SC_(0.92648999418099558750700023051939135561434274409392e-18), 
      SC_(0.22996534145332723997852573283005889220225251290408e-25), SC_(0.2971597882982735143010211229658290577049228886608e-20), SC_(0.18105871401684113750600804327424580317078273150599e-24), SC_(-0.52397229666212297161109745502471923828125e-7), SC_(-0.6233022963855150137392227864366754483789628722974e19), 
      SC_(0.23262787026796459560488491232047662116274797106108e-25), SC_(0.6551325321197509765625e-1), SC_(0.16290072103687030632445066548764228686607680174347e-20), SC_(-0.71544082024462842504808346433264887309633195400238e-16), SC_(-0.98858559565543721166704848282937720760724555227602e18), 
      SC_(0.27826294978205525521980137859608542144911232096849e-25), SC_(0.87440356429873925658498856170228582591246249688943e-25), SC_(0.897631640625e4), SC_(0.36269013671875e4), SC_(0.28820549055264756824493461253302827935710287805982e-3), 
      SC_(0.34919368622379363366113344149995795887854964367758e-25), SC_(0.253342638931968e15), SC_(0.7562174072265625e3), SC_(-0.13358971904e11), SC_(-0.12750020412892674391569363800760250228302398440321e-15), 
      SC_(0.40640597744934306582748730017532743697978442343199e-25), SC_(0.143180119991302490234375e1), SC_(0.7372973065411514426159556023776531219482421875e-10), SC_(0.25642714125858165256502331187864603249699103210135e-25), SC_(0.16806840183003004103311088621594719873834403266311e19), 
      SC_(0.66556817034054791977215246744979717646037778444601e-25), SC_(0.3026203967488e14), SC_(0.89236039341428712414264201591151959291892126202583e-16), SC_(0.12883867020718753337860107421875e-3), SC_(0.62189172419008455881321301576823244222445688480495e-1), 
      SC_(0.85862603804552791851901750144015928773062740209099e-25), SC_(0.100811407958566250167576559616e30), SC_(0.4642501040129231797912992205090709774140123045072e-18), SC_(0.6697769276797771453857421875e-3), SC_(0.25597760155920837386398004521369053843545906300128e-9), 
      SC_(0.10089998747641633763059998585889530904667436839173e-24), SC_(0.694304406642913818359375e-1), SC_(0.12026698098510906626001926156277477275580167770386e-13), SC_(-0.15574649983556515459174837338982445161805756583817e-21), SC_(0.21070067754050388417150557140030549089180888347646e18), 
      SC_(0.10332494589906572792043563946857459391668980497325e-24), SC_(0.363202080623525101568e21), SC_(0.31611702310388430456632212831036277123075706185773e-19), SC_(0.3834788709626559462375424e25), SC_(0.19494480412558630536765884383661183190812241864799e-32), 
      SC_(0.11061723157371115940205422633821341626969569915673e-24), SC_(0.46915519457248313591588473499272016198347046156414e-19), SC_(0.292094455289770849049091339111328125e-6), SC_(0.155271419401486900365614907392e30), SC_(0.57608762536920856390418378494213938082655486152011e-24), 
      SC_(0.14044194233643483429544463937103636612564738772591e-24), SC_(0.11511007425024644135191920213401317596435546875e-10), SC_(0.51712110886912e14), SC_(0.154647670346963546147209084928e30), SC_(0.80304305292253510634817499564421455993777835379657e-34), 
      SC_(0.21315088219210617005095987448538579660858166553439e-24), SC_(0.95683287681946893599160830490291118621826171875e-11), SC_(0.3115958984375e5), SC_(0.1778788089752197265625e1), SC_(0.13058169388077874810114041226751401624143738160404e0), 
      SC_(0.32135673854187971346020288041515339098365411363289e-24), SC_(0.32434747971540767529127381233219938105394927058134e-26), SC_(0.697133984375e4), SC_(0.2589941282271635003553456044755876064300537109375e-10), SC_(0.23039925225726596658297664671720758993009085642785e11), 
      SC_(0.35477071711955241575497882018697768801047953690642e-24), SC_(0.16799917719768968541980944488815402358444957287009e-26), SC_(0.2391704532426279666843648e25), SC_(-0.9987537633480230838468608e26), SC_(-0.11170439213945264439860192238802450754200316519462e-35), 
      SC_(0.63171350201374448567926894124993295043246632758382e-24), SC_(0.34594001439795600424927311319582115491182941913878e-27), SC_(0.63795086741914598182229839666991088459324643622494e-23), SC_(-0.12552908898662657608504726670096805643886406222975e-23), SC_(-0.95629214294281547762205671403056105369715614300042e36), 
      SC_(0.67408622876536618485544101470642653945071487431306e-24), SC_(0.2471692337152e13), SC_(0.132961654303503394275328e24), SC_(-0.6788451e7), SC_(-0.33286094625146253776290000962519139005436578926647e-23), 
      SC_(0.10695072441537967968227132372606381829210908662731e-23), SC_(0.35285359539881765141448911825262056696228540886295e-21), SC_(0.118697354167807134217582643032073974609375e-7), SC_(0.71003743825541563300385305979034455958753824234009e-14), SC_(0.35089989988978881039717099704028606373920726973772e20), 
      SC_(0.10793397050840846405918406985643934908360164204311e-23), SC_(0.1113690125e7), SC_(0.75714901237548921923889924164984433635483540570021e-22), SC_(0.1261075439453125e4), SC_(0.6676061172726403023950098474250977274537751230218e-4), 
      SC_(0.14055776683884390935377421641763401121381915626074e-23), SC_(0.23893704704e13), SC_(0.829389522038503243776e21), SC_(0.1426357962191104888916015625e-1), SC_(0.88635117902348692092144299129333228841677282906924e-15), 
      SC_(0.14272539883421020559268456416931805121571519290313e-23), SC_(0.36702409422429027827712e23), SC_(0.325886788778007030487060546875e-2), SC_(0.45193252206280704e17), SC_(0.78763062610517413780038390821520112762583412544418e-26), 
      SC_(0.1809900535358029636909945199492450026643175498009e-23), SC_(0.4521496521192602813243865966796875e-5), SC_(0.8669365225699721122509799897670745849609375e-10), SC_(-0.3707945239739274256862699985504150390625e-7), SC_(-0.14189342419296741566740455781008734607151058394391e12), 
      SC_(0.22979825824841110086247763680828023157010076005236e-23), SC_(0.93045377009959233280039386363886244165766006039391e-29), SC_(0.65658354476458128962806926054440737061668187379837e-16), SC_(-0.9890375e4), SC_(-0.37314934922703109150578387792499853099108043778131e6), 
      SC_(0.26973976499394821796760860105960760360263583912399e-23), SC_(0.238645943284598871514390339143574237823486328125e-10), SC_(0.23768503319901658006414734019219381138884883419848e-23), SC_(0.527652234461184e15), SC_(0.18190765247531467187582066782163346977401040810669e-7), 
      SC_(0.28816079125764878356579517477216619003588249370296e-23), SC_(0.882377426023595035076141357421875e-4), SC_(0.1577473308204273238016e22), SC_(-0.42506787746007220974913256138199158917084785613838e-23), SC_(0.2260606231678334898572932268877987581753719916506e4), 
      SC_(0.32599065541056766574490488870673046781917259195893e-23), SC_(0.192923329050787834358224912384e30), SC_(0.3097524677286855876445770263671875e-4), SC_(-0.100986093568e12), SC_(-0.12548493178296809708310951396530810777296967298351e-23), 
      SC_(0.34268145332932435562498678286384018714522126103361e-23), SC_(0.5212696875e6), SC_(0.3849909631451136e16), SC_(0.508418523136e12), SC_(0.72162014414273809333019650903497394748188629754886e-18), 
      SC_(0.56386042011206437624858452043569937567335514927436e-23), SC_(0.7681872205185024e16), SC_(0.23590024284203536808490753173828125e-4), SC_(0.20797140896320343017578125e-1), SC_(0.67249380302320973888478353771861280397144005879171e-5), 
      SC_(0.62349810733154656348475984703893669394009213746699e-23), SC_(0.3186756486421025349175685783759132587948386466284e-30), SC_(0.206639827322404864e18), SC_(0.5590021601165062747895717620849609375e-7), SC_(0.22500957165169082814761536290836745381917410205781e1), 
      SC_(0.63670474329021361052387975964176193132554315567972e-23), SC_(0.28074016939545422987264e23), SC_(0.17556869315576290047076213340915273874998092651367e-12), SC_(-0.1531524209357918723637248e25), SC_(-0.48982349819810203820904390481783758594463100466212e-33), 
      SC_(0.79077168410563814020679685421361419447872087573614e-23), SC_(0.21161119528926488937912315394561157356168786172334e-29), SC_(0.142681614079265273176133632659912109375e-6), SC_(-0.2962966449558734893798828125e-2), SC_(-0.5388142830829322167770886578711317078175280130675e8), 
      SC_(0.10530228911339364457321075924690629687513476753224e-22), SC_(0.483472707676213598935318528e27), SC_(0.44314850564982699138972646468012326028093886742722e-29), SC_(-0.15681767604224e14), SC_(-0.36835976310730676299394417367344677807328340135985e-24), 
      SC_(0.10594830308589723556089853200358767617433874974608e-22), SC_(0.32064444894785992801189422607421875e-5), SC_(0.86973574563961136555481660599328536803698241897109e-22), SC_(0.416365146520547568798065185546875e-4), SC_(0.79620513846799906888063680407815759196684641264128e9), 
      SC_(0.12363192189691982984868135714653404610974263277967e-22), SC_(0.35982240840770946433031796107826494335313327610493e-16), SC_(0.322920703887939453125e1), SC_(0.17277019497651336450993801928633292653556531673917e-28), SC_(0.58833909586422443110978922402391149473021618837133e21), 
      SC_(0.14850114058724673309995269779678521773758070878557e-22), SC_(0.88135538909447823165237586283144582965931590479158e-21), SC_(0.1617057321379178347342531196773052215576171875e-9), SC_(-0.8139933688528896e17), SC_(-0.41247833740064166396959255912190940026246123128608e-10), 
      SC_(0.22156699957340918412056171273583613824664784175411e-22), SC_(0.29634864404215477406978607177734375e-4), SC_(0.119116396494848e15), SC_(0.6916903633158144e16), SC_(0.89869667124025102871982743442548976065877351596674e-21), 
      SC_(0.24417406495470620949839827231771108642655043752256e-22), SC_(0.523734033203125e4), SC_(0.183467209339141845703125e1), SC_(-0.12311917978180542121435792068950831890106201171875e-11), SC_(0.10021776510098977430056989669428609195606706400045e0), 
      SC_(0.25335998731998849030698736206528910198942927678445e-22), SC_(0.99404931640625e3), SC_(0.204871795654296875e3), SC_(-0.17732928865033286806667264e28), SC_(-0.12038609899020735067631573133766711736365792216423e-27), 
      SC_(0.26358550214060722931322024418533938455722065441478e-22), SC_(0.4537445192909217439591884613037109375e-6), SC_(0.16901493831299083657975146245536820360788610173586e-21), SC_(0.3449957335950946027262366266885607046788209117949e-18), SC_(0.53858834605867315707828660767349440373027075024073e23), 
      SC_(0.30833663466070896382006111161955350802310604763079e-22), SC_(0.14264230850949372902972644950540109798353682890593e-20), SC_(0.39928437914112261306202108102764158914510517206509e-19), SC_(-0.3631383378888131119310855865478515625e-5), SC_(-0.1213112071190513079582770219354688035523822648048e17), 
      SC_(0.32152307578020235295696248397110750608107743175879e-22), SC_(0.77171333762843762060779084777095704339444637298584e-14), SC_(0.1759927888961148057063232441957212337513283273438e-19), SC_(-0.2195341448531573712125986030940794080379419028759e-15), SC_(-0.83912492088792002835980756398061311778687126536753e24), 
      SC_(0.35030939907262229474824187104684165838808240778235e-22), SC_(0.23553908385443359223970771765266363217961043119431e-16), SC_(0.21413030105610117647127543808e29), SC_(-0.174636600070766592e18), SC_(-0.46589433163832845716014527870522458470408394544791e-29), 
      SC_(0.40076885532064810604093087225601246825767987047584e-22), SC_(0.3082144530708319507539272308349609375e-6), SC_(0.3078387737274169921875e1), SC_(-0.306541058685140992e18), SC_(-0.52681800193790643826848396355296715809602729336734e-16), 
      SC_(0.47393636692305733664278524253798572860030269282561e-22), SC_(0.104557464599609375e3), SC_(0.4436923e7), SC_(0.27618875085853910114619402804692072095349431037903e-14), SC_(0.41627799504720195545327833769503897199882913521632e4), 
      SC_(0.63232212397934060070738019807261992566438379981264e-22), SC_(0.19656669921875e5), SC_(0.85838680267333984375e1), SC_(-0.23773043214411204929354878517112583573636652722882e-24), SC_(0.31955335590579409935215491096676679912082946876264e10), 
      SC_(0.70129216981394124517358319359700870310181386457771e-22), SC_(0.448211761474609375e3), SC_(0.2475014486984922284531527269369312674318628353376e-22), SC_(-0.15927880178899761053762373919084893714170902967453e-15), SC_(-0.67122396948539779453030130850570885552245981802717e16), 
      SC_(0.70776411089811926138706988062315912657584959788437e-22), SC_(0.59599255416864768e17), SC_(0.5230804920196533203125e1), SC_(-0.3854616915607552e16), SC_(-0.56932133994575562834803573946131249800277946647555e-22), 
      SC_(0.71863877935764437100797607417958061393203905709015e-22), SC_(0.174722980453023744e19), SC_(0.13073324703744e14), SC_(-0.26683298312969198105526272e27), SC_(-0.61987281823410613133111980521521492695625553531713e-34), 
      SC_(0.74762051927350566184369205465550661804385867981182e-22), SC_(0.26862682123178615729311180857336192916092225055347e-26), SC_(0.84223014588956526247936e23), SC_(0.1301752750835069196141448711201873228266493351629e-28), SC_(0.77480252682128625415386515944756210480090439704723e14), 
      SC_(0.92533743902997465556179028455896593691187845820423e-22), SC_(0.149624073505401611328125e1), SC_(0.8923663750663950598930432e25), SC_(0.102209814528e12), SC_(0.12937126487114329796907026194641071171060108535892e-21), 
      SC_(0.12289824338974083826108178981784992134240752648111e-21), SC_(0.698235158528e12), SC_(0.12468150316635728813707828521728515625e-5), SC_(0.10894201096789402072317898273468017578125e-6), SC_(0.12957615412040305231117322381745422132654264610854e2), 
      SC_(0.16709281876399104451896857451468573346753387909303e-21), SC_(0.105505156605401800151924736e28), SC_(0.36789907058298876307844693656079471111297607421875e-11), SC_(0.44886589798289497496477628875480243896348153676001e-24), SC_(0.13623440271665848922782542124576786747468037928652e5), 
      SC_(0.20480137977551409171276012694776647721228712839547e-21), SC_(0.52543687780784082447767556304253063949231234656262e-27), SC_(0.74365346526107147718978422623603563579308683983982e-18), SC_(-0.483856461841458695971596171148121356964111328125e-10), SC_(-0.39426565357138534357827502672260590696117791350039e21), 
      SC_(0.24251573418152508201725062311543065773911109772598e-21), SC_(0.15525652356389520625679773191407662125129718333483e-16), SC_(0.5536424766614160801792e22), SC_(0.55148544815829756735230559840777881519665801213215e-25), SC_(0.32091940865145284106703658946942174547858789512328e10), 
      SC_(0.33101343219058390575744884635968519337456683615528e-21), SC_(0.865986066855839453637599945068359375e-6), SC_(0.60807995981824e14), SC_(0.26816164712173073564413156940593807307003537187008e-31), SC_(0.27974902252196859786372864954767558421438937439356e9), 
      SC_(0.34232852484893752715336362962101832141392776520661e-21), SC_(0.28644704009199202239603918686080641793337820138912e-29), SC_(0.3675726848e10), SC_(0.12510508e9), SC_(0.13723028519686398282851688320405757273703039656552e-10), 
      SC_(0.34863327790830662300885857654195697230559147783424e-21), SC_(0.941622257232666015625e-2), SC_(0.1611729536e10), SC_(0.9274045452659739329501556448498433837812626734376e-17), SC_(0.39566873514712382541406214119913485568723205675036e6), 
      SC_(0.3591942195412689571187997472948797567093848215336e-21), SC_(0.20276001953125e5), SC_(0.23067565607429071342632211210292164463707216326199e-28), SC_(0.2583940140902996063232421875e-1), SC_(0.19204953652332429821075894150537070676350125552163e2), 
      SC_(0.37816734667556745747025163289015137202397909277352e-21), SC_(0.24983507829808709876928674020746257156133651733398e-14), SC_(0.3642084375e5), SC_(-0.1355347072e10), SC_(-0.27196824430587986423806969973687296096265940478318e-9), 
      SC_(0.46752986342868921380058106921978264280959081133915e-21), SC_(0.528067822154870882224308224e27), SC_(0.5685052480451848618115072e25), SC_(-0.59099866506205789543864529183945179702415473332877e-24), SC_(0.10198893064940502169045368957140475383349715793657e-13), 
      SC_(0.60174052366059316378553368571567225298046821535536e-21), SC_(0.10303296875652080092595762343334930266343200944146e-25), SC_(0.308824435098386432e18), SC_(-0.3148147e8), SC_(-0.5787851854562533682141642804720155538631133058382e-14), 
      SC_(0.75804509525494787096890253236172035888884579435398e-21), SC_(0.8845430532586596087103488e26), SC_(0.19398925304412841796875e1), SC_(-0.68091676439507864415645599365234375e-5), SC_(-0.16442983983143540066860704436157929741482495709281e-12), 
      SC_(0.79665469950330159961492980445589562332742161743226e-21), SC_(0.83213808566272e14), SC_(0.56174552729503315386117012764088940457440912723541e-15), SC_(0.13703472901716443136e21), SC_(0.83919271962645325476931765438895923092890437515712e-25), 
      SC_(0.96362472102334232055222076765519517715929964651878e-21), SC_(0.229194643907248973846435546875e-3), SC_(0.354709317473833607436972670257091522216796875e-9), SC_(-0.33682246752230244661008495496185190790821087358786e-25), SC_(0.1973944260376198272439270856288928262653812051008e19), 
      SC_(0.10655219220160638660658204061957438080199267460557e-20), SC_(0.4329301314592003063808e23), SC_(0.235037732322388428860686336e27), SC_(0.32667630938933585991669946822042821870520724674911e-27), SC_(0.23602272875316702306441670462110405333561131223386e-12), 
      SC_(0.14091959785120442850992498264083366277255038312433e-20), SC_(0.128396337300146092061566697472e30), SC_(0.31356214050816e15), SC_(-0.38295224717969824478792493889972690038039687589894e-27), SC_(0.10393796341126502848144071691816713657763034488644e-9), 
      SC_(0.16876090995538029053498222195215869301243571953819e-20), SC_(0.557600690481998400170491904e27), SC_(0.1795816235244274139404296875e-1), SC_(0.1630057900403404570624e22), SC_(0.2114060533267693219940512933825497532721225959918e-32), 
      SC_(0.16957562025474358445523368203906866558128285760176e-20), SC_(0.11310173639817380151408195664008982106452094740234e-18), SC_(0.15127345e7), SC_(0.6789177e7), SC_(0.10641855692615552707664083478942417992486945142603e-7), 
      SC_(0.23540851394404172234472420613491522312088477519865e-20), SC_(0.11023617015640261193574593543205827068633346002557e-25), SC_(0.448969248e9), SC_(0.78396986663444566392866475547677659885259515704092e-21), SC_(0.12156371321704405372177687766545701550937262774687e18), 
      SC_(0.2396832969158041061126381509032573502437912793539e-20), SC_(0.91303257931940606795251369476318359375e-6), SC_(0.62647392985281462272e21), SC_(0.8292595739476382732391357421875e-3), SC_(0.59273041561316941749338662692759842094526004174294e-6), 
      SC_(0.24141449950396592978032251394348434159198291126813e-20), SC_(0.18448819419086848e17), SC_(0.55460104261295954577309919031335994077380746603012e-16), SC_(-0.5924556271255552e16), SC_(-0.14040633787027708168907065281533134041530653230269e-21), 
      SC_(0.27589042212186362242123678200494962808875243354123e-20), SC_(0.16342684e8), SC_(0.10564504593401150001064081607182743027806282043457e-12), SC_(-0.38404155731201171875e2), SC_(-0.33731571461048716678767845378048804924400059939478e-3), 
      SC_(0.32517390764125836699536241120728208287005145393778e-20), SC_(0.32148523727519219712e22), SC_(0.60515264161661452673922225736467336588411333742066e-25), SC_(-0.19435005935616e14), SC_(-0.10774119959550489880494328789835313204223260188677e-21), 
      SC_(0.45554803310630748334844562492766673056365789307165e-20), SC_(0.11976841560564506196590386921663196062581846490502e-16), SC_(0.17776739501953125e3), SC_(-0.133709103104e12), SC_(-0.39443298300209577370446816065183322691280635216556e-10), 
      SC_(0.50936808729767273907694413617557038786998191426392e-20), SC_(0.6635618708750336e16), SC_(0.1165913989179818382232387584e28), SC_(-0.34306954063749667618865579754583450267091393470764e-14), SC_(0.22437814945454641629039665333729669609984304587835e-16), 
      SC_(0.5351417507930536367833561318604895795658649149118e-20), SC_(0.1111488176928805879808e22), SC_(0.286732616424560546875e2), SC_(0.4134069531147588349995203316211700439453125e-8), SC_(0.41054204043107208572454374473593992088110102327675e-6), 
      SC_(0.8022529108706313066889313475107958772980509820627e-20), SC_(0.15554543059386610748262569359212648123502731323242e-12), SC_(0.1855688655151038464e19), SC_(0.1087248221077504e16), SC_(0.66334090751607720724294127497788518724565684316049e-22), 
      SC_(0.18673345450030310831705831391483241255002667458029e-19), SC_(0.16140768350376832622251404282443946390469477480956e-24), SC_(0.35751782069791464758326094786154009108614104661683e-22), SC_(-0.33426269598555897417832754399315969839889817194489e-20), SC_(-0.19501514976027199276075970653574148237237843356341e32), 
      SC_(0.19864569542637633100393889035509276119739752175519e-19), SC_(0.6342787072e10), SC_(0.22447013671875e5), SC_(0.14114877442359296e17), SC_(0.20445336558477412082751152439615217306965941003306e-19), 
      SC_(0.21109476364529939751075359117074570214356299402425e-19), SC_(0.8756801014807582267041677127782781970980266472715e-25), SC_(0.19232578752860259808180970650021732008816410797181e-22), SC_(-0.128383655936e12), SC_(-0.77558438573112714615319148185209517084593174787914e0), 
      SC_(0.44545595303495604738852208133448318250202646595426e-19), SC_(0.19550562611967553516834072979690972715616226196289e-12), SC_(0.18799281123449514653822470500968856016443808698568e-21), SC_(-0.1141028984375e6), SC_(-0.53341932867975116606223201954549855219434719308155e3), 
      SC_(0.48988976909583188869227858043553514022505623870529e-19), SC_(0.20838384443777613341808319091796875e-4), SC_(0.15278292e8), SC_(-0.4315188e7), SC_(-0.24580064922065191728605791899716827200685867274697e-8), 
      SC_(0.59220483766176692878700381014733800100202643079683e-19), SC_(0.170295034922225631232e22), SC_(0.11738591232e12), SC_(0.357994224542412808887092978693544864654541015625e-10), SC_(0.5570355258929566719050106981498655214839625337254e-10), 
      SC_(0.66987496460547948918295480848217327007887433865108e-19), SC_(0.11343607001819294972258894083203810348232010076636e-27), SC_(0.865987129509449005126953125e-2), SC_(-0.23070771996939919337765994496e30), SC_(-0.29465261373203272668937214694852909417347758078722e-26), 
      SC_(0.68420748430509458628227944729238707566310040419921e-19), SC_(0.2356455859375e5), SC_(0.4488765904371071685042063337256479371717432513833e-17), SC_(0.89581251356119876105976700758048657674355763798346e-27), SC_(0.34038212894914778555701304844009055705590488570062e18), 
      SC_(0.765393322722613581412295230554931890765146818012e-19), SC_(0.50400686450302600860595703125e-2), SC_(0.9949530111868928e16), SC_(-0.5452569894273144049369088e25), SC_(-0.12383048869732072603641424387510064110009830509567e-30), 
      SC_(0.77559465687389450662322107690749284358844306552783e-19), SC_(0.44456448e10), SC_(0.205457109375e5), SC_(0.261885425731146261350229999616e30), SC_(0.1293487284646541813888039639818870721733813583309e-32), 
      SC_(0.79555820859346433961923283038897292129831839702092e-19), SC_(0.504025510381092864e18), SC_(0.77791009521484375e3), SC_(0.8640740297015296e16), SC_(0.76745730373666138656321456001439798928453136369171e-23), 
      SC_(0.855830077692287144095867031448610084964911948191e-19), SC_(0.1095691093411232941434718668460845947265625e-7), SC_(0.25149885914288461208343505859375e-4), SC_(-0.8668230625e6), SC_(-0.362730674616372320893362617779845806049778536958e-2), 
      SC_(0.99617012202940202076213412410443659439351904438809e-19), SC_(0.2204087310138598244745216e25), SC_(0.3795443262788467109203338623046875e-4), SC_(-0.2224682373046875e4), SC_(-0.87529286389859507044137773984211311214700340581471e-14), 
      SC_(0.1032382861400751813967549509395982276771519536851e-18), SC_(0.30157555913250196121325186204842339066090062260628e-16), SC_(0.20796434360740761083994803121731046293210742881286e-24), SC_(0.32496745967566525915920276830365278017691450795912e-25), SC_(0.64064009565442704092650504115089752656148580147586e31), 
      SC_(0.13074397374967548717431355988216612473706845776178e-18), SC_(0.31626431251652320497669279575347900390625e-7), SC_(0.422266894020140171051025390625e-3), SC_(-0.280081402699882469066092314624e30), SC_(-0.31984168666076823129750768694111356366386582599393e-26), 
      SC_(0.15449182507288713721863232866682302812932903179899e-18), SC_(0.133974442650952596522984094917774200439453125e-8), SC_(0.38424594277974055189327670217216623149703025319468e-21), SC_(0.652243981047462284550420008599758148193359375e-9), SC_(0.14479638868766345890465563414817157313496228971606e16), 
      SC_(0.1581975683677305589199413998757748345269646961242e-18), SC_(0.404438793566441745497286319732666015625e-6), SC_(0.18932908561168947981796090163086887514509726315737e-16), SC_(0.25596845038945945071386624e26), SC_(0.24310538829610847936752095264592812420662326309052e-20), 
      SC_(0.16677509527778160624086499150275919589603290660307e-18), SC_(0.50082130538252574789989333416135111329551950562359e-29), SC_(0.27393523857242675896004658903787332135948417999316e-20), SC_(0.69138784823058101751085119520898181200152521341806e-20), SC_(0.1382336801632085910261950405113206345876694297117e31), 
      SC_(0.18734172628738795211714510124956234449200564995408e-18), SC_(0.63174750153383030237819184549152851104736328125e-10), SC_(0.11239923698099365924906019645674659390465692499866e-29), SC_(-0.12493665475495438732114079503739715479396785516308e-25), SC_(0.71979531950769210186332161695236496779160461744228e26), 
      SC_(0.20581069188704517551523841788208013525718342862092e-18), SC_(0.79597584432992412060764095271814255738718202337623e-18), SC_(0.75974287571611502022633594876763844865744160884209e-30), SC_(0.353654027201034584064e22), SC_(0.20361005699679254438574738763998872382712274825469e-11), 
      SC_(0.20609658618625881570536584851127681616844711243175e-18), SC_(0.827880703125e5), SC_(0.1740015537225728e16), SC_(0.53243269389726412383234783131345790874178192098043e-20), SC_(0.14027726109006742105342456541540514539299993472965e1), 
      SC_(0.21615742888037643762213775404379401123833304154687e-18), SC_(0.22357367204300679512099339784098384888095444001863e-27), SC_(0.22890954226473139536401912863539109821431338787079e-15), SC_(-0.18357486856244363992582619479060346279197801777627e-19), SC_(-0.87018025858581000318689585970087625982626945817888e27), 
      SC_(0.22622955483503716568203720238550147314526839181781e-18), SC_(0.85913526136044117637383110697157917456934228539467e-16), SC_(0.6036870791327383552e20), SC_(0.5586347360256e13), SC_(0.23372306259719240017221166207655887209227135601964e-20), 
      SC_(0.22715338633228818618429436723693548572100553428754e-18), SC_(0.20493523314995077838798848e26), SC_(0.89597177734375e4), SC_(-0.17672784097547503280980010775813582313276128843427e-17), SC_(0.1741283841009750289852896743470165528364338969169e-5), 
      SC_(0.30420727664434581210352358596193944606511649908498e-18), SC_(0.28656053473241627216339111328125e-4), SC_(0.94969911521617292598785838378394608128019171999767e-19), SC_(0.29194834483964315907655873161274939775466918945313e-11), SC_(0.15909034235537062513712744621803951925069372793574e16), 
      SC_(0.33246523978462334755767677157978212676425755489618e-18), SC_(0.364377344204408356864e21), SC_(0.47603821186323272660218327918596801064457513241734e-24), SC_(0.25814216e9), SC_(0.19269257441096919530694670379923173139739144262915e-16), 
      SC_(0.38630216070566644236610820764554752315689256647602e-18), SC_(0.13632195402405625179543049996233605725137749686837e-16), SC_(0.246089305877685546875e2), SC_(0.1399240064e10), SC_(0.96160176358544680912132367246233006471552136890136e-8), 
      SC_(0.5065993732313771067901500902430633743733778828755e-18), SC_(0.1568245533434264871175400912761688232421875e-11), SC_(0.164856496509546701645376742817461490631103515625e-11), SC_(0.11049377558747242034087321371771395206451416015625e-10), SC_(0.24333145548513535763032420069717436356230077382352e18), 
      SC_(0.56496203192824509654683656084683818221492401789874e-18), SC_(0.3989972265625e5), SC_(0.10386388025240962199904871336025857786466985999141e-18), SC_(-0.1956300555677366237528064e25), SC_(-0.20985760511703309654551952723929281351715000626057e-24), 
      SC_(0.6105958285639939581856830766448673841750860447064e-18), SC_(0.44425352285770713933743536472320556640625e-10), SC_(0.43310928958817385137081146240234375e-5), SC_(0.3331700224e10), SC_(0.30849153168165211014337299028261182393629600707e-5), 
      SC_(0.74351356833997344638427159924098930332547752186656e-18), SC_(0.25260515625e6), SC_(0.20705711806766271231819329983944982104260290611819e-21), SC_(-0.97036929889871325401618645800638773835089523345232e-18), SC_(-0.44270929631699238220397253704106482840103445821599e16), 
      SC_(0.75868695590633990953827528458397466692986199632287e-18), SC_(0.930611462144e12), SC_(0.18147922618313051311153033283257685840533790511131e-24), SC_(-0.4468824462890625e3), SC_(-0.17122605983975616494910436179136666067164567252951e-6), 
      SC_(0.92091661616996020185937736612924453538653324358165e-18), SC_(0.13634373630111440434120595455169677734375e-8), SC_(0.114086150930432e15), SC_(-0.177961433038848e16), SC_(-0.43742116361186372707057103765791006102104098116996e-20), 
      SC_(0.17267258802243381463374302664526283024315489456058e-17), SC_(0.106269702911376953125e2), SC_(0.1371270220231999488e19), SC_(-0.2610413929460264625959098339080810546875e-7), SC_(-0.20151384519726350695045106393341169054390534680208e-9), 
      SC_(0.18472254159580004528743227276699201411247486248612e-17), SC_(0.24041662e8), SC_(0.8549778129918195190839469432830810546875e-7), SC_(-0.9977238732972182333469390869140625e-5), SC_(-0.18777158846153662023863432189916058865485224119003e3), 
      SC_(0.18755437374336002170666266863907623019258608110249e-17), SC_(0.776579078820560653184656985104084014892578125e-9), SC_(0.1157078125e4), SC_(0.41412740422322618368e20), SC_(0.32798850146389354885754724510156799518229419256579e-19), 
      SC_(0.22468750405760049766485005051652734664457966573536e-17), SC_(0.20721947294077835977077484130859375e-4), SC_(0.33333534375e6), SC_(0.135856362248887307941913604736328125e-4), SC_(0.33096158156088779129127640067482846233624776319543e3), 
      SC_(0.23677507366932257725205407394852841207466553896666e-17), SC_(0.19413969366297906845036399083384570651844569511013e-19), SC_(0.9869267940521240234375e0), SC_(-0.527360038883932767848677507072e30), SC_(-0.12360334357574898107848087376524755592649555106606e-27), 
      SC_(0.26571661369793510632029802376319338463872554711998e-17), SC_(0.8155011072e10), SC_(0.1562779305782940357831823844548056582932221703075e-23), SC_(-0.158908193270690389908850193023681640625e-6), SC_(-0.27385391577969229624957512379090687794348733507394e4), 
      SC_(0.29343589097392396787046010830923847834128537215292e-17), SC_(0.988066171875e5), SC_(0.24754359063412526643006257824154938047573476511687e-24), SC_(-0.67044108778078208e17), SC_(-0.38893042804795196357465478313524510719593882749798e-17), 
      SC_(0.32174132911148321865672794483970164947095327079296e-17), SC_(0.716792047023773193359375e-2), SC_(0.1701292973166346200741827487945556640625e-6), SC_(0.1377628393306462584178007091395556926727294921875e-10), SC_(0.36139061055708614171982246452283892649682331582451e11), 
      SC_(0.33799056846205146343036125611281050851175677962601e-17), SC_(0.940699322882210253737866878509521484375e-7), SC_(0.28067035992549749107627877552034277377768375726476e-29), SC_(-0.162116563320159912109375e1), SC_(-0.8091523759270728825492872210435631725041209007519e5), 
      SC_(0.34736920428572363268512890321915165259269997477531e-17), SC_(0.2535458095371723175048828125e-1), SC_(0.26639236355453407782438750529430338221052338559396e-30), SC_(0.12926337963453675344812564506800251945041208695431e-25), SC_(0.13925478141182229277143817958943446485388146767132e24), 
      SC_(0.46574007343104197780350728130827064887853339314461e-17), SC_(0.138342221871913237479424e26), SC_(0.105195244140625e5), SC_(-0.6631563720703125e3), SC_(-0.73605758407512432062994970478816333202168423203793e-16), 
      SC_(0.48236623830723532346288762173713848824263550341129e-17), SC_(0.1277736968994140625e3), SC_(0.95177386513821491537123975490430893842130899429321e-15), SC_(-0.69188577160303328973482915717587071687158308069902e-30), SC_(0.60363020633141073895228450454658582983021080949361e17), 
      SC_(0.52655215867828667928533109554578572897298727184534e-17), SC_(0.13102694856934221302627057835335012189043046859638e-22), SC_(0.557648090759990083584e22), SC_(-0.82892526176436831519822590053081512451171875e-9), SC_(-0.49088957920041958614658255603315707964163798177224e0), 
      SC_(0.55920763625968573348528831146175832600420108065009e-17), SC_(0.4486362300416e13), SC_(0.15860614776611328125e2), SC_(0.67221050854803507997731193412960237765219062566757e-16), SC_(0.57906219363989289634942989085109401080228066042955e2), 
      SC_(0.55959876861233143262135125706180360793950967490673e-17), SC_(0.95295438343517395336428519424e29), SC_(0.963892161962576210498809814453125e-4), SC_(0.27210720655868048112324686371721327304840087890625e-12), SC_(0.29720419314845298882214745109837232793968747939632e-5), 
      SC_(0.65166045527188006246692084100224917619925690814853e-17), SC_(0.143673929642318398691713809967041015625e-6), SC_(0.16637075914752e15), SC_(-0.24076418430271488e17), SC_(-0.2475925633548439017994534719021379048651154628174e-21), 
      SC_(0.68176019291467402705982786548233320900180842727423e-17), SC_(0.254574008285999298095703125e-1), SC_(0.2752869427204132080078125e0), SC_(0.107289657733604314756153344e28), SC_(0.13935903209016660805915740073905015544222859166445e-25), 
      SC_(0.80231539790356115235923917250460135619505308568478e-17), SC_(0.48408881335894016e17), SC_(0.27153925038874149322509765625e-2), SC_(-0.337505643256008625030517578125e-2), SC_(-0.28880597171948110891286910628894512386618556229753e-5), 
      SC_(0.80878494291046089240994343416701894966536201536655e-17), SC_(0.1615060552761815478491414528e29), SC_(0.4250650378642010683736064e25), SC_(0.550465557233664e15), SC_(0.7665682204462440903547624951783326488583724992224e-33), 
      SC_(0.10241893091461084678650897417107046294404426589608e-16), SC_(0.6510811857879161834716796875e-2), SC_(0.33316731575161268994048e23), SC_(0.18685794677734375e4), SC_(0.61366725169065281180715385638412540622056890839468e-13), 
      SC_(0.12692866469583270565540250585101489377848338335752e-16), SC_(0.195883875046228472335595208704e30), SC_(0.15639441e8), SC_(0.309064334791671808e19), SC_(0.30041981663937451991164678003672469797594750518722e-31), 
      SC_(0.13036512864804138041871853226361110955622280016541e-16), SC_(0.124515782754304e15), SC_(0.21949353142328154042672849755035713315010070800781e-12), SC_(-0.4362470948864e13), SC_(-0.18391679664039406576787168709927928959902260107376e-17), 
      SC_(0.20065922661601206578897704790875877733924426138401e-16), SC_(0.45365798223651683691859393121603716281242668628693e-15), SC_(0.160435796715319156646728515625e-3), SC_(0.100037578913478606848e22), SC_(0.34309298342647602644365714826276998591146823420685e-17), 
      SC_(0.24715665357800610426718818102287400506611447781324e-16), SC_(0.15454139158925192518959104e26), SC_(0.1653589118287872e16), SC_(-0.2871475982666015625e2), SC_(-0.45825038360031330054102253640951199565393489630838e-27), 
      SC_(0.25599855258170792768942364281414825200045015662909e-16), SC_(0.301153981126844882965087890625e-2), SC_(0.1650323114690053222170624e25), SC_(-0.4537919762181985561255714856088161468505859375e-9), SC_(-0.30097461902825564961699519247715738621951722883131e-9), 
      SC_(0.26924719012433700180732254469972986044012941420078e-16), SC_(0.41597107766322926041685503761868858418893069028854e-15), SC_(0.29144378043404386068337883462526366473710481841408e-20), SC_(-0.370274230861824e16), SC_(-0.11020218800329703103725212756492238562111267289754e-6), 
      SC_(0.27022364375023134885640124780437076879024971276522e-16), SC_(0.27506543358959030582888269221280574638246675400223e-29), SC_(0.10302131894484992e19), SC_(-0.109015556161536e15), SC_(-0.97414021009427756192024172486880966682042486122486e-21), 
      SC_(0.29292129777895166658878423060485829410026781260967e-16), SC_(0.3623176299517048782848e23), SC_(0.17793491421051038908068830934894322126638144254684e-15), SC_(-0.4787837861888e13), SC_(-0.10890581223892275765737490047081064660397125838898e-21), 
      SC_(0.36988549069333557356951958094981591784744523465633e-16), SC_(0.237869296e9), SC_(0.4375164244540203306430662971835871692327677107354e-28), SC_(-0.2537191845476627349853515625e-2), SC_(-0.12743885591175912587472375525250395917678182573964e1), 
      SC_(0.40798337829960889676546298421300207337480969727039e-16), SC_(0.1173381609915570272075776e25), SC_(0.63968165934984593408e20), SC_(-0.43809122158741115469526505885267337117583430483592e-22), SC_(0.41013278664791662351936843798955489687158902263061e-12), 
      SC_(0.4191901866745998263101558034549043441074900329113e-16), SC_(0.10302939847848110674084082249990501622960437089205e-16), SC_(0.2788808e8), SC_(-0.1267284457790898176e20), SC_(-0.12735703951375488492372016599292209320315586877608e-20), 
      SC_(0.64434140404769448852440039132716265157796442508698e-16), SC_(0.29474087059497833251953125e-2), SC_(0.831660695865821253391914069652557373046875e-8), SC_(-0.361036993563175201416015625e-1), SC_(-0.11781973232364219372724150746716878192145154846968e5), 
      SC_(0.65862403389962709829644205150600555498385801911354e-16), SC_(0.12589836710231217578946995640063576121650892880588e-24), SC_(0.15267659170852906972300245141565246870264040027036e-29), SC_(0.7304354260722909184e19), SC_(0.57797047912895605829251131842292150283514788749667e-9), 
      SC_(0.76081326502993809482791598419737510994309559464455e-16), SC_(0.25848253930055992144687593281560111790895462036133e-13), SC_(0.1193103496916592121124267578125e-2), SC_(0.900681217081344e15), SC_(0.13125180019368326604183089646272331872983702071315e-11), 
      SC_(0.80672926673936861015346000414183436078019440174103e-16), SC_(0.827727653086185455322265625e-2), SC_(0.35112936003017073972307015159908215318207425070796e-21), SC_(0.29399680529072325769822208e26), SC_(0.19644856918418534438823676999423197611328855663516e-22), 
      SC_(0.17055543082513291604229710429763144929893314838409e-15), SC_(0.6943710148334503173828125e-1), SC_(0.61840874921367523613102701318666731822304427623749e-15), SC_(-0.65621912475964907199619112761115127860814364053887e-27), SC_(0.47019236372761355486203476899973081384386480181909e18), 
      SC_(0.31185572008064158661122533544585166964679956436157e-15), SC_(0.103208861696e12), SC_(0.608565546572208404541015625e-1), SC_(0.111519998744668930048e22), SC_(0.12950466367514007286341944930272383433997736714818e-24), 
      SC_(0.37240330274649388175162156855435569013934582471848e-15), SC_(0.39033365298660194220303765177959576249122619628906e-12), SC_(0.49610075975644457590973956939706113189458847045898e-14), SC_(0.2721116561243963616334440303035080432891845703125e-10), SC_(0.55780152222755682040886430039080572919535793869307e18), 
      SC_(0.42470234622308579170574249772585062601137906312943e-15), SC_(0.273214027401991188526153564453125e-6), SC_(0.2784369140625e5), SC_(-0.122955464704e12), SC_(-0.2055859842856675244661943031533336289283609892675e-11), 
      SC_(0.43755096253020667185218428585358196869492530822754e-15), SC_(0.62454500948661006987094879150390625e-6), SC_(0.35261424123839905237211021312e29), SC_(0.2980772193152202874814464e25), SC_(0.19302058547089645438660392671915805421584719516624e-36), 
      SC_(0.45917973708010841743520913382781145628541707992554e-15), SC_(0.19586950889472e14), SC_(0.369513875501284851712e21), SC_(0.32082223828590183491348161974631250424082394394343e-26), SC_(0.22276248931728079203626923790939253098909187196436e-7), 
      SC_(0.92657114094649205629505850367877428652718663215637e-15), SC_(0.32666126748015500425026402808725833892822265625e-10), SC_(0.62660384591791979530528422515089914668351411819458e-14), SC_(0.1008363437193793288315646350383758544921875e-7), SC_(0.27351103948219950394607048822020994368305988636168e15), 
      SC_(0.9461294493359490714867732208404049742966890335083e-15), SC_(0.322404707098211673610421712510287761688232421875e-10), SC_(0.431042727657187209984457310208e30), SC_(-0.25939472834579646587371826171875e-3), SC_(-0.1521655516615116593467268230648389654033527386922e-9), 
      SC_(0.10427554739478122301787887948876232258044183254242e-14), SC_(0.113768251392e12), SC_(0.331932704e9), SC_(-0.146179646215493039614328832e27), SC_(-0.26207104372812352384186903012531171643148694235604e-30), 
      SC_(0.108844972507862952984525328758991236099973320961e-14), SC_(0.8827765185515090706758201122283935546875e-7), SC_(0.12374138095446693172739117808946185395058137146407e-19), SC_(0.666504180067635268759322624e28), SC_(0.1588943443495131901438841904021519421877511484431e-22), 
      SC_(0.11863620751000167503896864928947252337820827960968e-14), SC_(0.10501863e8), SC_(0.297662976884736e16), SC_(0.38545965e7), SC_(0.99936758376889422217427377170359816383144088083729e-14), 
      SC_(0.1327809695148788465823841420387907419353723526001e-14), SC_(0.54374770505732477601443242143375300656771287322044e-16), SC_(0.4562802734375e3), SC_(0.46168245925155835247976908741326032343734780941558e-30), SC_(0.8733391830285032647133058752737690971215445335428e16), 
      SC_(0.1521184564149866656757037475244942470453679561615e-14), SC_(0.78043131116246277084876840218763405232493823859841e-18), SC_(0.8230711687937861353472e22), SC_(-0.261837272793138107705720832e27), SC_(-0.55131649903407614493273709184047126007708292640109e-35), 
      SC_(0.15513160671825438827187149115616193739697337150574e-14), SC_(0.128848231629674512384e21), SC_(0.453911488373981184e18), SC_(-0.272230816057921281982464e24), SC_(-0.40900195710569414677231635149406992987060532636958e-32), 
      SC_(0.27307124609616964874825306708316929871216416358948e-14), SC_(0.182371203125e6), SC_(0.21274221015747239239477678037285035550496559153544e-20), SC_(-0.5080252838134765625e2), SC_(-0.26859329265194173738148314393473631299909977523176e-2), 
      SC_(0.3175585599804442958615791070542400120757520198822e-14), SC_(0.312386333942413330078125e0), SC_(0.19804426484300995555480765571588347428999554722395e-20), SC_(0.204206969528978780572352512e27), SC_(0.4598628270598817503003423168856717737399091724828e-24), 
      SC_(0.3191302296140746501407203794542510877363383769989e-14), SC_(0.10381816564935609401309940371061152700193908060555e-22), SC_(0.10607265933659792978005498298443853855133056640625e-11), SC_(0.16962918701171875e4), SC_(0.73699415925533608404039108584957523332422130169253e4), 
      SC_(0.46327183795158866780328210666084487456828355789185e-14), SC_(0.18185955328e11), SC_(0.451266796875e4), SC_(-0.251544139898814464e18), SC_(-0.79514006265528568085300195845574492625676786528676e-21), 
      SC_(0.49741023034125236151892224256698682438582181930542e-14), SC_(0.6392963047829880451899953186511993408203125e-8), SC_(0.10878475189208984375e2), SC_(0.59239240047379667314374328772998870027484841910281e-26), SC_(0.23259804734945165563893593397187160915487194491047e13), 
      SC_(0.10676147262794234704674778413391322828829288482666e-13), SC_(0.43214794983836329352138753913566138198376620493946e-21), SC_(0.13713993780991436762807365477498389161326031171484e-19), SC_(0.459039679325405184e18), SC_(0.50634806424548958080863973931752282050795937648579e-9), 
      SC_(0.11175146230483004594624674155056709423661231994629e-13), SC_(0.13292268387650598312620966562043814396254504117678e-22), SC_(0.573736336217933740044827573001384735107421875e-9), SC_(-0.159210900019246537340222857892513275146484375e-8), SC_(-0.51263188177194923566692827645827740096413880118868e15), 
      SC_(0.11434902436285691862405400343050132505595684051514e-13), SC_(0.11365004815161228179931640625e-1), SC_(0.27400035858154296875e2), SC_(0.203586085846411726815232e24), SC_(0.14865595781712049736623538981536601361501882271293e-22), 
      SC_(0.14319996604521614824712116842420073226094245910645e-13), SC_(0.502013623046875e4), SC_(0.439923968e9), SC_(0.77103273938046509121536e23), SC_(0.13127867694451221772529352791773418912044804650146e-25), 
      SC_(0.14452686009774895481427847698796540498733520507813e-13), SC_(0.669478515625e5), SC_(0.10465634918212890625e3), SC_(0.449877052233205176889896392822265625e-5), SC_(0.83920859706880014597252065499174465623352445982047e0), 
      SC_(0.15741248433312655941040958396115456707775592803955e-13), SC_(0.55817784918415767502848e23), SC_(0.229345916576958775296e21), SC_(0.1422582611968e13), SC_(0.11042022857014238245111043582622863593162051496085e-26), 
      SC_(0.18072887885680830044599076700251316651701927185059e-13), SC_(0.9294252867331209699841565452516078948974609375e-10), SC_(0.9254750999199875072e19), SC_(0.24365014356228265782400482870787190672759117303012e-27), SC_(0.12667200196814033712749982529939469166787145122709e5), 
      SC_(0.20907895301679711719256005153511068783700466156006e-13), SC_(0.893892793119022144310292787849903106689453125e-9), SC_(0.40748735773377120494842529296875e-3), SC_(-0.103842619771060224e19), SC_(-0.11301079598625095571338471461207721603886044979147e-14), 
      SC_(0.33361036372650532122463573614368215203285217285156e-13), SC_(0.13796345e8), SC_(0.198710050816e12), SC_(0.45089474962351026470181957815863910479792231456031e-22), SC_(0.10816863888512989997095493619370003783591021195154e0), 
      SC_(0.39424006729538510485078006695403018966317176818848e-13), SC_(0.57692237126522896384e20), SC_(0.63429242800339125096797943115234375e-5), SC_(0.2403500367487817497607929856e29), SC_(0.4949809604390674467680517177597868641410256650499e-36), 
      SC_(0.64787469822562976373703236276924144476652145385742e-13), SC_(0.901123595574664186118012928e27), SC_(0.52348109979648e14), SC_(-0.92166092189216471698798669434216327954012968124006e-30), SC_(0.1090156365125808257716087226492704191375893460149e-11), 
      SC_(0.76942494259615856755374352360377088189125061035156e-13), SC_(0.66135648510840369201714235709365829468252447054244e-26), SC_(0.14856115097057909918421003681032743770629167556763e-14), SC_(-0.7298071485930166476255264768e28), SC_(-0.49962292172186675708556937635053531938468515532145e-20), 
      SC_(0.85809811133878005628972118756792042404413223266602e-13), SC_(0.231948544e9), SC_(0.35943559868918673050330880869296379387378692626953e-12), SC_(0.33152778065911218176e20), SC_(0.14822334045625801548341774563889185100510953334425e-21), 
      SC_(0.89437253447417069951441703778982628136873245239258e-13), SC_(0.6810400963385563236916002816e29), SC_(0.3797301248e10), SC_(0.126497719300441316942690648064e30), SC_(0.20671010726926483227997444653788556014049212414485e-41), 
      SC_(0.10487268063512356075506204433622770011425018310547e-12), SC_(0.63315844405084463121122798948200730173070530440449e-26), SC_(0.2820757454293782533282725888e28), SC_(0.1287141702694919577644258606866425886927629562706e-20), SC_(0.7625540806887901305440815493898234863502803377371e4), 
      SC_(0.12564036996117605715639342633949127048254013061523e-12), SC_(0.9483047886198053293833322496e28), SC_(0.12390550980849227670011272750549835564015666022897e-16), SC_(-0.273697622787949512712657451629638671875e-6), SC_(-0.89824853650459102430566076692966043038795156299974e-6), 
      SC_(0.13318344907822798894869720243150368332862854003906e-12), SC_(0.648778863965304708472103811800479888916015625e-9), SC_(0.15799224663005841208176941239949009343490615719929e-18), SC_(0.438925457000732421875e1), SC_(0.15110069213515929983115826328865961997601215547368e6), 
      SC_(0.15615465734711286849289990641409531235694885253906e-12), SC_(0.24870398826241113884932236596184834676037667122728e-20), SC_(0.12784377253954858878954355810853016350847610738128e-17), SC_(0.276238139392e12), SC_(0.19786554171476684761944278128724044945577023531761e-3), 
      SC_(0.15995684594580228399252064264146611094474792480469e-12), SC_(0.170420291286861873152e22), SC_(0.286204729096914532827136e24), SC_(-0.8279771890329357120208442211151123046875e-7), SC_(0.65615234452566227821219269595685128171534111213131e-21), 
      SC_(0.18399165654589544338648465782171115279197692871094e-12), SC_(0.59311699931923680645911412736e29), SC_(0.33036756992e11), SC_(0.93300527026496382632103632204234600067138671875e-10), SC_(0.10720127778005331975224440744322785134582808832009e-13), 
      SC_(0.29870528793496387010009129880927503108978271484375e-12), SC_(0.2262512535863296e17), SC_(0.9036469625899950631026688e26), SC_(-0.21871623992919921875e1), SC_(0.5103356109347619113331878509059276755907702474308e-27), 
      SC_(0.30400416342266090019563762325560674071311950683594e-12), SC_(0.1399889375e6), SC_(0.3335612032771822899429376e25), SC_(0.21259690531047524889030064798589592101052403450012e-15), SC_(0.34455005796404051985506726831103545959478382478102e-7), 
      SC_(0.87205828495917625531319572473876178264617919921875e-12), SC_(0.17828132250559781516117823566813499739247164401987e-29), SC_(0.10616928431838319469314500884810081871023612620775e-18), SC_(-0.212311297277034496e19), SC_(-0.14143132703507446245366882656756991039691353152788e-10), 
      SC_(0.11046793904970209077021081611746922135353088378906e-11), SC_(0.395945312256e13), SC_(0.516478977703936e15), SC_(0.33489388749831173392049517199361798372968246351178e-25), SC_(0.10261044155333465315175909578459653562547787407513e-5), 
      SC_(0.14650218971984374505268533539492636919021606445313e-11), SC_(0.827417719457900920832e21), SC_(0.99161693125401212389746774533705320209264755249023e-13), SC_(-0.4229425548605760995328e22), SC_(-0.95402427001540155956102931856707223924536036302336e-30), 
      SC_(0.15171425313958986080820068309549242258071899414063e-11), SC_(0.3374702880859375e4), SC_(0.8743139992458493952e19), SC_(-0.6686860561370849609375e1), SC_(-0.3002438908822274925277408606109986399523433785326e-12), 
      SC_(0.24519117205329399311608540301676839590072631835938e-11), SC_(0.37266163191353868233690604938601609319448471069336e-13), SC_(0.17164059241625931492502552475279821268816515811295e-22), SC_(-0.32801553809475356226630220035122305463539532643935e-24), SC_(0.63515296008495797097992261176651053432804471005576e25), 
      SC_(0.27182867502056895503415034909266978502273559570313e-11), SC_(0.9611178584064393216e19), SC_(0.43522266445974666852999678045371003546350584579075e-29), SC_(-0.2494812472325268841899095431527758059964128278807e-20), SC_(0.13480851526964308079121034950043024547154027314665e3), 
      SC_(0.29120870211757354795167884731199592351913452148438e-11), SC_(0.3887373507426089705638133735808321250759789222684e-21), SC_(0.6547148956315140821970999240875244140625e-7), SC_(0.12526326011789939681625675755603012304041296576251e-24), SC_(0.16426629492670114906905094296695909709456996976342e22), 
      SC_(0.29600787966599373390863547683693468570709228515625e-11), SC_(0.3973922277237145706452353958928330746047663524223e-21), SC_(0.22686514883719433640502094462476634362246841192245e-15), SC_(0.2356390072724299979828321838226656836923211812973e-15), SC_(0.74826530999192537579310495705584399994314811536455e22), 
      SC_(0.33891997281570995781407873437274247407913208007813e-11), SC_(0.15147392863409494812524544e26), SC_(0.1021753437413508436293341219425201416015625e-7), SC_(-0.163353502834470571474944e24), SC_(-0.1727660327837803015143950138748892976048780042624e-33), 
      SC_(0.40045809550359745543346434715203940868377685546875e-11), SC_(0.15545443197401612718091273500581415284438335788764e-21), SC_(0.53111681546452992e17), SC_(0.84488384e9), SC_(0.37119938685395575343200714957460497696569465138723e-15), 
      SC_(0.63733484635675186069647679687477648258209228515625e-11), SC_(0.14835896334213958139303302711486596921615075148304e-29), SC_(0.149358570575714111328125e1), SC_(0.1017402710753804288e19), SC_(0.34927848403310092955516711143449217869038874100458e-16), 
      SC_(0.883858437827900189631691318936645984649658203125e-11), SC_(0.2675533852189090413285581307472793475995567477404e-29), SC_(0.89227636509894153737931787873094435781240463256836e-13), SC_(-0.258020797841408e15), SC_(-0.14434887711525503924559220378358629382677384522122e-7), 
      SC_(0.10552792147067169281626775045879185199737548828125e-10), SC_(0.2806226621032692492008209228515625e-4), SC_(0.5067019649024e13), SC_(0.310628116130828857421875e0), SC_(0.22948470574146532069261551613760894946094642379269e-4), 
      SC_(0.2587575986812140627080225385725498199462890625e-10), SC_(0.133434101007878780364990234375e-2), SC_(0.18789219970703125e4), SC_(0.8687275e7), SC_(0.67256865003055763773290668910027936489380689481087e-7), 
      SC_(0.2844938000456931348480793531052768230438232421875e-10), SC_(0.198093310108123529216e21), SC_(0.2637005062144e13), SC_(-0.827058865837670964538119733333587646484375e-9), SC_(0.8276142376917439023807843720956102108378867803271e-12), 
      SC_(0.287181702030014918136657797731459140777587890625e-10), SC_(0.20763506912126383440731014865551860154591068408081e-22), SC_(0.15903788229459968e17), SC_(0.2465913695459676091559231281280517578125e-7), SC_(0.39291472710261624671330092591045600800641927445849e1), 
      SC_(0.429480374875002013368430198170244693756103515625e-10), SC_(0.9581417214429984980992e22), SC_(0.60548121100288e14), SC_(0.44916436473898050918918476221330306438783187827912e-25), SC_(0.10782263530497046514179141587685299463453106251202e-10), 
      SC_(0.475504878527654994968543178401887416839599609375e-10), SC_(0.458113936316282949337088e24), SC_(0.2879962761326293474439808051101863384246826171875e-10), SC_(0.38806094851569314955264e24), SC_(0.44407680593672734398585252161238633184776723369752e-33), 
      SC_(0.48257405016460808155898121185600757598876953125e-10), SC_(0.1253181934356689453125e1), SC_(0.5335487261327490936842747904e28), SC_(0.2843008728868403019776e22), SC_(0.36520008616040154920452563084694127248774062394094e-33), 
      SC_(0.5260512858651367196216597221791744232177734375e-10), SC_(0.211335212615120842253257408512e30), SC_(0.253812432e9), SC_(0.32648756173466563987677623601222492988327417151595e-20), SC_(0.70282134149192367841270463560033057613589565263926e-12), 
      SC_(0.66436224577248736977708176709711551666259765625e-10), SC_(0.1287645825073152e16), SC_(0.1319026512921362432e19), SC_(0.2489169500768184661865234375e-1), SC_(0.7247273265118998238267296449606572590546815405985e-15), 
      SC_(0.8522828276458227492184960283339023590087890625e-10), SC_(0.55899994919408890758916186314309015870094299316406e-12), SC_(0.97513915318293903280056494908833997214969713240862e-17), SC_(0.24821585375603486028032247491330840316603456585653e-21), SC_(0.83208726697417671103165106753795798717568056161077e21), 
      SC_(0.109099930478695483770934515632688999176025390625e-9), SC_(0.270692863967232e15), SC_(0.29007003659667536871391374330266324510496644961677e-21), SC_(0.662604696117341518402099609375e-3), SC_(0.23398784686072748897166785500571130408922056113099e-2), 
      SC_(0.111468466401642984919817536137998104095458984375e-9), SC_(0.68559452379320356268932457055598206352442502975464e-14), SC_(0.322791595458984375e3), SC_(0.83594068023309085237182447514214800321497023105621e-15), SC_(0.34775042288691702425388939755810663167943433025528e12), 
      SC_(0.1237108193663516431115567684173583984375e-9), SC_(0.393077021751861389033472e24), SC_(0.85326592849126535957377352366076878413243909232699e-28), SC_(0.40366524684497251396209094309597276151180267333984e-12), SC_(0.10265993706475554621328701844340119184273235491136e1), 
      SC_(0.1776234992423297853747499175369739532470703125e-9), SC_(0.648145680315792560577392578125e-3), SC_(0.190692115536150528e18), SC_(0.30884640683662492599559357131511205807328224182129e-13), SC_(0.10167409595598760347845694686063659073232295746773e0), 
      SC_(0.34717195784850218842620961368083953857421875e-9), SC_(0.40871053623249201233388894216602693632012233138084e-16), SC_(0.59489389257909689226875975750249807283420722114897e-22), SC_(-0.183823234412017200156697072088718414306640625e-10), SC_(-0.63436985009846869656045408170236548101195232061781e17), 
      SC_(0.451758797037626891324180178344249725341796875e-9), SC_(0.344271373748779296875e1), SC_(0.342428213051392e16), SC_(0.1515062195912704e16), SC_(0.58743056645089248605803114478066356773725635368598e-21), 
      SC_(0.626809104620207335756276734173297882080078125e-9), SC_(0.1127446541470904877056e22), SC_(0.3806862878263927996158599853515625e-4), SC_(-0.55809958980228878891696818200743746701819603117656e-22), SC_(0.9088819150803773040608210209095743642460278178193e-2), 
      SC_(0.9231155839728444334468804299831390380859375e-9), SC_(0.148210436978768456128818797878921031951904296875e-11), SC_(0.2802693296844053863329895203088462651841439310374e-20), SC_(0.11801873e8), SC_(0.38526292759511738659280361222341157245243748651719e-1), 
      SC_(0.21980717246350423010881058871746063232421875e-8), SC_(0.49538579618632616607953877974068745970726013183594e-12), SC_(0.294444323290692452352e21), SC_(0.218038891637768413660577792e27), SC_(0.27986670037155934324525781256123082672651258233883e-34), 
      SC_(0.2402602117257401914685033261775970458984375e-8), SC_(0.42540803535525434114020215409929237537767221510876e-19), SC_(0.4942538125e6), SC_(-0.19200403581726623552300118153495613667215008435463e-24), SC_(0.28901838947785414545228654421464493653202761440022e13), 
      SC_(0.2502269946802471167757175862789154052734375e-8), SC_(0.439172573387622833251953125e-1), SC_(0.1484655421266577700334376999080632231198251247406e-14), SC_(0.217515168e9), SC_(0.64008842323926885588584314270491747993393491744903e-6), 
      SC_(0.27705213678785867159604094922542572021484375e-8), SC_(0.14060803910087571466647204943001270294189453125e-9), SC_(0.79591391331746227542562333034936727926833555102348e-16), SC_(0.1130919989314004038414218297758928599705541273579e-17), SC_(0.15279162108642205238638113706086141458303770987596e19), 
      SC_(0.29745914620349367396556772291660308837890625e-8), SC_(0.135719256064e12), SC_(0.26312211439804296018980907041482450328759995494821e-24), SC_(-0.72325931008e11), SC_(-0.26025493618765031944582661408500103876435030194882e-14), 
      SC_(0.3035781848126362092443741858005523681640625e-8), SC_(0.60851728009920512e17), SC_(0.22169422886076416e17), SC_(-0.771180726587772369384765625e-2), SC_(0.58356075827457693669918024467253431530422820737776e-18), 
      SC_(0.357227936120807498809881508350372314453125e-8), SC_(0.190531306287766710738651454448699951171875e-7), SC_(0.60475637804894883005346617466102543403394520282745e-16), SC_(0.25554468064755161278679088804333119355760572943836e-18), SC_(0.16050376680749540915211619360854206253328830762671e18), 
      SC_(0.5805298908256872891797684133052825927734375e-8), SC_(0.396956085205078125e3), SC_(0.23182911778654921095613188825248071874636675293591e-26), SC_(-0.14757916550624509427712e23), SC_(-0.14141726889735103114725839711364436845767347042983e-21), 
      SC_(0.658921095464393147267401218414306640625e-8), SC_(0.36312374337780811635291334191609812561286202425848e-24), SC_(0.3520565633613824e16), SC_(-0.95283742553550204184526308849589870675345082418062e-20), SC_(0.39383218115942262166676009411857129347834260605038e5), 
      SC_(0.7181391925570324019645340740680694580078125e-8), SC_(0.861479942937393161628278903663158416748046875e-9), SC_(0.65218459540529447227428438016e29), SC_(-0.21721630536744498257695212828366493340581655502319e-16), SC_(0.43184695581467687921857543427535645783935321162383e-4), 
      SC_(0.7274625346553875715471804141998291015625e-8), SC_(0.5271569847309365286491811275482177734375e-7), SC_(0.1207270608892123232922376449582392565762489766712e-20), SC_(-0.907864838861627276855870150029659271240234375e-9), SC_(-0.18846907217766321197261291037267280508950899795828e13), 
      SC_(0.768561481123697376460768282413482666015625e-8), SC_(0.746742980114208784384e22), SC_(0.1620157166788452543088295936e29), SC_(0.96551501855451422117358279079493699192937583575258e-20), SC_(0.44783395055835276765234394980567707654119207248648e-19), 
      SC_(0.1103230484744699424481950700283050537109375e-7), SC_(0.227022734375e5), SC_(0.314360886477516032755374908447265625e-5), SC_(0.230793674752e14), SC_(0.10938135963248928821050633939985227713352325798319e-13), 
      SC_(0.116516947201716902782209217548370361328125e-7), SC_(0.113272657281024e15), SC_(0.5554756105947418984448e22), SC_(-0.22779259015063853832005124830373254951609851559624e-18), SC_(0.45626261425943381204356625680683410530260337151658e-12), 
      SC_(0.1463924537148386662011034786701202392578125e-7), SC_(0.2235086485323776e16), SC_(0.92567377136320512e17), SC_(-0.502123015962624e16), SC_(-0.2041653512744934342005763872578190276494619329949e-23), 
      SC_(0.153310129036299258586950600147247314453125e-7), SC_(0.15191832576e11), SC_(0.64654147584e12), SC_(-0.109413349622840760752970661888e30), SC_(-0.11168340111963906937898650420056211408951891171444e-33), 
      SC_(0.284060650557194094290025532245635986328125e-7), SC_(0.65708584402419712e17), SC_(0.79746025e7), SC_(-0.103757918404631337107456e24), SC_(-0.14440448978129240797306397158111690006375043493078e-29), 
      SC_(0.46037570200496702454984188079833984375e-7), SC_(0.2497748291015625e4), SC_(0.37057185207840757381302088102614789022482000291348e-16), SC_(-0.88649561934381511385527829816055600531399250030518e-14), SC_(0.19027270633146013510916093701048426045586392144417e9), 
      SC_(0.48485627957006727228872478008270263671875e-7), SC_(0.21549719333954656317750013417980168338661728019701e-26), SC_(0.8410253024559104e16), SC_(0.341893185536e12), SC_(0.21425799803606972737445032217541375450102598435277e-17), 
      SC_(0.56142742010933943674899637699127197265625e-7), SC_(0.7819102165740332566201686859130859375e-7), SC_(0.51380279967715852817988775314006488770246505737305e-13), SC_(0.200521964168113291264e21), SC_(0.91091672374787343450225990261465422781914984618348e-16), 
      SC_(0.5888978904522446100600063800811767578125e-7), SC_(0.19738892977879712492899096608329417718301519724111e-25), SC_(0.555923861611518077552318572998046875e-6), SC_(0.1141436e8), SC_(0.8992374739358728447181125424661522884820716934695e-3), 
      SC_(0.64836257251954521052539348602294921875e-7), SC_(0.11649136528196886067987694424015483218044894522109e-26), SC_(0.36767340167168e14), SC_(0.493704617023468017578125e0), SC_(0.86342692064424182784615665841513322156909113570646e-5), 
      SC_(0.9426266700529595254920423030853271484375e-7), SC_(0.1065340096e10), SC_(0.675034e7), SC_(0.11022882697838232458615974340698784317282843403518e-17), SC_(0.15300795293140386147904527178989123927003675188183e-2), 
      SC_(0.11666782739894188125617802143096923828125e-6), SC_(0.34799534478224813938140869140625e-3), SC_(0.131195640625e6), SC_(-0.48978190038186971237336846953739494248125652120507e-22), SC_(0.2388945504612328758901280969267509380243643847542e5), 
      SC_(0.153669333258221740834414958953857421875e-6), SC_(0.24841828125e5), SC_(0.12379233211158146427122161981060344260185956954956e-13), SC_(-0.64715270091955995318595980768383579828650908893906e-19), SC_(0.29560340817341301491613970695503673872817011849739e10), 
      SC_(0.1622084795371847576461732387542724609375e-6), SC_(0.29883875829401013719709328056513446297320465063827e-30), SC_(0.4141578515625e5), SC_(-0.118396030554210304e19), SC_(-0.18077721597744865226496613232167680429316701947429e-18), 
      SC_(0.2007315487162486533634364604949951171875e-6), SC_(0.484821384427736035149791860021650791168212890625e-10), SC_(0.35244982272e11), SC_(0.66975396207649619968e20), SC_(0.50639601528733663055818645133500624155185681965241e-23), 
      SC_(0.2170967974279847112484276294708251953125e-6), SC_(0.10346977737162760356637413145463933451898572504768e-25), SC_(0.52484349362176e14), SC_(0.14238722776793028002018104416492860764265060424805e-12), SC_(0.36977717259341740049057345079935123328376787743457e4), 
      SC_(0.355180674205257673747837543487548828125e-6), SC_(0.20287806536730540463153715791122522205114364624023e-12), SC_(0.18075361207792184359277598559856414794921875e-8), SC_(-0.14129753935776534490287303924560546875e-5), SC_(-0.13543439921672448592686319863688635646982483335197e11), 
      SC_(0.355791058836985030211508274078369140625e-6), SC_(0.41966422727541823005436582324882699435164568058099e-20), SC_(0.56214188225567340850830078125e-3), SC_(0.21398259809600358456883901528625608132466446291041e-28), SC_(0.33532126652331267769382132479020153519397794821114e17), 
      SC_(0.364147808795678429305553436279296875e-6), SC_(0.62041543644016967787649385890347275562817230820656e-16), SC_(0.112208826976711861789226531982421875e-4), SC_(-0.4890405858049007292720489203929901123046875e-9), SC_(-0.25380132927950750614745151203507002931269737872133e10), 
      SC_(0.41233806769014336168766021728515625e-6), SC_(0.36580066080205142498016357421875e-3), SC_(0.78368969261646270751953125e-1), SC_(0.1548500925058203388738880396102715053530118893832e-17), SC_(0.12053469362478877684232105823926676391853113939021e8), 
      SC_(0.468250874519071658141911029815673828125e-6), SC_(0.4736783503633416192e19), SC_(0.25657845772245226891152621395363904506655393367165e-25), SC_(-0.11853116e8), SC_(-0.18751179628961700849769255337274434337397473288701e-14), 
      SC_(0.68897207938789506442844867706298828125e-6), SC_(0.221162365880631296e20), SC_(0.4426536e8), SC_(0.64514155343180504894614159597243663313292927341536e-19), SC_(0.1812732423002478587070521538978714785538743939722e-8), 
      SC_(0.71711195914758718572556972503662109375e-6), SC_(0.1054551841401995264e19), SC_(0.149447225428200880514850723557174205780029296875e-10), SC_(0.11321845307702313256969107657851948689486931698411e-21), SC_(0.12039655478363621612864710662326156428033821468659e2), 
      SC_(0.8440589454039582051336765289306640625e-6), SC_(0.16500875e7), SC_(0.177505408e10), SC_(0.14981564160172185125964081263351575235009960351817e-21), SC_(0.11359400041521647880429712249939997827113705715643e-2), 
      SC_(0.9389232218381948769092559814453125e-6), SC_(0.34272542467624321146683392e26), SC_(0.33883824818190138074762051584e29), SC_(-0.268267505598857216e18), SC_(-0.4765736122164139026308620711936669799666700219745e-39), 
      SC_(0.14005109960635309107601642608642578125e-5), SC_(0.16255437736119050960896e23), SC_(0.1638076981752402804736e22), SC_(0.12357156872339849389749039110242279093654360622168e-16), SC_(0.65926904064845259233343135625850082478676926387063e-17), 
      SC_(0.1407973059031064622104167938232421875e-5), SC_(0.1600049396020919356358656e25), SC_(0.56118849892227423295041715755205124853931264450324e-24), SC_(-0.24559907248456875315540531845570626501285005360842e-16), SC_(0.59281168127682335321956908269468899669273368717922e-4), 
      SC_(0.15967763147273217327892780303955078125e-5), SC_(0.8345118208e10), SC_(0.40453248004571117166922045171872923674527555704117e-15), SC_(-0.61496136691140435164266496e26), SC_(-0.10404042522852265374183951260504393780229288624804e-28), 
      SC_(0.18210504322269116528332233428955078125e-5), SC_(0.2651643312436211771770929152e28), SC_(0.36905974201464127488e20), SC_(0.11870302352028901338122299224941968986968277022243e-16), SC_(0.96444453967501221098008499031138568253013964649005e-19), 
      SC_(0.1885123992906301282346248626708984375e-5), SC_(0.25172518744793432127678756566548684645107602196601e-26), SC_(0.432213410600102056165376e24), SC_(0.1750858822896784444187573935580726214311653166078e-18), SC_(0.12475652059755078495964577464269580491486451957602e2), 
      SC_(0.2010440539379487745463848114013671875e-5), SC_(0.6231334375e5), SC_(0.42204349656676474209296423545367815677309408783913e-16), SC_(0.189095663973354608525312e24), SC_(0.85575637956111474497876880585018076767947579475261e-24), 
      SC_(0.21148944142623804509639739990234375e-5), SC_(0.33435832770024875859604662764468230307102203369141e-13), SC_(0.47324655483842805109613708493123820154516818645152e-26), SC_(0.40599286578442079483896452939559944088354637159455e-23), SC_(0.86086726864892856978021290224683696142061736289937e22), 
      SC_(0.2252993226647959090769290924072265625e-5), SC_(0.1145677201634679759519302305603716263249225448817e-17), SC_(0.57490079546449489559552e23), SC_(-0.18280795434640203579392e24), SC_(-0.23153775255121976847102308866036253916760345172262e-32), 
      SC_(0.2586026539574959315359592437744140625e-5), SC_(0.13906271765126904778015790844071007475134249542492e-23), SC_(0.48651935458110528998076915740966796875e-6), SC_(0.7676005010684497625088e22), SC_(0.55534780484904679566833659602625457533704982490912e-18), 
      SC_(0.318217871608794666826725006103515625e-5), SC_(0.640806732177734375e2), SC_(0.68430225988125784590876934144e29), SC_(-0.91491688131665702501767374089924889091207660385408e-19), SC_(0.13076909413247462911450776886742720618763010654651e-10), 
      SC_(0.3428982154218829236924648284912109375e-5), SC_(0.24666375732421875e3), SC_(0.18343744672083473263280947208875293341634460375644e-19), SC_(0.43015309196536843927560767042450606822967529296875e-12), SC_(0.24696721967211058722599902915223542353530466803084e9), 
      SC_(0.34367412808933295309543609619140625e-5), SC_(0.56812267303466796875e2), SC_(0.375230498611927032470703125e-1), SC_(-0.940448217079392634332180023193359375e-7), SC_(0.27222483126028747567331871746075117244762444634232e4), 
      SC_(0.3576953531592153012752532958984375e-5), SC_(0.14104317457808228352e20), SC_(0.49092389767073363326943535867030732333660125732422e-13), SC_(-0.1768607334231179264e20), SC_(-0.13174027442302826799661544100702814727664015808882e-26), 
      SC_(0.37117524698260240256786346435546875e-5), SC_(0.25937127167980755099163658883298921864479780197144e-14), SC_(0.20948793299367246339967233012199776531758743658429e-20), SC_(-0.5088028e8), SC_(-0.3649939396906969854756148210998242109051626865873e-3), 
      SC_(0.496315487907850183546543121337890625e-5), SC_(0.39944501218548349803692032e26), SC_(0.72472721302229174342168782629869383526965975761414e-16), SC_(0.3013316540734223281106096692383289337158203125e-9), SC_(0.19179116640052050131787066719787819821680219530636e-4), 
      SC_(0.5896066795685328543186187744140625e-5), SC_(0.83540669756266879012950000386178439626405634044204e-20), SC_(0.18486267904e11), SC_(0.711416436871559199062176048755645751953125e-8), SC_(0.16558524086880113634516369045738181687091036568877e3), 
      SC_(0.741827943784301169216632843017578125e-5), SC_(0.57862111028696838884929909418985971569782122969627e-17), SC_(0.21186012666429832052017445676028728485107421875e-9), SC_(-0.909995069378055632114410400390625e-4), SC_(-0.79167347903248615338879018331512795232997106267621e8), 
      SC_(0.1020877971313893795013427734375e-4), SC_(0.54233017649833819224649352104539179464381959405728e-19), SC_(0.1330528539256192743778228759765625e-4), SC_(0.60075625e6), SC_(0.22951727888716333518770359128519740944727307583691e-2), 
      SC_(0.115228258437127806246280670166015625e-4), SC_(0.14980029664002358913421630859375e-3), SC_(0.10872091648e11), SC_(0.974692302406765520572662353515625e-4), SC_(0.19283669680242463690410992722755728906094253397332e0), 
      SC_(0.12364866051939316093921661376953125e-4), SC_(0.256297172992e12), SC_(0.89514893312e11), SC_(0.92516305455080018876889980106170696672052145004272e-15), SC_(0.6956851082506011937598898817563396469969835697595e-7), 
      SC_(0.130162216009921394288539886474609375e-4), SC_(0.759344620746560394763946533203125e-4), SC_(0.22148209406780902835423848339554340607932845033396e-29), SC_(0.1025133774706451157090304e25), SC_(0.78168449939778815541125509826645235096454615091998e-21), 
      SC_(0.151082431329996325075626373291015625e-4), SC_(0.223869393291817180493772750848e30), SC_(0.130767456e9), SC_(0.3479859515209682285785675048828125e-4), SC_(0.10638852224302699211099006621011974474497792275897e-15), 
      SC_(0.1537743446533568203449249267578125e-4), SC_(0.15059710423148686686545261181890964508056640625e-9), SC_(0.117395620691240765154361724853515625e-5), SC_(-0.2890202999114990234375e1), SC_(-0.71323317684118857716768611179394676433168216080032e3), 
      SC_(0.17955519069801084697246551513671875e-4), SC_(0.61594795968322388346471996101172408089041709899902e-14), SC_(0.17182140399616e14), SC_(-0.8879954926669597625732421875e-2), SC_(-0.30902793952357142576725810247768489948284393255416e-3), 
      SC_(0.385829116567037999629974365234375e-4), SC_(0.87243150589952e14), SC_(0.502113922279907786752e21), SC_(-0.44867013175405750605515785144168657045844292877374e-29), SC_(0.6784291389719445280807556938270976838477737526148e-13), 
      SC_(0.5497968595591373741626739501953125e-4), SC_(0.2570904232561588287353515625e-1), SC_(0.142555389836268217827210559488e30), SC_(0.347529082477997995270422396070359436805186081898e-23), SC_(0.15205547141762716339195263933611696099613831306279e-9), 
      SC_(0.67357483203522861003875732421875e-4), SC_(0.2024667237879200631521688091840616152694565244019e-17), SC_(0.1125503860736e13), SC_(-0.28684009472e11), SC_(-0.17312469693572017037903718317715643420749673392298e-14), 
      SC_(0.7117705536074936389923095703125e-4), SC_(0.5225739073284472832e20), SC_(0.188505269646754054144e22), SC_(0.37162215e7), SC_(0.77884931309600959064671298574702199174386529309389e-23), 
      SC_(0.976757219177670776844024658203125e-4), SC_(0.20999384671790071386435906496888593240052529360776e-28), SC_(0.2420024555864064e16), SC_(-0.30929401675776e14), SC_(-0.41122600386595265452718551147832124897352249792332e-19), 
      SC_(0.10531136649660766124725341796875e-3), SC_(0.2080037632e10), SC_(0.951222915825664e15), SC_(-0.2556099821568e13), SC_(-0.16183594291792086140042069404303186458320314897362e-18), 
      SC_(0.1337912981398403644561767578125e-3), SC_(0.54060063803262892179191112518310546875e-6), SC_(0.431251569592525637174387802112e30), SC_(-0.40761757983463978673056514048e29), SC_(-0.42689657423364442342706084804950806299313503328401e-41), 
      SC_(0.135120135382749140262603759765625e-3), SC_(0.15396510045028230750086205123753138601649936845206e-21), SC_(0.23207376953125e5), SC_(0.4279265340301208198070526123046875e-5), SC_(0.11583891006744848427408148566636928242683392055917e4), 
      SC_(0.195464599528349936008453369140625e-3), SC_(0.121048798828125e5), SC_(0.93744699823914178927300605212876675065986065149559e-24), SC_(-0.80269794149945634012159454440908189848597528021079e-27), SC_(0.85066182884649426317108513864013994356814573463698e13), 
      SC_(0.237512751482427120208740234375e-3), SC_(0.17427138898629124241779209114611148834228515625e-9), SC_(0.33052706405189979932401911355555057525634765625e-10), SC_(-0.56586559029248e14), SC_(-0.27820838535642758409712041258322710540301181627086e-10), 
      SC_(0.371529138647019863128662109375e-3), SC_(0.12312668720852486471439889495482766790246387245134e-18), SC_(0.2606333696e10), SC_(-0.20283999631852400735709807122475467622280120849609e-12), SC_(0.51157368515785829729510457458840434162083885872526e1), 
      SC_(0.6058839499019086360931396484375e-3), SC_(0.5217478992180805632e19), SC_(0.4103625118732452392578125e0), SC_(-0.34598269870134102862979652570629696128889918327332e-14), SC_(0.11327789817456084957191801849955967708479747758643e-5), 
      SC_(0.7126068812794983386993408203125e-3), SC_(0.834977504013651542016e21), SC_(0.32316998463633678540817957675549120530669733319939e-24), SC_(-0.30853410104558776083649718202650547027587890625e-11), SC_(-0.14497478832531455977117278820477686854081973067291e-6), 
      SC_(0.11331872083246707916259765625e-2), SC_(0.7652003928866816e17), SC_(0.2029340237758464e16), SC_(0.46751457751334912e17), SC_(0.48218635922355250104615961298328372157645025546126e-24), 
      SC_(0.1283943769522011280059814453125e-2), SC_(0.49121531251266280226816e23), SC_(0.311947574615478515625e2), SC_(-0.1049853937656833303417716736e28), SC_(-0.33243523576876450506395708449850694875195152411876e-36), 
      SC_(0.210290006361901760101318359375e-2), SC_(0.4932620110638545248192561152e28), SC_(0.39087764918804168701171875e-1), SC_(-0.97106783192338154528339705536497949989183098296053e-22), SC_(0.10716357073204930403806358122863820937624055505006e-9), 
      SC_(0.43084057979285717010498046875e-2), SC_(0.7663212560384e13), SC_(0.15427949623089271042983806318685344877161824683753e-21), SC_(-0.10417810006584787840822059479251038283109664916992e-12), SC_(0.17169635051379646499605489602235548137277810862201e-2), 
      SC_(0.47173579223453998565673828125e-2), SC_(0.28601321158264026057365024112938563807684451932578e-26), SC_(0.40558081566683637682324548023871102486737072467804e-15), SC_(0.15528565625e6), SC_(0.46209895630262119473421061925210201261400658526527e-2), 
      SC_(0.4801772534847259521484375e-2), SC_(0.45398853613796871007741958773072074733645399780696e-27), SC_(0.7560605184e10), SC_(0.647133457931658995221368968486785888671875e-8), SC_(0.97150343363634710498793099113043775255963668957287e1), 
      SC_(0.52362792193889617919921875e-2), SC_(0.62775075435638427734375e-1), SC_(0.35503316103945850232270764479380886768922209739685e-14), SC_(-0.82191520164301076767365827890898799523711204528809e-14), SC_(0.94149739510744793867407461448723332321993376907253e9), 
      SC_(0.6464368663728237152099609375e-2), SC_(0.34548660250448633356353536e26), SC_(0.86745184e8), SC_(0.17538673631556802019439568731943899118999076469638e-25), SC_(0.18965171138822577964416888446520897074777671876756e-13), 
      SC_(0.8755207993090152740478515625e-2), SC_(0.19334258367635594160367929817354861347764157147378e-29), SC_(0.19905875479770919489158908039133416469773640855578e-23), SC_(0.16162294913370678880369874300115817788991989800707e-19), SC_(0.10302469141608676846163602607369970727019331722344e23), 
      SC_(0.105386711657047271728515625e-1), SC_(0.10971066146022716822519808e26), SC_(0.14238127367174709429046052203053697640243880490063e-25), SC_(0.12445412e8), SC_(0.81057286137718371719879398529595220079298267815081e-18), 
      SC_(0.1206146739423274993896484375e-1), SC_(0.3369771240234375e4), SC_(0.151668605394661426544189453125e-2), SC_(0.517785288393497467041015625e-1), SC_(0.12613012578767509848590874658523101847661158577119e1), 
      SC_(0.12089609168469905853271484375e-1), SC_(0.97507090560084943816369411520484629201082488192398e-26), SC_(0.399211437727154176e18), SC_(-0.43687648e8), SC_(-0.12712787183712312314723670820348108729409028012771e-14), 
      SC_(0.1223853044211864471435546875e-1), SC_(0.149331171875e5), SC_(0.25902370885233137108535751670716469965971562317009e-22), SC_(0.1585234087010320425115139642002759501338005065918e-12), SC_(0.87548765889989152595921377575214471779646231337304e6), 
      SC_(0.1719185896217823028564453125e-1), SC_(0.68342607872e11), SC_(0.74717364929222058918122144571648805171440455019649e-24), SC_(-0.19811498361971269233094972150865942239761352539063e-11), SC_(-0.62931581399346532875402225391415988485126399044258e-3), 
      SC_(0.2028485946357250213623046875e-1), SC_(0.43614054590079831541515886783599853515625e-7), SC_(0.84901359375e5), SC_(-0.402032989501953125e3), SC_(-0.14457959445537210532900171961971212086978017332471e-3), 
      SC_(0.244647525250911712646484375e-1), SC_(0.15256551424e13), SC_(0.54413439958598412815701968192616533315231208689511e-18), SC_(0.12193387618025211711902944244911850546486675739288e-14), SC_(0.68928140233641690874066639514030215078105803150605e3), 
      SC_(0.2503361739218235015869140625e-1), SC_(0.12629954201195087283302254587899482451973653951427e-19), SC_(0.18469444489392706000542236672e29), SC_(0.2008535602726624347269535064697265625e-5), SC_(0.15376107245372323818643874859148652065437313877165e-9), 
      SC_(0.256623141467571258544921875e-1), SC_(0.33872525312e11), SC_(0.14235380836999617679740726134029336127093459674064e-24), SC_(-0.54761008267973783831005426492301530003864451501272e-24), SC_(0.6002641543057883014281295950703999178968208670234e8), 
      SC_(0.2816712856292724609375e-1), SC_(0.20385418701171875e4), SC_(0.70816101925749637511437795979463150075616795220412e-19), SC_(-0.71224997471100448542813410313101485371589660644531e-12), SC_(0.14555984968538450265872789550217916380493832680261e3), 
      SC_(0.389046929776668548583984375e-1), SC_(0.18785430908203125e2), SC_(0.59877638017122304e17), SC_(-0.70611488161624017152739885005985343013890087604523e-15), SC_(0.23617650093748762722636584030199656175041288661882e-6), 
      SC_(0.500512681901454925537109375e-1), SC_(0.8265168543968919552e19), SC_(0.5917616329149883895863312384e28), SC_(0.1813467698915509796864e22), SC_(0.73014045504603704166845487809073717258890497149708e-34), 
      SC_(0.552595667541027069091796875e-1), SC_(0.24714513671875e5), SC_(0.15755500574372884400188753119438633820692530207452e-20), SC_(-0.1058852421875e6), SC_(-0.1385729677950429487289703993301344498336095174718e-5), 
      SC_(0.59153951704502105712890625e-1), SC_(0.28119016669184e16), SC_(0.46283060736691983672672256e26), SC_(0.33705512178551436908836997015329410971321759480507e-27), SC_(0.10567909802110001773228477874638062345056246984665e-17), 
      SC_(0.70532612502574920654296875e-1), SC_(0.509380480278670082048e21), SC_(0.6086066368937984e16), SC_(0.1157226484375e6), SC_(0.78636736502206833931370358047905890205013561234128e-20), 
      SC_(0.90219162404537200927734375e-1), SC_(0.1235392397312e15), SC_(0.312691328e9), SC_(-0.59579515824188623238913051216592009495798265561461e-17), SC_(0.98185483246869333393733269663055298966868810132828e-9), 
      SC_(0.9155814349651336669921875e-1), SC_(0.7803426304e10), SC_(0.56616158650510265207267401876833901042118668556213e-16), SC_(0.58011473761102867408662758102440028661308329567254e-29), SC_(0.23340628674965522944554049402356633166832118500539e6), 
      SC_(0.918718278408050537109375e-1), SC_(0.16469549560546875e4), SC_(0.1374542701881864559254609048366546630859375e-9), SC_(-0.64928905e7), SC_(-0.71534597326061132238132663299218904215199558605905e-7), 
      SC_(0.93234360218048095703125e-1), SC_(0.16614582122398761824502040001774922934468792234952e-23), SC_(0.51399625837802886962890625e-1), SC_(-0.79666525e7), SC_(-0.22357874328410148246257143325730977651923761352801e-5), 
      SC_(0.1238969862461090087890625e0), SC_(0.50384063720703125e3), SC_(0.404188410838900933656576e24), SC_(-0.113500412081864704e18), SC_(-0.71516214731582476895868452877782309419286266783848e-27), 
      SC_(0.138805568218231201171875e0), SC_(0.12325753201362607276032e23), SC_(0.6155888e8), SC_(0.17478379282804678163804057433594607573468238115311e-16), SC_(0.17562486771277811027907072136239595155317035456964e-12), 
      SC_(0.13968928158283233642578125e0), SC_(0.24041757569648325443267822265625e-4), SC_(0.75867372421355059130925056e26), SC_(0.14971352008162262765134699677531090489539158244758e-25), SC_(0.47162892053614125151645366512041674122628514159979e-8), 
      SC_(0.14648687839508056640625e0), SC_(0.189117259979248046875e2), SC_(0.64672735821725592375575075720917084254324436187744e-14), SC_(-0.1027551e8), SC_(-0.25659659832599873979437484533439372802557250970669e-6), 
      SC_(0.15200613439083099365234375e0), SC_(0.1863758428953588008880615234375e-2), SC_(0.64390535785573869136816111541365970083461434114724e-18), SC_(0.179179345703125e4), SC_(0.15376350655164216216009618321675610001686589538958e-1), 
      SC_(0.15778529644012451171875e0), SC_(0.625237882301288294684127322398126125335693359375e-11), SC_(0.31923294921875e5), SC_(0.2702271331145311705768108367919921875e-6), SC_(0.12723303520232964595307120813927223117434534421018e3), 
      SC_(0.23154227435588836669921875e0), SC_(0.2277369958392227999866008758544921875e-5), SC_(0.817438856761605722472448e24), SC_(0.6475818008051712e16), SC_(0.10055583404578821098090114781120362999351859150366e-25), 
      SC_(0.23772360384464263916015625e0), SC_(0.24407187456e12), SC_(0.8943501494940164775471203029155731201171875e-9), SC_(0.1651694635057152e16), SC_(0.55867742159906661083523501546119984619588397060731e-19), 
      SC_(0.2875674068927764892578125e0), SC_(0.6605737295872e13), SC_(0.14297552031194982191664166748523712158203125e-9), SC_(-0.3615199585953929943575623545608282448133710095244e-29), SC_(0.42333010096754627516650214935050999386320576617531e1), 
      SC_(0.3783153593540191650390625e0), SC_(0.17932992773095424e17), SC_(0.21370270682311573798295434301053319359198212623596e-15), SC_(0.104508124376678779299254529178142547607421875e-8), SC_(0.17691847946056675201705896851975198158108716530442e-2), 
      SC_(0.4375163614749908447265625e0), SC_(0.8310674814993035397492349147796630859375e-7), SC_(0.34676245389175740751178287273653290934930133737613e-25), SC_(-0.13512023861210132774912e23), SC_(-0.30627734774485470796026210351340366620342763472332e-20), 
      SC_(0.47186577320098876953125e0), SC_(0.33517950214445590972900390625e-4), SC_(0.19742964299069534676394727058454381385388387570856e-19), SC_(0.172844315049984e15), SC_(0.15571082388851563940538874881395087814248417447048e-12), 
      SC_(0.4837694466114044189453125e0), SC_(0.2555249786376953125e2), SC_(0.14830236860416e15), SC_(-0.23092787867579242139823118840080695690630818717182e-17), SC_(0.1436783479173125676726421090088414270562031415186e-5), 
      SC_(0.557569086551666259765625e0), SC_(0.3669039814207884562006016e25), SC_(0.11718498101389684343524611202444485336116031248821e-19), SC_(-0.1476470668143886336e19), SC_(-0.23234337351923507362878443677455037468061124379692e-28), 
      SC_(0.150170361995697021484375e1), SC_(0.22653612064768e14), SC_(0.931230204913778688e18), SC_(0.111986264311332864e18), SC_(0.13503306649655457756964944372267963200179420769152e-24), 
      SC_(0.151865482330322265625e1), SC_(0.13662545780395737088e20), SC_(0.581006519496440887451171875e-2), SC_(-0.4810541940969415009021759033203125e-4), SC_(0.26088930707430748487397772247873081286819775856106e-7), 
      SC_(0.155066859722137451171875e1), SC_(0.57957362287197611294686794281005859375e-6), SC_(0.15315803808343942142559420110171227706488770309301e-26), SC_(-0.24444800103136446196416126097616938750434201210737e-16), SC_(0.90955032242841468238880271499124261832873238707086e6), 
      SC_(0.15793964862823486328125e1), SC_(0.21153786174505042274269802208549073334284835448335e-27), SC_(0.12200210459945015628591136191971600055694580078125e-11), SC_(0.29733496255367166587727790005810361189438756346348e-24), SC_(0.61221579859114224783044449357017488484292020104154e19), 
      SC_(0.18657958507537841796875e1), SC_(0.14212401871702140532249813986709341406822204589844e-11), SC_(0.7765285505269888671753264475228206720203161239624e-14), SC_(-0.14057745442658881454581377878543473252314163378027e-27), SC_(0.34376559971843492093918769802879147369223951311666e15), 
      SC_(0.200531482696533203125e1), SC_(0.66637542724609375e2), SC_(0.6977945379592210481152e22), SC_(-0.1538061536848545074462890625e-1), SC_(0.91899125407594934397880198635868999618633362477239e-11), 
      SC_(0.20796673297882080078125e1), SC_(0.23342568365977612121539683156384858975229690258857e-19), SC_(0.23369637528405983173673414509188828169783391786041e-19), SC_(-0.34493877942163741868032e23), SC_(-0.14269697288704700026456987875655755932501905967557e-20), 
      SC_(0.2267075061798095703125e1), SC_(0.2218880925579554614742614016e28), SC_(0.65205579121751122872981967584324703322264654443958e-30), SC_(-0.18193587803964032632038804720580493128403998248643e-24), SC_(0.18773458887343617246865569088201403078203499932518e-3), 
      SC_(0.22948391437530517578125e1), SC_(0.1066555328369140625e3), SC_(0.576385747842019784963129344e27), SC_(0.266197237863696756221543182618916034698486328125e-10), SC_(0.10500257852828952292894301318898021528041485694642e-12), 
      SC_(0.3046932220458984375e1), SC_(0.18625525552055897944743393684375905872507558290159e-28), SC_(0.3957605632e10), SC_(0.5475589599790442463245199178345501422882080078125e-13), SC_(0.18339098800214958731143335962554579768175711553822e3), 
      SC_(0.317214488983154296875e1), SC_(0.1787234588447839005169755006044073262147782230584e-29), SC_(0.808940345497902097371234304e27), SC_(-0.152660180130070528e19), SC_(-0.14544688374658353436675575543549050491674381303428e-29), 
      SC_(0.3488028049468994140625e1), SC_(0.72476270262057055954832829597322805701906101027987e-24), SC_(0.21465711771648e14), SC_(-0.1243223625e7), SC_(-0.36901502835170062112191501271146371543800986080238e-11), 
      SC_(0.393867969512939453125e1), SC_(0.51874020272408766185256645893864430640143203159534e-29), SC_(0.2930298149585723876953125e0), SC_(-0.72393528671721441014597075991332530975341796875e-10), SC_(-0.55868866117473662932589074038762750761638800985872e1), 
      SC_(0.502499103546142578125e1), SC_(0.1056039999054108688384e22), SC_(0.988096714019775390625e0), SC_(-0.234368023278792403589267456e27), SC_(-0.96175701943042253761365952919230517595558464851346e-35), 
      SC_(0.7657299518585205078125e1), SC_(0.3369778067696671541852992959320545196533203125e-10), SC_(0.24060948594242438809947398636879256628162693232298e-16), SC_(-0.102500032512e12), SC_(-0.15294312119943326330072156244796735400596544767909e-9), 
      SC_(0.7906418323516845703125e1), SC_(0.48393864862901030998784493751613466975544853481209e-29), SC_(0.6576157757081091403961181640625e-3), SC_(0.87178096e8), SC_(0.74448636454103820303158662890650993329201889005998e-7), 
      SC_(0.12346179962158203125e2), SC_(0.304309702915784704e18), SC_(0.530327327997952e15), SC_(0.98908409223666358032640562140958007120161710190587e-19), SC_(0.1601572720936410379824366381268671633071010045693e-14), 
      SC_(0.1236770153045654296875e2), SC_(0.2486598558179742193396249971826250657613854855299e-16), SC_(0.425586784e9), SC_(-0.16583159541741498976819002564297989010810852050781e-11), SC_(0.12432911383477987669202622673990389191092739265681e0), 
      SC_(0.130841693878173828125e2), SC_(0.516425012058796509045456896e28), SC_(0.3000732163818651513042917353020530062720192427143e-28), SC_(-0.12223677825927734375e3), SC_(-0.59600143343483667135078068259806046605914824069307e-15), 
      SC_(0.1437510585784912109375e2), SC_(0.99939889697253647682373411953449249267578125e-10), SC_(0.17284426226994398730217260527005023625882369764373e-25), SC_(0.589887122259824536740779876708984375e-5), SC_(0.82977414248016272525740543786918282743356185060072e6), 
      SC_(0.155408535003662109375e2), SC_(0.245863923712e12), SC_(0.88887406204705208581375488864563298833942634608052e-27), SC_(-0.3278108895443665460334159433841705322265625e-8), SC_(-0.38929911183967971616546680441778615253883243106001e-6), 
      SC_(0.172352466583251953125e2), SC_(0.28185915786679144323656487358675803989171981811523e-13), SC_(0.549495171586755759562947787344455718994140625e-11), SC_(0.77621669365362350522745280609523053559517416326308e-27), SC_(0.29811356642573579120528904593230871758527217500489e14), 
      SC_(0.2496727752685546875e2), SC_(0.755542572949963187056710012257099151611328125e-10), SC_(0.140444835444342210428928e24), SC_(0.333316164222896912203776e24), SC_(0.61697425131819095690805450672367980932042039110706e-33), 
      SC_(0.251142292022705078125e2), SC_(0.95878670103350712202666425664563793145215793375946e-30), SC_(0.1179918399429880082607269287109375e-3), SC_(-0.18006479509999357834382910370507602237921673804522e-16), SC_(-0.20767359889649299374802028064947020874111331139665e4), 
      SC_(0.3167168426513671875e2), SC_(0.8758339475889442837797105312347412109375e-7), SC_(0.16276235359198247911424e23), SC_(-0.478584259033203125e3), SC_(-0.98355836090519231809970625809868089762136898416754e-13), 
      SC_(0.39971416473388671875e2), SC_(0.42171809391584026037414002688e29), SC_(0.1746199838817119598388671875e-1), SC_(0.14080540591494208027622707362473717849386561250306e-29), SC_(0.57731972252409096631390602463457410540926582027231e-12), 
      SC_(0.4151866912841796875e2), SC_(0.84098145009994339684283693509730169685090217512879e-22), SC_(0.23743823476252146065235137939453125e-5), SC_(0.12975368223172144971355734810458670835942029953003e-13), SC_(0.41662137710714344961872274967200362824507894251896e10), 
      SC_(0.43738616943359375e2), SC_(0.12385733574656e14), SC_(0.18116829833984375e4), SC_(-0.6090077153104283339067490304e30), SC_(-0.17586838254223165935107868934475381781225966395627e-34), 
      SC_(0.64164215087890625e2), SC_(0.60759354638336e14), SC_(0.15436498306983203153379328e27), SC_(0.2971673893625847995281219482421875e-6), SC_(0.3978686729151661279344274889478280044774036238231e-19), 
      SC_(0.7396154022216796875e2), SC_(0.434943033344e14), SC_(0.44933803488252409781774450688e29), SC_(0.41030704775427855914016195271187825710512697696686e-15), SC_(0.51301839608224722528804475837632403261204586969405e-20), 
      SC_(0.877169342041015625e2), SC_(0.96918456256389617919921875e-2), SC_(0.1194695377349853515625e2), SC_(0.33116262677524781031382708484933630188606912270188e-17), SC_(0.17384371767206275909057752319046159769983534621041e2), 
      SC_(0.9329457855224609375e2), SC_(0.16489136475174385000940710160662947664743371856133e-23), SC_(0.5227976893381994977626195689487990972659902516595e-26), SC_(-0.43789996198029257357120513916015625e-5), SC_(-0.15497773046920934314700228246837580600610142935771e7), 
      SC_(0.9570084381103515625e2), SC_(0.21871560124697031597619436421586769370151159819216e-20), SC_(0.10437099306084773731823749979533318132940422628963e-21), SC_(0.31689929654272e15), SC_(0.26374911044597243314245848273113923510941888515539e-13), 
      SC_(0.1074904022216796875e3), SC_(0.41020025634765625e3), SC_(0.424105413258075714111328125e-1), SC_(0.12980568876719278392783962772227823734283447265625e-10), SC_(0.80632850646709506287902787976369322104798297701048e0), 
      SC_(0.121872039794921875e3), SC_(0.13542694460127387585121963575751635744381928816438e-16), SC_(0.12486284559632162318061163896272346215674913706846e-28), SC_(-0.17388853194235818957341654922288398665841668844223e-15), SC_(-0.29929997600778273592083592409674281287091033348276e16), 
      SC_(0.131728790283203125e3), SC_(0.5893691639956045555799425024e28), SC_(0.269286016251644665671840694272e30), SC_(-0.19225120205890561304280076617299461303374835609466e-28), SC_(0.23747567274649262115100375303568860119505302660168e-27), 
      SC_(0.175763397216796875e3), SC_(0.12685536053155962454420298550668289028209301250172e-19), SC_(0.1597107696533203125e2), SC_(0.193429025e7), SC_(0.30514382609340192004140933870767164997572197608833e-6), 
      SC_(0.19177764892578125e3), SC_(0.84045921502887936e17), SC_(0.19129386995031684168433400267318972464065419958335e-25), SC_(-0.16734773921809110196565891338898506367022129154862e-29), SC_(0.28985510548725002737255597613665541364819200143545e5), 
      SC_(0.366723419189453125e3), SC_(0.4729196966323688478605312e25), SC_(0.75546687480489050112e20), SC_(0.30924904845017088e17), SC_(0.13997276569086734412665389893461313536545790758017e-29), 
      SC_(0.403912353515625e3), SC_(0.70494434112333692610263824462890625e-6), SC_(0.4871552734375e3), SC_(-0.79337131194643530951688192e26), SC_(-0.28185565809437219331198474902626375696922113021409e-26), 
      SC_(0.434518829345703125e3), SC_(0.429355800151824951171875e0), SC_(0.1905407088997890241444110870361328125e-5), SC_(-0.1920795655896742530676212337387238725422793886484e-27), SC_(0.41394799266597316262611547301984058012213693213971e4), 
      SC_(0.441912933349609375e3), SC_(0.200361263104e12), SC_(0.7487427472337473110016e22), SC_(-0.94412297518186496e17), SC_(-0.2653039857585517453143101871082962619886494600764e-26), 
      SC_(0.4589617919921875e3), SC_(0.71164645460638957568e20), SC_(0.3440692353251506574451923370361328125e-5), SC_(0.491521358489990234375e0), SC_(0.36374021419600170802135512961854475267516040798357e-10), 
      SC_(0.60508642578125e3), SC_(0.986511168e9), SC_(0.864834304e9), SC_(-0.1221882493796352e16), SC_(-0.12679767958599401117463725341907765508229105680362e-18), 
      SC_(0.82290283203125e3), SC_(0.36223742228003175114281475543975830078125e-7), SC_(0.12701055793371805794043341177064064973639689881679e-22), SC_(-0.12639319e8), SC_(-0.11012414677841827102143604394095232114440956402107e-6), 
      SC_(0.826349853515625e3), SC_(0.96257212198157311804282581954172398476352382607862e-31), SC_(0.590303199232e12), SC_(-0.23093588197298231534659862518310546875e-6), SC_(-0.47251948104414426539316167928430961763614109497953e-8), 
      SC_(0.101428350830078125e4), SC_(0.73197230504121553597519782482022700030639835409862e-27), SC_(0.56014250442752e14), SC_(0.10064316558837890625e3), SC_(0.16527977649070885637997380699331340882257467916328e-8), 
      SC_(0.10313978271484375e4), SC_(0.10318525717298732830018437311991874594241380691528e-14), SC_(0.14367766698608619435617583803832530975341796875e-9), SC_(-0.895382299859193153679370880126953125e-6), SC_(-0.52777525316528912144605771534399851901207874711783e6), 
      SC_(0.10841290283203125e4), SC_(0.45628768256e12), SC_(0.44396802085974908568299784035032644232939350037448e-25), SC_(0.18678055712586235137343338338755084705573535942824e-26), SC_(0.14825366330028607186953970497682490906029019303394e7), 
      SC_(0.1401687744140625e4), SC_(0.2510223973128944408017559908330440521240234375e-9), SC_(0.1164431796875e6), SC_(-0.660644830067038461622222848e27), SC_(-0.47960462509741734974205321792595950931889095335366e-28), 
      SC_(0.15455189208984375e4), SC_(0.90718428578382195030384883514111792400934880018881e-30), SC_(0.6565417468297216e16), SC_(0.460657443285032239104e23), SC_(0.12799003681657237864315630362352184152409603951107e-28), 
      SC_(0.1910833251953125e4), SC_(0.17696226098322235566195903544439715915359556674957e-14), SC_(0.1108289011237349741545443748691468499600887298584e-12), SC_(-0.2495210247598112768e19), SC_(-0.54899796206745991933997756649992143738257192929546e-18), 
      SC_(0.2011733154296875e4), SC_(0.19581301161984e14), SC_(0.85766768651814545869177326724802966485319195188075e-29), SC_(-0.103833197499625384807586669921875e-3), SC_(-0.33700014883516626520019369200567494039429584096042e-9), 
      SC_(0.2306111083984375e4), SC_(0.1685688489456173056e19), SC_(0.22256795142604778055852756615936599983521384333793e-27), SC_(0.14603023269556422518276493291433659749145590467378e-18), SC_(0.19777900026792559511511825473920177499794471914611e0), 
      SC_(0.2791671630859375e4), SC_(0.267051548817752064e18), SC_(0.3821992612462592e16), SC_(-0.513896026611328125e2), SC_(0.47465293649814820831954830513948060693670317100928e-17), 
      SC_(0.3408779052734375e4), SC_(0.20716176e8), SC_(0.18045615079140466679736426458546816320449579507113e-17), SC_(0.13555148115074189263395965099334716796875e-8), SC_(0.48164218033389365156625209765038103431165517985122e0), 
      SC_(0.3542151123046875e4), SC_(0.23456829198204715014597354638681281358003616333008e-13), SC_(0.1943433088069657088681196910329163074493408203125e-10), SC_(-0.12137352751010333009649936296477139513819154537089e-23), SC_(0.9333089944235657405856672732645955389783286783745e12), 
      SC_(0.7262e4), SC_(0.29360551054278656e17), SC_(0.22317236842790725727033694003705985580674980395081e-28), SC_(0.3551572091297857536e19), SC_(0.77717359263479130667388609725775170195499855795832e-25), 
      SC_(0.7298279296875e4), SC_(0.135008262029312e15), SC_(0.11206973876953125e4), SC_(-0.833275332470505472e18), SC_(-0.39896293187932511702409990531619082551759834612461e-23), 
      SC_(0.84882138671875e4), SC_(0.1164516231628986060845252084551879447407718437546e-22), SC_(0.6352472452890624e16), SC_(0.9560064697265625e2), SC_(0.61539124658325181782209897121876769029174304828769e-10), 
      SC_(0.8893943359375e4), SC_(0.2543300329755485778505163471925434570765698602578e-29), SC_(0.3695086771282607429611744009889662265777587890625e-11), SC_(0.30414472917553246177763126567583640280645340681076e-15), SC_(0.14819844701086027858443403271448375440180967242547e13), 
      SC_(0.98628369140625e4), SC_(0.54858798980712890625e2), SC_(0.2356236308287407155148684978485107421875e-6), SC_(0.4253408337513412943516008448e28), SC_(0.28310666672514729188368235301172552333474839823256e-28), 
      SC_(0.119369521484375e5), SC_(0.6284878833111793664e21), SC_(0.191033888e9), SC_(0.39331607614135449258906745840093203969711765921602e-22), SC_(0.24703761293442289267167403830981450356576108475156e-14), 
      SC_(0.147901005859375e5), SC_(0.62520772668534154026944814518561754825703991045316e-23), SC_(0.19445130267235161963321360384e29), SC_(-0.1193196866669472955128396274293578471770160831511e-17), SC_(0.37070531072257762272085483567842416858990215887893e-9), 
      SC_(0.1624405078125e5), SC_(0.40561403505621103444471068204533651486640155603425e-24), SC_(0.1332809589803218841552734375e-1), SC_(0.9897776246657427883580136193775026766383806631211e-23), SC_(0.90460833618467238772568452668297266842410945407588e11), 
      SC_(0.212897265625e5), SC_(0.312131216214219971638146891776e30), SC_(0.287488675e7), SC_(-0.23154143879988708931705332361161708831787109375e-9), SC_(0.36218305845932609136384265282122334602299609524974e-18), 
      SC_(0.2428015625e5), SC_(0.9274355505795028875581920146942138671875e-8), SC_(0.26150225e6), SC_(0.11752843565346520206117193700482738416557282334907e-21), SC_(0.65259789793303665112616821920019088303053096992953e1), 
      SC_(0.3443290234375e5), SC_(0.87738095954812459262649215691458087947041111220869e-24), SC_(0.15664042328847327389951260556699708104133605957031e-11), SC_(-0.254119e6), SC_(-0.12772679808309511627543152880924722250588088904856e-5), 
      SC_(0.3773583984375e5), SC_(0.114166624e9), SC_(0.92872925184e11), SC_(-0.21438933117678971029818058013916015625e-6), SC_(0.64605728869665645180655944572088132079855990068348e-10), 
      SC_(0.4905428125e5), SC_(0.77207493599362048142253911464649718254804611206055e-14), SC_(0.3302073455415666103363037109375e-3), SC_(0.18890981105259239958282790894372737966477870941162e-13), SC_(0.61867208756145935926407153641591060719655132590955e7), 
      SC_(0.503876328125e5), SC_(0.72534660121208050493385086597564193056086878641509e-19), SC_(0.12543467133030450355590801336802542209625244140625e-10), SC_(0.31351818084716796875e2), SC_(0.63794778343082751128672836783837473856982281965889e-2), 
      SC_(0.6055764453125e5), SC_(0.21872156251105889011820549956628982266049199267854e-22), SC_(0.40034377976350386198819103091685731105225964140265e-27), SC_(0.27609765618122752e17), SC_(0.14560406525664773387691827891026264861711885032388e-16), 
      SC_(0.647452890625e5), SC_(0.731999936e9), SC_(0.2930758730861938998746296647368581034243106842041e-13), SC_(-0.52838748931884765625e2), SC_(-0.17120943291351892258740815320009400558969058830526e-8), 
      SC_(0.652611328125e5), SC_(0.15427774721484081030600798989382838044548407196999e-15), SC_(0.19426667219324400548430276103317737579345703125e-9), SC_(0.58856992e8), SC_(0.36030403476542449556475604748668985232390371856757e-8), 
      SC_(0.815536015625e5), SC_(0.230844914913177490234375e0), SC_(0.3524259033203125e4), SC_(-0.1321976125e7), SC_(-0.23109655491331924663927580812478349761115365015562e-7), 
      SC_(0.870208046875e5), SC_(0.321584384e10), SC_(0.1875353171365556903538163169287145137786865234375e-10), SC_(-0.53437487793849893766722672467682446406173285904928e-27), SC_(0.81752691838560122383582346094261293418998308279632e0), 
      SC_(0.1250561640625e6), SC_(0.18213786e8), SC_(0.4530736e7), SC_(-0.6338109e7), SC_(-0.82054947889433688858556789211045548313964158982319e-10), 
      SC_(0.14622103125e6), SC_(0.89081879080330633735584910937177482992410659790039e-14), SC_(0.392437056867112321024e21), SC_(0.81061882297455856620945431847309806789279862382358e-24), SC_(0.51414750463934655970368369989612419137026160043331e-4), 
      SC_(0.1743905625e6), SC_(0.1477561092376708984375e2), SC_(0.30685072560418650741795681818015688728696009026275e-29), SC_(0.38635334931313991546630859375e-5), SC_(0.14930460404164659296991650253819651463281336520512e1), 
      SC_(0.18927953125e6), SC_(0.558697130491904e16), SC_(0.15689940429654907896725504e26), SC_(-0.55965794498735732531713438220322132110595703125e-10), SC_(0.43253763049715524208571587297087894361800756872535e-21), 
      SC_(0.2110425e6), SC_(0.2278860669204673264954113440517087889741271316559e-28), SC_(0.13786283453186048e17), SC_(0.2317149639129638671875e1), SC_(0.57271797542079362254125705553590497014434725405181e-10), 
      SC_(0.22300921875e6), SC_(0.22960517578125e4), SC_(0.46933254639405441853106942079784734541910233270121e-28), SC_(0.1788677712888375737065871362574398517608642578125e-12), SC_(0.49240542827705470999815066512520633293229227044991e3), 
      SC_(0.243351703125e6), SC_(0.2739399197316094099456e22), SC_(0.49426852584757985376029409962939098477363586425781e-12), SC_(-0.51383110636537278815143709462601173676432608772302e-20), SC_(0.16335452024035439445812369982936378131834825058997e-5), 
      SC_(0.35698746875e6), SC_(0.1922772196023861248e19), SC_(0.39861534375e6), SC_(-0.79583452052226943582938917254310240423365030437708e-17), SC_(0.14972539396832816705553188160320970310632940548863e-12), 
      SC_(0.6869200625e6), SC_(0.12406291034494643099606037139892578125e-5), SC_(0.60078474312334545656635060929362382794743178141472e-29), SC_(-0.2437755379502970498606373439542949199676513671875e-10), SC_(-0.29175644046652151721471627315205848278147317324593e4), 
      SC_(0.9115189375e6), SC_(0.179409878467662494683889664e27), SC_(0.152616857880340486461855087352290638591512106359e-16), SC_(-0.1373514587769293435305984e26), SC_(-0.37222221373521878809912319999667794920422002396464e-36), 
      SC_(0.938919625e6), SC_(0.12335309427680403189998774921476345362014725992594e-21), SC_(0.868360405803514368017204105854034423828125e-8), SC_(0.49951384010752e14), SC_(0.1087349672869820840168485856669779192236371190719e-14), 
      SC_(0.10005244375e7), SC_(0.11613385491986150110932385359774343669414520263672e-12), SC_(0.1767129607947373434957201408e28), SC_(0.46881775649030144e17), SC_(0.19756130934559701361236894181742053882125637225069e-28), 
      SC_(0.117237625e7), SC_(0.28658838e8), SC_(0.861307183935277657013354496e27), SC_(-0.337333418428897857666015625e-2), SC_(0.18238538582222796557049611161862806664203534063553e-18), 
      SC_(0.1600417625e7), SC_(0.39075846958449925554176e23), SC_(0.20905065178933313063680543564260005950927734375e-9), SC_(0.30890848880558885901418688453847335919234123879917e-24), SC_(0.1474164985779584031693927432441780851726669580882e-7), 
      SC_(0.167349975e7), SC_(0.335835966325248591601848602294921875e-5), SC_(0.5924034386893197017088e22), SC_(-0.1327253130511962808668613433837890625e-5), SC_(0.17316118393461797400689218961605338061094088491255e-10), 
      SC_(0.1693841875e7), SC_(0.988439261913299560546875e0), SC_(0.14889054402373871810492857583914434629716871949512e-24), SC_(-0.4169041500912129549760720692574977874755859375e-10), SC_(-0.23105803666133451280534670880230914719356541102847e-2), 
      SC_(0.190442875e7), SC_(0.237157376e10), SC_(0.3888856079211167744e20), SC_(-0.61913955997614338586966520328047636212431825697422e-17), SC_(0.19833300648363190686727867942176248871986575138248e-15), 
      SC_(0.1919959e7), SC_(0.26904405370231643246370367705821990966796875e-8), SC_(0.529686175286769866943359375e-2), SC_(-0.17135624122995048290227899055737648126296335249208e-18), SC_(0.71294777984487009571872221056556404754201103533872e4), 
      SC_(0.1986497625e7), SC_(0.189941275119781494140625e1), SC_(0.133596098423004150390625e1), SC_(-0.344017310999333858489990234375e-2), SC_(0.40865700009209118704310385337668006597087414806334e-2), 
      SC_(0.28672805e7), SC_(0.56191317180416e14), SC_(0.35222303584084124587381803803722666908207497246143e-28), SC_(-0.56519235158702940680086612701416015625e-6), SC_(-0.13957538937073804403987940214950748376734725386866e-12), 
      SC_(0.3057799e7), SC_(0.57031360774144e14), SC_(0.334671207278780147040256e26), SC_(0.186068168841302394866943359375e-2), SC_(0.44385547752902791796369422696533745242936564907692e-21), 
      SC_(0.31068275e7), SC_(0.24256317430431744e18), SC_(0.143404235132038593292236328125e-2), SC_(0.96258014296708486555996677315819032294541557348566e-21), SC_(0.1972598733605150297798640841340226756157118686237e-8), 
      SC_(0.32205e7), SC_(0.4915144753769099558912e22), SC_(0.1307531505290171480737626552581787109375e-7), SC_(0.164334032e9), SC_(0.6980534268819858473041043994511617636261409493517e-18), 
      SC_(0.39914275e7), SC_(0.5617260831058956682682037353515625e-4), SC_(0.43573388456807634241895548780677530339229715228289e-25), SC_(0.31924774e8), SC_(0.63133932606104414776194547815667534179536676234649e-9), 
      SC_(0.46787565e7), SC_(0.14932343959808349609375e1), SC_(0.16440348057365199213781820769542107996130653191358e-17), SC_(0.11708039093017578125e3), SC_(0.34226867487194103607643781127607630951888212570643e-4), 
      SC_(0.47933605e7), SC_(0.31721368112700180271268622555462940347189865902822e-26), SC_(0.25930237825377844274044036865234375e-4), SC_(-0.214466495180453821894623232e28), SC_(-0.91733319493295368134727198939095304158871839033766e-29), 
      SC_(0.67505405e7), SC_(0.12444449636352e15), SC_(0.2137999035767279565334320068359375e-4), SC_(-0.4992916231287458655895552e25), SC_(-0.52521328638500292117953896561071999999851161879722e-30), 
      SC_(0.81585985e7), SC_(0.3010926884599030017852783203125e-3), SC_(0.8215554048e10), SC_(0.114206015625e6), SC_(0.50136200110028234464770086816227677834645454947399e-10), 
      SC_(0.11603544e8), SC_(0.313275356292724609375e2), SC_(0.290066314697265625e3), SC_(-0.9375218963623046875e2), SC_(0.28649293639742832027456393766417241439254670094355e-7), 
      SC_(0.14428466e8), SC_(0.70876748614467584e17), SC_(0.18803361506481770337385962666972781228216793358854e-23), SC_(0.10022823697850966935315220275556287300944497201116e-25), SC_(0.71778859953945302976822186314656453326116349206407e1), 
      SC_(0.14455178e8), SC_(0.20228727343912268621384242806016118265688419342041e-13), SC_(0.349125194549560546875e1), SC_(0.1069340869435109198093414306640625e-3), SC_(0.63922052689648282610971529951958584600613959579745e-1), 
      SC_(0.15583587e8), SC_(0.46741176605224609375e2), SC_(0.5554841051654164918449652077470091171562671661377e-13), SC_(0.34054815792480743332272823033907149792298696411308e-19), SC_(0.3700199128491477647155829380685393746316047810923e4), 
      SC_(0.20014814e8), SC_(0.3708101212978363037109375e0), SC_(0.13699657060765273544864379382315910937961689342046e-19), SC_(0.7608494563549061950880059157498180866241455078125e-11), SC_(0.62708615324117416711398888201649265175697097819677e3), 
      SC_(0.21305708e8), SC_(0.16358995318300954765782308898640009098138844295667e-25), SC_(0.98936341703850100293138325469044502824544906616211e-13), SC_(-0.35379081781572062001539613618206203682348132133484e-14), SC_(-0.64169380348550957400835972497068436122147975451984e10), 
      SC_(0.23513628e8), SC_(0.289233994321472004292608e24), SC_(0.630719616e9), SC_(-0.13381082827944242446336e23), SC_(-0.66275653715849795694319915554978158944549924022817e-32), 
      SC_(0.2359947e8), SC_(0.83892250504513065845701871993405683214864787598623e-28), SC_(0.1116302655645995400846004486083984375e-5), SC_(0.939252372042160275456e21), SC_(0.10998068538650239817719760410038058510092001135979e-22), 
      SC_(0.3219581e8), SC_(0.10514049531904e14), SC_(0.1142989134450544952414929866790771484375e-6), SC_(0.3264901123046875e4), SC_(0.44539831126947074252907587959611138961807523305494e-11), 
      SC_(0.38569956e8), SC_(0.153969064060542517248e22), SC_(0.31365259264e11), SC_(0.64615751438068753629184e23), SC_(0.15901406672240710197060481639696712480117521197007e-31), 
      SC_(0.44006012e8), SC_(0.41172763385266176e17), SC_(0.69560673828125e4), SC_(0.6943892002105712890625e1), SC_(0.11055742170934965263077931846674792260115571222994e-12), 
      SC_(0.44515356e8), SC_(0.163460032e9), SC_(0.58954788950949720532109000901066150901463913669431e-21), SC_(-0.84008701238901905931910629732328743557445704936981e-16), SC_(0.1016468164574996101751049497404743419692229697756e-1), 
      SC_(0.60742564e8), SC_(0.10180891649724799208343029022216796875e-5), SC_(0.1729617489790698408202207232e29), SC_(0.13798541646137166738669772732522444264047223327907e-21), SC_(0.55002999650037162886168349807610893852430744597343e-13), 
      SC_(0.110924176e9), SC_(0.72381277181260981972756393027025707393702881272974e-29), SC_(0.9907270967960357666015625e-1), SC_(-0.46992797696e11), SC_(-0.7153769161341146618748649074890545875067308629286e-13), 
      SC_(0.138628768e9), SC_(0.24839921813791433941823936900536334689774519562944e-25), SC_(0.1002530003457735574556863866746425628662109375e-10), SC_(0.146151953125e5), SC_(0.31643515951668430782967469932625098874208800860989e-6), 
      SC_(0.14248488e9), SC_(0.61731988312258099732254031872e29), SC_(0.47155488899394500240213479534565823420775918905622e-28), SC_(-0.25432651776e11), SC_(-0.15560997549573948496013461708493710470300844615272e-23), 
      SC_(0.27280976e9), SC_(0.15585372e8), SC_(0.281720957673314842395484447479248046875e-8), SC_(0.12213673845353715391448545801722502801567316055298e-13), SC_(0.5952817136866798806190819811444904820394334558943e-2), 
      SC_(0.339495296e9), SC_(0.27455182077952e14), SC_(0.3135611338752e15), SC_(0.402709184e9), SC_(0.16499235413105133151072312126744836197182326227857e-17), 
      SC_(0.355727936e9), SC_(0.49794778812580822691949943719295546451682199506905e-24), SC_(0.1241846768099137683456e22), SC_(0.7965702487139983595526434005087182869351289729587e-26), SC_(0.17776375912355973204091948059938294188844121829538e-1), 
      SC_(0.4000056e9), SC_(0.667866475003904e15), SC_(0.1143672109375e6), SC_(0.41925702284651838570496e25), SC_(0.23627988424029165896561703037511481776791931850582e-30), 
      SC_(0.470933376e9), SC_(0.11153424070550668062429267024526780005544424057007e-13), SC_(0.1022445289472e13), SC_(0.3036598381787523315662848e25), SC_(0.51082525159717437740996972959268224682068490870662e-29), 
      SC_(0.480171648e9), SC_(0.81851918776879678213563875328e29), SC_(0.25317517949927424e17), SC_(-0.761762807808e12), SC_(0.14807577909106632829053240787195997254181008262149e-29), 
      SC_(0.53041488e9), SC_(0.46393568e9), SC_(0.579481973517204096424393355846405029296875e-8), SC_(-0.242978e8), SC_(-0.40688072399254155903354266338099994715882814754534e-12), 
      SC_(0.599453888e9), SC_(0.17675467453150265344e21), SC_(0.1340962341126144e16), SC_(0.18613109664666893650064594112336635589599609375e-9), SC_(0.55371046708594014602877624160531183618809435731096e-20), 
      SC_(0.738515392e9), SC_(0.13571258581209030066176e23), SC_(0.2301062643527984619140625e-1), SC_(-0.76610397713172684319715699530206620693206787109375e-12), SC_(0.79685761608775251576239402421443352242583336939208e-13), 
      SC_(0.814350976e9), SC_(0.11488148e8), SC_(0.19480861678725900179769036451744575015598837097741e-22), SC_(0.2380423411208374286693172481332745269194293372822e-27), SC_(0.44619130608245420753145073869509688203154097908354e5), 
      SC_(0.1756078592e10), SC_(0.26120992187958165504e20), SC_(0.26754587434396626122179441154003143310546875e-9), SC_(0.18746973490642741795614695493449097273634996893782e-28), SC_(0.19478325268074938295934076576198224696942609355331e-7), 
      SC_(0.3003238912e10), SC_(0.5025710997504e13), SC_(0.1350108672e10), SC_(0.5902561359107494354248046875e-2), SC_(0.88103370060025420319508578791540142249966037628539e-14), 
      SC_(0.3204498688e10), SC_(0.6025548983379369616386611596681177616119384765625e-12), SC_(0.1022096374072134494781494140625e-2), SC_(-0.17716674949936054272e20), SC_(-0.47182058754855865854157515823805004295335565607572e-22), 
      SC_(0.409506688e10), SC_(0.660258883726783096790313720703125e-4), SC_(0.11791503058925568539244861654413654150630463846028e-17), SC_(-0.10290368356898529759481386580688422327511943876743e-15), SC_(0.60420197885529575064878739038372357567146506347851e5), 
      SC_(0.794944256e10), SC_(0.57736081071197986602783203125e-2), SC_(0.2809777657073205428808056832e28), SC_(0.1966196e7), SC_(0.70403086897656371856817889132578689069531096518923e-21), 
      SC_(0.10259405824e11), SC_(0.35736448257653877024582131372021365223190514370799e-17), SC_(0.1626183676572159287754752e26), SC_(-0.3575664937749412075618238304741680622100830078125e-11), SC_(0.38830584832202869897569424004002309620276039209424e-14), 
      SC_(0.11937830912e11), SC_(0.7411516898803712e16), SC_(0.9116515625e4), SC_(-0.64115528232747007219859456e26), SC_(-0.43778554180175377391336585696830906679687162003759e-32), 
      SC_(0.13030267904e11), SC_(0.121054592e9), SC_(0.45041238147072e14), SC_(-0.5887378692626953125e1), SC_(0.32105605417518275901900628191290524679687102175416e-14), 
      SC_(0.14041162752e11), SC_(0.16802999673239973138530304e26), SC_(0.46871312598868006987253009842930850936681963503361e-17), SC_(-0.15507884900705449904439296e26), SC_(-0.85367992662173210620394366920086679245817675476894e-36), 
      SC_(0.15637035008e11), SC_(0.134159215839460458496e21), SC_(0.52544137753835862096607467464082219521515071392059e-15), SC_(-0.24948805243951710508554242551326751708984375e-8), SC_(0.19030304523928762876188956443874663859228088039831e-13), 
      SC_(0.17571876864e11), SC_(0.78331889736129170520187100955465240744456415725866e-27), SC_(0.29027516841888427734375e1), SC_(0.86297228563125827349722385406494140625e-6), SC_(0.22453186161261513391158868662040316475654593711161e-1), 
      SC_(0.18376677376e11), SC_(0.5392075674848229027702473104000091552734375e-9), SC_(0.69036960018143309015045095329037686884040172076524e-29), SC_(-0.5439871484375e5), SC_(-0.68408988305143483178776308392189960121866243138031e-8), 
      SC_(0.19167623168e11), SC_(0.8768775788564570846326161408e28), SC_(0.622147854301147162914276123046875e-5), SC_(-0.4378748023750764003328e22), SC_(-0.10075098730638899475891515746562096511093203179736e-33), 
      SC_(0.28634155008e11), SC_(0.67717655e7), SC_(0.439299052929024e15), SC_(-0.2764094369161640019069239296e28), SC_(-0.32055233575435343214064577748503293504534051786254e-33), 
      SC_(0.29924868096e11), SC_(0.2513091862201690673828125e0), SC_(0.364701990405672009728e21), SC_(0.1808835506439208984375e1), SC_(0.86504407140564687954319212516129000830686668187889e-15), 
      SC_(0.3143396352e11), SC_(0.13810928266794127506964991575307193802925529863273e-29), SC_(0.2529551275074481964111328125e-3), SC_(0.6610492153669156323303468525409698486328125e-8), SC_(0.20487685573371894368634282236661104960787516256632e2), 
      SC_(0.49448484864e11), SC_(0.37633713292972600066048e23), SC_(0.35798815666608753114714008801007788456267201895617e-28), SC_(0.51093983547468719468029134909980992773625985137187e-19), SC_(0.48326339555697561141802721066317632742526727641684e-6), 
      SC_(0.62930939904e11), SC_(0.177573984375e5), SC_(0.46090615400837396702570999962311759645672282204032e-17), SC_(0.13151506414305676629098713952040449869790306181017e-23), SC_(0.3439413116522142892624105600224528287109958555919e3), 
      SC_(0.67647336448e11), SC_(0.59025825792e11), SC_(0.63456950551354910536750724756131128750454202264858e-27), SC_(0.240986118684672e15), SC_(0.76528228072326729363880402140106115135029881663388e-19), 
      SC_(0.82854125568e11), SC_(0.58830391620982291911135882706044579926359106014644e-24), SC_(0.63024210653626119155168439078806841280311346054077e-14), SC_(-0.54368220029374445673164828463086450938135385513306e-14), SC_(-0.10829361597055536224749850825972154484392198615189e10), 
      SC_(0.120054595584e12), SC_(0.82902877667147644928e20), SC_(0.1294386796875e6), SC_(0.124762982982533251072e21), SC_(0.28237302458133933514902456909194247729198978347614e-28), 
      SC_(0.140797837312e12), SC_(0.14323210329885870979668017974210037525351329329437e-26), SC_(0.49604859973225045211182859805632006100495345890522e-16), SC_(0.4708577083789577955030836164951324462890625e-8), SC_(0.16771706036912324754305210348028914314093661469228e5), 
      SC_(0.187841462272e12), SC_(0.2085087317027500830590724945068359375e-5), SC_(0.23632697338789035110002273443186027179763186722994e-16), SC_(0.225691846571862697601318359375e-2), SC_(0.12845456754243698010038246582418683448773573315963e-1), 
      SC_(0.193607401472e12), SC_(0.1391435716868727467954158782958984375e-5), SC_(0.17110982071244507096707820892333984375e-5), SC_(-0.19561825628872353505405663801313808497495116967002e-21), SC_(0.80864759729644611943700382157345057894976359904086e2), 
      SC_(0.22130761728e12), SC_(0.27802641477000539246127245560908891101555874547646e-25), SC_(0.118848793208599090576171875e0), SC_(-0.12405722141265869140625e1), SC_(-0.9276223639209647401714189337787584324485796249616e-5), 
      SC_(0.22663667712e12), SC_(0.17455190938486797591622234904207289218902587890625e-11), SC_(0.85543193037952672645625784483272222025185271832015e-23), SC_(-0.1899995365173348970453916098985154078822091775636e-30), SC_(0.15499929512914335968618015050069017861297159802942e14), 
      SC_(0.2321313792e12), SC_(0.226527254199027083814144134521484375e-5), SC_(0.37947044e8), SC_(-0.1516351389696e13), SC_(-0.23023007721783712880856647301078004224131288409007e-16), 
      SC_(0.345189679104e12), SC_(0.79820903020739723608895214436397557193018231780357e-25), SC_(0.64729720161775472443612539086288393264112528413534e-17), SC_(0.66532361109504e14), SC_(0.26363301676819092424392344158949682932356960745854e-17), 
      SC_(0.394305110016e12), SC_(0.15888269576316649472e20), SC_(0.83157216696884789248e20), SC_(0.28352812140199936e17), SC_(0.74462783081321149104186552543671046301745851204849e-27), 
      SC_(0.496015867904e12), SC_(0.3791820544e10), SC_(0.776127685546875e4), SC_(0.215147537119264598004519939422607421875e-6), SC_(0.10086837230189300603966221534673195400104347338484e-10), 
      SC_(0.503288594432e12), SC_(0.586938125e5), SC_(0.12771843437840908067390157228141150513173185387927e-22), SC_(-0.349487481798860244452953338623046875e-5), SC_(-0.72029932947474925429881196156855684741460064981511e-10), 
      SC_(0.572994879488e12), SC_(0.4479686882443445386870784e25), SC_(0.3949284499458758322165682321378970124179942071882e-27), SC_(0.266417008e9), SC_(0.17777000343056153959167725670822180789645379680768e-21), 
      SC_(0.871788642304e12), SC_(0.20654001974429033907974591176490695466905211929998e-22), SC_(0.25783102660851220989209976272113706693474803698419e-30), SC_(0.64431740406461198732239319017208248330241815438058e-21), SC_(0.12190391991221392971014057913471308591001568711459e17), 
      SC_(0.875494899712e12), SC_(0.226093597412109375e3), SC_(0.18276990966796875e4), SC_(-0.40538668260659298304e20), SC_(-0.87620862396447187589874183773402645045819979837542e-24), 
      SC_(0.92167176192e12), SC_(0.14617966115474700927734375e0), SC_(0.2962839789688587188720703125e-1), SC_(-0.323903481159090176e20), SC_(-0.15195656115724489327613368628209569908647297359072e-23), 
      SC_(0.92746285056e12), SC_(0.7325884342193603515625e1), SC_(0.41534478125e6), SC_(0.183796966075897216796875e1), SC_(0.27055962004569991229008545959063589325367143232165e-8), 
      SC_(0.1323015995392e13), SC_(0.83436345194574414174670806687572621740400791168213e-15), SC_(0.26587446043832553782635536032685763530025724321604e-19), SC_(-0.90369778533118636580140234418583988079687330241541e-22), SC_(0.1951740446546404665680568108327258162423989400208e13), 
      SC_(0.163744841728e13), SC_(0.69148334649344262144e20), SC_(0.250710905670486651305984e24), SC_(0.183021328125e6), SC_(0.48966517083340871380066403254311456796061982956658e-26), 
      SC_(0.2146243837952e13), SC_(0.45278131287698752949211211671354249119758605957031e-12), SC_(0.8430518290874368e16), SC_(-0.885746479034423828125e0), SC_(0.17097085336400584019692272359292345057350265227936e-20), 
      SC_(0.2737008279552e13), SC_(0.88910703354695418642432e23), SC_(0.147013624882674776017665863037109375e-4), SC_(-0.138948e8), SC_(-0.36742469187297405316759652722949922342798960833565e-23), 
      SC_(0.2881296007168e13), SC_(0.1000261828920656625996343791484832763671875e-7), SC_(0.56146556854248046875e2), SC_(0.8827687217586030590550931806697492528618331775192e-23), SC_(0.42509319401345334213228978799787099767368705469532e-1), 
      SC_(0.3195750580224e13), SC_(0.1209453678131103515625e2), SC_(0.31177688248907589260716655132910091197118163108826e-14), SC_(-0.4171597312e10), SC_(-0.42339731362918471841305207444900093823614717619802e-14), 
      SC_(0.7204262903808e13), SC_(0.3381689405394563993960448e25), SC_(0.638556383965607886848e21), SC_(-0.42120456509063168e17), SC_(0.15575317217390122072535796938363987704778724700227e-32), 
      SC_(0.753277075456e13), SC_(0.57189246319545947866425095185149984899908304214478e-14), SC_(0.50392141342744323462734544896e29), SC_(0.89861124028964329323118259971904802659416547361282e-25), SC_(0.84550625913050425059505347644181958622837497454849e-12), 
      SC_(0.1591604150272e14), SC_(0.351564170056957952e18), SC_(0.39915753210320770987303899714279126384431587576396e-26), SC_(0.18147198280875792132716788562593424505831606627446e-28), SC_(0.6817961989239844144699667620358050442805270214532e-1), 
      SC_(0.17455096266752e14), SC_(0.71139728908672437321728e23), SC_(0.6174588866134016e17), SC_(-0.7305752277374267578125e1), SC_(0.16172835812094374773587673038596961971155471054338e-24), 
      SC_(0.20741449842688e14), SC_(0.4743499375e6), SC_(0.60682196926171104626767727515008970841312337712241e-30), SC_(0.5702780928e10), SC_(0.62259465015751190680345333485921749493056982782287e-15), 
      SC_(0.21823460737024e14), SC_(0.894460328026980278082191944122314453125e-8), SC_(0.30660718630209872134773085861070285318419337272644e-15), SC_(-0.56302317568e11), SC_(-0.25481170543505063442394384037544272844775408193195e-15), 
      SC_(0.2193780375552e14), SC_(0.1688042402747669257223606109619140625e-5), SC_(0.59463684184086124685157367095470539860668220270753e-30), SC_(-0.222474092611611039629312e24), SC_(-0.67345779651737834090180971110607868330593254403912e-28), 
      SC_(0.29861301190656e14), SC_(0.716266594827175140380859375e-2), SC_(0.13375914401765930660715049355796724128708774514962e-19), SC_(0.5779358744576e13), SC_(0.1685308032674899584230388525959903398092800817358e-17), 
      SC_(0.31117235191808e14), SC_(0.3356745714722109141803230158984661102294921875e-9), SC_(0.37225551903247833251953125e-1), SC_(0.31484928851968e16), SC_(0.31461807745559740553343508795707704290534229744319e-20), 
      SC_(0.31191365320704e14), SC_(0.2293932139873504638671875e0), SC_(0.61834249098451553748337548320711315606925672313013e-29), SC_(-0.5982092726894592e16), SC_(-0.15851321158930386974141141277129380455515234242728e-20), 
      SC_(0.334870085632e14), SC_(0.17562439325047307647764682769775390625e-6), SC_(0.17353881263527453121215165896486687553690320129363e-22), SC_(0.10955010354518890380859375e0), SC_(0.34852876235448366352201127880568420062336702413456e-4), 
      SC_(0.49020114305024e14), SC_(0.42052690625e6), SC_(0.4350305370112e13), SC_(-0.34981801878572553268209030398156159993725477716509e-27), SC_(0.12284492784759096402363590266094328751671947697601e-13), 
      SC_(0.56026120323072e14), SC_(0.2968644096e10), SC_(0.1669806335196404329218048e25), SC_(0.982560210944e12), SC_(0.43746483211725186557066605349769416924313629385926e-24), 
      SC_(0.59092118798336e14), SC_(0.25544630272e11), SC_(0.2050561617030631850390847488e28), SC_(-0.93237160106262528e17), SC_(-0.30932050569017569606289330408961535535923960046675e-29), 
      SC_(0.84026647904256e14), SC_(0.9030235625e6), SC_(0.19341944851038290442859641874855406926125844790931e-22), SC_(-0.16183332281234661790268972050670093221214074219461e-20), SC_(0.92854739256706577680259328294562476549023411198166e0), 
      SC_(0.8952989351936e14), SC_(0.5821022205054759979248046875e-4), SC_(0.16930462580604928e17), SC_(0.1441475953158445649402789888e28), SC_(0.64162028557540900736318509011534441036686622697431e-34), 
      SC_(0.91714010218496e14), SC_(0.15903771355407769760859082452952861785888671875e-10), SC_(0.20621651441981357349985057544616166528433660182218e-25), SC_(-0.15444423355232689276661517396860290318727493286133e-12), SC_(-0.19570533284217657144679813507410046091944093838418e5), 
      SC_(0.10547181387776e15), SC_(0.89483831787109375e3), SC_(0.2971664653159677982330322265625e-3), SC_(-0.29433792561152e14), SC_(-0.12801467922824471201024289479258151431375228395145e-18), 
      SC_(0.169495918280704e15), SC_(0.106314858496e12), SC_(0.30307608021550191165014175615417981032514993522398e-23), SC_(-0.9743143455125391483306884765625e-3), SC_(-0.21692895673463102774513663302873888611459425087084e-17), 
      SC_(0.184614706479104e15), SC_(0.1988045896512735359317049344e28), SC_(0.9218556175925116928e19), SC_(0.16526283776e11), SC_(0.87247196888777165991030567036355416711562753499749e-29), 
      SC_(0.22044892725248e15), SC_(0.68194390016e11), SC_(0.82951904279513563542883824670263768282126026765155e-25), SC_(-0.1445260835453154868446290493011474609375e-6), SC_(-0.14232560771964035551334897919749042153183656620622e-17), 
      SC_(0.323813657018368e15), SC_(0.156708486328125e5), SC_(0.16682115902222024485246354430501014576293528079987e-14), SC_(-0.3338787376455133737440661434447974897921085357666e-13), SC_(0.15769750471812656413875791763045334315928746617897e-2), 
      SC_(0.32790162702336e15), SC_(0.17749171611502504859023857341939015403147871657863e-25), SC_(0.113998673030377528862565203968e30), SC_(0.1091690106369558321830481872893869876861572265625e-11), SC_(0.7376829154455144537334355851632262650708094447784e-15), 
      SC_(0.40286692573184e15), SC_(0.52038092193792e16), SC_(0.30787743926144863285121466844884707825258374214172e-14), SC_(0.9836614990234375e2), SC_(0.32815320852077160002078659428612679661864800516549e-15), 
      SC_(0.47637881421824e15), SC_(0.256083277054131031036376953125e-2), SC_(0.894934712937934631550844928e27), SC_(0.63026674329507604827741060164026480733691095673533e-29), SC_(0.28443800019599121882423433218568170528455090132486e-17), 
      SC_(0.798277117149184e15), SC_(0.64990261775881629335552e23), SC_(0.629183676416e12), SC_(0.27870030942626650843907398780174844432622194290161e-17), SC_(0.18094555178717438538171833996718524897966754339758e-22), 
      SC_(0.95759886188544e15), SC_(0.4659874708323741288040764629840850830078125e-8), SC_(0.727262651482112e15), SC_(-0.5518754816e10), SC_(-0.19616453227008195539690596715591394184621211909383e-21), 
      SC_(0.1551973144854528e16), SC_(0.10139344880747031860591903938868807433237861914677e-19), SC_(0.7740245504e10), SC_(-0.58571932827648e14), SC_(-0.67506981129091845750446190909330129850985465284433e-20), 
      SC_(0.1559443435159552e16), SC_(0.1296097951186681029867031611502170562744140625e-9), SC_(0.21495435284055487900379567949710191143708470917773e-19), SC_(-0.12168303266687867641299147791755785874556750059128e-16), SC_(0.79720158864628729749958531950878190394078531069807e5), 
      SC_(0.159586086551552e16), SC_(0.94693035634918487630784511566162109375e-6), SC_(0.3069093933762029289472e22), SC_(-0.489862862294809540651139465216e30), SC_(-0.95301791507625821088034070804748092896597785006237e-39), 
      SC_(0.1755992815566848e16), SC_(0.311160515592192e15), SC_(0.879396533966064453125e1), SC_(-0.42764948393697586245822784899152190331642064968776e-24), SC_(0.40833330349573571058183037703406707577578239212629e-13), 
      SC_(0.183459460939776e16), SC_(0.58535432060362684618705258305616519358052915120161e-26), SC_(0.151380081803154098452068865299224853515625e-7), SC_(0.85484123133369723281636554248303846992307342134154e-25), SC_(0.26347058287077926347365609944873061617273956547542e10), 
      SC_(0.2038235383463936e16), SC_(0.197336701599744e16), SC_(0.78108794987201690673828125e-2), SC_(0.19746285946216817928151632558983474829972237785114e-19), SC_(0.35463365959776981995585843867682572518957434928647e-12), 
      SC_(0.2082685879058432e16), SC_(0.911282624e9), SC_(0.1114427401123063379525632e25), SC_(0.37492192874537494211295562962504845927469432353973e-17), SC_(0.64091497549275033408033422864822796853191222161235e-22), 
      SC_(0.2460775474003968e16), SC_(0.11911894016e11), SC_(0.11488683748933763072e20), SC_(0.2671757689356288e16), SC_(0.33954867185231449127923450476505270618078000384498e-24), 
      SC_(0.2660433739644928e16), SC_(0.2021791625e7), SC_(0.39646356055629828823414282575648289336041796455945e-27), SC_(-0.90965958552407811523940472930860323685919865965843e-16), SC_(0.89536100819620633898256567017554320012190758544577e-8), 
      SC_(0.3490414963195904e16), SC_(0.15486944554331788202011050222970875434036486240075e-20), SC_(0.65645105e7), SC_(-0.3862249885736011563008e22), SC_(-0.15030321942773773313070642569575229578631232758305e-27), 
      SC_(0.3732843586912256e16), SC_(0.91425932943820953369140625e-1), SC_(0.27109355651322886594095651346947306592483073472977e-17), SC_(-0.2280010496e10), SC_(-0.27270972086797623874696761025941465895226780556069e-15), 
      SC_(0.3762704347037696e16), SC_(0.10164524532769642241629852708355797252185587220552e-24), SC_(0.27152649027584e16), SC_(0.383565435413402155973017215728759765625e-6), SC_(0.23804839018775718073693636074253046814229093331093e-11), 
      SC_(0.6551729407524864e16), SC_(0.25762003497220575809478759765625e-3), SC_(0.156271296e9), SC_(-0.7108036079443991184234619140625e-3), SC_(0.54358974535033512119646257223362074375935527544017e-10), 
      SC_(0.7552590468349952e16), SC_(0.575958067183616e15), SC_(0.23832502919148795513995921571681613215787365334108e-18), SC_(-0.16014309555286814611860677563630328545940528783831e-20), SC_(0.93858067563758918073486329121399146014156473797673e-5), 
      SC_(0.7617166912258048e16), SC_(0.78087929856e11), SC_(0.23989477554782208e17), SC_(0.83931917784951364861476853784783003220582031644881e-18), SC_(0.27034519724555596789443192463038139534250181357333e-19), 
      SC_(0.8222450747703296e16), SC_(0.8274803712e10), SC_(0.527242330357572379789492224e27), SC_(0.48895778381210611976766991253265851212856409555572e-30), SC_(0.74455751091076848286943297672181953481088219377495e-24), 
      SC_(0.8870075981365248e16), SC_(0.9699246828571174660704143659015197265205188159598e-20), SC_(0.86747422243322953296456139754310066421454789020729e-25), SC_(-0.30056768339968e15), SC_(-0.42847731490613056519922750895506180779273890356379e-20), 
      SC_(0.8947236142579712e16), SC_(0.64884398852035896076984045066637918353080749511719e-12), SC_(0.3640597240689233647108096e25), SC_(-0.20160019901007336504105681634819746061656770691473e-25), SC_(0.33521550963867647751710831933851768581523193451564e-12), 
      SC_(0.9247942909100032e16), SC_(0.66864512022555389032059044995826013746409444138408e-17), SC_(0.34406117105255590527265189612451978026091969908862e-23), SC_(0.16972130859375e5), SC_(0.46568116999240819390977312271152595288904115985538e-10), 
      SC_(0.15615699003113472e17), SC_(0.2157478536102264143892170977778732776641845703125e-10), SC_(0.92339736328125e4), SC_(0.2467952464569808657124383444170234724879264831543e-14), SC_(0.28137654352976876055827088720392588615737493813187e-3), 
      SC_(0.18757896003125248e17), SC_(0.27796297217719256877899169921875e-3), SC_(0.3795939164774608798325061798095703125e-5), SC_(-0.4411582267493940889835357666015625e-4), SC_(-0.16561241734027399380354476330796336941583283787624e-4), 
      SC_(0.19790925832126464e17), SC_(0.14673756579750143547516416653309079265454784035683e-15), SC_(0.3067474539712255353944014848e28), SC_(-0.46111488638490765946006906581919557197059289510577e-24), SC_(0.33318296543710703146930010704335335102607434599885e-12), 
      SC_(0.31614863423832064e17), SC_(0.64014885e7), SC_(0.82997499668329372719087076888666576479636205476709e-19), SC_(0.97673453929425068759145069339947469290799664243252e-24), SC_(0.1474082113274986927473821089453469821830117865384e0), 
      SC_(0.35496891089158144e17), SC_(0.1432262115478515625e3), SC_(0.24132785049458572347706444480878020231965231517934e-25), SC_(0.537947271368466317653656005859375e-4), SC_(0.28483638915557694690075255204358779291820018303066e-6), 
      SC_(0.37258725328683008e17), SC_(0.27527139900776398375687894235391167938115142930643e-29), SC_(0.34671355e7), SC_(-0.329579110257327556610107421875e-2), SC_(-0.44826666388956802711142928493336346675505691157686e-14), 
      SC_(0.45080659638616064e17), SC_(0.66192871423119660955992064e26), SC_(0.65104581211365760324995297566040105840304400052279e-28), SC_(-0.4609219395046437739438260905444622039794921875e-9), SC_(0.30393593195986173088236185388151378128529468124634e-25), 
      SC_(0.55441482261200896e17), SC_(0.84905730317661677425908674864238508128710947175932e-22), SC_(0.68363272192e11), SC_(0.4260724998144e14), SC_(0.11697925063926465337112606670912855638056790467033e-20), 
      SC_(0.62729268668399616e17), SC_(0.10206736333437342809907509471629755506880924287999e-26), SC_(0.81748619457743373061928487104122026290137009371661e-27), SC_(-0.59081488088599881019268440147710709923287045273327e-27), SC_(0.17296073749639974583005326897055234716422193206457e19), 
      SC_(0.67960092158328832e17), SC_(0.18397274324487521318375543111309916577411627258698e-20), SC_(0.17372376323945837306439443636918440461158752441406e-11), SC_(0.22240787693568e14), SC_(0.15314765068954850046837516568238243973823802962003e-19), 
      SC_(0.98211402249928704e17), SC_(0.91343463282100856304168701171875e-5), SC_(0.61815804943327298417046040349825952731066536216531e-20), SC_(0.15683097532096506747707287147074704802829359095995e-22), SC_(0.14847580243473942674356093212105732071171909400697e6), 
      SC_(0.10021945407963136e18), SC_(0.28705071104e11), SC_(0.1324882283108628599609807308112863211135845631361e-16), SC_(-0.21994842184582347981213138944e29), SC_(-0.38428198134253200965721479225788208168133625801132e-35), 
      SC_(0.105732534230319104e18), SC_(0.3443469676067678619801881723105907440185546875e-9), SC_(0.13889756370430423980110642247760388383326368710868e-22), SC_(0.26158144e10), SC_(0.79112331506380595128354554585081093242068772744655e-16), 
      SC_(0.11384566732292096e18), SC_(0.58757351632535552e19), SC_(0.273440826416015625e3), SC_(-0.63452058800333914204274688e26), SC_(-0.65725875175758627471160771763067147666834253039354e-34), 
      SC_(0.117433949289971712e18), SC_(0.162249111923529198975302278995513916015625e-7), SC_(0.109367839992046356201171875e0), SC_(-0.25682033451598259706675813002826197495309656915197e-20), SC_(0.32066589256601074054642730535177997208081794531389e-2), 
      SC_(0.124700664587616256e18), SC_(0.3095501916077023035392e22), SC_(0.4245943000138700927533056e25), SC_(0.53696867131834092023185408e27), SC_(0.13177984836158444046950861908532532345926893822506e-37), 
      SC_(0.128395461743607808e18), SC_(0.206836903384823477636694016e27), SC_(0.53310077419155277311801910400390625e-5), SC_(-0.66452324352e12), SC_(-0.16246339708306689726375619149754640087627232329011e-29), 
      SC_(0.140845240494850048e18), SC_(0.15238641357421875e4), SC_(0.9007602981666816e16), SC_(-0.21558438e8), SC_(0.15155109340272247166088816142038442919912329856745e-21), 
      SC_(0.15402689026326528e18), SC_(0.6474543616e10), SC_(0.3346712684759722833405248820781707763671875e-8), SC_(0.28833691527365083704665074771632166453248624892738e-29), SC_(0.4096276045356790148209349023868569849111705574315e-7), 
      SC_(0.245924553149120512e18), SC_(0.12432241406593107741605394588021265875441186132822e-25), SC_(0.11698430441812742785454260394458960094979845402414e-30), SC_(0.10142405428001112064e20), SC_(0.30423445192187443924267108883316508334540324904605e-25), 
      SC_(0.30980423739768832e18), SC_(0.76340669757426261951512576e26), SC_(0.632591748046875e4), SC_(-0.1336046131083024763393742235552397179532135851332e-20), SC_(0.22571232473347972583727080449588071170762441941591e-21), 
      SC_(0.357437417575153664e18), SC_(0.2173093520104885101318359375e-1), SC_(0.12372333568e11), SC_(-0.12248384952545166015625e1), SC_(0.53657229424973014573915434188099752907498200207294e-14), 
      SC_(0.36385554182438912e18), SC_(0.4880095232e11), SC_(0.22669229503540638814840235681913327425718307495117e-12), SC_(-0.93454334481970799504143406421455969601552737913153e-21), SC_(0.48923745747855953399656188111764955982957757716394e-6), 
      SC_(0.415087526638780416e18), SC_(0.140571919027433667616047104e27), SC_(0.11791684300987981259822845458984375e-4), SC_(0.17635498046875e2), SC_(0.14682572203222134214343874166237989457260012270301e-21), 
      SC_(0.441417256711225344e18), SC_(0.3197955992849934712832e22), SC_(0.1093556445397325660451315343379974365234375e-7), SC_(-0.9779507932627939936764960293658077716827392578125e-11), SC_(0.32078703557500394804653928990709084664190346053448e-14), 
      SC_(0.45362430968070144e18), SC_(0.317074383652647862272e22), SC_(0.89612589356621110444032e24), SC_(0.180616595243008e15), SC_(0.38407704573117072373094012615593598112899782284232e-30), 
      SC_(0.466885347624615936e18), SC_(0.1095394379005843587298734717096385279518671401362e-29), SC_(0.8691929266426547798016e23), SC_(0.58962798910790525160497549395088867640879470854998e-17), SC_(0.96336031777320908719244768706875836157689599501609e-11), 
      SC_(0.53813397598240768e18), SC_(0.9151597128974336e16), SC_(0.24511930706754350706155776151717873290181159973145e-13), SC_(0.33505779800327468727968837771957314765596674943637e-24), SC_(0.36045288702975935176739474723909622333219641680094e-8), 
      SC_(0.812948248690950144e18), SC_(0.573921154459150755823616e25), SC_(0.44215075630028238618624e23), SC_(0.8585306549072265625e2), SC_(0.12603969062001301466969564143853380112338605539371e-30), 
      SC_(0.915670672271736832e18), SC_(0.39675285911547656146099641153758563749676113729947e-22), SC_(0.14906016349079502514296535764515283517539501190186e-13), SC_(-0.3871874820760012880782596766948699951171875e-8), SC_(-0.56087300675732405982389260047019515740430536251903e1), 
      SC_(0.921704585926541312e18), SC_(0.106680765625e6), SC_(0.56570606632127019614208e23), SC_(0.2693166200043876672351857498571899170690391311922e-24), SC_(0.13985495225057612995722164718279974711007682172634e-20), 
      SC_(0.1993097509492228096e19), SC_(0.31910282975259219863080686896417148545879172161222e-17), SC_(0.6051646e8), SC_(0.7197362225152e13), SC_(0.19298193055539541472180089436877636761796212157916e-20), 
      SC_(0.2513717777072652288e19), SC_(0.871877928148023784160614013671875e-4), SC_(0.10190402621727351770774006081609545752708623211902e-23), SC_(0.498152734340617797670347499661147594451904296875e-11), SC_(0.14259607366931342684347648514473148016605549985246e0), 
      SC_(0.4173026783555223552e19), SC_(0.25325901731494375978251987705874090841683295149966e-25), SC_(0.2247014312744140625e3), SC_(-0.1925644398234143277786857472e28), SC_(-0.15341643472452791881468857304558692672132616776398e-34), 
      SC_(0.459235907791224832e19), SC_(0.87862375252982516382616040573338977992534637451172e-13), SC_(0.401803645910803197693894617259502410888671875e-9), SC_(0.3200137703142619193802752e25), SC_(0.14730346091716177809600030451184040334577470221661e-31), 
      SC_(0.5077423201034698752e19), SC_(0.93737803399562835693359375e-3), SC_(0.17346513114802064592367969453334808349609375e-10), SC_(0.114951548280117776812403462827205657958984375e-8), SC_(0.18694696679082786599750684587309554591836894744968e-2), 
      SC_(0.7115694558070964224e19), SC_(0.911697810579426004551351070404052734375e-7), SC_(0.353218575e7), SC_(-0.69922551130979362004308562936482492999405571568888e-30), SC_(0.54114818216034650154393366386810274769974582629441e-7), 
      SC_(0.868149367402397696e19), SC_(0.18117627432139048989226726261264354120224815206108e-26), SC_(0.55646827574017444434287932233212870187285398193566e-25), SC_(0.2699863558762810316865550031364962002555785147706e-19), SC_(0.26675383124052748044060181233075977741996031511065e12), 
      SC_(0.871409419378753536e19), SC_(0.10055294386176e15), SC_(0.19118333886464e15), SC_(0.19455523781994563368983933894919118035016225576328e-21), SC_(0.30245570478436121805641627713230961372684706522729e-21), 
      SC_(0.9400097640298840064e19), SC_(0.8751563727855682373046875e-3), SC_(0.423289281913088785772479250432e30), SC_(0.794114232982437888e18), SC_(0.22504688367446473660334442312164588173070712711901e-32), 
      SC_(0.10280280887589339136e20), SC_(0.49921325198101894818741785761816914940427547878188e-26), SC_(0.5754278161047093248e19), SC_(-0.13595621377765355429940102970217622596615925090191e-21), SC_(0.20270137682870188516129112599835658832987453293531e-9), 
      SC_(0.11316614577233330176e20), SC_(0.900104978432e12), SC_(0.12594157657128558086556679995737795252352952957153e-13), SC_(0.401503996716456867943634279072284698486328125e-9), SC_(0.73425500027611546587881384574097676840747502710601e-10), 
      SC_(0.16893768561871290368e20), SC_(0.38262641055553103797137737274169921875e-7), SC_(0.56400939474343658730504103004932403564453125e-10), SC_(-0.348154485225677490234375e0), SC_(-0.18170651414739782456395795561758287675420244467194e-7), 
      SC_(0.1748333989082431488e20), SC_(0.248268663883209228515625e0), SC_(0.339717292032e12), SC_(0.23636871875e6), SC_(0.39724752710467164452324293888383999524241837515003e-17), 
      SC_(0.1917414138422755328e20), SC_(0.40000660111603838852169207047177953984196108194737e-21), SC_(0.19299584181631174594238409616964169401853723684326e-18), SC_(-0.2447043658252288e17), SC_(-0.11497180098873460666081866507470383163261042553405e-23), 
      SC_(0.30205231483425128448e20), SC_(0.20213326246758156110559789819802745114429853856564e-16), SC_(0.11798525e8), SC_(-0.72186512098956854158015270537643843098507632355387e-26), SC_(0.40894641444986862014203206172561233922281613197619e-3), 
      SC_(0.3083335169004797952e20), SC_(0.25554565784928256e17), SC_(0.55001718457514670035379822365939617156982421875e-10), SC_(-0.475754700601100921630859375e-1), SC_(0.52682237786148250108822272500251195557773448891767e-21), 
      SC_(0.32557997250865790976e20), SC_(0.152981488e9), SC_(0.13022084679680682421649408e26), SC_(0.328559815883636474609375e0), SC_(0.12571931624708992335316981931132371770582533530642e-24), 
      SC_(0.38083625921602912256e20), SC_(0.14043506688e11), SC_(0.13209346463532805303342509972708285204134881496429e-15), SC_(-0.56693135519481074879877269268035888671875e-7), SC_(0.83158459743638934087112797685339082141513696858831e-15), 
      SC_(0.50355072889071337472e20), SC_(0.9924967773258686065673828125e-2), SC_(0.3607895660400390625e2), SC_(0.7361732201616177917458117008209228515625e-7), SC_(0.4650536471107286486001524802196860743225649883219e-8), 
      SC_(0.7018217904466296832e20), SC_(0.4750826171875e5), SC_(0.28394778265649152e17), SC_(0.326307279807647176994578330777585506439208984375e-10), SC_(0.17696575430922792155808924716276887632062631112292e-18), 
      SC_(0.113674073964877447168e21), SC_(0.183615109375e6), SC_(0.404058591811917722225189208984375e-4), SC_(-0.55481593261847917064658769950259091085359441919422e-24), SC_(0.24338715310708295782533356891202968386388823460614e-8), 
      SC_(0.12116116760789254144e21), SC_(0.2893880591727793216705322265625e-3), SC_(0.130319118499755859375e1), SC_(0.381011011567616e15), SC_(0.12398589388448327034537697871075774660376423130072e-22), 
      SC_(0.140771054246300745728e21), SC_(0.4364620208740234375e2), SC_(0.10711124272997777587041261201942927950011067906889e-29), SC_(-0.57519616e8), SC_(-0.34019512662514247429907106459469873769817730537827e-16), 
      SC_(0.15262866262926032896e21), SC_(0.78398e6), SC_(0.3786630536101888e16), SC_(0.62870051086045850977047303157811296808459919772775e-28), SC_(0.17803821835344232596567077346772829000234069893566e-18), 
      SC_(0.2306652249771737088e21), SC_(0.72487803782646221227581317947397110401652753353119e-15), SC_(0.2927755373186121728e19), SC_(0.85256172876455101027449670235067169521414598420961e-20), SC_(0.27306690726663827206563405623101192238717602008124e-10), 
      SC_(0.263866535486334959616e21), SC_(0.150418243408203125e3), SC_(0.70894723477708281518115769172324141873507978746372e-27), SC_(-0.3900062680322030756578725083109804932239106623718e-30), SC_(0.25137329125431234354297233526449824654887426191218e4), 
      SC_(0.398680594063019737088e21), SC_(0.10907375003199604179826565086841583251953125e-9), SC_(0.41478983876103159289527866349089890718460083007813e-12), SC_(-0.6966302212096e13), SC_(-0.57993424418345427711698913329809965986376276110811e-21), 
      SC_(0.486625867239520206848e21), SC_(0.2663514463837359985504355062296832912238642165903e-19), SC_(0.4719122320543576863524228422930565122003386188676e-26), SC_(-0.12369338210470428252452159488e29), SC_(-0.52486756707121894054043599617133836143966167046517e-36), 
      SC_(0.532848913858758180864e21), SC_(0.2804503330955387951917145983316004276275634765625e-10), SC_(0.172887280972042231349248e25), SC_(0.182365325927734375e3), SC_(0.11497047485079965458009798428538418185914230259387e-22), 
      SC_(0.834580765033977872384e21), SC_(0.15617056749761104583740234375e-1), SC_(0.71962334215641021728515625e-1), SC_(-0.521713036505389027297496795654296875e-5), SC_(0.1335697144755327396002625953088980177925473155612e-7), 
      SC_(0.897051039890164154368e21), SC_(0.9091429412364959716796875e-2), SC_(0.103353980929199451566091738641262054443359375e-8), SC_(-0.39896293614162682356244622113147248278805078597342e-27), SC_(0.71535020612477739974214063462457085760294155498574e-3), 
      SC_(0.91184909420951764992e21), SC_(0.65724690529779712e17), SC_(0.22635786081082187592983245849609375e-4), SC_(0.28443816312700986870254382665734738111495971679688e-11), SC_(0.70357550553979701321067050402995067028922500261273e-15), 
      SC_(0.949726407769284673536e21), SC_(0.3587426362916534827718351152725517749786376953125e-11), SC_(0.15142064652433650485798833454982273253063182524288e-29), SC_(0.5263105426198626304e19), SC_(0.65505386294903740961944955600649868934680759606662e-27), 
      SC_(0.1099886552444978593792e22), SC_(0.11876603850689937599006851654101415277642317391837e-21), SC_(0.13402266243506853384161978158875538902350399439456e-19), SC_(-0.58575987284375708479930064918883569902163799270056e-20), SC_(-0.38608701661390120303681923440636689787864952197327e10), 
      SC_(0.1146824826980038344704e22), SC_(0.123134608e9), SC_(0.36464645756234167146109012677852867501115952109103e-20), SC_(0.145960173568e12), SC_(0.25695141822340345338516566415967223808824193353226e-20), 
      SC_(0.1672886569909744566272e22), SC_(0.22487528568887739897399753816881196044619173335377e-19), SC_(0.185430274308630309240832e25), SC_(0.29157344e8), SC_(0.15669081776377370465324112158766399865034932740325e-25), 
      SC_(0.1711439775257338052608e22), SC_(0.30659185015094057321365504e26), SC_(0.7833119869232177734375e1), SC_(-0.5409414316032e13), SC_(-0.30985201642688029716457103329179602366602811022103e-33), 
      SC_(0.2926998047169095663616e22), SC_(0.3667952402432e14), SC_(0.28799857572511128652513152655127873625243270679086e-26), SC_(0.88063873291015625e2), SC_(0.15325644590239837768811954228179177539171136144697e-17), 
      SC_(0.427296043882866802688e22), SC_(0.14208654969087828444471944343733085282244221758674e-22), SC_(0.1716118473408512e16), SC_(-0.17996093839902769152e21), SC_(-0.16601104234961252621793669598304861576818344610456e-29), 
      SC_(0.439028906074585432064e22), SC_(0.320426825e7), SC_(0.32412401535258716801207369728e29), SC_(-0.30931359806372614114377728e26), SC_(-0.27607657181716051791812572528647867932005126507654e-38), 
      SC_(0.5882928907194279657472e22), SC_(0.19802219475157014020096e25), SC_(0.49511542775217689241155796992e29), SC_(0.372750661335885524749755859375e-2), SC_(0.3559981037118474445665924937030462589994417113189e-35), 
      SC_(0.6443661400749065109504e22), SC_(0.240611655851932728105631744e29), SC_(0.15126033260477136128765155826087636266509091563425e-30), SC_(0.95370733737945556640625e0), SC_(0.38753317214698960194399613216931555454276746759297e-24), 
      SC_(0.6865513577844859469824e22), SC_(0.401415872e9), SC_(0.2812358319675629247660032e25), SC_(-0.2376111269076472061493248e27), SC_(-0.33007281458590603457624836915435654293066634477422e-37), 
      SC_(0.8553573619324145369088e22), SC_(0.17097021875e6), SC_(0.799823729380687897165824e25), SC_(-0.11171394538600498691494067315943539142608642578125e-10), SC_(0.53609971873333187098178460340334684598225230879559e-24), 
      SC_(0.12478698822407829848064e23), SC_(0.1965407257080078125e3), SC_(0.344887394304e12), SC_(-0.18247611706101452000439167022705078125e-5), SC_(0.32425282996209840045906418036654137989438047272958e-16), 
      SC_(0.12842575035600576970752e23), SC_(0.9170528e7), SC_(0.19517806153831335214121622811944689601659774780273e-12), SC_(-0.1536849212646484375e3), SC_(-0.28866373378511381562208782155938170760762386941484e-17), 
      SC_(0.1434108250941351264256e23), SC_(0.5747814608928768e16), SC_(0.44840411765612042671591552789323031902313232421875e-12), SC_(0.3930397855449088e16), SC_(0.55974105791738659682356948062274012447992428623037e-26), 
      SC_(0.1791534183567796994048e23), SC_(0.117519666905088e15), SC_(0.4539695293836727165124608e25), SC_(-0.11851369472e11), SC_(0.5136960010384668990061595781452168149528396570548e-29), 
      SC_(0.37615667369265726488576e23), SC_(0.60285032077445066533982753753662109375e-7), SC_(0.20308769621033541627525034757551728598068407904975e-22), SC_(-0.247466049536e12), SC_(-0.13827879934614263120844099105951850431902385276528e-20), 
      SC_(0.62052514199351953719296e23), SC_(0.53361689503260041482896036939970185741799468814861e-19), SC_(0.9145080596241438650400768e25), SC_(0.88322341442108154296875e-1), SC_(0.21049044423814160247516381166203365355421196509206e-22), 
      SC_(0.637769379930724892672e23), SC_(0.171703486984142728033475577831268310546875e-7), SC_(0.24447546456940472126007080078125e-3), SC_(-0.26166733832192e14), SC_(-0.92116642322940181469976802769678911153660574378313e-23), 
      SC_(0.68404845977357665697792e23), SC_(0.72781658358531814423386663293058518320322036743164e-13), SC_(0.69982016e9), SC_(0.16710320473225417331633553408e30), SC_(0.12006936511735891151610090899032124035778652751878e-38), 
      SC_(0.73319304495133544677376e23), SC_(0.2395810662364936952348672e25), SC_(0.24744480848549735980552416482594396338057229911556e-22), SC_(0.42062228e8), SC_(0.17336426124777650281100655275560249740310858728334e-26), 
      SC_(0.75699898250962334121984e23), SC_(0.29487300065576848347864702404308445693459361791611e-15), SC_(0.269071126588155160952832e26), SC_(0.1079208448e10), SC_(0.10050952810470758835622016409950300106552466316446e-27), 
      SC_(0.90721537714466311897088e23), SC_(0.391979743592841216e18), SC_(0.15474599e8), SC_(-0.22537551191366473088399216280475560110119998360502e-28), SC_(0.1696578299691663677244712148792478977665952793766e-21), 
      SC_(0.9457270987101889888256e23), SC_(0.5066510699517101396372603661077960168768186122179e-16), SC_(0.462716831308237710032896e24), SC_(0.84645887067429873701351894510480633471161127090454e-15), SC_(0.67289657651508478617450509217543609215998762913744e-15), 
      SC_(0.98595622295761632362496e23), SC_(0.1268757375e7), SC_(0.35219765472105368786515100509859621524810791015625e-12), SC_(-0.103132532828012544e18), SC_(-0.12278243966700762109179057970948886254224771593575e-26), 
      SC_(0.125138271246813010853888e24), SC_(0.507435381412506103515625e0), SC_(0.457703061401844024658203125e-1), SC_(-0.2404502470656e13), SC_(-0.52988754487843399200517365148569210454939618816664e-22), 
      SC_(0.210179409744077661405184e24), SC_(0.775467603201754089842406683474462128114628768627e-26), SC_(0.1351436267417501696e19), SC_(-0.9742528076171875e3), SC_(-0.48421711808796773233785861274336554356656425853338e-29), 
      SC_(0.211431536541276225667072e24), SC_(0.209520402514204164096e23), SC_(0.374303497374057769775390625e-1), SC_(0.119524568020779042853973805904388427734375e-7), SC_(0.19038048046682714911932275529728701896995311231633e-20), 
      SC_(0.261697851292622694383616e24), SC_(0.232045472709846499328e21), SC_(0.740444091796875e3), SC_(-0.40228969244368584234905483754118904471397399902344e-12), SC_(0.2584457357103991738079307538340636200872583014807e-21), 
      SC_(0.277204771630374352584704e24), SC_(0.178649388253688812255859375e-1), SC_(0.1626075136e10), SC_(0.32477325439453125e2), SC_(0.38373039029677064419294488780664341812940671142276e-16), 
      SC_(0.283834790857804101976064e24), SC_(0.1190209257472e16), SC_(0.14477963558912e14), SC_(0.4968694503397173407776768e25), SC_(0.1201225027146965514322811861323721315530271750753e-34), 
      SC_(0.283915729550307204530176e24), SC_(0.2116143198171993589085104758851230144500732421875e-11), SC_(0.14341135e7), SC_(0.5234013997795115008e19), SC_(0.16303242760584592161576898954092115216713837835169e-28), 
      SC_(0.385585445901317154275328e24), SC_(0.34954261617532788444443056161126115455317631131038e-20), SC_(0.962023936e9), SC_(0.1173024060108218691311776638031005859375e-6), SC_(0.71438835322268723367469707367256359972531243523922e-12), 
      SC_(0.48688847917066659823616e24), SC_(0.12212552573408426924125600686592708205013835254249e-21), SC_(0.1269279595243605041993096779751049041351507185027e-17), SC_(-0.72183370215235675049388064383748542240937240421772e-17), SC_(-0.87497936351054671381052980107636114663083556746798e6), 
      SC_(0.499508033700919974559744e24), SC_(0.83543058300870143401334898234397545457863287765576e-22), SC_(0.83509703330004320109836157826066482812166213989258e-13), SC_(0.28795215625e6), SC_(0.324824360656453279750504665337982414528286007074e-15), 
      SC_(0.606468632937360311451648e24), SC_(0.2216391133125217294264075462706387042999267578125e-10), SC_(0.12612983614823632236281100094325209625724382167533e-23), SC_(0.27668977677607065057685531428433023393154144287109e-12), SC_(0.22836510730242525394190340897974708875725743760574e1), 
      SC_(0.903024183216244059537408e24), SC_(0.15518063165544166788813746673722175600112280614926e-28), SC_(0.62680088576e11), SC_(-0.497913248836994171142578125e-1), SC_(-0.50366521060667220070702394050068183035765006836168e-22), 
      SC_(0.903113750805633203961856e24), SC_(0.2226578423545856e16), SC_(0.42335034231655299663543701171875e-3), SC_(0.72104642819988094924627148093521618126520988933947e-24), SC_(0.79999537635872505410233957947111656702210094502265e-16), 
      SC_(0.1031290663771427871653888e25), SC_(0.257509465140248750003593158908188343048095703125e-10), SC_(0.2186597346798524300263424e25), SC_(-0.40490232490529281863807058161608409818654763512313e-18), SC_(0.3809772984915159073428314854828102660677914157018e-17), 
      SC_(0.106024931377857842642944e25), SC_(0.2087689239260726026259362697601318359375e-6), SC_(0.8719922561795101501047611236572265625e-9), SC_(0.76085361343068974874624e24), SC_(0.13617175123806700013292760824408068565561587489962e-33), 
      SC_(0.1404590434004466388697088e25), SC_(0.2110544375e6), SC_(0.2084326724156433559977984e25), SC_(0.516740970708992e15), SC_(0.12115287981044689713392709277915156534118670211248e-30), 
      SC_(0.1511774231638439207370752e25), SC_(0.11230262057176420704600692485968125650585766606149e-24), SC_(0.2174006933223990990452293632e28), SC_(-0.2921577472e11), SC_(-0.42627147535886558844166037730594649807162499889897e-37), 
      SC_(0.1611108507323484384264192e25), SC_(0.11971012087915599989354498156046702206367626786232e-15), SC_(0.191893782528e12), SC_(0.873085859375e5), SC_(0.2867037497672644519809952844518942654262315886081e-19), 
      SC_(0.1657523685947075284959232e25), SC_(0.25513326169038305064700172114511289578331343363971e-18), SC_(0.80186429235745095942144e23), SC_(0.1547967032333730230675428174436092376708984375e-9), SC_(0.10388880365043120092474875588793613904886787794866e-17), 
      SC_(0.2325958174819757687046144e25), SC_(0.10062084498940748744644224643707275390625e-8), SC_(0.73901765063055790960788726806640625e-5), SC_(0.1686328448e10), SC_(0.20077650573547504082824414766675227623171993152151e-19), 
      SC_(0.2582930687253756671688704e25), SC_(0.98294646430729628238873174517209463374456390738487e-16), SC_(0.523289710174790201335781603120267391204833984375e-10), SC_(0.11728855386916592351553845219314098358154296875e-9), SC_(0.20504758549526996820756527033295801374195506995035e-1), 
      SC_(0.2827151743731615852920832e25), SC_(0.39566695676371483377659066249520947167184203863144e-17), SC_(0.14022327979649670404142971477700133076105259988253e-20), SC_(-0.1178793127110111527144908905029296875e-5), SC_(-0.21015559519097754189923254744815147163212563084929e-4), 
      SC_(0.3658255674684168267104256e25), SC_(0.347205125e7), SC_(0.952333915392338525421568e25), SC_(0.493732747180191557510859063296e30), SC_(0.38595612990567469629333401973433790503717814345531e-41), 
      SC_(0.80777571722833747247104e25), SC_(0.55398272e10), SC_(0.341833367802954728115011584e27), SC_(0.4525246741929405710336e22), SC_(0.13127412651201261844673654075052287525110627430968e-35), 
      SC_(0.18820064668587267094216704e26), SC_(0.302210201308383830109960399568080902099609375e-9), SC_(0.33895318467300131244893458519885746926814107382597e-21), SC_(-0.220309690490694265463389456272125244140625e-7), SC_(-0.8857373512501906409555193551969219570566044570186e-4), 
      SC_(0.21080026013603626963959808e26), SC_(0.46500309524870072390394842225085081377500273447367e-20), SC_(0.111704088747501373291015625e0), SC_(-0.2204564333716972336895229952e28), SC_(-0.93741877431301314282215548916844170971630819751383e-38), 
      SC_(0.24925849334950778558742528e26), SC_(0.31317834636651731435069138009717243018286553235541e-24), SC_(0.446171086848e12), SC_(0.611424244567615460255183279514312744140625e-10), SC_(0.18071495322856456358853957065938890778533770500459e-12), 
      SC_(0.25957591871894418276483072e26), SC_(0.33820226466031909703805272138232851375505561009049e-17), SC_(0.407093465328216552734375e-1), SC_(-0.74596487672624371624736927532950403474387712776661e-17), SC_(0.55899053627950401691741891899760992409332510195374e-3), 
      SC_(0.34176589422481911700258816e26), SC_(0.2594374745967797935009002685546875e-4), SC_(0.32639631015324299667668128677178174257278442382813e-11), SC_(-0.39206009507215186830735710722877728969003926356995e-26), SC_(0.99656432592835780571086861488747564238726543822412e-3), 
      SC_(0.52899930894361691974270976e26), SC_(0.403085186917451210319995880126953125e-5), SC_(0.6825940447919154921472e22), SC_(-0.14375419641822445568e20), SC_(-0.60363232208546199946445713316543948296321482911499e-34), 
      SC_(0.537890916288306029264896e26), SC_(0.12782816893625960774148491808127646127292821945365e-26), SC_(0.573235595703125e4), SC_(-0.12544778125e6), SC_(-0.71657596009498530548482712636575535494211682114149e-17), 
      SC_(0.8433542407536772363845632e26), SC_(0.42796459072778090240040672609944646251280316040511e-25), SC_(0.22687100431950362857652078512823989875357710843673e-19), SC_(0.11294291974004753756629686802523751532056905944046e-20), SC_(0.88701138982547221081855811970715058644159621057193e8), 
      SC_(0.139104185388464893432168448e27), SC_(0.231760859375e5), SC_(0.43720544762662627569227424828568473458290100097656e-12), SC_(0.2374636544e10), SC_(0.6921609089013412373280402427506383594598908716228e-21), 
      SC_(0.156845304607866907279753216e27), SC_(0.976198280113749206066131591796875e-4), SC_(0.10936154937744140625e3), SC_(-0.41998498541662710058071359488e30), SC_(-0.16652502911178853185876697517315755871318331105826e-40), 
      SC_(0.157999646511767429891227648e27), SC_(0.69354773968300552570460372409157516301196394394729e-27), SC_(0.40459505460468958310676912404346694529522210359573e-15), SC_(0.2743745536e11), SC_(0.26472063332119141767164566279621494424995662755822e-21), 
      SC_(0.169200325045883132536946688e27), SC_(0.12987603416915550095353577472e30), SC_(0.20901618155057581480384722985230161462766318436479e-21), SC_(-0.8212174501576704e16), SC_(-0.49333829304862756761854981623471626931832589089802e-40), 
      SC_(0.18019738841891322915192832e27), SC_(0.1161228928e10), SC_(0.18421718410258806513944641963201765549884569850292e-21), SC_(-0.39847982078741191696921488112504566858618204605591e-21), SC_(0.17283122168253610043193906220733507044384388549389e-6), 
      SC_(0.240541779585381516324110336e27), SC_(0.2905063139374032543660320015987963415682315826416e-13), SC_(0.36726935534616426233006549022576515777221278780118e-24), SC_(0.5391843328e12), SC_(0.10685173357205110804114321359031375712546961715976e-22), 
      SC_(0.26160499139176195703177216e27), SC_(0.25551566240720070127823149164214555639773607254028e-14), SC_(0.2455513858048e13), SC_(0.76865694789146174443197825024e29), SC_(0.42102041637540574313527997216886696455400412572293e-40), 
      SC_(0.28423416574930367528566784e27), SC_(0.34055852755898730066519419779069721698760986328125e-11), SC_(0.70640065850067723747656760044083495790872423425455e-25), SC_(0.10020495667270640877824310586985401272386297932826e-18), SC_(0.47817076033607555350752704896344130871965359055178e3), 
      SC_(0.339603340911883980420153344e27), SC_(0.539351792484352e16), SC_(0.5777183105237782001495361328125e-3), SC_(-0.42759100966109184e17), SC_(-0.63088198011691858070252939500618223753106170783744e-29), 
      SC_(0.418457674697258348132171776e27), SC_(0.1146871355062355355511214309376e31), SC_(0.4832090820796481536e19), SC_(0.2239617e8), SC_(0.85607629029587105611757975652813867965916905262051e-36), 
      SC_(0.482905248935018145708507136e27), SC_(0.11712293277443256300383769147321899595226568635553e-17), SC_(0.43801356384862208e17), SC_(0.790541259765625e4), SC_(0.11524019934599608840071663225685934856677773818628e-22), 
      SC_(0.704943726729360116931362816e27), SC_(0.280859119791213305197045481472e30), SC_(0.9329180732400125083648e22), SC_(-0.263649216e9), SC_(0.35954212306917041544272590413024826280517747178928e-37), 
      SC_(0.108138576895876428321521664e28), SC_(0.121629664e9), SC_(0.837203197023246876672e21), SC_(-0.34636652e8), SC_(0.3495258670475377943600732910414924000928562264996e-27), 
      SC_(0.1583264268936843798561947648e28), SC_(0.74033955225251559624163877337821304536191746592522e-16), SC_(0.106813757838608580641448497772216796875e-8), SC_(-0.95081157982349395751953125e-1), SC_(-0.78067064686933324405048609338056968328732594995288e-11), 
      SC_(0.1903848463306411019979456512e28), SC_(0.41524315625e6), SC_(0.9603179872256e13), SC_(-0.33670611871566835660019023634959012269973754882813e-11), SC_(0.7013450981963919041695196214483817396500069641397e-21), 
      SC_(0.1982984109938909458353618944e28), SC_(0.57559058523154999707763811983890536611676287215116e-28), SC_(0.18954326454529174714382811136e29), SC_(-0.71769535185590157312e20), SC_(-0.12181377246911709254263035815242321871232107633234e-40), 
      SC_(0.222246520174005267545980928e28), SC_(0.24442432318827852328354708908776139753005196553204e-21), SC_(0.1358339280940150480054651703124000152939184472259e-28), SC_(0.1929096832275390625e3), SC_(0.93043265128569252665328167060574294046977922061101e-14), 
      SC_(0.228460490382675067103346688e28), SC_(0.1059283606822132483824577235054573273384526110874e-22), SC_(0.7495925e5), SC_(0.18313684375e6), SC_(0.45341966440085175811927852865624259192364499711347e-18), 
      SC_(0.2295552972647520995079356416e28), SC_(0.8116024169921875e3), SC_(0.406449488413065216e18), SC_(0.1210972363736206571586395807697363987873694080033e-25), SC_(0.11680274510678021465134575907548276246526274420346e-21), 
      SC_(0.2314228013625886776106156032e28), SC_(0.14528588632178353334811760078082443214952945709229e-14), SC_(0.54849175282200488156594176e26), SC_(0.5798830216008354909718036651611328125e-7), SC_(0.54921077785694851775062771637993351556303331064265e-22), 
      SC_(0.3699745104553947847137951744e28), SC_(0.34977231725807742732787449097997501262533496350712e-30), SC_(0.120393285632e12), SC_(0.954876e8), SC_(0.22448886572410705870109454870839959584090293621426e-22), 
      SC_(0.3838393489343095451259240448e28), SC_(0.103355013339542251670339584e27), SC_(0.98872197265625e4), SC_(0.57959118635033995205500453873348476463434053584933e-17), SC_(0.12041009164150948897691954156849133755234146202352e-26), 
      SC_(0.5654821947040481368071995392e28), SC_(0.47785181184e14), SC_(0.40587309056e11), SC_(-0.37375441752374172210693359375e-3), SC_(0.48193946518009700351168874164523132159351681991985e-24), 
      SC_(0.6775909979186304065686470656e28), SC_(0.8062150656e10), SC_(0.348559752335036776448e21), SC_(-0.8760775059456393216e19), SC_(-0.10282120977675613763363596767906302856864535909313e-33), 
      SC_(0.7376334675354954747676196864e28), SC_(0.3832167254355459644063744e25), SC_(0.86986000872677090266227306614155168063007295131683e-15), SC_(-0.635832114613491743743541248e28), SC_(-0.24621535270065684155147722097385679585890775903462e-40), 
      SC_(0.9551179238333844741448269824e28), SC_(0.7608356306944e13), SC_(0.5558017730712890625e1), SC_(0.41698188855306519252274162436284849815711030154158e-27), SC_(0.15612097421897443717100059952264109969304027375674e-18), 
      SC_(0.10531197197128523245005307904e29), SC_(0.12791422998544384e17), SC_(0.660148875e6), SC_(0.33461133902897741824e20), SC_(0.40438261456319118306216960428142150932574137900723e-32), 
      SC_(0.12457122281020492087329554432e29), SC_(0.7671683806842035634176e22), SC_(0.232967583002618994214572012424468994140625e-7), SC_(-0.24723743603662803294991612279574155763839371502399e-16), SC_(0.22166650205242874655754051451333910848954470186131e-19), 
      SC_(0.15703756321543097476213374976e29), SC_(0.3366045475006103515625e1), SC_(0.15573768317699432373046875e0), SC_(0.6116611973854022065889826509770647605297401467399e-30), SC_(0.11358697102558723782406276684855724930886990175612e-11), 
      SC_(0.16696330462519916007687979008e29), SC_(0.1930155264e10), SC_(0.63629325734928786425753617162284769825930652586976e-20), SC_(0.12920223388671875e4), SC_(0.2308199605723093565210069675443489489234691184839e-19), 
      SC_(0.17764058704888363507915948032e29), SC_(0.79766535274496e14), SC_(0.39754495142903122994659328e26), SC_(-0.14620739417686359499606065152e29), SC_(-0.57422745573841589040276380059216580638301950767727e-41), 
      SC_(0.31748377778186208813596540928e29), SC_(0.1675580742552227722297344e25), SC_(0.42063803333440515664792681748951699777781240829747e-29), SC_(0.429656843192433391960064e24), SC_(0.23926759355712048744385470425532188141681573695193e-37), 
      SC_(0.3649235853244794839343562752e29), SC_(0.12279541379302346893022276017590817959179716467588e-21), SC_(0.40871462586513926278727773609006357347084303910378e-20), SC_(0.87854579712e12), SC_(0.67492676307713588597128960931053684956956100221764e-24), 
      SC_(0.36533776047685956616782348288e29), SC_(0.82729172633504849398988767461560200899839401245117e-13), SC_(0.8131970819162112e17), SC_(-0.1192539684780058450996875762939453125e-5), SC_(0.13274939233001620432487252088510733166654023704738e-22), 
      SC_(0.63201895715548519849695117312e29), SC_(0.659935944174255143387136e24), SC_(0.235792458057403564453125e0), SC_(-0.3216055136681984e16), SC_(-0.18080738259064818364416597919348501783180949800115e-37), 
      SC_(0.6372859541648241998931427328e29), SC_(0.242449971847236156463623046875e-2), SC_(0.27421585230570622547519032963236895739100873470306e-15), SC_(-0.303756275177001953125e2), SC_(-0.2116865223447144892600764830285901409868915835424e-14), 
      SC_(0.66201188727981103266043789312e29), SC_(0.733696256e9), SC_(0.350810660994547712e18), SC_(-0.2088726080984315558453090488910675048828125e-8), SC_(0.1518448361705534157919668106359692557429828526005e-25), 
      SC_(0.67397727780311165361354440704e29), SC_(0.2701057007003141150867456e25), SC_(0.32037437278282544783625240825131186284124851226807e-14), SC_(-0.14639644477145580259147550350462552160024642944336e-12), SC_(0.26795251743869315367874488984214665026594244506073e-20), 
      SC_(0.74469943825056746033385570304e29), SC_(0.25381451890023692523876122624e29), SC_(0.353061568e9), SC_(0.3667164349963059066794812679290771484375e-7), SC_(0.70123509979767730264405232269736730186653622643256e-31), 
      SC_(0.83503273667541398709050802176e29), SC_(0.64436475218886656e17), SC_(0.1095445250048e15), SC_(-0.27828965472666412863213985278623730405131117028594e-26), SC_(0.18517871294794141505416209832668190646081405513643e-27), 
      SC_(0.154135841378084202520367857664e30), SC_(0.11531852972032e14), SC_(0.28385876039913134187331286456979634325037409325887e-20), SC_(0.64800658718743622607072501400418684802673396916362e-20), SC_(0.31602768754325763081308012038930598073631539942634e-10), 
      SC_(0.205367992548434895604069433344e30), SC_(0.18794387499923534284127922718010683666989280027337e-18), SC_(0.644523545719734272e18), SC_(0.21339260514789921879362708770529188928577468686854e-21), SC_(0.77709407338464422363910627214199294770600429104781e-13), 
      SC_(0.288644753185258968910800093184e30), SC_(0.3712882e7), SC_(0.67304340158588786789888913154097233038086756096163e-21), SC_(0.228604896e9), SC_(0.6770315462223105083152407343178427212980572931536e-22), 
      SC_(0.32259278802051668555153276928e30), SC_(0.6638677978515625e3), SC_(0.11419584692467545095073688798947841860353946685791e-13), SC_(-0.914323027245700359344482421875e-4), SC_(-0.77167253067005495411786081658186819275011987939055e-17), 
      SC_(0.593089902380358100434877939712e30), SC_(0.6506956228718475954142519412926048971712589263916e-14), SC_(0.61562469482421875e2), SC_(0.2321270964224e13), SC_(0.21597485998566959444034291971333852159947917872266e-25), 
      SC_(0.653810657301073942950006751232e30), SC_(0.3684862263296e13), SC_(0.1658748045099008e17), SC_(-0.2043063195140096e16), SC_(-0.17992368419735800205714333900182443278381089486339e-30), 
      SC_(0.90054999923278052824918786048e30), SC_(0.5752800417419362304e19), SC_(0.23091611800228823082094034944e29), SC_(0.437946654856204986572265625e-1), SC_(0.20691242362670718543784273355620160692479713280658e-36), 
      SC_(0.1138966491359350198995104301056e31), SC_(0.16628866613248e14), SC_(0.83722254681922700089433337836521478725337885862245e-21), SC_(0.351686295552e12), SC_(0.16740484414913831836071532979123766364786418157375e-26), 
      SC_(0.1155650423248669340749283721216e31), SC_(0.55448366981994133391117331177699867339470074512064e-18), SC_(0.120595209390657634304e22), SC_(-0.31079530179668142456832e23), SC_(-0.20503537182647658707141982907149513184896420806907e-36)
   };
#undef SC_


