/*
When I run Rose on the following piece of code
        namespace namespace1 {
                template <class T> void foo(T t) {}
        }

        class className {
         public:
           void bar(int value) {
               namespace1::foo<int>(value);
           }
        };

it generates the following:

namespace namespace1
   {
     template < class T > void foo ( T t ) { }
   }
void namespace1::foo(int t);

class className
   {
     public: inline void bar(int value)
        {
          namespace1::foo(value);
        }

   };

When I run g++ over this code it gives me the following error:
        error: "void namespace1::foo(int)" should have been declared inside "namespace1"

The problem only comes up when templates are used. Do you know what the problem might be 
or what it might take to fix it? For the time being I'm creating workarounds in Perl that 
patch up problems in the code generated by Rose but these are obviously brittle so I'd 
much rather have a robust solution from you guys.

Greg Bronevetsky
*/


namespace namespace1
   {
     template <class T> void foo(T t) {}
   }

class className
   {
     public:
          void bar(int value)
             {
               namespace1::foo<int>(value);
             }
   };
