#include "sage3basic.h"
#include <string>
#include <map>
#include <fstream>

#ifdef ROSEQT_EXPERIMENTAL
    #include "PTracer.h"
#endif

namespace InstructionCountAnnotator  {

using namespace std;



/// this version reads a file of the format "addrInHex \t execCount\n" for example generated by pin
void annotate(SgNode * proj, const std::string & instfile)
{
    map<long, unsigned long> instMap;

    ifstream fStream (instfile.c_str(),ifstream::in);
    if(! fStream.is_open())
    {
        cerr << "Failed to open file: " << instfile << endl;
        return;
    }


    long addr;
    unsigned long execCount;

    while( fStream.good())
    {
        fStream >> hex >> addr;
        fStream >> dec >> execCount;

        instMap[addr]=execCount;
    }
    cout << "Read " << instMap.size() << " lines from " << instfile;

    ofstream controlOut ("control.out");

    // Annotate the AST

    typedef Rose_STL_Container<SgNode*>::iterator StatementIter;
    Rose_STL_Container<SgNode *> stmts = NodeQuery::querySubTree(proj,V_SgAsmInstruction);
    if(stmts.size()==0)
    {
        cout << "No binary Nodes to annotate" << endl;
        return;
    }

    cout << "annotating file " << proj << " " << proj->get_parent() << endl;

    for(StatementIter i= stmts.begin(); i != stmts.end(); ++i)
    {
        SgAsmStatement * s = isSgAsmStatement(*i);
        assert(s);
        s->addNewAttribute("Execution Count",new MetricAttribute(instMap[s->get_address()]));
    }

}




/// this version runs the executable and inserts breakpoint at every instruction (ptrace)
void annotate(SgNode * proj,
              std::vector<std::string> args = std::vector<std::string>() )
{

#ifdef ROSEQT_EXPERIMENTAL
    PTracer tracer;

    // Get path of executable
    /*if(proj->numberOfFiles() <= 0)
    {
        cerr << "InstructionCountAnnotator - Error: No Files in project" << endl;
        return;
    }

    assert( proj->get_numberOfTraversalSuccessors() > 0);
    if( ! isSgBinaryFile(proj->get_traversalSuccessorByIndex(0)))
    {
        cerr << "InstructionCountAnnotator - Error: Not a binary AST" << endl;
        return;
    }*/

    // Build an array with path at the first entry
    Sg_File_Info * fi = proj->get_file_info();
    vector<string> newArgs;
    newArgs.reserve(args.size()+1);
    newArgs.push_back(fi->get_filenameString());
    for(size_t i=0; i< args.size(); i++)
        newArgs.push_back(args[i]);


    // Load the process
    tracer.loadProcess(newArgs);

    // Add a breakpoint at each assembler instruction
    typedef Rose_STL_Container<SgNode*>::iterator StatementIter;
    Rose_STL_Container<SgNode *> stmts = NodeQuery::querySubTree(proj,V_SgAsmInstruction);
    assert(stmts.size() > 0);

    for(StatementIter i= stmts.begin(); i != stmts.end(); ++i)
    {
        SgAsmStatement * s = isSgAsmStatement(*i);
        assert(s);
        tracer.addStatementForTracing(s);
    }


    tracer.run();

    // Annotate the AST
    const map<address,PTracer::BreakpointInfo> & bpInfo = tracer.getBreakpointInfoMap();
    for (PTracer::const_BpIter i= bpInfo.begin(); i != bpInfo.end(); ++i)
    {
        const PTracer::BreakpointInfo & info = i->second;
        info.getNode()->addNewAttribute("Execution Count", new MetricAttribute(info.getHitCount()));
        //if(info.getHitCount() > 0)
        //    cerr << "Annotating: " << info.getNode()->class_name() << " with " << dec << info.getHitCount()<< endl;
    }

#else
    cerr<< "Annotating ast with PTracer experimental (not ported to all platforms), use ROSEQT_EXPERIMENTAL flag" << endl;
#endif


}




} //namespace
