#!/bin/bash
# A code generator to generate multiple instances of run_me ()
# which glues the XOMP runtime library and Fortran 77 outlined functions

# Liao 12/13/2010

# max number of subroutine parameters
# this number should be the same value as MAX_OUTLINED_FUNC_PARAMETER_COUNT
# from libxomp.h

MAX_PARAMETER_COUNT=256
echo "/* This file is automatically generated from $0 "
echo " * Maximum number of subroutine parameters is $MAX_PARAMETER_COUNT "
echo " * To regenerate run_me_defs.inc, type $0 > run_me_defs.inc */"

for ((c=1; c<=$MAX_PARAMETER_COUNT; c++))
do
  echo "static void run_me_$c (void*);"
  echo "void run_me_$c (void * data)"
  echo "{"
  echo "  typedef void (*FUNC_P)("
  for ((d=1; d<=$c;d++ ))
  do
    if [ $d -ne $c ] ; then
      echo "              void *,"
    else
      echo "              void *);"
    fi
  done  
  echo "  FUNC_P func;"
  echo "  func =(FUNC_P) (((void**)data)[0]);"

  echo "  func("
  for ((e=1; e<=$c;e++ ))
  do
    if [ $e -ne $c ] ; then
      echo "              ((void**)data)[$e],"
    else
      echo "              ((void**)data)[$e]);"
    fi

  done  
  echo "}"

done  
