#ifndef FIXUP_TEMPLATE_INSTANTIATIONS_H
#define FIXUP_TEMPLATE_INSTANTIATIONS_H

// DQ (5/27/2005):
/*! \brief Fixups template specializations generated by ROSE from template instantiations.

    Template instantions generated in either the prelink phase or as part of the initial compilation
    should be marked as comiler generated since they have no source position.

    \implementation We have to output the declaration of the specialization after the template declaration 
    and before it's first use in the source file.  It is an error to transform the specialization in a file 
    where it is not first used (e.g. if the first use appears in a header file then the first use could appear 
    before the declaration).  Note also that only those template specializations that are transformed are output
    by ROSE.
 */
void fixupTemplateInstantiations( SgNode* node );

class FixupTemplateInstantiations : public SgSimpleProcessing
   {
     public:
      //! Required traversal function
          void visit (SgNode* node);
   };

// endif for FIXUP_TEMPLATE_INSTANTIATIONS_H
#endif
