//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part8() {
    AssemblerX86::InsnDefn *defn = NULL;
    defn = new InsnDefn("setne",  x86_setne,   0x03, 0x0f95, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 95     SETNE r/m8*      Valid    N.E.       Set byte if not equal (ZF=0).
    defn = new InsnDefn("setne",  x86_setne,   0x02, 0x0f95, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 9E           SETNG r/m8       Valid    Valid      Set byte if not greater (ZF=1 or
    //                                                      SF OF)
    defn = new InsnDefn("setle",  x86_setle,   0x03, 0x0f9e, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 9E     SETNG r/m8*      Valid    N.E.       Set byte if not greater (ZF=1 or
    //                                                      SF OF).
    defn = new InsnDefn("setle",  x86_setle,   0x02, 0x0f9e, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 9C           SETNGE r/m8      Valid    Valid      Set byte if not greater or equal
    //                                                      (SF OF).
    defn = new InsnDefn("setl",   x86_setl,    0x03, 0x0f9c, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 9C     SETNGE r/m8*     Valid    N.E.       Set byte if not greater or equal
    //                                                      (SF OF).
    defn = new InsnDefn("setl",   x86_setl,    0x02, 0x0f9c, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 9D           SETNL r/m8       Valid    Valid      Set byte if not less (SF=OF).
    defn = new InsnDefn("setge",  x86_setge,   0x03, 0x0f9d, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 9D     SETNL r/m8*      Valid    N.E.       Set byte if not less (SF=OF).
    defn = new InsnDefn("setge",  x86_setge,   0x02, 0x0f9d, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 9F           SETNLE r/m8      Valid    Valid      Set byte if not less or equal (ZF=0
    //                                                      and SF=OF).
    defn = new InsnDefn("setg",   x86_setg,    0x03, 0x0f9f, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 9F     SETNLE r/m8*     Valid    N.E.       Set byte if not less or equal (ZF=0
    //                                                      and SF=OF).
    defn = new InsnDefn("setg",   x86_setg,    0x02, 0x0f9f, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 91           SETNO r/m8       Valid    Valid      Set byte if not overflow (OF=0).
    defn = new InsnDefn("setno",  x86_setno,   0x03, 0x0f91, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 91     SETNO r/m8*      Valid    N.E.       Set byte if not overflow (OF=0).
    defn = new InsnDefn("setno",  x86_setno,   0x02, 0x0f91, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 9B           SETNP r/m8       Valid    Valid      Set byte if not parity (PF=0).
    defn = new InsnDefn("setpo",  x86_setpo,   0x03, 0x0f9b, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 9B     SETNP r/m8*      Valid    N.E.       Set byte if not parity (PF=0).
    defn = new InsnDefn("setpo",  x86_setpo,   0x02, 0x0f9b, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 99           SETNS r/m8       Valid    Valid      Set byte if not sign (SF=0).
    defn = new InsnDefn("setns",  x86_setns,   0x03, 0x0f99, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 99     SETNS r/m8*      Valid    N.E.       Set byte if not sign (SF=0).
    defn = new InsnDefn("setns",  x86_setns,   0x02, 0x0f99, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 95           SETNZ r/m8       Valid    Valid      Set byte if not zero (ZF=0).
    defn = new InsnDefn("setne",  x86_setne,   0x03, 0x0f95, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  REX + 0F 95        SETNZ r/m8*        Valid       N.E.           Set byte if not zero (ZF=0).
    defn = new InsnDefn("setne",  x86_setne,   0x02, 0x0f95, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  0F 90              SETO r/m8          Valid       Valid          Set byte if overflow (OF=1)
    defn = new InsnDefn("seto",   x86_seto,    0x03, 0x0f90, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  REX + 0F 90        SETO r/m8*         Valid       N.E.           Set byte if overflow (OF=1).
    defn = new InsnDefn("seto",   x86_seto,    0x02, 0x0f90, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  0F 9A              SETP r/m8          Valid       Valid          Set byte if parity (PF=1).
    defn = new InsnDefn("setpe",  x86_setpe,   0x03, 0x0f9a, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  REX + 0F 9A        SETP r/m8*         Valid       N.E.           Set byte if parity (PF=1).
    defn = new InsnDefn("setpe",  x86_setpe,   0x02, 0x0f9a, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  0F 9A              SETPE r/m8         Valid       Valid          Set byte if parity even (PF=1).
    defn = new InsnDefn("setpe",  x86_setpe,   0x03, 0x0f9a, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  REX + 0F 9A        SETPE r/m8*        Valid       N.E.           Set byte if parity even (PF=1).
    defn = new InsnDefn("setpe",  x86_setpe,   0x02, 0x0f9a, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  0F 9B              SETPO r/m8         Valid       Valid          Set byte if parity odd (PF=0).
    defn = new InsnDefn("setpo",  x86_setpo,   0x03, 0x0f9b, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  REX + 0F 9B        SETPO r/m8*        Valid       N.E.           Set byte if parity odd (PF=0).
    defn = new InsnDefn("setpo",  x86_setpo,   0x02, 0x0f9b, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  0F 98              SETS r/m8          Valid       Valid          Set byte if sign (SF=1).
    defn = new InsnDefn("sets",   x86_sets,    0x03, 0x0f98, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  REX + 0F 98        SETS r/m8*         Valid       N.E.           Set byte if sign (SF=1).
    defn = new InsnDefn("sets",   x86_sets,    0x02, 0x0f98, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  0F 94              SETZ r/m8          Valid       Valid          Set byte if zero (ZF=1).
    defn = new InsnDefn("sete",   x86_sete,    0x03, 0x0f94, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-391");
    define(defn);
    //  REX + 0F 94        SETZ r/m8*         Valid       N.E.           Set byte if zero (ZF=1).
    defn = new InsnDefn("sete",   x86_sete,    0x02, 0x0f94, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-394");
    define(defn);

    //--- page 4-394 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F AE /7    SFENCE         Valid        Valid         Serializes store operations.
    defn = new InsnDefn("sfence", x86_sfence,  0x03, 0x0fae, od_e7);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-395");
    define(defn);

    //--- page 4-395 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 01 /0           SGDT m                Valid     Valid        Store GDTR to m.
    defn = new InsnDefn("sgdt",   x86_sgdt,    0x03, 0x0f01, od_e0, od_m);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-398");
    define(defn);

    //--- page 4-398 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F A4             SHLD r/m16, r16,     Valid         Valid         Shift r/m16 to left imm8
    //                   imm8                                             places while shifting bits
    //                                                                    from r16 in from the right.
    defn = new InsnDefn("shld",   x86_shld,    0x03, 0x0fa4, od_ib, od_r_m16, od_r16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-398");
    define(defn);
    // 0F A5             SHLD r/m16, r16, CL Valid          Valid         Shift r/m16 to left CL places
    //                                                                    while shifting bits from r16
    //                                                                    in from the right.
    defn = new InsnDefn("shld",   x86_shld,    0x03, 0x0fa5, od_none, od_r_m16, od_r16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-398");
    define(defn);
    // 0F A4             SHLD r/m32, r32,     Valid         Valid         Shift r/m32 to left imm8
    //                   imm8                                             places while shifting bits
    //                                                                    from r32 in from the right.
    defn = new InsnDefn("shld",   x86_shld,    0x03, 0x0fa4, od_ib, od_r_m32, od_r32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-398");
    define(defn);
    // REX.W + 0F A4     SHLD r/m64, r64,     Valid         N.E.          Shift r/m64 to left imm8
    //                   imm8                                             places while shifting bits
    //                                                                    from r64 in from the right.
    defn = new InsnDefn("shld",   x86_shld,    0x02, 0x0fa4, od_rexw|od_ib, od_r_m64, od_r64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-398");
    define(defn);
    // 0F A5             SHLD r/m32, r32, CL Valid          Valid         Shift r/m32 to left CL places
    //                                                                    while shifting bits from r32
    //                                                                    in from the right.
    defn = new InsnDefn("shld",   x86_shld,    0x03, 0x0fa5, od_none, od_r_m32, od_r32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-398");
    define(defn);
    // REX.W + 0F A5     SHLD r/m64, r64, CL Valid          N.E.          Shift r/m64 to left CL places
    //                                                                    while shifting bits from r64
    //                                                                    in from the right.
    defn = new InsnDefn("shld",   x86_shld,    0x02, 0x0fa5, od_rexw, od_r_m64, od_r64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-401");
    define(defn);

    //--- page 4-401 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F AC               SHRD r/m16,    Valid        Valid        Shift r/m16 to right imm8 places
    //                      r16, imm8                                while shifting bits from r16 in
    //                                                               from the left.
    defn = new InsnDefn("shrd",   x86_shrd,    0x03, 0x0fac, od_ib, od_r_m16, od_r16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-401");
    define(defn);
    //  0F AD               SHRD r/m16,    Valid        Valid        Shift r/m16 to right CL places
    //                      r16, CL                                  while shifting bits from r16 in
    //                                                               from the left.
    defn = new InsnDefn("shrd",   x86_shrd,    0x03, 0x0fad, od_none, od_r_m16, od_r16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-401");
    define(defn);
    //  0F AC               SHRD r/m32,    Valid        Valid        Shift r/m32 to right imm8 places
    //                      r32, imm8                                while shifting bits from r32 in
    //                                                               from the left.
    defn = new InsnDefn("shrd",   x86_shrd,    0x03, 0x0fac, od_ib, od_r_m32, od_r32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-401");
    define(defn);
    //  REX.W + 0F AC       SHRD r/m64,    Valid        N.E.         Shift r/m64 to right imm8 places
    //                      r64, imm8                                while shifting bits from r64 in
    //                                                               from the left.
    defn = new InsnDefn("shrd",   x86_shrd,    0x02, 0x0fac, od_rexw|od_ib, od_r_m64, od_r64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-401");
    define(defn);
    //  0F AD               SHRD r/m32,    Valid        Valid        Shift r/m32 to right CL places
    //                      r32, CL                                  while shifting bits from r32 in
    //                                                               from the left.
    defn = new InsnDefn("shrd",   x86_shrd,    0x03, 0x0fad, od_none, od_r_m32, od_r32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-401");
    define(defn);
    //  REX.W + 0F AD       SHRD r/m64,    Valid        N.E.         Shift r/m64 to right CL places
    //                      r64, CL                                  while shifting bits from r64 in
    //                                                               from the left.
    defn = new InsnDefn("shrd",   x86_shrd,    0x02, 0x0fad, od_rexw, od_r_m64, od_r64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-404");
    define(defn);

    //--- page 4-404 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F C6 /r ib SHUFPD xmm1,              Valid    Valid          Shuffle packed double-precision
    //                xmm2/m128, imm8                                   floating-point values selected by
    //                                                                  imm8 from xmm1 and
    //                                                                  xmm2/m128 to xmm1.
    defn = new InsnDefn("shufpd", x86_shufpd,  0x03, 0x660fc6, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-407");
    define(defn);

    //--- page 4-407 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F C6 /r ib    SHUFPS xmm1,              Valid       Valid            Shuffle packed single-precision
    //                 xmm2/m128, imm8                                        floating-point values selected by
    //                                                                        imm8 from xmm1 and
    //                                                                        xmm1/m128 to xmm1.
    defn = new InsnDefn("shufps", x86_shufps,  0x03, 0x0fc6, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-410");
    define(defn);

    //--- page 4-410 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 01 /1           SIDT m              Valid         Valid           Store IDTR to m.
    defn = new InsnDefn("sidt",   x86_sidt,    0x03, 0x0f01, od_e1, od_m);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-413");
    define(defn);

    //--- page 4-413 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 00 /0        SLDT r/m16          Valid    Valid       Stores segment selector from LDTR
    //                                                           in r/m16.
    defn = new InsnDefn("sldt",   x86_sldt,    0x03, 0x0f00, od_e0, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-413");
    define(defn);
    //  REX.W + 0F      SLDT r64/m16        Valid    Valid       Stores segment selector from LDTR
    //  00 /0                                                    in r64/m16.
    defn = new InsnDefn("sldt",   x86_sldt,    0x03, 0x0f00, od_rexw|od_e0, od_r64_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-415");
    define(defn);

    //--- page 4-415 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 01 /4      SMSW r/m16        Valid    Valid      Store machine status word to r/m16.
    defn = new InsnDefn("smsw",   x86_smsw,    0x03, 0x0f01, od_e4, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-415");
    define(defn);
    //  0F 01 /4      SMSW r32/m16      Valid    Valid      Store machine status word in low-order
    //                                                      16 bits of r32/m16; high-order 16 bits
    //                                                      of r32 are undefined.
    defn = new InsnDefn("smsw",   x86_smsw,    0x03, 0x0f01, od_e4, od_r32_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-415");
    define(defn);
    //  REX.W + 0F    SMSW r64/m16      Valid    Valid      Store machine status word in low-order
    //  01 /4                                               16 bits of r64/m16; high-order 16 bits
    //                                                      of r32 are undefined.
    defn = new InsnDefn("smsw",   x86_smsw,    0x03, 0x0f01, od_rexw|od_e4, od_r64_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-418");
    define(defn);

    //--- page 4-418 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 51 /r SQRTPD xmm1,           Valid     Valid        Computes square roots of the
    //             xmm2/m128                                     packed double-precision floating-
    //                                                           point values in xmm2/m128 and
    //                                                           stores the results in xmm1.
    defn = new InsnDefn("sqrtpd", x86_sqrtpd,  0x03, 0x660f51, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-421");
    define(defn);

    //--- page 4-421 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 51 /r    SQRTPS xmm1,         Valid        Valid          Computes square roots of the packed
    //              xmm2/m128                                        single-precision floating-point values in
    //                                                               xmm2/m128 and stores the results in
    //                                                               xmm1.
    defn = new InsnDefn("sqrtps", x86_sqrtps,  0x03, 0x0f51, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-424");
    define(defn);

    //--- page 4-424 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // F2 0F 51 /r     SQRTSD xmm1,             Valid       Valid           Computes square root of the
    //                 xmm2/m64                                             low double-precision floating-
    //                                                                      point value in xmm2/m64 and
    //                                                                      stores the results in xmm1.
    defn = new InsnDefn("sqrtsd", x86_sqrtsd,  0x03, 0xf20f51, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-427");
    define(defn);

    //--- page 4-427 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  F3 0F 51 /r    SQRTSS xmm1,            Valid       Valid          Computes square root of the low
    //                 xmm2/m32                                           single-precision floating-point value
    //                                                                    in xmm2/m32 and stores the
    //                                                                    results in xmm1.
    defn = new InsnDefn("sqrtss", x86_sqrtss,  0x03, 0xf30f51, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-430");
    define(defn);

    //--- page 4-430 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // F9               STC               Valid       Valid      Set CF flag.
    defn = new InsnDefn("stc",    x86_stc,     0x03, 0xf9, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-431");
    define(defn);

    //--- page 4-431 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  FD              STD                Valid       Valid      Set DF flag.
    defn = new InsnDefn("std",    x86_std,     0x03, 0xfd, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-432");
    define(defn);

    //--- page 4-432 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // FB                STI               Valid          Valid         Set interrupt flag; external, maskable
    //                                                                  interrupts enabled at the end of the
    //                                                                  next instruction.
    defn = new InsnDefn("sti",    x86_sti,     0x03, 0xfb, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-435");
    define(defn);

    //--- page 4-435 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F AE /3      STMXCSR m32       Valid     Valid      Store contents of MXCSR register to
    //                                                       m32.
    defn = new InsnDefn("stmxcsr", x86_stmxcsr, 0x03, 0x0fae, od_e3, od_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);

    //--- page 4-437 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  AA              STOS m8       Valid        Valid      For legacy mode, store AL at address
    //                                                        ES:(E)DI; For 64-bit mode store AL at
    //                                                        address RDI or EDI.
    defn = new InsnDefn("stos",   x86_stos,    0x03, 0xaa, od_none, od_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);
    //  AB              STOS m16      Valid        Valid      For legacy mode, store AX at address
    //                                                        ES:(E)DI; For 64-bit mode store AX at
    //                                                        address RDI or EDI.
    defn = new InsnDefn("stos",   x86_stos,    0x03, 0xab, od_none, od_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);
    //  AB              STOS m32      Valid        Valid      For legacy mode, store EAX at address
    //                                                        ES:(E)DI; For 64-bit mode store EAX at
    //                                                        address RDI or EDI.
    defn = new InsnDefn("stos",   x86_stos,    0x03, 0xab, od_none, od_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);
    //  REX.W + AB      STOS m64      Valid        N.E.       Store RAX at address RDI or EDI.
    defn = new InsnDefn("stos",   x86_stos,    0x02, 0xab, od_rexw, od_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);
    //  AA              STOSB         Valid        Valid      For legacy mode, store AL at address
    //                                                        ES:(E)DI; For 64-bit mode store AL at
    //                                                        address RDI or EDI.
    defn = new InsnDefn("stosb",  x86_stosb,   0x03, 0xaa, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);
    //  AB              STOSW         Valid        Valid      For legacy mode, store AX at address
    //                                                        ES:(E)DI; For 64-bit mode store AX at
    //                                                        address RDI or EDI.
    defn = new InsnDefn("stosw",  x86_stosw,   0x03, 0xab, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);
    //  AB              STOSD         Valid        Valid      For legacy mode, store EAX at address
    //                                                        ES:(E)DI; For 64-bit mode store EAX at
    //                                                        address RDI or EDI.
    defn = new InsnDefn("stosd",  x86_stosd,   0x03, 0xab, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-437");
    define(defn);
    //  REX.W + AB      STOSQ         Valid        N.E.       Store RAX at address RDI or EDI.
    defn = new InsnDefn("stosq",  x86_stosq,   0x02, 0xab, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-441");
    define(defn);

    //--- page 4-441 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 00 /1      STR r/m16            Valid     Valid        Stores segment selector from TR in
    //                                                            r/m16.
    defn = new InsnDefn("str",    x86_str,     0x03, 0x0f00, od_e1, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);

    //--- page 4-443 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  2C ib                SUB AL, imm8          Valid       Valid         Subtract imm8 from AL.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x2c, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  2D iw                SUB AX, imm16         Valid       Valid         Subtract imm16 from AX.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x2d, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  2D id                SUB EAX, imm32        Valid       Valid         Subtract imm32 from EAX.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x2d, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX.W + 2D id        SUB RAX, imm32       Valid        N.E.          Subtract imm32 sign-
    //                                                                       extended to 64-bits from
    //                                                                       RAX.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x2d, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  80 /5 ib             SUB r/m8, imm8       Valid        Valid         Subtract imm8 from r/m8.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x80, od_e5|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX + 80 /5 ib       SUB r/m8*, imm8      Valid        N.E.          Subtract imm8 from r/m8.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x80, od_rex|od_e5|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  81 /5 iw             SUB r/m16, imm16 Valid            Valid         Subtract imm16 from r/m16.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x81, od_e5|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  81 /5 id             SUB r/m32, imm32 Valid            Valid         Subtract imm32 from r/m32.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x81, od_e5|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX.W + 81 /5 id     SUB r/m64, imm32 Valid            N.E.          Subtract imm32 sign-
    //                                                                       extended to 64-bits from
    //                                                                       r/m64.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x81, od_rexw|od_e5|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  83 /5 ib             SUB r/m16, imm8      Valid        Valid         Subtract sign-extended imm8
    //                                                                       from r/m16.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x83, od_e5|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  83 /5 ib             SUB r/m32, imm8      Valid        Valid         Subtract sign-extended imm8
    //                                                                       from r/m32.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x83, od_e5|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX.W + 83 /5 ib     SUB r/m64, imm8      Valid        N.E.          Subtract sign-extended imm8
    //                                                                       from r/m64.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x83, od_rexw|od_e5|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  28 /r                SUB r/m8, r8         Valid        Valid         Subtract r8 from r/m8.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x28, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX + 28 /r          SUB r/m8*, r8*       Valid        N.E.          Subtract r8 from r/m8.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x28, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  29 /r                SUB r/m16, r16       Valid        Valid         Subtract r16 from r/m16.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x29, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  29 /r                SUB r/m32, r32       Valid        Valid         Subtract r32 from r/m32.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x29, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX.W + 29 /r        SUB r/m64, r32       Valid        N.E.          Subtract r64 from r/m64.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x29, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  2A /r                SUB r8, r/m8         Valid        Valid         Subtract r/m8 from r8.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x2a, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX + 2A /r          SUB r8*, r/m8*       Valid        N.E.          Subtract r/m8 from r8.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x2a, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  2B /r                SUB r16, r/m16       Valid        Valid         Subtract r/m16 from r16.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x2b, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  2B /r                SUB r32, r/m32       Valid        Valid         Subtract r/m32 from r32.
    defn = new InsnDefn("sub",    x86_sub,     0x03, 0x2b, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-443");
    define(defn);
    //  REX.W + 2B /r        SUB r64, r/m64       Valid        N.E.          Subtract r/m64 from r64.
    defn = new InsnDefn("sub",    x86_sub,     0x02, 0x2b, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-446");
    define(defn);

    //--- page 4-446 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 5C /r     SUBPD xmm1,         Valid         Valid          Subtract packed double-precision
    //                 xmm2/m128                                        floating-point values in
    //                                                                  xmm2/m128 from xmm1.
    defn = new InsnDefn("subpd",  x86_subpd,   0x03, 0x660f5c, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-449");
    define(defn);

    //--- page 4-449 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 5C /r     SUBPS xmm1              Valid       Valid        Subtract packed single-precision
    //               xmm2/m128                                        floating-point values in xmm2/mem
    //                                                                from xmm1.
    defn = new InsnDefn("subps",  x86_subps,   0x03, 0x0f5c, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-452");
    define(defn);

    //--- page 4-452 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // F2 0F 5C /r     SUBSD xmm1,        Valid         Valid           Subtracts the low double-
    //                 xmm2/m64                                         precision floating-point values in
    //                                                                  xmm2/mem64 from xmm1.
    defn = new InsnDefn("subsd",  x86_subsd,   0x03, 0xf20f5c, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-455");
    define(defn);

    //--- page 4-455 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  F3 0F 5C /r      SUBSS xmm1,             Valid       Valid      Subtract the lower single-precision
    //                   xmm2/m32                                       floating-point values in xmm2/m32
    //                                                                  from xmm1.
    defn = new InsnDefn("subss",  x86_subss,   0x03, 0xf30f5c, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-458");
    define(defn);

    //--- page 4-458 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 01 /7          SWAPGS         Valid    Invalid      Exchanges the current GS base register
    //                                                        value with the value contained in MSR
    //                                                        address C0000102H.
    defn = new InsnDefn("swapgs", x86_swapgs,  0x02, 0x0f01, od_e7);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-460");
    define(defn);

    //--- page 4-460 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 05            SYSCALL          Valid         Invalid       Fast call to privilege level 0
    //                                                               system procedures.
    defn = new InsnDefn("syscall", x86_syscall, 0x02, 0x0f05, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-462");
    define(defn);

    //--- page 4-462 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 34            SYSENTER        Valid    Valid      Fast call to privilege level 0 system
    //                                                      procedures.
    defn = new InsnDefn("sysenter", x86_sysenter, 0x03, 0x0f34, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-466");
    define(defn);

    //--- page 4-466 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 35           SYSEXIT       Valid    Valid      Fast return to privilege level 3 user code.
    defn = new InsnDefn("sysexit", x86_sysexit, 0x03, 0x0f35, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-466");
    define(defn);
    // REX.W + 0F SYSEXIT            Valid    Valid      Fast return to 64-bit mode privilege level 3
    // 35                                                user code.
    defn = new InsnDefn("sysexit", x86_sysexit, 0x03, 0x0f35, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-470");
    define(defn);

    //--- page 4-470 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 07           SYSRET        Valid        Invalid        Return from fast system call
    defn = new InsnDefn("sysret", x86_sysret,  0x02, 0x0f07, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);

    //--- page 4-472 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // A8 ib                TEST AL, imm8         Valid        Valid        AND imm8 with AL; set SF, ZF,
    //                                                                      PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0xa8, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // A9 iw                TEST AX, imm16        Valid        Valid        AND imm16 with AX; set SF,
    //                                                                      ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0xa9, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // A9 id                TEST EAX, imm32       Valid        Valid        AND imm32 with EAX; set SF,
    //                                                                      ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0xa9, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // REX.W + A9 id        TEST RAX, imm32       Valid        N.E.         AND imm32 sign-extended to
    //                                                                      64-bits with RAX; set SF, ZF,
    //                                                                      PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x02, 0xa9, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // F6 /0 ib             TEST r/m8, imm8       Valid        Valid        AND imm8 with r/m8; set SF,
    //                                                                      ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0xf6, od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // REX + F6 /0 ib       TEST r/m8*, imm8      Valid        N.E.         AND imm8 with r/m8; set SF,
    //                                                                      ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x02, 0xf6, od_rex|od_e0|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // F7 /0 iw             TEST r/m16,           Valid        Valid        AND imm16 with r/m16; set
    //                      imm16                                           SF, ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0xf7, od_e0|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // F7 /0 id             TEST r/m32,           Valid        Valid        AND imm32 with r/m32; set
    //                      imm32                                           SF, ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0xf7, od_e0|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // REX.W + F7 /0 id     TEST r/m64,           Valid        N.E.         AND imm32 sign-extended to
    //                      imm32                                           64-bits with r/m64; set SF, ZF,
    //                                                                      PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x02, 0xf7, od_rexw|od_e0|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // 84 /r                TEST r/m8, r8         Valid        Valid        AND r8 with r/m8; set SF, ZF,
    //                                                                      PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0x84, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // REX + 84 /r          TEST r/m8*, r8*       Valid        N.E.         AND r8 with r/m8; set SF, ZF,
    //                                                                      PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x02, 0x84, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // 85 /r                TEST r/m16, r16       Valid        Valid        AND r16 with r/m16; set SF,
    //                                                                      ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0x85, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // 85 /r                TEST r/m32, r32       Valid        Valid        AND r32 with r/m32; set SF,
    //                                                                      ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x03, 0x85, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-472");
    define(defn);
    // REX.W + 85 /r        TEST r/m64, r64       Valid        N.E.         AND r64 with r/m64; set SF,
    //                                                                      ZF, PF according to result.
    defn = new InsnDefn("test",   x86_test,    0x02, 0x85, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-475");
    define(defn);

    //--- page 4-475 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 2E /r    UCOMISD xmm1,        Valid       Valid          Compares (unordered) the low double-
    //                 xmm2/m64                                        precision floating-point values in
    //                                                                 xmm1 and xmm2/m64 and set the
    //                                                                 EFLAGS accordingly.
    defn = new InsnDefn("ucomisd", x86_ucomisd, 0x03, 0x660f2e, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-478");
    define(defn);

    //--- page 4-478 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 2E /r        UCOMISS xmm1,          Valid       Valid         Compare lower single-precision floating-
    //                 xmm2/m32                                         point value in xmm1 register with lower
    //                                                                  single-precision floating-point value in
    //                                                                  xmm2/mem and set the status flags
    //                                                                  accordingly.
    defn = new InsnDefn("ucomiss", x86_ucomiss, 0x03, 0x0f2e, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-481");
    define(defn);

    //--- page 4-481 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 0B           UD2               Valid         Valid        Raise invalid opcode exception.
    defn = new InsnDefn("ud2",    x86_ud2,     0x03, 0x0f0b, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-482");
    define(defn);

    //--- page 4-482 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 15 /r     UNPCKHPD xmm1,        Valid        Valid         Unpacks and Interleaves double-
    //                 xmm2/m128                                        precision floating-point values
    //                                                                  from high quadwords of xmm1
    //                                                                  and xmm2/m128.
    defn = new InsnDefn("unpckhpd", x86_unpckhpd, 0x03, 0x660f15, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-485");
    define(defn);

    //--- page 4-485 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 15 /r          UNPCKHPS xmm1,         Valid        Valid           Unpacks and Interleaves single-
    //                    xmm2/m128                                           precision floating-point values
    //                                                                        from high quadwords of xmm1
    //                                                                        and xmm2/mem into xmm1.
    defn = new InsnDefn("unpckhps", x86_unpckhps, 0x03, 0x0f15, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-488");
    define(defn);

    //--- page 4-488 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 14 /r     UNPCKLPD xmm1,        Valid       Valid        Unpacks and Interleaves double-
    //                 xmm2/m128                                      precision floating-point values from
    //                                                                low quadwords of xmm1 and
    //                                                                xmm2/m128.
    defn = new InsnDefn("unpcklpd", x86_unpcklpd, 0x03, 0x660f14, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-491");
    define(defn);

    //--- page 4-491 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 14 /r     UNPCKLPS xmm1,          Valid         Valid        Unpacks and Interleaves single-
    //               xmm2/m128                                          precision floating-point values from
    //                                                                  low quadwords of xmm1 and
    //                                                                  xmm2/mem into xmm1.
    defn = new InsnDefn("unpcklps", x86_unpcklps, 0x03, 0x0f14, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-494");
    define(defn);

    //--- page 4-494 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 00 /4        VERR r/m16       Valid      Valid          Set ZF=1 if segment specified with
    //                                                            r/m16 can be read.
    defn = new InsnDefn("verr",   x86_verr,    0x03, 0x0f00, od_e4, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-494");
    define(defn);
    // 0F 00 /5        VERW r/m16       Valid      Valid          Set ZF=1 if segment specified with
    //                                                            r/m16 can be written.
    defn = new InsnDefn("verw",   x86_verw,    0x03, 0x0f00, od_e5, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-497");
    define(defn);

    //--- page 4-497 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  9B           WAIT           Valid        Valid       Check pending unmasked floating-
    //                                                       point exceptions.
    defn = new InsnDefn("wait",   x86_wait,    0x03, 0x9b, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-497");
    define(defn);
    //  9B           FWAIT          Valid        Valid       Check pending unmasked floating-
    //                                                       point exceptions.
    defn = new InsnDefn("fwait",  x86_fwait,   0x03, 0x9b, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-499");
    define(defn);

    //--- page 4-499 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 09             WBINVD          Valid    Valid       Write back and flush Internal caches;
    //                                                         initiate writing-back and flushing of
    //                                                         external caches.
    defn = new InsnDefn("wbinvd", x86_wbinvd,  0x03, 0x0f09, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-501");
    define(defn);

    //--- page 4-501 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 30               WRMSR          Valid    Valid      Write the value in EDX:EAX to MSR
    //                                                         specified by ECX.
    defn = new InsnDefn("wrmsr",  x86_wrmsr,   0x03, 0x0f30, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-503");
    define(defn);

    //--- page 4-503 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F C0 /r             XADD r/m8, r8       Valid          Valid          Exchange r8 and r/m8; load
    //                                                                         sum into r/m8.
    defn = new InsnDefn("xadd",   x86_xadd,    0x03, 0x0fc0, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-503");
    define(defn);
    //  REX + 0F C0 /r       XADD r/m8*, r8*     Valid          N.E.           Exchange r8 and r/m8; load
    //                                                                         sum into r/m8.
    defn = new InsnDefn("xadd",   x86_xadd,    0x02, 0x0fc0, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-503");
    define(defn);
    //  0F C1 /r             XADD r/m16, r16     Valid          Valid          Exchange r16 and r/m16;
    //                                                                         load sum into r/m16.
    defn = new InsnDefn("xadd",   x86_xadd,    0x03, 0x0fc1, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-503");
    define(defn);
    //  0F C1 /r             XADD r/m32, r32     Valid          Valid          Exchange r32 and r/m32;
    //                                                                         load sum into r/m32.
    defn = new InsnDefn("xadd",   x86_xadd,    0x03, 0x0fc1, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-503");
    define(defn);
    //  REX.W + 0F C1 /r     XADD r/m64, r64     Valid          N.E.           Exchange r64 and r/m64;
    //                                                                         load sum into r/m64.
    defn = new InsnDefn("xadd",   x86_xadd,    0x02, 0x0fc1, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);

    //--- page 4-506 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 90+rw             XCHG AX, r16           Valid       Valid        Exchange r16 with AX.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x90, od_rw, od_AX, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 90+rw             XCHG r16, AX           Valid       Valid        Exchange AX with r16.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x90, od_rw, od_r16, od_AX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 90+rd             XCHG EAX, r32          Valid       Valid        Exchange r32 with EAX.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x90, od_rd, od_EAX, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // REX.W + 90+rd     XCHG RAX, r64          Valid       N.E.         Exchange r64 with RAX.
    defn = new InsnDefn("xchg",   x86_xchg,    0x02, 0x90, od_rexw|od_rd, od_RAX, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 90+rd             XCHG r32, EAX          Valid       Valid        Exchange EAX with r32.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x90, od_rd, od_r32, od_EAX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // REX.W + 90+rd     XCHG r64, RAX          Valid       N.E.         Exchange RAX with r64.
    defn = new InsnDefn("xchg",   x86_xchg,    0x02, 0x90, od_rexw|od_rd, od_r64, od_RAX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 86 /r             XCHG r/m8, r8          Valid       Valid        Exchange r8 (byte register) with
    //                                                                   byte from r/m8.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x86, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // REX + 86 /r       XCHG r/m8*, r8*        Valid       N.E.         Exchange r8 (byte register) with
    //                                                                   byte from r/m8.
    defn = new InsnDefn("xchg",   x86_xchg,    0x02, 0x86, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 86 /r             XCHG r8, r/m8          Valid       Valid        Exchange byte from r/m8 with
    //                                                                   r8 (byte register).
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x86, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // REX + 86 /r       XCHG r8*, r/m8*        Valid       N.E.         Exchange byte from r/m8 with
    //                                                                   r8 (byte register).
    defn = new InsnDefn("xchg",   x86_xchg,    0x02, 0x86, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 87 /r             XCHG r/m16, r16        Valid       Valid        Exchange r16 with word from
    //                                                                   r/m16.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x87, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 87 /r             XCHG r16, r/m16        Valid       Valid        Exchange word from r/m16 with
    //                                                                   r16.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x87, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 87 /r             XCHG r/m32, r32        Valid       Valid        Exchange r32 with doubleword
    //                                                                   from r/m32.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x87, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // REX.W + 87 /r     XCHG r/m64, r64       Valid        N.E.         Exchange r64 with quadword
    //                                                                   from r/m64.
    defn = new InsnDefn("xchg",   x86_xchg,    0x02, 0x87, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // 87 /r             XCHG r32, r/m32        Valid       Valid        Exchange doubleword from
    //                                                                   r/m32 with r32.
    defn = new InsnDefn("xchg",   x86_xchg,    0x03, 0x87, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-506");
    define(defn);
    // REX.W + 87 /r     XCHG r64, r/m64       Valid        N.E.         Exchange quadword from r/m64
    //                                                                   with r64.
    defn = new InsnDefn("xchg",   x86_xchg,    0x02, 0x87, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-509");
    define(defn);

    //--- page 4-509 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 01 D0      XGETBV                 Valid      Valid            Reads an XCR specified by ECX
    //                                                                   into EDX:EAX.
    defn = new InsnDefn("xgetbv", x86_xgetbv,  0x03, 0x0f01d0, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-511");
    define(defn);

    //--- page 4-511 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  D7                XLAT m8        Valid       Valid      Set AL to memory byte DS:[(E)BX +
    //                                                          unsigned AL].
    defn = new InsnDefn("xlatb",  x86_xlatb,   0x03, 0xd7, od_none, od_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-511");
    define(defn);
    //  D7                XLATB          Valid       Valid      Set AL to memory byte DS:[(E)BX +
    //                                                          unsigned AL].
    defn = new InsnDefn("xlatb",  x86_xlatb,   0x03, 0xd7, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-511");
    define(defn);
    //  REX.W + D7        XLATB          Valid       N.E.       Set AL to memory byte [RBX +
    //                                                          unsigned AL].
    defn = new InsnDefn("xlatb",  x86_xlatb,   0x02, 0xd7, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);

    //--- page 4-513 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  34 ib                 XOR AL, imm8          Valid        Valid         AL XOR imm8.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x34, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  35 iw                 XOR AX, imm16         Valid        Valid         AX XOR imm16.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x35, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  35 id                 XOR EAX, imm32        Valid        Valid         EAX XOR imm32.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x35, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX.W + 35 id         XOR RAX, imm32        Valid        N.E.          RAX XOR imm32 (sign-
    //                                                                         extended).
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x35, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  80 /6 ib              XOR r/m8, imm8        Valid        Valid         r/m8 XOR imm8.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x80, od_e6|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX + 80 /6 ib        XOR r/m8*, imm8       Valid        N.E.          r/m8 XOR imm8.
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x80, od_rex|od_e6|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  81 /6 iw              XOR r/m16, imm16      Valid        Valid         r/m16 XOR imm16.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x81, od_e6|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  81 /6 id              XOR r/m32, imm32      Valid        Valid         r/m32 XOR imm32.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x81, od_e6|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX.W + 81 /6 id      XOR r/m64, imm32      Valid        N.E.          r/m64 XOR imm32 (sign-
    //                                                                         extended).
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x81, od_rexw|od_e6|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  83 /6 ib              XOR r/m16, imm8       Valid        Valid         r/m16 XOR imm8 (sign-
    //                                                                         extended).
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x83, od_e6|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  83 /6 ib              XOR r/m32, imm8       Valid        Valid         r/m32 XOR imm8 (sign-
    //                                                                         extended).
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x83, od_e6|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX.W + 83 /6 ib      XOR r/m64, imm8       Valid        N.E.          r/m64 XOR imm8 (sign-
    //                                                                         extended).
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x83, od_rexw|od_e6|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  30 /r                 XOR r/m8, r8          Valid        Valid         r/m8 XOR r8.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x30, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX + 30 /r           XOR r/m8*, r8*        Valid        N.E.          r/m8 XOR r8.
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x30, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  31 /r                 XOR r/m16, r16        Valid        Valid         r/m16 XOR r16.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x31, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  31 /r                 XOR r/m32, r32        Valid        Valid         r/m32 XOR r32.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x31, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX.W + 31 /r         XOR r/m64, r64        Valid        N.E.          r/m64 XOR r64.
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x31, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  32 /r                 XOR r8, r/m8          Valid        Valid         r8 XOR r/m8.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x32, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX + 32 /r           XOR r8*, r/m8*        Valid        N.E.          r8 XOR r/m8.
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x32, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  33 /r                 XOR r16, r/m16        Valid        Valid         r16 XOR r/m16.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x33, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  33 /r                 XOR r32, r/m32        Valid        Valid         r32 XOR r/m32.
    defn = new InsnDefn("xor",    x86_xor,     0x03, 0x33, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-513");
    define(defn);
    //  REX.W + 33 /r         XOR r64, r/m64        Valid        N.E.          r64 XOR r/m64.
    defn = new InsnDefn("xor",    x86_xor,     0x02, 0x33, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-516");
    define(defn);

    //--- page 4-516 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 57 /r     XORPD xmm1, xmm2/m128       Valid       Valid           Bitwise exclusive-OR of
    //                                                                         xmm2/m128 and xmm1.
    defn = new InsnDefn("xorpd",  x86_xorpd,   0x03, 0x660f57, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-518");
    define(defn);

    //--- page 4-518 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 57 /r        XORPS xmm1, xmm2/m128 Valid            Valid           Bitwise exclusive-OR of
    //                                                                        xmm2/m128 and xmm1.
    defn = new InsnDefn("xorps",  x86_xorps,   0x03, 0x0f57, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-520");
    define(defn);

    //--- page 4-520 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //     0F AE /5      XRSTOR mem         Valid          Valid           Restore processor extended
    //                                                                     states from memory. The
    //                                                                     states are specified by
    //                                                                     EDX:EAX
    defn = new InsnDefn("xrstor", x86_xrstor,  0x03, 0x0fae, od_e5, od_m);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-525");
    define(defn);

    //--- page 4-525 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F AE /4      XSAVE mem               Valid    Valid        Save processor extended
    //                                                              states to memory. The states
    //                                                              are specified by EDX:EAX
    defn = new InsnDefn("xsave",  x86_xsave,   0x03, 0x0fae, od_e4, od_m);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-529");
    define(defn);

    //--- page 4-529 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 01 D1      XSETBV                  Valid      Valid             Write the value in EDX:EAX to
    //                                                                     the XCR specified by ECX.
    defn = new InsnDefn("xsetbv", x86_xsetbv,  0x03, 0x0f01d1, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-4");
    define(defn);

    //--- page 5-4 of x86-InstructionSetReference-NZ.pdf ---------------------------------------------------------------
    // 66 0F 38 80      INVEPT r64, m128        Invalidates EPT-derived entries in the TLBs and
    //                                          paging-structure caches (in 64-bit mode)
    defn = new InsnDefn("invept", x86_invept,  0x02, 0x660f3880, od_none, od_r64, od_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-4");
    define(defn);
    // 66 0F 38 80      INVEPT r32, m128        Invalidates EPT-derived entries in the TLBs and
    //                                          paging-structure caches (outside 64-bit mode)
    defn = new InsnDefn("invept", x86_invept,  0x02, 0x660f3880, od_none, od_r32, od_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-7");
    define(defn);

    //--- page 5-7 of x86-InstructionSetReference-NZ.pdf ---------------------------------------------------------------
    //  66 0F 38 81         INVVPID r64, m128           Invalidates entries in the TLBs and paging-structure
    //                                                  caches based on VPID (in 64-bit mode)
    defn = new InsnDefn("invvpid", x86_invvpid, 0x02, 0x660f3881, od_none, od_r64, od_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-7");
    define(defn);
    //  66 0F 38 81         INVVPID r32, m128           Invalidates entries in the TLBs and paging-structure
    //                                                  caches based on VPID (outside 64-bit mode)
    defn = new InsnDefn("invvpid", x86_invvpid, 0x02, 0x660f3881, od_none, od_r32, od_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-11");
    define(defn);

    //--- page 5-11 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 01 C1           VMCALL          Call to VM monitor by causing VM exit.
    defn = new InsnDefn("vmcall", x86_vmcall,  0x02, 0x0f01c1, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-13");
    define(defn);

    //--- page 5-13 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  66 0F C7 /6         VMCLEAR m64           Copy VMCS data to VMCS region in memory.
    defn = new InsnDefn("vmclear", x86_vmclear, 0x02, 0x660fc7, od_e6, od_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-16");
    define(defn);

    //--- page 5-16 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F 01 C2           VMLAUNCH        Launch virtual machine managed by current VMCS.
    defn = new InsnDefn("vmlaunch", x86_vmlaunch, 0x02, 0x0f01c2, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-16");
    define(defn);
    // 0F 01 C3           VMRESUME        Resume virtual machine managed by current VMCS.
    defn = new InsnDefn("vmresume", x86_vmresume, 0x02, 0x0f01c3, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-19");
    define(defn);

    //--- page 5-19 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F C7 /6            VMPTRLD m64            Loads the current VMCS pointer from memory.
    defn = new InsnDefn("vmptrld", x86_vmptrld, 0x02, 0x0fc7, od_e6, od_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-22");
    define(defn);

    //--- page 5-22 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F C7 /7            VMPTRST m64      Stores the current VMCS pointer into memory.
    defn = new InsnDefn("vmptrst", x86_vmptrst, 0x02, 0x0fc7, od_e7, od_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-24");
    define(defn);

    //--- page 5-24 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    // 0F 78             VMREAD r/m64, r64      Reads a specified VMCS field (in 64-bit mode).
    defn = new InsnDefn("vmread", x86_vmread,  0x02, 0x0f78, od_none, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-24");
    define(defn);
    // 0F 78             VMREAD r/m32, r32       Reads a specified VMCS field (outside 64-bit mode).
    defn = new InsnDefn("vmread", x86_vmread,  0x02, 0x0f78, od_none, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-27");
    define(defn);

    //--- page 5-27 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 79               VMWRITE r64, r/m64           Writes a specified VMCS field (in 64-bit mode)
    defn = new InsnDefn("vmwrite", x86_vmwrite, 0x02, 0x0f79, od_none, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-27");
    define(defn);
    //  0F 79               VMWRITE r32, r/m32           Writes a specified VMCS field (outside 64-bit mode)
    defn = new InsnDefn("vmwrite", x86_vmwrite, 0x02, 0x0f79, od_none, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-29");
    define(defn);

    //--- page 5-29 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  0F 01 C4           VMXOFF          Leaves VMX operation.
    defn = new InsnDefn("vmxoff", x86_vmxoff,  0x02, 0x0f01c4, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-31");
    define(defn);

    //--- page 5-31 of x86-InstructionSetReference-NZ.pdf --------------------------------------------------------------
    //  F3 0F C7 /6        VMXON m64                  Enter VMX root operation.
    defn = new InsnDefn("vmxon",  x86_vmxon,   0x02, 0xf30fc7, od_e6, od_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 5-37");
    define(defn);

    //------------------------------------------------------------------------------------------------------------------
    // The following definitions are from ExtraInstructions.txt, modified 10 Aug 2010
    //------------------------------------------------------------------------------------------------------------------


    //--- page 1 of ExtraInstructions.txt ------------------------------------------------------------------------------
    // 0F 01 C4                 VMOFF              Valid Invalid  VMX Instruction; ModR/M=0304 (0xc4)
    defn = new InsnDefn("vmoff",  x86_vmoff,   0x02, 0x0f01c4, od_none);
    defn->set_location("ExtraInstructions.txt, page 1");
    define(defn);
    // 0F 01 D8                 VMRUN              Valid Invalid  VMX Instruction; ModR/M=0330 (0xd8)
    defn = new InsnDefn("vmrun",  x86_vmrun,   0x02, 0x0f01d8, od_none);
    defn->set_location("ExtraInstructions.txt, page 1");
    define(defn);
    // 0F 01 D9                 VMMCALL            Valid Invalid  VMX Instruction; ModR/M=0331 (0xd9)
    defn = new InsnDefn("vmmcall", x86_vmmcall, 0x02, 0x0f01d9, od_none);
    defn->set_location("ExtraInstructions.txt, page 1");
    define(defn);
    // 0F 01 DA                 VMLOAD             Valid Invalid  VMX Instruction; ModR/M=0332 (0xda)
    defn = new InsnDefn("vmload", x86_vmload,  0x02, 0x0f01da, od_none);
    defn->set_location("ExtraInstructions.txt, page 1");
    define(defn);
    // 0F 01 DB                 VMSAVE             Valid Invalid  VMX Instruction; ModR/M=0333 (0xdb)
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
