//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules() {
    AssemblerX86::initAssemblyRules_part1();
    AssemblerX86::initAssemblyRules_part2();
    AssemblerX86::initAssemblyRules_part3();
    AssemblerX86::initAssemblyRules_part4();
    AssemblerX86::initAssemblyRules_part5();
    AssemblerX86::initAssemblyRules_part6();
    AssemblerX86::initAssemblyRules_part7();
    AssemblerX86::initAssemblyRules_part8();
    AssemblerX86::initAssemblyRules_part9();
}

std::string
AssemblerX86::to_str(X86InstructionKind kind)
{
    switch (kind) {
        case x86_aaa:             return "aaa";             break;
        case x86_aad:             return "aad";             break;
        case x86_aam:             return "aam";             break;
        case x86_aas:             return "aas";             break;
        case x86_adc:             return "adc";             break;
        case x86_add:             return "add";             break;
        case x86_addpd:           return "addpd";           break;
        case x86_addps:           return "addps";           break;
        case x86_addsd:           return "addsd";           break;
        case x86_addss:           return "addss";           break;
        case x86_addsubpd:        return "addsubpd";        break;
        case x86_addsubps:        return "addsubps";        break;
        case x86_and:             return "and";             break;
        case x86_andnpd:          return "andnpd";          break;
        case x86_andnps:          return "andnps";          break;
        case x86_andpd:           return "andpd";           break;
        case x86_andps:           return "andps";           break;
        case x86_arpl:            return "arpl";            break;
        case x86_blendpd:         return "blendpd";         break;
        case x86_blendps:         return "blendps";         break;
        case x86_blendvpd:        return "blendvpd";        break;
        case x86_blendvps:        return "blendvps";        break;
        case x86_bound:           return "bound";           break;
        case x86_bsf:             return "bsf";             break;
        case x86_bsr:             return "bsr";             break;
        case x86_bswap:           return "bswap";           break;
        case x86_bt:              return "bt";              break;
        case x86_btc:             return "btc";             break;
        case x86_btr:             return "btr";             break;
        case x86_bts:             return "bts";             break;
        case x86_call:            return "call";            break;
        case x86_cbw:             return "cbw";             break;
        case x86_cdq:             return "cdq";             break;
        case x86_cdqe:            return "cdqe";            break;
        case x86_clc:             return "clc";             break;
        case x86_cld:             return "cld";             break;
        case x86_clflush:         return "clflush";         break;
        case x86_clgi:            return "clgi";            break;
        case x86_cli:             return "cli";             break;
        case x86_clts:            return "clts";            break;
        case x86_cmc:             return "cmc";             break;
        case x86_cmova:           return "cmova";           break;
        case x86_cmovae:          return "cmovae";          break;
        case x86_cmovb:           return "cmovb";           break;
        case x86_cmovbe:          return "cmovbe";          break;
        case x86_cmove:           return "cmove";           break;
        case x86_cmovg:           return "cmovg";           break;
        case x86_cmovge:          return "cmovge";          break;
        case x86_cmovl:           return "cmovl";           break;
        case x86_cmovle:          return "cmovle";          break;
        case x86_cmovne:          return "cmovne";          break;
        case x86_cmovno:          return "cmovno";          break;
        case x86_cmovns:          return "cmovns";          break;
        case x86_cmovo:           return "cmovo";           break;
        case x86_cmovpe:          return "cmovpe";          break;
        case x86_cmovpo:          return "cmovpo";          break;
        case x86_cmovs:           return "cmovs";           break;
        case x86_cmp:             return "cmp";             break;
        case x86_cmppd:           return "cmppd";           break;
        case x86_cmpps:           return "cmpps";           break;
        case x86_cmpsb:           return "cmpsb";           break;
        case x86_cmpsd:           return "cmpsd";           break;
        case x86_cmpsq:           return "cmpsq";           break;
        case x86_cmpss:           return "cmpss";           break;
        case x86_cmpsw:           return "cmpsw";           break;
        case x86_cmpxchg:         return "cmpxchg";         break;
        case x86_cmpxchg16b:      return "cmpxchg16b";      break;
        case x86_cmpxchg8b:       return "cmpxchg8b";       break;
        case x86_comisd:          return "comisd";          break;
        case x86_comiss:          return "comiss";          break;
        case x86_cpuid:           return "cpuid";           break;
        case x86_cqo:             return "cqo";             break;
        case x86_crc32:           return "crc32";           break;
        case x86_cvtdq2pd:        return "cvtdq2pd";        break;
        case x86_cvtdq2ps:        return "cvtdq2ps";        break;
        case x86_cvtpd2dq:        return "cvtpd2dq";        break;
        case x86_cvtpd2pi:        return "cvtpd2pi";        break;
        case x86_cvtpd2ps:        return "cvtpd2ps";        break;
        case x86_cvtpi2pd:        return "cvtpi2pd";        break;
        case x86_cvtpi2ps:        return "cvtpi2ps";        break;
        case x86_cvtps2dq:        return "cvtps2dq";        break;
        case x86_cvtps2pd:        return "cvtps2pd";        break;
        case x86_cvtps2pi:        return "cvtps2pi";        break;
        case x86_cvtsd2si:        return "cvtsd2si";        break;
        case x86_cvtsd2ss:        return "cvtsd2ss";        break;
        case x86_cvtsi2sd:        return "cvtsi2sd";        break;
        case x86_cvtsi2ss:        return "cvtsi2ss";        break;
        case x86_cvtss2sd:        return "cvtss2sd";        break;
        case x86_cvtss2si:        return "cvtss2si";        break;
        case x86_cvttpd2dq:       return "cvttpd2dq";       break;
        case x86_cvttpd2pi:       return "cvttpd2pi";       break;
        case x86_cvttps2dq:       return "cvttps2dq";       break;
        case x86_cvttps2pi:       return "cvttps2pi";       break;
        case x86_cvttsd2si:       return "cvttsd2si";       break;
        case x86_cvttss2si:       return "cvttss2si";       break;
        case x86_cwd:             return "cwd";             break;
        case x86_cwde:            return "cwde";            break;
        case x86_daa:             return "daa";             break;
        case x86_das:             return "das";             break;
        case x86_dec:             return "dec";             break;
        case x86_div:             return "div";             break;
        case x86_divpd:           return "divpd";           break;
        case x86_divps:           return "divps";           break;
        case x86_divsd:           return "divsd";           break;
        case x86_divss:           return "divss";           break;
        case x86_dppd:            return "dppd";            break;
        case x86_dpps:            return "dpps";            break;
        case x86_emms:            return "emms";            break;
        case x86_enter:           return "enter";           break;
        case x86_extractps:       return "extractps";       break;
        case x86_extrq:           return "extrq";           break;
        case x86_f2xm1:           return "f2xm1";           break;
        case x86_fabs:            return "fabs";            break;
        case x86_fadd:            return "fadd";            break;
        case x86_faddp:           return "faddp";           break;
        case x86_farcall:         return "farcall";         break;
        case x86_farjmp:          return "farjmp";          break;
        case x86_fbld:            return "fbld";            break;
        case x86_fbstp:           return "fbstp";           break;
        case x86_fchs:            return "fchs";            break;
        case x86_fcmovb:          return "fcmovb";          break;
        case x86_fcmovbe:         return "fcmovbe";         break;
        case x86_fcmove:          return "fcmove";          break;
        case x86_fcmovnb:         return "fcmovnb";         break;
        case x86_fcmovnbe:        return "fcmovnbe";        break;
        case x86_fcmovne:         return "fcmovne";         break;
        case x86_fcmovnu:         return "fcmovnu";         break;
        case x86_fcmovu:          return "fcmovu";          break;
        case x86_fcom:            return "fcom";            break;
        case x86_fcomi:           return "fcomi";           break;
        case x86_fcomip:          return "fcomip";          break;
        case x86_fcomp:           return "fcomp";           break;
        case x86_fcompp:          return "fcompp";          break;
        case x86_fcos:            return "fcos";            break;
        case x86_fdecstp:         return "fdecstp";         break;
        case x86_fdiv:            return "fdiv";            break;
        case x86_fdivp:           return "fdivp";           break;
        case x86_fdivr:           return "fdivr";           break;
        case x86_fdivrp:          return "fdivrp";          break;
        case x86_femms:           return "femms";           break;
        case x86_ffree:           return "ffree";           break;
        case x86_fiadd:           return "fiadd";           break;
        case x86_ficom:           return "ficom";           break;
        case x86_ficomp:          return "ficomp";          break;
        case x86_fidiv:           return "fidiv";           break;
        case x86_fidivr:          return "fidivr";          break;
        case x86_fild:            return "fild";            break;
        case x86_fimul:           return "fimul";           break;
        case x86_fincstp:         return "fincstp";         break;
        case x86_fist:            return "fist";            break;
        case x86_fistp:           return "fistp";           break;
        case x86_fisttp:          return "fisttp";          break;
        case x86_fisub:           return "fisub";           break;
        case x86_fisubr:          return "fisubr";          break;
        case x86_fld:             return "fld";             break;
        case x86_fld1:            return "fld1";            break;
        case x86_fldcw:           return "fldcw";           break;
        case x86_fldenv:          return "fldenv";          break;
        case x86_fldl2e:          return "fldl2e";          break;
        case x86_fldl2t:          return "fldl2t";          break;
        case x86_fldlg2:          return "fldlg2";          break;
        case x86_fldln2:          return "fldln2";          break;
        case x86_fldpi:           return "fldpi";           break;
        case x86_fldz:            return "fldz";            break;
        case x86_fmul:            return "fmul";            break;
        case x86_fmulp:           return "fmulp";           break;
        case x86_fnclex:          return "fnclex";          break;
        case x86_fninit:          return "fninit";          break;
        case x86_fnop:            return "fnop";            break;
        case x86_fnsave:          return "fnsave";          break;
        case x86_fnstcw:          return "fnstcw";          break;
        case x86_fnstenv:         return "fnstenv";         break;
        case x86_fnstsw:          return "fnstsw";          break;
        case x86_fpatan:          return "fpatan";          break;
        case x86_fprem:           return "fprem";           break;
        case x86_fprem1:          return "fprem1";          break;
        case x86_fptan:           return "fptan";           break;
        case x86_frndint:         return "frndint";         break;
        case x86_frstor:          return "frstor";          break;
        case x86_fscale:          return "fscale";          break;
        case x86_fsin:            return "fsin";            break;
        case x86_fsincos:         return "fsincos";         break;
        case x86_fsqrt:           return "fsqrt";           break;
        case x86_fst:             return "fst";             break;
        case x86_fstp:            return "fstp";            break;
        case x86_fsub:            return "fsub";            break;
        case x86_fsubp:           return "fsubp";           break;
        case x86_fsubr:           return "fsubr";           break;
        case x86_fsubrp:          return "fsubrp";          break;
        case x86_ftst:            return "ftst";            break;
        case x86_fucom:           return "fucom";           break;
        case x86_fucomi:          return "fucomi";          break;
        case x86_fucomip:         return "fucomip";         break;
        case x86_fucomp:          return "fucomp";          break;
        case x86_fucompp:         return "fucompp";         break;
        case x86_fwait:           return "fwait";           break;
        case x86_fxam:            return "fxam";            break;
        case x86_fxch:            return "fxch";            break;
        case x86_fxrstor:         return "fxrstor";         break;
        case x86_fxsave:          return "fxsave";          break;
        case x86_fxtract:         return "fxtract";         break;
        case x86_fyl2x:           return "fyl2x";           break;
        case x86_fyl2xp1:         return "fyl2xp1";         break;
        case x86_getsec:          return "getsec";          break;
        case x86_haddpd:          return "haddpd";          break;
        case x86_haddps:          return "haddps";          break;
        case x86_hlt:             return "hlt";             break;
        case x86_hsubpd:          return "hsubpd";          break;
        case x86_hsubps:          return "hsubps";          break;
        case x86_idiv:            return "idiv";            break;
        case x86_imul:            return "imul";            break;
        case x86_in:              return "in";              break;
        case x86_inc:             return "inc";             break;
        case x86_insb:            return "insb";            break;
        case x86_insd:            return "insd";            break;
        case x86_insertps:        return "insertps";        break;
        case x86_insertq:         return "insertq";         break;
        case x86_insw:            return "insw";            break;
        case x86_int:             return "int";             break;
        case x86_int1:            return "int1";            break;
        case x86_int3:            return "int3";            break;
        case x86_into:            return "into";            break;
        case x86_invd:            return "invd";            break;
        case x86_invept:          return "invept";          break;
        case x86_invlpg:          return "invlpg";          break;
        case x86_invlpga:         return "invlpga";         break;
        case x86_invvpid:         return "invvpid";         break;
        case x86_iret:            return "iret";            break;
        case x86_ja:              return "ja";              break;
        case x86_jae:             return "jae";             break;
        case x86_jb:              return "jb";              break;
        case x86_jbe:             return "jbe";             break;
        case x86_jcxz:            return "jcxz";            break;
        case x86_je:              return "je";              break;
        case x86_jecxz:           return "jecxz";           break;
        case x86_jg:              return "jg";              break;
        case x86_jge:             return "jge";             break;
        case x86_jl:              return "jl";              break;
        case x86_jle:             return "jle";             break;
        case x86_jmp:             return "jmp";             break;
        case x86_jmpe:            return "jmpe";            break;
        case x86_jne:             return "jne";             break;
        case x86_jno:             return "jno";             break;
        case x86_jns:             return "jns";             break;
        case x86_jo:              return "jo";              break;
        case x86_jpe:             return "jpe";             break;
        case x86_jpo:             return "jpo";             break;
        case x86_jrcxz:           return "jrcxz";           break;
        case x86_js:              return "js";              break;
        case x86_lahf:            return "lahf";            break;
        case x86_lar:             return "lar";             break;
        case x86_lddqu:           return "lddqu";           break;
        case x86_ldmxcsr:         return "ldmxcsr";         break;
        case x86_lds:             return "lds";             break;
        case x86_lea:             return "lea";             break;
        case x86_leave:           return "leave";           break;
        case x86_les:             return "les";             break;
        case x86_lfence:          return "lfence";          break;
        case x86_lfs:             return "lfs";             break;
        case x86_lgdt:            return "lgdt";            break;
        case x86_lgs:             return "lgs";             break;
        case x86_lidt:            return "lidt";            break;
        case x86_lldt:            return "lldt";            break;
        case x86_lmsw:            return "lmsw";            break;
        case x86_lock:            return "lock";            break;
        case x86_lodsb:           return "lodsb";           break;
        case x86_lodsd:           return "lodsd";           break;
        case x86_lodsq:           return "lodsq";           break;
        case x86_lodsw:           return "lodsw";           break;
        case x86_loop:            return "loop";            break;
        case x86_loopnz:          return "loopnz";          break;
        case x86_loopz:           return "loopz";           break;
        case x86_lsl:             return "lsl";             break;
        case x86_lss:             return "lss";             break;
        case x86_ltr:             return "ltr";             break;
        case x86_lzcnt:           return "lzcnt";           break;
        case x86_maskmovq:        return "maskmovq";        break;
        case x86_maxpd:           return "maxpd";           break;
        case x86_maxps:           return "maxps";           break;
        case x86_maxsd:           return "maxsd";           break;
        case x86_maxss:           return "maxss";           break;
        case x86_mfence:          return "mfence";          break;
        case x86_minpd:           return "minpd";           break;
        case x86_minps:           return "minps";           break;
        case x86_minsd:           return "minsd";           break;
        case x86_minss:           return "minss";           break;
        case x86_monitor:         return "monitor";         break;
        case x86_mov:             return "mov";             break;
        case x86_movapd:          return "movapd";          break;
        case x86_movaps:          return "movaps";          break;
        case x86_movbe:           return "movbe";           break;
        case x86_movd:            return "movd";            break;
        case x86_movddup:         return "movddup";         break;
        case x86_movdq2q:         return "movdq2q";         break;
        case x86_movdqa:          return "movdqa";          break;
        case x86_movdqu:          return "movdqu";          break;
        case x86_movhlps:         return "movhlps";         break;
        case x86_movhpd:          return "movhpd";          break;
        case x86_movhps:          return "movhps";          break;
        case x86_movlhps:         return "movlhps";         break;
        case x86_movlpd:          return "movlpd";          break;
        case x86_movlps:          return "movlps";          break;
        case x86_movmskpd:        return "movmskpd";        break;
        case x86_movmskps:        return "movmskps";        break;
        case x86_movntdq:         return "movntdq";         break;
        case x86_movntdqa:        return "movntdqa";        break;
        case x86_movnti:          return "movnti";          break;
        case x86_movntpd:         return "movntpd";         break;
        case x86_movntps:         return "movntps";         break;
        case x86_movntq:          return "movntq";          break;
        case x86_movntsd:         return "movntsd";         break;
        case x86_movntss:         return "movntss";         break;
        case x86_movq:            return "movq";            break;
        case x86_movq2dq:         return "movq2dq";         break;
        case x86_movsb:           return "movsb";           break;
        case x86_movsd:           return "movsd";           break;
        case x86_movsd_sse:       return "movsd_sse";       break;
        case x86_movshdup:        return "movshdup";        break;
        case x86_movsldup:        return "movsldup";        break;
        case x86_movsq:           return "movsq";           break;
        case x86_movss:           return "movss";           break;
        case x86_movsw:           return "movsw";           break;
        case x86_movsx:           return "movsx";           break;
        case x86_movsxd:          return "movsxd";          break;
        case x86_movupd:          return "movupd";          break;
        case x86_movups:          return "movups";          break;
        case x86_movzx:           return "movzx";           break;
        case x86_mpsadbw:         return "mpsadbw";         break;
        case x86_mul:             return "mul";             break;
        case x86_mulpd:           return "mulpd";           break;
        case x86_mulps:           return "mulps";           break;
        case x86_mulsd:           return "mulsd";           break;
        case x86_mulss:           return "mulss";           break;
        case x86_mwait:           return "mwait";           break;
        case x86_neg:             return "neg";             break;
        case x86_nop:             return "nop";             break;
        case x86_not:             return "not";             break;
        case x86_or:              return "or";              break;
        case x86_orpd:            return "orpd";            break;
        case x86_orps:            return "orps";            break;
        case x86_out:             return "out";             break;
        case x86_outs:            return "outs";            break;
        case x86_outsb:           return "outsb";           break;
        case x86_outsd:           return "outsd";           break;
        case x86_outsw:           return "outsw";           break;
        case x86_pabsb:           return "pabsb";           break;
        case x86_pabsd:           return "pabsd";           break;
        case x86_pabsw:           return "pabsw";           break;
        case x86_packssdw:        return "packssdw";        break;
        case x86_packsswb:        return "packsswb";        break;
        case x86_packusdw:        return "packusdw";        break;
        case x86_packuswb:        return "packuswb";        break;
        case x86_paddb:           return "paddb";           break;
        case x86_paddd:           return "paddd";           break;
        case x86_paddq:           return "paddq";           break;
        case x86_paddsb:          return "paddsb";          break;
        case x86_paddsw:          return "paddsw";          break;
        case x86_paddusb:         return "paddusb";         break;
        case x86_paddusw:         return "paddusw";         break;
        case x86_paddw:           return "paddw";           break;
        case x86_palignr:         return "palignr";         break;
        case x86_pand:            return "pand";            break;
        case x86_pandn:           return "pandn";           break;
        case x86_pause:           return "pause";           break;
        case x86_pavgb:           return "pavgb";           break;
        case x86_pavgusb:         return "pavgusb";         break;
        case x86_pavgw:           return "pavgw";           break;
        case x86_pblendvb:        return "pblendvb";        break;
        case x86_pblendw:         return "pblendw";         break;
        case x86_pcmpeqb:         return "pcmpeqb";         break;
        case x86_pcmpeqd:         return "pcmpeqd";         break;
        case x86_pcmpeqq:         return "pcmpeqq";         break;
        case x86_pcmpeqw:         return "pcmpeqw";         break;
        case x86_pcmpestri:       return "pcmpestri";       break;
        case x86_pcmpestrm:       return "pcmpestrm";       break;
        case x86_pcmpgtb:         return "pcmpgtb";         break;
        case x86_pcmpgtd:         return "pcmpgtd";         break;
        case x86_pcmpgtq:         return "pcmpgtq";         break;
        case x86_pcmpgtw:         return "pcmpgtw";         break;
        case x86_pcmpistri:       return "pcmpistri";       break;
        case x86_pcmpistrm:       return "pcmpistrm";       break;
        case x86_pextrb:          return "pextrb";          break;
        case x86_pextrd:          return "pextrd";          break;
        case x86_pextrq:          return "pextrq";          break;
        case x86_pextrw:          return "pextrw";          break;
        case x86_pf2id:           return "pf2id";           break;
        case x86_pf2iw:           return "pf2iw";           break;
        case x86_pfacc:           return "pfacc";           break;
        case x86_pfadd:           return "pfadd";           break;
        case x86_pfcmpeq:         return "pfcmpeq";         break;
        case x86_pfcmpge:         return "pfcmpge";         break;
        case x86_pfcmpgt:         return "pfcmpgt";         break;
        case x86_pfmax:           return "pfmax";           break;
        case x86_pfmin:           return "pfmin";           break;
        case x86_pfmul:           return "pfmul";           break;
        case x86_pfnacc:          return "pfnacc";          break;
        case x86_pfpnacc:         return "pfpnacc";         break;
        case x86_pfrcp:           return "pfrcp";           break;
        case x86_pfrcpit1:        return "pfrcpit1";        break;
        case x86_pfrcpit2:        return "pfrcpit2";        break;
        case x86_pfrsqit1:        return "pfrsqit1";        break;
        case x86_pfrsqrt:         return "pfrsqrt";         break;
        case x86_pfsub:           return "pfsub";           break;
        case x86_pfsubr:          return "pfsubr";          break;
        case x86_phaddd:          return "phaddd";          break;
        case x86_phaddsw:         return "phaddsw";         break;
        case x86_phaddw:          return "phaddw";          break;
        case x86_phminposuw:      return "phminposuw";      break;
        case x86_phsubd:          return "phsubd";          break;
        case x86_phsubsw:         return "phsubsw";         break;
        case x86_phsubw:          return "phsubw";          break;
        case x86_pi2fd:           return "pi2fd";           break;
        case x86_pi2fw:           return "pi2fw";           break;
        case x86_pinsrb:          return "pinsrb";          break;
        case x86_pinsrd:          return "pinsrd";          break;
        case x86_pinsrq:          return "pinsrq";          break;
        case x86_pinsrw:          return "pinsrw";          break;
        case x86_pmaddubsw:       return "pmaddubsw";       break;
        case x86_pmaddwd:         return "pmaddwd";         break;
        case x86_pmaxsb:          return "pmaxsb";          break;
        case x86_pmaxsd:          return "pmaxsd";          break;
        case x86_pmaxsw:          return "pmaxsw";          break;
        case x86_pmaxub:          return "pmaxub";          break;
        case x86_pmaxud:          return "pmaxud";          break;
        case x86_pmaxuw:          return "pmaxuw";          break;
        case x86_pminsb:          return "pminsb";          break;
        case x86_pminsd:          return "pminsd";          break;
        case x86_pminsw:          return "pminsw";          break;
        case x86_pminub:          return "pminub";          break;
        case x86_pminud:          return "pminud";          break;
        case x86_pminuw:          return "pminuw";          break;
        case x86_pmovmskb:        return "pmovmskb";        break;
        case x86_pmovsxbd:        return "pmovsxbd";        break;
        case x86_pmovsxbq:        return "pmovsxbq";        break;
        case x86_pmovsxbw:        return "pmovsxbw";        break;
        case x86_pmovsxdq:        return "pmovsxdq";        break;
        case x86_pmovsxwd:        return "pmovsxwd";        break;
        case x86_pmovsxwq:        return "pmovsxwq";        break;
        case x86_pmovzxbd:        return "pmovzxbd";        break;
        case x86_pmovzxbq:        return "pmovzxbq";        break;
        case x86_pmovzxbw:        return "pmovzxbw";        break;
        case x86_pmovzxdq:        return "pmovzxdq";        break;
        case x86_pmovzxwd:        return "pmovzxwd";        break;
        case x86_pmovzxwq:        return "pmovzxwq";        break;
        case x86_pmuldq:          return "pmuldq";          break;
        case x86_pmulhrsw:        return "pmulhrsw";        break;
        case x86_pmulhrw:         return "pmulhrw";         break;
        case x86_pmulhuw:         return "pmulhuw";         break;
        case x86_pmulhw:          return "pmulhw";          break;
        case x86_pmulld:          return "pmulld";          break;
        case x86_pmullw:          return "pmullw";          break;
        case x86_pmuludq:         return "pmuludq";         break;
        case x86_pop:             return "pop";             break;
        case x86_popa:            return "popa";            break;
        case x86_popad:           return "popad";           break;
        case x86_popcnt:          return "popcnt";          break;
        case x86_popf:            return "popf";            break;
        case x86_popfd:           return "popfd";           break;
        case x86_popfq:           return "popfq";           break;
        case x86_por:             return "por";             break;
        case x86_prefetch:        return "prefetch";        break;
        case x86_prefetchnta:     return "prefetchnta";     break;
        case x86_prefetcht0:      return "prefetcht0";      break;
        case x86_prefetcht1:      return "prefetcht1";      break;
        case x86_prefetcht2:      return "prefetcht2";      break;
        case x86_prefetchw:       return "prefetchw";       break;
        case x86_psadbw:          return "psadbw";          break;
        case x86_pshufb:          return "pshufb";          break;
        case x86_pshufd:          return "pshufd";          break;
        case x86_pshufhw:         return "pshufhw";         break;
        case x86_pshuflw:         return "pshuflw";         break;
        case x86_pshufw:          return "pshufw";          break;
        case x86_psignb:          return "psignb";          break;
        case x86_psignd:          return "psignd";          break;
        case x86_psignw:          return "psignw";          break;
        case x86_pslld:           return "pslld";           break;
        case x86_pslldq:          return "pslldq";          break;
        case x86_psllq:           return "psllq";           break;
        case x86_psllw:           return "psllw";           break;
        case x86_psrad:           return "psrad";           break;
        case x86_psraq:           return "psraq";           break;
        case x86_psraw:           return "psraw";           break;
        case x86_psrld:           return "psrld";           break;
        case x86_psrldq:          return "psrldq";          break;
        case x86_psrlq:           return "psrlq";           break;
        case x86_psrlw:           return "psrlw";           break;
        case x86_psubb:           return "psubb";           break;
        case x86_psubd:           return "psubd";           break;
        case x86_psubq:           return "psubq";           break;
        case x86_psubsb:          return "psubsb";          break;
        case x86_psubsw:          return "psubsw";          break;
        case x86_psubusb:         return "psubusb";         break;
        case x86_psubusw:         return "psubusw";         break;
        case x86_psubw:           return "psubw";           break;
        case x86_pswapd:          return "pswapd";          break;
        case x86_ptest:           return "ptest";           break;
        case x86_punpckhbw:       return "punpckhbw";       break;
        case x86_punpckhdq:       return "punpckhdq";       break;
        case x86_punpckhqdq:      return "punpckhqdq";      break;
        case x86_punpckhwd:       return "punpckhwd";       break;
        case x86_punpcklbw:       return "punpcklbw";       break;
        case x86_punpckldq:       return "punpckldq";       break;
        case x86_punpcklqdq:      return "punpcklqdq";      break;
        case x86_punpcklwd:       return "punpcklwd";       break;
        case x86_push:            return "push";            break;
        case x86_pusha:           return "pusha";           break;
        case x86_pushad:          return "pushad";          break;
        case x86_pushf:           return "pushf";           break;
        case x86_pushfd:          return "pushfd";          break;
        case x86_pushfq:          return "pushfq";          break;
        case x86_pxor:            return "pxor";            break;
        case x86_rcl:             return "rcl";             break;
        case x86_rcpps:           return "rcpps";           break;
        case x86_rcpss:           return "rcpss";           break;
        case x86_rcr:             return "rcr";             break;
        case x86_rdmsr:           return "rdmsr";           break;
        case x86_rdpmc:           return "rdpmc";           break;
        case x86_rdtsc:           return "rdtsc";           break;
        case x86_rdtscp:          return "rdtscp";          break;
        case x86_rep_insb:        return "rep_insb";        break;
        case x86_rep_insd:        return "rep_insd";        break;
        case x86_rep_insw:        return "rep_insw";        break;
        case x86_rep_lodsb:       return "rep_lodsb";       break;
        case x86_rep_lodsd:       return "rep_lodsd";       break;
        case x86_rep_lodsq:       return "rep_lodsq";       break;
        case x86_rep_lodsw:       return "rep_lodsw";       break;
        case x86_rep_movsb:       return "rep_movsb";       break;
        case x86_rep_movsd:       return "rep_movsd";       break;
        case x86_rep_movsq:       return "rep_movsq";       break;
        case x86_rep_movsw:       return "rep_movsw";       break;
        case x86_rep_outsb:       return "rep_outsb";       break;
        case x86_rep_outsd:       return "rep_outsd";       break;
        case x86_rep_outsw:       return "rep_outsw";       break;
        case x86_rep_stosb:       return "rep_stosb";       break;
        case x86_rep_stosd:       return "rep_stosd";       break;
        case x86_rep_stosq:       return "rep_stosq";       break;
        case x86_rep_stosw:       return "rep_stosw";       break;
        case x86_repe_cmpsb:      return "repe_cmpsb";      break;
        case x86_repe_cmpsd:      return "repe_cmpsd";      break;
        case x86_repe_cmpsq:      return "repe_cmpsq";      break;
        case x86_repe_cmpsw:      return "repe_cmpsw";      break;
        case x86_repe_scasb:      return "repe_scasb";      break;
        case x86_repe_scasd:      return "repe_scasd";      break;
        case x86_repe_scasq:      return "repe_scasq";      break;
        case x86_repe_scasw:      return "repe_scasw";      break;
        case x86_repne_cmpsb:     return "repne_cmpsb";     break;
        case x86_repne_cmpsd:     return "repne_cmpsd";     break;
        case x86_repne_cmpsq:     return "repne_cmpsq";     break;
        case x86_repne_cmpsw:     return "repne_cmpsw";     break;
        case x86_repne_scasb:     return "repne_scasb";     break;
        case x86_repne_scasd:     return "repne_scasd";     break;
        case x86_repne_scasq:     return "repne_scasq";     break;
        case x86_repne_scasw:     return "repne_scasw";     break;
        case x86_ret:             return "ret";             break;
        case x86_retf:            return "retf";            break;
        case x86_rol:             return "rol";             break;
        case x86_ror:             return "ror";             break;
        case x86_roundpd:         return "roundpd";         break;
        case x86_roundps:         return "roundps";         break;
        case x86_roundsd:         return "roundsd";         break;
        case x86_roundss:         return "roundss";         break;
        case x86_rsm:             return "rsm";             break;
        case x86_rsqrtps:         return "rsqrtps";         break;
        case x86_rsqrtss:         return "rsqrtss";         break;
        case x86_sahf:            return "sahf";            break;
        case x86_salc:            return "salc";            break;
        case x86_sar:             return "sar";             break;
        case x86_sbb:             return "sbb";             break;
        case x86_scasb:           return "scasb";           break;
        case x86_scasd:           return "scasd";           break;
        case x86_scasq:           return "scasq";           break;
        case x86_scasw:           return "scasw";           break;
        case x86_seta:            return "seta";            break;
        case x86_setae:           return "setae";           break;
        case x86_setb:            return "setb";            break;
        case x86_setbe:           return "setbe";           break;
        case x86_sete:            return "sete";            break;
        case x86_setg:            return "setg";            break;
        case x86_setge:           return "setge";           break;
        case x86_setl:            return "setl";            break;
        case x86_setle:           return "setle";           break;
        case x86_setne:           return "setne";           break;
        case x86_setno:           return "setno";           break;
        case x86_setns:           return "setns";           break;
        case x86_seto:            return "seto";            break;
        case x86_setpe:           return "setpe";           break;
        case x86_setpo:           return "setpo";           break;
        case x86_sets:            return "sets";            break;
        case x86_sfence:          return "sfence";          break;
        case x86_sgdt:            return "sgdt";            break;
        case x86_shl:             return "shl";             break;
        case x86_shld:            return "shld";            break;
        case x86_shr:             return "shr";             break;
        case x86_shrd:            return "shrd";            break;
        case x86_shufpd:          return "shufpd";          break;
        case x86_shufps:          return "shufps";          break;
        case x86_sidt:            return "sidt";            break;
        case x86_skinit:          return "skinit";          break;
        case x86_sldt:            return "sldt";            break;
        case x86_smsw:            return "smsw";            break;
        case x86_sqrtpd:          return "sqrtpd";          break;
        case x86_sqrtps:          return "sqrtps";          break;
        case x86_sqrtsd:          return "sqrtsd";          break;
        case x86_sqrtss:          return "sqrtss";          break;
        case x86_stc:             return "stc";             break;
        case x86_std:             return "std";             break;
        case x86_stgi:            return "stgi";            break;
        case x86_sti:             return "sti";             break;
        case x86_stmxcsr:         return "stmxcsr";         break;
        case x86_stos:            return "stos";            break;
        case x86_stosb:           return "stosb";           break;
        case x86_stosd:           return "stosd";           break;
        case x86_stosq:           return "stosq";           break;
        case x86_stosw:           return "stosw";           break;
        case x86_str:             return "str";             break;
        case x86_sub:             return "sub";             break;
        case x86_subpd:           return "subpd";           break;
        case x86_subps:           return "subps";           break;
        case x86_subsd:           return "subsd";           break;
        case x86_subss:           return "subss";           break;
        case x86_swapgs:          return "swapgs";          break;
        case x86_syscall:         return "syscall";         break;
        case x86_sysenter:        return "sysenter";        break;
        case x86_sysexit:         return "sysexit";         break;
        case x86_sysret:          return "sysret";          break;
        case x86_test:            return "test";            break;
        case x86_ucomisd:         return "ucomisd";         break;
        case x86_ucomiss:         return "ucomiss";         break;
        case x86_ud2:             return "ud2";             break;
        case x86_unpckhpd:        return "unpckhpd";        break;
        case x86_unpckhps:        return "unpckhps";        break;
        case x86_unpcklpd:        return "unpcklpd";        break;
        case x86_unpcklps:        return "unpcklps";        break;
        case x86_verr:            return "verr";            break;
        case x86_verw:            return "verw";            break;
        case x86_vmcall:          return "vmcall";          break;
        case x86_vmclear:         return "vmclear";         break;
        case x86_vmlaunch:        return "vmlaunch";        break;
        case x86_vmload:          return "vmload";          break;
        case x86_vmmcall:         return "vmmcall";         break;
        case x86_vmoff:           return "vmoff";           break;
        case x86_vmptrld:         return "vmptrld";         break;
        case x86_vmptrst:         return "vmptrst";         break;
        case x86_vmread:          return "vmread";          break;
        case x86_vmresume:        return "vmresume";        break;
        case x86_vmrun:           return "vmrun";           break;
        case x86_vmsave:          return "vmsave";          break;
        case x86_vmwrite:         return "vmwrite";         break;
        case x86_vmxoff:          return "vmxoff";          break;
        case x86_vmxon:           return "vmxon";           break;
        case x86_wait:            return "wait";            break;
        case x86_wbinvd:          return "wbinvd";          break;
        case x86_wrmsr:           return "wrmsr";           break;
        case x86_xadd:            return "xadd";            break;
        case x86_xchg:            return "xchg";            break;
        case x86_xgetbv:          return "xgetbv";          break;
        case x86_xlatb:           return "xlatb";           break;
        case x86_xor:             return "xor";             break;
        case x86_xorpd:           return "xorpd";           break;
        case x86_xorps:           return "xorps";           break;
        case x86_xrstor:          return "xrstor";          break;
        case x86_xsave:           return "xsave";           break;
        case x86_xsetbv:          return "xsetbv";          break;
        default: abort(); //should not happen since this is machine generated!
    }

    // tps (12/7/2009) : Cannot get here. Returning control path to avoid warning in MSCV
    return "Should never see this text.";
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
