/* include/config.h.default. 
   A semi-sane set of defaults for more recent Linux platforms. Please tailor
   to meet your needs.
 */

/* Define to 1 if you have the new implementation of quotactl that only
   requires sys/types.h and sys/quota.h */
#define HAS_NEW_MINIMAL_QUOTACTL 1

/* Define to 1 if you have the RHEL ~4.6 version of quotactl, e.g. require
   linux/quota.h instead of sys/quota.h */
#undef HAS_RHEL46_QUOTACTL

/* Define to 1 if you have the RHEL 4.8+ version of quotactl, e.g. require
   sys/quota.h */
#define HAS_RHEL48_QUOTACTL

/* Define to 1 if you have the <asm/ldt.h> header file. */
#undef HAVE_ASM_LDT_H

/* Define to 1 if you have the <attr/xattr.h> header file. */
#undef HAVE_ATTR_XATTR_H

/* Define to 1 if you have the declaration of `CAP_BSET_DROP', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_BSET_DROP

/* Define to 1 if you have the declaration of `CAP_BSET_READ', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_BSET_READ

/* Define to 1 if you have the declaration of `cap_compare', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_COMPARE

/* Define to 1 if you have the declaration of `cap_free', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_FREE

/* Define to 1 if you have the declaration of `cap_from_text', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_FROM_TEXT

/* Define to 1 if you have the declaration of `cap_get_proc', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_GET_PROC

/* Define to 1 if you have the declaration of `cap_set_file', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_SET_FILE

/* Define to 1 if you have the declaration of `cap_set_flag', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_SET_FLAG

/* Define to 1 if you have the declaration of `cap_set_proc', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_SET_PROC

/* Define to 1 if you have the declaration of `cap_to_text', and to 0 if you
   don't. */
#undef HAVE_DECL_CAP_TO_TEXT

/* Define to 1 if you have the declaration of `PR_CAPBSET_READ', and to 0 if
   you don't. */
#undef HAVE_DECL_PR_CAPBSET_READ

/* Define to 1 if you have the declaration of `PTRACE_GETSIGINFO', and to 0 if
   you don't. */
#define HAVE_DECL_PTRACE_GETSIGINFO 1

/* Define to 1 if you have the declaration of `PTRACE_O_TRACEVFORKDONE', and
   to 0 if you don't. */
#define HAVE_DECL_PTRACE_O_TRACEVFORKDONE 1

/* Define to 1 if you have the declaration of `PTRACE_SETOPTIONS', and to 0 if
   you don't. */
#undef HAVE_DECL_PTRACE_SETOPTIONS

/* Define to 1 if you have the <dmapi.h> header file. */
#undef HAVE_DMAPI_H

/* Define to 1 if you have the <ifaddrs.h> header file. */
#define HAVE_IFADDRS_H 1

/* Define to 1 if you have the <inttypes.h> header file. */
#define HAVE_INTTYPES_H 1

/* Define to 1 if you have the `io_set_eventfd' function. */
#undef HAVE_IO_SET_EVENTFD

/* Define to 1 if you have the <libaio.h> header file. */
#undef HAVE_LIBAIO_H

/* Define to 1 if you have both SELinux libraries and headers. */
#undef HAVE_LIBSELINUX_DEVEL

/* Define to 1 if you have the <linux/genetlink.h> header file. */
#undef HAVE_LINUX_GENETLINK_H

/* Define to 1 if you have the <linux/module.h> header file. */
#undef HAVE_LINUX_MODULE_H

/* Define to 1 if you have the <linux/netlink.h> header file. */
#undef HAVE_LINUX_NETLINK_H

/* Define to 1 if you have the <linux/ptrace.h> header file. */
#undef HAVE_LINUX_PTRACE_H

/* Define to 1 if you have the <linux/signalfd.h> header file. */
#undef HAVE_LINUX_SIGNALFD_H

/* Define to 1 if you have the <linux/taskstats.h> header file. */
#undef HAVE_LINUX_TASKSTATS_H

/* Define to 1 if you have the <linux/types.h> header file. */
#undef HAVE_LINUX_TYPES_H

/* Define to 1 if you have the <memory.h> header file. */
#undef HAVE_MEMORY_H

/* Define to 1 if you have the <mm.h> header file. */
#undef HAVE_MM_H

/* Define to 1 if you have the `modify_ldt' function. */
#undef HAVE_MODIFY_LDT

/* 2.6 version of swapon/swapoff */
#define HAVE_NEW_SWAPONOFF 1

/* Define to 1 if you have the `numa_alloc_onnode' function. */
#undef HAVE_NUMA_ALLOC_ONNODE

/* Define to 1 if you have the <numa.h> header file. */
#undef HAVE_NUMA_H

/* 2.4 version of swapon/swapoff */
#undef HAVE_OLD_SWAPONOFF

/* Define to 1 if you have the <openssl/sha.h> header file. */
#undef HAVE_OPENSSL_SHA_H

/* Define to 1 if you have the <pthread.h> header file. */
#undef HAVE_PTHREAD_H

/* Define to 1 if you have the <selinux/selinux.h> header file. */
#undef HAVE_SELINUX_SELINUX_H

/* Define to 1 if you have the `signalfd' function. */
#define HAVE_SIGNALFD 1

/* Define to 1 if you have the <signalfd.h> header file. */
#define HAVE_SIGNALFD_H 1

/* Define to 1 if you have the <stdint.h> header file. */
#undef HAVE_STDINT_H

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define to 1 if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#define HAVE_STRING_H 1

/* Define to 1 if the system has the type `struct modify_ldt_ldt_s'. */
#undef HAVE_STRUCT_MODIFY_LDT_LDT_S

/* Define to 1 if `signo' is member of `struct signalfd_siginfo'. */
#undef HAVE_STRUCT_SIGNALFD_SIGINFO_SIGNO

/* Define to 1 if `ssi_signo' is member of `struct signalfd_siginfo'. */
#undef HAVE_STRUCT_SIGNALFD_SIGINFO_SSI_SIGNO

/* Define to 1 if `freepages_count' is member of `struct taskstats'. */
#undef HAVE_STRUCT_TASKSTATS_FREEPAGES_COUNT

/* Define to 1 if `nvcsw' is member of `struct taskstats'. */
#undef HAVE_STRUCT_TASKSTATS_NVCSW

/* Define to 1 if `read_bytes' is member of `struct taskstats'. */
#undef HAVE_STRUCT_TASKSTATS_READ_BYTES

/* Define to 1 if the system has the type `struct user_desc'. */
#undef HAVE_STRUCT_USER_DESC

/* Define to 1 if you have the <sys/acl.h> header file. */
#define HAVE_SYS_ACL_H 1

/* Define to 1 if you have the <sys/capability.h> header file. */
#define HAVE_SYS_CAPABILITY_H 1

/* Define to 1 if you have the <sys/epoll.h> header file. */
#define HAVE_SYS_EPOLL_H 1

/* Define to 1 if you have the <sys/inotify.h> header file. */
#define HAVE_SYS_INOTIFY_H 1

/* Define to 1 if you have the <sys/jfsdmapi.h> header file. */
#undef HAVE_SYS_JFSDMAPI_H

/* Define to 1 if you have the <sys/prctl.h> header file. */
#undef HAVE_SYS_PRCTL_H

/* Define to 1 if you have the <sys/signalfd.h> header file. */
#undef HAVE_SYS_SIGNALFD_H

/* Define to 1 if you have the <sys/stat.h> header file. */
#define HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#define HAVE_SYS_TYPES_H 1

/* Define to 1 if you have the <unistd.h> header file. */
#define HAVE_UNISTD_H 1

/* Define to 1 if you have the `unshare' function. */
#undef HAVE_UNSHARE

/* Name of package */
#undef PACKAGE

/* Define to the address where bug reports for this package should be sent. */
#undef PACKAGE_BUGREPORT

/* Define to the full name of this package. */
#undef PACKAGE_NAME

/* Define to the full name and version of this package. */
#undef PACKAGE_STRING

/* Define to the one symbol short name of this package. */
#undef PACKAGE_TARNAME

/* Define to the version of this package. */
#undef PACKAGE_VERSION

/* Define to 1 if you have the ANSI C header files. */
#define STDC_HEADERS 1

/* Version number of package */
#undef VERSION

/* Define to 1 if `lex' declares `yytext' as a `char *' by default, not a
   `char[]'. */
#undef YYTEXT_POINTER

/*
 * vim: syntax=c
 */
