% vim: syn=prolog

:- include "io.P".
:- template "basic".

% A table with one field of type string
:- declare p(string).

% Insert entries into table p
p("A").
p("B").

% A table with two fields of type string and integer
:- declare q(string, int).

% Insert entries
q("A", 3).
q("A", 4).
q("C", 5).

% Another table
:- declare r(string, int).

% Rule of r: intersection of p and q
r(S, I) :- p(S), q(S, I).

:- declare parent(string, string).

parent("Jim", "John").
parent("John", "Maggie").
parent("John", "Thomas").
parent("Maggie", "Sam").

:- declare anc(string, string).
% Recursively build the anc table

anc(P, D) :- parent(P, D).
anc(P, D) :- parent(P, C), anc(C, D).

% Find Jim's grandchildren, not children
?- anc("Jim", X), \+ parent("Jim", X), printnl(X). 
?- p(X), printnl(X).  % Query table p, all entries 
