#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of rose
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/rose-//g'`
echo $version

#Some cleanup
rm -rf source build install

#Create install directories
mkdir install source build

#Untar 
tar -zxvf  rose-$version.tar.gz

#Move rose into install directory
mv rose-$version/* source
rm -rf rose-$version

cd build

#Configure
../source/configure --prefix=$ISSM_TIER/externalpackages/rose/install \
					--with-boost=$ISSM_TIER/externalpackages/boost/install\
					--srcdir=$ISSM_TIER/externalpackages/rose/source

make -j $NUMCPUS
make install
