#define MAIN_APP_PROGRAM

// GNU will build intances of all objects in the header file if this
// is not specified.  The result is very large object files (too many symbols)
// so we can significantly reduce the size of the object files which will
// build the library (factor of 5-10).
#ifdef GNU
#pragma implementation "A++.h"
#endif











// *********************************************************
// This file contains the implementation of many of the member 
// functions of the A++/P++ array objects.  Array objects are
// defined for doubleArray floatArray and intArray.
// *********************************************************

// *********************************************************
// Include A++ header files
// *********************************************************
#include "A++.h"

// *********************************************************
// Include header files for Machine Dependent Interface (MDI) layer
// *********************************************************
extern "C"
   {
/* machine.h is found in MDI/machine.h through a link in A++/inc lude and P++/inc lude */
#include "machine.h"
   }


// Be consistant and make these extern in all files except the 
// file which handels global variables -- static_initialization.C
extern int APP_Global_Array_Base; 
extern Range APP_Unit_Range;

#define GIVE_UP_ON_ERROR_CHECKING TRUE
#define ARRAY_ID_LEAK_FIXED TRUE

#ifdef NDEBUG
#define DISPLAY_ALL_DATA FALSE
#else
#define DISPLAY_ALL_DATA TRUE
#endif

#if defined(PPP)
// Turn this off for now!
// Having this turned off simplifies the debugging process for A++/P++
#define MAX_MIN_CALL_IN_DISPLAY FALSE
// Support for parallel printf
#define USE_PARALLEL_STDIO TRUE
#define USE_PARALLEL_PRINTF
#else
#if defined(USE_EXPRESSION_TEMPLATES)
#define MAX_MIN_CALL_IN_DISPLAY FALSE
#else
#if defined(APP)
#define MAX_MIN_CALL_IN_DISPLAY TRUE
#else
// if TRUE this causes a bug in purify (only with P++) !!! (version 4.5.1)
#define MAX_MIN_CALL_IN_DISPLAY FALSE
#endif
#endif
#endif

// USE_DESCRIPTOR_CACHING FALSE



#if !defined(PPP)
// ******************************************************
// set the default base used for all A++ arrays objects
// ******************************************************
void
setGlobalBase( int Base )
   {
#if COMPILE_DEBUG_STATEMENTS
  // Enforce bound on Alt_Base depending on INT_MAX and INT_MIN
     static int Max_Base = INT_MAX;
     static int Min_Base = INT_MIN;

     if ( Base <= Min_Base || Base >= Max_Base )
        {
          printf ("ERROR: in setGlobalBase Base (%d) is out of range [%d, %d]\n",Base,Min_Base,Max_Base);
          APP_ABORT();
        }
#endif
     
     APP_Global_Array_Base = Base;
   }

// ******************************************************
// get the default base used for all A++ arrays objects
// ******************************************************
int
getGlobalBase()
   {
     return APP_Global_Array_Base;
   }

#if 1
// Install in next version
// ******************************************************
// get the A++/P++ library version number (named with 
// "APP_" prefix to avoid name space collision)
// ******************************************************
char*
APP_version()
   {
     return VERSION;
   }
#endif

// ******************************************************
// Abort function used univerally within A++/P++
// ******************************************************
void
APP_ABORT()
   {
  // The all data out to stdout and stderr before calling MPI_Abort()
     fflush(stdout);
     fflush(stderr);

#if defined(SERIAL_APP)
     printf ("Exiting P++ program from inside of APP_ABORT()! (Calling system abort function ...) \n");

  // Have to call MPI_Abort before calling MPI_Finalize (contained in Exit_Virtual_Machine())
  // MPI_Abort(MPI_COMM_WORLD,Diagnostic_Manager::APP_ErrorCode);
#else
     printf ("Exiting A++ program from inside of APP_ABORT()! (Calling system abort function ...) \n");
#endif

     Optimization_Manager::Exit_Virtual_Machine ();
     printf ("Virtual Machine exited! \n");
     fflush(stdout);
     fflush(stderr);
     abort();
   }

// ******************************************************
// Exit function used univerally within A++/P++
// ******************************************************
void
APP_Exit()
   {
  // error code to pass back to unix operating system ored by purify if purify is used
     int errorCode = Diagnostic_Manager::APP_ErrorCode;

#if defined(SERIAL_APP)
     printf ("Exiting P++ program from inside of APP_EXIT()! (Calling system abort function ...) \n");

  // Have to call MPI_Abort before calling MPI_Finalize (contained in Exit_Virtual_Machine())
  // MPI_Abort(MPI_COMM_WORLD,errorCode);

  // Optimization_Manager::Exit_Virtual_Machine();
     printf ("Virtual Machine exited! \n");
#endif

  // Clean out existing buffers before exiting
     fflush(stdout);
     fflush(stderr);

#if defined(USE_PURIFY)
  // If purify is used (configured and is actually running) then force the exit 
  // status to reflect any errors found when running with purify 
  // (access errors, memory leaks, and memory in use) these bool values 
  // are ORed into the status (ZERO is used as input)
     if (purify_is_running() == TRUE)
        {
          printf ("Exiting ... A++/P++ is configured to use PURIFY and (purify_is_running() == TRUE) \n");

       // Call purify exit mechanism to return non-zero
       // status if any purify errors have been detected
          purify_exit(errorCode);
        }
       else
        {
          printf ("Exiting... A++/P++ is configured to use PURIFY but (purify_is_running() == FALSE) \n");
          exit(errorCode);
        }
#else
     printf ("Exiting P++ program from inside of APP_EXIT() (A++/P++ is not configured to use purify) (Calling system exit function ...) \n");
     exit(errorCode);
#endif
   }


// ******************************************************
// Assertion support function used univerally within A++/P++ (used in APP_ASSERT)
// ******************************************************
void
APP_Assertion_Support ( char* Source_File_With_Error, unsigned Line_Number_In_File )
   {
#if defined(PPP) || defined(SERIAL_APP)
     cerr << "\n\nParallel Assertion failed on processor "
          << Communication_Manager::localProcessNumber()
          << " of file "
          << Source_File_With_Error
          << " on line "
          << Line_Number_In_File
          << "\n";
#else
     cerr << "\n\nSerial Assertion failed "
          << "in file "
          << Source_File_With_Error
          << " on line "
          << Line_Number_In_File
          << "\n";
#endif
  // (8/3/2000) Bugfix suggest by Brian Miller to fix problem with dynamic libraries when compiled with KCC
  // cerr << flush;
     cerr.flush();
     APP_ABORT();
   }

#if 0
void APP_Assertion_Support ( char* Source_File_With_Error, unsigned Line_Number_In_File )
   {
     fflush(stdout);
#if defined(PPP)
     fprintf(stderr, "\n\nP++ Assertion failed on processor %d of file %s on line %u \n",
          PARTI_myproc(),Source_File_With_Error,Line_Number_In_File);
#else
     fprintf(stderr, "\n\nA++ Assertion failed: %s, line %u \n",Source_File_With_Error,Line_Number_In_File);
#endif
     fflush(stderr);
     APP_ABORT();
   }
#endif

#endif


#if 0
// Another example of a parallel printf type function (included as a reference)
#include <stdarg.h>
void
MPI_Printf(char *fmt, ...)
{
#define BUFSIZE 128
    int rank;
    int tag=10, p,np;
    va_list args;
    char str[BUFSIZE];
    MPI_Status status;
    va_start(args,fmt);

    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &np);
    if (rank==0) {
        fprintf(stdout,"PE%3.3d: ",rank);
        vfprintf(stdout,fmt,args);
        for (p=1; p<np; p++) {
            MPI_Recv(str,BUFSIZE,MPI_CHAR,p,tag, MPI_COMM_WORLD, &status);
            fprintf(stdout,"PE%3.3d: ",p);
            fprintf(stdout,"%s",str);
        }
    } else {
        vsprintf(str,fmt,args);
        MPI_Send(str,BUFSIZE,MPI_CHAR,0,tag,MPI_COMM_WORLD);
    }
    va_end(args);
    fflush(stdout);
}
#endif

#if defined(PPP)

// Undefine this so that we can call the REAL printf function properly
// within the definition of the parallel printf function.
#if defined(USE_PARALLEL_PRINTF)
#undef printf
#endif

#include <stdarg.h>

// ###################################################################
// Parallel printf function prepends the node number to any output using printf if
// the standard printf is defined to be parallelPrintf by a macro internally.
// This macro is contorled within the A++_headers.h file in P++/include.
// ###################################################################

int
parallelPrintf ( const char *inputString , ... )
   {
  // An additional option to this function could be to place all output into a file
  // or separate files.

     char tempString    [1000];
     char messageString [1000];

     char *fmt     = NULL;
     va_list arg_ptr;
     va_start(arg_ptr,inputString);
     vsprintf ( tempString , inputString , arg_ptr );

     if ((Communication_Manager::restrictOutput == FALSE) ||
         (Communication_Manager::localProcessNumber() == Communication_Manager::ioProcessor))
        {
          if (Communication_Manager::getPrefixParallelPrintf() == TRUE)
               sprintf ( messageString , "NODE %2d: %s" , 
                    Communication_Manager::localProcessNumber() , tempString  );
            else
               sprintf ( messageString , "%s" , tempString  );
        }
       else
        {
       // What the other processors output!
          sprintf ( messageString, ".");
        }
     
  // Note that we need the ";" at the end because some machines define this macro without it
  // (error reported by Brian Gunney)
     va_end(arg_ptr);

  // return the result from the original printf function
     return printf ("%s",messageString);
  // return 0;
   }

// Redefine the printf macro if USE_PARALLEL_PRINTF is 
// defined (it was undefined just for this function).
#if defined(USE_PARALLEL_PRINTF)
#define printf parallelPrintf
#endif

#endif












/* EXPAND THE MACROS HERE! */

#define DOUBLEARRAY
// *********************************************************
// *********************************************************
// ***********  STATIC VARIABLE INITIALIZEATION  ***********
// *********************************************************
// *********************************************************

#if !defined(PPP)
// *********************************************************
// Hash tables can be used to to avoid redundent allocation 
// and deallocation associated with the use of temporaries.
// Temporaries are created and saved for reuse when the same 
// size temporary is required again. No smart system for aging
// of hashed memory is used to avoid the acumulation of reserved
// memory for reuse.  Also no measurable advantage of this 
// feature has been observed.
// *********************************************************
// doubleArray_Data_Hash_Table doubleArray::Hash_Table;
#endif

// *********************************************************
// A++/P++ arrays can be optionally set to always initialize their
// data to a user defined value on construction.  This feature is generally 
// turned off to avoid the performance overhead of unrequired 
// initialization. The value used for the optional initialization
// is defined in doubleArray::PREINITIALIZE_VALUE -- but may be 
// redefined by the user.  The default value is
// INT_MAX -- this is choosen because it is a value more likely
// to allow users to catch errors in there codes.
// This feature of A++/P++ arrose out of discussions with Bill Rider.
// *********************************************************
bool doubleArray::PREINITIALIZE_OBJECT_IN_CONSTRUCTOR = FALSE;
double      doubleArray::PREINITIALIZE_VALUE                 = (double) INT_MAX;
bool doubleArray::USE_DESCRIPTOR_CACHING              = FALSE;

// *********************************************************
// Constants to allow different formating of array data in
// the A++ display member function
// *********************************************************
const int doubleArray::DECIMAL_DISPLAY_FORMAT     = 0;
const int doubleArray::EXPONENTIAL_DISPLAY_FORMAT = 1;
const int doubleArray::SMART_DISPLAY_FORMAT       = 2;
// On the HP machines their C++ compiler initializes const static
// variable AFTER non-const static variables thus the DISPLAY_FORMAT
// gets garbage.  To fix this we initialize DISPLAY_FORMAT with the 
// value 2 directly!
// int doubleArray::DISPLAY_FORMAT = doubleArray::SMART_DISPLAY_FORMAT;
int doubleArray::DISPLAY_FORMAT = 2;

// *********************************************************
/* Constants used to define specific operations              */
/* (used within runtime system for control of optimizations) */
// *********************************************************
const int doubleArray::Plus             = 0;
const int doubleArray::Minus            = 1;
const int doubleArray::Times            = 2;
const int doubleArray::Divided_By       = 3;
const int doubleArray::Modulo           = 4;
const int doubleArray::cos_Function     = 5;
const int doubleArray::sin_Function     = 6;
const int doubleArray::tan_Function     = 7;
const int doubleArray::acos_Function    = 8;
const int doubleArray::asin_Function    = 9;
const int doubleArray::atan_Function    = 10;
const int doubleArray::cosh_Function    = 11;
const int doubleArray::sinh_Function    = 12;
const int doubleArray::tanh_Function    = 13;
const int doubleArray::acosh_Function   = 14;
const int doubleArray::asinh_Function   = 15;
const int doubleArray::atanh_Function   = 16;
const int doubleArray::log_Function     = 17;
const int doubleArray::log10_Function   = 18;
const int doubleArray::exp_Function     = 19;
const int doubleArray::sqrt_Function    = 20;
const int doubleArray::fabs_Function    = 21;
const int doubleArray::abs_Function     = 22; 
const int doubleArray::ceil_Function    = 23;
const int doubleArray::floor_Function   = 24;
const int doubleArray::atan2_Function   = 25;
const int doubleArray::Unary_Minus      = 26;
const int doubleArray::fmod_Function    = 27;
const int doubleArray::mod_Function     = 28;
const int doubleArray::pow_Function     = 29;
const int doubleArray::sign_Function    = 30;
const int doubleArray::min_Function     = 31;
const int doubleArray::max_Function     = 32;
const int doubleArray::Not              = 33;
const int doubleArray::LT               = 34;
const int doubleArray::GT               = 35;
const int doubleArray::LTEQ             = 36;
const int doubleArray::GTEQ             = 37;
const int doubleArray::EQ               = 38;
const int doubleArray::NOT_EQ           = 39;
const int doubleArray::AND              = 40;
const int doubleArray::OR               = 41;

const int doubleArray::Scalar_Plus             = 42;
const int doubleArray::Scalar_Minus            = 43;
const int doubleArray::Scalar_Times            = 44;
const int doubleArray::Scalar_Divided_By       = 45;
const int doubleArray::Scalar_Modulo           = 46;
const int doubleArray::Scalar_cos_Function     = 47;
const int doubleArray::Scalar_sin_Function     = 48;
const int doubleArray::Scalar_tan_Function     = 49;
const int doubleArray::Scalar_acos_Function    = 50;
const int doubleArray::Scalar_asin_Function    = 51;
const int doubleArray::Scalar_atan_Function    = 52;
const int doubleArray::Scalar_cosh_Function    = 53;
const int doubleArray::Scalar_sinh_Function    = 54;
const int doubleArray::Scalar_tanh_Function    = 55;
const int doubleArray::Scalar_acosh_Function   = 56;
const int doubleArray::Scalar_asinh_Function   = 57;
const int doubleArray::Scalar_atanh_Function   = 58;
const int doubleArray::Scalar_log_Function     = 59;
const int doubleArray::Scalar_log10_Function   = 60;
const int doubleArray::Scalar_exp_Function     = 61;
const int doubleArray::Scalar_sqrt_Function    = 62;
const int doubleArray::Scalar_fabs_Function    = 63;
const int doubleArray::Scalar_abs_Function     = 64;
const int doubleArray::Scalar_ceil_Function    = 65;
const int doubleArray::Scalar_floor_Function   = 66;
const int doubleArray::Scalar_atan2_Function   = 67;
const int doubleArray::Scalar_Unary_Minus      = 68;
const int doubleArray::Scalar_fmod_Function    = 69;
const int doubleArray::Scalar_mod_Function     = 70;
const int doubleArray::Scalar_pow_Function     = 71;
const int doubleArray::Scalar_sign_Function    = 72;
const int doubleArray::Scalar_min_Function     = 73;
const int doubleArray::Scalar_max_Function     = 74;
const int doubleArray::Scalar_Not              = 75;
const int doubleArray::Scalar_LT               = 76;
const int doubleArray::Scalar_GT               = 77;
const int doubleArray::Scalar_LTEQ             = 78;
const int doubleArray::Scalar_GTEQ             = 79;
const int doubleArray::Scalar_EQ               = 80;
const int doubleArray::Scalar_NOT_EQ           = 81;
const int doubleArray::Scalar_AND              = 82;
const int doubleArray::Scalar_OR               = 83;

// These are considered to terminate a Statement!
const int doubleArray::Assignment        = 84;
const int doubleArray::replace_Function  = 85;
const int doubleArray::Plus_Equals       = 86;
const int doubleArray::Minus_Equals      = 87;
const int doubleArray::Times_Equals      = 88;
const int doubleArray::Divided_By_Equals = 89;
const int doubleArray::Modulo_Equals     = 90;
const int doubleArray::sum_Function      = 91;
const int doubleArray::Scalar_Assignment        = 92;
const int doubleArray::Scalar_replace_Function  = 93;
const int doubleArray::Scalar_Plus_Equals       = 94;
const int doubleArray::Scalar_Minus_Equals      = 95;
const int doubleArray::Scalar_Times_Equals      = 96;
const int doubleArray::Scalar_Divided_By_Equals = 97;
const int doubleArray::Scalar_Modulo_Equals     = 98;
const int doubleArray::Scalar_sum_Function      = 99;

const int doubleArray::indexMap_Function = 100;
const int doubleArray::view_Function     = 101;
const int doubleArray::display_Function  = 102;

// Bitwise operators
const int doubleArray::BitwiseComplement       = 103;
const int doubleArray::BitwiseAND              = 104;
const int doubleArray::BitwiseOR               = 105;
const int doubleArray::BitwiseXOR              = 106;
const int doubleArray::BitwiseLShift           = 107;
const int doubleArray::BitwiseRShift           = 108;
const int doubleArray::Scalar_BitwiseAND        = 109;
const int doubleArray::Scalar_BitwiseOR         = 110;
const int doubleArray::Scalar_BitwiseXOR        = 111;
const int doubleArray::Scalar_BitwiseLShift     = 112;
const int doubleArray::Scalar_BitwiseRShift     = 113;
const int doubleArray::BitwiseAND_Equals       = 114;
const int doubleArray::BitwiseOR_Equals        = 115;
const int doubleArray::BitwiseXOR_Equals       = 116;
const int doubleArray::Scalar_BitwiseAND_Equals = 117;
const int doubleArray::Scalar_BitwiseOR_Equals  = 118;
const int doubleArray::Scalar_BitwiseXOR_Equals = 119;

// Conversion operators
const int doubleArray::convertTo_intArrayFunction    = 120;
const int doubleArray::convertTo_floatArrayFunction  = 121;
const int doubleArray::convertTo_doubleArrayFunction = 122;

// *********************************************************
// *********************************************************
// ****  BASEARRAY CLASS constructor and destructor  *****
// *********************************************************
// *********************************************************

#if defined(DOUBLEARRAY)

#if 1
BaseArray::BaseArray()
   {
  // Constructor
   };
#endif

#if 0
BaseArray::~BaseArray()
   {
  // Destructor
   };
#endif

// if DOUBLEARRAY
#endif

// *********************************************************
// *********************************************************
// ********  NEW OPERATOR INITIALIZEATION SUPPORT  *********
// *********************************************************
// *********************************************************

void
doubleArray::freeMemoryInUse() 
   {
  // *********************************************************
  // This function is useful in conjuction with the Purify (from Pure Software Inc.)
  // it frees memory allocated for use internally in A++ doubleArray objects.
  // This memory is used internally and is reported as "in use" by Purify
  // if it is not freed up using this function.  This function works with 
  // similar functions for each A++ object to free up all of the A++ memory in 
  // use internally.
  // *********************************************************

#if defined(USE_TAU)
     TAU_PROFILE("doubleArray::freeMemoryInUse()", "void(void)", TAU_APP_MEMORY_POOL_MANAGEMENT);
#endif

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        printf ("Inside of doubleArray::freeMemoryInUse() \n");
#endif 

#if 1
  // used in abstract_op.C to hold last temporary in cases where it must 
  // have a lifetime beyond the current statement.
#if !defined(PPP)
  // freeup space from last temporary!
     if (Last_Lhs_doubleArray_Operand != NULL)
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("Delete Last_Lhs_doubleArray_Operand  Last_Lhs_doubleArray_Operand = %p \n",Last_Lhs_doubleArray_Operand);
#endif 
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          Last_Lhs_doubleArray_Operand->decrementReferenceCount();
          if (Last_Lhs_doubleArray_Operand->getReferenceCount() < getReferenceCountBase())
               delete Last_Lhs_doubleArray_Operand;
          Last_Lhs_doubleArray_Operand = NULL;
        }
       else
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("No Last_Lhs_doubleArray_Operand to delete! \n");
#endif 
        }
#endif

     int i;
     for (i=0; i < Max_Number_Of_Memory_Blocks-1; i++)
        {
          if (Memory_Block_List [i] != NULL)
             {
#if 1
               free ((char*) (Memory_Block_List[i]));
#else
               delete ((char*) (Memory_Block_List[i]));
#endif
             }
        }
#else
     printf ("doubleArray::freeMemoryInUse() Commented Out! \n");
#endif
   }

// *********************************************************
// *********************************************************
// ***********  INITIALIZATION FOR CONSTRUCTORS  ***********
// *********************************************************
// *********************************************************

// inline void
// doubleArray::preInitialize_Array ( int Number_Of_Valid_Dimensions ,
//                                  const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                                  bool Force_Memory_Allocation )
inline void
doubleArray::preInitializeArray ()
   {
// *************************************************************************
// This function is used internally in the Initialize_Array_Functions below
// *************************************************************************

#if defined(APP) || ( defined(SERIAL_APP) && !defined(PPP) )
  // For P++ we only track the serial array objects not the serial array objects
     if (Diagnostic_Manager::getTrackArrayData() == TRUE)
        {
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
#ifdef DOUBLEARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_DOUBLE_ELEMENT_TYPE);
#endif
#ifdef FLOATARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_FLOAT_ELEMENT_TYPE);
#endif
#ifdef INTARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_INT_ELEMENT_TYPE);
#endif
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
        }
#endif

#if defined(PPP)
     Array_Descriptor.SerialArray = NULL;
#else
     Array_Descriptor.Array_Data  = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

  // There are no auxilary references at this point
     referenceCount = getReferenceCountBase();

  // printf ("Allocation should be done in the Array_Descriptor object! \n");

  // If Force_Memory_Allocation == TRUE then the constructor has to allocate
  // space even if DEFER_EXPRESSION_EVALUATION == TRUE
  // This function allocates the data for the serial and distributed parallel
  // arrays.  I the case of P++ is allocates only this processors part of the
  // data (info obtained from block parti array descriptor).
     Allocate_Array_Data (TRUE);

#if 1
#if defined(PPP)
  // Error checking!
     if ( Communication_Manager::Number_Of_Processors == 1 )
        {
          for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
               if ( getLength(i) != Array_Descriptor.SerialArray->getLength(i) )
                  {
                 // printf ("Offset_For_Ghost_Boundary_Width = %d \n",Offset_For_Ghost_Boundary_Width);
                    printf ("getLength(%d) = %d  != Array_Descriptor.SerialArray->getLength(i) = %d \n",
                         i,getLength(i),Array_Descriptor.SerialArray->getLength(i));
                    printf ("getInternalGhostCellWidth(%d) = %d \n",i,getInternalGhostCellWidth(i));
                    view("In Initialization");
                    APP_ABORT();
                  }
             }
        }
#endif
#endif

#if !defined(PPP)
     POINTER_LIST_INITIALIZATION_MACRO;
#endif

     if (PREINITIALIZE_OBJECT_IN_CONSTRUCTOR)
        {
#if COMPILE_DEBUG_STATEMENTS
       // printf ("NOTE: PREINITIALIZING THE ARRAY AS PART OF INITIALIZATION (PREINITIALIZE_VALUE = %f) \n",(float)PREINITIALIZE_VALUE);
#endif
          operator=(PREINITIALIZE_VALUE);
        }

     Array_Storage = NULL;
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
       // STARTING LIST FOR LIFETIME EXTENSION
          new doubleArray_Operand_Storage ( *this );
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from doubleArray::preInitializeArray");
#endif
   }

// inline void
// doubleArray::Initialize_Array ( int Number_Of_Valid_Dimensions , 
//                               const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                               bool Force_Memory_Allocation )
inline void
doubleArray::initializeArray ()
   {
// *************************************************************************
// This function is used internally in the constructors below
// *************************************************************************

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of doubleArray::initializeArray() (this = %p)\n",this);
        }
#endif

  // Call a common function to both initializeArray functions
     preInitializeArray ();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
     Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from doubleArray::initializeArray");
#endif
   }

#if defined(APP) || defined(PPP)
// *************************************************************************
// This function is used internally in the constructors below (for P++ 
// this allows the specification of an existing parallel partitioning object)
// *************************************************************************
// inline void
// doubleArray::Initialize_Array ( int Number_Of_Valid_Dimensions , 
//                               const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                               const Partitioning_Type & Partition , 
//                               bool Force_Memory_Allocation )
inline void
doubleArray::initializeArray ( const Internal_Partitioning_Type & Partition )
   {
  // Note that since we have moved the Array_Descriptor to be an object in the array object instead
  // of pointed to from the array object there is less fr this function to do and so the
  // Number_Of_Valid_Dimensions and the Array_Size input variables are no longer used
  // (except for printing debugging information).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of doubleArray::initializeArray(Internal_Partitioning_Type&) (this = %p)\n",this);
       // printf (" (this = %p) \n",this);
        }
#endif

     if (&Partition);

#if 0
// (11/19/2000) The partitioning object should already be initialized
#if defined(PPP)
  // Initialize to use the input partitioning object
     Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = &((Internal_Partitioning_Type&)Partition);

  // Bugfix (11/12/2000) It seems that incrementing the reference count was forgotten here!
     Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->incrementReferenceCount();
#endif
#endif

  // Call a common function to both Initialize_Array functions
     preInitializeArray ();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL);
     Internal_Partitioning_Type::AddArrayToPartitioning(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from doubleArray::initializeArray(Internal_Partitioning_Type&)");
#endif
   }

inline void
doubleArray::initializeArray ( const Partitioning_Type & Partition )
   {
  // Note that since we have moved the Array_Descriptor to be an object in the array object instead
  // of pointed to from the array object there is less fr this function to do and so the
  // Number_Of_Valid_Dimensions and the Array_Size input variables are no longer used
  // (except for printing debugging information).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of doubleArray::initializeArray (Partitioning_Type&) ");
       // printf (" (this = %p) \n",this);
        }
#endif

  // Call the version taking the Internal_Partitioning_Type
     initializeArray (*(Partition.getInternalPartitioningObject()));
   }
#endif


// *********************************************************
// *********************************************************
// ********************  CONSTRUCTORS  *********************
// *********************************************************
// *********************************************************

// ***************************************************************
// This constructor is used by the Defered Evaluation code to build
// A++ objects from a pointer to data and a descriptor.
// ***************************************************************
#if 0
// This function is commented out since we are testing 
// the current compilation of P++
// This function is called in lazy_operand.C!
// I don't think it is implemented correctly and I don't want to support it.

#if defined(PPP)
doubleArray::doubleArray( const doubleSerialArray* SerialArray_Pointer , 
   doubleArray_Descriptor_Type* 
   Array_Descriptor_Pointer, Operand_Storage* Array_Storage_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
// This may not be the right Array_Descriptor constructor to use???
// : Array_Descriptor(SerialArray_Pointer,Array_Descriptor_Pointer,Array_Storage_Pointer)
   : Array_Descriptor()
#endif
#else
doubleArray::doubleArray( const double* Array_Data_Pointer , 
   doubleArray_Descriptor_Type* 
   Array_Descriptor_Pointer , Operand_Storage* Array_Storage_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
// This may not be the right Array_Descriptor constructor to use???
// : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer,Array_Storage_Pointer)
   : Array_Descriptor()
#endif
#endif
   {
#if defined(USE_TAU)
     TAU_PROFILE("doubleArray::doubleArray()", "void(double*,doubleArray_Descriptor_Type*)", TAU_APP_CONSTRUCTORS);
#endif
  // This function is not used except in the lazy evaluation (one of them files)!

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
#if defined(PPP)
          printf ("Using the constructor 'doubleArray (doubleSerialArray*,Array_Descriptor_Type*,Operand_Storage*)'! \n");
       // printf ("Using the constructor 'doubleArray (doubleSerialArray*,Array_Domain_Type*,Operand_Storage*)'! \n");
#else
          printf ("Using the constructor 'doubleArray (double*,Array_Descriptor_Type*,Operand_Storage*)'! \n");
       // printf ("Using the constructor 'doubleArray (double*,Array_Domain_Type*,Operand_Storage*)'! \n");
#endif
        }
#endif

  // **********************************************************************************************
     printf ("I think this function is not used except in lazy evaluation \n");
     printf ("    It uses an older construction mechanism that uses the operator= \n");
     printf ("    Untill this is corrected I think this function should be disabled! \n");
     printf ("Exiting in doubleArray (doubleSerialArray*,Array_Descriptor_Type*,Operand_Storage*) \n");
     APP_ABORT();
  // **********************************************************************************************

  // This forces a copy of the descriptor data into the descriptor member in the array
  // at some point this will be an important issue to optimize since we want to avoid
  // building a descriptor to initialize the array's descriptor only to then
  // throw away the first descriptor.  So this is an efficency issue.
     Array_Descriptor = *Array_Descriptor_Pointer;
#if defined(PPP)
     Array_Descriptor.SerialArray      = (doubleSerialArray*) SerialArray_Pointer;
#else
     Array_Descriptor.Array_Data       = (double*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
#endif
     Array_Storage    = Array_Storage_Pointer;
     referenceCount   = getReferenceCountBase();
   }
// commented out!
#endif

// *******************************************************************************
// This is the default constructor it builds a NULL array (an array with no data).
// *******************************************************************************
doubleArray::doubleArray() 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor()
#endif
   {
  // Note that a nullArray does not have a partitioning object since it's partitioning will 
  // defined only at the point where it has data (i.e. not yet)

  // Possible improvement to this implementation:
  //    1: Call the initializeArray function!

#if defined(USE_TAU)
     TAU_PROFILE("doubleArray::doubleArray()", "void(void)", TAU_APP_CONSTRUCTORS);
#endif

  // The default constructor for the Array_Descriptor sets up a NULL Array
  // (meaning an array with no data) so we have Array_Data = NULL.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Call doubleArray::doubleArray() DEFAULT Constructor (this = %p) \n",this);
#endif

     Array_Storage    = NULL;
     referenceCount   = getReferenceCountBase();

#if defined(PPP)
  // Should this be NULL or a pointer to a NULL doubleSerialArray
  // Bugfix (12/14/94) a NULL P++ array contains a pointer to a NULL A++ array
  // It would be more efficient if it could be a NULL pointer but it would
  // make the implementation more complex so we force a P++ NULL array to 
  // have an A++ NULL array (since then we have to check the pointer for NULL
  // and we can't assert that the ponter is always non-NULL).
     Array_Descriptor.SerialArray = new doubleSerialArray();
#else
     Array_Descriptor.Array_Data = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

     Array_Storage    = NULL;
     referenceCount   = getReferenceCountBase();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
  // Internal_Partitioning_Type::DefaultdoubleArrayList.addElement(*this);
     Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

  // printf ("At BASE of default constructor doubleArray::doubleArray() Array_ID() = %d  getRawDataReferenceCount() = %d \n",Array_ID(),getRawDataReferenceCount());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from default constructor doubleArray::doubleArray()");
#endif
   }

// ***************************************************************
// This function allows the construction of an A++ array object 
// using an existing meory pointer.
// ***************************************************************
#if defined(PPP)
// doubleArray::doubleArray ( double* Data_Pointer , int i , const Range & Range_I , 
//                                           int j , const Range & Range_J ,
//                                           int k , const Range & Range_K ,
//                                           int l , const Range & Range_L )
doubleArray::doubleArray ( const double* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE)
#endif
   {
  // To use existing data in the parallel environment we have to specify the global size
  // and the base/bound (using the Range object).  The base of the global array is set to 
  // ZERO.  It can be reset after construction if required.

#if defined(USE_TAU)
     TAU_PROFILE("doubleArray::doubleArray()", "void(double*,int,int,int,int,int,int)", TAU_APP_CONSTRUCTORS);
#endif
  // This constructor uses existing data and builds a P++ array that encloses it
  // Range objects are used to specify the local processor's partition of the data

     INTEGER_AND_RANGE_ARGUMENTS_TO_INTEGER_AND_CONST_REF_RANGE_LIST_MACRO

     printf ("Sorry, not implemented: doubleArray::doubleArray ( const double* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE ) \n");
     printf ("     We can't yet support arbitrary distributions such as has been specified ... \n");
     APP_ABORT();

  // Initialize the pointers befor calling adopt
  // Array_Descriptor = NULL;
     Array_Descriptor.SerialArray      = NULL;
     referenceCount   = getReferenceCountBase();

  // Build default partition for use within adopt.  This is not likely the
  // correct partition to use here so this should be passed in as an option when the
  // parallel adopt function is implemented.
     Partitioning_Type Partition;
  // It is simple to just call the adopt function!
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase());
     adopt ( Data_Pointer , Partition, Integer_List , Internal_Index_List );
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

     APP_ASSERT (Array_Descriptor.Array_Domain.builtUsingExistingData == TRUE);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor doubleArray::doubleArray(double*,ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE)");
#endif
   }

// end of if defined(PPP)
#else
// else for if not defined(PPP)

// doubleArray::doubleArray ( double* Data_Pointer , int i , int j , int k , int l )
doubleArray::doubleArray ( const double* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_INTEGER)
#endif
   {
#if defined(USE_TAU)
     TAU_PROFILE("doubleArray::doubleArray()", "void(double*,int,int,int,int,int,int)", TAU_APP_CONSTRUCTORS);
#endif

  // Should we call the more general initialization 
  // (it would allocate data -- so I guess not!)
     referenceCount   = getReferenceCountBase();
     Array_Storage    = NULL;
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor doubleArray::doubleArray(double*,ARGUMENT_LIST_MACRO_INTEGER)");
#endif
   }
#endif

// *****************************************************************
// Constructor using existing memory and Range objects
// *****************************************************************
#if !defined(PPP)
doubleArray::doubleArray ( const double* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_CONST_REF_RANGE)
#endif
   {
  // Should we call the more general initialization 
  // (though it would allocate data so I guess not)
     referenceCount   = getReferenceCountBase();
     Array_Storage    = NULL;
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

  // printf ("Exiting in doubleArray::doubleArray ( const double* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE ) \n");
  // APP_ABORT();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor doubleArray::doubleArray(double*,ARGUMENT_LIST_MACRO_CONST_REF_RANGE)");
#endif
   }
#endif

// ************************************************************
// Copy constructor should not be used often since it really 
// makes a deep copy (as a good copy constructor should)!
// ************************************************************
doubleArray::doubleArray( const doubleArray & X , int Type_Of_Copy ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(X.Array_Descriptor,Type_Of_Copy)
#endif
   {
  // If the user passes parameters by value (instead of by reference) then we 
  // are forced to abide by his/her wishes and do the required copying.  It is most
  // likely however that he/she wants to pass by reference for better efficiency.
  // There is nothing that the array class should do to provide what we might think
  // the user wants since passing by value provides a level of protection against 
  // function side effects that the user might have specifically choosen.

  // There are different types of copies:
  //    Shallow Copy
  //        Don't really copy anything (just make a new reference to the existing data)
  //        This is NOT the default!
  //        Supported value: SHALLOWCOPY
  //    Deep Copy
  //        Deep Collapsed Copy
  //             Current functionality of the Deep Copy option.
  //             This IS the default!
  //             Supported value: DEEPCOPY or DEEPCOLAPSEDCOPY
  //        Deep Aligned Copy
  //             Build copy to be same size as original array (might be inefficient)
  //             Supported value: DEEPALIGNEDCOPY
  //        Deep Collapsed and Aligned Copy
  //             This requires additional support from PADRE (table based distributions)
  //             Supported value: DEEPCOLAPSEDALIGNEDCOPY

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("*********************************************** \n");
          printf ("*********************************************** \n");
          printf ("Using the copy constructor doubleArray(const doubleArray & X) (X.Array_ID() = %d) \n",X.Array_ID());
          printf ("*********************************************** \n");
          printf ("*********************************************** \n");
        }
     X.Test_Consistency ("X called from COPY constructor doubleArray::doubleArray(doubleArray)");
#endif

#if !defined(PPP)
  // This does not make sense for P++ (I think)???
  // Since this is a new array object it should have an initialize referenced count on its
  // raw data.  This is required here because the reference counting mechanism reused the
  // value of zero for an existing reference and no references (this will be fixed soon).
  // (5/1/2000) The reference count base is now 1 so it is fixed now -- I suspect this is no longer required!
     resetRawDataReferenceCount();
#endif

#if defined(PPP)
     Array_Descriptor.SerialArray = NULL;
#else
  // Since we will allocate new data we need to initialize this to NULL
  // prior to calling the Allocate_Array_Data member function
     Array_Descriptor.Array_Data  = NULL;
  // ... bug fix (10/9/96,kdb) this was fixed a while ago but got lost.  The
  // descriptor pointer needs to be initialized as well as the data pointer ...
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif
     Array_Storage  = NULL;
     referenceCount = getReferenceCountBase();

#if 0
  // error checking
     if ( (Type_Of_Copy != DEEPCOPY) && (Type_Of_Copy != SHALLOWCOPY) )
        {
          printf ("ERROR: Type_Of_Copy neither DEEPCOPY nor SHALLOWCOPY \n");
          APP_ABORT();
        }
#endif

#if 0
  // Example source code (from Brian) showing how to build the ALIGNED_COPY mechanism
     cout<<" J.getRawBase(0)= "<<J.getRawBase(0)<<"  J.getRawBound(0)= "<<J.getRawBound(0)<<"  J.getRawStride(0)= "<<J.getRawStride(0)<<endl;
     J.getFullRange(0).display("J.getFullRange(0)");
     intArray TT(Range(J.getFullRange(0).getBase(),J.getFullRange(0).getBound()));
     J.dimension(0).display("J.dimension(0)");  
     intArray T = TT(Range(J.getRawBase(0),J.getRawBound(0),J.getRawStride(0)));
#endif

  // Code in progress to redo how we handle different cases of Type_Of_Copy and include additional cases
     bool Force_Memory_Allocation = TRUE;
     int Old_Array_Id                = Array_Descriptor.Array_ID();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
  // This must be called before the Allocate_Array_Data function
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
        {
          Internal_Partitioning_Type::AddArrayToPartitioning(*this);
        }
       else
        {
          Internal_Partitioning_Type::AddArrayToPartitioning (*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
        }
#endif

  // The copy constructor supports several different types of copy semantics
     switch (Type_Of_Copy)
        {
          case SHALLOWCOPY:
            // This is the simplist case of the copy constructor (but not often very useful)
               reference (X);
               break;

          case DEEPCOLAPSEDCOPY:
          case DEEPCOPY:
            // printf ("In Array copy constructor - the Array_Descriptor should allocate the data! \n");

            // The copy constructor has to allocate space even if 
            // DEFER_EXPRESSION_EVALUATION == TRUE
               setTemporary(FALSE);

            // (19/2/98) This is a fix to skip the allocation of data and force it to be
            // allocated by the operator= only if required.  The result is more efficient code.
            // If the input is a temporary then this code could be written more efficiently!
            // printf ("Inefficent Operation: COPY constructor is forced to allocate data even if input is a temporary! \n");
               Allocate_Array_Data ( Force_Memory_Allocation );

               APP_ASSERT (isTemporary() == FALSE);

            // Error checking (make sure not a view)
            // Since we just made a copy this object is NOT a view! 
               if (Array_Descriptor.usesIndirectAddressing())
                  {
                 // printf ("WARNING: copy constructor built a view using intArrays (correcting)! \n");
                 // Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                 // for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                 //      Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 0)
                       {
                         printf ("WARNING: copy constructor built a view using intArrays (correcting by deleting indirection intArrays)! \n");
                       }
#endif
                    Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                    for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                       {
                      // (5/1/2000) valid pointers were previously just set to NULL.
                      // This caused a bug when the reference count of the indirection 
                      // intArray was not decremented properly and the delete operator
                      // called when there are no more references.
                         if (Array_Descriptor.Array_Domain.Index_Array[i] != NULL)
                            {
                              Array_Descriptor.Array_Domain.Index_Array[i]->decrementReferenceCount();
                              if (Array_Descriptor.Array_Domain.Index_Array[i]->getReferenceCount() < intArray::getReferenceCountBase())
                                   delete Array_Descriptor.Array_Domain.Index_Array[i];
                              Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
                            }
                       }
                  }

#if !defined(PPP)
            // this can't be a view
               POINTER_LIST_INITIALIZATION_MACRO;
#endif

            // Call operator=
            // If the operator= can just steal the data and void a deep copy then it will
            // do so and then delete the memory allocated a few lines above!
            // printf ("Assignement commented out in doubleArray::COPY CONSTRUCTOR! \n");
            // printf ("Assignement in doubleArray::COPY CONSTRUCTOR! \n");
            // APP_DEBUG = 1;
               *this = X;
            // APP_DEBUG = 0;
               break;

          case DEEPALIGNEDCOPY:
            // intArray Copy (Range(X.getFullRange(0).getBase(),X.getFullRange(0).getBound()));
            // printf ("DEEPALIGNEDCOPY not supported yet! \n");
            // APP_ABORT();
            // printf ("In Array copy constructor - the Array_Descriptor should allocate the data! \n");

            // The copy constructor has to allocate space even if 
            // DEFER_EXPRESSION_EVALUATION == TRUE
               setTemporary(FALSE);

            // (19/2/98) This is a fix to skip the allocation of data and force it to be
            // allocated by the operator= only if required.  The result is more efficient code.
            // If the input is a temporary then this code could be written more efficiently!
            // printf ("Inefficent Operation: COPY constructor is forced to allocate data even if input is a temporary! \n");
               Allocate_Array_Data ( Force_Memory_Allocation );

               APP_ASSERT (isTemporary() == FALSE);

            // Error checking (make sure not a view)
            // Since we just made a copy this object is NOT a view! 
               if (Array_Descriptor.usesIndirectAddressing())
                  {
                 // printf ("WARNING: copy constructor built a view using intArrays (correcting)! \n");
                 // Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                 // for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                 //      Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 0)
                       {
                         printf ("WARNING: copy constructor built a view using intArrays (correcting be deleting indirection intArrays)! \n");
                       }
#endif
                    Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                    for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                       {
                      // (5/1/2000) valid pointers were previously just set to NULL.
                      // This caused a bug when the reference count of the indirection 
                      // intArray was not decremented properly and the delete operator
                      // called when there are no more references.
                         if (Array_Descriptor.Array_Domain.Index_Array[i] != NULL)
                            {
                              Array_Descriptor.Array_Domain.Index_Array[i]->decrementReferenceCount();
                              if (Array_Descriptor.Array_Domain.Index_Array[i]->getReferenceCount() < intArray::getReferenceCountBase())
                                   delete Array_Descriptor.Array_Domain.Index_Array[i];
                              Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
                            }
                       }
                  }

#if !defined(PPP)
            // this can't be a view
               POINTER_LIST_INITIALIZATION_MACRO;
#endif

            // Call operator=
            // If the operator= can just steal the data and void a deep copy then it will
            // do so and then delete the memory allocated a few lines above!
            // printf ("Assignement commented out in doubleArray::COPY CONSTRUCTOR! \n");
            // APP_DEBUG = 1;

            // printf ("Now call the assignement operator in doubleArray::COPY CONSTRUCTOR! \n");
#if 1
               *this = X;
#else
               printf ("#####  ASSIGNING TO A SCALAR VALUE!!!!!  ##### \n");
               *this = 1;
#endif

            // APP_DEBUG = 0;
               break;

          case DEEPCOLAPSEDALIGNEDCOPY:
               printf ("DEEPCOLAPSEDALIGNEDCOPY not supported yet! \n");
               APP_ABORT();
               break;

          default:
               printf ("ERROR: default reached in COPY Constructor Type_Of_Copy = %d not known \n",Type_Of_Copy);
               APP_ABORT();
               break;
        }

#if defined(PPP)
  // Now update the ghost boundaries with valid data for the neighboring processors
  // Not sure that this is required since the initialization of the local arrays 
  // should have updated the boundaries (at least is special cases).
     updateGhostBoundaries();
#endif

     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
          new doubleArray_Operand_Storage ( *this );
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from COPY constructor doubleArray::doubleArray(doubleArray)");
#endif
   }

#ifdef USE_STRING_SPECIFIC_CODE

#if defined(APP) || defined(SERIAL_APP)
// ************************************************************
// Copy constructor should not be used often since it really 
// makes a deep copy (as a good copy constructor should)!
// ************************************************************
// doubleArray::doubleArray( const char* dataString ) 
doubleArray::doubleArray( const AppString & dataString ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(dataString)
#else
   : Array_Descriptor(dataString)
#endif
   {
     initializeArray ();

#if 1
     char* numberString = strdup(dataString.getInternalString());

  // Now fill in the newly declared array
     char* delimiterList = " {},";
     char* nextSubString = NULL;
     int counter = 0;

     double* dataPointer = getDataPointer();

  // char* nextSubString = strtok(dataString,delimiterList);
  // parseString (nextSubString,numbersString);
     if ( (nextSubString = strtok(numberString,delimiterList)) != NULL )
        {
          printf ("counter = %d nextSubString = %s \n",counter,nextSubString);
#ifdef DOUBLEARRAY
          dataPointer[counter] = atof(nextSubString);
#endif
#ifdef FLOATARRAY
          dataPointer[counter] = atof(nextSubString);
#endif
#ifdef INTARRAY
          dataPointer[counter] = atoi(nextSubString);
#endif
          while ( (nextSubString = strtok(NULL,delimiterList)) != NULL )
             {
               counter++;
               dataPointer[counter] = atoi(nextSubString);
            // printf ("counter = %d nextSubString = %s \n",counter,nextSubString);
             }
        }
#else
     printf ("doubleArray ( const AppString & dataString ) not compiled unless USE_STRING_SPECIFIC_CODE used in compiling A++/P++! \n");
     APP_ABORT();
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor doubleArray::doubleArray(char*)");
#endif
   }

// if defined(APP) || defined(SERIAL_APP)
#endif

// if USE_STRING_SPECIFIC_CODE 
#endif

// *************************************************************************
/* This function is too large for inlining using the AT&T compiler!
   But we might be able to inline the Array_Descriptor_Type at some point
   and that might be worth while since this function is called a lot in A++ */
// *************************************************************************
doubleArray::doubleArray ( int i ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }

#if (MAX_ARRAY_DIMENSION >= 2)
doubleArray::doubleArray ( int i , int j ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 3)
doubleArray::doubleArray ( int i , int j , int k ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 4)
doubleArray::doubleArray ( int i , int j , int k , int l ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 5)
doubleArray::doubleArray ( int i , int j , int k , int l , int m )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 6)
doubleArray::doubleArray ( int i , int j , int k , int l , int m , int n ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 7)
doubleArray::doubleArray ( int i , int j , int k , int l , int m , int n , int o ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 8)
doubleArray::doubleArray ( int i , int j , int k , int l , int m , int n , int o , int p ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,p+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
doubleArray::doubleArray( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor (MAX_ARRAY_DIMENSION,Integer_List)
#endif
   {
     initializeArray();
   }

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
// doubleArray::doubleArray( int Array_Size_I , int Array_Size_J , int Array_Size_K ,
//                       int Array_Size_L , bool Force_Memory_Allocation )
doubleArray::doubleArray( ARGUMENT_LIST_MACRO_INTEGER , bool Force_Memory_Allocation ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor (VARIABLE_LIST_MACRO_INTEGER)
#endif
   {
  // ZERO is an acceptable value for the Array size!

  // Avoid compiler warning for unused input variable
     if (&Force_Memory_Allocation);

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Using the constructor doubleArray::doubleArray (ARGUMENT_LIST_MACRO_INTEGER, bool) ");
          for (int index_var=0; index_var < MAX_ARRAY_DIMENSION; index_var++)
               printf ("int=%d,",Integer_List[index_var]);
          printf (" (this = %p) \n",this);
          printf ("\n");
        }
#endif

     initializeArray();
   }

#if defined(APP) || defined(PPP)
// *************************************************************************
/* This function is too large for inlining using the AT&T compiler!
   But we might be able to inline the Array_Descriptor_Type at some point
   and that might be worth while since this function is called a lot in A++ */
// *************************************************************************
doubleArray::doubleArray ( int i , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }

#if (MAX_ARRAY_DIMENSION >= 2)
doubleArray::doubleArray ( int i , int j , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 3)
doubleArray::doubleArray ( int i , int j , int k , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 4)
doubleArray::doubleArray ( int i , int j , int k , int l , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 5)
doubleArray::doubleArray ( int i , int j , int k , int l , int m , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 6)
doubleArray::doubleArray ( int i , int j , int k , int l , int m , int n , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 7)
doubleArray::doubleArray ( int i , int j , int k , int l , int m , int n , int o , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 8)
doubleArray::doubleArray ( int i , int j , int k , int l , int m , int n , int o , int p , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,p+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
// doubleArray::doubleArray( int Array_Size_I , int Array_Size_J , int Array_Size_K ,
//                       int Array_Size_L , const Partitioning_Type & Partition , bool Force_Memory_Allocation )
doubleArray::doubleArray( ARGUMENT_LIST_MACRO_INTEGER ,
                      const Partitioning_Type & Partition ,
                      bool Force_Memory_Allocation )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
// : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
//                    *Partition.getInternalPartitioningObject())
   : Array_Descriptor(COMPUTE_RANGE_ARGUMENTS_MACRO,
                      *Partition.getInternalPartitioningObject())
#endif
   {
  // Avoid compiler generated warning about unused input variable
     if (&Force_Memory_Allocation);

  // ZERO is an acceptable value for the Array size!
     initializeArray(Partition);
   }
#endif

doubleArray::doubleArray( ARGUMENT_LIST_MACRO_CONST_REF_RANGE ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(VARIABLE_LIST_MACRO_CONST_REF_RANGE)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of constructor doubleArray::doubleArray( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )! \n");
#endif

     initializeArray();
   }

doubleArray::doubleArray( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Internal_Index_List)
#endif
   {
     initializeArray();
   }

#if defined(PPP) || defined (APP)
doubleArray::doubleArray( 
   const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List, 
   const Internal_Partitioning_Type & partition )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Internal_Index_List,partition)
#endif
   {
     initializeArray(partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 2)
// *************************************************************
// We need this constructor to avoid confusion with the copy 
// constructor (ambiguous call problem due to promotion of Range
// to A++ array object).
// *************************************************************
//doubleArray::doubleArray ( const Range & Range_I , int j ) 
//   : Array_Descriptor(Range_I,Range(APP_Global_Array_Base,j))
doubleArray::doubleArray ( const Range & Range_I , int j ) 
   : Array_Descriptor(Range_I,Range(APP_Global_Array_Base,j-1))
#if defined(USE_EXPRESSION_TEMPLATES)
   , InArray<double>(this)
#endif
   {
     initializeArray();
   }
#endif

#if !defined(PPP)
//============================================================================
//============  Constructor used in operator()(Internal_Index)  ==============
//============================================================================
doubleArray::doubleArray( const double* Array_Data_Pointer,
                      const Array_Domain_Type & X,
                      const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this,X,Index_List)
#else
// : Array_Descriptor(Array_Data_Pointer,X,Index_List)
   : Array_Descriptor(X,Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
     Array_Descriptor.Array_Data   = (double*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor doubleArray (double*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

     if (Array_ID() != X.Array_ID())
        {
          view("this: In doubleArray::doubleArray(double*,const Array_Domain_Type & X,const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List)");
          X.display("X: In doubleArray::doubleArray(double*,const Array_Domain_Type & X,const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List)");
        }
     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (double*,Array_Descriptor_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }

//============================================================================
doubleArray::doubleArray( const double* Array_Data_Pointer,
                      const Array_Domain_Type & X,
                      const Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Indirect_Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this,X,Indirect_Index_List)
#else
   : Array_Descriptor(X,Indirect_Index_List)
// : Array_Descriptor(Array_Data_Pointer,X,Indirect_Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
     Array_Descriptor.Array_Data   = (double*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor doubleArray (double*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (double*,Array_Descriptor_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
 // end of not PPP
#endif

//============================================================================
#if defined(PPP)
doubleArray::doubleArray( const doubleSerialArray* SerialArray_Pointer,
                      const Array_Domain_Type & X,
                      const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this,X,Index_List)
#else
   : Array_Descriptor(X,Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif

     Array_Descriptor.SerialArray = (doubleSerialArray*) SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

#if COMPILE_DEBUG_STATEMENTS
     if (SerialArray_Pointer != NULL)
        {
       // APP_ASSERT(SerialArray_Pointer->getDataPointer() != NULL);

          if (APP_DEBUG > 5)
               view("Using the constructor doubleArray (doubleSerialArray*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }
#endif

     APP_ASSERT(Array_ID() == X.Array_ID());
     
  // ... add this fix from other constructor (2/14/96, kdb) ...
  // ... The local part of an indexed view might be a Null Array on some 
  // processors.  On those processors all the Local_Mask_Index objects must 
  // be Null_Index objects. ...
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);
     if (Array_Descriptor.SerialArray->isNullArray() == TRUE)
        {
#if 0
          for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
               Array_Descriptor.Array_Domain.Local_Mask_Index [i] = Internal_Index (0,0,1,Null_Index);
#else
          Array_Descriptor.Array_Domain.resetDomainForNullArray();
#endif

       // (12/13/2000) Added test
          APP_ASSERT (getLeftNumberOfPoints(0) == 0);
          APP_ASSERT (getRightNumberOfPoints(0) == 0);
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (doubleSerialArray*,Array_Descriptor_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }

//============================================================================
doubleArray::doubleArray( const doubleSerialArray* SerialArray_Pointer, 
                      const Array_Domain_Type & X,  
                      const Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type 
		      Indirect_Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this,X,Indirect_Index_List) 
#else
   : Array_Descriptor(X,Indirect_Index_List)
// : Array_Descriptor(SerialArray_Pointer,X,Indirect_Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (doubleSerialArray*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
  // Array_Descriptor.Array_Data   = 
  //	(double*) SerialArray_Pointer.Array_Descriptor.Array_Data;
     Array_Descriptor.SerialArray = (doubleSerialArray*)SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

  // New test (12/13/2000)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     if (SerialArray_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor doubleArray (doubleSerialArray*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // New test (12/13/2000) if this is false then consider calling "getDomain().resetDomainForNullArray();"
          APP_ASSERT (Array_Descriptor.SerialArray->isNullArray() == FALSE);
        }

     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (doubleSerialArray*,Array_Descriptor_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
//============================================================================
doubleArray::doubleArray( const doubleSerialArray* SerialArray_Pointer,
                      const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this,Integer_List)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Integer_List)
// : Array_Descriptor(SerialArray_Pointer,MAX_ARRAY_DIMENSION,Integer_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
     Array_Descriptor.SerialArray = (doubleSerialArray*)SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

  // New test (12/13/2000)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     if (SerialArray_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor doubleArray (doubleSerialArray*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // New test (12/13/2000) if this is false then consider calling "getDomain().resetDomainForNullArray();"
          APP_ASSERT (Array_Descriptor.SerialArray->isNullArray() == FALSE);
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (doubleSerialArray*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
  // end of PPP only section
#endif

//============================================================================

#if !defined(PPP)
// ... this looks like it should only work if not PPP ...
// Support for the following ...
// Temporary_Array = new doubleArray ( Null_Array , 
//                                   &(Lhs.Array_Descriptor.Array_Domain), 
//                                   AvoidBuildingIndirectAddressingView);

doubleArray::doubleArray( const double* Array_Data_Pointer , const Array_Domain_Type* Array_Domain_Pointer, bool AvoidBuildingIndirectAddressingView ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView) 
#else
   : Array_Descriptor(*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
// : Array_Descriptor(Array_Data_Pointer,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Domain_Type*)'! \n");
#endif
     Array_Descriptor.Array_Data   = (double*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;

#if !defined(PPP)
  // Since this is a new array object is should have an initialize reference count on its
  // raw data.  This is required here because the reference counting mechanism reused the 
  // value of zero for one existing reference and no references (this will be fixed soon).
     resetRawDataReferenceCount();
#endif
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor doubleArray (double*,Array_Domain_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // If we have valid data then it should have a reference count showing that
       // there is an external reference.
          incrementRawDataReferenceCount();
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (double*,Array_Descriptor_Type*,bool)");
#endif
   }
#endif // end of not PPP

//============================================================================

#if defined(PPP)
// Support for the following ...
// Temporary_Array = new doubleArray ( Null_Array , 
//                                   &(Lhs.Array_Descriptor.Array_Domain), 
//                                   AvoidBuildingIndirectAddressingView);

doubleArray::doubleArray(
     doubleSerialArray* SerialArray_Pointer , 
     const Array_Domain_Type* Array_Domain_Pointer, 
     bool AvoidBuildingIndirectAddressingView ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView) 
#else
   : Array_Descriptor(*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
// : Array_Descriptor(SerialArray_Pointer,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Domain_Type*)'! \n");
#endif
     Array_Descriptor.SerialArray   = (doubleSerialArray*)SerialArray_Pointer;
     referenceCount                 = getReferenceCountBase();
     Array_Storage                  = NULL;

     if (SerialArray_Pointer != NULL)
        {
          APP_ASSERT (SerialArray_Pointer != NULL);
#if 1
       // We need to adjust the base of the local array for account for the base of the 
       // parallel array object.  This makes more sense than the other way around.
          int i = 0;
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
            // set the bases of the SerialArray to match that of the ParallelArray
            // built using the input Array_Domain_Pointer
            // APP_ASSERT (Array_Descriptor.Array_Domain.Global_Index[i].getMode()     != Null_Index); 
            // APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != Null_Index); 
               int Global_Difference = 0;
               int Local_Difference  = 0;

               if (Array_Descriptor.Array_Domain.Global_Index[i].getMode() != Null_Index) 
                    Global_Difference = 
                         Array_Descriptor.Array_Domain.Global_Index[i].getBase() -
                         Array_Descriptor.Array_Domain.getRawBase(i);

               if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != Null_Index) 
                    Local_Difference = 
                         Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() -
                         SerialArray_Pointer->Array_Descriptor.Array_Domain.getRawBase(i);
#if 0
               printf ("SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",
                    i,SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i]);
               printf ("Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",
                    i,Array_Descriptor.Array_Domain.Data_Base[i]);
               printf ("Array_Domain_Pointer->Data_Base[%d] = %d \n",
                    i,Array_Domain_Pointer->Data_Base[i]);
               printf ("Array_Domain_Pointer->getBase(%d) = %d \n",
                    i,Array_Domain_Pointer->getBase(i));
               printf ("SerialArray_Pointer->getBase(%d) = %d \n",
                    i,SerialArray_Pointer->getBase(i));
            // int newBase = Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase();
            // printf ("newBase = %d \n",newBase);
            // ((doubleSerialArray*)SerialArray_Pointer)->setBase(newBase,i);
            // SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] = newBase;;
               printf ("Global_Difference = %d \n",Global_Difference);
               printf ("Local_Difference  = %d \n",Local_Difference);
            // Array_Descriptor.Array_Domain.Data_Base[i] = 
            //      Array_Descriptor.Array_Domain.Global_Index[i].getBase();
            // SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] = 
            //      Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase();
#endif
               Array_Descriptor.Array_Domain.Data_Base[i] += Global_Difference;
               Array_Descriptor.Array_Domain.User_Base[i] += Global_Difference;
               SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] += Local_Difference;
               SerialArray_Pointer->Array_Descriptor.Array_Domain.User_Base[i] += Local_Difference;
             }
#endif

          SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

          if (APP_DEBUG > 5)
               view("Using the constructor doubleArray (double*,Array_Domain_Type*)");

#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif

#if 0
       // Test (11/12/2000) Maybe this should be in the descriptor?
       // Added to reflect that temoraries will be deleted when used within serial array operations
       // and we want them to last until they are deleted by the parallel array object.
          if (SerialArray_Pointer->isTemporary() == TRUE)
             {
               SerialArray_Pointer->incrementReferenceCount();
               APP_ASSERT (SerialArray_Pointer->getReferenceCount() > 1);
             }
#endif
        }

  // We might need this!
  // resetRawDataReferenceCount();
  // incrementRawDataReferenceCount();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (double*,Array_Descriptor_Type*)");
#endif
   }
#endif  // end of PPP only


//============================================================================

#if !defined(PPP)
#if 0
// All of these are commented out!!!
doubleArray::doubleArray
   ( const double* Array_Data_Pointer , 
     const intArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (double*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor doubleArray (double*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (double*,Array_Descriptor_Type*)");
#endif
   }

doubleArray::doubleArray
   ( const double* Array_Data_Pointer , 
     const floatArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (double*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor doubleArray (double*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (double*,Array_Descriptor_Type*)");
#endif
   }

doubleArray::doubleArray
   ( const double* Array_Data_Pointer , 
     const doubleArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'doubleArray (double*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (double*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor doubleArray (double*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor doubleArray::doubleArray (double*,Array_Descriptor_Type*)");
#endif
   }
  // end of if 0
#endif
  // end of !PPP
#endif



// *********************************************************
// *********************************************************
// ******************  MEMBER FUNCTIONS  *******************
// *********************************************************
// *********************************************************

doubleArray &
doubleArray::seqAdd ( double Base , double Stride )
   {
// ***************************************************************
// This function allows the initialization of an array with 
// incremeted values.
// ***************************************************************

#if defined(USE_TAU)
     TAU_PROFILE("doubleArray::seqAdd()", "void(double,double)", TAU_APP_USER_FUNCTIONS);
#endif
  // This function intializes the data to be sequentially valued starting
  // at the Base value and continuing with Stride to the end of the array.
  // It does not touch the array data directly since this is the job of the 
  // MDI functions (or the operator() which take scalars).  This function uses the
  // operator() member function to initialize the actual data since in the CM-5 
  // implementation the data is not directly addressable at the C++ level!

  // because this function is implemented using scalar indexing it is very slow
  // especially in the P++ parallel environment.

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from doubleArray::seqAdd(Base,Stride)");
#endif

#if !defined(CRAY)
     double Counter = Base;

  // The use of multiple function call here is not very important 
  // since this is not often a time critical function and would be inlined!
#if 0
     APP_ASSERT (MAX_ARRAY_DIMENSION == 4);

     printf ("We really should use the dimension independent case!  Exiting ... \n");
     APP_ABORT();

     int Base_I = getBase(0);
     int Base_J = getBase(1);
     int Base_K = getBase(2);
     int Base_L = getBase(3);

     int Bound_I = getBound(0);
     int Bound_J = getBound(1);
     int Bound_K = getBound(2);
     int Bound_L = getBound(3);

     for (int l=Base_L; l <= Bound_L; l++)
        {
          for (int k=Base_K; k <= Bound_K; k++)
             {
               for (int j=Base_J; j <= Bound_J; j++)
                  {
                    for (int i=Base_I; i <= Bound_I; i++)
                       {
                         (*this)(i,j,k,l) = Counter;
                         Counter += Stride;
                       }
                  }
             }
        }
#else
     APP_ASSERT (MAX_ARRAY_DIMENSION <= 8);
  // Dimension independent code!
     int Array_Base[MAX_ARRAY_DIMENSION];
     int Array_Bound[MAX_ARRAY_DIMENSION];
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          Array_Base [temp] = getBase (temp);
          Array_Bound[temp] = getBound(temp);
        }

#if defined(PPP)
  // Get a view of the whole serial array including ghost boundaries so 
  // that they can be initialized properly without any communication.
     const doubleSerialArray & localArray = getLocalArrayWithGhostBoundaries();

  // these are used to simplify code
     int localArrayBase0  = Array_Descriptor.Array_Domain.getLocalMaskIndex(0).getBase();
     int localArrayBound0 = Array_Descriptor.Array_Domain.getLocalMaskIndex(0).getBound();
#if MAX_ARRAY_DIMENSION > 1
     int localArrayBase1  = Array_Descriptor.Array_Domain.getLocalMaskIndex(1).getBase();
     int localArrayBound1 = Array_Descriptor.Array_Domain.getLocalMaskIndex(1).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 2
     int localArrayBase2  = Array_Descriptor.Array_Domain.getLocalMaskIndex(2).getBase();
     int localArrayBound2 = Array_Descriptor.Array_Domain.getLocalMaskIndex(2).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 3
     int localArrayBase3  = Array_Descriptor.Array_Domain.getLocalMaskIndex(3).getBase();
     int localArrayBound3 = Array_Descriptor.Array_Domain.getLocalMaskIndex(3).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 4
     int localArrayBase4  = Array_Descriptor.Array_Domain.getLocalMaskIndex(4).getBase();
     int localArrayBound4 = Array_Descriptor.Array_Domain.getLocalMaskIndex(4).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 5
     int localArrayBase5  = Array_Descriptor.Array_Domain.getLocalMaskIndex(5).getBase();
     int localArrayBound5 = Array_Descriptor.Array_Domain.getLocalMaskIndex(5).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 6
     int localArrayBase6  = Array_Descriptor.Array_Domain.getLocalMaskIndex(6).getBase();
     int localArrayBound6 = Array_Descriptor.Array_Domain.getLocalMaskIndex(6).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 7
     int localArrayBase7  = Array_Descriptor.Array_Domain.getLocalMaskIndex(7).getBase();
     int localArrayBound7 = Array_Descriptor.Array_Domain.getLocalMaskIndex(7).getBound();
#endif
#endif

  // Avoid compiler warnings by only declaring the ones that we use (1-MAX_ARRAY_DIMENSION)
     int i;
#if MAX_ARRAY_DIMENSION > 1
     int j;
#endif
#if MAX_ARRAY_DIMENSION > 2
     int k;
#endif
#if MAX_ARRAY_DIMENSION > 3
     int l;
#endif
#if MAX_ARRAY_DIMENSION > 4
     int m;
#endif
#if MAX_ARRAY_DIMENSION > 5
     int n;
#endif
#if MAX_ARRAY_DIMENSION > 6
     int o; 
#endif
#if MAX_ARRAY_DIMENSION > 7
     int p;
#endif

  // With more work we could make this more thoughly dimension independent
  // by using the same techniques as in the MDI code!
  // int i; int j; int k; int l; int m; int n; int o; int p;
     switch (numberOfDimensions())
        {
          case 0 : // Do nothing (nothing to do)!
               break;
          case 1 :
#if defined(PPP)
               for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                  {
                    if ((i >= localArrayBase0) && (i <= localArrayBound0))
                         localArray(i) = Counter;
                    Counter += Stride;
                  }
#else
               for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                  {
                    (*this)(i) = Counter;
                    Counter += Stride;
                  }
#endif
               break;
#if MAX_ARRAY_DIMENSION > 1
          case 2 :
#if defined(PPP)
               for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                    for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                       {
                         if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                             (j >= localArrayBase1) && (j <= localArrayBound1))
                              localArray(i,j) = Counter;
                         Counter += Stride;
                       }
#else
               for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                    for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                       {
                         (*this)(i,j) = Counter;
                         Counter += Stride;
                       }
#endif
               break;
#endif
#if MAX_ARRAY_DIMENSION > 2
          case 3 :
#if defined(PPP)
               for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                    for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                         for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                            {
                              if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                  (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                  (k >= localArrayBase2) && (k <= localArrayBound2))
                                   localArray(i,j,k) = Counter;
                              Counter += Stride;
                            }
#else
               for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                    for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                        for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                           {
                             (*this)(i,j,k) = Counter;
                             Counter += Stride;
                           }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 3
          case 4 :
#if defined(PPP)
               for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                    for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                         for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                              for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                 {
                                   if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                       (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                       (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                       (l >= localArrayBase3) && (l <= localArrayBound3))
                                        localArray(i,j,k,l) = Counter;
                                   Counter += Stride;
                                 }
#else
               for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                   for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                        for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                             for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                {
                                  (*this)(i,j,k,l) = Counter;
                                  Counter += Stride;
                                }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 4
          case 5 :
#if defined(PPP)
               for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                    for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                         for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                              for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                   for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                      {
                                        if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                            (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                            (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                            (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                            (m >= localArrayBase4) && (m <= localArrayBound4))
                                             localArray(i,j,k,l,m) = Counter;
                                        Counter += Stride;
                                      }
#else
               for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                   for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                        for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                             for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                  for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                     {
                                       (*this)(i,j,k,l,m) = Counter;
                                       Counter += Stride;
                                     }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 5
          case 6 :
#if defined(PPP)
               for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                    for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                         for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                              for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                   for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                        for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                           {
                                             if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                 (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                 (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                 (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                 (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                 (n >= localArrayBase5) && (n <= localArrayBound5))
                                                  localArray(i,j,k,l,m,n) = Counter;
                                             Counter += Stride;
                                           }
#else
               for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                   for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                        for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                             for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                  for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                       for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                          {
                                            (*this)(i,j,k,l,m,n) = Counter;
                                            Counter += Stride;
                                          }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 6
          case 7 :
#if defined(PPP)
               for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                    for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                         for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                              for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                   for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                        for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                             for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                {
                                                  if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                      (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                      (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                      (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                      (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                      (n >= localArrayBase5) && (n <= localArrayBound5) &&
                                                      (o >= localArrayBase6) && (o <= localArrayBound6))
                                                       localArray(i,j,k,l,m,n,o) = Counter;
                                                  Counter += Stride;
                                                }
#else
               for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                   for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                        for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                             for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                  for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                       for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                            for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                               {
                                                 (*this)(i,j,k,l,m,n,o) = Counter;
                                                 Counter += Stride;
                                               }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 7
          case 8 :
#if defined(PPP)
               for (p=Array_Base[7]; p <= Array_Bound[7]; p++)
                    for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                         for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                              for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                                   for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                        for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                             for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                                  for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                     {
                                                       if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                           (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                           (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                           (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                           (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                           (n >= localArrayBase5) && (n <= localArrayBound5) &&
                                                           (o >= localArrayBase6) && (o <= localArrayBound6) &&
                                                           (p >= localArrayBase7) && (p <= localArrayBound7))
                                                            localArray(i,j,k,l,m,n,o,p) = Counter;
                                                       Counter += Stride;
                                                     }
#else
               for (p=Array_Base[7]; p <= Array_Bound[7]; p++)
                   for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                        for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                             for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                                  for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                       for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                            for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                                 for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                    {
                                                      (*this)(i,j,k,l,m,n,o,p) = Counter;
                                                      Counter += Stride;
                                                    }
#endif
                   break;
#endif
          default: printf ("ERROR: Default reached in switch statement in doubleArray::seqAdd \n");
                   APP_ABORT();
        }
#endif
#else
     printf ("ERROR: FUNCTION DISABLED ON CRAY Y-MP -- doubleArray::seqAdd function generates internal compiler error \n");
     printf ("       NO WORK AROUND HAS BEEN FOUND! \n");
     APP_ABORT();
#endif

     return *this;
   }

#if defined(INTARRAY)
#if 0
// *****************************************************************************************
// Function not supported since it allows to two paths to build an intArray: intArray(1) 
// and intArray(Index(1)) which is ambiguous to the C++ compiler if required for autopromotion!
// It might be allowed now that there are special operator() for each possilbe case of mixing scalar
// with intArray in the indirect addressing of A++ array object!
// *****************************************************************************************
intArray::intArray ( const Internal_Index & X ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<double>(this)
#endif
   {
  // Convert an Index to an intArray to support mixed intArray and Index object indexing!
  // Later this function will access the chache of readonly intArray objects 
  // for use with indexing!

#if EXTRA_ERROR_CHECKING
     if (X.getMode() == All_Index)
        {
          printf ("ERROR: Can't convert Index object with mode All_Index to intArray! \n");
          X.display();
          printf ("ERROR in intArray::intArray ( const Index & X ) (see explanation above!) \n");
          APP_ABORT();
        }
#endif

  // Build a descriptor for a 1D array! Null_Index generates a Null intArray
     if (X.getMode() == Null_Index)
          //Array_Descriptor = new Array_Descriptor_Type ();
          Array_Descriptor = 
	     new doubleArray_Descriptor_Type();
       else
          Array_Descriptor = 
	     new doubleArray_Descriptor_Type
	        (X.length(),1,1,1);
          //Array_Descriptor = new Array_Descriptor_Type (X.length(),1,1,1);

  // APP_ASSERT( Array_Descriptor != NULL );

  // Allocate array memory!
     Allocate_Array_Data (TRUE);
     Array_Storage  = NULL;
     referenceCount = getReferenceCountBase();

     if (X.getMode() == Index_Triplet)
          seqAdd (X.getBase(),X.getStride());
   }
#endif

// *****************************************************************************************
// This function initializes the elements of the result array with the  i n d e x  positions
// of the nonzero entries of the Lhs array.  It is used to build an  i n d e x  map into
// an array.  Typically it is used on the intArray result from a relational operator!
// For example: intArray indexMap = (A == 5).Build_indexMap();  
// indexMap is an array (of length cooresponding to the number of elements of A with 
// value 5) with values equal to the  i n d e x  position in A where the values was 5.
// Thus function only makes sense in 1D - so we only handle that case!
// later we will make it return the positions along each axis so that it can handle
// multidimensional array masks.
// *****************************************************************************************
#if !defined(USE_EXPRESSION_TEMPLATES)
#if defined(PPP)
intArray & 
intArray::indexMap ()
   {
#if defined(USE_TAU)
     TAU_PROFILE("intArray::indexMap()", "void(double,double)", TAU_APP_USER_FUNCTIONS);
#endif
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of intArray::indexMap() (P++ specific)\n");

     Test_Consistency ("Called from intArray::indexMap() (P++ specific)");
#endif

  // printf ("ERROR: P++ intArray::indexMap not implemented! \n");
  // APP_ABORT();

     intSerialArray *Serial_Index_Map = &( Array_Descriptor.SerialArray->indexMap() );
     APP_ASSERT(Serial_Index_Map != NULL);
     int Number_Of_Nonzero_Elements   = Serial_Index_Map->elementCount();
     int Num_Dims = Serial_Index_Map->numberOfDimensions();
     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;
     Integer_List[0] = Number_Of_Nonzero_Elements;
     Integer_List[1] = Num_Dims;
     int temp;
     for (temp=2; temp < MAX_ARRAY_DIMENSION; temp++)
          Integer_List[temp] = 0;
     intArray *Return_Index_Map     = new intArray
      (Serial_Index_Map, Integer_List);
    //(Serial_Index_Map , 
    //new doubleArray_Descriptor_Type(Integer_List));

#if COMPILE_DEBUG_STATEMENTS
     Return_Index_Map->Test_Consistency ("Called from intArray::indexMap() (P++ specific)");
#endif

  // printf ("Exiting from intArray::indexMap () ... \n");
  // APP_ABORT();

  // Since we want A++/P++ to correctly absorb the array when it 
  // is used it needs to be marked as a temporary.
     Return_Index_Map->setTemporary(TRUE);

     return *Return_Index_Map;
   }

// else not defined(PPP)
#else

// A++ and Serial_Array version of indexMap member function
intArray &
intArray::indexMap ()
   {
#if defined(USE_TAU)
     TAU_PROFILE("intArray::indexMap()", "void(double,double)", TAU_APP_USER_FUNCTIONS);
#endif
  // This takes a Mask and returns the intArray with values that coorespond to the 
  // poistions of 1's in the mask.
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of intArray::indexMap() \n");

     Test_Consistency ("Called from intArray::indexMap()");
#endif

#if EXTRA_ERROR_CHECKING
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
          printf ("ERROR: Inside of intArray::indexMap() -- Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION == TRUE (sorry, not supported yet) \n");
          APP_ABORT();
       // doubleArray_Function_15 *Execution_Object = new doubleArray_Function_15 ( indexMap_Function , MDI_Build_Index_Map_Array , *this );
        } 
#endif

  // indexMap could be called for a NULL array object
  // APP_ASSERT (Array_Descriptor.Array_Data != NULL);

  // view ("BEFORE SUM: *this");

  // Any use of (*this) after the next statement will be an error if (*this) is a temporary!
  // The next statement correctly absorbes the temporary (if it is one).  Thus this function
  // manages the memory and lifetime of its data properly.
  // If *this is a temporary then we can't expect to use it so we have to use
  // Mask_Of_Nonzero_Elements explicitly instead
     intArray Mask_Of_Nonzero_Elements = (*this != 0);

     int numberOfNonzeroElements = sum (Mask_Of_Nonzero_Elements);
     int numDims                 = Mask_Of_Nonzero_Elements.numberOfDimensions();

     APP_ASSERT (numDims == numberOfDimensions());

  // printf ("In indexMap: numberOfNonzeroElements = %d numDims = %d \n",numberOfNonzeroElements,numDims);

  // This would be a null array if numberOfNonzeroElements == 0
     intArray *Return_Index_Map = new intArray(numberOfNonzeroElements,numDims);
     APP_ASSERT( Return_Index_Map != NULL );

#if COMPILE_DEBUG_STATEMENTS
     Return_Index_Map->Test_Consistency ("Called from intArray::indexMap()");
#endif

  // printf ("WARNING: Possible error in base usage of indexMap function! \n");

  // Force array bases to zero if not already!
     int temp;
     for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
          if (Return_Index_Map->getBase(temp) != 0)
               Return_Index_Map->setBase (0,temp);

  // Temp code to initialize the returning array object
  // *Return_Index_Map = 0;

#if 1
  // To improve the performance we implement a specialized version 
  // directly for the most common dimensions
     if (numDims == 1)
        {
          double* resultPointer = Return_Index_Map->Array_Descriptor.Array_Data;
          double* arrayPointer  = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_View_Pointer0;

       // APP_ASSERT (resultPointer != NULL);
       // APP_ASSERT (arrayPointer  != NULL);

          int i=0;
          int counter = 0;
          int base   = Mask_Of_Nonzero_Elements.getBase(0);
          int bound  = Mask_Of_Nonzero_Elements.getBound(0);
          int stride = Mask_Of_Nonzero_Elements.getRawStride(0);

       // APP_ASSERT(stride == 1 );

          for (i=base; i <= bound; i += stride)
             {
               if (arrayPointer[i])
                  {
                    resultPointer[counter] = (i/stride);
                    counter++;
                  }
             }
        }
       else
        {
          if (numDims == 2)
             {
               double* resultPointer = Return_Index_Map->Array_Descriptor.Array_Data;
               double* arrayPointer  = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_View_Pointer1;

            // APP_ASSERT (resultPointer != NULL);
            // APP_ASSERT (arrayPointer  != NULL);

               int i=0;
               int j=0;
               int counter = 0;
               int base0   = Mask_Of_Nonzero_Elements.getBase(0);
               int bound0  = Mask_Of_Nonzero_Elements.getBound(0);
               int stride0 = Mask_Of_Nonzero_Elements.getRawStride(0);
               int base1   = Mask_Of_Nonzero_Elements.getBase(1);
               int bound1  = Mask_Of_Nonzero_Elements.getBound(1);
               int stride1 = Mask_Of_Nonzero_Elements.getRawStride(1);
               int size    = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain.Size[0];

            // APP_ASSERT(stride0 == stride1 == 1 );

               for (j=base1; j <= bound1; j += stride1)
                  {
                    int offset_i = (j*size);
                    for (i=base0; i <= bound0; i += stride0)
                       {
                         if (arrayPointer[offset_i+i])
                            {
                              resultPointer[counter]                         = (i/stride0);
                              resultPointer[numberOfNonzeroElements+counter] = (j/stride1);
                              counter++;
                            }
                       }
                  }
             }
            else
             {
               if ( numDims == 3 )
                  {
                    double* resultPointer = Return_Index_Map->Array_Descriptor.Array_Data;
                    double* arrayPointer  = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_View_Pointer2;

                 // APP_ASSERT (resultPointer != NULL);
                 // APP_ASSERT (arrayPointer  != NULL);

                    int i=0;
                    int j=0;
                    int k=0;
                    int counter = 0;

                    int size0   = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain.Size[0];
                    int base0   = Mask_Of_Nonzero_Elements.getBase(0);
                    int bound0  = Mask_Of_Nonzero_Elements.getBound(0);
                    int stride0 = Mask_Of_Nonzero_Elements.getRawStride(0);

                    int size1   = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain.Size[1];
                    int base1   = Mask_Of_Nonzero_Elements.getBase(1);
                    int bound1  = Mask_Of_Nonzero_Elements.getBound(1);
                    int stride1 = Mask_Of_Nonzero_Elements.getRawStride(1);

                    int base2   = Mask_Of_Nonzero_Elements.getBase(2);
                    int bound2  = Mask_Of_Nonzero_Elements.getBound(2);
                    int stride2 = Mask_Of_Nonzero_Elements.getRawStride(2);

                    for (k=base2; k <= bound2; k += stride2)
                       {
                         int offset_j = (k*size1);
                         for (j=base1; j <= bound1; j += stride1)
                            {
                              int offset_i = offset_j+(j*size0);
                              for (i=base0; i <= bound0; i += stride0)
                                 {
                                   if (arrayPointer[offset_i+i])
                                      {
#if 0
                                        printf ("FOUND NONZERO VALUE: counter = %d i = %d j = %d k = %d \n",
                                             counter,i,j,k);
#endif
                                        resultPointer[counter]                               = (i/stride0);
                                        resultPointer[numberOfNonzeroElements + counter]     = (j/stride1);
                                        resultPointer[(numberOfNonzeroElements*2) + counter] = (k/stride2);
                                        counter++;
                                      }
                                 }
                            }
                       }
                  }
                 else
                  {
                 // Handle dimensions greater then 3 using the more general MDI layer

                 // Setup Mask pointers! (Fix this later -- not defined for a where mask)
                    int *Mask_Data       = NULL;
                    array_domain *Mask_Descriptor = NULL;

                 // Call the MDI function
                    MDI_Build_Index_Map_Array (
                              Return_Index_Map->Array_Descriptor.Array_Data , 
                              Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Data , 
                              Mask_Data ,
                              (array_domain*)(&Return_Index_Map->Array_Descriptor.Array_Domain) , 
                              (array_domain*)(&Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain) , 
                              Mask_Descriptor );
                  }
             }
        }

#else

  // Setup Mask pointers! (Fix this later -- not defined for a where mask)
     int *Mask_Data                = NULL;
     array_domain *Mask_Descriptor = NULL;

  // Call the MDI function
     MDI_Build_Index_Map_Array ( Return_Index_Map->Array_Descriptor.Array_Data , 
                                 Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Data , 
                                 Mask_Data ,
                                 (array_domain*)(&Return_Index_Map->Array_Descriptor.Array_Domain) , 
                                 (array_domain*)(&Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain) , 
                                 Mask_Descriptor );
#endif

#if COMPILE_DEBUG_STATEMENTS
     Return_Index_Map->Test_Consistency ("Called from intArray::indexMap()");

     if (APP_DEBUG > 3)
          printf ("Leaving intArray::Index_Map() \n");
#endif

  // Since we want A++/P++ to correctly absorb the array when it 
  // is used it needs to be marked as a temporary.
     Return_Index_Map->setTemporary(TRUE);

  // Return_Index_Map->view("Called from intArray::indexMap()");

     return *Return_Index_Map;
   }
#endif
#endif
#endif

// *****************************************************************
// Build_Pointer_To_View_Of_Array simplifies the internal 
// construction of a view (for use internally in A++/P++)
// *****************************************************************
doubleArray*
doubleArray::Build_Pointer_To_View_Of_Array (
   const doubleArray & X , 
   const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
#if defined(USE_TAU)
     TAU_PROFILE("doubleArray::Build_Pointer_To_View_Of_Array()", 
                 "doubleArray*(doubleArray,Internal_Index,Internal_Index,Internal_Index,Internal_Index)", 
                 TAU_APP_OVERHEAD);
#endif

  // This function builds a pointer to a view using an existing doubleSerialArray and an array
  // of Internal_Index objects (array of Internal_Index objects should be length MAX_ARRAY_DIMENSION == 4)
  // This function could be made more efficient if it was made less dependent on length
  // 4 Internal_Index arrays as input.  So maybe later we can have 4 different versions each taking a different
  // number of Internal_Index objects.

     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
       // This generate a call to the BaseArray::Array_ID() (some sort of error?)
          printf ("Inside of doubleArray::Build_Pointer_To_View_Of_Array ( const doubleArray & X , const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List ) \n");

          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
             {
               Internal_Index_List[temp]->list("input parameter to Build_Pointer_To_View_Of_Array");
             }
        }

     if (Diagnostic_Manager::getReferenceCountingReport() > 0)
        {
       // This mechanism outputs reports which allow us to trace the reference counts
          X.displayReferenceCounts("Input X in doubleArray::Build_Pointer_To_View_Of_Array");
        }

     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In Build_Pointer_To_View_Of_Array() - X array local range (%d,%d,%d) \n",
               X.getBase(0),
               X.getBound(0),
               X.getStride(0));

            // We are most interested in 1D problems currently
          printf ("     input Internal_Index_List[0] range (%d,%d,%d) \n",
               Internal_Index_List[0]->getBase(),
               Internal_Index_List[0]->getBound(),
               Internal_Index_List[0]->getStride());

       // X.view("Input array_Domain to doubleArray::Build_Pointer_To_View_Of_Array");
        }
#endif

#if BOUNDS_ERROR_CHECKING
     if (Internal_Index::Index_Bounds_Checking)
        {
          X.Error_Checking_For_Index_Operators ( Internal_Index_List );
        }
#endif

#if 0
  // (7/27/2000) added assert (trap case of target of view being a null array)
  // APP_ASSERT(X.isNullArray() == FALSE);
     if (X.isNullArray() == TRUE)
        {
          if (X.isView() == TRUE)
             {
            // Even a null array needs to have a valid data point if it is a view.
            // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
               APP_ASSERT(X.getDataPointer() != NULL);
             }
        }
#endif

  /*
  // ... change (8/26/96,kdb) new interpretation for index application so
  // a new list of Indexes with compressed stride (usually 1) is constructed
  // and used instead of Internal_Index_List (try stride 1 first because 
  // needed stride for ratio is currently unavailable) ...
  */
  /* .. change again (10/9/96,kdb) this wasn't quite correct before ... */
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List_For_View;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT(Internal_Index_List[temp] != NULL);

       // .. (10/15/96,kdb) try again to get this right ...
          if (Internal_Index_List[temp]->Index_Mode == Index_Triplet)
             {
               int indexBase     = Internal_Index_List[temp]->getBase();
               int indexCount    = Internal_Index_List[temp]->getCount();
               int indexStride   = Internal_Index_List[temp]->getStride();
               int domainRawBase = X.Array_Descriptor.getRawBase(temp);
               int domainBase    = X.Array_Descriptor.getBase(temp);
               int domainRawStride  = X.Array_Descriptor.getRawStride(temp);

            // I suspect that the computation of tempBase is wrong!
#if 0
               printf ("In Build_Pointer_To_View_Of_Array (axis=%d) indexBase = %d indexCount = %d indexStride = %d domainRawBase = %d domainBase = %d domainRawStride = %d \n",
                    temp,indexBase,indexCount,indexStride,domainRawBase,domainBase,domainRawStride);
#endif

            // This is the simplest way to build the correct index (else why was this index input?)
               Internal_Index_List_For_View[temp] = new Internal_Index(*Internal_Index_List[temp]);
               APP_ASSERT (Internal_Index_List_For_View[temp] != NULL);
             }
            else
             {
            // ... NULL INDEX CASE ...
               Internal_Index_List_For_View[temp] = new Internal_Index(0,0,1);
               APP_ASSERT (Internal_Index_List_For_View[temp] != NULL);
             }

#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
             {
               printf ("Axis = %d \n",temp);
               Internal_Index_List_For_View[temp]->list("Internal_Index_List_For_View");
             }
#endif
        }

#if EXTRA_ERROR_CHECKING
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          APP_ASSERT (Internal_Index_List[temp] != NULL);

     if (Index::Index_Bounds_Checking)
        {
       // X.view("X in doubleArray::Build_Pointer_To_View_Of_Array()");
       // Must make array of pointer to Internal_Index objects from array of Internal_Index
       // ... (8/26/96) use Internal_Index_List_For_View instead ...
          X.Array_Descriptor.Error_Checking_For_Index_Operators ( Internal_Index_List_For_View );
        }
#endif

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
       // X.view("X in doubleArray::Build_Pointer_To_View_Of_Array()");
       // printf ("Exiting in doubleArray::Build_Pointer_To_View_Of_Array() \n");
       // APP_ABORT();
        }
#endif

#if defined(PPP)
  // make code independent of 4 dimensional arrays internally
  // Internal_Index Local_Index_Array [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Local_Index_Array;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp] != NULL);
       // Bugfix (11/9/95) New Cray C++ compiler on T3D does not like the following statement
       // It is good to have such picky compilers since no other compiler has caught the problem.
       // ... (8/26/96) use Internal_Index_List_For_View instead ...
          Local_Index_Array [temp] = Internal_Index_List_For_View[temp]->getPointerToLocalPart
                                          (X.Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain,temp);

#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 2)
             {
               printf ("Axis = %d \n",temp);
               Local_Index_Array[temp]->display("Internal_Index_List_For_View");
             }
#endif
        }

  // Must delete the pointers returned from getPointerToLocalPart an stored into Local_Index_Array
  // ... (8/26/96) use Internal_Index_List_For_View instead ...
  // This P++ version calls the Serial A++ version of this function
     doubleArray* Return_Pointer = new doubleArray
          (doubleSerialArray::Build_Pointer_To_View_Of_Array(*X.Array_Descriptor.SerialArray,Local_Index_Array) , 
	   X.Array_Descriptor.Array_Domain, Internal_Index_List_For_View );
     APP_ASSERT(Return_Pointer != NULL);

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp] != NULL);
          delete Local_Index_Array [temp];
          Local_Index_Array [temp] = NULL;

       // ... Internal_Index_List_For_View is no longer needed ...
          delete Internal_Index_List_For_View [temp];
          Internal_Index_List_For_View [temp] = NULL;
        }
#else
  // NON P++ version of code body
  // We have to increment the reference count for the data since there is now another
  // reference to it.
     X.incrementRawDataReferenceCount();

  // (7/27/2000) added assert
  // APP_ASSERT(X.isNullArray() == FALSE);
  // APP_ASSERT(X.Array_Descriptor.Array_Data != NULL);

  // ... (8/26/96) use Internal_Index_List_For_View instead ...
     doubleArray* Return_Pointer = 
          new doubleArray(X.Array_Descriptor.Array_Data,X.Array_Descriptor.Array_Domain,Internal_Index_List_For_View );
     APP_ASSERT(Return_Pointer != NULL);

  // ... Internal_Index_List_For_View is no longer needed ...
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          delete Internal_Index_List_For_View [temp];
          Internal_Index_List_For_View [temp] = NULL;
        }

#if COMPILE_DEBUG_STATEMENTS
#if 0
     if (X.isNullArray())
        {
       // Even a null array needs to have a valid data point if it is a view.
       // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
          APP_ASSERT(X.getDataPointer() != NULL);
          APP_ASSERT(Return_Pointer->getDataPointer() != NULL);
        }
     if (Return_Pointer->isNullArray() == TRUE)
        {
          if (Return_Pointer->isView() == TRUE)
             {
            // Even a null array needs to have a valid data point if it is a view.
            // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
               APP_ASSERT(Return_Pointer->getDataPointer() != NULL);
             }
        }
#endif
#endif
#endif

  // Return_Pointer->view("Output array_Domain to doubleArray::Build_Pointer_To_View_Of_Array");

     if (X.isTemporary())
        {
          Return_Pointer->setTemporary(TRUE);
        }

     if (X.isTemporary())
          APP_ASSERT(Return_Pointer->isTemporary());

#if COMPILE_DEBUG_STATEMENTS
     if (Diagnostic_Manager::getReferenceCountingReport() > 0)
        {
       // This mechanism outputs reports which allow us to trace the reference counts
          X.displayReferenceCounts("Input X in BASE of doubleArray::Build_Pointer_To_View_Of_Array");
          Return_Pointer->displayReferenceCounts("Return_Pointer in BASE of doubleArray::Build_Pointer_To_View_Of_Array");
        }
#endif

     return Return_Pointer;
   }

// *****************************************************************
// adopt member function uses existing memory to build A++ and P++ arrays
// *****************************************************************
doubleArray &
doubleArray::adopt (
   const double* Data_Pointer ,
   const Partitioning_Type & Partition ,
   ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 2)
          printf ("Inside of doubleArray::adopt (double*,Partitioning_Type,int,Range,int,Range,int,Range,int,Range) (Pointer = %p) (Array_ID = %d) \n",Data_Pointer,Array_ID());
#endif

     INTEGER_AND_RANGE_ARGUMENTS_TO_INTEGER_AND_CONST_REF_RANGE_LIST_MACRO

  // printf ("Users data must be in a partitioning conformable to P++ internal usage! \n");
  // printf ("doubleArray::adopt (double*,Partitioning_Type,int,Range,int,Range,int,Range,int,Range) not implemented in P++! \n");
  // APP_ABORT();

     return adopt ( Data_Pointer , Partition , Integer_List , Internal_Index_List );
   }

// This is the functional part of the P++ adopt member function
// It is not implemented currently because it is more difficult than expected
doubleArray & 
doubleArray::adopt ( const double* Data_Pointer , const Partitioning_Type & Partition ,
                   const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List ,
                   const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
#if defined(PPP)
  // Avoid compiler warning about unused input variable
     if (&Partition);
     if (&Integer_List);
     if (&Data_Pointer);
  // if (&Internal_Index_List);

     printf ("Users data must be in a partitioning conformable to P++ internal usage! \n");
     printf ("doubleArray::adopt (double*,Partitioning_Type,int,Range,int,Range,int,Range,int,Range) not implemented in P++! \n");
     APP_ABORT();

  // adopt ( Data_Pointer , Partition , Integer_List );
  // doubleArray *Temp_Array = new doubleArray(Internal_Index_List,Partition);
  // Temp_Array->Array_Descriptor->incrementReferenceCount;
  // delete Array_Descriptor;
  // Array_Descriptor = Temp_Array->Array_Descriptor;
  // delete Temp_Array;
#else
  // Avoid compiler warning about unused input variable
     if (&Partition);
     if (&Integer_List);

  // Call the A++ member function
     adopt ( Data_Pointer , Internal_Index_List );
#endif

  // Now setup the new bases (changed from the default of ZERO)
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
           setBase (Internal_Index_List[temp]->Base,temp);
     return *this;
   }

// A++ specific implementation of adopt member functions
// These A++ specific function are made available to P++ to maintain
// the identical interface even though under P++ these functions
// are not implemented.
doubleArray & 
doubleArray::adopt ( const double* Data_Pointer , const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of doubleArray::adopt (double*,int*)(Pointer = %p)(Array_ID = %d)(referenceCount = %d, raw data reference count = %d)\n",
	      Data_Pointer,Array_ID(),getReferenceCount(),getRawDataReferenceCount());
        }
#endif

#if defined(PPP)
  // Avoid compiler warning about unused input variable
     if (&Integer_List);

     printf ("ERROR: not implemented for P++ (another P++ specific adopt member function is required)! \n");
     APP_ABORT();
#else
  // Get default base for each dimension
     int OldBase[MAX_ARRAY_DIMENSION];
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          OldBase[temp] = APP_Global_Array_Base;

     bool Is_A_Null_Array = FALSE;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT(Integer_List[temp] >= 0);
          if (Integer_List[temp] == 0) Is_A_Null_Array = TRUE;
        }

#if COMPILE_DEBUG_STATEMENTS
     if (Is_A_Null_Array) 
        {
          APP_ASSERT( Data_Pointer != NULL );
        }
#endif

  // Save old base for each dimension
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          OldBase[temp] = getBase(temp);

     Delete_Array_Data();

#if (ARRAY_ID_LEAK_FIXED == TRUE)

  // printf ("In adopt: ARRAY_ID_LEAK_FIXED is not fixed yet! \n");
  // APP_ABORT();

  // Bugfix (1/27/97) I think this fixes what appeared to be a memory leak in the adopt function
  // Since the reference count includes the initial reference we have to return
  // the Array_ID before we would otherwise (one array reference before we would otherwise).
  // Note: it is OK to return the Array_ID as long as the reference count is also reset
  // else there are many problems the next time that Array_ID is reused.  If the reference
  // count is < 0 then it would be reset and the Array_ID returned within the destructor for
  // the Array_Descriptor.  But it is because the reference count can be == 0 that we have
  // to fix this problem here.
  // printf ("getRawDataReferenceCount() = %d \n",getRawDataReferenceCount() );
  // if (getRawDataReferenceCount() == 0)  we really do need to handle the case of <= 0
     if (getRawDataReferenceCount() <= getRawDataReferenceCountBase())
        {
       // printf ("Note: getRawDataReferenceCount() = %d <= getRawDataReferenceCountBase() = %d \n",
       //        getRawDataReferenceCount(),getRawDataReferenceCountBase());

#if !defined(PPP)
       // Reinitialize reference count for next use!
          resetRawDataReferenceCount();
       // Array_Descriptor_Type::Array_Reference_Count_Array [Array_ID()] = 0;
#endif

       // Array_Descriptor.Push_Array_ID (Array_ID());
          Array_Domain_Type::Push_Array_ID (Array_ID());
        }
#endif

  // Note that the default base will be used for this array object!
     APP_ASSERT (!Is_A_Null_Array); // temp test (6/13/2000)
     if (!Is_A_Null_Array)
        {
       // printf ("Do we have to assign more data? \n");
       // Array_Descriptor = new Array_Descriptor_Type ( MAX_ARRAY_DIMENSION , Integer_List );
       // Array_Descriptor = Array_Descriptor_Type ( MAX_ARRAY_DIMENSION , Integer_List );
          Array_Descriptor.Initialize_Descriptor ( MAX_ARRAY_DIMENSION , Integer_List );
        }
       else
        {
          printf ("Do we have to assign more data? \n");
       // Array_Descriptor = new Array_Descriptor_Type ();
       // This constructor should have already been called! (Dan, 5/16/97)
       // Array_Descriptor = Array_Descriptor_Type ();
        }

  // APP_ASSERT( Array_Descriptor != NULL );

// We have to record that this array object is built using preexisting data.
// This means that we will have to give back the Array_ID within the redim function
// Are there other functions where we would have to give back the Array_IDs?
   Array_Descriptor.Array_Domain.builtUsingExistingData = TRUE;

// Now use the pointer that was provide by the user!

#if defined(PPP)
   Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Local_Internal_Index_List;
   for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
      Local_Internal_Index_List[temp] = &(Array_Descriptor.Array_Domain.Local_Mask_Index[temp]);
   Array_Descriptor.SerialArray   = new doubleSerialArray;
   Array_Descriptor.SerialArray->adopt (Data_Pointer,Local_Internal_Index_List);
#else
   Array_Descriptor.Array_Data    = (double*) Data_Pointer;
   POINTER_LIST_INITIALIZATION_MACRO;
#endif
   Array_Storage = NULL;

   // Increment the reference count so that destructor cannot delete the data
   // we need this because the data might not have been from the heap. And because
   // if the user created the data it is the users responcibility to handle the 
   // memory.
   incrementRawDataReferenceCount();

   // reset the base to that of the old descriptor
   for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
      setBase (OldBase[temp],temp);
#endif

   return *this;
}

// *****************************************************************
// adopt member function uses existing memory to build A++ arrays
// and Integers to setup the dimensions
// *****************************************************************
doubleArray & doubleArray::adopt ( const double* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 2)
          printf ("Inside of doubleArray::adopt (double*,int,int,int,int) (Pointer = %p) (Array_ID = %d) \n",Data_Pointer,Array_ID());
#endif

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

     return adopt ( Data_Pointer , Integer_List );
   }

// *****************************************************************
// adopt member function uses existing memory to build A++ arrays
// and Range objects to setup the base and dimensions
// *****************************************************************
doubleArray & doubleArray::adopt ( const double* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     return adopt ( Data_Pointer , Internal_Index_List );
   }

// This function takes an array of Internal_Index objects
doubleArray & doubleArray::adopt ( const double* Data_Pointer , const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          Array_Size[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base) + 1;

     adopt ( Data_Pointer , Array_Size );

  // Now setup the new bases (changed from the default of ZERO)
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
           setBase (Internal_Index_List[temp]->Base,temp);

     return *this;
   }

// *****************************************************************
// adopt member function uses existing memory to build A++ and P++ 
// arrays and another A++/P++ array objects to get the size and distribution (in P++)
// *****************************************************************
doubleArray & doubleArray::adopt ( const double* Data_Pointer , const doubleArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 2)
          printf ("Inside of doubleArray::adopt (double*,doubleArray) (Pointer = %p) (Array_ID = %d) \n",Data_Pointer,Array_ID());
#endif

     Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          Array_Size[temp] = X.getLength(temp);

#if defined(PPP)
  // In P++ we would have to get the partition information and then 
  // use an alternative adopt function internally. This has not been implemented yet.
     printf ("Not implemented for P++: doubleArray::adopt ( const double* Data_Pointer , const doubleArray & X ) \n");
     APP_ABORT();
#endif

     return adopt ( Data_Pointer , Array_Size );
   }

// *********************************************************
// Used by the inlined operator new -- required because 
// inlined functions can't have loops (with Cfront C++)
// *********************************************************
void doubleArray::New_Function_Loop ()
   {
  // Initialize the free list of pointers!
     for (int i=0; i < CLASS_ALLOCATION_POOL_SIZE-1; i++)
        {
          Current_Link [i].freepointer = &(Current_Link[i+1]);
        }
   }

// *********************************************************
// Destructor for A++ objects
// *********************************************************
doubleArray::~doubleArray ()
   {
  // The assumed semantics of the destructor is that it must delete the array object
  // however it may (based upon the reference count) select to not delete the data.
  // This is because at this (late) point in the process the space associated with 
  // the array object must be freed to the operating system.  So the place to do the
  // reference counting check on the array object (different from the array data contained within
  // the array object) is before the delete operator is called (since the delete operator then
  // calls the destructor (or is it the other way around?)).

#if COMPILE_DEBUG_STATEMENTS
     if ( (APP_DEBUG > 0) || (Diagnostic_Manager::getReferenceCountingReport() > 0) )
        {
#if defined(PPP)
          printf ("### Inside of doubleArray::destructor (Array_id = %d, this=%p, this->Array_Descriptor.SerialArray=%p) (referenceCount = %d) \n",
               this->Array_ID(),this,this->Array_Descriptor.SerialArray,referenceCount);
#else
          printf ("              doubleArray::destructor (Array_id = %d, this=%p, this->Array_Data=%p) (referenceCount = %d) \n",
               this->Array_ID(),this,this->Array_Descriptor.Array_Data,referenceCount);
#endif
        }

     if ( Diagnostic_Manager::getReferenceCountingReport() > 0 )
        {
          displayReferenceCounts("In doubleArray destructor");
        }
#endif

#if defined(PPP)
  // Delete this array in the list of arrays associated with this partition
  // This does a shallow delete removing the object from the list only!

  // Views are not defined with a partitioning object since it uses the
  // same partitioning object as what the view is a view of!
     if ( (Array_Descriptor.isView() == FALSE) && (Array_Descriptor.isTemporary() == FALSE) )
        {
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
             {
            // printf ("In doubleArray::~doubleArray: remove the reference to the array in the DEFAULT partitioning object! \n");
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);
             }
            else
             {
            // printf ("In doubleArray::~doubleArray: remove the reference to the array in a valid partitioning object! \n");
               Internal_Partitioning_Type::DeleteArrayToPartitioning
                    (*(Array_Descriptor.Array_Domain.Partitioning_Object_Pointer),*this);
             }
        }
#endif

#if 0
  // If the reference count is greater than zero then it means that the object is
  // in use by some other reference -- so we would not want to delete the array object OR the data.
  // Note that the delete operator should decriment the referenceCount.
     if (referenceCount < getReferenceCountBase())
        {
          printf ("referenceCount in doubleArray::destructor is %d (check reference count before calling delete) \n",
               referenceCount);
       // view("ERROR: referenceCount >= getReferenceCountBase() in doubleArray::destructor");
       // APP_ABORT();
        }
  // APP_ASSERT(referenceCount >= getReferenceCountBase());
#endif

  // printf ("referenceCount in doubleArray::destructor is %d Array_ID() = %d \n",referenceCount,Array_ID());

#if 0
#if defined(PPP)
     if (Array_Descriptor.SerialArray != NULL)
        {
          printf ("In doubleArray::destructor Array_Descriptor.SerialArray->getReferenceCount() = %d \n",
               Array_Descriptor.SerialArray->getReferenceCount());
        }
       else
        {
          printf ("In doubleArray::destructor Array_Descriptor.SerialArray == NULL! \n");
        }
#endif
#endif

  // (12/08/2000) I don't know if we can assert this for P++
     APP_ASSERT(referenceCount <= getReferenceCountBase());

     APP_ASSERT (Array_Storage == NULL);
#if COMPILE_DEBUG_STATEMENTS
     if (Array_Storage != NULL)
        {
          if (APP_DEBUG > 0)
               printf ("NOTE: doubleArray::~doubleArray --  Array_Storage (built during defered evaluation) is NOT NULL! \n");
        }
#endif

#if defined(PPP)
     if (Array_Descriptor.SerialArray != NULL)
#else
     if (Array_Descriptor.Array_Data != NULL)
#endif
        {
       // We don't have to decrement the reference count because 
       // it is done in the Delete_Array_Data() member function
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 1)
             {
#if defined(PPP)
               printf ("Call destructor for SerialArray (getRawDataReferenceCount() = %d) \n",getRawDataReferenceCount());
#else
               printf ("Call destructor for Array_Data (getRawDataReferenceCount() = %d) \n",getRawDataReferenceCount());
#endif
             }
#endif
          APP_ASSERT(getRawDataReferenceCount() >= getReferenceCountBase());

          Delete_Array_Data ();
#if defined(PPP)
          Array_Descriptor.SerialArray = NULL;
#else
          Array_Descriptor.Array_Data  = NULL;
          POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif
        }
       else
        {
       // We still have to decrement the reference count since otherwise
       // the use of the reference counting would be inconsistant between
       // the array object having data and a Null array object.
       // The Array_ID values in the descriptors que off of the
       // reference count to know when to return the Array_ID values
       // back to the stack.  So we have to decriment the reference count
       // even though the there really is no data in a Null array.
       // Within P++ this allows views of Null arrays (for arrays
       // not partitioned over  all processors) to be properly defined.
          decrementRawDataReferenceCount();

#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 1)
             {
#if defined(PPP)
               printf ("In ~doubleArray(): Array_Descriptor.SerialArray == NULL! \n");
#else
               printf ("In ~doubleArray(): Array_Descriptor.Array_Data == NULL! \n");
#endif
             }
#endif
        }

  // Note: Next is called the destructor for the Array_Descriptor and then the Array_Domain!
   }

int
doubleArray::numberOfInternalArrays()
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::numberOfInternalArrays() \n");
#endif

     int numberOfOutstandingArrayObjects = 0;

     if (Last_Lhs_doubleArray_Operand != NULL)
        {
          APP_ASSERT (Last_Lhs_doubleArray_Operand->usesIndirectAddressing() == FALSE);
          numberOfOutstandingArrayObjects++;
        }

  // printf ("doubleArray::numberOfInternalArrays() = %d \n",numberOfOutstandingArrayObjects);

     return numberOfOutstandingArrayObjects;
   }



#if defined(APP) || defined(PPP)
#if defined(USE_PADRE)
void
doubleArray::partition ( PADRE_Distribution<BaseArray,Array_Domain_Type,SerialArray_Domain_Type> *Partition )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of PADRE SPECIFIC doubleArray::partition (PADRE_Distribution) function! \n");
#endif

  // printf ("PADRE SPECIFIC doubleArray::partition (PADRE_Distribution) function! Exiting ... \n");
  // APP_ABORT();

     Internal_Partitioning_Type *Internal_Partition_Pointer = new Internal_Partitioning_Type (Partition);
     APP_ASSERT (Internal_Partition_Pointer != NULL);

  // printf ("BEFORE partition -- In doubleArray::partition ( PADRE_Distribution* ): Internal_Partition_Pointer->getReferenceCount()  = %d \n",
  //      Internal_Partition_Pointer->getReferenceCount());

     partition (*Internal_Partition_Pointer); 

  // printf ("AFTER partition -- In doubleArray::partition ( PADRE_Distribution* ): Internal_Partition_Pointer->getReferenceCount()  = %d \n",
  //      Internal_Partition_Pointer->getReferenceCount());

  // APP_ASSERT ( Internal_Partition_Pointer->getReferenceCount() == Internal_Partition_Pointer->getReferenceCountBase() );
     if (Internal_Partition_Pointer != NULL)
        {
          Internal_Partition_Pointer->decrementReferenceCount();
          if (Internal_Partition_Pointer->getReferenceCount() < 
              Internal_Partition_Pointer->getReferenceCountBase())
               delete Internal_Partition_Pointer;
          Internal_Partition_Pointer = NULL;
        }

  // printf ("Exiting in doubleArray::partition(PADRE_Distribution) \n");
  // APP_ABORT();
   }
#endif

Internal_Partitioning_Type*
doubleArray::getInternalPartitionPointer () const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::getInternalPartition () \n");
#endif

#if defined(PPP)
     return Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
#else
  // In the A++ case we can do most anything! (so return NULL)
     return NULL;
#endif
   }


Partitioning_Type
doubleArray::getPartition () const
   {
  // This function might be better implemented to return a pointer and then a NULL 
  // pointer could be returned to signify the use of the Default values in the
  // Partitining_Type object (class) 

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::getPartition () \n");
#endif

#if defined(PPP)
  // APP_ASSERT (Array_Descriptor != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
        {
          printf ("Default values in Partitioning_Type used -- Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL \n");
        }
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL);

     return Partitioning_Type(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
#else
  // In the A++ case we can do most anything!
     return Partitioning_Type();
#endif
   }

doubleArray &
doubleArray::partition ( const Partitioning_Type & Partition )
   {
  // This function repartitions the THIS array using the input Partitioning_Type object!
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::partition (const Partitioning_Type & Partition) \n");
#endif

    //APP_ASSERT ( Partition.Internal_Array_Descriptor.Partitioning_Object != NULL );
    APP_ASSERT ( Partition.Internal_Partitioning_Object != NULL );
    partition (*Partition.getInternalPartitioningObject());
    return *this;
   }

doubleArray &
doubleArray::partition ( const Internal_Partitioning_Type & Partition )
   {
  // This function repartitions the THIS array using the input Partitioning_Type object!

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::partition (const Internal_Partitioning_Type & Partition) \n");
#endif

  // printf ("########################################################## \n");
  // printf ("### doubleArray::partition (Internal_Partitioning_Type) #### \n");
  // printf ("########################################################## \n");

#if defined(PPP)
  // outstanding reference to the array object (but not the data) are OK
  // APP_ASSERT (getReferenceCount() == getReferenceCountBase());

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("In partition(): We should handle null array case the same as other cases (eliminate the test of null array!) \n");
#endif

     if (Array_Descriptor.isNullArray() == TRUE)
        {
       // This is a seperate case because the partitioning information is not
       // built for the case of a NULL array. Parti can't handle the concept of
       // a NULL array (as I recall).
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
          printf ("Inside of doubleArray::partition: Case of Partitioning a Null Array \n");
#endif

          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 1)
                    printf ("Inside of doubleArray::partition: deleting reference to %p in NON-DEFAULT list \n",this);
#endif
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
             }
            else
             {
            // Or delete it from the Default partitioning object!
            // Partitioning_Type::DefaultdoubleArrayList.deleteElement(*this);
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 1)
                    printf ("Inside of doubleArray::partition: deleting reference to %p in DEFAULT list \n",this);
#endif
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);
             }

       // Array_Descriptor.partition (*Partition.getInternalPartitioningObject());
          Array_Descriptor.partition (Partition);

       // printf ("Add (register) array to partitioning object \n");
       // Now associate this array with the partitioning so that if the partitioning is ever
       // changed we can find the array and propgate the effect of the redistribution.
          Internal_Partitioning_Type::AddArrayToPartitioning ( ((Internal_Partitioning_Type &) Partition), *this );
        }
       else
        {
       // I think this code is changing the lists used in the swapDistribution function (an STL list (for PADRE)).
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
             {
               Internal_Partitioning_Type & previousPartition = *(Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
            // First disassociate the THIS array from the array list on the Partitioning Object!
            // Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->doubleArrayList.deleteElement(*this);
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);

            // printf ("Can't delete Partitioning object yet: no reference counting implemented yet! \n");
            // if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount-- == getReferenceCountBase())
            //      delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
            // Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;

            // Added error checking (11/14/2000)
               APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                           Internal_Partitioning_Type::getReferenceCountBase());

               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
               if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() <
                   Internal_Partitioning_Type::getReferenceCountBase())
                  {
                 // printf ("calling delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
                    delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
                  }
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;
             }
            else
             {
            // Or delete it from the Default partitioning object!
            // Partitioning_Type::DefaultdoubleArrayList.deleteElement(*this);
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);
             }

       // The array size is not changing but a few parts of the global array descriptor are
       // effected by the redistribution and so we save the old descriptor and build a new descriptor (later).
       // A better implementation would just save the relavant parts (I think)
          doubleArray_Descriptor_Type*
	     Old_Array_Descriptor = new doubleArray_Descriptor_Type (Array_Descriptor);
          APP_ASSERT(Old_Array_Descriptor != NULL);

       // Modify some of the descriptor fields too
          Array_Descriptor.partition (Partition);

       // printf ("Add (register) array to partitioning object \n");
       // Now associate this array with the partitioning so that if the partitioning is ever
       // changed we can find the array and propgate the effect of the redistribution.
          Internal_Partitioning_Type::AddArrayToPartitioning ( ((Internal_Partitioning_Type &) Partition), *this );

          doubleSerialArray *Temp_SerialArray = Array_Descriptor.SerialArray;

       // Increment reference count so that Temp_SerialArray will not be deleted!
          incrementRawDataReferenceCount();

          Delete_Array_Data();

       // Force all the mechanisms to build a P++ array to be called using the new partition data
          Allocate_Array_Data(TRUE);

       // At this point the descriptor for the new array (with the new partitioning) is defined
          doubleArray_Descriptor_Type* New_Array_Descriptor = &Array_Descriptor;

       // printf ("Exiting in doubleArray::partition AFTER Allocate_Array_Data() \n");
       // APP_ABORT();

          APP_ASSERT(New_Array_Descriptor != NULL);
          APP_ASSERT(Old_Array_Descriptor != NULL);

       // *****************************************************************
       // Now transfer the data from the old partition to the new partition
       // *****************************************************************

#if defined(USE_PADRE)
       // What PADRE function should we use here!
       // printf ("Must call a PADRE function! \n"); APP_ABORT();
          APP_ASSERT (New_Array_Descriptor != NULL);
          APP_ASSERT (Old_Array_Descriptor != NULL);
          APP_ASSERT (Array_Descriptor.SerialArray != NULL);
       // APP_ASSERT (Array_Descriptor.SerialArray->Array_Descriptor.Array_Data != NULL);
          APP_ASSERT (Temp_SerialArray != NULL);
       // APP_ASSERT (Temp_SerialArray->Array_Descriptor.Array_Data != NULL);

          PADRE_Descriptor<BaseArray,Array_Domain_Type,SerialArray_Domain_Type>::transferData 
             ( New_Array_Descriptor->Array_Domain, 
               Old_Array_Descriptor->Array_Domain,
               Temp_SerialArray->Array_Descriptor.Array_Data,
               Array_Descriptor.SerialArray->Array_Descriptor.Array_Data );
#else
       // Bugfix (4/11/96) PARTI returns the wrong schedule because it does not invalidate
       // the cached schedule from before the distribution was changed.  Thus it returns
       // the wrong schedule (or something like that).  The call to remove_subarray_scheds
       // is a PARTI function which clears the internal cache to force all subarray schedules
       // to be rebuilt from scratch.  When this bug in PARTI is fixed we can remove this function
       // call.
          remove_subarray_scheds();

          SCHED* Temp_Schedule = Internal_Partitioning_Type::BuildCommunicationScheduleRegularSectionTransfer
                                    ( New_Array_Descriptor->Array_Domain, Old_Array_Descriptor->Array_Domain );

          APP_ASSERT(Temp_SerialArray != NULL);
          APP_ASSERT(Array_Descriptor.SerialArray != NULL);

          if (Temp_Schedule != NULL)
             {
            // printf ("@@@@@@@ VALID SCHED OBJECT GENERATE IN doubleArray::partition() \n");
            // Internal_Partitioning_Type::displaySCHED (Temp_Schedule);
            // Array_Descriptor->display("Array_Descriptor in doubleArray::partition()");
            // The Temp_SerialArray is the source the this->SerialArray is the destination
#if defined(DOUBLEARRAY)
              dDataMove(Temp_SerialArray->Array_Descriptor.Array_Data,Temp_Schedule,
			Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
#elif defined(FLOATARRAY)
              fDataMove(Temp_SerialArray->Array_Descriptor.Array_Data, Temp_Schedule,
		        Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
#elif defined(INTARRAY)
              iDataMove(Temp_SerialArray->Array_Descriptor.Array_Data, Temp_Schedule,
		        Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
#endif
            // Delete the communication schedule that was just used
            // Note that a copy was saved as a part of PARTI's processing so that the
            // schedule can be reused later if required -- without it's recreation.
               delete_SCHED (Temp_Schedule);
               Temp_Schedule = NULL;
             }
            else
             {
            // printf ("$$$$$ VOID SCHED OBJECT GENERATE IN doubleArray::partition() \n");
             }
#endif

       // ***************************************************
       // Now cleanup an prepare to return from this function
       // ***************************************************

       // Now delete the old descriptor
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          APP_ASSERT (Old_Array_Descriptor->getReferenceCount() >= doubleArray_Descriptor_Type::getReferenceCountBase());
          Old_Array_Descriptor->decrementReferenceCount();
          if (Old_Array_Descriptor->getReferenceCount() < doubleArray_Descriptor_Type::getReferenceCountBase())
               delete Old_Array_Descriptor;
          Old_Array_Descriptor = NULL;

       // Now delete the old serial array!
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          APP_ASSERT (Temp_SerialArray->getReferenceCount() >= getReferenceCountBase());
          Temp_SerialArray->decrementReferenceCount();
          if (Temp_SerialArray->getReferenceCount() < getReferenceCountBase())
               delete Temp_SerialArray;
          Temp_SerialArray = NULL;
        }
  // if def for use with if(PPP)
#endif

#if COMPILE_DEBUG_STATEMENTS
     int localNumberOfDimensions = numberOfDimensions();
  // printf ("In doubleArray::partition: localNumberOfDimensions = %d \n",localNumberOfDimensions);

     int temp = 0;
     for (temp=0; temp < localNumberOfDimensions; temp++)
        {
       // printf ("In doubleArray::partition: getGhostBoundaryWidth(%d) = %d Partition.getLocalGhostCellWidth(temp) = %d \n",temp,getGhostBoundaryWidth(temp),temp,Partition.getLocalGhostCellWidth(temp));
          APP_ASSERT (getGhostBoundaryWidth(temp) == Partition.getLocalGhostCellWidth(temp));
        }
     for (temp=localNumberOfDimensions; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // printf ("In doubleArray::partition: getGhostBoundaryWidth(%d) = %d \n",temp,getGhostBoundaryWidth(temp));
          APP_ASSERT (getGhostBoundaryWidth(temp) == 0);
        }
#endif

  // printf ("Leaving doubleArray::partition (const Partitioning_Type & Partition) \n");
  // printf ("Exiting at BASE of doubleArray::partition (const Partitioning_Type & Partition) \n");
  // APP_ABORT();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from doubleArray::partition(Internal_Partitioning_Type)");
#endif

     return *this;
   }


#if defined(PPP)
intSerialArray
#else
intArray
#endif
doubleArray::buildProcessorMap ( doubleArrayMemberVoidFunctionPointerType X )
   {
  // This function builds a 3D array object representing the base/bound for each 
  // dimension of an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::buildProcessorMap() \n");
#endif

     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // The length 2 of the last dimension is to hold the base and bound
#if defined(PPP)
     intSerialArray dataTable (numberOfNodes);
#else
     intArray dataTable (numberOfNodes);
#endif

     int j = 0;
     for (j = 0; j < numberOfNodes; j++)
        {
       // initialize the table
          dataTable(j) = 0;
        }

#if defined(PPP)
     Communication_Manager::Sync();

  // temp storage (required for Communication_Manager::fillProcessorArray)
     int* processorArray = new int [numberOfNodes];
     APP_ASSERT (processorArray != NULL);

  // initialize the newly allocated space
     for (j = 0; j < numberOfNodes; j++)
        {
          processorArray[j] = 0;
        }

  // fill in the local base and bound for each dimension (into the dataTable)
  // Communication_Manager::fillProcessorArray ( processorArray, getLocalBase(i) );
     Communication_Manager::fillProcessorArray ( processorArray, (this->*X)() );

     for (j = 0; j < numberOfNodes; j++)
        {
          dataTable(j) = processorArray[j];
        }

  // now delete the allocated data (from above)
     delete processorArray;
     processorArray = NULL;
#endif

     return dataTable;
   }

#if defined(PPP)
intSerialArray
#else
intArray
#endif
doubleArray::buildProcessorMap ( doubleArrayMemberIntegerFunctionPointerType X )
   {
  // This function builds a 3D array object representing the base/bound for each 
  // dimension of an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::buildProcessorMap() \n");
#endif

     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // The length 2 of the last dimension is to hold the base and bound
#if defined(PPP)
     intSerialArray dataTable (numberOfNodes,numberOfDimensions());
#else
     intArray dataTable (numberOfNodes,numberOfDimensions());
#endif

     int i = 0;
     int j = 0;
     for (j = 0; j < numberOfNodes; j++)
        {
       // initialize the table
          for (i = 0; i < numberOfDimensions(); i++)
             {
               dataTable(j,i) = 0;
             }
        }

#if defined(PPP)
     Communication_Manager::Sync();

  // temp storage (required for Communication_Manager::fillProcessorArray)
     int* processorArray = new int [numberOfNodes];
     APP_ASSERT (processorArray != NULL);

  // initialize the newly allocated space
     for (j = 0; j < numberOfNodes; j++)
        {
          processorArray[j] = 0;
        }

     for (i = 0; i < numberOfDimensions(); i++)
        {
       // fill in the local base and bound for each dimension (into the dataTable)
       // Communication_Manager::fillProcessorArray ( processorArray, getLocalBase(i) );
          Communication_Manager::fillProcessorArray ( processorArray, (this->*X)(i) );

          for (j = 0; j < numberOfNodes; j++)
             {
               dataTable(j,i) = processorArray[j];
             }
        }

  // now delete the allocated data (from above)
     delete processorArray;
     processorArray = NULL;
#endif

     return dataTable;
   }

void
doubleArray::displayArraySizesPerProcessor (const char* Label)
   {
  // This function displays the number of points on each processor for an array object

#if COMPILE_DEBUG_STATEMENTS
     printf ("Inside of doubleArray::displayArraySizesPerProcessor (%s) \n",Label);
#endif

#if defined(PPP)
     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // printf ("numberOfNodes = %d \n",numberOfNodes);

  // local storage to accumulate data to prior to display
     intSerialArray dataTable = buildProcessorMap ( &(doubleArray::getLocalSize) );

  // dataTable.display("dataTable");

     int j = 0;

  // Turn OFF the mechanism that prints the node number before each output string!
     if (Communication_Manager::localProcessNumber() == 0)
        {
          Communication_Manager::setPrefixParallelPrintf(FALSE);
          printf ("***************************************************************** \n");
          printf ("Display of information about %s for each distribution of the array object \n",Label);
          printf ("***************************************************************** \n");

          printf ("Distribution of data: \n");
          for (j = 0; j < numberOfNodes; j++)
             {
            // Later handle threads separately
            // printf ("Node %3d ",localBase(i),localBound(i));
               printf ("Node: %3d: ",j);

               printf ("%3d ",dataTable(j));

               printf ("\n");
             }

          printf ("\n");
          printf ("\n");

       // Turn ON the mechanism that prints the node number before each output string!
          Communication_Manager::setPrefixParallelPrintf(TRUE);
        }
#endif
   }

#if defined(PPP)
intSerialArray
#else
intArray
#endif
doubleArray::buildProcessorMap ( doubleArrayMemberIntegerFunctionPointerType X, doubleArrayMemberIntegerFunctionPointerType Y )
   {
  // This function builds a 3D array object representing the base/bound for each
  // dimension of an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::buildProcessorMap() \n");
#endif

     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // The length 2 of the last dimension is to hold the base and bound
#if defined(PPP)
     intSerialArray dataTable (numberOfNodes,numberOfDimensions(),2);
#else
     intArray dataTable (numberOfNodes,numberOfDimensions(),2);
#endif

#if 1
  // Express the version taking two function pointers 
  // in terms of the function taking one parameter

     Internal_Index all;
     dataTable(all,all,0) = buildProcessorMap(X);
     dataTable(all,all,1) = buildProcessorMap(Y);
#else
  // This is old code (remove it later)

     int i = 0;
     int j = 0;
     for (j = 0; j < numberOfNodes; j++)
        {
       // initialize the table
          for (i = 0; i < numberOfDimensions(); i++)
             {
               dataTable(j,i,0) = 0;
               dataTable(j,i,1) = 0;
             }
        }

#if defined(PPP)
     Communication_Manager::Sync();

  // temp storage (required for Communication_Manager::fillProcessorArray)
     int* processorArray = new int [numberOfNodes];
     APP_ASSERT (processorArray != NULL);

  // initialize the newly allocated space
     for (j = 0; j < numberOfNodes; j++)
        {
          processorArray[j] = 0;
        }

     for (i = 0; i < numberOfDimensions(); i++)
        {
       // fill in the local base and bound for each dimension (into the dataTable)
       // Communication_Manager::fillProcessorArray ( processorArray, getLocalBase(i) );
          Communication_Manager::fillProcessorArray ( processorArray, (this->*X)(i) );

          for (j = 0; j < numberOfNodes; j++)
             {
               dataTable(j,i,0) = processorArray[j];
             }
  
       // Communication_Manager::fillProcessorArray ( processorArray, getLocalBound(i) );
          Communication_Manager::fillProcessorArray ( processorArray, (this->*Y)(i) );
          for (j = 0; j < numberOfNodes; j++)
             {
               dataTable(j,i,1) = processorArray[j];
             }
        }

  // now delete the allocated data (from above)
     delete processorArray;
     processorArray = NULL;
#endif
#endif

     return dataTable;
   }


void
doubleArray::displayPartitioning (const char* Label)
   {
  // This function displays the partitioning of the array object

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
          printf ("Inside of doubleArray::displayPartitioning (%s) \n",Label);
#endif

#if defined(PPP)
     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // intSerialArray dataTable = buildProcessorMap ( getLocalBase, getLocalBound );
     intSerialArray dataTable = buildProcessorMap ( &(doubleArray::getLocalBase), &(doubleArray::getLocalBound) );

     int i = 0;
     int j = 0;

  // Turn OFF the mechanism that prints the node number before each output string!
     if (Communication_Manager::localProcessNumber() == 0)
        {
          Communication_Manager::setPrefixParallelPrintf(FALSE);
          printf ("***************************************************************** \n");
          printf ("Display of information about the distribution of the array object \n");
          printf ("***************************************************************** \n");

          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
             {
               Partitioning_Type::displayDefaultValues ();
             }
            else
             {
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->display ();
             }

          printf ("Distribution of data: \n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf ("      AXIS %d  ",i);
             }
          printf ("\n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf ("   base  bound");
             }
          printf ("\n");
          for (j = 0; j < numberOfNodes; j++)
             {
            // Later handle threads separately
            // printf ("Node %3d ",localBase(i),localBound(i));
               printf ("Node: %3d",j);
               bool locatedOnThisProcessor = TRUE;
               for (i = 0; i < numberOfDimensions(); i++)
                  {
                    if ( dataTable(j,i,0) > dataTable(j,i,1) )
                         locatedOnThisProcessor = FALSE;
                  }

               if (locatedOnThisProcessor == FALSE)
                  {
                    printf (" *****  NOT LOCATED ON THIS PROCESSOR  ***** ");
                  }
                 else
                  {
                    for (i = 0; i < numberOfDimensions(); i++)
                       {
                         printf ("   %3d   %3d  ",dataTable(j,i,0),dataTable(j,i,1));
                       }
                  }

               printf ("\n");
             }

          printf ("\n");
          printf ("\n");
          printf ("\n");

       // Turn ON the mechanism that prints the node number before each output string!
          Communication_Manager::setPrefixParallelPrintf(TRUE);
        }
#endif
   }

#if 1
void
doubleArray::displayLeftRightNumberOfPoints (const char* Label)
   {
  // This function displays the LeftNumberOfPoints and the RightNumberOfPoints
  // for each processors partition of an array object.

#if COMPILE_DEBUG_STATEMENTS
     printf ("Inside of doubleArray::displayLeftRightNumberOfPoints (%s) \n",Label);
#endif

#if defined(PPP)
     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // intSerialArray dataTable = buildProcessorMap ( getLeftNumberOfPoints, getRightNumberOfPoints );
     intSerialArray dataTable = buildProcessorMap ( &(doubleArray::getLeftNumberOfPoints), &(doubleArray::getRightNumberOfPoints) );

     int i = 0;
     int j = 0;

  // Turn OFF the mechanism that prints the node number before each output string!
     if (Communication_Manager::localProcessNumber() == 0)
        {
          Communication_Manager::setPrefixParallelPrintf(FALSE);
          printf ("***************************************************************** \n");
          printf ("Display of information about %s for each distribution of the array object \n",Label);
          printf ("***************************************************************** \n");

#if 0
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
             {
               Partitioning_Type::displayDefaultValues ();
             }
            else
             {
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->display ();
             }
#endif

          printf ("Distribution of data: \n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf ("      AXIS %d  ",i);
             }
          printf ("\n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf (" LeftNumberOfPoints RightNumberOfPoints");
             }
          printf ("\n");
          for (j = 0; j < numberOfNodes; j++)
             {
            // Later handle threads separately
            // printf ("Node %3d ",localBase(i),localBound(i));
               printf ("Node: %3d",j);
               bool locatedOnThisProcessor = TRUE;

               if (locatedOnThisProcessor == FALSE)
                  {
                    printf (" *****  NOT LOCATED ON THIS PROCESSOR  ***** ");
                  }
                 else
                  {
                    for (i = 0; i < numberOfDimensions(); i++)
                       {
                         printf ("        %3d                 %3d  ",dataTable(j,i,0),dataTable(j,i,1));
                       }
                  }

               printf ("\n");
             }

          printf ("\n");
          printf ("\n");
          printf ("\n");

       // Turn ON the mechanism that prints the node number before each output string!
          Communication_Manager::setPrefixParallelPrintf(TRUE);
        }
#endif
   }
#endif

#if 0
int
doubleArray::getNumberOfMessageSent ()
   {
  // This function builds a 3D array object representing the communication done on
  // an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::buildProcessorMap() \n");
#endif

     return Diagnostic_Manager::getNumberOfMessagesSent();
   }

int
doubleArray::getGlobalNumberOfMessageSent ()
   {
  // This function builds a 3D array object representing the communication done on
  // an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::buildProcessorMap() \n");
#endif

     return Diagnostic_Manager::getNumberOfMessagesSent();
   }
#endif

#if defined(PPP) && defined(USE_PADRE)
void
doubleArray::setLocalDomainInPADRE_Descriptor ( SerialArray_Domain_Type *inputDomain ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::setLocalDomainInPADRE_Descriptor(%p) \n",inputDomain);
#endif

     Array_Descriptor.setLocalDomainInPADRE_Descriptor(inputDomain);
   }
#endif

doubleArray & 
doubleArray::partition ( const doubleArray & Example_Array )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::partition (const doubleArray & Example_Array) \n");
#endif

     return partition ( Example_Array.getPartition() );
   }

doubleArray &
doubleArray::partition ( const floatArray & Example_Array )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::partition (const floatArray & Example_Array) \n");
#endif

     return partition ( Example_Array.getPartition() );
   }

doubleArray & doubleArray::partition ( const intArray & Example_Array )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::partition (const intArray & Example_Array) \n");
#endif

     return partition ( Example_Array.getPartition() );
   }
#endif

#if defined(APP) || defined(PPP)
int
doubleArray::getGhostBoundaryWidth ( int Axis ) const
   {
  // The returns the Array_Descriptor.Array_Domain.InternalGhostCellWidth[Axis]
     int width = Array_Descriptor.getGhostBoundaryWidth(Axis);
  // The ghost boundary width of an array need not match that of it's
  // partitioning object since the arrays ghost boundary width can be
  // reset seperate from the partitioning
  // APP_ASSERT (width == getInternalGhostCellWidth(Axis));
     return width;
   }
#endif

#if defined(APP) || defined(PPP)
// Depreciated function (not documented in manual)
int
doubleArray::getInternalGhostCellWidth ( int Axis ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 9)
          printf ("Inside of doubleArray::getInternalGhostCellWidth (int Axis) \n");
#endif

#if defined(PPP)
  // APP_ASSERT (Array_Descriptor != NULL);
     return Array_Descriptor.Array_Domain.InternalGhostCellWidth[Axis];
#else
     static int Dummy_Integer = 0;
     return Dummy_Integer;
#endif
   }

doubleArray &
doubleArray::setGhostCellWidth ( Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
     return setInternalGhostCellWidth (Integer_List);
   } 

doubleArray &
doubleArray::setGhostCellWidth ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of doubleArray::setGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif

     setGhostCellWidth(Integer_List);
     return *this;
   }

doubleArray &
doubleArray::setGhostCellWidthSaveData ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of doubleArray::setGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
#if defined(PPP)
  // Save old Serial array so that this operation does not distroy data (or decide if it should or not)
  // printf ("Old data not saved as a result of call to doubleArray::setInternalGhostCellWidth \n");
  // If we work on the serial arrays directly then we can avoid a temporary limitation of P++
  // in which the operands of a binary operand must have the same ghost cell widths.
  // doubleArray Temporary_Copy = *this;
     doubleSerialArray Temporary_Copy = *Array_Descriptor.SerialArray;

     setGhostCellWidth(Integer_List);

  // This brings out a bug in P++ which does not permit operations
  // between operands with different size ghost boundaries.
  // printf ("SORRY NOT IMPLEMENTED, doubleArray::setInternalGhostCellWidthSaveData is not implemented yet! \n");
  // APP_ABORT();

  // copy previous data back into new array so that data is preserved.
     *Array_Descriptor.SerialArray = Temporary_Copy;

  // Now update the ghost boundaries with the interior edges of the adjacent processors (if distributed)
     updateGhostBoundaries();
#endif
     return *this;
   }


// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setInternalGhostCellWidth
// Interface of A++/P++: P++ specific (Does nothing within A++)
// Complexity: Constant
// Purpose: permit dynamic adjustment of ghost cell 
//          widths along each dimension.  This function 
//          is a helper function for the interface function.
// ******************************************************
// ******************************************************
doubleArray &
doubleArray::setInternalGhostCellWidth ( Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of doubleArray::setInternalGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
#if defined(PPP)
  // Save old Serial array so that this operation does not distroy data (or decide if it should or not)
     //printf ("Old data not saved as a result of call to doubleArray::setInternalGhostCellWidth \n");

  // SerialArray_Descriptor_Type *Old_Serial_Array_Descriptor = NULL;
     if ( getRawDataReferenceCount() == getRawDataReferenceCountBase() )
        {
#if defined(PPP) && defined(USE_PADRE)
       // We have to remove the references in PADRE to the Serial_Array object
       // which is being deleted.  This is a consequence of P++ using PADRE in a way
       // so as to prevent the redundent storage of Array_Domain objects 
       // (specifically we use PADRE in a way so that only references are stored).
          setLocalDomainInPADRE_Descriptor(NULL);
#endif
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
       // printf ("BEFORE delete in setInternalGhostCellWidth: Array_Descriptor.SerialArray->getReferenceCount() = %d \n",
       //      Array_Descriptor.SerialArray->getReferenceCount());
       // Array_Descriptor.SerialArray->view("In setInternalGhostCellWidth");
          Array_Descriptor.SerialArray->decrementReferenceCount();
          if (Array_Descriptor.SerialArray->getReferenceCount() < getReferenceCountBase())
               delete Array_Descriptor.SerialArray;
          Array_Descriptor.SerialArray = NULL;
       // printf ("Exiting in setInternalGhostCellWidth \n");
       // APP_ABORT();
        }
       else
        {
          printf ("ERROR: Existing references exit to the present array data (can't change in doubleArray::setInternalGhostCellWidth)! \n");

       // We exit here -- but we don't have to do so (this is temporary code)!
          APP_ABORT();
        }

     Array_Descriptor.setInternalGhostCellWidth(Integer_List);
  // view("BEFORE REALLOCATION");

  // Now reallocate the data using the descriptor that has has its InternalGhostCellWidth modified
  // Allocate_Parallel_Array (TRUE);
     Allocate_Array_Data (TRUE);
  // MDI_double_Allocate(SerialArray->Array_Descriptor);
  // view("AFTER REALLOCATION");

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from inside of doubleArray::setInternalGhostCellWidth");
#endif

  // Now update the ghost boundaries with the interior edges of the adjacent processors (if distributed)
  // updateGhostBoundaries();
#endif
     return *this;
   }

// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setInternalGhostCellWidth
// Interface of A++/P++: P++ specific (Does nothing within A++)
// Complexity: Constant
// Purpose: permit dynamic adjustment of ghost cell 
//          widths along each dimension.
// ******************************************************
// ******************************************************
doubleArray &
doubleArray::setInternalGhostCellWidth ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of doubleArray::setInternalGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
     setInternalGhostCellWidth(Integer_List);
     return *this;
   }

// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setInternalGhostCellWidthSaveData
// Interface of A++/P++: P++ specific (Does nothing within A++)
// Complexity: Constant
// Purpose: permit dynamic adjustment of ghost cell 
//          widths along each dimension. This function 
//          saves and recopies the data after changing
//          the ghost cell widths.  As a final step it
//          updates the ghost boundaries to force a 
//          consistant representation of the data.
// ******************************************************
// ******************************************************
doubleArray &
doubleArray::setInternalGhostCellWidthSaveData ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of doubleArray::setInternalGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
#if defined(PPP)
  // Save old Serial array so that this operation does not distroy data (or decide if it should or not)
  // printf ("Old data not saved as a result of call to doubleArray::setInternalGhostCellWidth \n");
  // If we work on the serial arrays directly then we can avoid a temporary limitation of P++
  // in which the operands of a binary operand must have the same ghost cell widths.
  // doubleArray Temporary_Copy = *this;
     doubleSerialArray Temporary_Copy = *Array_Descriptor.SerialArray;

     setInternalGhostCellWidth(Integer_List);

  // This brings out a bug in P++ which does not permit operations
  // between operands with different size ghost boundaries.
  // printf ("SORRY NOT IMPLEMENTED, doubleArray::setInternalGhostCellWidthSaveData is not implemented yet! \n");
  // APP_ABORT();

  // copy previous data back into new array so that data is preserved.
     *Array_Descriptor.SerialArray = Temporary_Copy;

  // Now update the ghost boundaries with the interior edges of the adjacent processors (if distributed)
     updateGhostBoundaries();
#endif
     return *this;
   }

// ******************************************************
// ******************************************************
// ******************************************************
// MEMBER FUNCTION: getExternalGhostCellWidth
// Purpose:  access function for ghost cell width for 
//           each axis.
// ******************************************************
// ******************************************************
int
doubleArray::getExternalGhostCellWidth ( int Axis ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::getExternalGhostCellWidth (int Axis) \n");
#endif

#if defined(PPP)
  // APP_ASSERT (Array_Descriptor != NULL);
     return Array_Descriptor.Array_Domain.ExternalGhostCellWidth[Axis];
#else
     static int Dummy_Integer = 0;
     return Dummy_Integer;
#endif
   }

// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setExternalGhostCellWidth
// Purpose: This function represents access to a feature 
//          within BlockParti.  It is disabled since this
//          feature of BlockParti is not an important part 
//          of P++ at this time.  The idea is that both
//          Internal AND External boundaries can be 
//          constructed The internal ones represent ghost 
//          boundaries and the external ones represent
//          extended boundaries as required for overlap 
//          between seperate blocks (for multi block 
//          solution methods).
// ******************************************************
// ******************************************************
//doubleArray & doubleArray::setExternalGhostCellWidth ( int Width_I, int Width_J, int Width_K, int Width_L )
//doubleArray & doubleArray::setExternalGhostCellWidthSaveData ( ARGUMENT_LIST_MACRO_INTEGER )
doubleArray &
doubleArray::setExternalGhostCellWidth ( ARGUMENT_LIST_MACRO_INTEGER )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::setExternalGhostCellWidth \n");
#endif
  // Avoid compiler warnings about unused input variables
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO
     if (&Integer_List);

#if defined(PPP)
     printf ("External Ghost Cell Widths currently not implemented in P++! \n");
     printf ("Exiting ... \n");
     APP_ABORT();

   //APP_ASSERT (Array_Descriptor != NULL);
     /*
     Array_Descriptor.ExternalGhostCellWidth[0] = Width_I;
     Array_Descriptor.ExternalGhostCellWidth[1] = Width_J;
     Array_Descriptor.ExternalGhostCellWidth[2] = Width_K;
     Array_Descriptor.ExternalGhostCellWidth[3] = Width_L;
     */

#if defined(USE_PADRE)
  // What PADRE function do we use here?
     printf ("NEED TO CALL PADRE \n"); APP_ABORT();
#else
     Array_Descriptor.Array_Domain.BlockPartiArrayDomain = Array_Descriptor.Build_BlockPartiArrayDomain();
#endif
#endif
     return *this;
   }

void
doubleArray::updateGhostBoundaries() const
   {
  // The function body is not defined for A++ or SerialArray objects
#if defined(PPP)
     if (!isNullArray())
        {
          APP_ASSERT (Array_Descriptor.SerialArray != NULL);
       // Internal_Partitioning_Type::updateGhostBoundaries (*this,*Array_Descriptor.SerialArray);
#if defined(USE_PADRE)
          APP_ASSERT (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL);
          if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
             {
               Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->updateGhostBoundaries(getDataPointer());
             }
#else
          Internal_Partitioning_Type::updateGhostBoundaries (*this,*Array_Descriptor.SerialArray);
#endif
        }
#endif
   }

#endif




// *************************************************************
// Forces a temporary to become a nontemporay.
// If it was a temporary the its data is placed into another doubleArray
// so that no coping is done.  If it was not a temporary then it is
// just passed though (nothing is done!).
// *************************************************************
doubleArray
evaluate ( const doubleArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::evaluate! \n");
#endif

#if EXTRA_ERROR_CHECKING
  // error checking (since I think this might be a problem for deferred evaluation)!
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
          printf ("ERROR: evaluate used while Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION == TRUE \n");
          printf ("Evaluate for DEFER_EXPRESSION_EVALUATION == TRUE -- Sorry, not implemented yet ... \n");
          APP_ABORT();
        }
#endif

  // Bug fix (12/1/93) we have to call the copy constructor in both cases since
  // the input might be referenced after the evaluate function is called.  
  // Though this is not possible in the case of a temporary -- except for the 
  // case of: doubleArray & X = A+B;  which can be referenced after evaluate (X)
  // but that is a little bit pathological for any array class that tries to
  // manage temporaries (and the point is that the user should use this function) 
  // so we would write doubleArray & X = evaluate(A+B); with no performance penalty
  // from the evaluate function (since not copying is done).

     return doubleArray ( X );  // call copy constructor!
   }

#if !defined(PPP)
// *************************************************************
// Fixup User_Base so scalar indexing is consistent between processors.
// This means that a ghost cell will be accessed by the same subscript
// on either processor if it lies on both.
// *************************************************************
void
doubleArray::Fixup_User_Base 
   ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_Pointer_List ,
     const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Local_Index_Pointer_List )
   {
     int i;
     for (i=0; i < MAX_ARRAY_DIMENSION; i++)
        {
          if (Local_Index_Pointer_List[i] != NULL)
             {
            // ... Don't reset User_Base unless Index_Triplet ...
               if (Local_Index_Pointer_List[i]->Index_Mode == Index_Triplet)
                  {
                 // (2/3/2000) Catch the case where the stride does not divide into the difference of the two 
                 // bases evenly since this should cause an error internally
                    APP_ASSERT ( (Local_Index_Pointer_List[i]->Base - Index_Pointer_List[i]->Base) % Index_Pointer_List[i]->Stride == 0);
	            int offset = (Local_Index_Pointer_List[i]->Base - Index_Pointer_List[i]->Base) /  Index_Pointer_List[i]->Stride;

                 // printf ("In doubleArray::Fixup_User_Base(): axis = %d View_Offset = %d offset = %d \n",
                 //      i,Array_Descriptor.Array_Domain.View_Offset,offset);

                    Array_Descriptor.Array_Domain.User_Base[i] = Index_Pointer_List[i]->Base + offset;
	            if (i==0)
                         Array_Descriptor.Array_Domain.Scalar_Offset[0] = 
                              Array_Descriptor.Array_Domain.View_Offset -
                                   Array_Descriptor.Array_Domain.User_Base[0] *
                                   Array_Descriptor.Array_Domain.Stride[0];
                      else
                         Array_Descriptor.Array_Domain.Scalar_Offset[i] =
                              Array_Descriptor.Array_Domain.Scalar_Offset[i-1] -
                                   Array_Descriptor.Array_Domain.User_Base[i] *
                                   Array_Descriptor.Array_Domain.Stride[i] *
                                   Array_Descriptor.Array_Domain.Size[i-1];
                  }
             }
            else
             {
            // printf ("In doubleArray::Fixup_User_Base(): Local_Index_Pointer_List[%d] != NULL \n",i);
             }

       // printf ("In doubleArray::Fixup_User_Base(): Array_Descriptor.Array_Domain.Scalar_Offset[%d] = %d \n",
       //      i,Array_Descriptor.Array_Domain.Scalar_Offset[i]);
        }

     POINTER_LIST_INITIALIZATION_MACRO;
   }
#endif

// *************************************************************
// This function checks the internal consistancy of A++ objects
// *************************************************************
void
doubleArray::Test_Consistency( const char *Label ) const 
   {
  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since doubleArray::Test_Consistency (%s) was called! \n",Label);
     APP_ABORT();
#endif

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 5)
          printf ("Inside of doubleArray::Test_Consistency! (Label = %s) \n",Label);
#if defined(PPP)
   if (Optimization_Manager::Optimize_Scalar_Indexing == FALSE)
     Communication_Manager::Sync();
#endif
#endif

  // int temp;

  // Check that these are the correct values since on some machines
  // (like the HP) they can be initialized in a strange order (see 
  // note at top of file)
     APP_ASSERT (DECIMAL_DISPLAY_FORMAT     == 0);
     APP_ASSERT (EXPONENTIAL_DISPLAY_FORMAT == 1);
     APP_ASSERT (SMART_DISPLAY_FORMAT       == 2);
     APP_ASSERT (DISPLAY_FORMAT             == 2);

  // error checking!
  // APP_ASSERT(Array_Descriptor != NULL);
  // if (Array_Descriptor == NULL)
  //    {
  //      printf ("ERROR: Array_Descriptor == NULL in doubleArray::Test_Consistency \n");
  //      APP_ABORT();
  //    }

#if defined(APP) || defined(SERIAL_APP)
  // This fails on 3 processors but passes on 1 and two processors
  // this makes no sense so I have commented it out for now!
     if ( (sizeof(int_array) != sizeof(doubleArray)) || (1 == 2) )
        {
#if 1
          printf ("sizeof(int_array) = %d \n",sizeof(int_array) );
          printf ("Address of int_array.Array_Descriptor = %p \n",&(((int_array*) this)->Array_Descriptor) );
          printf ("sizeof(doubleArray) = %d \n",sizeof(doubleArray) );
          printf ("Address of START this       = %p \n",this);
          printf ("Address of Array_Descriptor = %p \n",&Array_Descriptor);
          printf ("Address of Array_Storage    = %p \n",&Array_Storage);
          printf ("Address of freepointer      = %p \n",&freepointer);
          printf ("Address of referenceCount   = %p \n",&referenceCount);
#endif
          printf ("sizeof(array_domain) = %d  sizeof(Array_Domain_Type) = %d \n",
               sizeof(array_domain),sizeof(Array_Domain_Type));
          printf ("sizeof(int_array) = %d  !=  sizeof(doubleArray) = %d \n",
               sizeof(int_array),sizeof(doubleArray));
        }
#endif
#if defined(APP) || defined(SERIAL_APP)
     APP_ASSERT ( sizeof(int_array) == sizeof(doubleArray) );
#endif

  // We can't test this unless it appears in the users code.  I don't know why this is this way.
  // We can if it is forced to be included as it is now (I think).
  // But if other application libraries have static arrays we cannot be sure of the
  // order of the call to the constructors and since this function is called within
  // the constructors the constructors might be called before the APP_Unit_Range is setup.
  // We hope that just not calling this here will fix the problem but actually it would
  // seem that the array object built via static constructors could in theory be built
  // incorrectly.  We have to wait and see if this is a bug that we have to fix better.
	    
  //APP_Unit_Range.Test_Consistency("Test of APP_Unit_Range in doubleArray::Test_Consistency");

  // Consistancy checking specific to the array descriptor was moved to a member
  // function of that class (the way it should be done) (30/12/94)
     Array_Descriptor.Test_Consistency(Label);

  // printf ("PASSED: Call to Array_Descriptor.Test_Consistency(%s) \n",Label);

  // printf ("Test 0.4 \n");
  // check for illegal values in the reference counts
     APP_ASSERT(referenceCount >= getReferenceCountBase());

  // printf ("Test 0.5 \n");
  // printf ("getdoubleArrayPointer() = %p \n",getdoubleArrayPointer());
  // printf ("Test 0.6 \n");

  // I just changed the way that reference counting is done -- specifically the reference counting 
  // of the Serial_A++ objects in P++ is handled the same was as the A++ object reference count the
  // raw data arrays which they use.  The makes A++ to P++ the same as raw C arrays are to A++
  // and with VERY similar control code and reference counting properties (maybe exactly the same).
  // In addition each A++/P++ object can be referenced using another referenceCount (this is design for use by the
  // user applications and is not touched internally in A++/P++ (mearly provided as a feature)). 

  // printf ("Test 1 \n");
  // printf ("Exiting ... \n");
  // APP_ABORT();

#if defined(USE_EXPRESSION_TEMPLATES)
     int ExpectedOffset = 0;
     if (usesIndirectAddressing() == FALSE)
        {
          ExpectedOffset = Array_Descriptor.Array_Domain.Base[0];
          for (int i=1; i < MAX_ARRAY_DIMENSION; i++)
             {
               ExpectedOffset += Array_Descriptor.Array_Domain.Base[i] * Array_Descriptor.Array_Domain.Size[i-1];
             }
        }
     if (Array_Descriptor.Array_Domain.ExpressionTemplateOffset != ExpectedOffset)
        {
          printf ("ERROR: Array_Descriptor.Array_Domain.ExpressionTemplateOffset != ExpectedOffset \n");
          printf ("Array_Descriptor.Array_Data                            = %p \n",Array_Descriptor.Array_Data);
          printf ("Array_Descriptor.ExpressionTemplateDataPointer         = %p \n",Array_Descriptor.ExpressionTemplateDataPointer);
          printf ("Array_Descriptor.Array_Domain.ExpressionTemplateOffset = %d \n",Array_Descriptor.Array_Domain.ExpressionTemplateOffset);
          printf ("ExpectedOffset                                         = %d \n",ExpectedOffset);
          Array_Descriptor.display("ERROR in doubleArray<T,Template_Dimension>::Test_Consistency()");
       // APP_ABORT();
        }
     APP_ASSERT (Array_Descriptor.Array_Domain.ExpressionTemplateOffset == ExpectedOffset);
     if (Array_Descriptor.Array_Data != NULL)
        {
          if (Array_Descriptor.ExpressionTemplateDataPointer != Array_Descriptor.Array_Data+ExpectedOffset)
             {
               printf ("ERROR: Array_Descriptor.ExpressionTemplateDataPointer != Array_Descriptor.Array_Data+ExpectedOffset \n");
               printf ("Array_Descriptor.Array_Data                            = %p \n",Array_Descriptor.Array_Data);
               printf ("Array_Descriptor.ExpressionTemplateDataPointer         = %p \n",Array_Descriptor.ExpressionTemplateDataPointer);
               printf ("Array_Descriptor.Array_Domain.ExpressionTemplateOffset = %d \n",Array_Descriptor.Array_Domain.ExpressionTemplateOffset);
               printf ("ExpectedOffset                                         = %d \n",ExpectedOffset);
               Array_Descriptor.display("ERROR in doubleArray<T,Template_Dimension>::Test_Consistency()");
            // APP_ABORT();
             }
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer == Array_Descriptor.Array_Data+ExpectedOffset);
        }
#endif

#if defined(PPP)
  // We had to build a way for P++ to tell other libraries (like PARTI) now many
  // processors we have and it is important that these stay sync'd (so we test them here).
  // APP_ASSERT (Global_PARTI_P_plus_plus_Interface_Number_Of_Processors == Communication_Manager::Number_Of_Processors);

  // We always want a vaild SerialArray even if it is a NULL Array
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);

     Array_Descriptor.SerialArray->Test_Consistency(Label);

// ... (12/15/96,kdb) this might not be true in some cases because the
//  output of the overlapping boundary model might produce a null array
//  for the serialArray that is used temporarily for a conformable operation ...
#if 0
     if (Array_Descriptor.SerialArray->isNullArray() == TRUE)
        {
           int i;
           for (i=0; i < MAX_ARRAY_DIMENSION; i++)
              {
                if (Array_Descriptor.Array_Domain.Local_Mask_Index [i].getMode() != Null_Index)
                   {
                     printf ("Exiting from doubleArray::Test_Consistency (%s) \n",Label);
                   }
                APP_ASSERT(Array_Descriptor.Array_Domain.Local_Mask_Index [i].getMode() == Null_Index);
              }
        }
#endif

  // This is not a valid test (even after the corrction for Is_A_Null_Array) since any indexed
  // region might have a middle processor subregion for which Is_Contiguous_Data is TRUE even if the
  // global array (since it is indexed and a subregion) has Is_Contiguous_Data set to FALSE.
  // APP_ASSERT ( Array_Descriptor.Is_Contiguous_Data == Array_Descriptor.SerialArray->Array_Descriptor.Is_Contiguous_Data );
  // if ( Array_Descriptor.SerialArray->Array_Descriptor.Is_A_Null_Array == FALSE )
  //    {
  //      APP_ASSERT ( Array_Descriptor.Is_Contiguous_Data == Array_Descriptor.SerialArray->Array_Descriptor.Is_Contiguous_Data );
  //    }

  // If one is a temporary then the other must be marked as a temporary (so we check it)
     if (Array_Descriptor.isTemporary() != 
	 Array_Descriptor.SerialArray->isTemporary())
        {
          printf ("ERROR: Array_Descriptor.Is_A_Temporary = %s BUT SerialArray->Array_Descriptor.Is_A_Temporary = %s \n",
             (Array_Descriptor.isTemporary()) ? "TRUE" : "FALSE" ,
             (Array_Descriptor.SerialArray->isTemporary()) ? "TRUE" : "FALSE" );
          APP_ABORT();
        }

  // All P++ objects should have a valid pointer to a partitioning object (they may be multiply referenced)
  // Actally if they use the default partitioning then the pointer is NULL (Is this a good implementation?)
  // APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL);

  // We have to skip some of these tests if we have a Null_Array
     int i = 0;
     if (Array_Descriptor.isNullArray() == FALSE)
        {
       // Some tests can only be done for the case of a single processor
          if (Communication_Manager::Number_Of_Processors == 1)
             {
            // This is the case of P++ on a single processor!
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 9)
                  {
                 // view("Called from inside of doubleArray::Test_Consistency");
                    printf ("getLength(0) = %d getLength(1) = %d getLength(2) = %d getLength(3) = %d \n",
                              getLength(0),getLength(1),getLength(2),getLength(3));
                    printf ("SerialArray->getLength(0) = %d SerialArray->getLength(1) = %d SerialArray->getLength(2) = %d SerialArray->getLength(3) = %d \n",
                              Array_Descriptor.SerialArray->getLength(0),
			      Array_Descriptor.SerialArray->getLength(1),
			      Array_Descriptor.SerialArray->getLength(2),
			      Array_Descriptor.SerialArray->getLength(3));
                    printf ("getInternalGhostCellWidth(0) = %d getInternalGhostCellWidth(1) = %d getInternalGhostCellWidth(2) = %d getInternalGhostCellWidth(3) = %d \n",
                              getInternalGhostCellWidth(0),
			      getInternalGhostCellWidth(1),
			      getInternalGhostCellWidth(2),
			      getInternalGhostCellWidth(3));
                  }
#endif

               for (i=0; i < Array_Descriptor.Array_Domain.Domain_Dimension; i++)
                  {
                    int Offset_For_Ghost_Boundary_Width = 
                         (Array_Descriptor.isView() == TRUE) ? 0 : getInternalGhostCellWidth(0);
#if 1
                 // redundant test with the APP_ASSERTion below
                 // if ( getLength(i) != Array_Descriptor.SerialArray->getLength(i) - 2 * Offset_For_Ghost_Boundary_Width )
                    if ( getLength(i) != Array_Descriptor.SerialArray->getLength(i) )
                       {
                         printf ("Offset_For_Ghost_Boundary_Width = %d \n",Offset_For_Ghost_Boundary_Width);
                         printf ("getLength(%d) = %d  != Array_Descriptor.SerialArray->getLength(%d) = %d \n",
                              i,getLength(i),i,Array_Descriptor.SerialArray->getLength(i));
                         printf ("getInternalGhostCellWidth(%d) = %d \n",i,getInternalGhostCellWidth(i));
                         view("This from Test_Consistency #1");
                         APP_ABORT();
                       }
#endif

                 // True only of the case on a single processor 
                 // Bug fix (1/12/95) fixed case with nonzero ghost boundary widths
                 // APP_ASSERT( getLength(i) == Array_Descriptor.SerialArray->getLength(i) - 2 * Offset_For_Ghost_Boundary_Width );
                    APP_ASSERT( getLength(i) == Array_Descriptor.SerialArray->getLength(i) );

                 // printf ("Exiting from inside of doubleArray::Test_Consistency \n");
                 // APP_ABORT();

#if 1
                 // redundant test with the APP_ASSERTion below
                 // if ( getBase(i) != SerialArray->getBase(i) + Offset_For_Ghost_Boundary_Width )
                    if (getRawBase(i) != Array_Descriptor.SerialArray->getRawBase(i))
                       {
                         printf ("In doubleArray::Test_Consistency -- getRawBase(%d) = %d  != SerialArray->getRawBase(%d) = %d \n",
                                   i,getRawBase(i),i,
				   Array_Descriptor.SerialArray->getRawBase(i));
                                /* getLength(i),Array_Descriptor.SerialArray->getLength(i); */
                         printf ("Offset_For_Ghost_Boundary_Width = %d \n",Offset_For_Ghost_Boundary_Width);
                         view("This from Test_Consistency #2");
                         APP_ABORT();
                       }
#endif
                 // APP_ASSERT( getBase(i) == Array_Descriptor.SerialArray->getBase(i) + Offset_For_Ghost_Boundary_Width );
                    if ( getRawBase(i) != Array_Descriptor.SerialArray->getRawBase(i) )
                       {
                         display("ERROR: getRawBase(i) != Array_Descriptor.SerialArray->getRawBase(i)");
                       }
                    APP_ASSERT( getRawBase(i) == Array_Descriptor.SerialArray->getRawBase(i) );
                    if ( getRawBound(i) != Array_Descriptor.SerialArray->getRawBound(i) )
                       {
                         view("ERROR: getRawBound(i) != Array_Descriptor.SerialArray->getRawBound(i)");
                       }
                    APP_ASSERT( getRawBound(i) == Array_Descriptor.SerialArray->getRawBound(i) );
                  }
             }

// if defined(USE_PADRE)
#if 1
       // What PADRE function do we use here?
       // printf ("NEED TO CALL PADRE \n"); APP_ABORT();
       // PADRE specefic error checking is done in the P++ objects containing PADRE objects.

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
          printf ("In Array::Test_Consistency(): Significant error checking commented out due to unresolved conflict in cvs update! \n");
#endif

#else
       // If the PARTI descriptor is availabel we can do error checking on it
       // if (Array_Descriptor.Array_Domain.BlockPartiArrayDomain != NULL)
          if ( (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain() != NULL) && (Array_Descriptor.SerialArray->isNullArray() == FALSE) )
             {
            // Error checking must be done in the array member function because it uses
            // the getBase array member function.
#if 0
               int Sizes[MAX_ARRAY_DIMENSION];
               laSizes( Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),Sizes);
               printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points[0] = %d \n",
                    Array_Descriptor.Array_Domain.Array_Domain.Left_Number_Of_Points[0]);
               printf ("Sizes[0] = %d  Sizes[1] = %d Sizes[2] = %d Sizes[3] = %d \n",
                    Sizes[0],Sizes[1],Sizes[2],Sizes[3]);
               printf ("getRawBase(0) = %d getRawBase(1) = %d getRawBase(2) = %d getRawBase(3) = %d \n",
                    getRawBase(0),getRawBase(1),getRawBase(2),getRawBase(3));
               printf ("getLocalRawBase(0) = %d getLocalRawBase(1) = %d getLocalRawBase(2) = %d getLocalRawBase(3) = %d \n",
                    getLocalRawBase(0),getLocalRawBase(1),getLocalRawBase(2),getLocalRawBase(3));
#endif

               if (!Array_Descriptor.Array_Domain.Uses_Indirect_Addressing)
	       {
               // Make sure that the dimension of the PARTI descriptor matches 
	       // that of the P++ descriptor!
                  APP_ASSERT 
		     (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain()
		      ->nDims == Array_Descriptor.Array_Domain.Domain_Dimension );
                  APP_ASSERT 
		     (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain()
		      ->nDims == 
		      doubleArray_Descriptor_Type
		      ::computeArrayDimension (Array_Descriptor) );
	       }

               for (i=0; i < Array_Descriptor.Array_Domain.Domain_Dimension; i++)
                  {
                 // Skip error checking in case of gLBnd(Array_Descriptor->BlockPartiArrayDomain,i) < 0 
                 // -1 is the error code returned by the PARTI library (meaning that the dimension was out of range)
                 // (Actually meaning that the data is not owned by this processor).
#if 1
                    int PARTI_Parallel_Descriptor_Lower_Bound = gLBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i);
#else
                 // The following modification to the PARTI_Parallel_Descriptor_Lower_Bound variable allows
                 // for the case where a non unit stride makes the first local Index of a view different
                 // from the position of first element of the local partition.  It is important only for 
                 // views which have non unit stride!
                    APP_ASSERT (SerialArray);
                 // APP_ASSERT (SerialArray->Array_Descriptor);
                    int PARTI_Parallel_Descriptor_Lower_Bound = gLBnd
		       (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(), i) 
		       +Array_Descriptor.SerialArray->Array_Descriptor.
			Array_Domain.Base[i];
#endif
                 // Trap out error return value for PARTI gLBnd
                    if ( PARTI_Parallel_Descriptor_Lower_Bound == -1 )
                       {
                         printf ("No array data located on this processor! \n");
                         printf ("Axis = %d  gLBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i) = %d \n",
                              i,gLBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i));
                       }
                 // APP_ASSERT (PARTI_Parallel_Descriptor_Lower_Bound != -1);
                    if ( PARTI_Parallel_Descriptor_Lower_Bound != -1 )
                       {
                         if (Array_Descriptor.isLeftPartition(i))
                            {
                              if ( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] != 0 )
                                 {
                                   printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Left_Number_Of_Points[i]);
                                   printf ("PARTI_Parallel_Descriptor_Lower_Bound  (for Axis = %d) = %d \n",i,PARTI_Parallel_Descriptor_Lower_Bound );
                                   printf ("Array_Descriptor.Array_Domain.Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Base[i]);
                                   printf ("Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Data_Base[i]);
                                   view ("ERROR: Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == PARTI_Parallel_Descriptor_Lower_Bound - Array_Descriptor.Array_Domain.Base[i]");
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == 0 );
                            }
                           else
                            {
                           // When the right or middle processor is close enough to the left edge of the left most processor
                           // (as in when the number of array elements is approximately the number of processors).
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (Array_Descriptor->Base[i] + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]);
                           // Divide the ghost boudary width by the Strid to compute it's contribution to the Left_Number_Of_Points
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (Array_Descriptor->Base[i] + (Array_Descriptor.Array_Domain.InternalGhostCellWidth[i] / Array_Descriptor->Stride[i]));

                           // The following logic supports the error checking of the Left_Number_Of_Points and is complex
                           // because it accounts for the interdependence of the partitioning and the stride of access.
                           // Basically if the partitioning is such that the added ghost boundary width is greater
                           // than or equal to the stride then the Left_Number_Of_Points is decremented.  This relationship
                           // is very simple if the stride is 1 but this code must handle the more general cases.
#if 0
                           // int Remainder = (PARTI_Parallel_Descriptor_Lower_Bound - Array_Descriptor->Base[i]) % Array_Descriptor->Stride[i];
                              int Stride = Array_Descriptor->Stride[i];
                           // int Remainder = (Stride - 1) - (PARTI_Parallel_Descriptor_Lower_Bound % Stride);
                              int Remainder = (Stride - 1) - (PARTI_Parallel_Descriptor_Lower_Bound % Stride);
                           // int Offset_For_Stride = ((Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) >= Array_Descriptor->Stride[i]) ? 1 : 0;
                              int Offset_For_Stride = Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i];
                              Offset_For_Stride = (Offset_For_Stride >= Array_Descriptor.Array_Domain.Stride[i]) ? 
                                                  Offset_For_Stride : 0;
                              APP_ASSERT ( Offset_For_Stride >= 0 );
                           // APP_ASSERT ( Offset_For_Stride <= Array_Descriptor.Array_Domain.Stride[i] );
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (Array_Descriptor->Base[i] + Offset_For_Stride);
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - Offset_For_Stride;
                           // Computed_Left_Number_Of_Points = (Computed_Left_Number_Of_Points >= 0) ? Computed_Left_Number_Of_Points : 0;
#else
#if 0
                           // int Temp_Computed_Left_Number_Of_Points = 
                           //      PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (2 * Array_Descriptor.Array_Domain.InternalGhostCellWidth[i] + Array_Descriptor->Base[i]);
                              int Ghost_Boundary_Width = Array_Descriptor.Array_Domain.InternalGhostCellWidth[i];
           // Nearly correct  int Temp_Computed_Left_Number_Of_Points = 
           //                      (PARTI_Parallel_Descriptor_Lower_Bound - Ghost_Boundary_Width)
           //                 // - (Array_Descriptor->Base[i] - Ghost_Boundary_Width)
           //                    - (Array_Descriptor->Base[i])
           //                //  + (SerialArray->Array_Descriptor->Base[i] - Ghost_Boundary_Width);
           //                //  + (SerialArray->Array_Descriptor->Base[i] + Ghost_Boundary_Width);
           //                    + (SerialArray->Array_Descriptor->Base[i]);
                           // int Offset_For_Stride = Array_Descriptor.SerialArray->Array_Descriptor->Base[i] + Ghost_Boundary_Width;
                           // int Offset_For_Stride = Array_Descriptor.SerialArray->Array_Descriptor->Base[i] - Ghost_Boundary_Width;
                              int Offset_For_Stride = 
				 Array_Descriptor.SerialArray->Array_Descriptor.
				 Array_Domain.Base[i];
                              Offset_For_Stride = (Offset_For_Stride > 0) ? Offset_For_Stride : 0;
                              int Temp_Computed_Left_Number_Of_Points = 
                                   (PARTI_Parallel_Descriptor_Lower_Bound - Ghost_Boundary_Width)
                                 - (Array_Descriptor.Array_Domain.Base[i])
                                 + Offset_For_Stride;
                              int Computed_Left_Number_Of_Points = (Temp_Computed_Left_Number_Of_Points >= 0) ?
                                   Temp_Computed_Left_Number_Of_Points : 0;
#else
#if GIVE_UP_ON_ERROR_CHECKING
                           // This force the error checking to workwhile we test another idea!
                           // printf ("TEMPORARY CODE IN ERROR CHECKING! \n");
                              int Computed_Left_Number_Of_Points = Array_Descriptor.Array_Domain.Left_Number_Of_Points [i];
#else
                           // OK - I give up - this is the simple way to do this (though it does less checking)
                              int Computed_Left_Number_Of_Points = 
                                   Array_Descriptor.Array_Domain.Local_Mask_Index [i].getBase() - 
                                   Array_Descriptor.Array_Domain.Global_Index [i].getBase();
                           // Computed_Left_Number_Of_Points -= 
                           //      (Array_Descriptor->Array_Conformability_Info == NULL) ? 0 :
                           //      Array_Descriptor->Array_Conformability_Info->Lhs_Left_Number_Of_Points_Truncated;
#endif
#endif
#endif
                              if ( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] != Computed_Left_Number_Of_Points )
                                 {
                                   printf ("Computed_Left_Number_Of_Points = %d \n",Computed_Left_Number_Of_Points);
                                // printf ("Offset_For_Stride = %d \n",Offset_For_Stride);
                                   printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Left_Number_Of_Points[i]);
                                   printf ("PARTI_Parallel_Descriptor_Lower_Bound  (for Axis = %d) = %d \n",i,PARTI_Parallel_Descriptor_Lower_Bound );
                                   printf ("Array_Descriptor.Array_Domain.Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Base[i]);
                                   printf ("Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Data_Base[i]);
                                   view ("ERROR: Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == PARTI_Parallel_Descriptor_Lower_Bound - (Array_Descriptor.Array_Domain.Base[i] + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i])");
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == Computed_Left_Number_Of_Points );
                            }
                       }
                  }

            // I think that the use of the Bound[?] below does not get computed correctly
            // if we have a view of a view (so the wrong case would be processed)  We can
            // debug this case at a later date!   ?????
            // APP_ASSERT (Array_Descriptor->isView() == FALSE);
     
            // These are the bounds of the actual data (with assumed base of ZERO)
            // if we just use the Array_Descriptor->Bound[?] then we get the bound of the view
            // (if the array object was a view).  We could use the RawArraySize member function.
               int Bounds[MAX_ARRAY_DIMENSION];
               Bounds [0] = Array_Descriptor.Array_Domain.Size[0] - 1;
               int temp;
	       for ( temp=1; temp<MAX_ARRAY_DIMENSION; temp++ )
                  {
                    Bounds [temp] = (Array_Descriptor.Array_Domain.Size[temp] / Array_Descriptor.Array_Domain.Size[temp-1]) - 1;
                  }

               int SerialArray_Sizes [MAX_ARRAY_DIMENSION];
            // ??????????????????
               Array_Descriptor.SerialArray->Array_Descriptor.getRawDataSize(SerialArray_Sizes); 

               for (i=0; i < Array_Descriptor.Array_Domain.Domain_Dimension; i++)
                  {
                 // Skip error checking in case of gLBnd(Array_Descriptor->BlockPartiArrayDomain,i) < 0
                 // -1 is the error code returned by the PARTI library (meaning that the dimension was out of range)
#if 1
                    int PARTI_Parallel_Descriptor_Upper_Bound = gUBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i);
#else
                 // The following modification to the PARTI_Parallel_Descriptor_Lower_Bound variable allows
                 // for the case where a non unit stride makes the first local Index of a view different
                 // from the position of first element of the local partition.  It is important only for 
                 // views which have non unit stride!
                    APP_ASSERT (SerialArray);
                 // APP_ASSERT (SerialArray->Array_Descriptor);
                    int PARTI_Parallel_Descriptor_Upper_Bound = gUBnd
		       (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i) -
                        ((SerialArray_Sizes[i]-1) - 
			Array_Descriptor.SerialArray->Array_Descriptor.
			Array_Domain.Bound[i]);
#endif
                 // Trap out error return value for PARTI gUBnd
                    if ( PARTI_Parallel_Descriptor_Upper_Bound == -1 )
                       {
                         printf ("PARTI_Parallel_Descriptor_Upper_Bound = %d \n",PARTI_Parallel_Descriptor_Upper_Bound);
                         printf ("SerialArray_Sizes [0-%d] = ", MAX_ARRAY_DIMENSION-1);
                         printf (IO_CONTROL_STRING_MACRO_INTEGER,ARRAY_TO_LIST_MACRO(SerialArray_Sizes));
                         printf ("\n");
                         printf ("Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Bound[%d] = %d \n",
                              i,Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Bound[i]);
                         printf ("Axis = %d  gUBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i) = %d \n",
                              i,gUBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i));
                       }
                 // APP_ASSERT (PARTI_Parallel_Descriptor_Upper_Bound != -1);
                    if ( PARTI_Parallel_Descriptor_Upper_Bound != -1 )
                       {
                         if (Array_Descriptor.isRightPartition(i))
                            {
                              if ( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != 0 )
                                 {
                                   printf ("Array_Descriptor.Array_Domain.Right_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Right_Number_Of_Points[i]);
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] == 0 );
                            }
                           else 
                            {
                           // The following logic supports the error checking of the Left_Number_Of_Points and is complex
                           // because it accounts for the interdependence of the partitioning and the stride of access.
                           // Basically if the partitioning is such that the added ghost boundary width is greater
                           // than or equal to the stride then the Left_Number_Of_Points is decremented.  This relationship
                           // is very simple if the stride is 1 but this code must handle the more general cases.
#if 0
                              int Remainder = (Array_Descriptor.Array_Domain.Bound[i] - PARTI_Parallel_Descriptor_Upper_Bound)  % Array_Descriptor.Array_Domain.Stride[i];
                           // int Offset_For_Stride = Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i] >= Array_Descriptor.Array_Domain.Stride[i];
                              int Offset_For_Stride = ((Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) >= 
                                                        Array_Descriptor.Array_Domain.Stride[i]) ? 
                                                       (Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) : 0;
                              APP_ASSERT ( Offset_For_Stride >= 0 );
                           // APP_ASSERT ( Offset_For_Stride <= Array_Descriptor.Array_Domain.Stride[i] );
                              int Computed_Right_Number_Of_Points = Array_Descriptor.Array_Domain.Bound[i] - 
                                   (PARTI_Parallel_Descriptor_Upper_Bound + Offset_For_Stride);
                              Computed_Right_Number_Of_Points = (Computed_Right_Number_Of_Points >= 0) ? Computed_Right_Number_Of_Points : 0;

                           // if ( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != Array_Descriptor.Array_Domain.Bound[i] - 
                           //      (PARTI_Parallel_Descriptor_Upper_Bound + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) )
#else
#if 0
                           // int Temp_Computed_Left_Number_Of_Points = 
                           //      (PARTI_Parallel_Descriptor_Lower_Bound - Ghost_Boundary_Width)
                           // // - (Array_Descriptor.Array_Domain.Base[i] - Ghost_Boundary_Width)
                           //    - (Array_Descriptor.Array_Domain.Base[i])
                           //    + (SerialArray->Array_Descriptor.Array_Domain.Base[i] - Ghost_Boundary_Width);
                              int Ghost_Boundary_Width = Array_Descriptor.Array_Domain.InternalGhostCellWidth[i];
                           // int Temp_Computed_Right_Number_Of_Points = 
                           //      (Array_Descriptor.Array_Domain.Bound[i])
                           //    - (PARTI_Parallel_Descriptor_Upper_Bound + Ghost_Boundary_Width)
                           //    - (SerialArray->Array_Descriptor.Array_Domain.Bound[i] - Ghost_Boundary_Width);
              // Near working int Temp_Computed_Right_Number_Of_Points = 
              //                   (Array_Descriptor.Array_Domain.Bound[i])
              //                 - (PARTI_Parallel_Descriptor_Upper_Bound + Ghost_Boundary_Width);
                              int Temp_Computed_Right_Number_Of_Points = 
                                   (Array_Descriptor.Array_Domain.Bound[i])
                                 - (PARTI_Parallel_Descriptor_Upper_Bound + Ghost_Boundary_Width)
                                 + (PARTI_Parallel_Descriptor_Upper_Bound - 
                                        (SerialArray->Array_Descriptor.Array_Domain.Bound[i] - 2 * Ghost_Boundary_Width));
                              int Computed_Right_Number_Of_Points = (Temp_Computed_Right_Number_Of_Points >= 0) ?
                                                                     Temp_Computed_Right_Number_Of_Points : 0;
#else
#if GIVE_UP_ON_ERROR_CHECKING
                           // This force the error checking to workwhile we test another idea!
                           // printf ("TEMPORARY CODE IN ERROR CHECKING! \n");
                              int Computed_Right_Number_Of_Points = Array_Descriptor.Array_Domain.Right_Number_Of_Points [i];
#else
                           // OK - I give up - this is the simple way to do this (though it does less checking)
                              int Computed_Right_Number_Of_Points = 
                                   Array_Descriptor.Array_Domain.Global_Index [i].getRawBound() - 
                                   Array_Descriptor.Array_Domain.Local_Mask_Index [i].getBound();
#endif
#endif
#endif
                              if ( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != Computed_Right_Number_Of_Points )
                                 {
                                   printf ("Computed_Right_Number_Of_Points = %d \n",Computed_Right_Number_Of_Points);
                                // printf ("Offset_For_Stride = %d \n",Offset_For_Stride);
                                   printf ("Array_Descriptor.Array_Domain.Right_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Right_Number_Of_Points[i]);
                                   printf ("PARTI_Parallel_Descriptor_Upper_Bound (for Axis = %d) = %d \n",i,PARTI_Parallel_Descriptor_Upper_Bound);
                                   printf ("Array_Descriptor.Array_Domain.Bound[%d] = %d \n",i,Array_Descriptor.Array_Domain.Bound[i]);
                                   view ("ERROR: Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != Computed_Right_Number_Of_Points");
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] == Computed_Right_Number_Of_Points );
                            }
                       }
                  }
             }  // end of block from if ( Array_Descriptor.Array_Domain.BlockPartiArrayDomain != NULL )

          if ((Array_Descriptor.Array_Domain.Global_Index[0].getBase()  !=getRawBase(0)) && 
	       (Array_Descriptor.Array_Domain.Global_Index[0].getMode() != Null_Index) &&
	       !(Array_Descriptor.Array_Domain.Uses_Indirect_Addressing))
             {
               printf ("getRawBase(0) ================================== %d \n",getRawBase(0));
               printf ("Array_Descriptor.Array_Domain.Global_Index[0].getBase() = %d \n",Array_Descriptor.Array_Domain.Global_Index[0].getBase());
               Array_Descriptor.Array_Domain.Global_Index[0].display("Array_Descriptor.Array_Domain.Global_Index[0]");
             }

          if ((Array_Descriptor.Array_Domain.Global_Index[1].getBase()!=getRawBase(1)) && (Array_Descriptor.Array_Domain.Global_Index[1].getMode() != Null_Index) )
             {
               printf ("getRawBase(1) ================================== %d \n",getRawBase(1));
               printf ("Array_Descriptor.Array_Domain.Global_Index[1].getBase() = %d \n",Array_Descriptor.Array_Domain.Global_Index[1].getBase());
               Array_Descriptor.Array_Domain.Global_Index[1].display("Array_Descriptor.Array_Domain.Global_Index[1]");
             }
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[0].getBase()==getRawBase(0)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[0].getMode()==Null_Index) || Array_Descriptor.Array_Domain.Uses_Indirect_Addressing );
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[1].getBase()==getRawBase(1)) ||
                       (Array_Descriptor.Array_Domain.Global_Index[1].getMode()==Null_Index) );
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[2].getBase()==getRawBase(2)) ||
                       (Array_Descriptor.Array_Domain.Global_Index[2].getMode()==Null_Index) );
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[3].getBase()==getRawBase(3)) ||
                       (Array_Descriptor.Array_Domain.Global_Index[3].getMode()==Null_Index) );

          if ( (Array_Descriptor.Array_Domain.Global_Index[0].getBound() != getRawBound(0)) &&
               (Array_Descriptor.Array_Domain.Global_Index[0].getMode()  == Index_Triplet)  &&
		!Array_Descriptor.Array_Domain.Uses_Indirect_Addressing )
             {
               view("ERROR: Array_Descriptor.Array_Domain.Global_Index[0].getBound() != getRawBound(0)");
               printf ("getRawBound(0) = %d \n",getRawBound(0));
               printf ("Array_Descriptor.Array_Domain.Global_Index[0].getBound() = %d \n",
                    Array_Descriptor.Array_Domain.Global_Index[0].getBound());
            // I think this should be an error!
               APP_ABORT();
             }

#if GIVE_UP_ON_ERROR_CHECKING
      //  printf ("TEMPORARY CODE IN ERROR CHECKING! \n");
#else
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[0].getBound() == getRawBound(0)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[0].getMode()  == Null_Index) ); 
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[1].getBound() == getRawBound(1)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[1].getMode()  == Null_Index) ); 
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[2].getBound() == getRawBound(2)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[2].getMode()  == Null_Index) ); 
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[3].getBound() == getRawBound(3)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[3].getMode()  == Null_Index) ); 

       // Check consistancy of the Local_Mask_Index since this an important part of the message passing 
       // interpretation and general P++ operation.
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
            // The size of the local view should match the size of the local mask array
               if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                  {
                 // I can't seem to enforce this (I wonder why it is false?)
                 // Answer: Because ghost boundaies are included in the 
                 //         local_Mask_Index and NOT in the serial array view
                 // APP_ASSERT( Array_Descriptor.SerialArray->getLength(i) == 
                 //             Array_Descriptor.Array_Domain.Local_Mask_Index[i].length() );

                 // Debugging code added (7/22/2000): Error checking for the local mask index data
                    int length = Size[i];
                    if (i > 0)
                         length /= Size[i-1];

                    APP_ASSERT (Local_Mask_Index [i].getMode() != Null_Index);
                    APP_ASSERT (length  == Local_Mask_Index[i].getLength());
                    APP_ASSERT (Data_Base[i] == Local_Mask_Index[i].getBase());
                    APP_ASSERT (Data_Base[i]+length == Local_Mask_Index[i].getBound());
                    APP_ASSERT (1 == Local_Mask_Index[i].getStride());

                 // Verify that the global index is not a Null_Index
                    APP_ASSERT (Global_Index [i].getMode() != Null_Index);
                  }

               if ( Array_Descriptor.isLeftPartition(i) )
                  {
                 // If the Local_Mask_Index is a Null_Array then we want to skip this test
                 // so we only do the test if Local_Mask_Index is an Index_Triplet
                    APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != All_Index);

                 // Bugfix (4/18/95) If the view is a part of the array not owned by the local partition then the
                 // SerialArray will be a NULL array and so we must check for that case and skip
                 // the error checking if we have discovered this case.
                 // if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                    if ( (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet) &&
                         (Array_Descriptor.SerialArray->isNullArray() == FALSE) )
                       {
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() != getRawBase(i) )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBase() = %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase());
                              printf ("Array_Descriptor.Array_Domain.Base[%d] ======================= %d \n",i,Array_Descriptor.Array_Domain.Base[i]);
                              printf ("Array_Descriptor.Array_Domain.InternalGhostCellWidth[%d] ===== %d \n",
                                   i,Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]);
                              printf ("getLocalRawBase(%d) ================================= %d \n",i,getLocalRawBase(i) );
                              printf ("SerialArray->Array_Descriptor.Array_Domain.Base[%d] ===== %d \n",i,SerialArray->Array_Descriptor.Array_Domain.Base[i]);
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() == getRawBase(i) );
                       }
                  }
                 else
                  {
                 // We can't test this because we don't know if the internal boundaries are included in the Local_Mask_Index.
#if 0
                    if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                       {
                      // APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() == getLocalRawBase(i) );
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() != 
			      Array_Descriptor.SerialArray->Array_Descriptor.
			      Array_Domain.Data_Base[i] )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBase() = %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase());
                              printf ("getLocalRawBase(%d) ================================= %d \n",i,getLocalRawBase(i) );
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase()
				      == Array_Descriptor.SerialArray->
				      Array_Descriptor.Array_Domain.Data_Base[i] );
                       }
#endif
                  }

            // if (Array_Descriptor.Array_Domain.Right_Number_Of_Points [i] == 0)
               if ( Array_Descriptor.isRightPartition(i) )
                  {
                 // If the Local_Mask_Index is a Null_Array then we want to skip this test
                 // so we only do the test if Local_Mask_Index is an Index_Triplet
                    APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != All_Index);

                 // Bugfix (4/18/95) If the view is a part of the array not owned by the local partition then the
                 // SerialArray will be a NULL array and so we must check for that case and skip
                 // the error checking if we have discovered this case.
                 // if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                    if ( (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet) &&
                         (Array_Descriptor.SerialArray->isNullArray() == FALSE) )
                       {
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() != getLocalRawBound(i) )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBound() ======= %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound());
                              printf ("Array_Descriptor.Array_Domain.InternalGhostCellWidth[%d] ============ %d \n",
                                   i,Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]);
                              printf ("getLocalRawBound(%d) ======================================= %d \n",i,getLocalRawBound(i) );
                              view ("ERROR: Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() != getLocalRawBound(i)");
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == getLocalRawBound(i) );
                       }
                  }
                 else
                  {
                 // We can't test this because we don't know if the internal boundaries are included in the Local_Mask_Index.
#if 0
                    if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                       {
                      // APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == getLocalBound(i) );
                      // APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == Array_Descriptor.SerialArray->Array_Descriptor->Data_Base[i] );
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() != Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Data_Base[i] + Bounds[i] )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBound() = %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound());
                              printf ("getLocalRawBound(%d) ================================= %d \n",i,getLocalRawBound(i) );
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Data_Base[i] + Bounds[i] );
                       }
#endif
                  }

            // printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBase()  = %d \n",i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() );
            // printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBound() = %d \n",i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() );
            // printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points [%d]  = %d \n",i,Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] );
            // printf ("Array_Descriptor.Array_Domain.Right_Number_Of_Points [%d] = %d \n",i,Array_Descriptor.Array_Domain.Right_Number_Of_Points [i] );
            // printf ("getBase(%d)  = %d \n",i,getBase(i) );
            // printf ("getBound(%d) = %d \n",i,getBound(i) );

            // If the Local_Mask_Index is a Null_Array then we want to skip this test
            // so we only do the test if Local_Mask_Index is an Index_Triplet
               APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != All_Index);
               if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                  {
                    APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase()  - Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == getRawBase(i) ); 
                    APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() + Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] == getRawBound(i) ); 
                  }
             }
 // End of if not defined USE_PADRE
#endif
#endif
        }  // end of block from if (Array_Descriptor.isNullArray() == FALSE) above

 // Cannot make this APP_ASSERTion since it must be allowed (example: A(I) = sqrt(A(I));)
 // APP_ASSERT(SerialArray->Array_Descriptor.Is_Contiguous_Data == TRUE);

 // endif for if PPP above
#endif

#if 0
     if (isNullArray() == TRUE)
        {
          if (isView() == TRUE)
             {
            // Even a null array needs to have a valid data point if it is a view.
            // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
               APP_ASSERT(getDataPointer() != NULL);
             }
        }
#endif

  // Test the setup of the View pointer offsets (this is the same test done in the scalar indexing operators)
#if defined(PPP)
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer0 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[0]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer1 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[1]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer2 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[2]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer3 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[3]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer4 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[4]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer5 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[5]);
#else
     APP_ASSERT (Array_Descriptor.Array_View_Pointer0 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[0]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer1 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[1]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer2 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[2]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer3 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[3]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer4 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[4]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer5 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[5]);
#endif

#if COMPILE_DEBUG_STATEMENTS
#if defined(PPP)
   if (Optimization_Manager::Optimize_Scalar_Indexing == FALSE)
     Communication_Manager::Sync();
#endif
     if (APP_DEBUG > 5)
          printf ("Leaving doubleArray::Test_Consistency! (Label = %s) \n",Label);
#endif
   }



// *************************************************************
// Conformable operations are required for all array operations
// (meaning that all the axis dimensions must be the same)
// their use allows P++ to interpret the parallel message passing
// Need one function for each type that we support!
// *************************************************************
void
doubleArray::Test_Conformability ( const doubleArray & X ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of doubleArray::Test_Conformability \n");
#endif

  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     if (Index::Index_Bounds_Checking == FALSE)
        {
          printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since doubleArray::Test_Conformability was called! \n");
          APP_ABORT();
        }
#endif

#if defined(PPP)
  // Call this because it will trap the case of mixed width ghost boundary operations
  // Which is a temporary trap since it is hard to handle and will be implemented later
     if ( Internal_Partitioning_Type::Has_Same_Ghost_Boundary_Widths
	     ( Array_Descriptor.Array_Domain, X.Array_Descriptor.Array_Domain ) == FALSE )
        {
          printf ("ERROR in doubleArray::Test_Conformability ( const doubleArray & X ) \n");
          printf ("Operands have different width ghost boundaries -- sorry -- not yet supported! \n");
          printf ("Internal Ghost Boundary widths: Lhs (%d, %d, %d, %d) Rhs (%d, %d, %d, %d) \n",
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[0],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[2],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[3],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[0], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[2], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[3] );
#if COMPILE_DEBUG_STATEMENTS
            // display("THIS");
            // X.display("X");
#endif
          printf ("Exiting ... \n");
          APP_ABORT();
        }
       else
        {
       // printf ("ERROR in doubleArray::Test_Conformability ( const doubleArray & X ) \n");
       // printf ("Operands have SAME width ghost boundaries \n");
        }
#endif

     if (!isConformable(X))
        {
          printf ("********************************************************* \n"); 
          printf ("             ERROR in CONFORMABILITY TEST                 \n");
          printf ("********************************************************* \n"); 

          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("ERROR: doubleArray - doubleArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("ERROR: doubleArray - doubleArray (direct addressing) operation is non conformable, an error! \n");

#if COMPILE_DEBUG_STATEMENTS
       // Print out extra information if internal debugging is turned on
          printf ("********************************************************* \n"); 
          view("This (LHS in binary operation)");
          printf ("********************************************************* \n"); 
          X.view("X (RHS in binary operation)");
          printf ("********************************************************* \n"); 

       // print out the error message again since the views of the data have likely confused the user!
          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("(END OF DISPLAY) ERROR: doubleArray - doubleArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("(END OF DISPLAY) ERROR: doubleArray - doubleArray (direct addressing) operation is non conformable, an error! \n");
#endif
          APP_ABORT();
        }     

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving doubleArray::Test_Conformability \n");
#endif
   }

bool
doubleArray::isConformable ( const doubleArray & X ) const
   {
  // Conformability between array objects in array expressions is rather strict.
  // The advantage is that such operations have significant semantics and can be
  // optimized with tools like ROSE (a tool for generating optimizing preprocessors).
  // So operations like: A(I,J) = B(I,J) are conformable but operations like 
  // A(I,J) = B(J,I) are not conformable unless I and J are the same length.
  // Similarly A(0,I) = B(I) are not conformable!

     bool Return_Value = TRUE;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of doubleArray::isConformable \n");
#endif
  // APP_ASSERT(Array_Descriptor != NULL);
  // APP_ASSERT(X.Array_Descriptor != NULL);

     if (usesIndirectAddressing() || X.usesIndirectAddressing())
        {
       // Conformability for indirect addressing is restricted to JUST counting 
       // the number of elements.  So A(2,I) is conformable with B(I,2) if "I" 
       // is an intArray object.  
          int Max_Dimension_Size   = elementCount();
          int X_Max_Dimension_Size = X.elementCount();

          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("NOTE: in doubleArray::Test_Conformability (indirect test) -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif
             }
            else
             {
            // Test for conformability of operation between array object using indirect addressing!
               if ( Max_Dimension_Size != X_Max_Dimension_Size )
                    Return_Value = FALSE;
             }
        }
       else
        {
          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 3)
                    printf ("NOTE: in doubleArray::Test_Conformability -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif

#if defined(APP)
            // If the LHS is a valid array but the RHS in an A++ operation is NULL then this is not a valid operation
            // P++ may have to allow this because of the case that operations are defined on processors that have no data
               if ( (!Array_Descriptor.isNullArray() && X.isNullArray()) )
                    Return_Value  = FALSE;
#endif
             }
            else
             {
               int length[MAX_ARRAY_DIMENSION];
               int X_length[MAX_ARRAY_DIMENSION];
               int temp;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
#if defined(PPP)
                    length[temp]   = getLength(temp) - 2*getInternalGhostCellWidth(temp);
                    X_length[temp] = X.getLength(temp) - 2*X.getInternalGhostCellWidth(temp);
#else
                    length[temp]   = getLength(temp);
                    X_length[temp] = X.getLength(temp);
#endif
                  }

               bool Error_Printed = FALSE;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
                    if ( (length[temp] != X_length[temp]) && (Error_Printed == FALSE) )
                       {
                         Return_Value  = FALSE;
                      // Avoid reprinting the error for other values of temp
                         Error_Printed = TRUE;
                         printf ("Lengths in each dimension = \n");
                         int temp2;
                         for (temp2 = 0; temp2 < MAX_ARRAY_DIMENSION; temp2++)
                              printf ("Along axis=%d -- length = %d  length of X = %d \n",temp,length[temp2],X_length[temp2]);
                       }
                  }
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving doubleArray::isConformable \n");
#endif

     return Return_Value;
   }

// *************************************************************
// Conformable operations are required for all array operations
// (meaning that all the axis dimensions must be the same)
// their use allows P++ to interpret the parallel message passing
// Need one function for each type that we support!
// *************************************************************
void
doubleArray::Test_Conformability ( const floatArray & X ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of doubleArray::Test_Conformability \n");
#endif

  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     if (Index::Index_Bounds_Checking == FALSE)
        {
          printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since doubleArray::Test_Conformability was called! \n");
          APP_ABORT();
        }
#endif

#if defined(PPP)
  // Call this because it will trap the case of mixed width ghost boundary operations
  // Which is a temporary trap since it is hard to handle and will be implemented later
     if ( Internal_Partitioning_Type::Has_Same_Ghost_Boundary_Widths
	     ( Array_Descriptor.Array_Domain, X.Array_Descriptor.Array_Domain ) == FALSE )
        {
          printf ("ERROR in doubleArray::Test_Conformability ( const floatArray & X ) \n");
          printf ("Operands have different width ghost boundaries -- sorry -- not yet supported! \n");
          printf ("Internal Ghost Boundary widths: Lhs (%d, %d, %d, %d) Rhs (%d, %d, %d, %d) \n",
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[0],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[2],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[3],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[0], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[2], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[3] );
#if COMPILE_DEBUG_STATEMENTS
            // display("THIS");
            // X.display("X");
#endif
          printf ("Exiting ... \n");
          APP_ABORT();
        }
       else
        {
       // printf ("ERROR in doubleArray::Test_Conformability ( const floatArray & X ) \n");
       // printf ("Operands have SAME width ghost boundaries \n");
        }
#endif

     if (!isConformable(X))
        {
          printf ("********************************************************* \n"); 
          printf ("             ERROR in CONFORMABILITY TEST                 \n");
          printf ("********************************************************* \n"); 

          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("ERROR: doubleArray - floatArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("ERROR: doubleArray - floatArray (direct addressing) operation is non conformable, an error! \n");

#if COMPILE_DEBUG_STATEMENTS
       // Print out extra information if internal debugging is turned on
          printf ("********************************************************* \n"); 
          view("This (LHS in binary operation)");
          printf ("********************************************************* \n"); 
          X.view("X (RHS in binary operation)");
          printf ("********************************************************* \n"); 

       // print out the error message again since the views of the data have likely confused the user!
          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("(END OF DISPLAY) ERROR: doubleArray - floatArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("(END OF DISPLAY) ERROR: doubleArray - floatArray (direct addressing) operation is non conformable, an error! \n");
#endif
          APP_ABORT();
        }     

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving doubleArray::Test_Conformability \n");
#endif
   }

bool
doubleArray::isConformable ( const floatArray & X ) const
   {
  // Conformability between array objects in array expressions is rather strict.
  // The advantage is that such operations have significant semantics and can be
  // optimized with tools like ROSE (a tool for generating optimizing preprocessors).
  // So operations like: A(I,J) = B(I,J) are conformable but operations like 
  // A(I,J) = B(J,I) are not conformable unless I and J are the same length.
  // Similarly A(0,I) = B(I) are not conformable!

     bool Return_Value = TRUE;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of doubleArray::isConformable \n");
#endif
  // APP_ASSERT(Array_Descriptor != NULL);
  // APP_ASSERT(X.Array_Descriptor != NULL);

     if (usesIndirectAddressing() || X.usesIndirectAddressing())
        {
       // Conformability for indirect addressing is restricted to JUST counting 
       // the number of elements.  So A(2,I) is conformable with B(I,2) if "I" 
       // is an intArray object.  
          int Max_Dimension_Size   = elementCount();
          int X_Max_Dimension_Size = X.elementCount();

          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("NOTE: in doubleArray::Test_Conformability (indirect test) -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif
             }
            else
             {
            // Test for conformability of operation between array object using indirect addressing!
               if ( Max_Dimension_Size != X_Max_Dimension_Size )
                    Return_Value = FALSE;
             }
        }
       else
        {
          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 3)
                    printf ("NOTE: in doubleArray::Test_Conformability -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif

#if defined(APP)
            // If the LHS is a valid array but the RHS in an A++ operation is NULL then this is not a valid operation
            // P++ may have to allow this because of the case that operations are defined on processors that have no data
               if ( (!Array_Descriptor.isNullArray() && X.isNullArray()) )
                    Return_Value  = FALSE;
#endif
             }
            else
             {
               int length[MAX_ARRAY_DIMENSION];
               int X_length[MAX_ARRAY_DIMENSION];
               int temp;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
#if defined(PPP)
                    length[temp]   = getLength(temp) - 2*getInternalGhostCellWidth(temp);
                    X_length[temp] = X.getLength(temp) - 2*X.getInternalGhostCellWidth(temp);
#else
                    length[temp]   = getLength(temp);
                    X_length[temp] = X.getLength(temp);
#endif
                  }

               bool Error_Printed = FALSE;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
                    if ( (length[temp] != X_length[temp]) && (Error_Printed == FALSE) )
                       {
                         Return_Value  = FALSE;
                      // Avoid reprinting the error for other values of temp
                         Error_Printed = TRUE;
                         printf ("Lengths in each dimension = \n");
                         int temp2;
                         for (temp2 = 0; temp2 < MAX_ARRAY_DIMENSION; temp2++)
                              printf ("Along axis=%d -- length = %d  length of X = %d \n",temp,length[temp2],X_length[temp2]);
                       }
                  }
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving doubleArray::isConformable \n");
#endif

     return Return_Value;
   }

// *************************************************************
// Conformable operations are required for all array operations
// (meaning that all the axis dimensions must be the same)
// their use allows P++ to interpret the parallel message passing
// Need one function for each type that we support!
// *************************************************************
void
doubleArray::Test_Conformability ( const intArray & X ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of doubleArray::Test_Conformability \n");
#endif

  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     if (Index::Index_Bounds_Checking == FALSE)
        {
          printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since doubleArray::Test_Conformability was called! \n");
          APP_ABORT();
        }
#endif

#if defined(PPP)
  // Call this because it will trap the case of mixed width ghost boundary operations
  // Which is a temporary trap since it is hard to handle and will be implemented later
     if ( Internal_Partitioning_Type::Has_Same_Ghost_Boundary_Widths
	     ( Array_Descriptor.Array_Domain, X.Array_Descriptor.Array_Domain ) == FALSE )
        {
          printf ("ERROR in doubleArray::Test_Conformability ( const intArray & X ) \n");
          printf ("Operands have different width ghost boundaries -- sorry -- not yet supported! \n");
          printf ("Internal Ghost Boundary widths: Lhs (%d, %d, %d, %d) Rhs (%d, %d, %d, %d) \n",
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[0],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[2],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[3],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[0], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[2], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[3] );
#if COMPILE_DEBUG_STATEMENTS
            // display("THIS");
            // X.display("X");
#endif
          printf ("Exiting ... \n");
          APP_ABORT();
        }
       else
        {
       // printf ("ERROR in doubleArray::Test_Conformability ( const intArray & X ) \n");
       // printf ("Operands have SAME width ghost boundaries \n");
        }
#endif

     if (!isConformable(X))
        {
          printf ("********************************************************* \n"); 
          printf ("             ERROR in CONFORMABILITY TEST                 \n");
          printf ("********************************************************* \n"); 

          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("ERROR: doubleArray - intArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("ERROR: doubleArray - intArray (direct addressing) operation is non conformable, an error! \n");

#if COMPILE_DEBUG_STATEMENTS
       // Print out extra information if internal debugging is turned on
          printf ("********************************************************* \n"); 
          view("This (LHS in binary operation)");
          printf ("********************************************************* \n"); 
          X.view("X (RHS in binary operation)");
          printf ("********************************************************* \n"); 

       // print out the error message again since the views of the data have likely confused the user!
          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("(END OF DISPLAY) ERROR: doubleArray - intArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("(END OF DISPLAY) ERROR: doubleArray - intArray (direct addressing) operation is non conformable, an error! \n");
#endif
          APP_ABORT();
        }     

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving doubleArray::Test_Conformability \n");
#endif
   }

bool
doubleArray::isConformable ( const intArray & X ) const
   {
  // Conformability between array objects in array expressions is rather strict.
  // The advantage is that such operations have significant semantics and can be
  // optimized with tools like ROSE (a tool for generating optimizing preprocessors).
  // So operations like: A(I,J) = B(I,J) are conformable but operations like 
  // A(I,J) = B(J,I) are not conformable unless I and J are the same length.
  // Similarly A(0,I) = B(I) are not conformable!

     bool Return_Value = TRUE;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of doubleArray::isConformable \n");
#endif
  // APP_ASSERT(Array_Descriptor != NULL);
  // APP_ASSERT(X.Array_Descriptor != NULL);

     if (usesIndirectAddressing() || X.usesIndirectAddressing())
        {
       // Conformability for indirect addressing is restricted to JUST counting 
       // the number of elements.  So A(2,I) is conformable with B(I,2) if "I" 
       // is an intArray object.  
          int Max_Dimension_Size   = elementCount();
          int X_Max_Dimension_Size = X.elementCount();

          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("NOTE: in doubleArray::Test_Conformability (indirect test) -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif
             }
            else
             {
            // Test for conformability of operation between array object using indirect addressing!
               if ( Max_Dimension_Size != X_Max_Dimension_Size )
                    Return_Value = FALSE;
             }
        }
       else
        {
          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 3)
                    printf ("NOTE: in doubleArray::Test_Conformability -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif

#if defined(APP)
            // If the LHS is a valid array but the RHS in an A++ operation is NULL then this is not a valid operation
            // P++ may have to allow this because of the case that operations are defined on processors that have no data
               if ( (!Array_Descriptor.isNullArray() && X.isNullArray()) )
                    Return_Value  = FALSE;
#endif
             }
            else
             {
               int length[MAX_ARRAY_DIMENSION];
               int X_length[MAX_ARRAY_DIMENSION];
               int temp;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
#if defined(PPP)
                    length[temp]   = getLength(temp) - 2*getInternalGhostCellWidth(temp);
                    X_length[temp] = X.getLength(temp) - 2*X.getInternalGhostCellWidth(temp);
#else
                    length[temp]   = getLength(temp);
                    X_length[temp] = X.getLength(temp);
#endif
                  }

               bool Error_Printed = FALSE;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
                    if ( (length[temp] != X_length[temp]) && (Error_Printed == FALSE) )
                       {
                         Return_Value  = FALSE;
                      // Avoid reprinting the error for other values of temp
                         Error_Printed = TRUE;
                         printf ("Lengths in each dimension = \n");
                         int temp2;
                         for (temp2 = 0; temp2 < MAX_ARRAY_DIMENSION; temp2++)
                              printf ("Along axis=%d -- length = %d  length of X = %d \n",temp,length[temp2],X_length[temp2]);
                       }
                  }
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving doubleArray::isConformable \n");
#endif

     return Return_Value;
   }


// *******************************************************
// fill function provides a way to assign a scalar to an 
// array object
// *******************************************************
doubleArray & doubleArray::fill ( double x )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::fill! (value = %f)\n",double(x));
#endif

     return operator=(x);
   }

// *******************************************************
// Transpose function for A++ arrays
// This is in the Range of a Matrix function but we provide 
// it for for the array class.
// *******************************************************
doubleArray & transpose ( const doubleArray & X )
   {
  // This function is not implemented efficiently -- we can reimplement it later!
  // Some of the functionality within Block Parti could help implement this better.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::transpose! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
     X.Test_Consistency("Called from TOP of doubleArray::transpose()");
#endif

     int temp;

  // APP_ASSERT(X.Array_Descriptor != NULL);
     int Dimension[MAX_ARRAY_DIMENSION];

  // Get the dimensions of the input array object (dimension is an inlined function
  // and if it only occures once on a statement it will be inlined by the Cfront compilers
  // if it appears twice in a statement it would not be inlined -- so we initialized
  // intermediate variable with single calls to the inlined function).
     for ( temp=0; temp<MAX_ARRAY_DIMENSION; temp++ ) Dimension[temp] = X.getLength(temp);

  // Build temporary result to return value
     doubleArray & Result = *(new doubleArray (Dimension[1],Dimension[0]));

#if COMPILE_DEBUG_STATEMENTS
  // We don't really want to initialize this unless we are debugging the code!
     Result = 0;
#endif

  // Now we have to fixup the descriptor
     Result.Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
#if defined(PPP)
     APP_ASSERT(Result.Array_Descriptor.SerialArray != NULL);
  // APP_ASSERT(Result.Array_Descriptor.SerialArray->Array_Descriptor != NULL);
     Result.Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
  // If there is any message passing to be done to update X (if it is a temporary) the we should
  // do it before we proceed with the transpose (I think).
  // Result.Array_Descriptor->Array_Conformability_Info = getArray_Conformability_Info (X);
     if (X.isTemporary() == TRUE)
        {
       // printf ("Input to doubleArray::transpose is a temporary \n");
          bool Nonzero_Ghost_Cell_Width = FALSE;
          int i;
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
               if (X.Array_Descriptor.Array_Domain.InternalGhostCellWidth [i] > 0)
                    Nonzero_Ghost_Cell_Width = TRUE;
       // Do the message passing to update the ghost boundaries
          if (Nonzero_Ghost_Cell_Width == TRUE)
               X.updateGhostBoundaries();
          if (X.Array_Descriptor.Array_Domain.Array_Conformability_Info != NULL)
             {
            // Added conventional mechanism for reference counting control
            // operator delete no longer decriments the referenceCount.
               X.Array_Descriptor.Array_Domain.Array_Conformability_Info->decrementReferenceCount();
               if (X.Array_Descriptor.Array_Domain.Array_Conformability_Info->getReferenceCount() < 
                   Array_Conformability_Info_Type::getReferenceCountBase())
                    delete X.Array_Descriptor.Array_Domain.Array_Conformability_Info;
             }
        }
  // Build a new history (start a new history) of how the ghost boundaries are used.
  // we need a new history because the transpose means that a different set of ghost boundaries
  // and a different partitioning is likely in use.
     //Result.Array_Descriptor.Array_Domain.Array_Conformability_Info = new Array_Conformability_Info_Type(Result.Array_Descriptor);
     Result.Array_Descriptor.Array_Domain.Array_Conformability_Info = new Array_Conformability_Info_Type(Result.Array_Descriptor.Array_Domain);
#endif

  // This initializes the memory and so avoids purify errors of uninitialized 
  // memory reads (umr) in the scalar indexing function.

  // Bugfix (2/13/96) can't use temporary in array operation else it will be deleted prematurely.
  // But because we mark the Result as a temporary the operator= tries to delete it prematurely
  // so we have to initialize the Result before we mark it as a temporary.
  // Result = 0;

#if 1
     if (Dimension[3] == Dimension[2] == 1)
        {
          int Base_I   = X.getBase(0);
          int Base_J   = X.getBase(1);
          int Base_K   = X.getBase(2);
          int Base_L   = X.getBase(3);
          int Bound_I  = X.getBound(0);
          int Bound_J  = X.getBound(1);
          int Stride_I = X.getStride(0);
          int Stride_J = X.getStride(1);
          for (int j=Base_J; j <= Bound_J; j += Stride_J)
               for (int i=Base_I; i <= Bound_I; i += Stride_I)
                  {
                 // printf ("Result(%d,%d) = X(%d,%d) BEFORE Result(%d,%d) = %f X(%d,%d) = %f \n",
                 //      i,j,j,i,i,j,Result(j,i),i,j,X(i,j));
                    Result(j-Base_J,i-Base_I,0,0) = X(i,j,Base_K,Base_L);
                  }
        }
       else
        {
          printf ("Transpose not implemented for arrays of dimension greater than 2! \n");
          APP_ABORT();
        }
#endif

  // APP_ASSERT (X.Array_Descriptor != NULL);
     if (X.isTemporary())
        {
       // printf ("In doubleArray::transpose(): -- Calling the delete operator for the input array! \n");
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          X.decrementReferenceCount();
          if (X.getReferenceCount() < doubleArray::getReferenceCountBase())
               delete &((doubleArray &) X);
        }

  // Result.display("Result in doubleArray::transpose()");

#if COMPILE_DEBUG_STATEMENTS
     Result.Test_Consistency("Called from BASE of doubleArray::transpose()");
#endif

     return Result;
   }

// *******************************************************
// Reference function provides a means of aliasing A++
// objects (with normal problems associated with aliasing)
// *******************************************************
doubleArray &
doubleArray::reference ( const doubleArray & X )
   {
  // USERS SHOULD BE CAREFULL: since this function returns the
  // equivalent of an alias in FORTRAN and so it behaves similarly!

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::reference! \n");
#endif

  // Check to make sure we are not referencing to ourselves and do nothing if we are.
     bool SkipReference = FALSE;
     if (this == &( (doubleArray &) X))
        {
          SkipReference = TRUE;
        }

#if defined(PPP)
     if (Array_Descriptor.SerialArray == X.Array_Descriptor.SerialArray)
        {
          SkipReference = TRUE;
        }
#endif

  // if ( this != &( (doubleArray &) X)) 
     if ( SkipReference == FALSE )
        {
       // When the function is called by the copy constructor then the array object
       // is not yet build so the Array_Descriptor = NULL and the Array_Data = NULL
       // This is how we deteect this case and avoid deleting the objects data 
       // (which has not been built).
#if 0
          if (Array_Descriptor != NULL)
             {
            // To make this more efficent only call delete function if
            // Array_Descriptor->Is_A_Null_Array == FALSE!
               Delete_Array_Data();
               delete Array_Descriptor;
            // Array_Descriptor->ReferenceCountedDelete();
             }
#endif

#if defined(PPP)
       // ... (9/3/97,kdb) memory leak -- we need to delete old serialArray ...
          if (Array_Descriptor.SerialArray != NULL) 
             {
#if defined(USE_PADRE)
            // We have to remove the references in PADRE to the Serial_Array object
            // which is being deleted.  This is a consequence of P++ using PADRE in a way
            // so as to prevent the redundent storage of Array_Domain objects 
            // (specifically we use PADRE in a way so that only references are stored).
               setLocalDomainInPADRE_Descriptor(NULL);
#endif
            // Added conventional mechanism for reference counting control
            // operator delete no longer decriments the referenceCount.
               Array_Descriptor.SerialArray->decrementReferenceCount();
               if (Array_Descriptor.SerialArray->getReferenceCount() < getReferenceCountBase())
	            delete Array_Descriptor.SerialArray; 
             }
          Array_Descriptor.SerialArray = X.Array_Descriptor.SerialArray;

      // ... also need to delete partitioning object because it gets 
      //  overwritten below by operator= for Array_Descriptor ...
	  if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer !=NULL)
             {
            // Bugfix (11/14/2000) we want to handle this consistant with code elsewhere plus 
            // if we decrement the count we need to ALSO delete the Partitioning_Object!
            // Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount--;
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
               APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                           Internal_Partitioning_Type::getReferenceCountBase()-1);
               if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() < 
                   Internal_Partitioning_Type::getReferenceCountBase())
                  {
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 1)
                         printf ("In doubleArray::reference() deleting Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
#endif
                    delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
                  }
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;
             }

       // We have to increment the reference coutn to avoid having the 
       // SerialArray being deleted too early. It is not equivalent to 
       // just increntent the P++ reference count array since that would not
       // effect the Serial_A++ array operations that are done within P++ operators
       // it would only effect the deletion of the Serial_A_++ arrays by the
       // P++ delete operator (there is a subtle and important difference).
       // SerialArray->IncrementReferenceCount();
          incrementRawDataReferenceCount();
#else
       // Bugfix (2/10/98) fix memory leak when A.reference(B) is used in a loop!
          Delete_Array_Data();

       // Copy the pointer to the data!
          Array_Descriptor.Array_Data = X.Array_Descriptor.Array_Data;

       // ... set this later after Array_Desccriptor has been set ...
       // Array_View_Pointer = X.Array_View_Pointer;
       // no info in the descriptor yet 
       // POINTER_LIST_INITIALIZATION_MACRO;
#endif

       // Build a new descriptor to avoid reference counting of the Array_Descriptor!
       // This also allows the reference to  d e f i n e  a new base for the reference
       // (this is handy in adaptive mesh refinement).  This is required to avoid
       // bad interactions between the reference counting used on the SerialArray 
       // and the reference counting on the array data used in views.
       // In A++ it might not be a problem but in P++ the reference must have
       // a different Array_ID than what is referenced to avoid forcing the
       // reference count to be less than zero when views are taken of the referenced
       // array subsequently.
       // Array_Descriptor = new Array_Descriptor_Type (*X.Array_Descriptor);
       // Array_Descriptor = Array_Descriptor_Type (X.Array_Descriptor);
       //   Array_Descriptor = Array_Descriptor_Type<double,MAX_ARRAY_DIMENSION> (X.Array_Descriptor);
       // ... (9/4/97,kdb) this is iniefficient and messes up reference counting 
       //  for the partitioning object ...
       //   Array_Descriptor = 
       //     doubleArray_Descriptor_Type
       //	(X.Array_Descriptor);
       // ... (9/9/97,kdb) see comment below ...
       // printf ("In doubleArray::reference -- X.Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      X.Array_ID(),X.getRawDataReferenceCount());
       // printf ("In doubleArray::reference --   Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      Array_ID(),getRawDataReferenceCount());

       // In the case where we repeat A.refernece(B) more then once the Array_ID's are
       // the same and we can't return it to the stack of Array_ID's
          //if (Array_ID() != X.Array_ID())
          if (Array_ID() != X.Array_ID() && getRawDataReferenceCount()<getReferenceCountBase())
               Array_Domain_Type::Push_Array_ID (Array_ID());

       // This represents the dominate overhead of the reference function!
          Array_Descriptor = X.Array_Descriptor;

       // printf ("In doubleArray::reference -- (AFTER assignment) Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      Array_ID(),getRawDataReferenceCount());

       // Force Array_ID's to be the same between the reference and it's object
       // Array_Descriptor.Push_Array_ID (Array_ID());
       // ... (9/9/97,kdb) must do this with Array_ID above before it is
       //  overwritten ...
       // Array_Domain_Type::Push_Array_ID (Array_ID());
       // ... don't need this anymore because operator= for descriptor 
       //  already does this ...
       //   Array_Descriptor.Array_Domain.Array_ID = X.Array_ID();

#if defined(PPP)
       // ... bug fix (11/5/96,kdb) this array needs to be added to the
       // partitioning object list ...
	  if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer !=NULL)
	    Internal_Partitioning_Type::AddArrayToPartitioning
	       (*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
	  else
	    Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

       // BUG FIX (10/1/94):
       // The reference has the lifetime of the scope of it's construction but its
       // data has the lifetime of that which it is a reference to.
          Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#if defined(PPP)
       // Bugfix (12/15/94)
          Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#endif

#if !defined(PPP)
       // Now increment the reference count (for both array data and the descriptor)!
       // Array_Descriptor_Type::Array_Reference_Count_Array [Array_Descriptor->Array_ID]++;
          incrementRawDataReferenceCount();

       // info from X aready stored in the descriptor so this works
          POINTER_LIST_INITIALIZATION_MACRO;

       // printf ("In doubleArray::reference -- (at BASE) Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      Array_ID(),getRawDataReferenceCount());
#endif
        }

  // (DQ 6/24/2000): Fixed to handle input of temporary.
  // The testcode.C demonstrates the use of a temporary in a reference member function call
  // Plus we now want to compute the number of arrays in use more accurately!
  // We want to only decrement the reference count not delete the data.
  // X.displayReferenceCounts("In doubleArray::reference()");
     Delete_If_Temporary ( X );

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving doubleArray::reference! \n");
#endif
     return *this;
   }

// *******************************************************
// UNreference function provides a means of breaking the 
// aliasing of A++ objects. It creates a deep copy of what
// it referenced previously. 
// *******************************************************
doubleArray &
doubleArray::breakReference()
   {
  // This function builds a new array (internally) and copies
  // the referenced data to the new array and then makes the
  // new array it's internal data and decriments the reference 
  // count on the data.

  // Part of the Deferred Evaluation functionality
     bool Force_Memory_Allocation             = TRUE;

     APP_ASSERT(getRawDataReferenceCount() >= getReferenceCountBase());

  // If the data is not referenced then there is no reference 
  // to break and so there is nothing to do.
     if (getRawDataReferenceCount() > getReferenceCountBase())
        {
          APP_ASSERT(Array_Descriptor.isView() == FALSE);

          doubleArray Old_Array;          // We build a descriptor which the
                                        // next call to reference() will delete
                                        // but this could be made more efficient later.

          Old_Array.reference (*this);  // bumps up reference count on data 
                                        // destructor called on exit which decriments
                                        // the reference count again.

          Delete_Array_Data();          // decriments reference count on data

          Array_Descriptor.Array_Domain.setArray_ID (Array_Descriptor.Array_Domain.Pop_Array_ID());

          Allocate_Array_Data(Force_Memory_Allocation);

#if COMPILE_DEBUG_STATEMENTS
          Test_Consistency("Called from doubleArray::breakReference()");
#endif

#if !defined(PPP)
       // Since this is a new array object is should have an initialize reference count on its
       // raw data.  This is required here because the reference counting mechanism reused the
       // value of zero for one existing reference and no references (this will be fixed soon).
          resetRawDataReferenceCount();
#endif

          *this = Old_Array; // do the assignment of values to new data
        }

     return *this;
   }

// ***********************************************************
// View function which can be called from within dbx
// ***********************************************************
void
APP_view ( const doubleArray & X , const char *Label )
   {
     X.view(Label);
   }

// ***********************************************************
// Display function which can be called from within dbx
// ***********************************************************
void
APP_display ( const doubleArray & X , const char *Label )
   {
     X.display(Label);
   }

// ***********************************************************
// View function provides a means of output for A++ objects
// this function provides output of internal data in A++ objects
// ***********************************************************
doubleArray & doubleArray::view ( const char *Label ) const
   {
  // This function has nothing to do with views in A++ (which are just subarrays)
  // this is a display function which is just more detailed in its output
  // than the regular display member function!

     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
#if COMPILE_DEFERRED_DISPLAY_AND_VIEW_FUNCTIONS
       // This function has problems with the new Solaris C++ compiler!
          doubleArray_Function_16 *Execution_Object = new doubleArray_Function_16 ( view_Function , doubleArray::view , *this , Label );
          APP_ASSERT( Execution_Object != NULL );
#endif
        }
       else
        {
#if COMPILE_DEBUG_STATEMENTS
          printf ("doubleArray::view() (CONST) (this = %p) -- %s \n",this,Label);
#else
          printf ("doubleArray::view() (CONST) -- %s \n",Label);
#endif
       // printf ("Array_Descriptor is a %s pointer = %p! \n",
       //      (Array_Descriptor == NULL) ? "NULL" : "VALID",Array_Descriptor);
     
          Array_Descriptor.display(Label);
       // if (Array_Descriptor != NULL)
       //    {
       //      printf ("Going to Display the Array_Descriptor! \n");
       //      Array_Descriptor->display(Label);
       //    }
       //   else
       //    {
       //      printf ("ERROR: Array_Descriptor is NULL in doubleArray::view! \n");
       //      APP_ABORT();
       //    }

#if defined(PPP)
       // P++ specific reference couting information!
          printf ("Number of references to this P++ object (user's reference count) = %d \n",getReferenceCount());

       // We need to be able to view the data even if the SerialArray is a Null pointer
       // as in the case where it has not yet been initialized for example.
          if (Array_Descriptor.SerialArray == NULL)
               printf ("(Internal) SerialArray is a NULL pointer! (THIS IS AN ERROR MOST OF THE TIME!) \n");
            else
             {
               printf ("Number of references to the Serial A++ object (P++'s reference count on the A++ object) = %d \n",
                    Array_Descriptor.SerialArray->getReferenceCount());
               printf ("(Internal) SerialArray is a %s pointer = %p! (Internal raw array data) SerialArray->getRawDataReferenceCount() = %d \n",
                    (Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID" , 
		     Array_Descriptor.SerialArray ,
                    Array_Descriptor.SerialArray->getRawDataReferenceCount() );
             }
#else
       // A++ specific reference couting information!
          printf ("Number of references to this A++ object (or serial array object) (user's reference count) = %d \n",getReferenceCount());
          printf ("(Internal) Array_Data is a %s pointer = %p! (Internal raw array data) getRawDataReferenceCount() = %d \n",
               (Array_Descriptor.Array_Data == NULL) ? "NULL" : "VALID" , Array_Descriptor.Array_Data ,
               getRawDataReferenceCount() );
#endif

#if defined(PPP)
          printf ("\n");
          printf ("\n");
          printf ("************************************ \n");
          printf ("View SerialArray local to processor! \n");
          printf ("************************************ \n");
          printf ("\n");
          if (Array_Descriptor.SerialArray != NULL)
               Array_Descriptor.SerialArray->view(Label);
#else
       // Now call display function to print out the array data!
          printf ("Call display for data! \n");
          display(Label);
#endif

          printf ("\n");
          printf ("Array_Storage is %s! \n",(Array_Storage == NULL) ? "NULL" : "NOT NULL");
          printf ("\n");
          printf ("\n");

        }

     return *((doubleArray *) this);
   }

// ***********************************************************
// Display function provides a means of output for A++ objects
// ***********************************************************
doubleArray & doubleArray::globalDisplay ( const char *Label ) const
   {
  // This function is less detailed than the normal display function!
  // It only prints out the numerical values!

#if defined(PPP)
  // printf ("doubleArray::globalDisplay() (CONST) (Array_ID = %d) -- %s \n",Array_ID(),Label);
  // printf ("SerialArray is a %s pointer = %p (%d)! \n",(Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID",SerialArray,(int)SerialArray);

#if 0
  // While debugging P++ this is an easier mode to use (fewer P++ operations!)
     APP_ASSERT( Array_Descriptor.SerialArray != NULL );
     Array_Descriptor.SerialArray->display(Label);
#else
  // Send all the data to a serial array and display the serial array as if on a single processor.
  // Build a partition object restricted to a single processor (we choose processor 0 for this).
     Partitioning_Type Single_Processor_Partition (Range(0,0));

  // Single_Processor_Partition.display("Single_Processor_Partition");
     doubleArray Single_Processor_Array ( 0, Single_Processor_Partition);
  // Single_Processor_Array.Array_Descriptor.display("Single_Processor_Array");
  // APP_DEBUG = 5;
     Single_Processor_Array.redim (*this);

  /*
  // ... bug fix (10/24/96,kdb) set this partition to have the same ghost cell
  //  width as this because otherwise the default used to create
  //  Single_Processor_Array might be different than that for this and so
  //  = operation won't work ...
  */

     int ghost_cell_width[MAX_ARRAY_DIMENSION];
     int nd;
     for (nd=0;nd<MAX_ARRAY_DIMENSION;nd++)
	ghost_cell_width[nd] = this->Array_Descriptor.Array_Domain.InternalGhostCellWidth[nd];
     // ... (10/25/96,kdb) turn the following off for now because
     //  setInternalGhostCellWidth doesn't work unless bases are 0 and it's better
     //  to break display in special case than all cases ...
     Single_Processor_Array.setInternalGhostCellWidth 
       ( ARRAY_TO_LIST_MACRO(ghost_cell_width) );
  // Single_Processor_Array.view("In doubleArray::globalDisplay -- Single_Processor_Array");
  // view("In doubleArray::globalDisplay -- *this");
  // APP_DEBUG = 1;

  // printf ("TEMPORARY CODE IN doubleArray::globalDisplay \n");
  // view("PARALLEL THIS ARRAY");
  // Single_Processor_Array.view("BEFORE ASSIGNMENT");
  // APP_DEBUG = 2;
     Single_Processor_Array = *this;
  // APP_DEBUG = 0;
  // Single_Processor_Array.view("AFTER ASSIGNMENT");

  // APP_DEBUG = 0;
  // Single_Processor_Partition.display("Single_Processor_Partition");
     Single_Processor_Array.Array_Descriptor.SerialArray->display(Label);
#endif

#else
     printf ("ERROR: doubleArray::globalDisplay called in non P++ application (Label = %s) \n",Label);
     APP_ABORT();
#endif

  // printf ("Exiting in doubleArray::globalDisplay \n");
  // APP_ABORT();

     return *((doubleArray *) this);
   }


// *********************************************************
// There are many different objects in an array object
// (particularly for parallel array objects and even serial
// array objects using indirect addressing).  This function
// prints out the reference counts of all the different 
// parts of an array object.
// *********************************************************
doubleArray &
doubleArray::displayReferenceCounts (const char* label) const
   {
  // For label to be specified
     APP_ASSERT (label != NULL);

  // APP_ABORT();

     printf ("Inside of doubleArray::displayReferenceCounts(%s) : (is temporary = %s) (isNullArray = %s) \n",
          label,(isTemporary() == TRUE) ? "YES" : "NO",(isNullArray() == TRUE) ? "YES" : "NO");
     printf ("     Array Reference Count (this=%p) (Array id = %d) = %d \n",this,Array_ID(),getReferenceCount());
#if defined(PPP)
     printf ("     P++ array data's reference count ((pointer to doubleSerialArray) getRawDataReferenceCount()) = %d \n",
          getRawDataReferenceCount());
#endif
#if defined(SERIAL_APP)
     printf ("     SerialArray data's reference count ((pointer to double) getRawDataReferenceCount()) = %d \n",
          getRawDataReferenceCount());
#endif
#if defined(APP)
     printf ("     A++ array data's reference count ((pointer to double) getRawDataReferenceCount()) = %d \n",
          getRawDataReferenceCount());
#endif

  // display refernece counts of indirection vectors used in indirect addressing
     Array_Descriptor.Array_Domain.displayReferenceCounts(label);

#if defined(PPP)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);
  // Array_Descriptor.SerialArray->displayReferenceCounts(label);
     printf ("          SerialArray Reference Count (this=%p) (is temporary = %s) (is nullArray = %s) (Array id = %d) = %d \n",
	     Array_Descriptor.SerialArray,
          (Array_Descriptor.SerialArray->isTemporary() == TRUE) ? "YES" : "NO",
          (Array_Descriptor.SerialArray->isNullArray() == TRUE) ? "YES" : "NO",
          Array_Descriptor.SerialArray->Array_ID(),
          Array_Descriptor.SerialArray->getReferenceCount());
     printf ("          serial array data's reference count ((pointer to double) getRawDataReferenceCount()) = %d \n",
          Array_Descriptor.SerialArray->getRawDataReferenceCount());
#if defined(USE_PADRE)
     if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
          Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
               displayReferenceCounts(label);
#endif
#endif

  // Cast away const here
     return *((doubleArray*) this);
   }

// ***********************************************************
// Display function provides a means of output for A++ objects
// ***********************************************************
extern void APP_Null_Initialization_Function(void);
doubleArray &
doubleArray::display ( const char *Label ) const
   {
  // This function is less detailed than the normal display function!
  // It only prints out the numerical values!

  // Text from static_initialization.C:
  // This function is called in the Initialization function for the array objects
  // its purpose is to force this file (which contains the APP_Global_Array_Base
  // and APP_Unit_Range variabels above) to be included at compile time and
  // thus force the static constructors to be called.  The problem was that
  // the Overture dynamic link libraries where using the APP_Unit_Range
  // variable but the users application might not be using it and so it
  // was never included and thus never initialized (static constructor called
  // at load time).  Hopefully this will not cause problems on other architectures
  // using different compilers.
     APP_Null_Initialization_Function();

#if defined(PPP)
     printf ("doubleArray::display() (CONST) (Array_ID = %d) -- %s \n",Array_ID(),Label);
  // Bugfix (12/19/96) the conversion of a pointer to an int is not allowed on the 64-bit SGI compiler.
  // printf ("SerialArray is a %s pointer = %p (%d)! \n",(Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID",SerialArray,(int)SerialArray);
     printf ("SerialArray is a %s pointer = %p! \n",(Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID",Array_Descriptor.SerialArray);

// if !defined(NDEBUG)
#if 0
  // While debugging P++ this is an easier mode to use (fewer P++ operations!)
     APP_ASSERT( Array_Descriptor.SerialArray != NULL );
     Array_Descriptor.SerialArray->display(Label);
#else
     globalDisplay(Label);
  // printf ("ERROR CHECKING exiting in P++ version of doubleArray::display \n");
  // APP_ABORT();
#endif

  // Now build the array on processor 0 so it can be displayed in it's more complete form for users
#else
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
#if COMPILE_DEFERRED_DISPLAY_AND_VIEW_FUNCTIONS
       // This function has problems with the new Solaris C++ compiler!
          doubleArray_Function_16 *Execution_Object = new doubleArray_Function_16 ( display_Function , doubleArray::display , *this , Label );
          APP_ASSERT( Execution_Object != NULL );
#endif
        }
       else
        {
       // printf ("doubleArray::display() (CONST) (Array_ID = %d) -- %s \n",Array_ID(),Label);
          printf ("doubleArray::display() (CONST) (Array_ID = %d) -- %s \n",Array_Descriptor.Array_ID(),Label);
#if 0
          if (Array_Descriptor != NULL)
             {
#if DISPLAY_ALL_DATA
            // printf ("Going to Display the Array_Descriptor! \n");
            // Array_Descriptor.display();
#endif
             }
            else
             {
               printf ("ERROR: Array_Descriptor is NULL in display! \n");
               APP_ABORT();
             }
#endif

#if DISPLAY_ALL_DATA
          printf ("Array_Data is a %s pointer = %p (%d)! \n",(Array_Descriptor.Array_Data == NULL) ? "NULL" : "VALID",
               Array_Descriptor.Array_Data,Array_Descriptor.Array_Data);
#endif

       // Choose a  for the display of values.  Optionally the user can have the 
       // display function choose a  based on the max and min values to be displayed!
       // Bugfix (11/13/96) This has to be given the default value (which the user can set).
       // int Local_Display_Format = DECIMAL_DISPLAY_FORMAT;
          int Local_Display_Format = DISPLAY_FORMAT;

          APP_ASSERT ( (DISPLAY_FORMAT == DECIMAL_DISPLAY_FORMAT) || 
                       (DISPLAY_FORMAT == EXPONENTIAL_DISPLAY_FORMAT) ||
                       (DISPLAY_FORMAT == SMART_DISPLAY_FORMAT) );

#if MAX_MIN_CALL_IN_DISPLAY
          if (DISPLAY_FORMAT == SMART_DISPLAY_FORMAT)
             {
            // This is a better fix to avoid the max and min function deleting the temporary!
            // Actually I don't know which is better but the later avoids the creation
            // of a temporary array object!
               bool Input_Array_Is_A_Temporary = Array_Descriptor.isTemporary();

               if (Input_Array_Is_A_Temporary)
                  {
                 // Array_Descriptor.Is_A_Temporary = FALSE;
                    ((doubleArray*) this)->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#if defined(PPP)
                    Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#endif
                  }

#if !defined(INTARRAY)
               double Min_Value = min ( fabs (*this) );
               double Max_Value = max ( fabs (*this) );
#else
               double Min_Value = min ( abs (*this) );
               double Max_Value = max ( abs (*this) );
#endif
               if ( ( (Min_Value < 0.001) && (Min_Value > 0) )  || (Max_Value >= 1000) )
                  {
                    printf ("SMART FORMATTING set Local_Display_Format = EXPONENTIAL_DISPLAY_FORMAT \n");
                    Local_Display_Format = EXPONENTIAL_DISPLAY_FORMAT;
                  }
                 else
                  {
                 // We want to avoid the use of EXPONENTIAL_DISPLAY_FORMAT for intArrays
                 // printf ("Force DECIMAL_DISPLAY_FORMAT for intArray objects! \n");
                    Local_Display_Format = DECIMAL_DISPLAY_FORMAT;
                  }

               if (Input_Array_Is_A_Temporary)
                  {
                 // Array_Descriptor.Is_A_Temporary = TRUE;
                    ((doubleArray*) this)->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
#if defined(PPP)
                    Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
#endif
                  }
             }
#else
          printf ("WARNING: In doubleArray::display() -- Smart display turned OFF! \n");
          Local_Display_Format = EXPONENTIAL_DISPLAY_FORMAT;
#endif

       // printf ("Local_Display_Format = %d \n",Local_Display_Format);
          APP_ASSERT ( (Local_Display_Format == DECIMAL_DISPLAY_FORMAT) || 
                       (Local_Display_Format == EXPONENTIAL_DISPLAY_FORMAT) );
       // printf ("Call the MDI function! \n");
#if !defined(USE_EXPRESSION_TEMPLATES)
          MDI_double_Print_Array ( Array_Descriptor.Array_Data , (array_domain*)(&Array_Descriptor.Array_Domain) , Local_Display_Format );
#else
       // APP_DEBUG = 2;
          MDI_Display();
       // APP_DEBUG = 0;
// end of !defined(USE_EXPRESSION_TEMPLATES)
#endif
        }
#endif

     return *((doubleArray *) this);
   }

#if 1
// We are forced to at least temporarily disable some of the deferred evaluation
// features since they are inconsistant with the use of expression template implementation.
// ************************************************************
// Do nothing here since we only want to have the linked list of 
// Expression_Tree_Node_Type objects built! 
// it is not important to attached the expresion tree to the intermediate
// array values (though this was done in the work for Sandia originally).
// If we wanted to do so then this is the place to do it!
// ************************************************************
void
doubleArray::Add_Defered_Expression ( Expression_Tree_Node_Type* X ) const 
   {
    // Avoid the compiler's warning about lack of use by using X in a meaningless statement
    Expression_Tree_Node_Type* Avoid_Compiler_Warning = X;

#if COMPILE_DEBUG_STATEMENTS
       if (APP_DEBUG > 3)
            printf ("Inside of doubleArray::Add_Defered_Expression (Expression_Tree_Node_Type* X)! \n");
#endif
   }
#endif

// ************************************************************
// Required for support of the defered evaluation!
// ************************************************************
int
doubleArray::Array_ID () const 
   {
     return Array_Descriptor.Array_ID();
   }

// ************************************************************
// setBase changes the base of an array object (for all dimensions)
// Even the base of a view can be changed!
// ************************************************************
doubleArray &
doubleArray::setBase( int New_Base_For_All_Axes )
   {
     Array_Descriptor.setBase(New_Base_For_All_Axes);
     return *this;
   }

// ************************************************************
// setBase changes the base of an array object. Even the base 
// of a view can be changed!
// ************************************************************
doubleArray &
doubleArray::setBase( int New_Base , int Axis )
   {
     Array_Descriptor.setBase (New_Base,Axis);
     return *this;
   }

#if 0
// ************************************************************
// setParallelBase changes the base of an array object. Even the base 
// of a view can be changed!
// ************************************************************
doubleArray &
doubleArray::setParallelBase( int New_Base , int Axis )
   {
   // ... this doesn't change the SerialArray values ...
#if COMPILE_DEBUG_STATEMENTS
  // Enforce bound on Alt_Base depending on INT_MAX and INT_MIN
     static int Max_Base = INT_MAX;
     static int Min_Base = INT_MIN;

  // error checking!
     APP_ASSERT((New_Base > Min_Base) && (New_Base < Max_Base));
#endif

  // If there is an outstanding reference then we have to
  // break the reference by forcing a copy of the descriptor.
  // Then we can modify the new descriptor.
     if (Array_Descriptor.referenceCount > getReferenceCountBase())
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("ReferenceCount = %d -- Breaking reference to other descriptor! \n",Array_Descriptor.referenceCount);
#endif
          printf ("This should be unreachable code! \n");
          APP_ABORT();
          Array_Descriptor.referenceCount--;
        }

     int i = 0;
     int Scalar_Offset = 0;
     int Difference = New_Base - (Array_Descriptor.Array_Domain.Data_Base[Axis] + 
	Array_Descriptor.Array_Domain.Base[Axis]);

#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
  // Adjust the Data_Base on the LOCAL SerialArray relative to the change in the 
  // GLOBAL base
     Array_Descriptor.Array_Domain.Global_Index     [Axis]      += Difference;
     Array_Descriptor.Array_Domain.Local_Mask_Index [Axis]      += Difference;
#endif

     Scalar_Offset = Difference * Array_Descriptor.Array_Domain.Stride[Axis];
     if (Axis>0) Scalar_Offset *= Array_Descriptor.Array_Domain.Size[Axis-1];

     APP_ASSERT (Array_Descriptor.isView() || (Array_Descriptor.Array_Domain.Base[Axis] == 0) );

     Array_Descriptor.Array_Domain.Data_Base [Axis] = New_Base - Array_Descriptor.Array_Domain.Base[Axis];
     Array_Descriptor.Array_Domain.User_Base [Axis] += Difference;

     for (i = Axis;i<MAX_ARRAY_DIMENSION;i++)
       Array_Descriptor.Array_Domain.Scalar_Offset[i] -= Scalar_Offset; 

#if defined(PPP)
     // ... might not need this but shouldn't hurt ...
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;
#else
     POINTER_LIST_INITIALIZATION_MACRO;
#endif

     return *this;
   }
#endif

// ********************************************************************
// ********************************************************************
// Get base for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  It is an error to use this function unless all bases
// have the same value.
// ********************************************************************
int
doubleArray::getBase() const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);

  // Check for the same value in each dimension!
  // APP_ASSERT( (Array_Descriptor->Base [0] == Array_Descriptor->Base [1]) && 
  //         (Array_Descriptor->Base [2] == Array_Descriptor->Base [3]) &&
  //         (Array_Descriptor->Base [0] == Array_Descriptor->Base [2]) );

     int temp = 0;
     for (temp=1;temp<MAX_ARRAY_DIMENSION;temp++)
          APP_ASSERT(Array_Descriptor.Array_Domain.User_Base[0] == Array_Descriptor.Array_Domain.User_Base[temp]);

     Temp_Base = Array_Descriptor.Array_Domain.User_Base [0];
  // Temp_Base = Array_Descriptor.Array_Domain.Data_Base [0] + Array_Descriptor.Array_Domain.Base [0];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getBase(0));

     return Temp_Base;
   }

int
doubleArray::getRawBase() const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);

  // Check for the same value in each dimension!
  // APP_ASSERT( (Array_Descriptor->Base [0] == Array_Descriptor->Base [1]) && 
  //         (Array_Descriptor->Base [2] == Array_Descriptor->Base [3]) &&
  //         (Array_Descriptor->Base [0] == Array_Descriptor->Base [2]) );

     int temp = 0;
     for (temp=1;temp<MAX_ARRAY_DIMENSION;temp++)
        APP_ASSERT
	   (Array_Descriptor.Array_Domain.Base[0] + Array_Descriptor.Array_Domain.Data_Base[0] == 
	    Array_Descriptor.Array_Domain.Base[temp] + Array_Descriptor.Array_Domain.Data_Base[temp]);  

     Temp_Base = Array_Descriptor.Array_Domain.Data_Base [0] + Array_Descriptor.Array_Domain.Base [0];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getRawBase(0));

     return Temp_Base;
   }

// ********************************************************************
// Get base for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  The Base can be accessed seperately for each dimension.
// ********************************************************************
int
doubleArray::getDataBase( int Axis ) const
   {
     int Temp_Base = 0;

     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     Temp_Base = Array_Descriptor.Array_Domain.Data_Base[Axis];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getDataBase(Axis));

     return Temp_Base;
   }

int
doubleArray::getBase( int Axis ) const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // The global base is returned for views to comform with HPF indexing of views!
  // Bug fix (7/27/94) views of views are incorrect
  // Temp_Base = Array_Descriptor->Base[Axis]; 
  // Temp_Base = Array_Descriptor->Data_Base[Axis]; 
  // Temp_Base = Array_Descriptor->Data_Base[Axis]+Array_Descriptor->Base[Axis]; 
     Temp_Base = Array_Descriptor.Array_Domain.User_Base[Axis];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getBase(Axis));

     return Temp_Base;
   }

int
doubleArray::getRawBase( int Axis ) const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // The global base is returned for views to comform with HPF indexing of views!
  // Bug fix (7/27/94) views of views are incorrect
  // Temp_Base = Array_Descriptor->Base[Axis]; 
  // Temp_Base = Array_Descriptor->Data_Base[Axis]; 
     Temp_Base = Array_Descriptor.Array_Domain.Data_Base[Axis]+Array_Descriptor.Array_Domain.Base[Axis]; 

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getRawBase(Axis));

     return Temp_Base;
   }

// ********************************************************************
// Get bound for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
doubleArray::getBound( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // Bugfix (12/1/94) incorrect bound was combuted for a view!
  // return Array_Descriptor->Data_Base[Axis]+(Array_Descriptor->Bound[Axis]-Array_Descriptor->Base[Axis]); 
  // int Temp_Bound = Array_Descriptor->Data_Base[Axis]+Array_Descriptor->Bound[Axis]; 
     int Temp_Bound = Array_Descriptor.Array_Domain.User_Base[Axis]+
	(Array_Descriptor.Array_Domain.Bound[Axis]-Array_Descriptor.Array_Domain.Base[Axis]) /
	Array_Descriptor.Array_Domain.Stride[Axis]; 

  // double check for consistant result!
     APP_ASSERT (Temp_Bound == Array_Descriptor.getBound(Axis));

     return Temp_Bound;
   }

int
doubleArray::getRawBound( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // Bugfix (12/1/94) incorrect bound was combuted for a view!
  // return Array_Descriptor.Array_Domain.Data_Base[Axis]+(Array_Descriptor.Array_Domain.Bound[Axis]-Array_Descriptor.Array_Domain.Base[Axis]); 
     int Temp_Bound = Array_Descriptor.Array_Domain.Data_Base[Axis]+ Array_Descriptor.Array_Domain.Bound[Axis]; 

  // double check for consistant result!
     APP_ASSERT (Temp_Bound == Array_Descriptor.getRawBound(Axis));

     return Temp_Bound;
   }

// ********************************************************************
// Get stride for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
doubleArray::getStride( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // int Temp_Stride = Array_Descriptor.Array_Domain.Stride[Axis]; 
     int Temp_Stride = 1;

  // double check for consistant result!
     APP_ASSERT (Temp_Stride == Array_Descriptor.getStride(Axis));

     return Temp_Stride;
   }

int
doubleArray::getRawStride( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     int Temp_Stride = Array_Descriptor.Array_Domain.Stride[Axis]; 

  // double check for consistant result!
  // ... bug fix (10/9/96,kdb) the raw strides should be the same ...
  //   APP_ASSERT (Temp_Stride == Array_Descriptor->getStride(Axis));
     APP_ASSERT (Temp_Stride == Array_Descriptor.getRawStride(Axis));

     return Temp_Stride;
   }

// ********************************************************************
// Get number of dimensions of the array objects (note that a 1x2 array is 2 dimensional)
// ********************************************************************
int
doubleArray::numberOfDimensions () const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.numberOfDimensions();
   }

// ********************************************************************
// Get length for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
doubleArray::getLength( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     return Array_Descriptor.getLength(Axis);
   }

// ********************************************************************
// Get raw data size for use in accessing the A++ data directly from 
// a pointer (obtained via the getDataPointer member function).
// ********************************************************************
int
doubleArray::getRawDataSize( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     return Array_Descriptor.getRawDataSize(Axis);
   }

// ********************************************************************
// Array size by axis - Works correctly for views too!
// This function has been devalued in it present form and will
// return a Range object in the future (maybe an Internal_Index).
// This function has returned after having been devalued (it now returns
// a Range object).  Geoff had suggested this some time ago.
// This function does not work for indirect addressing.
// ********************************************************************
Range
doubleArray::dimension( int Axis ) const
   {
  // This function is called so often that it shouuld be inlined
  // alternatively the lower level function might be called instead 
  // of this one (then that function should be inlined -- and it is).

  // printf ("Inside of doubleArray::Dimension(%d) \n",Axis);
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     return Array_Descriptor.dimension( Axis );
   }

#if defined(APP) || defined(PPP)
// ********************************************************************
// ********************************************************************
// These functions are specific to P++ and provide informationabout the 
// local partition instead of the global distributed array.
// ********************************************************************
// ********************************************************************

// ********************************************************************
// Get LOCAL Range for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  The dimension can be accessed seperately for each dimension.
// ********************************************************************
Range
doubleArray::localDimension( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->dimension( Axis );
#else
     return dimension( Axis );
#endif
   }

// ********************************************************************
// Get LOCAL base for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  The Base can be accessed seperately for each dimension.
// ********************************************************************
int
doubleArray::getLocalBase( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getBase(Axis);
#else
     return getBase(Axis);
#endif
   }

// ********************************************************************
// Get LOCAL bound for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
doubleArray::getLocalBound( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getBound(Axis);
#else
     return getBound(Axis);
#endif
   }

int
doubleArray::getLocalRawBase( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getRawBase(Axis);
#else
     return getRawBase(Axis);
#endif
   }

int
doubleArray::getLocalRawBound( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getRawBound(Axis);
#else
     return getRawBound(Axis);
#endif
   }

// ********************************************************************
// Get LOCAL stride for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
doubleArray::getLocalStride( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getStride(Axis);
#else
     return getStride(Axis);
#endif
   }

int
doubleArray::getLocalRawStride( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getRawStride(Axis);
#else
     return getRawStride(Axis);
#endif
   }

// ********************************************************************
// Get LOCAL stride for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
doubleArray::getLocalLength( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getLength(Axis);
#else
     return getLength(Axis);
#endif
   }

// ********************************************************************
// total array size (total number of elements in array (or view))!
// ********************************************************************
int
doubleArray::getLocalSize() const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getSize();
#else
     return getSize();
#endif
   }
#endif

// ********************************************************************
// total array size (total number of elements in array (or view))!
// ********************************************************************
int
doubleArray::getSize() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
  // using the size is incorrect since the size is not modified when we take a view!
  // return Array_Descriptor->Size[3]; 
  // I think this is the only way! Or computing it directly!
  // The Array_Size function didn't propoerly acount for non unit strides - but this is fixed now!
     return Array_Descriptor.Array_Size(); 
   }

// ********************************************************************
// total array size (total number of elements in array (or view))!
// ********************************************************************
int
doubleArray::elementCount() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
  // using the size is incorrect since the size is not modified when we take a view!
  // return Array_Descriptor->Size[3]; 
  // I think this is the only way! Or computing it directly!
  // The Array_Size function didn't propoerly acount for non unit strides - but this is fixed now!
     return Array_Descriptor.Array_Size(); 
   }

// ********************************************************************
/* Number of columns and rows useful for 2D arrays (part of defined interface)! */
// ********************************************************************
int
doubleArray::cols() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.getLength(1); 
   }

// ********************************************************************
/* Number of columns and rows useful for 2D arrays (part of defined interface)! */
// ********************************************************************
int
doubleArray::rows() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.getLength(0); 
   }

bool
doubleArray::isSameBase ( const doubleArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameBase(X.Array_Descriptor);
   }

bool
doubleArray::isSameBound ( const doubleArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameBound(X.Array_Descriptor);
   }

bool
doubleArray::isSameStride ( const doubleArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameStride(X.Array_Descriptor);
   }

bool
doubleArray::isSameLength ( const doubleArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameLength(X.Array_Descriptor);
   }

#if defined(APP) || defined(PPP)
bool
doubleArray::isSameGhostBoundaryWidth ( const doubleArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameGhostBoundaryWidth(X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameGhostBoundaryWidth
	(X.Array_Descriptor.Array_Domain);
   }
bool
doubleArray::isSameDistribution ( const intArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameDistribution (X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameDistribution 
	(X.Array_Descriptor.Array_Domain);
   }
bool
doubleArray::isSameDistribution ( const floatArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameDistribution (X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameDistribution 
	(X.Array_Descriptor.Array_Domain);
   }
bool
doubleArray::isSameDistribution ( const doubleArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameDistribution (X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameDistribution 
	(X.Array_Descriptor.Array_Domain);
   }
#endif

bool
doubleArray::isSimilar ( const doubleArray & X ) const
   {
  // This function is a dimension independent test of equality
  // between the bases of each axis of two array descriptors.

  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSimilar(X.Array_Descriptor);
   }

#if 0
// ********************************************************************
// Control the ablity to resize and array throught assignment
// This whole process is greatly cleaned up over that of M++!
// A++ array objects can not be redimensioned through assignment
// ********************************************************************
int doubleArray::lock()
   {
     printf ("Sorry, doubleArray::lock not implemented yet! \n");
  // APP_ABORT();
     return 0;
   }

int doubleArray::unlock()
   {
     printf ("Sorry, doubleArray::unlock not implemented yet! \n");
  // APP_ABORT();
     return 0;
   }
#endif

// ********************************************************************
// dimensioning member functions: allow the user to reset the size of an
// existing array (redim does not preserve the original data (see resize)).
// ********************************************************************
// doubleArray & doubleArray::redim ( int i , int j , int k , int l )
doubleArray &
doubleArray::redim ( ARGUMENT_LIST_MACRO_INTEGER )
   {
  // It is the responcibility of the user to be certain that
  // no references to the current data exist! Same as in any array class!

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

     return redim (Integer_List);
   }

doubleArray &
doubleArray::redim ( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
  // This is the main function called to handle the redimensioning of array objects.
  // Several other interface functions each call this function to do the heavy lifting
  // This function does not change the partitioning object in use if it is associated 
  // with thearray object. If there is not partitioning object then this function does 
  // not add one.

     int temp_index = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  doubleArray::redim(int*) ");
          int temp = 0;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }

     Test_Consistency("Called from TOP of doubleArray::redim(int*)");

  // Error checking for inputs
     for (temp_index = 0; temp_index > MAX_ARRAY_DIMENSION; temp_index++)
        {
          if (Integer_List[0] == 0)
             {
            // Case of redim to NULL array object!
               APP_ASSERT (Integer_List[temp_index] == 0);
             }
            else
             {
            // Case of redim to non-NULL array object!
               APP_ASSERT (Integer_List[temp_index] > 0);
             }
        }
#endif

#if EXTRA_ERROR_CHECKING
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
       // There is currently no execution object that can perform this operation
       // so it cannot be processed in defered evaluation mode!
          printf ("ERROR: DEFER_EXPRESSION_EVALUATION == TRUE in doubleArray::redim() \n");
          APP_ABORT();
        }
#endif

  // printf ("TOP of redim() getRawDataReferenceCount() = %d \n",getRawDataReferenceCount());

  // Note that this only handles the case where the first parameter is 
  // ZERO! The purpose of this code is to permit views to be turned
  // into NULL array objects even though a it makes no sense (that we 
  // know of) to redim a view.
     int redim_to_zero = (Integer_List[0] != 0) ? FALSE : TRUE;
     if (Index::Index_Bounds_Checking)
	{
	  if ( Array_Descriptor.isView() == TRUE && !redim_to_zero )
	     {
	       printf ("ERROR: can only redim a view to zero (forming a NULL array) \n");
	       APP_ABORT();
	     }
	}

#if EXTRA_ERROR_CHECKING
  // Check the input values to make sure that we are correctly handling the null array case
     if (redim_to_zero == TRUE)
        {
          int i;
       // We can't insure that if one of the values is zero that all others will be zero!
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
               APP_ASSERT (Integer_List[i] >= 0);
        }
       else
        {
          int i;
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
               APP_ASSERT (Integer_List[i] >= 1);
        }
#endif

#if defined(PPP)
  // Declaration specific to P++ (the result could be a NULL pointer)
     Internal_Partitioning_Type* currentPartition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("In redim: Remove the associatation with the currentPartition \n");
#endif
     if (currentPartition != NULL)
          Internal_Partitioning_Type::DeleteArrayToPartitioning(*currentPartition,*this);
       else
          Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);

#if COMPILE_DEBUG_STATEMENTS
     int numberOfReferencesBeforeRedim = (currentPartition != NULL) ? currentPartition->referenceCount : 0;
#endif
#endif

  // delete current array info!
  // printf ("BEFORE Delete_Array_Data() getRawDataReferenceCount() = %d \n",getRawDataReferenceCount());
  // We should be able to remove this once we have a non-zero base reference count value!
  // The problem is that the inialization of the Domain assumes that the refeence count is zero if the Array_Data == NULL
  // It used to be that the descriptor's destructor would zero the reference count but now 
  // this is not called because the Array_Descriptor_Type is a member of the array object (instead of a pointer).
     Delete_Array_Data();
  // printf ("AFTER Delete_Array_Data() Array_ID() = %d  getRawDataReferenceCount() = %d \n",Array_ID(),getRawDataReferenceCount());

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("In redim: This should have already been done in the Delete_Array_Data() member function \n");
#endif

#if defined(PPP)
  // This should have already been done in the Delete_Array_Data() member function
     Array_Descriptor.SerialArray = NULL;
#else
  // This should have already been done in the Delete_Array_Data() member function
     Array_Descriptor.Array_Data  = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("#1 currentPartition->referenceCount              = %d \n",currentPartition->referenceCount);
#endif
#endif

  // This copies the old data so we can reuse it this is a
  // relatively expensive operation since the whole object is copied
  // This cales the copy constructor (which may not be the right thing to do)
  // Array_Descriptor_Type Old_Array_Descriptor = Array_Descriptor;
  // Alternatively we can just save the little amount of data from the
  // old descriptor as is required.
     int     Old_Array_ID               = Array_ID();
     bool Old_builtUsingExistingData = Array_Descriptor.Array_Domain.builtUsingExistingData;
#if defined(PPP)

#if 0
  // It is not possible to have a partitioning object be associated with a NullArray object
  // so we don't want to throw away the existing partitioning object.
     if (redim_to_zero == TRUE)
        {
       // If we are going to make this a NULL array then we want to give up the 
       // partitioning object (since we will get a new one if this object is ever 
       // used in an subsequent assignment)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
             {
            // printf ("In doubleArray::redim --- delete Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer commented out! \n");

            // Additional error checking (11/14/2000)
               APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                           Internal_Partitioning_Type::getReferenceCountBase());

               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
               if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() <
                   Internal_Partitioning_Type::getReferenceCountBase())
                    delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
             }
          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;

          APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL);
        }
#endif

  // Internal_Partitioning_Type *Old_Partition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
  // printf ("In redim: Old_Partition = %p \n",Old_Partition);

#if 1
  // This should be done by the call to the ArrayDomain::partition() function 
  // within the Array_Descriptor.Initialize_Descriptor
#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("Put this code into the ArrayDomain::partition() function \n");
#endif

  // Now we want to remove all the existing distribution descriptor data so that it
  // will not be reused when we build a new and (likely) different size array object.
#if defined(USE_PADRE)
  // Let the allocation of data reinitialize the PADRE object pointer with a new PADRE_Descriptor
     if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
        {
          Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->decrementReferenceCount();
          if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->getReferenceCount() <
              Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->getReferenceCountBase())
               delete Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer;
        }
     Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer = NULL;

#else
     if (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition != NULL)
        {
          APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition->referenceCount >= 1);
          delete_DECOMP(Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition);  
        }
     Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition = NULL;

     if (Array_Descriptor.Array_Domain.BlockPartiArrayDomain!= NULL)
        {
       // Shouldn't the upper limit be 1 instead of 0?
          APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDomain->referenceCount >= 0);
          delete_DARRAY(Array_Descriptor.Array_Domain.BlockPartiArrayDomain);  
        }
     Array_Descriptor.Array_Domain.BlockPartiArrayDomain = NULL;

  // End USE_PADRE not defined
#endif
#endif

     APP_ASSERT (Array_Descriptor.SerialArray == NULL);

  // Reinitialize the descriptor with data about the size of the new array (include the partition object for P++)
  // This function does not assume that Old_Partition is a valid pointer (could be NULL pointer)
     Array_Descriptor.Initialize_Descriptor ( MAX_ARRAY_DIMENSION, Integer_List, currentPartition );

  // Now decrement the reference count to make up to how the last function incremented it
  // We know that we can do this because the same partitioning object is just reused.
     if (currentPartition != NULL)
          currentPartition->decrementReferenceCount();

#if defined(USE_PADRE)
     APP_ASSERT (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer == NULL);
#else
     APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition == NULL);
     APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDomain        == NULL);
  // End of USE_PADRE not defined
#endif

  // Error checking (make sure we have not dropped the partitioning object)
     APP_ASSERT ( ( (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL) && 
                    (currentPartition != NULL) ) || 
                  (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == currentPartition));

  // End of PPP defined
#else
  // if PPP not defined
     APP_ASSERT (Array_Descriptor.Array_Data == NULL);

  // We have to return the array id if we have deleted the data as part of the redim process.
     if (getRawDataReferenceCount() < getRawDataReferenceCountBase())
        {
       // Make sure the reference count is not too small (should be only one less than the reference count base)
          APP_ASSERT (getRawDataReferenceCount() >= getRawDataReferenceCountBase() - 1);

       // Then set it to the reference count base (from zero references to a
       // single reference since we will allocate data next)
          resetRawDataReferenceCount();

          Array_Domain_Type::Push_Array_ID (Old_Array_ID);
        }

  // printf ("In redim #3: Array_ID() = %d  and Old_Array_ID = %d \n",Array_ID(),Old_Array_ID);

  // Reinitialize the descriptor with data about the size of the new array (include the partition object for P++)
     Array_Descriptor.Initialize_Descriptor ( MAX_ARRAY_DIMENSION, Integer_List );

  // Bugfix (2/13/97) This fixes what appeared to be a memory leak in the redim function
  // Since the reference count includes the initial reference we have to return
  // the Array_ID before we would otherwise (one array reference before we would otherwise).
  // Note: See the comments in the ::adopt function since the same problem is handled there as well.
     if (Old_builtUsingExistingData == TRUE)
        {
       // printf ("Redimensioning an array built using adopt \n");
       // Extra error checking (11/16/2000)
          APP_ASSERT (Array_Domain_Type::Array_Reference_Count_Array [Old_Array_ID] >= getRawDataReferenceCountBase());
          if (Array_Domain_Type::Array_Reference_Count_Array [Old_Array_ID] <= getRawDataReferenceCountBase())
             {
            // Reinitialize reference count for next use!
            // We can't use resetRawDataReferenceCount since it internally 
            // uses Array_Descriptor instead of Old_Array_Descriptor
               Array_Domain_Type::Array_Reference_Count_Array [Old_Array_ID] = getRawDataReferenceCountBase();
               Array_Domain_Type::Push_Array_ID (Old_Array_ID);
             }
        }

  // End PPP not defined
#endif

  // Passing in TRUE avoids the defered allocation of data under defered evaluation
  // which is sometimes required.  However in this case it is at present an error
  // to use redim while defered evaluation is turned ON!
  // This function allocates the data for the serial and distributed parallel
  // arrays.  In the case of P++ it allocates only the processors part of the
  // data (info obtained from block parti array descriptor).
     Allocate_Array_Data(TRUE);

#if !defined(PPP)
     Array_Descriptor.Array_Domain.ExpressionTemplateOffset = 0;
     Array_Descriptor.Array_Domain.View_Offset              = 0;

     POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if defined(PPP)
  // Now update the ghost boundaries with valid data for the neighboring processors
     updateGhostBoundaries();

  // Verify that we saved the right partitioning object if it existed or not
     APP_ASSERT ( ( (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL) && 
                    (currentPartition != NULL) ) || 
                  (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == currentPartition));
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == currentPartition);

#if COMPILE_DEBUG_STATEMENTS
  // Error checking
     int numberOfReferencesAfterRedim = (currentPartition != NULL) ? currentPartition->referenceCount : 0;
     APP_ASSERT (numberOfReferencesBeforeRedim == numberOfReferencesAfterRedim);
#endif
#endif

#if defined(APP) || ( defined(SERIAL_APP) && !defined(PPP) )
  // For P++ we only track the serial array objects not the serial array objects
     if (Diagnostic_Manager::getTrackArrayData() == TRUE)
        {
       // Since we have changed the size of the array we have to reset the diagnostic data
       // Also initialize the type code in the diagnostic data object so we know the base type of the array object
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
#ifdef DOUBLEARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_DOUBLE_ELEMENT_TYPE);
#endif
#ifdef FLOATARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_FLOAT_ELEMENT_TYPE);
#endif
#ifdef INTARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_INT_ELEMENT_TYPE);
#endif
        }
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Called from BASE of doubleArray::redim(int,int,int,int)");
#endif

     return *this;
   }

// ********************************************************************
// redimension array using range objects to allow the specification 
// of both base and size of each dimension.
// ********************************************************************
doubleArray &
doubleArray::redim ( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     return redim (Internal_Index_List);
   }

// We need this to avoid an ERROR: Overloading ambiguity between "doubleArray::redim(const Array_Domain_Type&)" 
// and "doubleArray::redim(const Range&, const Range&, const Range&, const Range&, const Range&, const Range&)"
// so we need to implement a redim that takes a single Index object.
doubleArray & 
doubleArray::redim ( const Index & I )
   {
     Range I_Range = I;
     return redim (I_Range);
   }

doubleArray & 
doubleArray::redim ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;

     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          Integer_List[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base)+1;

     redim ( Integer_List );

  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");
  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");
  // printf ("Call setBase \n");
  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");
  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          setBase (Internal_Index_List[temp]->Base,temp);

     return *this;
   }

// ********************************************************************
// redimension array using another array object as a source for info
// about base and size of each dimension.
// ********************************************************************
// template<class T , int Template_Dimension>
// doubleArray & doubleArray::redim ( const Array_Descriptor_Type<T,Template_Dimension> & X )
doubleArray &
doubleArray::redim ( const Array_Domain_Type & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  doubleArray::redim (const Array_Domain_Type & X) \n");
#endif

  // Build Range objects
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // printf ("Inside of doubleArray::redim (const doubleArray & X) -- temp = %d \n",temp);

       // Bugfix (1/17/96) redim must account for stride in redimensioning of this array
       // just using base and bound was insufficient to get the correct size!
       // int Bound = X.getBound(temp);
       // Index_List[temp] = Internal_Index (Base,(Bound-Base)+1);
          int Base  = X.getBase(temp);
          int Length = X.getLength(temp);
          Index_List[temp] = Internal_Index (Base,Length);
          Internal_Index_List[temp] = &(Index_List[temp]);
        }

  // printf ("Inside of doubleArray::redim (const doubleArray & X) calling redim(Internal_Index_List) \n");

  // Call redim using Range objects
     redim (Internal_Index_List);

     return *this;
   }

// ********************************************************************
// redimension array using another array object as a source for info 
// about base and size of each dimension.
// ********************************************************************
doubleArray &
doubleArray::redim ( const doubleArray & X ) 
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  doubleArray::redim (const doubleArray & X) \n");
#endif

     redim (X.Array_Descriptor.Array_Domain);
     return *this;
   }

// ********************************************************************
// This function acts like a copy constructor but for an existing object
// thus no new object is built. The default is a deep copy.  The only option
// is a shallow copy (same as a reference).
// ********************************************************************
doubleArray &
doubleArray::copy ( const doubleArray & X , int Type_Of_Copy ) 
   {
  // This copy function does deep copies or shallow copies depending on the Type_Of_Copy input
  // APP_ASSERT( this != &((doubleArray &) X) );

     if ( this != &((doubleArray &) X) )
        { 
          if (Type_Of_Copy == DEEPCOPY)
             {
            // redimension and then call the assignment operator to copy the data.
               redim (X);
               operator= (X);
             }
            else
             {
               if (Type_Of_Copy == SHALLOWCOPY)
                  {
                 // call the reference member function
                    reference (X);
                  }
                 else
                  {
                    printf ("In doubleArray::copy has bad Type_Of_Copy input (Use DEEPCOPY or SHALLOWCOPY)! \n");
                    APP_ABORT();
                  }
             }
        }
       else
        {
          printf ("Note: doubleArray::copy handed itself as input (copy skipped)! \n");
        }

     return *this;
   }

// ********************************************************************
// The reshape function uses an existing A++ array and redimensions
// it to be a different size without changing the number of elements.
// It is an error to change the number of elements in the reshaped array.
// The number of total elements before and after reshape must be the same.
// ********************************************************************
// doubleArray & doubleArray::reshape ( int i , int j , int k , int l )
doubleArray &
doubleArray::reshape ( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  doubleArray::reshape ");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }

     Test_Consistency("Called from TOP of doubleArray::reshape(int,int,int,int)");
#endif

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#0 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
#endif
#endif

  // Bugfix (11/26/96) Make the error checking avaiable when the bounds checking is turned on
     int Number_Of_Elements_Before_Reshape = 0;
     if (Index::Index_Bounds_Checking != FALSE)
          Number_Of_Elements_Before_Reshape = elementCount();

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Number_Of_Elements_Before_Reshape = %d \n",Number_Of_Elements_Before_Reshape);
#endif

  // Support for leading one feature of the reshape function
     int indexPosition = 0;
     while ( ( (Integer_List[indexPosition] == 1) && (getLength(indexPosition) != 1) ) &&
             (indexPosition < MAX_ARRAY_DIMENSION) )
        {
          indexPosition++;
        }
     int numberOfLeadingOnesAddedInNewArrayShape = indexPosition;

     indexPosition = 0;
     while ( ( (Integer_List[indexPosition] != 1) && (getLength(indexPosition) == 1) ) &&
             (indexPosition < MAX_ARRAY_DIMENSION) )
        {
          indexPosition++;
        }
     int numberOfLeadingOnesRemovedInNewArrayShape = indexPosition;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("numberOfLeadingOnesAddedInNewArrayShape = %d numberOfLeadingOnesRemovedInNewArrayShape = %d \n",
               numberOfLeadingOnesAddedInNewArrayShape,numberOfLeadingOnesRemovedInNewArrayShape);
        }
#endif

  // Now modify the child partitioning to reflect the non-distributed dimensions
  // that we add with unit length (length == 1)
  // Error checking for deleting non-distributed unit dimensions
     APP_ASSERT (numberOfLeadingOnesRemovedInNewArrayShape >= 0);
     APP_ASSERT (numberOfLeadingOnesRemovedInNewArrayShape < MAX_ARRAY_DIMENSION);

  // Error checking for adding non-distributed unit dimensions
     APP_ASSERT (numberOfLeadingOnesAddedInNewArrayShape >= 0);
     APP_ASSERT (numberOfLeadingOnesAddedInNewArrayShape < MAX_ARRAY_DIMENSION);

  // Make sure that we don't think we are both added and deleting leading unit dimensions!
     APP_ASSERT ( (numberOfLeadingOnesRemovedInNewArrayShape == 0) || (numberOfLeadingOnesAddedInNewArrayShape == 0));

#if defined(PPP)
  // This function is implemented with a P++ section and an A++ section
  // START OF P++ SECTION OF RESHAPE

  // We have to call resize here since the effect of having ghost boundaries
  // prevents a trivial manipulation of the existing memory.  This is because the 
  // ghost boundaries are connected to the raw data (in the usual way).
  // As a result we have to build new partitioning objects to represent the 
  // distributions with different axes specified as distributed or not distributed
  // (not because we have different ghost boundary widths!!! (I think))

     Internal_Partitioning_Type* parentPartitioningObject = NULL;
  // Internal_Partitioning_Type* childPartitioningObject  = NULL;
     Internal_Partitioning_Type* newPartitioningObject    = NULL;

  // ... bug fix (11/6/96, kdb) this checks cause problems if the SerialArray
  // is a null array so skip them and rest of code should be okay ...
     if (!Array_Descriptor.SerialArray->Array_Descriptor.isNullArray())
        {

#if COMPILE_DEBUG_STATEMENTS
       // Handle case of removing dimensions
          if (numberOfLeadingOnesRemovedInNewArrayShape > 0)
             {
            // loop over the dimensions and verify that the dimensions we
            // will remove are not distributed (in the partition object)
               int i = 0;
               for (i = 0; i < numberOfLeadingOnesAddedInNewArrayShape; i++)
                  {
                    APP_ASSERT (Array_Domain_Type::isPartitioned(Array_Descriptor.Array_Domain,Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain,i) == TRUE);
                  }
             }
#endif

          if (numberOfLeadingOnesAddedInNewArrayShape > 0)
             {
               bool usingDefaultPartitioning = (getInternalPartitionPointer() == NULL) ? TRUE : FALSE;

               if (usingDefaultPartitioning == TRUE)
                  {
                 // Build a new partitioning object
                    parentPartitioningObject = NULL;
#if 0
                    printf ("Building new child partitioning object \n");
#endif
                    newPartitioningObject = new Internal_Partitioning_Type();

                    APP_ASSERT (newPartitioningObject->getReferenceCount() ==
                                Internal_Partitioning_Type::getReferenceCountBase());
                 // Bugfix (11/27/2000)
                 // newPartitioningObject->decrementReferenceCount();
                  }
                 else
                  {
                 // Use the copy constructor to build a new partitioning object (matching the parent)
#if 0
                    printf ("Building new child partitioning object using copy constructor from parent \n");
#endif
                    parentPartitioningObject = getInternalPartitionPointer();
                    parentPartitioningObject->incrementReferenceCount();

                    newPartitioningObject = new Internal_Partitioning_Type(*parentPartitioningObject);

                    APP_ASSERT (newPartitioningObject->getReferenceCount() ==
                                Internal_Partitioning_Type::getReferenceCountBase());
                 // Bugfix (11/27/2000)
                    newPartitioningObject->decrementReferenceCount();
                  }

            // define parent/child relationship (avoid case where they are the same partitioning object)
               APP_ASSERT (newPartitioningObject != NULL);
               APP_ASSERT (newPartitioningObject != Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
               if (parentPartitioningObject != NULL)
                  {
                    newPartitioningObject->setParentPartitioningObject(parentPartitioningObject);
                    APP_ASSERT (newPartitioningObject->isRootOfPartitionTree == FALSE);
                  }

            // Handle case of adding dimensions
            // loop over the dimensions and mark the new child partitioning
            // object to have no distribution along these leading dimensions
               int i = 0;
               for (i = 0; i < numberOfLeadingOnesAddedInNewArrayShape; i++)
                  {
                 // All added unit dimensions should have zero ghost boundary
                 // width (since the raw data does not have them)
                    int ghostBoundaryWidth = 0;
                    newPartitioningObject->partitionAlongAxis(i,FALSE,ghostBoundaryWidth);
                  }
             }
            else
             {
#if 0
               printf ("Parent and child partitioning object are NULL \n");
#endif
               parentPartitioningObject = getInternalPartitionPointer();
#if 1
               if (parentPartitioningObject != NULL)
                    parentPartitioningObject->incrementReferenceCount();
#endif
               newPartitioningObject    = parentPartitioningObject;

               if (numberOfLeadingOnesRemovedInNewArrayShape > 0)
                  {
#if 0
                    printf ("Reusing parent as child partitioning object \n");
#endif
                    if (parentPartitioningObject->parentPartitioningObject != NULL)
                       {
#if 0
                         printf ("Getting the parentPartitioning of the parent partitioning object \n");
#endif
                         newPartitioningObject = parentPartitioningObject->parentPartitioningObject;
                       }
                  }

               if (newPartitioningObject != NULL)
                    newPartitioningObject->incrementReferenceCount();
             }

       // This does not have to be TRUE
       // APP_ASSERT (newPartitioningObject != NULL);

#if 0
#if defined(PPP)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
               printf ("Reshape-#1 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
            else
               printf ("Reshape-#1 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
          if (newPartitioningObject != NULL)
               printf ("Reshape-#1 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
            else
               printf ("Reshape-#1 newPartitioningObject is NULL \n");
#endif
#endif

#if 0
       // Now we have a new partitioning object for the reshaped array
       // (correctly associated with it's parent partitioning)
          if (parentPartitioningObject == NULL)
             {
               Internal_Partitioning_Type::displayDefaultValues("parentPartitioningObject");
             }
            else
             {
               parentPartitioningObject->display("parentPartitioningObject");
             }

          if (newPartitioningObject != NULL)
               newPartitioningObject->display("newPartitioningObject");

          printf ("Need to add this (new partitioning) to the list of associated partitionings (on the parent partitioning) \n");
#endif

       // We don't need this refernece any more so delete it now!
          if (parentPartitioningObject != NULL)
             {
               APP_ASSERT (parentPartitioningObject->getReferenceCount() >= Internal_Partitioning_Type::getReferenceCountBase());

               parentPartitioningObject->decrementReferenceCount();
               if (parentPartitioningObject->getReferenceCount() <
                   Internal_Partitioning_Type::getReferenceCountBase())
                  {
                 // printf ("calling delete parentPartitioningObject \n");
                    delete parentPartitioningObject;
                  }
               parentPartitioningObject = NULL;
             }
          APP_ASSERT (parentPartitioningObject == NULL);

          int Partitioned_Dims[MAX_ARRAY_DIMENSION];
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               Partitioned_Dims[temp] = Array_Domain_Type::isPartitioned (Array_Descriptor.Array_Domain,Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain,temp);

       // ... first determine if reshape will collapse a dimension that is partitioned ...
       // find the maximum dimension of the final reshaped array
          int reshape_dim = MAX_ARRAY_DIMENSION;
          temp = MAX_ARRAY_DIMENSION-1;
          while (temp>0)
             {
               if (Integer_List[temp--] == 1)
                    reshape_dim--;
                 else
                    break;
             }

       // printf ("reshape_dim = %d \n",reshape_dim);

#if 0
       // This is no longer a constraint (at least not with leading unit dimensions)

       // Are any of the higher dimensions distributed?
       // It might be that we can remove this as a restriction will a little more work!
          for (temp=reshape_dim; temp<MAX_ARRAY_DIMENSION; temp++)
             {
               if (Partitioned_Dims[temp])
                  {
                    printf("NOTE: can't reshape so that array collapses to a smaller \n");
                    printf("   dimensionality than a distributed dimension in P++ \n");
                    printf("   The problematic dimension is %d out of (0-%d) \n", temp, MAX_ARRAY_DIMENSION-1);
                 // APP_ABORT();
                  }
             }
#endif

#if 1
       // This is no longer a constraint (at least not with leading unit dimensions)

       // The following loop is related to a mechanism in reshape which I don't think is used in 
       // parallel and might be a problem with ghost boundaries (but I'm not certain).
          int old_cntr = 0;
          int new_cntr = 0;
          do {
            // ... find which dimension of new array will have partitions
            // coresponding to old partitions and check to make sure
            // lengths are the same ...

               int old_prod = 1;
               while (!Partitioned_Dims[old_cntr]) 
                  {
                    old_prod *= getLength(old_cntr);
                    old_cntr++;
                    if (old_cntr >= MAX_ARRAY_DIMENSION) break;
                  }

            // Now "old_cntr" corresponds to new partitioned dimension or is >= MAX_ARRAY_DIMENSION

               int new_prod = 1;
               if (old_cntr > 0)
                  {
                    new_prod = Integer_List[new_cntr];
                    while (new_prod <= old_prod)
                       {
	                 new_cntr++;
                         if (new_cntr >= MAX_ARRAY_DIMENSION) break;
                         new_prod *= Integer_List[new_cntr];
                       }
                  }

            // Now "new_cntr" correspond to new partitioned dimension or is >= MAX_ARRAY_DIMENSION

               if (old_cntr == MAX_ARRAY_DIMENSION || new_cntr == MAX_ARRAY_DIMENSION)
		  break;

               if ( (getLength(old_cntr) != Integer_List[new_cntr]) && (Integer_List[new_cntr] != 1) )
                  {
                 // printf("NOTE: reshaping a distributed dimension in P++ with any length except 1 \n");
                 // printf("     getLength(old_cntr) != Integer_List[new_cntr] (%d != %d) \n",
                 //      getLength(old_cntr),Integer_List[new_cntr]);
                    printf("ERROR: can't reshape a distributed dimension in P++ with any length except 1 \n");
                    APP_ABORT();
                  }
               old_cntr++;
               new_cntr++;
             }
          while (old_cntr < MAX_ARRAY_DIMENSION && new_cntr < MAX_ARRAY_DIMENSION);
        }
#endif

  // ... save Array_ID from both parallel and serial arrays ...
     int Old_Parallel_ID = Array_ID();
     int Old_Serial_ID   = Array_Descriptor.SerialArray->Array_ID();

  // ... store pointer to data and increment reference count so the data in the
  // original SerialArray isn't deleted and then delete the SerialArray
  // so there isn't a memory leak ...
     double* Old_Data_Pointer = Array_Descriptor.SerialArray->Array_Descriptor.Array_Data;
     Array_Descriptor.SerialArray->incrementRawDataReferenceCount();

#if defined(USE_PADRE)
  // We have to remove the references in PADRE to the Serial_Array object
  // which is being deleted.  This is a consequence of P++ using PADRE in a way
  // so as to prevent the redundent storage of Array_Domain objects 
  // (specifically we use PADRE in a way so that only references are stored).
     setLocalDomainInPADRE_Descriptor(NULL);
#endif

  // printf ("In reshape: Array_Descriptor.SerialArray->getReferenceCount() = %d \n",Array_Descriptor.SerialArray->getReferenceCount() );
     APP_ASSERT (Array_Descriptor.SerialArray->getReferenceCount() >= getReferenceCountBase());

  // Added conventional mechanism for reference counting control
  // operator delete no longer decriments the referenceCount.
     Array_Descriptor.SerialArray->decrementReferenceCount();
     if (Array_Descriptor.SerialArray->getReferenceCount() < getReferenceCountBase())
          delete Array_Descriptor.SerialArray;
     Array_Descriptor.SerialArray = NULL;

#if 0
#if defined(PPP)
  // APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#2 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
       else
          printf ("Reshape-#2 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
     if (newPartitioningObject != NULL)
          printf ("Reshape-#2 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
       else
          printf ("Reshape-#2 newPartitioningObject is NULL \n");
#endif
#endif

  // ... save partitioning so reshaped array will have the same partition
  // and delete this from array list for partitioning because
  // Initialize_Array will add this back again. Also increment reference count. ...
     Internal_Partitioning_Type* old_partition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
     if (old_partition != NULL)
        {
          Internal_Partitioning_Type::DeleteArrayToPartitioning (*old_partition,*this);

       // printf ("In doubleArray::reshape: Should we now be incrementing the reference count??? \n");

       // ... wrong thing to do because partion will only be deleted once for this array ...
       // old_partition->incrementReferenceCount();
        }
       else
        {
          Internal_Partitioning_Type::DeleteArrayToPartitioning (*this);
        }

#if 0
#if defined(PPP)
  // APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#3 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
       else
          printf ("Reshape-#3 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
     if (newPartitioningObject != NULL)
          printf ("Reshape-#3 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
       else
          printf ("Reshape-#3 newPartitioningObject is NULL \n");
#endif
#endif

  // Now delete the current Partitioning object???
  // Added error checking (11/19/2000)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
        {
          APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                      Internal_Partitioning_Type::getReferenceCountBase());

          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() <
              Internal_Partitioning_Type::getReferenceCountBase())
             {
            // printf ("calling delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
               delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
             }
          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;
        }
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL);

#if 0
#if defined(PPP)
     APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#3.5 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
     if (newPartitioningObject != NULL)
          printf ("Reshape-#3.5 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif

 //  Now attach the new partitioning object to the current array object
     if (newPartitioningObject != NULL)
        {
          printf ("Resetting the Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
          newPartitioningObject->incrementReferenceCount();
          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = newPartitioningObject;
        }
#endif

#if 0
#if defined(PPP)
  // APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#4 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
       else
          printf ("Reshape-#4 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
     if (newPartitioningObject != NULL)
          printf ("Reshape-#4 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
       else
          printf ("Reshape-#4 newPartitioningObject is NULL \n");
#endif
#endif

#if defined(USE_PADRE)
  // What PADRE function should we call?
     if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
        {
          Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
	     decrementReferenceCount();
          if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
	      getReferenceCount() <
              Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
	      getReferenceCountBase())
               delete Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer;
        }
     Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer = NULL;
#else
  // ... these get set to null without deleting by Initialize_Array ...
     if (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition != NULL)  
          delete_DECOMP(Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition);  
     Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition = NULL;

     if (Array_Descriptor.Array_Domain.BlockPartiArrayDomain!= NULL)  
          delete_DARRAY(Array_Descriptor.Array_Domain.BlockPartiArrayDomain);  
     Array_Descriptor.Array_Domain.BlockPartiArrayDomain = NULL;

  // End of USE_PADRE not defined
#endif

     if (APP_DEBUG > 0)
        {
          printf ("Inside of doubleArray::reshape --- BEFORE Initialize_Array(MAX_ARRAY_DIMENSION,Integer_List) ");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }

  // Compute the dimension of the new array object (it might be different from the old array object!)
     int newNumberOfDimensions = Array_Domain_Type::computeDimension(Integer_List);

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#5 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
     if (newPartitioningObject != NULL)
          printf ("Reshape-#5 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif
#endif

  // printf ("In reshape: newNumberOfDimensions = %d \n",newNumberOfDimensions);

  // The newPartitioningObject could be NULL if it represents the parent 
  // (removing leading unit dimensions) and the parent represent the default partitioning
     if (newPartitioningObject == NULL)
        {
       // printf ("Calling Initialize_Descriptor and initializeArray: newPartitioningObject == NULL \n");
       // Array_Descriptor.Array_Domain.Initialize_Domain ( MAX_ARRAY_DIMENSION, Integer_List );
          Array_Descriptor.Initialize_Descriptor (newNumberOfDimensions,Integer_List,NULL);
          initializeArray ();
        }
       else
        {
       // printf ("Calling Initialize_Descriptor and initializeArray: newPartitioningObject != NULL \n");
       // Array_Descriptor.Array_Domain.Initialize_Domain ( MAX_ARRAY_DIMENSION, Integer_List,*newPartitioningObject );
       // Array_Descriptor.Array_Domain.display("newPartitioningObject != NULL");

#if 0
#if defined(PPP)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
               printf ("Reshape-#6 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
          if (newPartitioningObject != NULL)
             {
               printf ("Reshape-#6 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
               printf ("#6 newPartitioningObject->intArrayList.getLength()    = %d \n",newPartitioningObject->intArrayList.getLength());
               printf ("#6 newPartitioningObject->floatArrayList.getLength()  = %d \n",newPartitioningObject->floatArrayList.getLength());
               printf ("#6 newPartitioningObject->doubleArrayList.getLength() = %d \n",newPartitioningObject->doubleArrayList.getLength());
            // APP_ASSERT (newPartitioningObject->intArrayList.getLength()+newPartitioningObject->floatArrayList.getLength()+newPartitioningObject->doubleArrayList.getLength()+Internal_Partitioning_Type::getReferenceCountBase() == newPartitioningObject->referenceCount);
             }
#endif
#endif

          APP_ASSERT (newPartitioningObject != NULL);
          APP_ASSERT (newPartitioningObject != Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
          Array_Descriptor.Initialize_Descriptor (newNumberOfDimensions,Integer_List,newPartitioningObject);

       // The serialArray is not allocated and this leads to an assertion failure
       // Array_Descriptor.display("newPartitioningObject != NULL");

#if 0
#if defined(PPP)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
               printf ("Reshape-#7 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
          if (newPartitioningObject != NULL)
               printf ("Reshape-#7 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif
#endif

       // This causes the partitioning object to be initialized again (and its reference count incremented again)
       // initializeArray (*newPartitioningObject);
       // initializeArray ();
          initializeArray (*newPartitioningObject);

#if 0
          printf ("Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getLocalGhostCellWidth(0) = %d \n",
                   Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getLocalGhostCellWidth(0));
          printf ("Array_Descriptor.Array_Domain.InternalGhostCellWidth [0] = %d \n",
                   Array_Descriptor.Array_Domain.InternalGhostCellWidth [0]);
#endif
          APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getLocalGhostCellWidth(0) == 
                      Array_Descriptor.Array_Domain.InternalGhostCellWidth [0]);

          APP_ASSERT (Array_Descriptor.SerialArray != NULL);

       // view("newPartitioningObject != NULL");
        }

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#8 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
     if (newPartitioningObject != NULL)
          printf ("Reshape-#8 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif
#endif

  // ********************************************************
  // **********************  Clean Up  **********************
  // ********************************************************

  // We don't need this refernece any more so delete it now!
     if (newPartitioningObject != NULL)
        {
          APP_ASSERT (newPartitioningObject->getReferenceCount() >= Internal_Partitioning_Type::getReferenceCountBase());
          newPartitioningObject->decrementReferenceCount();
          if (newPartitioningObject->getReferenceCount() <
              Internal_Partitioning_Type::getReferenceCountBase())
             {
               printf ("calling delete newPartitioningObject \n");
               delete newPartitioningObject;
             }
          newPartitioningObject = NULL;
        }
     APP_ASSERT (newPartitioningObject == NULL);

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#9 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
#endif
#endif

#if COMPILE_DEBUG_STATEMENTS
     int i = 0;

  // Check that the leading unit dimensions added have ZERO ghost
  // boundary width so that no data movement is required
     for (i = 0; i < numberOfLeadingOnesAddedInNewArrayShape; i++)
        {
       // All added dimensions should have zero ghost boundary width (since the ghost boundaries
       // are allocated on the exterior boundary of the array even for nondistributed dimensions)
       // printf ("Final resulting array in reshape(): getGhostBoundaryWidth(%d) = %d \n",
       //      i,getGhostBoundaryWidth(i));
          APP_ASSERT (getGhostBoundaryWidth(i) == 0);
        }

  // Check that the ghost boundary widths of the trailing 
  // dimensions of a array object are zero as well
     for (i = numberOfDimensions(); i < MAX_ARRAY_DIMENSION; i++)
        {
       // All added dimensions should have zero ghost boundary width (since the ghost boundaries
       // are allocated on the exterior boundary of the array even for nondistributed dimensions)
       // printf ("Final resulting array in reshape(): getGhostBoundaryWidth(%d) = %d \n",
       //      i,getGhostBoundaryWidth(i));
          APP_ASSERT (getGhostBoundaryWidth(i) == 0);
        }
#endif

     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     Array_Domain_Type::Push_Array_ID ( Array_Descriptor.SerialArray->Array_ID() );
     Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.setArray_ID (Old_Serial_ID);

     Array_Domain_Type::Push_Array_ID ( Array_ID() );
     Array_Descriptor.Array_Domain.setArray_ID (Old_Parallel_ID);

  // ... Array_Data wasn't allocated with a new ...
     free (Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
     Array_Descriptor.SerialArray->Array_Descriptor.Array_Data = Old_Data_Pointer;

     SERIAL_POINTER_LIST_INITIALIZATION_MACRO

  // printf ("End of P++ section in doubleArray::reshape() \n");
  // END OF P++ SECTION OF RESHAPE
#else
  // START OF A++ SECTION OF RESHAPE

  // if (Array_Descriptor.isView())
  //    {
  //      printf ("ERROR: in doubleArray::reshape -- Can't reshape a view of another A++ array object \n");
  //      APP_ABORT();
  //    }
  //
  // APP_ASSERT( Array_Descriptor.isView() == FALSE );

  // ... We don't really have to save the whole descriptor here so now we
  // just save the little bit of data we require! ...
     int Old_Array_ID = Array_ID();

     if (Array_Descriptor.isView())
        {
       // ... make sure that either all leading dimensions span entire size or
       // that only added leading dimensions have length 1 ...

          int reshape_okay = TRUE;

       // Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List_Non_View;
          int Integer_List_Non_View[MAX_ARRAY_DIMENSION];
          int View_Bases[2*MAX_ARRAY_DIMENSION];
          int View_Sizes[2*MAX_ARRAY_DIMENSION];
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
             {
               Integer_List_Non_View[temp] = Integer_List[temp];
	    // ... initialize these so non short span case will work the same as before ...
               View_Bases[temp] = 0;
               View_Sizes[temp] = Integer_List[temp];
             }

       // ... first check to see if all dimensions of view except the last span the entire array ...

          int short_span = FALSE;
          int numdims = numberOfDimensions();

          for (temp=0; temp < numdims-1; temp++)
               if (getLength(temp) < getRawDataSize(temp))
                    short_span = TRUE;

       // ... if some leading dimensions don't span the entire array then
       // the only reshape allowed is to add leading dimensions of length 1 ...

          if (short_span)
             {
               int Old_Lengths[MAX_ARRAY_DIMENSION];
               for (temp=0; temp<numdims; temp++)
                    Old_Lengths[temp] = getLength(temp);

               int ncntr = 0;
               int ocntr = 0;

               do {
                    if (Integer_List[ncntr] != 1)
                         break;
                    ncntr++;
                  }
               while (ncntr < MAX_ARRAY_DIMENSION);

            // ... at this point ncntr is either the first nonunit dimension
            // in the reshape or is equal to MAX_ARRAY_DIMENSION ...

            // ... find first nonunit dimension in old list ...
               do {
                    if (Old_Lengths[ocntr] > 1)
                         break;
                    ocntr++;
                  }
               while (ocntr < numdims);

            // ... ocntr is now the first nonunit dimension before reshaping.
            // This can't be equal to numdims since short_span is true
            // but double check logic. ...
               APP_ASSERT (ocntr < numdims);

               while ((ocntr < numdims) && (ncntr < MAX_ARRAY_DIMENSION))
                  {
                    if (Old_Lengths[ocntr] != Integer_List[ncntr]) 
                       {
                         reshape_okay = FALSE;
                         break;
                       }
                    ocntr++;
                    ncntr++;
                 // ... increase ocntr up to numdims if old dimension is length 1 ...
                    if (ocntr<numdims) 
                       {
                         while (Old_Lengths[ocntr]==1) 
                            {
                              ocntr++;
                              if (ocntr >= numdims) break;
                            }
                       }
                    if (ncntr<MAX_ARRAY_DIMENSION) 
                       {
                         while (Integer_List[ncntr]==1) 
                            {
                              ncntr++;
                              if (ncntr<MAX_ARRAY_DIMENSION) break; 
                            }
                       }
                  }

               if (reshape_okay)
                    if (ncntr < MAX_ARRAY_DIMENSION)
                         Integer_List_Non_View[ncntr] = getRawDataSize(ocntr);

               if (reshape_okay)
                    fix_view_bases ( View_Bases, View_Sizes, numdims, Old_Lengths, Integer_List);
             }
            else 
             {
            // ... non short span case so see if corresponding reshape of 
            // corresponding nonview is possible by checking to see if 
            // old nonview size is divisible by reshape dimensions ...

               int old_size = 1;
               for (temp=0; temp<numdims; temp++)
                    old_size *= getRawDataSize(temp);

               temp = MAX_ARRAY_DIMENSION-1;
               do {
                    if (Integer_List[temp] > 1) break;
                    temp--;
                  }
               while (temp >= 0);

            // ... if all values of Integer_List are 1 then last_non_unit will be -1 ...
               int last_non_unit = temp;

               int left_over = old_size;
               temp=0; 
	       while (temp<last_non_unit)
                  {
                    if (left_over % Integer_List[temp] != 0) 
                       {
                         reshape_okay = FALSE;
                         break;
                       }
                    left_over /= Integer_List[temp++];
                  }

            // ... if last non unit is -1 leftover will be one and reset will
            // be unecessary but easier to do ...
               if (last_non_unit == -1)
                    last_non_unit = 0;

               if (reshape_okay)
                    fix_view_bases_non_short_span (View_Bases, View_Sizes, numdims, Integer_List);

               if (reshape_okay)
                    View_Sizes[last_non_unit] = left_over;
             }

          if (!reshape_okay)
             {
               printf("ERROR: can't reshape this view because corresponding original \n");
               printf("       array can't be reshaped to produce the shaped view.  \n");
               APP_ABORT();
             }

          Array_Descriptor.Initialize_Descriptor (MAX_ARRAY_DIMENSION,Integer_List);
       // Array_Descriptor.Fixup_Descriptor_With_View (MAX_ARRAY_DIMENSION,View_Sizes,View_Bases);
          Array_Descriptor.reshape (MAX_ARRAY_DIMENSION,View_Sizes,View_Bases);
        }
       else
        {
       // printf ("In reshape(): Calling Initialize_Descriptor -- Array_ID() = %d \n",Array_ID());
          Array_Descriptor.Initialize_Descriptor (MAX_ARRAY_DIMENSION,Integer_List);
        }

  // Since we are reusing the existing array_ID we have to give back the new one 
  // and reset the reference count associated with it since it is not used.
     decrementRawDataReferenceCount();

  // printf ("Before push Array_ID() in reshape(): Array_ID() = %d Old_Array_ID = %d \n",Array_ID(),Old_Array_ID);

  // Bugfix (7/29/96) Fix for growing Reference_Count_Array length
     Array_Domain_Type::Push_Array_ID ( Array_ID() );

  // Reuse the original array ID (after we gave back the one associated with the new array descriptor).
     Array_Descriptor.Array_Domain.setArray_ID (Old_Array_ID);

  // printf ("After setArray_ID: Array_ID() = %d \n",Array_ID());

     Array_Descriptor.Array_Domain.ExpressionTemplateOffset = 0;
     Array_Descriptor.Array_Domain.View_Offset = 0;
     POINTER_LIST_INITIALIZATION_MACRO;

  // printf ("End of reshape(): Array_ID() = %d \n",Array_ID());
  // END OF A++ SECTION OF RESHAPE
#endif

  // Bugfix (11/26/96) Make the error checking avaiable when the bounds checking is turned on
     int Number_Of_Elements_After_Reshape = 0;
     if (Index::Index_Bounds_Checking != FALSE)
        {
          Number_Of_Elements_After_Reshape = elementCount();
          if (Number_Of_Elements_Before_Reshape != Number_Of_Elements_After_Reshape)
             {
               printf ("ERROR: in doubleArray::reshape -- Number_Of_Elements_Before_Reshape != Number_Of_Elements_After_Reshape! \n");
               printf ("       Should have used resize (to preserve data values) or redim (to clear data) \n");
               APP_ABORT();
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Called from BOTTOM of doubleArray::reshape(int*)");
#endif

  // view ("BASE OF RESHAPE");
  // printf ("Exiting at base of reshape \n");
  // APP_ABORT();

     return *this;
   }

doubleArray & doubleArray::reshape ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO
     
     reshape ( Integer_List );

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::reshape(ARGUMENT_LIST_MACRO_CONST_REF_RANGE)");
#endif

     return *this;
   }

// ********************************************************************
// this figures out what the new bases will need to be so view is
// accessed okay when only change to shape is an added or removed 1
// ********************************************************************
void
doubleArray::fix_view_bases (
   int* View_Bases, 
   int* View_Sizes, 
   int numdims,
   const int* Old_Lengths,
   const int* Integer_List)
{
  int temp; 
  int ocntr;
  int ncntr;
  int vcntr;

  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
  {
    View_Bases[temp] = getRawBase(temp)-getDataBase(temp);
    View_Sizes[temp] = getRawDataSize(temp);
  }
  for (temp = MAX_ARRAY_DIMENSION; temp<2*MAX_ARRAY_DIMENSION; temp++)
  {
    View_Bases[temp] = 0;
    View_Sizes[temp] = 1;
  }

  ocntr = ncntr = vcntr = 0;

  while (ocntr < numdims && ncntr < MAX_ARRAY_DIMENSION)
  {
    if (Old_Lengths[ocntr] == Integer_List[ncntr])
    {
      ocntr++;
      ncntr++;
      vcntr++;
    }
    else if (Integer_List[ncntr] == 1)
    {
      // extra 1 added in reshape
      for (temp = 2*MAX_ARRAY_DIMENSION-1; temp>vcntr; temp--)
      {
	View_Bases[temp] = View_Bases[temp-1];
	View_Sizes[temp] = View_Sizes[temp-1];
      }
      View_Bases[vcntr] = 0;
      View_Sizes[vcntr] = 1;
      ncntr++;
      vcntr++;
    }
    else
    {
      // dimension of length 1 lost from reshape
      View_Bases[vcntr] += View_Bases[vcntr+1] * View_Sizes[vcntr];
      View_Sizes[vcntr] *= View_Sizes[vcntr+1];
      for (temp=vcntr+1; temp < 2*MAX_ARRAY_DIMENSION -1; temp++)
      {
	View_Bases[temp] = View_Bases[temp+1];
	View_Sizes[temp] = View_Sizes[temp+1];
      }
      ocntr++;
      vcntr++;
    }
  }

  // now compress sizes and view bases if too many dimensions
  // have been added
  while (vcntr >= MAX_ARRAY_DIMENSION)
  {
    View_Bases[vcntr-1] += View_Bases[vcntr] * View_Sizes[vcntr-1];
    View_Sizes[vcntr-1] *= View_Sizes[vcntr];
    vcntr--;
  }
}

// ********************************************************************
// this figures out what the new bases will need to be so view is
// accessed okay when dimensions of length other than 1 are possibly
// added or changed but all dimensions but the last span the whole
// length both before and after the reshape except the last
// ********************************************************************
void
doubleArray::fix_view_bases_non_short_span ( int* View_Bases, int* View_Sizes, int numdims, const int* Integer_List)
{
  int temp; 

  // ... get sizes and bases from before reshape ...
  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
  {
    View_Sizes[temp] = getRawDataSize(temp);
    View_Bases[temp] = getRawBase(temp)-getDataBase(temp);
  }


  // ... only the last dimension should have a non-zero base ...

  for (temp=0; temp<numdims-1; temp++) APP_ASSERT (View_Bases[temp] == 0);


  // ... put all the offset in the last non unit dimension since this will
  //  be the first dimension guaranteed to work after resetting the rest ...

  int save_base = View_Bases[numdims-1];
  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++) View_Bases[temp] = 0; 

  int total_size = 1;
  for (temp=0; temp<numdims-1; temp++) total_size *= View_Sizes[temp];


  int last_non_unit = 0;
  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
    if (Integer_List[temp]>1) last_non_unit = temp;


  // ... find the size unp to the last nonunit dimension to divide
  //  by since this will be multiplied back in to get the offset ...

  int total_size2 = 1;
  for (temp=0; temp<last_non_unit-1; temp++) total_size2 *= Integer_List[temp];
  
  View_Bases[last_non_unit] = save_base * total_size / total_size2; 


  // ... now reset sizes for after the reshape. The last_non_unit size
  //  will be reset out this routine since this is the only partial
  //  dimension ...

  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
    View_Sizes[temp] = Integer_List[temp];
}

// ********************************************************************
// This reshape function uses Range object to allow both the base and 
// dimensions to be set.
// ********************************************************************
// doubleArray & doubleArray::reshape ( const Range & I , const Range & J , const Range & K , const Range & L )
doubleArray &
doubleArray::reshape ( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     reshape (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::reshape(ARGUMENT_LIST_MACRO_CONST_REF_RANGE)");
#endif

     return *this;
   }

doubleArray &
doubleArray::reshape ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;

     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp]->Stride == 1);
          Integer_List[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base)+1;
        }

     reshape ( Integer_List );

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          setBase (Internal_Index_List[temp]->Base,temp);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::reshape(Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif

     return *this;
   }

// ********************************************************************
// This reshape function uses an existing array object to get both the
// base and dimensions to be set.
// ********************************************************************
doubleArray &
doubleArray::reshape ( const doubleArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  doubleArray::reshape (const doubleArray & X) \n");
#endif

  // Build Range objects
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // Index_List[temp] = Internal_Index (X.getBase(temp),X.getBound(temp));
          int Base  = X.getBase(temp);
          int Bound = X.getBound(temp);
          Index_List[temp] = Internal_Index (Base,(Bound-Base)+1);
          Internal_Index_List[temp] = &(Index_List[temp]);
        }

  // Call reshape using Range objects
     reshape (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::reshape(doubleArray)");
#endif

     return *this;
   }


// ********************************************************************
// This resize member function works the same as redim except it 
// preserves the data (i.e. it copies the data to the old data to
// the new array (truncating the data along dimensions that are made 
// smaller by the resizing of the old array object)).
// ********************************************************************
doubleArray &
doubleArray::resize ( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
  // The resize function uses an existing A++ array and redimensions
  // it to be a different size while preserving as much of the data as possible.

  // Bugfix (10/7/96) This function now calls the resize function that takes range
  // objects.  Thus only a single function implements the details of the resize
  // functionality and all the others call it.  Aren't we clever!

     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  doubleArray::resize ");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }
#endif

  // Build Range objects from the list of integers
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
     {
        int Base  = 0;
        int Length = Integer_List[temp];
        Index_List[temp] = Internal_Index (Base,Length); 
	Internal_Index_List[temp] = &(Index_List[temp]); 
     }

  // Call resize using Range objects
     resize (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::resize(Integer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif

     return *this;
   }

// doubleArray & doubleArray::resize ( int i , int j , int k , int l )
doubleArray & 
doubleArray::resize ( ARGUMENT_LIST_MACRO_INTEGER )
   {
  // The resize function uses an existing A++ array and redimensions
  // it to be a different size without changing the number of elements.
  // It is an error to change the number of elements in the reshaped array.

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

     resize (Integer_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::resize(ARGUMENT_LIST_MACRO_INTEGER)");
#endif

     return *this;
   }

// ********************************************************************
// This is the main resize funtion all the rest are just interface functions to this function
// ********************************************************************
doubleArray & 
doubleArray::resize ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  doubleArray::resize RANGE LIST(base,bound) pairs \n");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" (%d,%d) ",Internal_Index_List[temp]->Base,Internal_Index_List[temp]->Bound);
          printf ("\n");
        }
#endif

     doubleArray* New_Array = NULL;

#if defined(PPP)
  // If within P++ we have used a partition object save it and use it for the final resized array
  // first we us in in the new array we build then we make the current array a nullArray and then
  // we assign the the New_Array to the current one and this will distribute the current array
  // the same as the New_Array and give it the same bases as the New_Array.

     Internal_Partitioning_Type* old_partition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
  // printf ("##### old_partition = %p \n",old_partition);

     if (old_partition != NULL)
        {
       // It might be a performance issue to redistribute the array in this step
       // it might be better to specify the partitioning object when the New_Array
       // is constructed so that we avoid the additional data movement. 
       // This is an optimization for later.
       // New_Array.partition(*old_partition);

       // this will setup the bases correctly
          New_Array = new doubleArray (Internal_Index_List,*old_partition);
        }
       else
        {
          New_Array = new doubleArray (Internal_Index_List);
        }
#else
  // this will setup the bases correctly
     New_Array = new doubleArray (Internal_Index_List);
#endif

     APP_ASSERT (New_Array != NULL);

  // Can't resize a view (it makes no sense)
     if (Array_Descriptor.isView() == TRUE)
        {
          printf ("WARNING in doubleArray::resize: it make little sense to resize a view! \n");
          printf ("     Hint: Check for a view explicitly to avoid calling resize. \n");
          APP_ABORT();
        }

  // APP_ASSERT( Array_Descriptor.isView() == FALSE );

  // Save old base for each dimension
  // This could be made more efficent by avoiding the function call!
     int OldBase  [MAX_ARRAY_DIMENSION];
     int OldBound [MAX_ARRAY_DIMENSION];
     int Intersection_Base  [MAX_ARRAY_DIMENSION];
     int Intersection_Bound [MAX_ARRAY_DIMENSION];
     bool Is_An_Intersection = TRUE;
     Range Range_List [MAX_ARRAY_DIMENSION];

  // The internal A++/P++ interface requires an array of pointers to Internal_Index objects
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Assignment_Index_List;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          OldBase [temp] = getBase(temp);
          OldBound[temp] = getBound(temp);
          Intersection_Base [temp] =
 	     (OldBase[temp]  < Internal_Index_List[temp]->Base)  ? Internal_Index_List[temp]->Base  : OldBase[temp];
          Intersection_Bound[temp] =
             (OldBound[temp] > Internal_Index_List[temp]->Bound) ? Internal_Index_List[temp]->Bound : OldBound[temp];
          if (Intersection_Bound[temp] < Intersection_Base [temp])
               Is_An_Intersection = FALSE;

       // Bugfix (1/27/96) resize did not work for case of Null array
          if( Is_An_Intersection )
               Range_List [temp] = Range ( Intersection_Base[temp] , Intersection_Bound[temp] );
          else
               Range_List [temp] = Range ( 0, 0, 1, Null_Index );
          Assignment_Index_List [temp] = &(Range_List [temp]);
        }

     if (Is_An_Intersection)
        {
       // We can't do this assignment if there is no intersection
          (*New_Array) (Assignment_Index_List) = (*this)(Assignment_Index_List);
        }

#if defined(PPP)
  // Fix to Stefan's resize bug (this fix made this function much simpler)
  // Redimension to a null array then use the assignment operator
     redim(0);

  // Assign the new data to the *this array so that the redimensioning will be done automatically
  // This will pickup the Rhs's partitioning (I verified this as well)
     (*this) = (*New_Array);

  // Bug fix (6/9/2000) Commented out because it does not comile when not using PADRE
  // But not the same PADRE descriptor
  // APP_ASSERT (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer !=
  //             New_Array->Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer);
#else
  // Bug fix (2/14/94) suggested by Marc Reider
  // Save old data and descriptor to assign them to the local 
  // array object which will be deleted when we leave scope!
  // Let this local variable delete the old data 
  // and descriptor when it goes out of scope.
     double *Temp_Data                         = Array_Descriptor.Array_Data;
     Array_Descriptor.Array_Data           = New_Array->Array_Descriptor.Array_Data;
     New_Array->Array_Descriptor.Array_Data = Temp_Data;
  // ... (11/19/98; kdb) switch array ID's also for serial case only because 
  // they are attached to the data that is being switched ...
     int Temp_ID = Array_Descriptor.Array_Domain.internalArrayID;
     Array_Descriptor.Array_Domain.internalArrayID = 
	New_Array->Array_Descriptor.Array_Domain.internalArrayID;
     New_Array->Array_Descriptor.Array_Domain.internalArrayID = Temp_ID;

     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp]->Stride == 1);
          Integer_List[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base)+1;
        }

  // ... (11/17/98;kdb) put Array ID back here because Initialize_Descriptor 
  // will grab a new one and it might as well be the same one it had ...

  // Always reuse the existing Array ID (not clear if this will work need to test it)
     Array_Domain_Type::Push_Array_ID (Array_ID());

  // Why don't we have a function which takes Internal_Index objects?
     Array_Descriptor.Initialize_Descriptor(MAX_ARRAY_DIMENSION,Integer_List);

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          setBase(Internal_Index_List[temp]->Base,temp);

     POINTER_LIST_INITIALIZATION_MACRO;
#endif

  // Now delete the new array we allocated at the start
     APP_ASSERT(New_Array != NULL);
     delete New_Array;
     New_Array = NULL;

#if defined(APP) || ( defined(SERIAL_APP) && !defined(PPP) )
  // For P++ we only track the serial array objects not the serial array objects
     if (Diagnostic_Manager::getTrackArrayData() == TRUE)
        {
       // Since we have changed the size of the array we have to reset the diagnostic data
       // Now initialize the type code in the diagnostic data object so we know the base type of the array object
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
#ifdef DOUBLEARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_DOUBLE_ELEMENT_TYPE);
#endif
#ifdef FLOATARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_FLOAT_ELEMENT_TYPE);
#endif
#ifdef INTARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_INT_ELEMENT_TYPE);
#endif
        }
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::resize");
#endif

     return *this;
   }

doubleArray &
doubleArray::resize ( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  doubleArray::resize RANGE(base,bound) pairs \n");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" (%d,%d) ",Internal_Index_List[temp]->Base,Internal_Index_List[temp]->Bound);
          printf ("\n");
        }
#endif

     resize (Internal_Index_List);  // this will setup the bases correctly

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::resize(int,int,int,int)");
#endif

     return *this;
   }

// ********************************************************************
// This resize function uses an existing array object to get both the
// base and dimensions to be set.
// ********************************************************************
doubleArray &
doubleArray::resize ( const doubleArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  doubleArray::resize (const doubleArray & X) \n");
#endif

  // Build Range objects
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // Index_List[temp] = Internal_Index (X.getBase(temp),X.getBound(temp));
          int Base  = X.getBase(temp);
          int Bound = X.getBound(temp);
          Index_List[temp] = Internal_Index (Base,(Bound-Base)+1);
          Internal_Index_List[temp] = &(Index_List[temp]);
        }

  // Call resize using Range objects
     resize (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::resize(doubleArray)");
#endif

     return *this;
   }

// **************************************************************************
// Function used in the member functions for operator()(Index)
// **************************************************************************
bool
doubleArray::Is_Built_By_Defered_Evaluation() const
   {
  // This can be simplified (there is a member function for this)
     return Array_Descriptor.Array_Domain.Is_Built_By_Defered_Evaluation;
   }



// Expantion of previous macro to handle cross product of types
// normally inlined in inline_support.h
doubleArray*
doubleArray::Build_Temporary_By_Example ( const intArray & Lhs )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::Build_Temporary_By_Example (Lhs) \n");
     Lhs.Test_Consistency("Lhs input in doubleArray::Build_Temporary_By_Example");
#endif

     doubleArray *Temporary_Array = NULL;
     bool Force_Memory_Allocation = !Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION;

#if defined(PPP)
     doubleSerialArray* Null_Array = NULL;
#else
     double* Null_Array = NULL;
#endif


#if defined(PPP)
  // This is part of an expensive O(n^2) operation so use it saringly as a test
     APP_ASSERT (SerialArray_Domain_Type::checkForArrayIDOnStack (Lhs.Array_ID()) == 0);
#endif

  // Call a constructor specific to building a temporary
  // we can distinquish it by handing it a pointer to the member function?
     bool AvoidBuildingIndirectAddressingView = TRUE;
     Temporary_Array = new doubleArray ( Null_Array,
                                       &(Lhs.Array_Descriptor.Array_Domain),
                                       AvoidBuildingIndirectAddressingView);

  // This would be a very slow way to handle this -- and we want to
  // avoid the redudent overhead of initializing the descriptor twice
  // Temporary_Array->Array_Descriptor.Build_Temporary_By_Example(Lhs.Array_Descriptor.Array_Domain);
     APP_ASSERT(Temporary_Array != NULL);

  // printf ("In doubleArray::Build_Temporary_By_Example: Temporary_Array->Array_ID() != Lhs.Array_ID() (%d != %d) \n",
  //      Temporary_Array->Array_ID(),Lhs.Array_ID());

     APP_ASSERT(Temporary_Array->Array_ID() != Lhs.Array_ID());
     APP_ASSERT(Temporary_Array->getRawDataReferenceCount() == Temporary_Array->getReferenceCountBase());

  // Later if we change now the base is set in assignement we might want to change this!
  // ... (4/23,98, kdb) base is already set and might not be set to
  // APP_Global_Array_Base if indirect addressing is used ...
  // Temporary_Array->setBase(APP_Global_Array_Base);

  // We have to set the resulting array to be a temporary array
     Temporary_Array->setTemporary(TRUE);
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

  // We can't generate a temporary which requires indirect addressing 
  // (i.e. the temporary returns is a gathered quantity).
     APP_ASSERT(Temporary_Array->usesIndirectAddressing() == FALSE);

  // Build the space for the size of array indicated by the descriptor (just built above)
     Temporary_Array->Allocate_Array_Data(Force_Memory_Allocation);

  // When we build a temporary by example using Lhs we should make sure we return a 
  // temporary!  Make sure it is still a temporary after calling Allocate_Array_Data()
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

#if !defined(PPP)
  // Set up the Array_View_Pointers for scalar indexing
     TEMPORARY_POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if INITIALIZE_TEMPORARY_MEMORY
  // printf ("START: Initialize temporary array! \n");

  // Save the where mask so that the whole array will be initialized!
     intdoubleArray *Temp_Where_Mask = Where_Statement_Support::Where_Statement_Mask;
     Where_Statement_Support::Where_Statement_Mask = NULL;
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;

  // Initialize the new array
     *Temporary_Array = 0;

  // Now restore the where mask as if nothing had ever happened!
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
     Where_Statement_Support::Where_Statement_Mask = Temp_Where_Mask;
     Temp_Where_Mask = NULL;
  // printf ("END: Initialize temporary array! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
  // Initialize the new array (temp code)
  // *Temporary_Array = 0;

     Temporary_Array->Test_Consistency("doubleArray::Build_Temporary_By_Example");

  // Helpful mechanism for debugging communication models (VSG and Overlap updates models)
     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In doubleArray::Build_Temporary_By_Example(): return array - local range (%d,%d,%d) \n",
               Temporary_Array->getBase(0),
               Temporary_Array->getBound(0),
               Temporary_Array->getStride(0));
        }
#endif

#if 0
  // Error checking (part of debugging)
     Temporary_Array->view("doubleArray::Build_Temporary_By_Example -- Temporary_Array->view()");
  // APP_ABORT();
#endif

     return Temporary_Array;
   }

// normally inlined in inline_support.h
doubleArray*
doubleArray::Build_Temporary_By_Example ( const floatArray & Lhs )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::Build_Temporary_By_Example (Lhs) \n");
     Lhs.Test_Consistency("Lhs input in doubleArray::Build_Temporary_By_Example");
#endif

     doubleArray *Temporary_Array = NULL;
     bool Force_Memory_Allocation = !Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION;

#if defined(PPP)
     doubleSerialArray* Null_Array = NULL;
#else
     double* Null_Array = NULL;
#endif


#if defined(PPP)
  // This is part of an expensive O(n^2) operation so use it saringly as a test
     APP_ASSERT (SerialArray_Domain_Type::checkForArrayIDOnStack (Lhs.Array_ID()) == 0);
#endif

  // Call a constructor specific to building a temporary
  // we can distinquish it by handing it a pointer to the member function?
     bool AvoidBuildingIndirectAddressingView = TRUE;
     Temporary_Array = new doubleArray ( Null_Array,
                                       &(Lhs.Array_Descriptor.Array_Domain),
                                       AvoidBuildingIndirectAddressingView);

  // This would be a very slow way to handle this -- and we want to
  // avoid the redudent overhead of initializing the descriptor twice
  // Temporary_Array->Array_Descriptor.Build_Temporary_By_Example(Lhs.Array_Descriptor.Array_Domain);
     APP_ASSERT(Temporary_Array != NULL);

  // printf ("In doubleArray::Build_Temporary_By_Example: Temporary_Array->Array_ID() != Lhs.Array_ID() (%d != %d) \n",
  //      Temporary_Array->Array_ID(),Lhs.Array_ID());

     APP_ASSERT(Temporary_Array->Array_ID() != Lhs.Array_ID());
     APP_ASSERT(Temporary_Array->getRawDataReferenceCount() == Temporary_Array->getReferenceCountBase());

  // Later if we change now the base is set in assignement we might want to change this!
  // ... (4/23,98, kdb) base is already set and might not be set to
  // APP_Global_Array_Base if indirect addressing is used ...
  // Temporary_Array->setBase(APP_Global_Array_Base);

  // We have to set the resulting array to be a temporary array
     Temporary_Array->setTemporary(TRUE);
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

  // We can't generate a temporary which requires indirect addressing 
  // (i.e. the temporary returns is a gathered quantity).
     APP_ASSERT(Temporary_Array->usesIndirectAddressing() == FALSE);

  // Build the space for the size of array indicated by the descriptor (just built above)
     Temporary_Array->Allocate_Array_Data(Force_Memory_Allocation);

  // When we build a temporary by example using Lhs we should make sure we return a 
  // temporary!  Make sure it is still a temporary after calling Allocate_Array_Data()
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

#if !defined(PPP)
  // Set up the Array_View_Pointers for scalar indexing
     TEMPORARY_POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if INITIALIZE_TEMPORARY_MEMORY
  // printf ("START: Initialize temporary array! \n");

  // Save the where mask so that the whole array will be initialized!
     intdoubleArray *Temp_Where_Mask = Where_Statement_Support::Where_Statement_Mask;
     Where_Statement_Support::Where_Statement_Mask = NULL;
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;

  // Initialize the new array
     *Temporary_Array = 0;

  // Now restore the where mask as if nothing had ever happened!
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
     Where_Statement_Support::Where_Statement_Mask = Temp_Where_Mask;
     Temp_Where_Mask = NULL;
  // printf ("END: Initialize temporary array! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
  // Initialize the new array (temp code)
  // *Temporary_Array = 0;

     Temporary_Array->Test_Consistency("doubleArray::Build_Temporary_By_Example");

  // Helpful mechanism for debugging communication models (VSG and Overlap updates models)
     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In doubleArray::Build_Temporary_By_Example(): return array - local range (%d,%d,%d) \n",
               Temporary_Array->getBase(0),
               Temporary_Array->getBound(0),
               Temporary_Array->getStride(0));
        }
#endif

#if 0
  // Error checking (part of debugging)
     Temporary_Array->view("doubleArray::Build_Temporary_By_Example -- Temporary_Array->view()");
  // APP_ABORT();
#endif

     return Temporary_Array;
   }

// normally inlined in inline_support.h
doubleArray*
doubleArray::Build_Temporary_By_Example ( const doubleArray & Lhs )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray::Build_Temporary_By_Example (Lhs) \n");
     Lhs.Test_Consistency("Lhs input in doubleArray::Build_Temporary_By_Example");
#endif

     doubleArray *Temporary_Array = NULL;
     bool Force_Memory_Allocation = !Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION;

#if defined(PPP)
     doubleSerialArray* Null_Array = NULL;
#else
     double* Null_Array = NULL;
#endif


#if defined(PPP)
  // This is part of an expensive O(n^2) operation so use it saringly as a test
     APP_ASSERT (SerialArray_Domain_Type::checkForArrayIDOnStack (Lhs.Array_ID()) == 0);
#endif

  // Call a constructor specific to building a temporary
  // we can distinquish it by handing it a pointer to the member function?
     bool AvoidBuildingIndirectAddressingView = TRUE;
     Temporary_Array = new doubleArray ( Null_Array,
                                       &(Lhs.Array_Descriptor.Array_Domain),
                                       AvoidBuildingIndirectAddressingView);

  // This would be a very slow way to handle this -- and we want to
  // avoid the redudent overhead of initializing the descriptor twice
  // Temporary_Array->Array_Descriptor.Build_Temporary_By_Example(Lhs.Array_Descriptor.Array_Domain);
     APP_ASSERT(Temporary_Array != NULL);

  // printf ("In doubleArray::Build_Temporary_By_Example: Temporary_Array->Array_ID() != Lhs.Array_ID() (%d != %d) \n",
  //      Temporary_Array->Array_ID(),Lhs.Array_ID());

     APP_ASSERT(Temporary_Array->Array_ID() != Lhs.Array_ID());
     APP_ASSERT(Temporary_Array->getRawDataReferenceCount() == Temporary_Array->getReferenceCountBase());

  // Later if we change now the base is set in assignement we might want to change this!
  // ... (4/23,98, kdb) base is already set and might not be set to
  // APP_Global_Array_Base if indirect addressing is used ...
  // Temporary_Array->setBase(APP_Global_Array_Base);

  // We have to set the resulting array to be a temporary array
     Temporary_Array->setTemporary(TRUE);
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

  // We can't generate a temporary which requires indirect addressing 
  // (i.e. the temporary returns is a gathered quantity).
     APP_ASSERT(Temporary_Array->usesIndirectAddressing() == FALSE);

  // Build the space for the size of array indicated by the descriptor (just built above)
     Temporary_Array->Allocate_Array_Data(Force_Memory_Allocation);

  // When we build a temporary by example using Lhs we should make sure we return a 
  // temporary!  Make sure it is still a temporary after calling Allocate_Array_Data()
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

#if !defined(PPP)
  // Set up the Array_View_Pointers for scalar indexing
     TEMPORARY_POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if INITIALIZE_TEMPORARY_MEMORY
  // printf ("START: Initialize temporary array! \n");

  // Save the where mask so that the whole array will be initialized!
     intdoubleArray *Temp_Where_Mask = Where_Statement_Support::Where_Statement_Mask;
     Where_Statement_Support::Where_Statement_Mask = NULL;
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;

  // Initialize the new array
     *Temporary_Array = 0;

  // Now restore the where mask as if nothing had ever happened!
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
     Where_Statement_Support::Where_Statement_Mask = Temp_Where_Mask;
     Temp_Where_Mask = NULL;
  // printf ("END: Initialize temporary array! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
  // Initialize the new array (temp code)
  // *Temporary_Array = 0;

     Temporary_Array->Test_Consistency("doubleArray::Build_Temporary_By_Example");

  // Helpful mechanism for debugging communication models (VSG and Overlap updates models)
     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In doubleArray::Build_Temporary_By_Example(): return array - local range (%d,%d,%d) \n",
               Temporary_Array->getBase(0),
               Temporary_Array->getBound(0),
               Temporary_Array->getStride(0));
        }
#endif

#if 0
  // Error checking (part of debugging)
     Temporary_Array->view("doubleArray::Build_Temporary_By_Example -- Temporary_Array->view()");
  // APP_ABORT();
#endif

     return Temporary_Array;
   }


// ***********************************************************************************
// This function is used in the abstract binary operators to control the reuse of
// temporaries.  If the Lhs or Rhs is a temporary then it can be reused -- else
// a real temporary must be allocated for use within the expression evaluation.
// Temporaries are marked in the descriptor as being temporaries so that they can
// be readily identified as such.  It is possible to provide such functionality
// as a seperate class but I have never seen it done in such a way as to be practical
// for a large and meaningful array class.
// ***********************************************************************************

// normally inlined in inline_support.h
doubleArray &
doubleArray::Build_New_Array_Or_Reuse_Operand ( const doubleArray & Lhs , const doubleArray & Rhs ,
                                              Memory_Source_Type & Result_Array_Memory )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray &doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs (Lhs,Rhs,Memory_Type) \n");

  // Error checking
  // APP_ASSERT(Lhs.Array_Descriptor && Rhs.Array_Descriptor);
  // Lhs.view("Lhs in (AT TOP) doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
  // Rhs.view("Rhs in (AT TOP) doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
#endif

     doubleArray *Temporary_Array = NULL;

  // New code with faster logic (13/10/94).
  // Most common case of Rhs as temporary placed first
  // Bug fix (11/5/94) P++ relies on the order of preference in reuse of temporaries
  // this is a bad sort of dependence (I hate it).  It should be fixed but I'm not clear
  // how that should be done.
     if (Lhs.isTemporary())
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("In doubleArray::Build_New_Array_Or_Reuse_Operand - Reusing Lhs array object to hold temporary \n");
#endif
          Temporary_Array     = &(doubleArray &) Lhs;
          Result_Array_Memory = Memory_From_Lhs;

       // Bugfix (12/3/2000) must record the new reference
          Temporary_Array->incrementReferenceCount();
        }
       else
        {
          if (Rhs.isTemporary())
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("In doubleArray::Build_New_Array_Or_Reuse_Operand - Reusing Rhs array object to hold temporary \n");
#endif
               Temporary_Array     = &(doubleArray &) Rhs;
               Result_Array_Memory = Memory_From_Rhs;

            // Bugfix (12/3/2000) must record the new reference
               Temporary_Array->incrementReferenceCount();
             }
            else
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("Building a new array object to hold temporary \n");
               Lhs.Test_Consistency ("doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
            // Lhs.view("Lhs in (AT TOP) doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
            // Rhs.view("Rhs in (AT TOP) doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
#endif
            // We use the Lhs because this simplifies the final assignment process
            // by making the resulting temporary aligned with the Lhs of the operator=
            // this technique reduces the communication require for the parallel array 
            // statements.
               Temporary_Array     = doubleArray::Build_Temporary_By_Example (Lhs);
               Result_Array_Memory = Newly_Allocated_Memory;
             }
        }

#if COMPILE_DEBUG_STATEMENTS
  // Lhs.view("Lhs in (AT BOTTOM) doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
  // Rhs.view("Rhs in (AT BOTTOM) doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
  // Temporary_Array->view("Temporary_Array in (AT BOTTOM) doubleArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
#endif

     return *Temporary_Array;
   }

// ***********************************************************************************
// This function is used in the abstract unary operators to control the reuse of
// temporaries.  If the Lhs or Rhs is a temporary then it can be reused -- else
// a real temporary must be allocated for use within the expression evaluation.
// Temporaries are marked in the descriptor as being temporaries so that they can
// be readily identified as such.  It is possible to provide such functionality
// as a seperate class but I have never seen it done in such a way as to be practical
// for a large and meaningful array class.
// ***********************************************************************************

// normally inlined in inline_support.h
doubleArray &
doubleArray::Build_New_Array_Or_Reuse_Operand ( const doubleArray & X , Memory_Source_Type & Result_Array_Memory )
   {
     doubleArray *Temporary_Array = NULL;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of doubleArray &doubleArray::Build_New_Array_Or_Reuse_Operand (Operand,Memory_Type) \n");

  // APP_ASSERT(X.Array_Descriptor);
#endif

     if (X.isTemporary())
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("In doubleArray::Build_New_Array_Or_Reuse_Operand - Reusing X array object to hold temporary \n");
#endif
          Temporary_Array     = &(doubleArray &) X;
          Result_Array_Memory = Memory_From_Operand;

       // Bugfix (12/3/2000) must record the new reference
          Temporary_Array->incrementReferenceCount();
        }
       else
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("Building a new array object to hold temporary \n");
          X.Test_Consistency ("doubleArray::Build_New_Array_Or_Reuse_Operand");
#endif
          Temporary_Array     = doubleArray::Build_Temporary_By_Example (X);
          Result_Array_Memory = Newly_Allocated_Memory;
        }

     return *Temporary_Array;
   }

void
Delete_If_Temporary ( const doubleArray & X )
   {
  // Constants can never be a temporary - it is the law! 
  // I admit that it seems questionable to delete an object
  // that is passed in by a const ref but mutable types will 
  // make this a more acceptable thing to do when they 
  // appear in C++ (next version -- I think)

// #if !defined(SERIAL_APP) 
  // These behavior was reverified on (2/26/96) while fixing memory leaks in P++.
  // We only activate the temporary management for the A++ and P++ objects
  // not for the Serial_A++ objects.  This is to aviod the redundent
  // management of P++ arrays and Serial_A++ arrays that are used internally in
  // P++.  The way we avoid this temporary management of the Serial_A++ objects is
  // to eliminate the body of this function when it is used to generate the
  // Serial_A++ member function

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("################################################################### \n");
          printf ("############# Inside of doubleArray::Delete_If_Temporary! ########### \n");
          printf ("################################################################### \n");
        }
#endif

  // Bug fix (11/30/93) Views have to have local scope else they are
  // deleted too soon when passed by reference to an expression.
  // Since they have no data associated with them they are not
  // a problem with their longer lifetime! (only a few words are
  // required to hold a view where as a temporary has array data
  // associated with it).

     if (X.isTemporary())
        {
#if COMPILE_DEBUG_STATEMENTS
          if ( (APP_DEBUG > 0) || (Diagnostic_Manager::getReferenceCountingReport() > 0) )
               printf ("Inside of Delete_If_Temporary (DELETING doubleArray object (id=%d)) X.getReferenceCount() = %d \n",
                    X.Array_ID(),X.getReferenceCount());
#endif

       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          X.decrementReferenceCount();
          if (X.getReferenceCount() < doubleArray::getReferenceCountBase())
             {
            // printf ("Deleting the array object (doubleArray)! (doubleArray::getReferenceCountBase() = %d) \n",doubleArray::getReferenceCountBase());

            // Added (12/5/2000) to simplify use in operator.C
#if defined(PPP) && defined(USE_PADRE)
            // Handle case where PADRE is used
            // when using PADRE we have to clear the use of the SerialArray_Domain before
            // deleting the SerialArray object.
               X.setLocalDomainInPADRE_Descriptor(NULL);
#endif

               delete & (doubleArray &) X;    // Notice that we cast away const here!
             }
        }
#if COMPILE_DEBUG_STATEMENTS
       else
        {
          if ( (APP_DEBUG > 0) || (Diagnostic_Manager::getReferenceCountingReport() > 0) )
               printf ("Inside of Delete_If_Temporary (NOT A TEMPORARY doubleArray object (id=%d)) X.getReferenceCount() = %d \n",
                    X.Array_ID(),X.getReferenceCount());
        }
#endif
   }

void
Delete_Lhs_If_Temporary ( const doubleArray & Lhs )
   {
  // The Solaris C++ compiler v3.0 can't inline a function with a static variable we get a
  // "sorry not implemented: cannot expand inline function with static Last_Lhs_doubleArray_Operand" message.
  // So it is a variable with file scope (later we should make it a static data member).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
       // printf ("Inside of Delete_Lhs_If_Temporary! \n");
          printf ("################################################################### \n");
          printf ("########### Inside of doubleArray::Delete_Lhs_If_Temporary! ######### \n");
          printf ("################################################################### \n");
        }
#endif

  // Last_Lhs_doubleArray_Operand is given file scope! We could make it a static member of the class?
     if (Last_Lhs_doubleArray_Operand != NULL)
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("Inside of Delete_Lhs_If_Temporary (DELETING THE LAST LHS)! \n");
#endif
       // I don't think this function is ever called called so as to delete anything!
       // printf ("Exiting from Delete_Lhs_If_Temporary ( const doubleArray & Lhs ) ... \n");
       // exit(1);

       // Added (12/5/2000) to simplify use in operator.C
#if defined(PPP) && defined(USE_PADRE)
       // Handle case where PADRE is used
       // when using PADRE we have to clear the use of the SerialArray_Domain before
       // deleting the SerialArray object.
          Last_Lhs_doubleArray_Operand->setLocalDomainInPADRE_Descriptor(NULL);
#endif

       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          Last_Lhs_doubleArray_Operand->decrementReferenceCount();
          if (Last_Lhs_doubleArray_Operand->getReferenceCount() < doubleArray::getReferenceCountBase())
               delete Last_Lhs_doubleArray_Operand;
       // Last_Lhs_doubleArray_Operand = NULL;
        }

  // Bug fix (11/30/93) Views have to have local scope else they are
  // deleted too soon when passed by reference to an expression.
  // Since they have no data associated with them they are not
  // a problem with their longer lifetime! (only a few words are
  // required to hold a view where as a temporary has array data
  // associated with it).

  // Last_Lhs_doubleArray_Operand = (Lhs.Array_Descriptor.Array_Domain.Is_A_Temporary) ? &((doubleArray &) Lhs) : NULL;

  // This might be a memory leak for P++ since views can be temporaries and must be deleted (sometimes)
     Last_Lhs_doubleArray_Operand = (Lhs.Array_Descriptor.Array_Domain.Is_A_Temporary && !Lhs.Array_Descriptor.Array_Domain.Is_A_View) ? &((doubleArray &) Lhs) : NULL;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Leaving Delete_Lhs_If_Temporary! \n");
        }
#endif
   }

#if defined(PPP) 
doubleSerialArray
doubleArray::getLocalArrayWithGhostBoundaries () const
#else
doubleArray
doubleArray::getLocalArrayWithGhostBoundaries () const
#endif
   {
  // return A++ array that includes ghost cells if P++ or a shallow copy 
  // of itself if A++

  //APP_ASSERT(!Array_Descriptor.Is_A_View);

#if defined(PPP) 
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);

     if ((!Array_Descriptor.Array_Domain.Is_A_View) && 
	 (!Array_Descriptor.Array_Domain.Is_A_Null_Array) &&
	 (!getSerialDomain().Is_A_Null_Array))
        {
          Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
          int i;
          for (i=0;i<MAX_ARRAY_DIMENSION;i++)
             {
               Internal_Index_List[i] = new Range(getLocalFullRange(i));
               APP_ASSERT (Internal_Index_List[i] != NULL);
             }

       // Performance optimization (11/30/2000)
       // doubleSerialArray ReturnArray;
       // ReturnArray.adopt(getDataPointer(),Internal_Index_List);
          APP_ASSERT (getDataPointer() != NULL);
#if 1
          printf ("Inside of doubleArray::getLocalArrayWithGhostBoundaries(): Skipping significant optimization! \n");
          doubleSerialArray ReturnArray;
          ReturnArray.adopt(getDataPointer(),Internal_Index_List);
#else
          doubleSerialArray ReturnArray (getDataPointer(),Internal_Index_List);
#endif
          for (i=0; i < MAX_ARRAY_DIMENSION; i++) 
             {
            // Range objects don't have referenceCounting! (should they?)
               delete Internal_Index_List[i];
             }
          return doubleSerialArray(ReturnArray,SHALLOWCOPY);
        }
       else
        {
          return doubleSerialArray(*Array_Descriptor.SerialArray,SHALLOWCOPY);
        }
  // printf("getLocalArrayWithGhostBoundaries doesn't work in parallel right now\n");
#else
     return doubleArray(*this,SHALLOWCOPY);
#endif
   }

#if defined(PPP) 
doubleSerialArray*
doubleArray::getLocalArrayWithGhostBoundariesPointer () const
#else
doubleArray*
doubleArray::getLocalArrayWithGhostBoundariesPointer () const
#endif
   {
  // return A++ array that includes ghost cells if P++ or a shallow copy 
  // of itself if A++

  //APP_ASSERT(!Array_Descriptor.Is_A_View);

#if defined(PPP) 
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);

     APP_ASSERT(Array_Descriptor.SerialArray->isTemporary() == FALSE);

     if ((!Array_Descriptor.Array_Domain.Is_A_View) && 
	 (!Array_Descriptor.Array_Domain.Is_A_Null_Array) &&
	 (!getSerialDomain().Is_A_Null_Array))
        {
          Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
          int i;
          for (i=0;i<MAX_ARRAY_DIMENSION;i++)
             {
               Internal_Index_List[i] = new Range(getLocalFullRange(i));
               APP_ASSERT (Internal_Index_List[i] != NULL);
             }

       // Performance optimization (11/30/2000)
          APP_ASSERT (getDataPointer() != NULL);
#if 1
          printf ("Inside of doubleArray::getLocalArrayWithGhostBoundariesPointer(): Skipping significant optimization! \n");
          doubleSerialArray* ReturnArray = new doubleSerialArray();
          APP_ASSERT (ReturnArray != NULL);
          ReturnArray->adopt(getDataPointer(),Internal_Index_List);
#else
          doubleSerialArray* ReturnArray = new doubleSerialArray (getDataPointer(),Internal_Index_List);
          APP_ASSERT (ReturnArray != NULL);
#endif
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
            // Range objects don't have referenceCounting! (should they?)
               delete Internal_Index_List[i];
             }
       // return new doubleSerialArray(ReturnArray,SHALLOWCOPY);
          return ReturnArray;
       }
      else
       {
         return new doubleSerialArray(*Array_Descriptor.SerialArray,SHALLOWCOPY);
       }
  // printf("getLocalArrayWithGhostBoundaries doesn't work in parallel right now\n");
#else
     return new doubleArray(*this,SHALLOWCOPY);
#endif
   }

void
doubleArray::testArray()
   {
  // This function writes over the existing data in the "this" array
  // and is provided as a more robust test of the internal descriptor data
  // than the inpection only based Test_Consistency() member function.

  // Call the nondestructive test since it is easy to do!
#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("doubleArray::testArray");
#else
     printf ("NOTE: internal debugging turned OFF -- so testArray error checking is not meaningful! \n");
#endif

  // build a reference to the "this" array
     doubleArray & X = *this;

  // Test use of assignment operator
     X = 1;

#if 0
  // This does not work for P++ arrays
  // test scalar indexing of the whole array
     double* arrayPointer  = Array_Descriptor.Array_View_Pointer5;
     APP_ASSERT (Array_Descriptor.Array_View_Pointer5 == 
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[5]);
#endif

     int i=0;
     int j=0;
     int k=0;
     int l=0;
     int m=0;
     int n=0;

     APP_ASSERT (MAX_ARRAY_DIMENSION == 6);

  // Example of 6D indexing
     for (n=getBase(5); n <= getBound(5); n += getRawStride(5))
        {
          int offset_m = (n*getRawDataSize(4));
          for (m=getBase(4); m <= getBound(4); m += getRawStride(4))
             {
               int offset_l = offset_m+(m*getRawDataSize(3));
               for (l=getBase(3); l <= getBound(3); l += getRawStride(3))
                  {
                    int offset_k = offset_l+(l*getRawDataSize(2));
                    for (k=getBase(2); k <= getBound(2); k += getRawStride(2))
                       {
                         int offset_j = offset_k+(k*getRawDataSize(1));
                         for (j=getBase(1); j <= getBound(1); j += getRawStride(1))
                            {
                              int offset_i = offset_j+(j*getRawDataSize(0));
                              for (i=getBase(0); i <= getBound(0); i += getRawStride(0))
                                 {
                                // if (arrayPointer[offset_i+i])  // (example of precomputed invariant indexing)
                                // printf ("In testArray(): i = %d j = %d k = %d l = %d m = %d n = %d \n",
                                //      i,j,k,l,m,n);
				   X(i,j,k,l,m,n) = 1;
                                // arrayPointer[offset_i+i] = 2;
                                 }
                            }
                       }
                  }
             }
        }
   }


#undef DOUBLEARRAY

#define FLOATARRAY
// *********************************************************
// *********************************************************
// ***********  STATIC VARIABLE INITIALIZEATION  ***********
// *********************************************************
// *********************************************************

#if !defined(PPP)
// *********************************************************
// Hash tables can be used to to avoid redundent allocation 
// and deallocation associated with the use of temporaries.
// Temporaries are created and saved for reuse when the same 
// size temporary is required again. No smart system for aging
// of hashed memory is used to avoid the acumulation of reserved
// memory for reuse.  Also no measurable advantage of this 
// feature has been observed.
// *********************************************************
// floatArray_Data_Hash_Table floatArray::Hash_Table;
#endif

// *********************************************************
// A++/P++ arrays can be optionally set to always initialize their
// data to a user defined value on construction.  This feature is generally 
// turned off to avoid the performance overhead of unrequired 
// initialization. The value used for the optional initialization
// is defined in floatArray::PREINITIALIZE_VALUE -- but may be 
// redefined by the user.  The default value is
// INT_MAX -- this is choosen because it is a value more likely
// to allow users to catch errors in there codes.
// This feature of A++/P++ arrose out of discussions with Bill Rider.
// *********************************************************
bool floatArray::PREINITIALIZE_OBJECT_IN_CONSTRUCTOR = FALSE;
float      floatArray::PREINITIALIZE_VALUE                 = (float) INT_MAX;
bool floatArray::USE_DESCRIPTOR_CACHING              = FALSE;

// *********************************************************
// Constants to allow different formating of array data in
// the A++ display member function
// *********************************************************
const int floatArray::DECIMAL_DISPLAY_FORMAT     = 0;
const int floatArray::EXPONENTIAL_DISPLAY_FORMAT = 1;
const int floatArray::SMART_DISPLAY_FORMAT       = 2;
// On the HP machines their C++ compiler initializes const static
// variable AFTER non-const static variables thus the DISPLAY_FORMAT
// gets garbage.  To fix this we initialize DISPLAY_FORMAT with the 
// value 2 directly!
// int floatArray::DISPLAY_FORMAT = floatArray::SMART_DISPLAY_FORMAT;
int floatArray::DISPLAY_FORMAT = 2;

// *********************************************************
/* Constants used to define specific operations              */
/* (used within runtime system for control of optimizations) */
// *********************************************************
const int floatArray::Plus             = 0;
const int floatArray::Minus            = 1;
const int floatArray::Times            = 2;
const int floatArray::Divided_By       = 3;
const int floatArray::Modulo           = 4;
const int floatArray::cos_Function     = 5;
const int floatArray::sin_Function     = 6;
const int floatArray::tan_Function     = 7;
const int floatArray::acos_Function    = 8;
const int floatArray::asin_Function    = 9;
const int floatArray::atan_Function    = 10;
const int floatArray::cosh_Function    = 11;
const int floatArray::sinh_Function    = 12;
const int floatArray::tanh_Function    = 13;
const int floatArray::acosh_Function   = 14;
const int floatArray::asinh_Function   = 15;
const int floatArray::atanh_Function   = 16;
const int floatArray::log_Function     = 17;
const int floatArray::log10_Function   = 18;
const int floatArray::exp_Function     = 19;
const int floatArray::sqrt_Function    = 20;
const int floatArray::fabs_Function    = 21;
const int floatArray::abs_Function     = 22; 
const int floatArray::ceil_Function    = 23;
const int floatArray::floor_Function   = 24;
const int floatArray::atan2_Function   = 25;
const int floatArray::Unary_Minus      = 26;
const int floatArray::fmod_Function    = 27;
const int floatArray::mod_Function     = 28;
const int floatArray::pow_Function     = 29;
const int floatArray::sign_Function    = 30;
const int floatArray::min_Function     = 31;
const int floatArray::max_Function     = 32;
const int floatArray::Not              = 33;
const int floatArray::LT               = 34;
const int floatArray::GT               = 35;
const int floatArray::LTEQ             = 36;
const int floatArray::GTEQ             = 37;
const int floatArray::EQ               = 38;
const int floatArray::NOT_EQ           = 39;
const int floatArray::AND              = 40;
const int floatArray::OR               = 41;

const int floatArray::Scalar_Plus             = 42;
const int floatArray::Scalar_Minus            = 43;
const int floatArray::Scalar_Times            = 44;
const int floatArray::Scalar_Divided_By       = 45;
const int floatArray::Scalar_Modulo           = 46;
const int floatArray::Scalar_cos_Function     = 47;
const int floatArray::Scalar_sin_Function     = 48;
const int floatArray::Scalar_tan_Function     = 49;
const int floatArray::Scalar_acos_Function    = 50;
const int floatArray::Scalar_asin_Function    = 51;
const int floatArray::Scalar_atan_Function    = 52;
const int floatArray::Scalar_cosh_Function    = 53;
const int floatArray::Scalar_sinh_Function    = 54;
const int floatArray::Scalar_tanh_Function    = 55;
const int floatArray::Scalar_acosh_Function   = 56;
const int floatArray::Scalar_asinh_Function   = 57;
const int floatArray::Scalar_atanh_Function   = 58;
const int floatArray::Scalar_log_Function     = 59;
const int floatArray::Scalar_log10_Function   = 60;
const int floatArray::Scalar_exp_Function     = 61;
const int floatArray::Scalar_sqrt_Function    = 62;
const int floatArray::Scalar_fabs_Function    = 63;
const int floatArray::Scalar_abs_Function     = 64;
const int floatArray::Scalar_ceil_Function    = 65;
const int floatArray::Scalar_floor_Function   = 66;
const int floatArray::Scalar_atan2_Function   = 67;
const int floatArray::Scalar_Unary_Minus      = 68;
const int floatArray::Scalar_fmod_Function    = 69;
const int floatArray::Scalar_mod_Function     = 70;
const int floatArray::Scalar_pow_Function     = 71;
const int floatArray::Scalar_sign_Function    = 72;
const int floatArray::Scalar_min_Function     = 73;
const int floatArray::Scalar_max_Function     = 74;
const int floatArray::Scalar_Not              = 75;
const int floatArray::Scalar_LT               = 76;
const int floatArray::Scalar_GT               = 77;
const int floatArray::Scalar_LTEQ             = 78;
const int floatArray::Scalar_GTEQ             = 79;
const int floatArray::Scalar_EQ               = 80;
const int floatArray::Scalar_NOT_EQ           = 81;
const int floatArray::Scalar_AND              = 82;
const int floatArray::Scalar_OR               = 83;

// These are considered to terminate a Statement!
const int floatArray::Assignment        = 84;
const int floatArray::replace_Function  = 85;
const int floatArray::Plus_Equals       = 86;
const int floatArray::Minus_Equals      = 87;
const int floatArray::Times_Equals      = 88;
const int floatArray::Divided_By_Equals = 89;
const int floatArray::Modulo_Equals     = 90;
const int floatArray::sum_Function      = 91;
const int floatArray::Scalar_Assignment        = 92;
const int floatArray::Scalar_replace_Function  = 93;
const int floatArray::Scalar_Plus_Equals       = 94;
const int floatArray::Scalar_Minus_Equals      = 95;
const int floatArray::Scalar_Times_Equals      = 96;
const int floatArray::Scalar_Divided_By_Equals = 97;
const int floatArray::Scalar_Modulo_Equals     = 98;
const int floatArray::Scalar_sum_Function      = 99;

const int floatArray::indexMap_Function = 100;
const int floatArray::view_Function     = 101;
const int floatArray::display_Function  = 102;

// Bitwise operators
const int floatArray::BitwiseComplement       = 103;
const int floatArray::BitwiseAND              = 104;
const int floatArray::BitwiseOR               = 105;
const int floatArray::BitwiseXOR              = 106;
const int floatArray::BitwiseLShift           = 107;
const int floatArray::BitwiseRShift           = 108;
const int floatArray::Scalar_BitwiseAND        = 109;
const int floatArray::Scalar_BitwiseOR         = 110;
const int floatArray::Scalar_BitwiseXOR        = 111;
const int floatArray::Scalar_BitwiseLShift     = 112;
const int floatArray::Scalar_BitwiseRShift     = 113;
const int floatArray::BitwiseAND_Equals       = 114;
const int floatArray::BitwiseOR_Equals        = 115;
const int floatArray::BitwiseXOR_Equals       = 116;
const int floatArray::Scalar_BitwiseAND_Equals = 117;
const int floatArray::Scalar_BitwiseOR_Equals  = 118;
const int floatArray::Scalar_BitwiseXOR_Equals = 119;

// Conversion operators
const int floatArray::convertTo_intArrayFunction    = 120;
const int floatArray::convertTo_floatArrayFunction  = 121;
const int floatArray::convertTo_doubleArrayFunction = 122;

// *********************************************************
// *********************************************************
// ****  BASEARRAY CLASS constructor and destructor  *****
// *********************************************************
// *********************************************************

#if defined(DOUBLEARRAY)

#if 1
BaseArray::BaseArray()
   {
  // Constructor
   };
#endif

#if 0
BaseArray::~BaseArray()
   {
  // Destructor
   };
#endif

// if DOUBLEARRAY
#endif

// *********************************************************
// *********************************************************
// ********  NEW OPERATOR INITIALIZEATION SUPPORT  *********
// *********************************************************
// *********************************************************

void
floatArray::freeMemoryInUse() 
   {
  // *********************************************************
  // This function is useful in conjuction with the Purify (from Pure Software Inc.)
  // it frees memory allocated for use internally in A++ floatArray objects.
  // This memory is used internally and is reported as "in use" by Purify
  // if it is not freed up using this function.  This function works with 
  // similar functions for each A++ object to free up all of the A++ memory in 
  // use internally.
  // *********************************************************

#if defined(USE_TAU)
     TAU_PROFILE("floatArray::freeMemoryInUse()", "void(void)", TAU_APP_MEMORY_POOL_MANAGEMENT);
#endif

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        printf ("Inside of floatArray::freeMemoryInUse() \n");
#endif 

#if 1
  // used in abstract_op.C to hold last temporary in cases where it must 
  // have a lifetime beyond the current statement.
#if !defined(PPP)
  // freeup space from last temporary!
     if (Last_Lhs_floatArray_Operand != NULL)
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("Delete Last_Lhs_floatArray_Operand  Last_Lhs_floatArray_Operand = %p \n",Last_Lhs_floatArray_Operand);
#endif 
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          Last_Lhs_floatArray_Operand->decrementReferenceCount();
          if (Last_Lhs_floatArray_Operand->getReferenceCount() < getReferenceCountBase())
               delete Last_Lhs_floatArray_Operand;
          Last_Lhs_floatArray_Operand = NULL;
        }
       else
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("No Last_Lhs_floatArray_Operand to delete! \n");
#endif 
        }
#endif

     int i;
     for (i=0; i < Max_Number_Of_Memory_Blocks-1; i++)
        {
          if (Memory_Block_List [i] != NULL)
             {
#if 1
               free ((char*) (Memory_Block_List[i]));
#else
               delete ((char*) (Memory_Block_List[i]));
#endif
             }
        }
#else
     printf ("floatArray::freeMemoryInUse() Commented Out! \n");
#endif
   }

// *********************************************************
// *********************************************************
// ***********  INITIALIZATION FOR CONSTRUCTORS  ***********
// *********************************************************
// *********************************************************

// inline void
// floatArray::preInitialize_Array ( int Number_Of_Valid_Dimensions ,
//                                  const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                                  bool Force_Memory_Allocation )
inline void
floatArray::preInitializeArray ()
   {
// *************************************************************************
// This function is used internally in the Initialize_Array_Functions below
// *************************************************************************

#if defined(APP) || ( defined(SERIAL_APP) && !defined(PPP) )
  // For P++ we only track the serial array objects not the serial array objects
     if (Diagnostic_Manager::getTrackArrayData() == TRUE)
        {
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
#ifdef DOUBLEARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_DOUBLE_ELEMENT_TYPE);
#endif
#ifdef FLOATARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_FLOAT_ELEMENT_TYPE);
#endif
#ifdef INTARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_INT_ELEMENT_TYPE);
#endif
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
        }
#endif

#if defined(PPP)
     Array_Descriptor.SerialArray = NULL;
#else
     Array_Descriptor.Array_Data  = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

  // There are no auxilary references at this point
     referenceCount = getReferenceCountBase();

  // printf ("Allocation should be done in the Array_Descriptor object! \n");

  // If Force_Memory_Allocation == TRUE then the constructor has to allocate
  // space even if DEFER_EXPRESSION_EVALUATION == TRUE
  // This function allocates the data for the serial and distributed parallel
  // arrays.  I the case of P++ is allocates only this processors part of the
  // data (info obtained from block parti array descriptor).
     Allocate_Array_Data (TRUE);

#if 1
#if defined(PPP)
  // Error checking!
     if ( Communication_Manager::Number_Of_Processors == 1 )
        {
          for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
               if ( getLength(i) != Array_Descriptor.SerialArray->getLength(i) )
                  {
                 // printf ("Offset_For_Ghost_Boundary_Width = %d \n",Offset_For_Ghost_Boundary_Width);
                    printf ("getLength(%d) = %d  != Array_Descriptor.SerialArray->getLength(i) = %d \n",
                         i,getLength(i),Array_Descriptor.SerialArray->getLength(i));
                    printf ("getInternalGhostCellWidth(%d) = %d \n",i,getInternalGhostCellWidth(i));
                    view("In Initialization");
                    APP_ABORT();
                  }
             }
        }
#endif
#endif

#if !defined(PPP)
     POINTER_LIST_INITIALIZATION_MACRO;
#endif

     if (PREINITIALIZE_OBJECT_IN_CONSTRUCTOR)
        {
#if COMPILE_DEBUG_STATEMENTS
       // printf ("NOTE: PREINITIALIZING THE ARRAY AS PART OF INITIALIZATION (PREINITIALIZE_VALUE = %f) \n",(float)PREINITIALIZE_VALUE);
#endif
          operator=(PREINITIALIZE_VALUE);
        }

     Array_Storage = NULL;
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
       // STARTING LIST FOR LIFETIME EXTENSION
          new floatArray_Operand_Storage ( *this );
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from floatArray::preInitializeArray");
#endif
   }

// inline void
// floatArray::Initialize_Array ( int Number_Of_Valid_Dimensions , 
//                               const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                               bool Force_Memory_Allocation )
inline void
floatArray::initializeArray ()
   {
// *************************************************************************
// This function is used internally in the constructors below
// *************************************************************************

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of floatArray::initializeArray() (this = %p)\n",this);
        }
#endif

  // Call a common function to both initializeArray functions
     preInitializeArray ();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
     Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from floatArray::initializeArray");
#endif
   }

#if defined(APP) || defined(PPP)
// *************************************************************************
// This function is used internally in the constructors below (for P++ 
// this allows the specification of an existing parallel partitioning object)
// *************************************************************************
// inline void
// floatArray::Initialize_Array ( int Number_Of_Valid_Dimensions , 
//                               const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                               const Partitioning_Type & Partition , 
//                               bool Force_Memory_Allocation )
inline void
floatArray::initializeArray ( const Internal_Partitioning_Type & Partition )
   {
  // Note that since we have moved the Array_Descriptor to be an object in the array object instead
  // of pointed to from the array object there is less fr this function to do and so the
  // Number_Of_Valid_Dimensions and the Array_Size input variables are no longer used
  // (except for printing debugging information).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of floatArray::initializeArray(Internal_Partitioning_Type&) (this = %p)\n",this);
       // printf (" (this = %p) \n",this);
        }
#endif

     if (&Partition);

#if 0
// (11/19/2000) The partitioning object should already be initialized
#if defined(PPP)
  // Initialize to use the input partitioning object
     Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = &((Internal_Partitioning_Type&)Partition);

  // Bugfix (11/12/2000) It seems that incrementing the reference count was forgotten here!
     Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->incrementReferenceCount();
#endif
#endif

  // Call a common function to both Initialize_Array functions
     preInitializeArray ();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL);
     Internal_Partitioning_Type::AddArrayToPartitioning(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from floatArray::initializeArray(Internal_Partitioning_Type&)");
#endif
   }

inline void
floatArray::initializeArray ( const Partitioning_Type & Partition )
   {
  // Note that since we have moved the Array_Descriptor to be an object in the array object instead
  // of pointed to from the array object there is less fr this function to do and so the
  // Number_Of_Valid_Dimensions and the Array_Size input variables are no longer used
  // (except for printing debugging information).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of floatArray::initializeArray (Partitioning_Type&) ");
       // printf (" (this = %p) \n",this);
        }
#endif

  // Call the version taking the Internal_Partitioning_Type
     initializeArray (*(Partition.getInternalPartitioningObject()));
   }
#endif


// *********************************************************
// *********************************************************
// ********************  CONSTRUCTORS  *********************
// *********************************************************
// *********************************************************

// ***************************************************************
// This constructor is used by the Defered Evaluation code to build
// A++ objects from a pointer to data and a descriptor.
// ***************************************************************
#if 0
// This function is commented out since we are testing 
// the current compilation of P++
// This function is called in lazy_operand.C!
// I don't think it is implemented correctly and I don't want to support it.

#if defined(PPP)
floatArray::floatArray( const floatSerialArray* SerialArray_Pointer , 
   floatArray_Descriptor_Type* 
   Array_Descriptor_Pointer, Operand_Storage* Array_Storage_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
// This may not be the right Array_Descriptor constructor to use???
// : Array_Descriptor(SerialArray_Pointer,Array_Descriptor_Pointer,Array_Storage_Pointer)
   : Array_Descriptor()
#endif
#else
floatArray::floatArray( const float* Array_Data_Pointer , 
   floatArray_Descriptor_Type* 
   Array_Descriptor_Pointer , Operand_Storage* Array_Storage_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
// This may not be the right Array_Descriptor constructor to use???
// : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer,Array_Storage_Pointer)
   : Array_Descriptor()
#endif
#endif
   {
#if defined(USE_TAU)
     TAU_PROFILE("floatArray::floatArray()", "void(float*,floatArray_Descriptor_Type*)", TAU_APP_CONSTRUCTORS);
#endif
  // This function is not used except in the lazy evaluation (one of them files)!

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
#if defined(PPP)
          printf ("Using the constructor 'floatArray (floatSerialArray*,Array_Descriptor_Type*,Operand_Storage*)'! \n");
       // printf ("Using the constructor 'floatArray (floatSerialArray*,Array_Domain_Type*,Operand_Storage*)'! \n");
#else
          printf ("Using the constructor 'floatArray (float*,Array_Descriptor_Type*,Operand_Storage*)'! \n");
       // printf ("Using the constructor 'floatArray (float*,Array_Domain_Type*,Operand_Storage*)'! \n");
#endif
        }
#endif

  // **********************************************************************************************
     printf ("I think this function is not used except in lazy evaluation \n");
     printf ("    It uses an older construction mechanism that uses the operator= \n");
     printf ("    Untill this is corrected I think this function should be disabled! \n");
     printf ("Exiting in floatArray (floatSerialArray*,Array_Descriptor_Type*,Operand_Storage*) \n");
     APP_ABORT();
  // **********************************************************************************************

  // This forces a copy of the descriptor data into the descriptor member in the array
  // at some point this will be an important issue to optimize since we want to avoid
  // building a descriptor to initialize the array's descriptor only to then
  // throw away the first descriptor.  So this is an efficency issue.
     Array_Descriptor = *Array_Descriptor_Pointer;
#if defined(PPP)
     Array_Descriptor.SerialArray      = (floatSerialArray*) SerialArray_Pointer;
#else
     Array_Descriptor.Array_Data       = (float*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
#endif
     Array_Storage    = Array_Storage_Pointer;
     referenceCount   = getReferenceCountBase();
   }
// commented out!
#endif

// *******************************************************************************
// This is the default constructor it builds a NULL array (an array with no data).
// *******************************************************************************
floatArray::floatArray() 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor()
#endif
   {
  // Note that a nullArray does not have a partitioning object since it's partitioning will 
  // defined only at the point where it has data (i.e. not yet)

  // Possible improvement to this implementation:
  //    1: Call the initializeArray function!

#if defined(USE_TAU)
     TAU_PROFILE("floatArray::floatArray()", "void(void)", TAU_APP_CONSTRUCTORS);
#endif

  // The default constructor for the Array_Descriptor sets up a NULL Array
  // (meaning an array with no data) so we have Array_Data = NULL.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Call floatArray::floatArray() DEFAULT Constructor (this = %p) \n",this);
#endif

     Array_Storage    = NULL;
     referenceCount   = getReferenceCountBase();

#if defined(PPP)
  // Should this be NULL or a pointer to a NULL floatSerialArray
  // Bugfix (12/14/94) a NULL P++ array contains a pointer to a NULL A++ array
  // It would be more efficient if it could be a NULL pointer but it would
  // make the implementation more complex so we force a P++ NULL array to 
  // have an A++ NULL array (since then we have to check the pointer for NULL
  // and we can't assert that the ponter is always non-NULL).
     Array_Descriptor.SerialArray = new floatSerialArray();
#else
     Array_Descriptor.Array_Data = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

     Array_Storage    = NULL;
     referenceCount   = getReferenceCountBase();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
  // Internal_Partitioning_Type::DefaultfloatArrayList.addElement(*this);
     Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

  // printf ("At BASE of default constructor floatArray::floatArray() Array_ID() = %d  getRawDataReferenceCount() = %d \n",Array_ID(),getRawDataReferenceCount());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from default constructor floatArray::floatArray()");
#endif
   }

// ***************************************************************
// This function allows the construction of an A++ array object 
// using an existing meory pointer.
// ***************************************************************
#if defined(PPP)
// floatArray::floatArray ( float* Data_Pointer , int i , const Range & Range_I , 
//                                           int j , const Range & Range_J ,
//                                           int k , const Range & Range_K ,
//                                           int l , const Range & Range_L )
floatArray::floatArray ( const float* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE)
#endif
   {
  // To use existing data in the parallel environment we have to specify the global size
  // and the base/bound (using the Range object).  The base of the global array is set to 
  // ZERO.  It can be reset after construction if required.

#if defined(USE_TAU)
     TAU_PROFILE("floatArray::floatArray()", "void(float*,int,int,int,int,int,int)", TAU_APP_CONSTRUCTORS);
#endif
  // This constructor uses existing data and builds a P++ array that encloses it
  // Range objects are used to specify the local processor's partition of the data

     INTEGER_AND_RANGE_ARGUMENTS_TO_INTEGER_AND_CONST_REF_RANGE_LIST_MACRO

     printf ("Sorry, not implemented: floatArray::floatArray ( const float* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE ) \n");
     printf ("     We can't yet support arbitrary distributions such as has been specified ... \n");
     APP_ABORT();

  // Initialize the pointers befor calling adopt
  // Array_Descriptor = NULL;
     Array_Descriptor.SerialArray      = NULL;
     referenceCount   = getReferenceCountBase();

  // Build default partition for use within adopt.  This is not likely the
  // correct partition to use here so this should be passed in as an option when the
  // parallel adopt function is implemented.
     Partitioning_Type Partition;
  // It is simple to just call the adopt function!
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase());
     adopt ( Data_Pointer , Partition, Integer_List , Internal_Index_List );
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

     APP_ASSERT (Array_Descriptor.Array_Domain.builtUsingExistingData == TRUE);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor floatArray::floatArray(float*,ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE)");
#endif
   }

// end of if defined(PPP)
#else
// else for if not defined(PPP)

// floatArray::floatArray ( float* Data_Pointer , int i , int j , int k , int l )
floatArray::floatArray ( const float* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_INTEGER)
#endif
   {
#if defined(USE_TAU)
     TAU_PROFILE("floatArray::floatArray()", "void(float*,int,int,int,int,int,int)", TAU_APP_CONSTRUCTORS);
#endif

  // Should we call the more general initialization 
  // (it would allocate data -- so I guess not!)
     referenceCount   = getReferenceCountBase();
     Array_Storage    = NULL;
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor floatArray::floatArray(float*,ARGUMENT_LIST_MACRO_INTEGER)");
#endif
   }
#endif

// *****************************************************************
// Constructor using existing memory and Range objects
// *****************************************************************
#if !defined(PPP)
floatArray::floatArray ( const float* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_CONST_REF_RANGE)
#endif
   {
  // Should we call the more general initialization 
  // (though it would allocate data so I guess not)
     referenceCount   = getReferenceCountBase();
     Array_Storage    = NULL;
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

  // printf ("Exiting in floatArray::floatArray ( const float* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE ) \n");
  // APP_ABORT();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor floatArray::floatArray(float*,ARGUMENT_LIST_MACRO_CONST_REF_RANGE)");
#endif
   }
#endif

// ************************************************************
// Copy constructor should not be used often since it really 
// makes a deep copy (as a good copy constructor should)!
// ************************************************************
floatArray::floatArray( const floatArray & X , int Type_Of_Copy ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(X.Array_Descriptor,Type_Of_Copy)
#endif
   {
  // If the user passes parameters by value (instead of by reference) then we 
  // are forced to abide by his/her wishes and do the required copying.  It is most
  // likely however that he/she wants to pass by reference for better efficiency.
  // There is nothing that the array class should do to provide what we might think
  // the user wants since passing by value provides a level of protection against 
  // function side effects that the user might have specifically choosen.

  // There are different types of copies:
  //    Shallow Copy
  //        Don't really copy anything (just make a new reference to the existing data)
  //        This is NOT the default!
  //        Supported value: SHALLOWCOPY
  //    Deep Copy
  //        Deep Collapsed Copy
  //             Current functionality of the Deep Copy option.
  //             This IS the default!
  //             Supported value: DEEPCOPY or DEEPCOLAPSEDCOPY
  //        Deep Aligned Copy
  //             Build copy to be same size as original array (might be inefficient)
  //             Supported value: DEEPALIGNEDCOPY
  //        Deep Collapsed and Aligned Copy
  //             This requires additional support from PADRE (table based distributions)
  //             Supported value: DEEPCOLAPSEDALIGNEDCOPY

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("*********************************************** \n");
          printf ("*********************************************** \n");
          printf ("Using the copy constructor floatArray(const floatArray & X) (X.Array_ID() = %d) \n",X.Array_ID());
          printf ("*********************************************** \n");
          printf ("*********************************************** \n");
        }
     X.Test_Consistency ("X called from COPY constructor floatArray::floatArray(floatArray)");
#endif

#if !defined(PPP)
  // This does not make sense for P++ (I think)???
  // Since this is a new array object it should have an initialize referenced count on its
  // raw data.  This is required here because the reference counting mechanism reused the
  // value of zero for an existing reference and no references (this will be fixed soon).
  // (5/1/2000) The reference count base is now 1 so it is fixed now -- I suspect this is no longer required!
     resetRawDataReferenceCount();
#endif

#if defined(PPP)
     Array_Descriptor.SerialArray = NULL;
#else
  // Since we will allocate new data we need to initialize this to NULL
  // prior to calling the Allocate_Array_Data member function
     Array_Descriptor.Array_Data  = NULL;
  // ... bug fix (10/9/96,kdb) this was fixed a while ago but got lost.  The
  // descriptor pointer needs to be initialized as well as the data pointer ...
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif
     Array_Storage  = NULL;
     referenceCount = getReferenceCountBase();

#if 0
  // error checking
     if ( (Type_Of_Copy != DEEPCOPY) && (Type_Of_Copy != SHALLOWCOPY) )
        {
          printf ("ERROR: Type_Of_Copy neither DEEPCOPY nor SHALLOWCOPY \n");
          APP_ABORT();
        }
#endif

#if 0
  // Example source code (from Brian) showing how to build the ALIGNED_COPY mechanism
     cout<<" J.getRawBase(0)= "<<J.getRawBase(0)<<"  J.getRawBound(0)= "<<J.getRawBound(0)<<"  J.getRawStride(0)= "<<J.getRawStride(0)<<endl;
     J.getFullRange(0).display("J.getFullRange(0)");
     intArray TT(Range(J.getFullRange(0).getBase(),J.getFullRange(0).getBound()));
     J.dimension(0).display("J.dimension(0)");  
     intArray T = TT(Range(J.getRawBase(0),J.getRawBound(0),J.getRawStride(0)));
#endif

  // Code in progress to redo how we handle different cases of Type_Of_Copy and include additional cases
     bool Force_Memory_Allocation = TRUE;
     int Old_Array_Id                = Array_Descriptor.Array_ID();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
  // This must be called before the Allocate_Array_Data function
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
        {
          Internal_Partitioning_Type::AddArrayToPartitioning(*this);
        }
       else
        {
          Internal_Partitioning_Type::AddArrayToPartitioning (*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
        }
#endif

  // The copy constructor supports several different types of copy semantics
     switch (Type_Of_Copy)
        {
          case SHALLOWCOPY:
            // This is the simplist case of the copy constructor (but not often very useful)
               reference (X);
               break;

          case DEEPCOLAPSEDCOPY:
          case DEEPCOPY:
            // printf ("In Array copy constructor - the Array_Descriptor should allocate the data! \n");

            // The copy constructor has to allocate space even if 
            // DEFER_EXPRESSION_EVALUATION == TRUE
               setTemporary(FALSE);

            // (19/2/98) This is a fix to skip the allocation of data and force it to be
            // allocated by the operator= only if required.  The result is more efficient code.
            // If the input is a temporary then this code could be written more efficiently!
            // printf ("Inefficent Operation: COPY constructor is forced to allocate data even if input is a temporary! \n");
               Allocate_Array_Data ( Force_Memory_Allocation );

               APP_ASSERT (isTemporary() == FALSE);

            // Error checking (make sure not a view)
            // Since we just made a copy this object is NOT a view! 
               if (Array_Descriptor.usesIndirectAddressing())
                  {
                 // printf ("WARNING: copy constructor built a view using intArrays (correcting)! \n");
                 // Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                 // for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                 //      Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 0)
                       {
                         printf ("WARNING: copy constructor built a view using intArrays (correcting by deleting indirection intArrays)! \n");
                       }
#endif
                    Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                    for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                       {
                      // (5/1/2000) valid pointers were previously just set to NULL.
                      // This caused a bug when the reference count of the indirection 
                      // intArray was not decremented properly and the delete operator
                      // called when there are no more references.
                         if (Array_Descriptor.Array_Domain.Index_Array[i] != NULL)
                            {
                              Array_Descriptor.Array_Domain.Index_Array[i]->decrementReferenceCount();
                              if (Array_Descriptor.Array_Domain.Index_Array[i]->getReferenceCount() < intArray::getReferenceCountBase())
                                   delete Array_Descriptor.Array_Domain.Index_Array[i];
                              Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
                            }
                       }
                  }

#if !defined(PPP)
            // this can't be a view
               POINTER_LIST_INITIALIZATION_MACRO;
#endif

            // Call operator=
            // If the operator= can just steal the data and void a deep copy then it will
            // do so and then delete the memory allocated a few lines above!
            // printf ("Assignement commented out in floatArray::COPY CONSTRUCTOR! \n");
            // printf ("Assignement in floatArray::COPY CONSTRUCTOR! \n");
            // APP_DEBUG = 1;
               *this = X;
            // APP_DEBUG = 0;
               break;

          case DEEPALIGNEDCOPY:
            // intArray Copy (Range(X.getFullRange(0).getBase(),X.getFullRange(0).getBound()));
            // printf ("DEEPALIGNEDCOPY not supported yet! \n");
            // APP_ABORT();
            // printf ("In Array copy constructor - the Array_Descriptor should allocate the data! \n");

            // The copy constructor has to allocate space even if 
            // DEFER_EXPRESSION_EVALUATION == TRUE
               setTemporary(FALSE);

            // (19/2/98) This is a fix to skip the allocation of data and force it to be
            // allocated by the operator= only if required.  The result is more efficient code.
            // If the input is a temporary then this code could be written more efficiently!
            // printf ("Inefficent Operation: COPY constructor is forced to allocate data even if input is a temporary! \n");
               Allocate_Array_Data ( Force_Memory_Allocation );

               APP_ASSERT (isTemporary() == FALSE);

            // Error checking (make sure not a view)
            // Since we just made a copy this object is NOT a view! 
               if (Array_Descriptor.usesIndirectAddressing())
                  {
                 // printf ("WARNING: copy constructor built a view using intArrays (correcting)! \n");
                 // Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                 // for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                 //      Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 0)
                       {
                         printf ("WARNING: copy constructor built a view using intArrays (correcting be deleting indirection intArrays)! \n");
                       }
#endif
                    Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                    for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                       {
                      // (5/1/2000) valid pointers were previously just set to NULL.
                      // This caused a bug when the reference count of the indirection 
                      // intArray was not decremented properly and the delete operator
                      // called when there are no more references.
                         if (Array_Descriptor.Array_Domain.Index_Array[i] != NULL)
                            {
                              Array_Descriptor.Array_Domain.Index_Array[i]->decrementReferenceCount();
                              if (Array_Descriptor.Array_Domain.Index_Array[i]->getReferenceCount() < intArray::getReferenceCountBase())
                                   delete Array_Descriptor.Array_Domain.Index_Array[i];
                              Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
                            }
                       }
                  }

#if !defined(PPP)
            // this can't be a view
               POINTER_LIST_INITIALIZATION_MACRO;
#endif

            // Call operator=
            // If the operator= can just steal the data and void a deep copy then it will
            // do so and then delete the memory allocated a few lines above!
            // printf ("Assignement commented out in floatArray::COPY CONSTRUCTOR! \n");
            // APP_DEBUG = 1;

            // printf ("Now call the assignement operator in floatArray::COPY CONSTRUCTOR! \n");
#if 1
               *this = X;
#else
               printf ("#####  ASSIGNING TO A SCALAR VALUE!!!!!  ##### \n");
               *this = 1;
#endif

            // APP_DEBUG = 0;
               break;

          case DEEPCOLAPSEDALIGNEDCOPY:
               printf ("DEEPCOLAPSEDALIGNEDCOPY not supported yet! \n");
               APP_ABORT();
               break;

          default:
               printf ("ERROR: default reached in COPY Constructor Type_Of_Copy = %d not known \n",Type_Of_Copy);
               APP_ABORT();
               break;
        }

#if defined(PPP)
  // Now update the ghost boundaries with valid data for the neighboring processors
  // Not sure that this is required since the initialization of the local arrays 
  // should have updated the boundaries (at least is special cases).
     updateGhostBoundaries();
#endif

     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
          new floatArray_Operand_Storage ( *this );
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from COPY constructor floatArray::floatArray(floatArray)");
#endif
   }

#ifdef USE_STRING_SPECIFIC_CODE

#if defined(APP) || defined(SERIAL_APP)
// ************************************************************
// Copy constructor should not be used often since it really 
// makes a deep copy (as a good copy constructor should)!
// ************************************************************
// floatArray::floatArray( const char* dataString ) 
floatArray::floatArray( const AppString & dataString ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(dataString)
#else
   : Array_Descriptor(dataString)
#endif
   {
     initializeArray ();

#if 1
     char* numberString = strdup(dataString.getInternalString());

  // Now fill in the newly declared array
     char* delimiterList = " {},";
     char* nextSubString = NULL;
     int counter = 0;

     float* dataPointer = getDataPointer();

  // char* nextSubString = strtok(dataString,delimiterList);
  // parseString (nextSubString,numbersString);
     if ( (nextSubString = strtok(numberString,delimiterList)) != NULL )
        {
          printf ("counter = %d nextSubString = %s \n",counter,nextSubString);
#ifdef DOUBLEARRAY
          dataPointer[counter] = atof(nextSubString);
#endif
#ifdef FLOATARRAY
          dataPointer[counter] = atof(nextSubString);
#endif
#ifdef INTARRAY
          dataPointer[counter] = atoi(nextSubString);
#endif
          while ( (nextSubString = strtok(NULL,delimiterList)) != NULL )
             {
               counter++;
               dataPointer[counter] = atoi(nextSubString);
            // printf ("counter = %d nextSubString = %s \n",counter,nextSubString);
             }
        }
#else
     printf ("floatArray ( const AppString & dataString ) not compiled unless USE_STRING_SPECIFIC_CODE used in compiling A++/P++! \n");
     APP_ABORT();
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor floatArray::floatArray(char*)");
#endif
   }

// if defined(APP) || defined(SERIAL_APP)
#endif

// if USE_STRING_SPECIFIC_CODE 
#endif

// *************************************************************************
/* This function is too large for inlining using the AT&T compiler!
   But we might be able to inline the Array_Descriptor_Type at some point
   and that might be worth while since this function is called a lot in A++ */
// *************************************************************************
floatArray::floatArray ( int i ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }

#if (MAX_ARRAY_DIMENSION >= 2)
floatArray::floatArray ( int i , int j ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 3)
floatArray::floatArray ( int i , int j , int k ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 4)
floatArray::floatArray ( int i , int j , int k , int l ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 5)
floatArray::floatArray ( int i , int j , int k , int l , int m )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 6)
floatArray::floatArray ( int i , int j , int k , int l , int m , int n ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 7)
floatArray::floatArray ( int i , int j , int k , int l , int m , int n , int o ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 8)
floatArray::floatArray ( int i , int j , int k , int l , int m , int n , int o , int p ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,p+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
floatArray::floatArray( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor (MAX_ARRAY_DIMENSION,Integer_List)
#endif
   {
     initializeArray();
   }

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
// floatArray::floatArray( int Array_Size_I , int Array_Size_J , int Array_Size_K ,
//                       int Array_Size_L , bool Force_Memory_Allocation )
floatArray::floatArray( ARGUMENT_LIST_MACRO_INTEGER , bool Force_Memory_Allocation ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor (VARIABLE_LIST_MACRO_INTEGER)
#endif
   {
  // ZERO is an acceptable value for the Array size!

  // Avoid compiler warning for unused input variable
     if (&Force_Memory_Allocation);

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Using the constructor floatArray::floatArray (ARGUMENT_LIST_MACRO_INTEGER, bool) ");
          for (int index_var=0; index_var < MAX_ARRAY_DIMENSION; index_var++)
               printf ("int=%d,",Integer_List[index_var]);
          printf (" (this = %p) \n",this);
          printf ("\n");
        }
#endif

     initializeArray();
   }

#if defined(APP) || defined(PPP)
// *************************************************************************
/* This function is too large for inlining using the AT&T compiler!
   But we might be able to inline the Array_Descriptor_Type at some point
   and that might be worth while since this function is called a lot in A++ */
// *************************************************************************
floatArray::floatArray ( int i , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }

#if (MAX_ARRAY_DIMENSION >= 2)
floatArray::floatArray ( int i , int j , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 3)
floatArray::floatArray ( int i , int j , int k , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 4)
floatArray::floatArray ( int i , int j , int k , int l , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 5)
floatArray::floatArray ( int i , int j , int k , int l , int m , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 6)
floatArray::floatArray ( int i , int j , int k , int l , int m , int n , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 7)
floatArray::floatArray ( int i , int j , int k , int l , int m , int n , int o , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 8)
floatArray::floatArray ( int i , int j , int k , int l , int m , int n , int o , int p , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,p+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
// floatArray::floatArray( int Array_Size_I , int Array_Size_J , int Array_Size_K ,
//                       int Array_Size_L , const Partitioning_Type & Partition , bool Force_Memory_Allocation )
floatArray::floatArray( ARGUMENT_LIST_MACRO_INTEGER ,
                      const Partitioning_Type & Partition ,
                      bool Force_Memory_Allocation )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
// : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
//                    *Partition.getInternalPartitioningObject())
   : Array_Descriptor(COMPUTE_RANGE_ARGUMENTS_MACRO,
                      *Partition.getInternalPartitioningObject())
#endif
   {
  // Avoid compiler generated warning about unused input variable
     if (&Force_Memory_Allocation);

  // ZERO is an acceptable value for the Array size!
     initializeArray(Partition);
   }
#endif

floatArray::floatArray( ARGUMENT_LIST_MACRO_CONST_REF_RANGE ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(VARIABLE_LIST_MACRO_CONST_REF_RANGE)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of constructor floatArray::floatArray( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )! \n");
#endif

     initializeArray();
   }

floatArray::floatArray( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Internal_Index_List)
#endif
   {
     initializeArray();
   }

#if defined(PPP) || defined (APP)
floatArray::floatArray( 
   const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List, 
   const Internal_Partitioning_Type & partition )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Internal_Index_List,partition)
#endif
   {
     initializeArray(partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 2)
// *************************************************************
// We need this constructor to avoid confusion with the copy 
// constructor (ambiguous call problem due to promotion of Range
// to A++ array object).
// *************************************************************
//floatArray::floatArray ( const Range & Range_I , int j ) 
//   : Array_Descriptor(Range_I,Range(APP_Global_Array_Base,j))
floatArray::floatArray ( const Range & Range_I , int j ) 
   : Array_Descriptor(Range_I,Range(APP_Global_Array_Base,j-1))
#if defined(USE_EXPRESSION_TEMPLATES)
   , InArray<float>(this)
#endif
   {
     initializeArray();
   }
#endif

#if !defined(PPP)
//============================================================================
//============  Constructor used in operator()(Internal_Index)  ==============
//============================================================================
floatArray::floatArray( const float* Array_Data_Pointer,
                      const Array_Domain_Type & X,
                      const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this,X,Index_List)
#else
// : Array_Descriptor(Array_Data_Pointer,X,Index_List)
   : Array_Descriptor(X,Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
     Array_Descriptor.Array_Data   = (float*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor floatArray (float*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

     if (Array_ID() != X.Array_ID())
        {
          view("this: In floatArray::floatArray(float*,const Array_Domain_Type & X,const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List)");
          X.display("X: In floatArray::floatArray(float*,const Array_Domain_Type & X,const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List)");
        }
     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (float*,Array_Descriptor_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }

//============================================================================
floatArray::floatArray( const float* Array_Data_Pointer,
                      const Array_Domain_Type & X,
                      const Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Indirect_Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this,X,Indirect_Index_List)
#else
   : Array_Descriptor(X,Indirect_Index_List)
// : Array_Descriptor(Array_Data_Pointer,X,Indirect_Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
     Array_Descriptor.Array_Data   = (float*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor floatArray (float*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (float*,Array_Descriptor_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
 // end of not PPP
#endif

//============================================================================
#if defined(PPP)
floatArray::floatArray( const floatSerialArray* SerialArray_Pointer,
                      const Array_Domain_Type & X,
                      const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this,X,Index_List)
#else
   : Array_Descriptor(X,Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif

     Array_Descriptor.SerialArray = (floatSerialArray*) SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

#if COMPILE_DEBUG_STATEMENTS
     if (SerialArray_Pointer != NULL)
        {
       // APP_ASSERT(SerialArray_Pointer->getDataPointer() != NULL);

          if (APP_DEBUG > 5)
               view("Using the constructor floatArray (floatSerialArray*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }
#endif

     APP_ASSERT(Array_ID() == X.Array_ID());
     
  // ... add this fix from other constructor (2/14/96, kdb) ...
  // ... The local part of an indexed view might be a Null Array on some 
  // processors.  On those processors all the Local_Mask_Index objects must 
  // be Null_Index objects. ...
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);
     if (Array_Descriptor.SerialArray->isNullArray() == TRUE)
        {
#if 0
          for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
               Array_Descriptor.Array_Domain.Local_Mask_Index [i] = Internal_Index (0,0,1,Null_Index);
#else
          Array_Descriptor.Array_Domain.resetDomainForNullArray();
#endif

       // (12/13/2000) Added test
          APP_ASSERT (getLeftNumberOfPoints(0) == 0);
          APP_ASSERT (getRightNumberOfPoints(0) == 0);
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (floatSerialArray*,Array_Descriptor_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }

//============================================================================
floatArray::floatArray( const floatSerialArray* SerialArray_Pointer, 
                      const Array_Domain_Type & X,  
                      const Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type 
		      Indirect_Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this,X,Indirect_Index_List) 
#else
   : Array_Descriptor(X,Indirect_Index_List)
// : Array_Descriptor(SerialArray_Pointer,X,Indirect_Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (floatSerialArray*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
  // Array_Descriptor.Array_Data   = 
  //	(float*) SerialArray_Pointer.Array_Descriptor.Array_Data;
     Array_Descriptor.SerialArray = (floatSerialArray*)SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

  // New test (12/13/2000)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     if (SerialArray_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor floatArray (floatSerialArray*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // New test (12/13/2000) if this is false then consider calling "getDomain().resetDomainForNullArray();"
          APP_ASSERT (Array_Descriptor.SerialArray->isNullArray() == FALSE);
        }

     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (floatSerialArray*,Array_Descriptor_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
//============================================================================
floatArray::floatArray( const floatSerialArray* SerialArray_Pointer,
                      const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this,Integer_List)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Integer_List)
// : Array_Descriptor(SerialArray_Pointer,MAX_ARRAY_DIMENSION,Integer_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
     Array_Descriptor.SerialArray = (floatSerialArray*)SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

  // New test (12/13/2000)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     if (SerialArray_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor floatArray (floatSerialArray*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // New test (12/13/2000) if this is false then consider calling "getDomain().resetDomainForNullArray();"
          APP_ASSERT (Array_Descriptor.SerialArray->isNullArray() == FALSE);
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (floatSerialArray*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
  // end of PPP only section
#endif

//============================================================================

#if !defined(PPP)
// ... this looks like it should only work if not PPP ...
// Support for the following ...
// Temporary_Array = new floatArray ( Null_Array , 
//                                   &(Lhs.Array_Descriptor.Array_Domain), 
//                                   AvoidBuildingIndirectAddressingView);

floatArray::floatArray( const float* Array_Data_Pointer , const Array_Domain_Type* Array_Domain_Pointer, bool AvoidBuildingIndirectAddressingView ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView) 
#else
   : Array_Descriptor(*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
// : Array_Descriptor(Array_Data_Pointer,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Domain_Type*)'! \n");
#endif
     Array_Descriptor.Array_Data   = (float*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;

#if !defined(PPP)
  // Since this is a new array object is should have an initialize reference count on its
  // raw data.  This is required here because the reference counting mechanism reused the 
  // value of zero for one existing reference and no references (this will be fixed soon).
     resetRawDataReferenceCount();
#endif
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor floatArray (float*,Array_Domain_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // If we have valid data then it should have a reference count showing that
       // there is an external reference.
          incrementRawDataReferenceCount();
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (float*,Array_Descriptor_Type*,bool)");
#endif
   }
#endif // end of not PPP

//============================================================================

#if defined(PPP)
// Support for the following ...
// Temporary_Array = new floatArray ( Null_Array , 
//                                   &(Lhs.Array_Descriptor.Array_Domain), 
//                                   AvoidBuildingIndirectAddressingView);

floatArray::floatArray(
     floatSerialArray* SerialArray_Pointer , 
     const Array_Domain_Type* Array_Domain_Pointer, 
     bool AvoidBuildingIndirectAddressingView ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView) 
#else
   : Array_Descriptor(*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
// : Array_Descriptor(SerialArray_Pointer,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Domain_Type*)'! \n");
#endif
     Array_Descriptor.SerialArray   = (floatSerialArray*)SerialArray_Pointer;
     referenceCount                 = getReferenceCountBase();
     Array_Storage                  = NULL;

     if (SerialArray_Pointer != NULL)
        {
          APP_ASSERT (SerialArray_Pointer != NULL);
#if 1
       // We need to adjust the base of the local array for account for the base of the 
       // parallel array object.  This makes more sense than the other way around.
          int i = 0;
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
            // set the bases of the SerialArray to match that of the ParallelArray
            // built using the input Array_Domain_Pointer
            // APP_ASSERT (Array_Descriptor.Array_Domain.Global_Index[i].getMode()     != Null_Index); 
            // APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != Null_Index); 
               int Global_Difference = 0;
               int Local_Difference  = 0;

               if (Array_Descriptor.Array_Domain.Global_Index[i].getMode() != Null_Index) 
                    Global_Difference = 
                         Array_Descriptor.Array_Domain.Global_Index[i].getBase() -
                         Array_Descriptor.Array_Domain.getRawBase(i);

               if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != Null_Index) 
                    Local_Difference = 
                         Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() -
                         SerialArray_Pointer->Array_Descriptor.Array_Domain.getRawBase(i);
#if 0
               printf ("SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",
                    i,SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i]);
               printf ("Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",
                    i,Array_Descriptor.Array_Domain.Data_Base[i]);
               printf ("Array_Domain_Pointer->Data_Base[%d] = %d \n",
                    i,Array_Domain_Pointer->Data_Base[i]);
               printf ("Array_Domain_Pointer->getBase(%d) = %d \n",
                    i,Array_Domain_Pointer->getBase(i));
               printf ("SerialArray_Pointer->getBase(%d) = %d \n",
                    i,SerialArray_Pointer->getBase(i));
            // int newBase = Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase();
            // printf ("newBase = %d \n",newBase);
            // ((floatSerialArray*)SerialArray_Pointer)->setBase(newBase,i);
            // SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] = newBase;;
               printf ("Global_Difference = %d \n",Global_Difference);
               printf ("Local_Difference  = %d \n",Local_Difference);
            // Array_Descriptor.Array_Domain.Data_Base[i] = 
            //      Array_Descriptor.Array_Domain.Global_Index[i].getBase();
            // SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] = 
            //      Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase();
#endif
               Array_Descriptor.Array_Domain.Data_Base[i] += Global_Difference;
               Array_Descriptor.Array_Domain.User_Base[i] += Global_Difference;
               SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] += Local_Difference;
               SerialArray_Pointer->Array_Descriptor.Array_Domain.User_Base[i] += Local_Difference;
             }
#endif

          SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

          if (APP_DEBUG > 5)
               view("Using the constructor floatArray (float*,Array_Domain_Type*)");

#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif

#if 0
       // Test (11/12/2000) Maybe this should be in the descriptor?
       // Added to reflect that temoraries will be deleted when used within serial array operations
       // and we want them to last until they are deleted by the parallel array object.
          if (SerialArray_Pointer->isTemporary() == TRUE)
             {
               SerialArray_Pointer->incrementReferenceCount();
               APP_ASSERT (SerialArray_Pointer->getReferenceCount() > 1);
             }
#endif
        }

  // We might need this!
  // resetRawDataReferenceCount();
  // incrementRawDataReferenceCount();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (float*,Array_Descriptor_Type*)");
#endif
   }
#endif  // end of PPP only


//============================================================================

#if !defined(PPP)
#if 0
// All of these are commented out!!!
floatArray::floatArray
   ( const float* Array_Data_Pointer , 
     const intArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (float*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor floatArray (float*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (float*,Array_Descriptor_Type*)");
#endif
   }

floatArray::floatArray
   ( const float* Array_Data_Pointer , 
     const floatArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (float*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor floatArray (float*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (float*,Array_Descriptor_Type*)");
#endif
   }

floatArray::floatArray
   ( const float* Array_Data_Pointer , 
     const doubleArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'floatArray (float*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (float*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor floatArray (float*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor floatArray::floatArray (float*,Array_Descriptor_Type*)");
#endif
   }
  // end of if 0
#endif
  // end of !PPP
#endif



// *********************************************************
// *********************************************************
// ******************  MEMBER FUNCTIONS  *******************
// *********************************************************
// *********************************************************

floatArray &
floatArray::seqAdd ( float Base , float Stride )
   {
// ***************************************************************
// This function allows the initialization of an array with 
// incremeted values.
// ***************************************************************

#if defined(USE_TAU)
     TAU_PROFILE("floatArray::seqAdd()", "void(float,float)", TAU_APP_USER_FUNCTIONS);
#endif
  // This function intializes the data to be sequentially valued starting
  // at the Base value and continuing with Stride to the end of the array.
  // It does not touch the array data directly since this is the job of the 
  // MDI functions (or the operator() which take scalars).  This function uses the
  // operator() member function to initialize the actual data since in the CM-5 
  // implementation the data is not directly addressable at the C++ level!

  // because this function is implemented using scalar indexing it is very slow
  // especially in the P++ parallel environment.

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from floatArray::seqAdd(Base,Stride)");
#endif

#if !defined(CRAY)
     float Counter = Base;

  // The use of multiple function call here is not very important 
  // since this is not often a time critical function and would be inlined!
#if 0
     APP_ASSERT (MAX_ARRAY_DIMENSION == 4);

     printf ("We really should use the dimension independent case!  Exiting ... \n");
     APP_ABORT();

     int Base_I = getBase(0);
     int Base_J = getBase(1);
     int Base_K = getBase(2);
     int Base_L = getBase(3);

     int Bound_I = getBound(0);
     int Bound_J = getBound(1);
     int Bound_K = getBound(2);
     int Bound_L = getBound(3);

     for (int l=Base_L; l <= Bound_L; l++)
        {
          for (int k=Base_K; k <= Bound_K; k++)
             {
               for (int j=Base_J; j <= Bound_J; j++)
                  {
                    for (int i=Base_I; i <= Bound_I; i++)
                       {
                         (*this)(i,j,k,l) = Counter;
                         Counter += Stride;
                       }
                  }
             }
        }
#else
     APP_ASSERT (MAX_ARRAY_DIMENSION <= 8);
  // Dimension independent code!
     int Array_Base[MAX_ARRAY_DIMENSION];
     int Array_Bound[MAX_ARRAY_DIMENSION];
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          Array_Base [temp] = getBase (temp);
          Array_Bound[temp] = getBound(temp);
        }

#if defined(PPP)
  // Get a view of the whole serial array including ghost boundaries so 
  // that they can be initialized properly without any communication.
     const floatSerialArray & localArray = getLocalArrayWithGhostBoundaries();

  // these are used to simplify code
     int localArrayBase0  = Array_Descriptor.Array_Domain.getLocalMaskIndex(0).getBase();
     int localArrayBound0 = Array_Descriptor.Array_Domain.getLocalMaskIndex(0).getBound();
#if MAX_ARRAY_DIMENSION > 1
     int localArrayBase1  = Array_Descriptor.Array_Domain.getLocalMaskIndex(1).getBase();
     int localArrayBound1 = Array_Descriptor.Array_Domain.getLocalMaskIndex(1).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 2
     int localArrayBase2  = Array_Descriptor.Array_Domain.getLocalMaskIndex(2).getBase();
     int localArrayBound2 = Array_Descriptor.Array_Domain.getLocalMaskIndex(2).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 3
     int localArrayBase3  = Array_Descriptor.Array_Domain.getLocalMaskIndex(3).getBase();
     int localArrayBound3 = Array_Descriptor.Array_Domain.getLocalMaskIndex(3).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 4
     int localArrayBase4  = Array_Descriptor.Array_Domain.getLocalMaskIndex(4).getBase();
     int localArrayBound4 = Array_Descriptor.Array_Domain.getLocalMaskIndex(4).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 5
     int localArrayBase5  = Array_Descriptor.Array_Domain.getLocalMaskIndex(5).getBase();
     int localArrayBound5 = Array_Descriptor.Array_Domain.getLocalMaskIndex(5).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 6
     int localArrayBase6  = Array_Descriptor.Array_Domain.getLocalMaskIndex(6).getBase();
     int localArrayBound6 = Array_Descriptor.Array_Domain.getLocalMaskIndex(6).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 7
     int localArrayBase7  = Array_Descriptor.Array_Domain.getLocalMaskIndex(7).getBase();
     int localArrayBound7 = Array_Descriptor.Array_Domain.getLocalMaskIndex(7).getBound();
#endif
#endif

  // Avoid compiler warnings by only declaring the ones that we use (1-MAX_ARRAY_DIMENSION)
     int i;
#if MAX_ARRAY_DIMENSION > 1
     int j;
#endif
#if MAX_ARRAY_DIMENSION > 2
     int k;
#endif
#if MAX_ARRAY_DIMENSION > 3
     int l;
#endif
#if MAX_ARRAY_DIMENSION > 4
     int m;
#endif
#if MAX_ARRAY_DIMENSION > 5
     int n;
#endif
#if MAX_ARRAY_DIMENSION > 6
     int o; 
#endif
#if MAX_ARRAY_DIMENSION > 7
     int p;
#endif

  // With more work we could make this more thoughly dimension independent
  // by using the same techniques as in the MDI code!
  // int i; int j; int k; int l; int m; int n; int o; int p;
     switch (numberOfDimensions())
        {
          case 0 : // Do nothing (nothing to do)!
               break;
          case 1 :
#if defined(PPP)
               for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                  {
                    if ((i >= localArrayBase0) && (i <= localArrayBound0))
                         localArray(i) = Counter;
                    Counter += Stride;
                  }
#else
               for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                  {
                    (*this)(i) = Counter;
                    Counter += Stride;
                  }
#endif
               break;
#if MAX_ARRAY_DIMENSION > 1
          case 2 :
#if defined(PPP)
               for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                    for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                       {
                         if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                             (j >= localArrayBase1) && (j <= localArrayBound1))
                              localArray(i,j) = Counter;
                         Counter += Stride;
                       }
#else
               for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                    for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                       {
                         (*this)(i,j) = Counter;
                         Counter += Stride;
                       }
#endif
               break;
#endif
#if MAX_ARRAY_DIMENSION > 2
          case 3 :
#if defined(PPP)
               for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                    for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                         for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                            {
                              if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                  (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                  (k >= localArrayBase2) && (k <= localArrayBound2))
                                   localArray(i,j,k) = Counter;
                              Counter += Stride;
                            }
#else
               for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                    for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                        for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                           {
                             (*this)(i,j,k) = Counter;
                             Counter += Stride;
                           }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 3
          case 4 :
#if defined(PPP)
               for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                    for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                         for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                              for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                 {
                                   if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                       (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                       (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                       (l >= localArrayBase3) && (l <= localArrayBound3))
                                        localArray(i,j,k,l) = Counter;
                                   Counter += Stride;
                                 }
#else
               for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                   for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                        for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                             for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                {
                                  (*this)(i,j,k,l) = Counter;
                                  Counter += Stride;
                                }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 4
          case 5 :
#if defined(PPP)
               for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                    for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                         for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                              for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                   for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                      {
                                        if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                            (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                            (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                            (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                            (m >= localArrayBase4) && (m <= localArrayBound4))
                                             localArray(i,j,k,l,m) = Counter;
                                        Counter += Stride;
                                      }
#else
               for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                   for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                        for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                             for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                  for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                     {
                                       (*this)(i,j,k,l,m) = Counter;
                                       Counter += Stride;
                                     }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 5
          case 6 :
#if defined(PPP)
               for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                    for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                         for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                              for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                   for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                        for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                           {
                                             if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                 (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                 (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                 (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                 (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                 (n >= localArrayBase5) && (n <= localArrayBound5))
                                                  localArray(i,j,k,l,m,n) = Counter;
                                             Counter += Stride;
                                           }
#else
               for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                   for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                        for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                             for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                  for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                       for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                          {
                                            (*this)(i,j,k,l,m,n) = Counter;
                                            Counter += Stride;
                                          }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 6
          case 7 :
#if defined(PPP)
               for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                    for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                         for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                              for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                   for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                        for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                             for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                {
                                                  if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                      (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                      (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                      (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                      (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                      (n >= localArrayBase5) && (n <= localArrayBound5) &&
                                                      (o >= localArrayBase6) && (o <= localArrayBound6))
                                                       localArray(i,j,k,l,m,n,o) = Counter;
                                                  Counter += Stride;
                                                }
#else
               for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                   for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                        for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                             for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                  for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                       for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                            for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                               {
                                                 (*this)(i,j,k,l,m,n,o) = Counter;
                                                 Counter += Stride;
                                               }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 7
          case 8 :
#if defined(PPP)
               for (p=Array_Base[7]; p <= Array_Bound[7]; p++)
                    for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                         for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                              for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                                   for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                        for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                             for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                                  for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                     {
                                                       if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                           (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                           (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                           (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                           (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                           (n >= localArrayBase5) && (n <= localArrayBound5) &&
                                                           (o >= localArrayBase6) && (o <= localArrayBound6) &&
                                                           (p >= localArrayBase7) && (p <= localArrayBound7))
                                                            localArray(i,j,k,l,m,n,o,p) = Counter;
                                                       Counter += Stride;
                                                     }
#else
               for (p=Array_Base[7]; p <= Array_Bound[7]; p++)
                   for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                        for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                             for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                                  for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                       for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                            for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                                 for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                    {
                                                      (*this)(i,j,k,l,m,n,o,p) = Counter;
                                                      Counter += Stride;
                                                    }
#endif
                   break;
#endif
          default: printf ("ERROR: Default reached in switch statement in floatArray::seqAdd \n");
                   APP_ABORT();
        }
#endif
#else
     printf ("ERROR: FUNCTION DISABLED ON CRAY Y-MP -- floatArray::seqAdd function generates internal compiler error \n");
     printf ("       NO WORK AROUND HAS BEEN FOUND! \n");
     APP_ABORT();
#endif

     return *this;
   }

#if defined(INTARRAY)
#if 0
// *****************************************************************************************
// Function not supported since it allows to two paths to build an intArray: intArray(1) 
// and intArray(Index(1)) which is ambiguous to the C++ compiler if required for autopromotion!
// It might be allowed now that there are special operator() for each possilbe case of mixing scalar
// with intArray in the indirect addressing of A++ array object!
// *****************************************************************************************
intArray::intArray ( const Internal_Index & X ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<float>(this)
#endif
   {
  // Convert an Index to an intArray to support mixed intArray and Index object indexing!
  // Later this function will access the chache of readonly intArray objects 
  // for use with indexing!

#if EXTRA_ERROR_CHECKING
     if (X.getMode() == All_Index)
        {
          printf ("ERROR: Can't convert Index object with mode All_Index to intArray! \n");
          X.display();
          printf ("ERROR in intArray::intArray ( const Index & X ) (see explanation above!) \n");
          APP_ABORT();
        }
#endif

  // Build a descriptor for a 1D array! Null_Index generates a Null intArray
     if (X.getMode() == Null_Index)
          //Array_Descriptor = new Array_Descriptor_Type ();
          Array_Descriptor = 
	     new floatArray_Descriptor_Type();
       else
          Array_Descriptor = 
	     new floatArray_Descriptor_Type
	        (X.length(),1,1,1);
          //Array_Descriptor = new Array_Descriptor_Type (X.length(),1,1,1);

  // APP_ASSERT( Array_Descriptor != NULL );

  // Allocate array memory!
     Allocate_Array_Data (TRUE);
     Array_Storage  = NULL;
     referenceCount = getReferenceCountBase();

     if (X.getMode() == Index_Triplet)
          seqAdd (X.getBase(),X.getStride());
   }
#endif

// *****************************************************************************************
// This function initializes the elements of the result array with the  i n d e x  positions
// of the nonzero entries of the Lhs array.  It is used to build an  i n d e x  map into
// an array.  Typically it is used on the intArray result from a relational operator!
// For example: intArray indexMap = (A == 5).Build_indexMap();  
// indexMap is an array (of length cooresponding to the number of elements of A with 
// value 5) with values equal to the  i n d e x  position in A where the values was 5.
// Thus function only makes sense in 1D - so we only handle that case!
// later we will make it return the positions along each axis so that it can handle
// multidimensional array masks.
// *****************************************************************************************
#if !defined(USE_EXPRESSION_TEMPLATES)
#if defined(PPP)
intArray & 
intArray::indexMap ()
   {
#if defined(USE_TAU)
     TAU_PROFILE("intArray::indexMap()", "void(float,float)", TAU_APP_USER_FUNCTIONS);
#endif
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of intArray::indexMap() (P++ specific)\n");

     Test_Consistency ("Called from intArray::indexMap() (P++ specific)");
#endif

  // printf ("ERROR: P++ intArray::indexMap not implemented! \n");
  // APP_ABORT();

     intSerialArray *Serial_Index_Map = &( Array_Descriptor.SerialArray->indexMap() );
     APP_ASSERT(Serial_Index_Map != NULL);
     int Number_Of_Nonzero_Elements   = Serial_Index_Map->elementCount();
     int Num_Dims = Serial_Index_Map->numberOfDimensions();
     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;
     Integer_List[0] = Number_Of_Nonzero_Elements;
     Integer_List[1] = Num_Dims;
     int temp;
     for (temp=2; temp < MAX_ARRAY_DIMENSION; temp++)
          Integer_List[temp] = 0;
     intArray *Return_Index_Map     = new intArray
      (Serial_Index_Map, Integer_List);
    //(Serial_Index_Map , 
    //new floatArray_Descriptor_Type(Integer_List));

#if COMPILE_DEBUG_STATEMENTS
     Return_Index_Map->Test_Consistency ("Called from intArray::indexMap() (P++ specific)");
#endif

  // printf ("Exiting from intArray::indexMap () ... \n");
  // APP_ABORT();

  // Since we want A++/P++ to correctly absorb the array when it 
  // is used it needs to be marked as a temporary.
     Return_Index_Map->setTemporary(TRUE);

     return *Return_Index_Map;
   }

// else not defined(PPP)
#else

// A++ and Serial_Array version of indexMap member function
intArray &
intArray::indexMap ()
   {
#if defined(USE_TAU)
     TAU_PROFILE("intArray::indexMap()", "void(float,float)", TAU_APP_USER_FUNCTIONS);
#endif
  // This takes a Mask and returns the intArray with values that coorespond to the 
  // poistions of 1's in the mask.
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of intArray::indexMap() \n");

     Test_Consistency ("Called from intArray::indexMap()");
#endif

#if EXTRA_ERROR_CHECKING
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
          printf ("ERROR: Inside of intArray::indexMap() -- Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION == TRUE (sorry, not supported yet) \n");
          APP_ABORT();
       // floatArray_Function_15 *Execution_Object = new floatArray_Function_15 ( indexMap_Function , MDI_Build_Index_Map_Array , *this );
        } 
#endif

  // indexMap could be called for a NULL array object
  // APP_ASSERT (Array_Descriptor.Array_Data != NULL);

  // view ("BEFORE SUM: *this");

  // Any use of (*this) after the next statement will be an error if (*this) is a temporary!
  // The next statement correctly absorbes the temporary (if it is one).  Thus this function
  // manages the memory and lifetime of its data properly.
  // If *this is a temporary then we can't expect to use it so we have to use
  // Mask_Of_Nonzero_Elements explicitly instead
     intArray Mask_Of_Nonzero_Elements = (*this != 0);

     int numberOfNonzeroElements = sum (Mask_Of_Nonzero_Elements);
     int numDims                 = Mask_Of_Nonzero_Elements.numberOfDimensions();

     APP_ASSERT (numDims == numberOfDimensions());

  // printf ("In indexMap: numberOfNonzeroElements = %d numDims = %d \n",numberOfNonzeroElements,numDims);

  // This would be a null array if numberOfNonzeroElements == 0
     intArray *Return_Index_Map = new intArray(numberOfNonzeroElements,numDims);
     APP_ASSERT( Return_Index_Map != NULL );

#if COMPILE_DEBUG_STATEMENTS
     Return_Index_Map->Test_Consistency ("Called from intArray::indexMap()");
#endif

  // printf ("WARNING: Possible error in base usage of indexMap function! \n");

  // Force array bases to zero if not already!
     int temp;
     for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
          if (Return_Index_Map->getBase(temp) != 0)
               Return_Index_Map->setBase (0,temp);

  // Temp code to initialize the returning array object
  // *Return_Index_Map = 0;

#if 1
  // To improve the performance we implement a specialized version 
  // directly for the most common dimensions
     if (numDims == 1)
        {
          float* resultPointer = Return_Index_Map->Array_Descriptor.Array_Data;
          float* arrayPointer  = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_View_Pointer0;

       // APP_ASSERT (resultPointer != NULL);
       // APP_ASSERT (arrayPointer  != NULL);

          int i=0;
          int counter = 0;
          int base   = Mask_Of_Nonzero_Elements.getBase(0);
          int bound  = Mask_Of_Nonzero_Elements.getBound(0);
          int stride = Mask_Of_Nonzero_Elements.getRawStride(0);

       // APP_ASSERT(stride == 1 );

          for (i=base; i <= bound; i += stride)
             {
               if (arrayPointer[i])
                  {
                    resultPointer[counter] = (i/stride);
                    counter++;
                  }
             }
        }
       else
        {
          if (numDims == 2)
             {
               float* resultPointer = Return_Index_Map->Array_Descriptor.Array_Data;
               float* arrayPointer  = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_View_Pointer1;

            // APP_ASSERT (resultPointer != NULL);
            // APP_ASSERT (arrayPointer  != NULL);

               int i=0;
               int j=0;
               int counter = 0;
               int base0   = Mask_Of_Nonzero_Elements.getBase(0);
               int bound0  = Mask_Of_Nonzero_Elements.getBound(0);
               int stride0 = Mask_Of_Nonzero_Elements.getRawStride(0);
               int base1   = Mask_Of_Nonzero_Elements.getBase(1);
               int bound1  = Mask_Of_Nonzero_Elements.getBound(1);
               int stride1 = Mask_Of_Nonzero_Elements.getRawStride(1);
               int size    = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain.Size[0];

            // APP_ASSERT(stride0 == stride1 == 1 );

               for (j=base1; j <= bound1; j += stride1)
                  {
                    int offset_i = (j*size);
                    for (i=base0; i <= bound0; i += stride0)
                       {
                         if (arrayPointer[offset_i+i])
                            {
                              resultPointer[counter]                         = (i/stride0);
                              resultPointer[numberOfNonzeroElements+counter] = (j/stride1);
                              counter++;
                            }
                       }
                  }
             }
            else
             {
               if ( numDims == 3 )
                  {
                    float* resultPointer = Return_Index_Map->Array_Descriptor.Array_Data;
                    float* arrayPointer  = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_View_Pointer2;

                 // APP_ASSERT (resultPointer != NULL);
                 // APP_ASSERT (arrayPointer  != NULL);

                    int i=0;
                    int j=0;
                    int k=0;
                    int counter = 0;

                    int size0   = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain.Size[0];
                    int base0   = Mask_Of_Nonzero_Elements.getBase(0);
                    int bound0  = Mask_Of_Nonzero_Elements.getBound(0);
                    int stride0 = Mask_Of_Nonzero_Elements.getRawStride(0);

                    int size1   = Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain.Size[1];
                    int base1   = Mask_Of_Nonzero_Elements.getBase(1);
                    int bound1  = Mask_Of_Nonzero_Elements.getBound(1);
                    int stride1 = Mask_Of_Nonzero_Elements.getRawStride(1);

                    int base2   = Mask_Of_Nonzero_Elements.getBase(2);
                    int bound2  = Mask_Of_Nonzero_Elements.getBound(2);
                    int stride2 = Mask_Of_Nonzero_Elements.getRawStride(2);

                    for (k=base2; k <= bound2; k += stride2)
                       {
                         int offset_j = (k*size1);
                         for (j=base1; j <= bound1; j += stride1)
                            {
                              int offset_i = offset_j+(j*size0);
                              for (i=base0; i <= bound0; i += stride0)
                                 {
                                   if (arrayPointer[offset_i+i])
                                      {
#if 0
                                        printf ("FOUND NONZERO VALUE: counter = %d i = %d j = %d k = %d \n",
                                             counter,i,j,k);
#endif
                                        resultPointer[counter]                               = (i/stride0);
                                        resultPointer[numberOfNonzeroElements + counter]     = (j/stride1);
                                        resultPointer[(numberOfNonzeroElements*2) + counter] = (k/stride2);
                                        counter++;
                                      }
                                 }
                            }
                       }
                  }
                 else
                  {
                 // Handle dimensions greater then 3 using the more general MDI layer

                 // Setup Mask pointers! (Fix this later -- not defined for a where mask)
                    int *Mask_Data       = NULL;
                    array_domain *Mask_Descriptor = NULL;

                 // Call the MDI function
                    MDI_Build_Index_Map_Array (
                              Return_Index_Map->Array_Descriptor.Array_Data , 
                              Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Data , 
                              Mask_Data ,
                              (array_domain*)(&Return_Index_Map->Array_Descriptor.Array_Domain) , 
                              (array_domain*)(&Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain) , 
                              Mask_Descriptor );
                  }
             }
        }

#else

  // Setup Mask pointers! (Fix this later -- not defined for a where mask)
     int *Mask_Data                = NULL;
     array_domain *Mask_Descriptor = NULL;

  // Call the MDI function
     MDI_Build_Index_Map_Array ( Return_Index_Map->Array_Descriptor.Array_Data , 
                                 Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Data , 
                                 Mask_Data ,
                                 (array_domain*)(&Return_Index_Map->Array_Descriptor.Array_Domain) , 
                                 (array_domain*)(&Mask_Of_Nonzero_Elements.Array_Descriptor.Array_Domain) , 
                                 Mask_Descriptor );
#endif

#if COMPILE_DEBUG_STATEMENTS
     Return_Index_Map->Test_Consistency ("Called from intArray::indexMap()");

     if (APP_DEBUG > 3)
          printf ("Leaving intArray::Index_Map() \n");
#endif

  // Since we want A++/P++ to correctly absorb the array when it 
  // is used it needs to be marked as a temporary.
     Return_Index_Map->setTemporary(TRUE);

  // Return_Index_Map->view("Called from intArray::indexMap()");

     return *Return_Index_Map;
   }
#endif
#endif
#endif

// *****************************************************************
// Build_Pointer_To_View_Of_Array simplifies the internal 
// construction of a view (for use internally in A++/P++)
// *****************************************************************
floatArray*
floatArray::Build_Pointer_To_View_Of_Array (
   const floatArray & X , 
   const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
#if defined(USE_TAU)
     TAU_PROFILE("floatArray::Build_Pointer_To_View_Of_Array()", 
                 "floatArray*(floatArray,Internal_Index,Internal_Index,Internal_Index,Internal_Index)", 
                 TAU_APP_OVERHEAD);
#endif

  // This function builds a pointer to a view using an existing floatSerialArray and an array
  // of Internal_Index objects (array of Internal_Index objects should be length MAX_ARRAY_DIMENSION == 4)
  // This function could be made more efficient if it was made less dependent on length
  // 4 Internal_Index arrays as input.  So maybe later we can have 4 different versions each taking a different
  // number of Internal_Index objects.

     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
       // This generate a call to the BaseArray::Array_ID() (some sort of error?)
          printf ("Inside of floatArray::Build_Pointer_To_View_Of_Array ( const floatArray & X , const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List ) \n");

          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
             {
               Internal_Index_List[temp]->list("input parameter to Build_Pointer_To_View_Of_Array");
             }
        }

     if (Diagnostic_Manager::getReferenceCountingReport() > 0)
        {
       // This mechanism outputs reports which allow us to trace the reference counts
          X.displayReferenceCounts("Input X in floatArray::Build_Pointer_To_View_Of_Array");
        }

     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In Build_Pointer_To_View_Of_Array() - X array local range (%d,%d,%d) \n",
               X.getBase(0),
               X.getBound(0),
               X.getStride(0));

            // We are most interested in 1D problems currently
          printf ("     input Internal_Index_List[0] range (%d,%d,%d) \n",
               Internal_Index_List[0]->getBase(),
               Internal_Index_List[0]->getBound(),
               Internal_Index_List[0]->getStride());

       // X.view("Input array_Domain to floatArray::Build_Pointer_To_View_Of_Array");
        }
#endif

#if BOUNDS_ERROR_CHECKING
     if (Internal_Index::Index_Bounds_Checking)
        {
          X.Error_Checking_For_Index_Operators ( Internal_Index_List );
        }
#endif

#if 0
  // (7/27/2000) added assert (trap case of target of view being a null array)
  // APP_ASSERT(X.isNullArray() == FALSE);
     if (X.isNullArray() == TRUE)
        {
          if (X.isView() == TRUE)
             {
            // Even a null array needs to have a valid data point if it is a view.
            // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
               APP_ASSERT(X.getDataPointer() != NULL);
             }
        }
#endif

  /*
  // ... change (8/26/96,kdb) new interpretation for index application so
  // a new list of Indexes with compressed stride (usually 1) is constructed
  // and used instead of Internal_Index_List (try stride 1 first because 
  // needed stride for ratio is currently unavailable) ...
  */
  /* .. change again (10/9/96,kdb) this wasn't quite correct before ... */
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List_For_View;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT(Internal_Index_List[temp] != NULL);

       // .. (10/15/96,kdb) try again to get this right ...
          if (Internal_Index_List[temp]->Index_Mode == Index_Triplet)
             {
               int indexBase     = Internal_Index_List[temp]->getBase();
               int indexCount    = Internal_Index_List[temp]->getCount();
               int indexStride   = Internal_Index_List[temp]->getStride();
               int domainRawBase = X.Array_Descriptor.getRawBase(temp);
               int domainBase    = X.Array_Descriptor.getBase(temp);
               int domainRawStride  = X.Array_Descriptor.getRawStride(temp);

            // I suspect that the computation of tempBase is wrong!
#if 0
               printf ("In Build_Pointer_To_View_Of_Array (axis=%d) indexBase = %d indexCount = %d indexStride = %d domainRawBase = %d domainBase = %d domainRawStride = %d \n",
                    temp,indexBase,indexCount,indexStride,domainRawBase,domainBase,domainRawStride);
#endif

            // This is the simplest way to build the correct index (else why was this index input?)
               Internal_Index_List_For_View[temp] = new Internal_Index(*Internal_Index_List[temp]);
               APP_ASSERT (Internal_Index_List_For_View[temp] != NULL);
             }
            else
             {
            // ... NULL INDEX CASE ...
               Internal_Index_List_For_View[temp] = new Internal_Index(0,0,1);
               APP_ASSERT (Internal_Index_List_For_View[temp] != NULL);
             }

#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
             {
               printf ("Axis = %d \n",temp);
               Internal_Index_List_For_View[temp]->list("Internal_Index_List_For_View");
             }
#endif
        }

#if EXTRA_ERROR_CHECKING
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          APP_ASSERT (Internal_Index_List[temp] != NULL);

     if (Index::Index_Bounds_Checking)
        {
       // X.view("X in floatArray::Build_Pointer_To_View_Of_Array()");
       // Must make array of pointer to Internal_Index objects from array of Internal_Index
       // ... (8/26/96) use Internal_Index_List_For_View instead ...
          X.Array_Descriptor.Error_Checking_For_Index_Operators ( Internal_Index_List_For_View );
        }
#endif

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
       // X.view("X in floatArray::Build_Pointer_To_View_Of_Array()");
       // printf ("Exiting in floatArray::Build_Pointer_To_View_Of_Array() \n");
       // APP_ABORT();
        }
#endif

#if defined(PPP)
  // make code independent of 4 dimensional arrays internally
  // Internal_Index Local_Index_Array [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Local_Index_Array;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp] != NULL);
       // Bugfix (11/9/95) New Cray C++ compiler on T3D does not like the following statement
       // It is good to have such picky compilers since no other compiler has caught the problem.
       // ... (8/26/96) use Internal_Index_List_For_View instead ...
          Local_Index_Array [temp] = Internal_Index_List_For_View[temp]->getPointerToLocalPart
                                          (X.Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain,temp);

#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 2)
             {
               printf ("Axis = %d \n",temp);
               Local_Index_Array[temp]->display("Internal_Index_List_For_View");
             }
#endif
        }

  // Must delete the pointers returned from getPointerToLocalPart an stored into Local_Index_Array
  // ... (8/26/96) use Internal_Index_List_For_View instead ...
  // This P++ version calls the Serial A++ version of this function
     floatArray* Return_Pointer = new floatArray
          (floatSerialArray::Build_Pointer_To_View_Of_Array(*X.Array_Descriptor.SerialArray,Local_Index_Array) , 
	   X.Array_Descriptor.Array_Domain, Internal_Index_List_For_View );
     APP_ASSERT(Return_Pointer != NULL);

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp] != NULL);
          delete Local_Index_Array [temp];
          Local_Index_Array [temp] = NULL;

       // ... Internal_Index_List_For_View is no longer needed ...
          delete Internal_Index_List_For_View [temp];
          Internal_Index_List_For_View [temp] = NULL;
        }
#else
  // NON P++ version of code body
  // We have to increment the reference count for the data since there is now another
  // reference to it.
     X.incrementRawDataReferenceCount();

  // (7/27/2000) added assert
  // APP_ASSERT(X.isNullArray() == FALSE);
  // APP_ASSERT(X.Array_Descriptor.Array_Data != NULL);

  // ... (8/26/96) use Internal_Index_List_For_View instead ...
     floatArray* Return_Pointer = 
          new floatArray(X.Array_Descriptor.Array_Data,X.Array_Descriptor.Array_Domain,Internal_Index_List_For_View );
     APP_ASSERT(Return_Pointer != NULL);

  // ... Internal_Index_List_For_View is no longer needed ...
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          delete Internal_Index_List_For_View [temp];
          Internal_Index_List_For_View [temp] = NULL;
        }

#if COMPILE_DEBUG_STATEMENTS
#if 0
     if (X.isNullArray())
        {
       // Even a null array needs to have a valid data point if it is a view.
       // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
          APP_ASSERT(X.getDataPointer() != NULL);
          APP_ASSERT(Return_Pointer->getDataPointer() != NULL);
        }
     if (Return_Pointer->isNullArray() == TRUE)
        {
          if (Return_Pointer->isView() == TRUE)
             {
            // Even a null array needs to have a valid data point if it is a view.
            // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
               APP_ASSERT(Return_Pointer->getDataPointer() != NULL);
             }
        }
#endif
#endif
#endif

  // Return_Pointer->view("Output array_Domain to floatArray::Build_Pointer_To_View_Of_Array");

     if (X.isTemporary())
        {
          Return_Pointer->setTemporary(TRUE);
        }

     if (X.isTemporary())
          APP_ASSERT(Return_Pointer->isTemporary());

#if COMPILE_DEBUG_STATEMENTS
     if (Diagnostic_Manager::getReferenceCountingReport() > 0)
        {
       // This mechanism outputs reports which allow us to trace the reference counts
          X.displayReferenceCounts("Input X in BASE of floatArray::Build_Pointer_To_View_Of_Array");
          Return_Pointer->displayReferenceCounts("Return_Pointer in BASE of floatArray::Build_Pointer_To_View_Of_Array");
        }
#endif

     return Return_Pointer;
   }

// *****************************************************************
// adopt member function uses existing memory to build A++ and P++ arrays
// *****************************************************************
floatArray &
floatArray::adopt (
   const float* Data_Pointer ,
   const Partitioning_Type & Partition ,
   ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 2)
          printf ("Inside of floatArray::adopt (float*,Partitioning_Type,int,Range,int,Range,int,Range,int,Range) (Pointer = %p) (Array_ID = %d) \n",Data_Pointer,Array_ID());
#endif

     INTEGER_AND_RANGE_ARGUMENTS_TO_INTEGER_AND_CONST_REF_RANGE_LIST_MACRO

  // printf ("Users data must be in a partitioning conformable to P++ internal usage! \n");
  // printf ("floatArray::adopt (float*,Partitioning_Type,int,Range,int,Range,int,Range,int,Range) not implemented in P++! \n");
  // APP_ABORT();

     return adopt ( Data_Pointer , Partition , Integer_List , Internal_Index_List );
   }

// This is the functional part of the P++ adopt member function
// It is not implemented currently because it is more difficult than expected
floatArray & 
floatArray::adopt ( const float* Data_Pointer , const Partitioning_Type & Partition ,
                   const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List ,
                   const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
#if defined(PPP)
  // Avoid compiler warning about unused input variable
     if (&Partition);
     if (&Integer_List);
     if (&Data_Pointer);
  // if (&Internal_Index_List);

     printf ("Users data must be in a partitioning conformable to P++ internal usage! \n");
     printf ("floatArray::adopt (float*,Partitioning_Type,int,Range,int,Range,int,Range,int,Range) not implemented in P++! \n");
     APP_ABORT();

  // adopt ( Data_Pointer , Partition , Integer_List );
  // floatArray *Temp_Array = new floatArray(Internal_Index_List,Partition);
  // Temp_Array->Array_Descriptor->incrementReferenceCount;
  // delete Array_Descriptor;
  // Array_Descriptor = Temp_Array->Array_Descriptor;
  // delete Temp_Array;
#else
  // Avoid compiler warning about unused input variable
     if (&Partition);
     if (&Integer_List);

  // Call the A++ member function
     adopt ( Data_Pointer , Internal_Index_List );
#endif

  // Now setup the new bases (changed from the default of ZERO)
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
           setBase (Internal_Index_List[temp]->Base,temp);
     return *this;
   }

// A++ specific implementation of adopt member functions
// These A++ specific function are made available to P++ to maintain
// the identical interface even though under P++ these functions
// are not implemented.
floatArray & 
floatArray::adopt ( const float* Data_Pointer , const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of floatArray::adopt (float*,int*)(Pointer = %p)(Array_ID = %d)(referenceCount = %d, raw data reference count = %d)\n",
	      Data_Pointer,Array_ID(),getReferenceCount(),getRawDataReferenceCount());
        }
#endif

#if defined(PPP)
  // Avoid compiler warning about unused input variable
     if (&Integer_List);

     printf ("ERROR: not implemented for P++ (another P++ specific adopt member function is required)! \n");
     APP_ABORT();
#else
  // Get default base for each dimension
     int OldBase[MAX_ARRAY_DIMENSION];
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          OldBase[temp] = APP_Global_Array_Base;

     bool Is_A_Null_Array = FALSE;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT(Integer_List[temp] >= 0);
          if (Integer_List[temp] == 0) Is_A_Null_Array = TRUE;
        }

#if COMPILE_DEBUG_STATEMENTS
     if (Is_A_Null_Array) 
        {
          APP_ASSERT( Data_Pointer != NULL );
        }
#endif

  // Save old base for each dimension
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          OldBase[temp] = getBase(temp);

     Delete_Array_Data();

#if (ARRAY_ID_LEAK_FIXED == TRUE)

  // printf ("In adopt: ARRAY_ID_LEAK_FIXED is not fixed yet! \n");
  // APP_ABORT();

  // Bugfix (1/27/97) I think this fixes what appeared to be a memory leak in the adopt function
  // Since the reference count includes the initial reference we have to return
  // the Array_ID before we would otherwise (one array reference before we would otherwise).
  // Note: it is OK to return the Array_ID as long as the reference count is also reset
  // else there are many problems the next time that Array_ID is reused.  If the reference
  // count is < 0 then it would be reset and the Array_ID returned within the destructor for
  // the Array_Descriptor.  But it is because the reference count can be == 0 that we have
  // to fix this problem here.
  // printf ("getRawDataReferenceCount() = %d \n",getRawDataReferenceCount() );
  // if (getRawDataReferenceCount() == 0)  we really do need to handle the case of <= 0
     if (getRawDataReferenceCount() <= getRawDataReferenceCountBase())
        {
       // printf ("Note: getRawDataReferenceCount() = %d <= getRawDataReferenceCountBase() = %d \n",
       //        getRawDataReferenceCount(),getRawDataReferenceCountBase());

#if !defined(PPP)
       // Reinitialize reference count for next use!
          resetRawDataReferenceCount();
       // Array_Descriptor_Type::Array_Reference_Count_Array [Array_ID()] = 0;
#endif

       // Array_Descriptor.Push_Array_ID (Array_ID());
          Array_Domain_Type::Push_Array_ID (Array_ID());
        }
#endif

  // Note that the default base will be used for this array object!
     APP_ASSERT (!Is_A_Null_Array); // temp test (6/13/2000)
     if (!Is_A_Null_Array)
        {
       // printf ("Do we have to assign more data? \n");
       // Array_Descriptor = new Array_Descriptor_Type ( MAX_ARRAY_DIMENSION , Integer_List );
       // Array_Descriptor = Array_Descriptor_Type ( MAX_ARRAY_DIMENSION , Integer_List );
          Array_Descriptor.Initialize_Descriptor ( MAX_ARRAY_DIMENSION , Integer_List );
        }
       else
        {
          printf ("Do we have to assign more data? \n");
       // Array_Descriptor = new Array_Descriptor_Type ();
       // This constructor should have already been called! (Dan, 5/16/97)
       // Array_Descriptor = Array_Descriptor_Type ();
        }

  // APP_ASSERT( Array_Descriptor != NULL );

// We have to record that this array object is built using preexisting data.
// This means that we will have to give back the Array_ID within the redim function
// Are there other functions where we would have to give back the Array_IDs?
   Array_Descriptor.Array_Domain.builtUsingExistingData = TRUE;

// Now use the pointer that was provide by the user!

#if defined(PPP)
   Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Local_Internal_Index_List;
   for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
      Local_Internal_Index_List[temp] = &(Array_Descriptor.Array_Domain.Local_Mask_Index[temp]);
   Array_Descriptor.SerialArray   = new floatSerialArray;
   Array_Descriptor.SerialArray->adopt (Data_Pointer,Local_Internal_Index_List);
#else
   Array_Descriptor.Array_Data    = (float*) Data_Pointer;
   POINTER_LIST_INITIALIZATION_MACRO;
#endif
   Array_Storage = NULL;

   // Increment the reference count so that destructor cannot delete the data
   // we need this because the data might not have been from the heap. And because
   // if the user created the data it is the users responcibility to handle the 
   // memory.
   incrementRawDataReferenceCount();

   // reset the base to that of the old descriptor
   for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
      setBase (OldBase[temp],temp);
#endif

   return *this;
}

// *****************************************************************
// adopt member function uses existing memory to build A++ arrays
// and Integers to setup the dimensions
// *****************************************************************
floatArray & floatArray::adopt ( const float* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 2)
          printf ("Inside of floatArray::adopt (float*,int,int,int,int) (Pointer = %p) (Array_ID = %d) \n",Data_Pointer,Array_ID());
#endif

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

     return adopt ( Data_Pointer , Integer_List );
   }

// *****************************************************************
// adopt member function uses existing memory to build A++ arrays
// and Range objects to setup the base and dimensions
// *****************************************************************
floatArray & floatArray::adopt ( const float* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     return adopt ( Data_Pointer , Internal_Index_List );
   }

// This function takes an array of Internal_Index objects
floatArray & floatArray::adopt ( const float* Data_Pointer , const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          Array_Size[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base) + 1;

     adopt ( Data_Pointer , Array_Size );

  // Now setup the new bases (changed from the default of ZERO)
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
           setBase (Internal_Index_List[temp]->Base,temp);

     return *this;
   }

// *****************************************************************
// adopt member function uses existing memory to build A++ and P++ 
// arrays and another A++/P++ array objects to get the size and distribution (in P++)
// *****************************************************************
floatArray & floatArray::adopt ( const float* Data_Pointer , const floatArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 2)
          printf ("Inside of floatArray::adopt (float*,floatArray) (Pointer = %p) (Array_ID = %d) \n",Data_Pointer,Array_ID());
#endif

     Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          Array_Size[temp] = X.getLength(temp);

#if defined(PPP)
  // In P++ we would have to get the partition information and then 
  // use an alternative adopt function internally. This has not been implemented yet.
     printf ("Not implemented for P++: floatArray::adopt ( const float* Data_Pointer , const floatArray & X ) \n");
     APP_ABORT();
#endif

     return adopt ( Data_Pointer , Array_Size );
   }

// *********************************************************
// Used by the inlined operator new -- required because 
// inlined functions can't have loops (with Cfront C++)
// *********************************************************
void floatArray::New_Function_Loop ()
   {
  // Initialize the free list of pointers!
     for (int i=0; i < CLASS_ALLOCATION_POOL_SIZE-1; i++)
        {
          Current_Link [i].freepointer = &(Current_Link[i+1]);
        }
   }

// *********************************************************
// Destructor for A++ objects
// *********************************************************
floatArray::~floatArray ()
   {
  // The assumed semantics of the destructor is that it must delete the array object
  // however it may (based upon the reference count) select to not delete the data.
  // This is because at this (late) point in the process the space associated with 
  // the array object must be freed to the operating system.  So the place to do the
  // reference counting check on the array object (different from the array data contained within
  // the array object) is before the delete operator is called (since the delete operator then
  // calls the destructor (or is it the other way around?)).

#if COMPILE_DEBUG_STATEMENTS
     if ( (APP_DEBUG > 0) || (Diagnostic_Manager::getReferenceCountingReport() > 0) )
        {
#if defined(PPP)
          printf ("### Inside of floatArray::destructor (Array_id = %d, this=%p, this->Array_Descriptor.SerialArray=%p) (referenceCount = %d) \n",
               this->Array_ID(),this,this->Array_Descriptor.SerialArray,referenceCount);
#else
          printf ("              floatArray::destructor (Array_id = %d, this=%p, this->Array_Data=%p) (referenceCount = %d) \n",
               this->Array_ID(),this,this->Array_Descriptor.Array_Data,referenceCount);
#endif
        }

     if ( Diagnostic_Manager::getReferenceCountingReport() > 0 )
        {
          displayReferenceCounts("In floatArray destructor");
        }
#endif

#if defined(PPP)
  // Delete this array in the list of arrays associated with this partition
  // This does a shallow delete removing the object from the list only!

  // Views are not defined with a partitioning object since it uses the
  // same partitioning object as what the view is a view of!
     if ( (Array_Descriptor.isView() == FALSE) && (Array_Descriptor.isTemporary() == FALSE) )
        {
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
             {
            // printf ("In floatArray::~floatArray: remove the reference to the array in the DEFAULT partitioning object! \n");
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);
             }
            else
             {
            // printf ("In floatArray::~floatArray: remove the reference to the array in a valid partitioning object! \n");
               Internal_Partitioning_Type::DeleteArrayToPartitioning
                    (*(Array_Descriptor.Array_Domain.Partitioning_Object_Pointer),*this);
             }
        }
#endif

#if 0
  // If the reference count is greater than zero then it means that the object is
  // in use by some other reference -- so we would not want to delete the array object OR the data.
  // Note that the delete operator should decriment the referenceCount.
     if (referenceCount < getReferenceCountBase())
        {
          printf ("referenceCount in floatArray::destructor is %d (check reference count before calling delete) \n",
               referenceCount);
       // view("ERROR: referenceCount >= getReferenceCountBase() in floatArray::destructor");
       // APP_ABORT();
        }
  // APP_ASSERT(referenceCount >= getReferenceCountBase());
#endif

  // printf ("referenceCount in floatArray::destructor is %d Array_ID() = %d \n",referenceCount,Array_ID());

#if 0
#if defined(PPP)
     if (Array_Descriptor.SerialArray != NULL)
        {
          printf ("In floatArray::destructor Array_Descriptor.SerialArray->getReferenceCount() = %d \n",
               Array_Descriptor.SerialArray->getReferenceCount());
        }
       else
        {
          printf ("In floatArray::destructor Array_Descriptor.SerialArray == NULL! \n");
        }
#endif
#endif

  // (12/08/2000) I don't know if we can assert this for P++
     APP_ASSERT(referenceCount <= getReferenceCountBase());

     APP_ASSERT (Array_Storage == NULL);
#if COMPILE_DEBUG_STATEMENTS
     if (Array_Storage != NULL)
        {
          if (APP_DEBUG > 0)
               printf ("NOTE: floatArray::~floatArray --  Array_Storage (built during defered evaluation) is NOT NULL! \n");
        }
#endif

#if defined(PPP)
     if (Array_Descriptor.SerialArray != NULL)
#else
     if (Array_Descriptor.Array_Data != NULL)
#endif
        {
       // We don't have to decrement the reference count because 
       // it is done in the Delete_Array_Data() member function
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 1)
             {
#if defined(PPP)
               printf ("Call destructor for SerialArray (getRawDataReferenceCount() = %d) \n",getRawDataReferenceCount());
#else
               printf ("Call destructor for Array_Data (getRawDataReferenceCount() = %d) \n",getRawDataReferenceCount());
#endif
             }
#endif
          APP_ASSERT(getRawDataReferenceCount() >= getReferenceCountBase());

          Delete_Array_Data ();
#if defined(PPP)
          Array_Descriptor.SerialArray = NULL;
#else
          Array_Descriptor.Array_Data  = NULL;
          POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif
        }
       else
        {
       // We still have to decrement the reference count since otherwise
       // the use of the reference counting would be inconsistant between
       // the array object having data and a Null array object.
       // The Array_ID values in the descriptors que off of the
       // reference count to know when to return the Array_ID values
       // back to the stack.  So we have to decriment the reference count
       // even though the there really is no data in a Null array.
       // Within P++ this allows views of Null arrays (for arrays
       // not partitioned over  all processors) to be properly defined.
          decrementRawDataReferenceCount();

#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 1)
             {
#if defined(PPP)
               printf ("In ~floatArray(): Array_Descriptor.SerialArray == NULL! \n");
#else
               printf ("In ~floatArray(): Array_Descriptor.Array_Data == NULL! \n");
#endif
             }
#endif
        }

  // Note: Next is called the destructor for the Array_Descriptor and then the Array_Domain!
   }

int
floatArray::numberOfInternalArrays()
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::numberOfInternalArrays() \n");
#endif

     int numberOfOutstandingArrayObjects = 0;

     if (Last_Lhs_floatArray_Operand != NULL)
        {
          APP_ASSERT (Last_Lhs_floatArray_Operand->usesIndirectAddressing() == FALSE);
          numberOfOutstandingArrayObjects++;
        }

  // printf ("floatArray::numberOfInternalArrays() = %d \n",numberOfOutstandingArrayObjects);

     return numberOfOutstandingArrayObjects;
   }



#if defined(APP) || defined(PPP)
#if defined(USE_PADRE)
void
floatArray::partition ( PADRE_Distribution<BaseArray,Array_Domain_Type,SerialArray_Domain_Type> *Partition )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of PADRE SPECIFIC floatArray::partition (PADRE_Distribution) function! \n");
#endif

  // printf ("PADRE SPECIFIC floatArray::partition (PADRE_Distribution) function! Exiting ... \n");
  // APP_ABORT();

     Internal_Partitioning_Type *Internal_Partition_Pointer = new Internal_Partitioning_Type (Partition);
     APP_ASSERT (Internal_Partition_Pointer != NULL);

  // printf ("BEFORE partition -- In floatArray::partition ( PADRE_Distribution* ): Internal_Partition_Pointer->getReferenceCount()  = %d \n",
  //      Internal_Partition_Pointer->getReferenceCount());

     partition (*Internal_Partition_Pointer); 

  // printf ("AFTER partition -- In floatArray::partition ( PADRE_Distribution* ): Internal_Partition_Pointer->getReferenceCount()  = %d \n",
  //      Internal_Partition_Pointer->getReferenceCount());

  // APP_ASSERT ( Internal_Partition_Pointer->getReferenceCount() == Internal_Partition_Pointer->getReferenceCountBase() );
     if (Internal_Partition_Pointer != NULL)
        {
          Internal_Partition_Pointer->decrementReferenceCount();
          if (Internal_Partition_Pointer->getReferenceCount() < 
              Internal_Partition_Pointer->getReferenceCountBase())
               delete Internal_Partition_Pointer;
          Internal_Partition_Pointer = NULL;
        }

  // printf ("Exiting in floatArray::partition(PADRE_Distribution) \n");
  // APP_ABORT();
   }
#endif

Internal_Partitioning_Type*
floatArray::getInternalPartitionPointer () const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::getInternalPartition () \n");
#endif

#if defined(PPP)
     return Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
#else
  // In the A++ case we can do most anything! (so return NULL)
     return NULL;
#endif
   }


Partitioning_Type
floatArray::getPartition () const
   {
  // This function might be better implemented to return a pointer and then a NULL 
  // pointer could be returned to signify the use of the Default values in the
  // Partitining_Type object (class) 

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::getPartition () \n");
#endif

#if defined(PPP)
  // APP_ASSERT (Array_Descriptor != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
        {
          printf ("Default values in Partitioning_Type used -- Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL \n");
        }
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL);

     return Partitioning_Type(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
#else
  // In the A++ case we can do most anything!
     return Partitioning_Type();
#endif
   }

floatArray &
floatArray::partition ( const Partitioning_Type & Partition )
   {
  // This function repartitions the THIS array using the input Partitioning_Type object!
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::partition (const Partitioning_Type & Partition) \n");
#endif

    //APP_ASSERT ( Partition.Internal_Array_Descriptor.Partitioning_Object != NULL );
    APP_ASSERT ( Partition.Internal_Partitioning_Object != NULL );
    partition (*Partition.getInternalPartitioningObject());
    return *this;
   }

floatArray &
floatArray::partition ( const Internal_Partitioning_Type & Partition )
   {
  // This function repartitions the THIS array using the input Partitioning_Type object!

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::partition (const Internal_Partitioning_Type & Partition) \n");
#endif

  // printf ("########################################################## \n");
  // printf ("### floatArray::partition (Internal_Partitioning_Type) #### \n");
  // printf ("########################################################## \n");

#if defined(PPP)
  // outstanding reference to the array object (but not the data) are OK
  // APP_ASSERT (getReferenceCount() == getReferenceCountBase());

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("In partition(): We should handle null array case the same as other cases (eliminate the test of null array!) \n");
#endif

     if (Array_Descriptor.isNullArray() == TRUE)
        {
       // This is a seperate case because the partitioning information is not
       // built for the case of a NULL array. Parti can't handle the concept of
       // a NULL array (as I recall).
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
          printf ("Inside of floatArray::partition: Case of Partitioning a Null Array \n");
#endif

          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 1)
                    printf ("Inside of floatArray::partition: deleting reference to %p in NON-DEFAULT list \n",this);
#endif
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
             }
            else
             {
            // Or delete it from the Default partitioning object!
            // Partitioning_Type::DefaultfloatArrayList.deleteElement(*this);
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 1)
                    printf ("Inside of floatArray::partition: deleting reference to %p in DEFAULT list \n",this);
#endif
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);
             }

       // Array_Descriptor.partition (*Partition.getInternalPartitioningObject());
          Array_Descriptor.partition (Partition);

       // printf ("Add (register) array to partitioning object \n");
       // Now associate this array with the partitioning so that if the partitioning is ever
       // changed we can find the array and propgate the effect of the redistribution.
          Internal_Partitioning_Type::AddArrayToPartitioning ( ((Internal_Partitioning_Type &) Partition), *this );
        }
       else
        {
       // I think this code is changing the lists used in the swapDistribution function (an STL list (for PADRE)).
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
             {
               Internal_Partitioning_Type & previousPartition = *(Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
            // First disassociate the THIS array from the array list on the Partitioning Object!
            // Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->floatArrayList.deleteElement(*this);
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);

            // printf ("Can't delete Partitioning object yet: no reference counting implemented yet! \n");
            // if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount-- == getReferenceCountBase())
            //      delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
            // Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;

            // Added error checking (11/14/2000)
               APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                           Internal_Partitioning_Type::getReferenceCountBase());

               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
               if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() <
                   Internal_Partitioning_Type::getReferenceCountBase())
                  {
                 // printf ("calling delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
                    delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
                  }
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;
             }
            else
             {
            // Or delete it from the Default partitioning object!
            // Partitioning_Type::DefaultfloatArrayList.deleteElement(*this);
               Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);
             }

       // The array size is not changing but a few parts of the global array descriptor are
       // effected by the redistribution and so we save the old descriptor and build a new descriptor (later).
       // A better implementation would just save the relavant parts (I think)
          floatArray_Descriptor_Type*
	     Old_Array_Descriptor = new floatArray_Descriptor_Type (Array_Descriptor);
          APP_ASSERT(Old_Array_Descriptor != NULL);

       // Modify some of the descriptor fields too
          Array_Descriptor.partition (Partition);

       // printf ("Add (register) array to partitioning object \n");
       // Now associate this array with the partitioning so that if the partitioning is ever
       // changed we can find the array and propgate the effect of the redistribution.
          Internal_Partitioning_Type::AddArrayToPartitioning ( ((Internal_Partitioning_Type &) Partition), *this );

          floatSerialArray *Temp_SerialArray = Array_Descriptor.SerialArray;

       // Increment reference count so that Temp_SerialArray will not be deleted!
          incrementRawDataReferenceCount();

          Delete_Array_Data();

       // Force all the mechanisms to build a P++ array to be called using the new partition data
          Allocate_Array_Data(TRUE);

       // At this point the descriptor for the new array (with the new partitioning) is defined
          floatArray_Descriptor_Type* New_Array_Descriptor = &Array_Descriptor;

       // printf ("Exiting in floatArray::partition AFTER Allocate_Array_Data() \n");
       // APP_ABORT();

          APP_ASSERT(New_Array_Descriptor != NULL);
          APP_ASSERT(Old_Array_Descriptor != NULL);

       // *****************************************************************
       // Now transfer the data from the old partition to the new partition
       // *****************************************************************

#if defined(USE_PADRE)
       // What PADRE function should we use here!
       // printf ("Must call a PADRE function! \n"); APP_ABORT();
          APP_ASSERT (New_Array_Descriptor != NULL);
          APP_ASSERT (Old_Array_Descriptor != NULL);
          APP_ASSERT (Array_Descriptor.SerialArray != NULL);
       // APP_ASSERT (Array_Descriptor.SerialArray->Array_Descriptor.Array_Data != NULL);
          APP_ASSERT (Temp_SerialArray != NULL);
       // APP_ASSERT (Temp_SerialArray->Array_Descriptor.Array_Data != NULL);

          PADRE_Descriptor<BaseArray,Array_Domain_Type,SerialArray_Domain_Type>::transferData 
             ( New_Array_Descriptor->Array_Domain, 
               Old_Array_Descriptor->Array_Domain,
               Temp_SerialArray->Array_Descriptor.Array_Data,
               Array_Descriptor.SerialArray->Array_Descriptor.Array_Data );
#else
       // Bugfix (4/11/96) PARTI returns the wrong schedule because it does not invalidate
       // the cached schedule from before the distribution was changed.  Thus it returns
       // the wrong schedule (or something like that).  The call to remove_subarray_scheds
       // is a PARTI function which clears the internal cache to force all subarray schedules
       // to be rebuilt from scratch.  When this bug in PARTI is fixed we can remove this function
       // call.
          remove_subarray_scheds();

          SCHED* Temp_Schedule = Internal_Partitioning_Type::BuildCommunicationScheduleRegularSectionTransfer
                                    ( New_Array_Descriptor->Array_Domain, Old_Array_Descriptor->Array_Domain );

          APP_ASSERT(Temp_SerialArray != NULL);
          APP_ASSERT(Array_Descriptor.SerialArray != NULL);

          if (Temp_Schedule != NULL)
             {
            // printf ("@@@@@@@ VALID SCHED OBJECT GENERATE IN floatArray::partition() \n");
            // Internal_Partitioning_Type::displaySCHED (Temp_Schedule);
            // Array_Descriptor->display("Array_Descriptor in floatArray::partition()");
            // The Temp_SerialArray is the source the this->SerialArray is the destination
#if defined(DOUBLEARRAY)
              dDataMove(Temp_SerialArray->Array_Descriptor.Array_Data,Temp_Schedule,
			Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
#elif defined(FLOATARRAY)
              fDataMove(Temp_SerialArray->Array_Descriptor.Array_Data, Temp_Schedule,
		        Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
#elif defined(INTARRAY)
              iDataMove(Temp_SerialArray->Array_Descriptor.Array_Data, Temp_Schedule,
		        Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
#endif
            // Delete the communication schedule that was just used
            // Note that a copy was saved as a part of PARTI's processing so that the
            // schedule can be reused later if required -- without it's recreation.
               delete_SCHED (Temp_Schedule);
               Temp_Schedule = NULL;
             }
            else
             {
            // printf ("$$$$$ VOID SCHED OBJECT GENERATE IN floatArray::partition() \n");
             }
#endif

       // ***************************************************
       // Now cleanup an prepare to return from this function
       // ***************************************************

       // Now delete the old descriptor
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          APP_ASSERT (Old_Array_Descriptor->getReferenceCount() >= floatArray_Descriptor_Type::getReferenceCountBase());
          Old_Array_Descriptor->decrementReferenceCount();
          if (Old_Array_Descriptor->getReferenceCount() < floatArray_Descriptor_Type::getReferenceCountBase())
               delete Old_Array_Descriptor;
          Old_Array_Descriptor = NULL;

       // Now delete the old serial array!
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          APP_ASSERT (Temp_SerialArray->getReferenceCount() >= getReferenceCountBase());
          Temp_SerialArray->decrementReferenceCount();
          if (Temp_SerialArray->getReferenceCount() < getReferenceCountBase())
               delete Temp_SerialArray;
          Temp_SerialArray = NULL;
        }
  // if def for use with if(PPP)
#endif

#if COMPILE_DEBUG_STATEMENTS
     int localNumberOfDimensions = numberOfDimensions();
  // printf ("In floatArray::partition: localNumberOfDimensions = %d \n",localNumberOfDimensions);

     int temp = 0;
     for (temp=0; temp < localNumberOfDimensions; temp++)
        {
       // printf ("In floatArray::partition: getGhostBoundaryWidth(%d) = %d Partition.getLocalGhostCellWidth(temp) = %d \n",temp,getGhostBoundaryWidth(temp),temp,Partition.getLocalGhostCellWidth(temp));
          APP_ASSERT (getGhostBoundaryWidth(temp) == Partition.getLocalGhostCellWidth(temp));
        }
     for (temp=localNumberOfDimensions; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // printf ("In floatArray::partition: getGhostBoundaryWidth(%d) = %d \n",temp,getGhostBoundaryWidth(temp));
          APP_ASSERT (getGhostBoundaryWidth(temp) == 0);
        }
#endif

  // printf ("Leaving floatArray::partition (const Partitioning_Type & Partition) \n");
  // printf ("Exiting at BASE of floatArray::partition (const Partitioning_Type & Partition) \n");
  // APP_ABORT();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from floatArray::partition(Internal_Partitioning_Type)");
#endif

     return *this;
   }


#if defined(PPP)
intSerialArray
#else
intArray
#endif
floatArray::buildProcessorMap ( floatArrayMemberVoidFunctionPointerType X )
   {
  // This function builds a 3D array object representing the base/bound for each 
  // dimension of an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::buildProcessorMap() \n");
#endif

     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // The length 2 of the last dimension is to hold the base and bound
#if defined(PPP)
     intSerialArray dataTable (numberOfNodes);
#else
     intArray dataTable (numberOfNodes);
#endif

     int j = 0;
     for (j = 0; j < numberOfNodes; j++)
        {
       // initialize the table
          dataTable(j) = 0;
        }

#if defined(PPP)
     Communication_Manager::Sync();

  // temp storage (required for Communication_Manager::fillProcessorArray)
     int* processorArray = new int [numberOfNodes];
     APP_ASSERT (processorArray != NULL);

  // initialize the newly allocated space
     for (j = 0; j < numberOfNodes; j++)
        {
          processorArray[j] = 0;
        }

  // fill in the local base and bound for each dimension (into the dataTable)
  // Communication_Manager::fillProcessorArray ( processorArray, getLocalBase(i) );
     Communication_Manager::fillProcessorArray ( processorArray, (this->*X)() );

     for (j = 0; j < numberOfNodes; j++)
        {
          dataTable(j) = processorArray[j];
        }

  // now delete the allocated data (from above)
     delete processorArray;
     processorArray = NULL;
#endif

     return dataTable;
   }

#if defined(PPP)
intSerialArray
#else
intArray
#endif
floatArray::buildProcessorMap ( floatArrayMemberIntegerFunctionPointerType X )
   {
  // This function builds a 3D array object representing the base/bound for each 
  // dimension of an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::buildProcessorMap() \n");
#endif

     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // The length 2 of the last dimension is to hold the base and bound
#if defined(PPP)
     intSerialArray dataTable (numberOfNodes,numberOfDimensions());
#else
     intArray dataTable (numberOfNodes,numberOfDimensions());
#endif

     int i = 0;
     int j = 0;
     for (j = 0; j < numberOfNodes; j++)
        {
       // initialize the table
          for (i = 0; i < numberOfDimensions(); i++)
             {
               dataTable(j,i) = 0;
             }
        }

#if defined(PPP)
     Communication_Manager::Sync();

  // temp storage (required for Communication_Manager::fillProcessorArray)
     int* processorArray = new int [numberOfNodes];
     APP_ASSERT (processorArray != NULL);

  // initialize the newly allocated space
     for (j = 0; j < numberOfNodes; j++)
        {
          processorArray[j] = 0;
        }

     for (i = 0; i < numberOfDimensions(); i++)
        {
       // fill in the local base and bound for each dimension (into the dataTable)
       // Communication_Manager::fillProcessorArray ( processorArray, getLocalBase(i) );
          Communication_Manager::fillProcessorArray ( processorArray, (this->*X)(i) );

          for (j = 0; j < numberOfNodes; j++)
             {
               dataTable(j,i) = processorArray[j];
             }
        }

  // now delete the allocated data (from above)
     delete processorArray;
     processorArray = NULL;
#endif

     return dataTable;
   }

void
floatArray::displayArraySizesPerProcessor (const char* Label)
   {
  // This function displays the number of points on each processor for an array object

#if COMPILE_DEBUG_STATEMENTS
     printf ("Inside of floatArray::displayArraySizesPerProcessor (%s) \n",Label);
#endif

#if defined(PPP)
     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // printf ("numberOfNodes = %d \n",numberOfNodes);

  // local storage to accumulate data to prior to display
     intSerialArray dataTable = buildProcessorMap ( &(floatArray::getLocalSize) );

  // dataTable.display("dataTable");

     int j = 0;

  // Turn OFF the mechanism that prints the node number before each output string!
     if (Communication_Manager::localProcessNumber() == 0)
        {
          Communication_Manager::setPrefixParallelPrintf(FALSE);
          printf ("***************************************************************** \n");
          printf ("Display of information about %s for each distribution of the array object \n",Label);
          printf ("***************************************************************** \n");

          printf ("Distribution of data: \n");
          for (j = 0; j < numberOfNodes; j++)
             {
            // Later handle threads separately
            // printf ("Node %3d ",localBase(i),localBound(i));
               printf ("Node: %3d: ",j);

               printf ("%3d ",dataTable(j));

               printf ("\n");
             }

          printf ("\n");
          printf ("\n");

       // Turn ON the mechanism that prints the node number before each output string!
          Communication_Manager::setPrefixParallelPrintf(TRUE);
        }
#endif
   }

#if defined(PPP)
intSerialArray
#else
intArray
#endif
floatArray::buildProcessorMap ( floatArrayMemberIntegerFunctionPointerType X, floatArrayMemberIntegerFunctionPointerType Y )
   {
  // This function builds a 3D array object representing the base/bound for each
  // dimension of an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::buildProcessorMap() \n");
#endif

     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // The length 2 of the last dimension is to hold the base and bound
#if defined(PPP)
     intSerialArray dataTable (numberOfNodes,numberOfDimensions(),2);
#else
     intArray dataTable (numberOfNodes,numberOfDimensions(),2);
#endif

#if 1
  // Express the version taking two function pointers 
  // in terms of the function taking one parameter

     Internal_Index all;
     dataTable(all,all,0) = buildProcessorMap(X);
     dataTable(all,all,1) = buildProcessorMap(Y);
#else
  // This is old code (remove it later)

     int i = 0;
     int j = 0;
     for (j = 0; j < numberOfNodes; j++)
        {
       // initialize the table
          for (i = 0; i < numberOfDimensions(); i++)
             {
               dataTable(j,i,0) = 0;
               dataTable(j,i,1) = 0;
             }
        }

#if defined(PPP)
     Communication_Manager::Sync();

  // temp storage (required for Communication_Manager::fillProcessorArray)
     int* processorArray = new int [numberOfNodes];
     APP_ASSERT (processorArray != NULL);

  // initialize the newly allocated space
     for (j = 0; j < numberOfNodes; j++)
        {
          processorArray[j] = 0;
        }

     for (i = 0; i < numberOfDimensions(); i++)
        {
       // fill in the local base and bound for each dimension (into the dataTable)
       // Communication_Manager::fillProcessorArray ( processorArray, getLocalBase(i) );
          Communication_Manager::fillProcessorArray ( processorArray, (this->*X)(i) );

          for (j = 0; j < numberOfNodes; j++)
             {
               dataTable(j,i,0) = processorArray[j];
             }
  
       // Communication_Manager::fillProcessorArray ( processorArray, getLocalBound(i) );
          Communication_Manager::fillProcessorArray ( processorArray, (this->*Y)(i) );
          for (j = 0; j < numberOfNodes; j++)
             {
               dataTable(j,i,1) = processorArray[j];
             }
        }

  // now delete the allocated data (from above)
     delete processorArray;
     processorArray = NULL;
#endif
#endif

     return dataTable;
   }


void
floatArray::displayPartitioning (const char* Label)
   {
  // This function displays the partitioning of the array object

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
          printf ("Inside of floatArray::displayPartitioning (%s) \n",Label);
#endif

#if defined(PPP)
     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // intSerialArray dataTable = buildProcessorMap ( getLocalBase, getLocalBound );
     intSerialArray dataTable = buildProcessorMap ( &(floatArray::getLocalBase), &(floatArray::getLocalBound) );

     int i = 0;
     int j = 0;

  // Turn OFF the mechanism that prints the node number before each output string!
     if (Communication_Manager::localProcessNumber() == 0)
        {
          Communication_Manager::setPrefixParallelPrintf(FALSE);
          printf ("***************************************************************** \n");
          printf ("Display of information about the distribution of the array object \n");
          printf ("***************************************************************** \n");

          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
             {
               Partitioning_Type::displayDefaultValues ();
             }
            else
             {
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->display ();
             }

          printf ("Distribution of data: \n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf ("      AXIS %d  ",i);
             }
          printf ("\n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf ("   base  bound");
             }
          printf ("\n");
          for (j = 0; j < numberOfNodes; j++)
             {
            // Later handle threads separately
            // printf ("Node %3d ",localBase(i),localBound(i));
               printf ("Node: %3d",j);
               bool locatedOnThisProcessor = TRUE;
               for (i = 0; i < numberOfDimensions(); i++)
                  {
                    if ( dataTable(j,i,0) > dataTable(j,i,1) )
                         locatedOnThisProcessor = FALSE;
                  }

               if (locatedOnThisProcessor == FALSE)
                  {
                    printf (" *****  NOT LOCATED ON THIS PROCESSOR  ***** ");
                  }
                 else
                  {
                    for (i = 0; i < numberOfDimensions(); i++)
                       {
                         printf ("   %3d   %3d  ",dataTable(j,i,0),dataTable(j,i,1));
                       }
                  }

               printf ("\n");
             }

          printf ("\n");
          printf ("\n");
          printf ("\n");

       // Turn ON the mechanism that prints the node number before each output string!
          Communication_Manager::setPrefixParallelPrintf(TRUE);
        }
#endif
   }

#if 1
void
floatArray::displayLeftRightNumberOfPoints (const char* Label)
   {
  // This function displays the LeftNumberOfPoints and the RightNumberOfPoints
  // for each processors partition of an array object.

#if COMPILE_DEBUG_STATEMENTS
     printf ("Inside of floatArray::displayLeftRightNumberOfPoints (%s) \n",Label);
#endif

#if defined(PPP)
     int numberOfNodes = Communication_Manager::numberOfProcessors();

  // local storage to accumulate data to prior to display
  // intSerialArray dataTable = buildProcessorMap ( getLeftNumberOfPoints, getRightNumberOfPoints );
     intSerialArray dataTable = buildProcessorMap ( &(floatArray::getLeftNumberOfPoints), &(floatArray::getRightNumberOfPoints) );

     int i = 0;
     int j = 0;

  // Turn OFF the mechanism that prints the node number before each output string!
     if (Communication_Manager::localProcessNumber() == 0)
        {
          Communication_Manager::setPrefixParallelPrintf(FALSE);
          printf ("***************************************************************** \n");
          printf ("Display of information about %s for each distribution of the array object \n",Label);
          printf ("***************************************************************** \n");

#if 0
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
             {
               Partitioning_Type::displayDefaultValues ();
             }
            else
             {
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->display ();
             }
#endif

          printf ("Distribution of data: \n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf ("      AXIS %d  ",i);
             }
          printf ("\n");
          printf ("         ");
          for (i = 0; i < numberOfDimensions(); i++)
             {
               printf (" LeftNumberOfPoints RightNumberOfPoints");
             }
          printf ("\n");
          for (j = 0; j < numberOfNodes; j++)
             {
            // Later handle threads separately
            // printf ("Node %3d ",localBase(i),localBound(i));
               printf ("Node: %3d",j);
               bool locatedOnThisProcessor = TRUE;

               if (locatedOnThisProcessor == FALSE)
                  {
                    printf (" *****  NOT LOCATED ON THIS PROCESSOR  ***** ");
                  }
                 else
                  {
                    for (i = 0; i < numberOfDimensions(); i++)
                       {
                         printf ("        %3d                 %3d  ",dataTable(j,i,0),dataTable(j,i,1));
                       }
                  }

               printf ("\n");
             }

          printf ("\n");
          printf ("\n");
          printf ("\n");

       // Turn ON the mechanism that prints the node number before each output string!
          Communication_Manager::setPrefixParallelPrintf(TRUE);
        }
#endif
   }
#endif

#if 0
int
floatArray::getNumberOfMessageSent ()
   {
  // This function builds a 3D array object representing the communication done on
  // an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::buildProcessorMap() \n");
#endif

     return Diagnostic_Manager::getNumberOfMessagesSent();
   }

int
floatArray::getGlobalNumberOfMessageSent ()
   {
  // This function builds a 3D array object representing the communication done on
  // an array object on each processor.  It requires communication
  // which is handled by the Communication_Manager::fillProcessorArray() function.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::buildProcessorMap() \n");
#endif

     return Diagnostic_Manager::getNumberOfMessagesSent();
   }
#endif

#if defined(PPP) && defined(USE_PADRE)
void
floatArray::setLocalDomainInPADRE_Descriptor ( SerialArray_Domain_Type *inputDomain ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::setLocalDomainInPADRE_Descriptor(%p) \n",inputDomain);
#endif

     Array_Descriptor.setLocalDomainInPADRE_Descriptor(inputDomain);
   }
#endif

floatArray & 
floatArray::partition ( const doubleArray & Example_Array )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::partition (const doubleArray & Example_Array) \n");
#endif

     return partition ( Example_Array.getPartition() );
   }

floatArray &
floatArray::partition ( const floatArray & Example_Array )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::partition (const floatArray & Example_Array) \n");
#endif

     return partition ( Example_Array.getPartition() );
   }

floatArray & floatArray::partition ( const intArray & Example_Array )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::partition (const intArray & Example_Array) \n");
#endif

     return partition ( Example_Array.getPartition() );
   }
#endif

#if defined(APP) || defined(PPP)
int
floatArray::getGhostBoundaryWidth ( int Axis ) const
   {
  // The returns the Array_Descriptor.Array_Domain.InternalGhostCellWidth[Axis]
     int width = Array_Descriptor.getGhostBoundaryWidth(Axis);
  // The ghost boundary width of an array need not match that of it's
  // partitioning object since the arrays ghost boundary width can be
  // reset seperate from the partitioning
  // APP_ASSERT (width == getInternalGhostCellWidth(Axis));
     return width;
   }
#endif

#if defined(APP) || defined(PPP)
// Depreciated function (not documented in manual)
int
floatArray::getInternalGhostCellWidth ( int Axis ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 9)
          printf ("Inside of floatArray::getInternalGhostCellWidth (int Axis) \n");
#endif

#if defined(PPP)
  // APP_ASSERT (Array_Descriptor != NULL);
     return Array_Descriptor.Array_Domain.InternalGhostCellWidth[Axis];
#else
     static int Dummy_Integer = 0;
     return Dummy_Integer;
#endif
   }

floatArray &
floatArray::setGhostCellWidth ( Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
     return setInternalGhostCellWidth (Integer_List);
   } 

floatArray &
floatArray::setGhostCellWidth ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of floatArray::setGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif

     setGhostCellWidth(Integer_List);
     return *this;
   }

floatArray &
floatArray::setGhostCellWidthSaveData ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of floatArray::setGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
#if defined(PPP)
  // Save old Serial array so that this operation does not distroy data (or decide if it should or not)
  // printf ("Old data not saved as a result of call to floatArray::setInternalGhostCellWidth \n");
  // If we work on the serial arrays directly then we can avoid a temporary limitation of P++
  // in which the operands of a binary operand must have the same ghost cell widths.
  // floatArray Temporary_Copy = *this;
     floatSerialArray Temporary_Copy = *Array_Descriptor.SerialArray;

     setGhostCellWidth(Integer_List);

  // This brings out a bug in P++ which does not permit operations
  // between operands with different size ghost boundaries.
  // printf ("SORRY NOT IMPLEMENTED, floatArray::setInternalGhostCellWidthSaveData is not implemented yet! \n");
  // APP_ABORT();

  // copy previous data back into new array so that data is preserved.
     *Array_Descriptor.SerialArray = Temporary_Copy;

  // Now update the ghost boundaries with the interior edges of the adjacent processors (if distributed)
     updateGhostBoundaries();
#endif
     return *this;
   }


// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setInternalGhostCellWidth
// Interface of A++/P++: P++ specific (Does nothing within A++)
// Complexity: Constant
// Purpose: permit dynamic adjustment of ghost cell 
//          widths along each dimension.  This function 
//          is a helper function for the interface function.
// ******************************************************
// ******************************************************
floatArray &
floatArray::setInternalGhostCellWidth ( Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of floatArray::setInternalGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
#if defined(PPP)
  // Save old Serial array so that this operation does not distroy data (or decide if it should or not)
     //printf ("Old data not saved as a result of call to floatArray::setInternalGhostCellWidth \n");

  // SerialArray_Descriptor_Type *Old_Serial_Array_Descriptor = NULL;
     if ( getRawDataReferenceCount() == getRawDataReferenceCountBase() )
        {
#if defined(PPP) && defined(USE_PADRE)
       // We have to remove the references in PADRE to the Serial_Array object
       // which is being deleted.  This is a consequence of P++ using PADRE in a way
       // so as to prevent the redundent storage of Array_Domain objects 
       // (specifically we use PADRE in a way so that only references are stored).
          setLocalDomainInPADRE_Descriptor(NULL);
#endif
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
       // printf ("BEFORE delete in setInternalGhostCellWidth: Array_Descriptor.SerialArray->getReferenceCount() = %d \n",
       //      Array_Descriptor.SerialArray->getReferenceCount());
       // Array_Descriptor.SerialArray->view("In setInternalGhostCellWidth");
          Array_Descriptor.SerialArray->decrementReferenceCount();
          if (Array_Descriptor.SerialArray->getReferenceCount() < getReferenceCountBase())
               delete Array_Descriptor.SerialArray;
          Array_Descriptor.SerialArray = NULL;
       // printf ("Exiting in setInternalGhostCellWidth \n");
       // APP_ABORT();
        }
       else
        {
          printf ("ERROR: Existing references exit to the present array data (can't change in floatArray::setInternalGhostCellWidth)! \n");

       // We exit here -- but we don't have to do so (this is temporary code)!
          APP_ABORT();
        }

     Array_Descriptor.setInternalGhostCellWidth(Integer_List);
  // view("BEFORE REALLOCATION");

  // Now reallocate the data using the descriptor that has has its InternalGhostCellWidth modified
  // Allocate_Parallel_Array (TRUE);
     Allocate_Array_Data (TRUE);
  // MDI_float_Allocate(SerialArray->Array_Descriptor);
  // view("AFTER REALLOCATION");

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from inside of floatArray::setInternalGhostCellWidth");
#endif

  // Now update the ghost boundaries with the interior edges of the adjacent processors (if distributed)
  // updateGhostBoundaries();
#endif
     return *this;
   }

// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setInternalGhostCellWidth
// Interface of A++/P++: P++ specific (Does nothing within A++)
// Complexity: Constant
// Purpose: permit dynamic adjustment of ghost cell 
//          widths along each dimension.
// ******************************************************
// ******************************************************
floatArray &
floatArray::setInternalGhostCellWidth ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of floatArray::setInternalGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
     setInternalGhostCellWidth(Integer_List);
     return *this;
   }

// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setInternalGhostCellWidthSaveData
// Interface of A++/P++: P++ specific (Does nothing within A++)
// Complexity: Constant
// Purpose: permit dynamic adjustment of ghost cell 
//          widths along each dimension. This function 
//          saves and recopies the data after changing
//          the ghost cell widths.  As a final step it
//          updates the ghost boundaries to force a 
//          consistant representation of the data.
// ******************************************************
// ******************************************************
floatArray &
floatArray::setInternalGhostCellWidthSaveData ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of floatArray::setInternalGhostCellWidth -- \n");
          int temp;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf ("%d ",Integer_List[temp]);
          printf (" \n");
        } 
#endif
     
#if defined(PPP)
  // Save old Serial array so that this operation does not distroy data (or decide if it should or not)
  // printf ("Old data not saved as a result of call to floatArray::setInternalGhostCellWidth \n");
  // If we work on the serial arrays directly then we can avoid a temporary limitation of P++
  // in which the operands of a binary operand must have the same ghost cell widths.
  // floatArray Temporary_Copy = *this;
     floatSerialArray Temporary_Copy = *Array_Descriptor.SerialArray;

     setInternalGhostCellWidth(Integer_List);

  // This brings out a bug in P++ which does not permit operations
  // between operands with different size ghost boundaries.
  // printf ("SORRY NOT IMPLEMENTED, floatArray::setInternalGhostCellWidthSaveData is not implemented yet! \n");
  // APP_ABORT();

  // copy previous data back into new array so that data is preserved.
     *Array_Descriptor.SerialArray = Temporary_Copy;

  // Now update the ghost boundaries with the interior edges of the adjacent processors (if distributed)
     updateGhostBoundaries();
#endif
     return *this;
   }

// ******************************************************
// ******************************************************
// ******************************************************
// MEMBER FUNCTION: getExternalGhostCellWidth
// Purpose:  access function for ghost cell width for 
//           each axis.
// ******************************************************
// ******************************************************
int
floatArray::getExternalGhostCellWidth ( int Axis ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::getExternalGhostCellWidth (int Axis) \n");
#endif

#if defined(PPP)
  // APP_ASSERT (Array_Descriptor != NULL);
     return Array_Descriptor.Array_Domain.ExternalGhostCellWidth[Axis];
#else
     static int Dummy_Integer = 0;
     return Dummy_Integer;
#endif
   }

// ******************************************************
// ******************************************************
// MEMBER FUNCTION: setExternalGhostCellWidth
// Purpose: This function represents access to a feature 
//          within BlockParti.  It is disabled since this
//          feature of BlockParti is not an important part 
//          of P++ at this time.  The idea is that both
//          Internal AND External boundaries can be 
//          constructed The internal ones represent ghost 
//          boundaries and the external ones represent
//          extended boundaries as required for overlap 
//          between seperate blocks (for multi block 
//          solution methods).
// ******************************************************
// ******************************************************
//floatArray & floatArray::setExternalGhostCellWidth ( int Width_I, int Width_J, int Width_K, int Width_L )
//floatArray & floatArray::setExternalGhostCellWidthSaveData ( ARGUMENT_LIST_MACRO_INTEGER )
floatArray &
floatArray::setExternalGhostCellWidth ( ARGUMENT_LIST_MACRO_INTEGER )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::setExternalGhostCellWidth \n");
#endif
  // Avoid compiler warnings about unused input variables
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO
     if (&Integer_List);

#if defined(PPP)
     printf ("External Ghost Cell Widths currently not implemented in P++! \n");
     printf ("Exiting ... \n");
     APP_ABORT();

   //APP_ASSERT (Array_Descriptor != NULL);
     /*
     Array_Descriptor.ExternalGhostCellWidth[0] = Width_I;
     Array_Descriptor.ExternalGhostCellWidth[1] = Width_J;
     Array_Descriptor.ExternalGhostCellWidth[2] = Width_K;
     Array_Descriptor.ExternalGhostCellWidth[3] = Width_L;
     */

#if defined(USE_PADRE)
  // What PADRE function do we use here?
     printf ("NEED TO CALL PADRE \n"); APP_ABORT();
#else
     Array_Descriptor.Array_Domain.BlockPartiArrayDomain = Array_Descriptor.Build_BlockPartiArrayDomain();
#endif
#endif
     return *this;
   }

void
floatArray::updateGhostBoundaries() const
   {
  // The function body is not defined for A++ or SerialArray objects
#if defined(PPP)
     if (!isNullArray())
        {
          APP_ASSERT (Array_Descriptor.SerialArray != NULL);
       // Internal_Partitioning_Type::updateGhostBoundaries (*this,*Array_Descriptor.SerialArray);
#if defined(USE_PADRE)
          APP_ASSERT (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL);
          if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
             {
               Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->updateGhostBoundaries(getDataPointer());
             }
#else
          Internal_Partitioning_Type::updateGhostBoundaries (*this,*Array_Descriptor.SerialArray);
#endif
        }
#endif
   }

#endif




// *************************************************************
// Forces a temporary to become a nontemporay.
// If it was a temporary the its data is placed into another floatArray
// so that no coping is done.  If it was not a temporary then it is
// just passed though (nothing is done!).
// *************************************************************
floatArray
evaluate ( const floatArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::evaluate! \n");
#endif

#if EXTRA_ERROR_CHECKING
  // error checking (since I think this might be a problem for deferred evaluation)!
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
          printf ("ERROR: evaluate used while Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION == TRUE \n");
          printf ("Evaluate for DEFER_EXPRESSION_EVALUATION == TRUE -- Sorry, not implemented yet ... \n");
          APP_ABORT();
        }
#endif

  // Bug fix (12/1/93) we have to call the copy constructor in both cases since
  // the input might be referenced after the evaluate function is called.  
  // Though this is not possible in the case of a temporary -- except for the 
  // case of: floatArray & X = A+B;  which can be referenced after evaluate (X)
  // but that is a little bit pathological for any array class that tries to
  // manage temporaries (and the point is that the user should use this function) 
  // so we would write floatArray & X = evaluate(A+B); with no performance penalty
  // from the evaluate function (since not copying is done).

     return floatArray ( X );  // call copy constructor!
   }

#if !defined(PPP)
// *************************************************************
// Fixup User_Base so scalar indexing is consistent between processors.
// This means that a ghost cell will be accessed by the same subscript
// on either processor if it lies on both.
// *************************************************************
void
floatArray::Fixup_User_Base 
   ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_Pointer_List ,
     const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Local_Index_Pointer_List )
   {
     int i;
     for (i=0; i < MAX_ARRAY_DIMENSION; i++)
        {
          if (Local_Index_Pointer_List[i] != NULL)
             {
            // ... Don't reset User_Base unless Index_Triplet ...
               if (Local_Index_Pointer_List[i]->Index_Mode == Index_Triplet)
                  {
                 // (2/3/2000) Catch the case where the stride does not divide into the difference of the two 
                 // bases evenly since this should cause an error internally
                    APP_ASSERT ( (Local_Index_Pointer_List[i]->Base - Index_Pointer_List[i]->Base) % Index_Pointer_List[i]->Stride == 0);
	            int offset = (Local_Index_Pointer_List[i]->Base - Index_Pointer_List[i]->Base) /  Index_Pointer_List[i]->Stride;

                 // printf ("In floatArray::Fixup_User_Base(): axis = %d View_Offset = %d offset = %d \n",
                 //      i,Array_Descriptor.Array_Domain.View_Offset,offset);

                    Array_Descriptor.Array_Domain.User_Base[i] = Index_Pointer_List[i]->Base + offset;
	            if (i==0)
                         Array_Descriptor.Array_Domain.Scalar_Offset[0] = 
                              Array_Descriptor.Array_Domain.View_Offset -
                                   Array_Descriptor.Array_Domain.User_Base[0] *
                                   Array_Descriptor.Array_Domain.Stride[0];
                      else
                         Array_Descriptor.Array_Domain.Scalar_Offset[i] =
                              Array_Descriptor.Array_Domain.Scalar_Offset[i-1] -
                                   Array_Descriptor.Array_Domain.User_Base[i] *
                                   Array_Descriptor.Array_Domain.Stride[i] *
                                   Array_Descriptor.Array_Domain.Size[i-1];
                  }
             }
            else
             {
            // printf ("In floatArray::Fixup_User_Base(): Local_Index_Pointer_List[%d] != NULL \n",i);
             }

       // printf ("In floatArray::Fixup_User_Base(): Array_Descriptor.Array_Domain.Scalar_Offset[%d] = %d \n",
       //      i,Array_Descriptor.Array_Domain.Scalar_Offset[i]);
        }

     POINTER_LIST_INITIALIZATION_MACRO;
   }
#endif

// *************************************************************
// This function checks the internal consistancy of A++ objects
// *************************************************************
void
floatArray::Test_Consistency( const char *Label ) const 
   {
  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since floatArray::Test_Consistency (%s) was called! \n",Label);
     APP_ABORT();
#endif

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 5)
          printf ("Inside of floatArray::Test_Consistency! (Label = %s) \n",Label);
#if defined(PPP)
   if (Optimization_Manager::Optimize_Scalar_Indexing == FALSE)
     Communication_Manager::Sync();
#endif
#endif

  // int temp;

  // Check that these are the correct values since on some machines
  // (like the HP) they can be initialized in a strange order (see 
  // note at top of file)
     APP_ASSERT (DECIMAL_DISPLAY_FORMAT     == 0);
     APP_ASSERT (EXPONENTIAL_DISPLAY_FORMAT == 1);
     APP_ASSERT (SMART_DISPLAY_FORMAT       == 2);
     APP_ASSERT (DISPLAY_FORMAT             == 2);

  // error checking!
  // APP_ASSERT(Array_Descriptor != NULL);
  // if (Array_Descriptor == NULL)
  //    {
  //      printf ("ERROR: Array_Descriptor == NULL in floatArray::Test_Consistency \n");
  //      APP_ABORT();
  //    }

#if defined(APP) || defined(SERIAL_APP)
  // This fails on 3 processors but passes on 1 and two processors
  // this makes no sense so I have commented it out for now!
     if ( (sizeof(int_array) != sizeof(floatArray)) || (1 == 2) )
        {
#if 1
          printf ("sizeof(int_array) = %d \n",sizeof(int_array) );
          printf ("Address of int_array.Array_Descriptor = %p \n",&(((int_array*) this)->Array_Descriptor) );
          printf ("sizeof(floatArray) = %d \n",sizeof(floatArray) );
          printf ("Address of START this       = %p \n",this);
          printf ("Address of Array_Descriptor = %p \n",&Array_Descriptor);
          printf ("Address of Array_Storage    = %p \n",&Array_Storage);
          printf ("Address of freepointer      = %p \n",&freepointer);
          printf ("Address of referenceCount   = %p \n",&referenceCount);
#endif
          printf ("sizeof(array_domain) = %d  sizeof(Array_Domain_Type) = %d \n",
               sizeof(array_domain),sizeof(Array_Domain_Type));
          printf ("sizeof(int_array) = %d  !=  sizeof(floatArray) = %d \n",
               sizeof(int_array),sizeof(floatArray));
        }
#endif
#if defined(APP) || defined(SERIAL_APP)
     APP_ASSERT ( sizeof(int_array) == sizeof(floatArray) );
#endif

  // We can't test this unless it appears in the users code.  I don't know why this is this way.
  // We can if it is forced to be included as it is now (I think).
  // But if other application libraries have static arrays we cannot be sure of the
  // order of the call to the constructors and since this function is called within
  // the constructors the constructors might be called before the APP_Unit_Range is setup.
  // We hope that just not calling this here will fix the problem but actually it would
  // seem that the array object built via static constructors could in theory be built
  // incorrectly.  We have to wait and see if this is a bug that we have to fix better.
	    
  //APP_Unit_Range.Test_Consistency("Test of APP_Unit_Range in floatArray::Test_Consistency");

  // Consistancy checking specific to the array descriptor was moved to a member
  // function of that class (the way it should be done) (30/12/94)
     Array_Descriptor.Test_Consistency(Label);

  // printf ("PASSED: Call to Array_Descriptor.Test_Consistency(%s) \n",Label);

  // printf ("Test 0.4 \n");
  // check for illegal values in the reference counts
     APP_ASSERT(referenceCount >= getReferenceCountBase());

  // printf ("Test 0.5 \n");
  // printf ("getfloatArrayPointer() = %p \n",getfloatArrayPointer());
  // printf ("Test 0.6 \n");

  // I just changed the way that reference counting is done -- specifically the reference counting 
  // of the Serial_A++ objects in P++ is handled the same was as the A++ object reference count the
  // raw data arrays which they use.  The makes A++ to P++ the same as raw C arrays are to A++
  // and with VERY similar control code and reference counting properties (maybe exactly the same).
  // In addition each A++/P++ object can be referenced using another referenceCount (this is design for use by the
  // user applications and is not touched internally in A++/P++ (mearly provided as a feature)). 

  // printf ("Test 1 \n");
  // printf ("Exiting ... \n");
  // APP_ABORT();

#if defined(USE_EXPRESSION_TEMPLATES)
     int ExpectedOffset = 0;
     if (usesIndirectAddressing() == FALSE)
        {
          ExpectedOffset = Array_Descriptor.Array_Domain.Base[0];
          for (int i=1; i < MAX_ARRAY_DIMENSION; i++)
             {
               ExpectedOffset += Array_Descriptor.Array_Domain.Base[i] * Array_Descriptor.Array_Domain.Size[i-1];
             }
        }
     if (Array_Descriptor.Array_Domain.ExpressionTemplateOffset != ExpectedOffset)
        {
          printf ("ERROR: Array_Descriptor.Array_Domain.ExpressionTemplateOffset != ExpectedOffset \n");
          printf ("Array_Descriptor.Array_Data                            = %p \n",Array_Descriptor.Array_Data);
          printf ("Array_Descriptor.ExpressionTemplateDataPointer         = %p \n",Array_Descriptor.ExpressionTemplateDataPointer);
          printf ("Array_Descriptor.Array_Domain.ExpressionTemplateOffset = %d \n",Array_Descriptor.Array_Domain.ExpressionTemplateOffset);
          printf ("ExpectedOffset                                         = %d \n",ExpectedOffset);
          Array_Descriptor.display("ERROR in floatArray<T,Template_Dimension>::Test_Consistency()");
       // APP_ABORT();
        }
     APP_ASSERT (Array_Descriptor.Array_Domain.ExpressionTemplateOffset == ExpectedOffset);
     if (Array_Descriptor.Array_Data != NULL)
        {
          if (Array_Descriptor.ExpressionTemplateDataPointer != Array_Descriptor.Array_Data+ExpectedOffset)
             {
               printf ("ERROR: Array_Descriptor.ExpressionTemplateDataPointer != Array_Descriptor.Array_Data+ExpectedOffset \n");
               printf ("Array_Descriptor.Array_Data                            = %p \n",Array_Descriptor.Array_Data);
               printf ("Array_Descriptor.ExpressionTemplateDataPointer         = %p \n",Array_Descriptor.ExpressionTemplateDataPointer);
               printf ("Array_Descriptor.Array_Domain.ExpressionTemplateOffset = %d \n",Array_Descriptor.Array_Domain.ExpressionTemplateOffset);
               printf ("ExpectedOffset                                         = %d \n",ExpectedOffset);
               Array_Descriptor.display("ERROR in floatArray<T,Template_Dimension>::Test_Consistency()");
            // APP_ABORT();
             }
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer == Array_Descriptor.Array_Data+ExpectedOffset);
        }
#endif

#if defined(PPP)
  // We had to build a way for P++ to tell other libraries (like PARTI) now many
  // processors we have and it is important that these stay sync'd (so we test them here).
  // APP_ASSERT (Global_PARTI_P_plus_plus_Interface_Number_Of_Processors == Communication_Manager::Number_Of_Processors);

  // We always want a vaild SerialArray even if it is a NULL Array
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);

     Array_Descriptor.SerialArray->Test_Consistency(Label);

// ... (12/15/96,kdb) this might not be true in some cases because the
//  output of the overlapping boundary model might produce a null array
//  for the serialArray that is used temporarily for a conformable operation ...
#if 0
     if (Array_Descriptor.SerialArray->isNullArray() == TRUE)
        {
           int i;
           for (i=0; i < MAX_ARRAY_DIMENSION; i++)
              {
                if (Array_Descriptor.Array_Domain.Local_Mask_Index [i].getMode() != Null_Index)
                   {
                     printf ("Exiting from floatArray::Test_Consistency (%s) \n",Label);
                   }
                APP_ASSERT(Array_Descriptor.Array_Domain.Local_Mask_Index [i].getMode() == Null_Index);
              }
        }
#endif

  // This is not a valid test (even after the corrction for Is_A_Null_Array) since any indexed
  // region might have a middle processor subregion for which Is_Contiguous_Data is TRUE even if the
  // global array (since it is indexed and a subregion) has Is_Contiguous_Data set to FALSE.
  // APP_ASSERT ( Array_Descriptor.Is_Contiguous_Data == Array_Descriptor.SerialArray->Array_Descriptor.Is_Contiguous_Data );
  // if ( Array_Descriptor.SerialArray->Array_Descriptor.Is_A_Null_Array == FALSE )
  //    {
  //      APP_ASSERT ( Array_Descriptor.Is_Contiguous_Data == Array_Descriptor.SerialArray->Array_Descriptor.Is_Contiguous_Data );
  //    }

  // If one is a temporary then the other must be marked as a temporary (so we check it)
     if (Array_Descriptor.isTemporary() != 
	 Array_Descriptor.SerialArray->isTemporary())
        {
          printf ("ERROR: Array_Descriptor.Is_A_Temporary = %s BUT SerialArray->Array_Descriptor.Is_A_Temporary = %s \n",
             (Array_Descriptor.isTemporary()) ? "TRUE" : "FALSE" ,
             (Array_Descriptor.SerialArray->isTemporary()) ? "TRUE" : "FALSE" );
          APP_ABORT();
        }

  // All P++ objects should have a valid pointer to a partitioning object (they may be multiply referenced)
  // Actally if they use the default partitioning then the pointer is NULL (Is this a good implementation?)
  // APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL);

  // We have to skip some of these tests if we have a Null_Array
     int i = 0;
     if (Array_Descriptor.isNullArray() == FALSE)
        {
       // Some tests can only be done for the case of a single processor
          if (Communication_Manager::Number_Of_Processors == 1)
             {
            // This is the case of P++ on a single processor!
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 9)
                  {
                 // view("Called from inside of floatArray::Test_Consistency");
                    printf ("getLength(0) = %d getLength(1) = %d getLength(2) = %d getLength(3) = %d \n",
                              getLength(0),getLength(1),getLength(2),getLength(3));
                    printf ("SerialArray->getLength(0) = %d SerialArray->getLength(1) = %d SerialArray->getLength(2) = %d SerialArray->getLength(3) = %d \n",
                              Array_Descriptor.SerialArray->getLength(0),
			      Array_Descriptor.SerialArray->getLength(1),
			      Array_Descriptor.SerialArray->getLength(2),
			      Array_Descriptor.SerialArray->getLength(3));
                    printf ("getInternalGhostCellWidth(0) = %d getInternalGhostCellWidth(1) = %d getInternalGhostCellWidth(2) = %d getInternalGhostCellWidth(3) = %d \n",
                              getInternalGhostCellWidth(0),
			      getInternalGhostCellWidth(1),
			      getInternalGhostCellWidth(2),
			      getInternalGhostCellWidth(3));
                  }
#endif

               for (i=0; i < Array_Descriptor.Array_Domain.Domain_Dimension; i++)
                  {
                    int Offset_For_Ghost_Boundary_Width = 
                         (Array_Descriptor.isView() == TRUE) ? 0 : getInternalGhostCellWidth(0);
#if 1
                 // redundant test with the APP_ASSERTion below
                 // if ( getLength(i) != Array_Descriptor.SerialArray->getLength(i) - 2 * Offset_For_Ghost_Boundary_Width )
                    if ( getLength(i) != Array_Descriptor.SerialArray->getLength(i) )
                       {
                         printf ("Offset_For_Ghost_Boundary_Width = %d \n",Offset_For_Ghost_Boundary_Width);
                         printf ("getLength(%d) = %d  != Array_Descriptor.SerialArray->getLength(%d) = %d \n",
                              i,getLength(i),i,Array_Descriptor.SerialArray->getLength(i));
                         printf ("getInternalGhostCellWidth(%d) = %d \n",i,getInternalGhostCellWidth(i));
                         view("This from Test_Consistency #1");
                         APP_ABORT();
                       }
#endif

                 // True only of the case on a single processor 
                 // Bug fix (1/12/95) fixed case with nonzero ghost boundary widths
                 // APP_ASSERT( getLength(i) == Array_Descriptor.SerialArray->getLength(i) - 2 * Offset_For_Ghost_Boundary_Width );
                    APP_ASSERT( getLength(i) == Array_Descriptor.SerialArray->getLength(i) );

                 // printf ("Exiting from inside of floatArray::Test_Consistency \n");
                 // APP_ABORT();

#if 1
                 // redundant test with the APP_ASSERTion below
                 // if ( getBase(i) != SerialArray->getBase(i) + Offset_For_Ghost_Boundary_Width )
                    if (getRawBase(i) != Array_Descriptor.SerialArray->getRawBase(i))
                       {
                         printf ("In floatArray::Test_Consistency -- getRawBase(%d) = %d  != SerialArray->getRawBase(%d) = %d \n",
                                   i,getRawBase(i),i,
				   Array_Descriptor.SerialArray->getRawBase(i));
                                /* getLength(i),Array_Descriptor.SerialArray->getLength(i); */
                         printf ("Offset_For_Ghost_Boundary_Width = %d \n",Offset_For_Ghost_Boundary_Width);
                         view("This from Test_Consistency #2");
                         APP_ABORT();
                       }
#endif
                 // APP_ASSERT( getBase(i) == Array_Descriptor.SerialArray->getBase(i) + Offset_For_Ghost_Boundary_Width );
                    if ( getRawBase(i) != Array_Descriptor.SerialArray->getRawBase(i) )
                       {
                         display("ERROR: getRawBase(i) != Array_Descriptor.SerialArray->getRawBase(i)");
                       }
                    APP_ASSERT( getRawBase(i) == Array_Descriptor.SerialArray->getRawBase(i) );
                    if ( getRawBound(i) != Array_Descriptor.SerialArray->getRawBound(i) )
                       {
                         view("ERROR: getRawBound(i) != Array_Descriptor.SerialArray->getRawBound(i)");
                       }
                    APP_ASSERT( getRawBound(i) == Array_Descriptor.SerialArray->getRawBound(i) );
                  }
             }

// if defined(USE_PADRE)
#if 1
       // What PADRE function do we use here?
       // printf ("NEED TO CALL PADRE \n"); APP_ABORT();
       // PADRE specefic error checking is done in the P++ objects containing PADRE objects.

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
          printf ("In Array::Test_Consistency(): Significant error checking commented out due to unresolved conflict in cvs update! \n");
#endif

#else
       // If the PARTI descriptor is availabel we can do error checking on it
       // if (Array_Descriptor.Array_Domain.BlockPartiArrayDomain != NULL)
          if ( (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain() != NULL) && (Array_Descriptor.SerialArray->isNullArray() == FALSE) )
             {
            // Error checking must be done in the array member function because it uses
            // the getBase array member function.
#if 0
               int Sizes[MAX_ARRAY_DIMENSION];
               laSizes( Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),Sizes);
               printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points[0] = %d \n",
                    Array_Descriptor.Array_Domain.Array_Domain.Left_Number_Of_Points[0]);
               printf ("Sizes[0] = %d  Sizes[1] = %d Sizes[2] = %d Sizes[3] = %d \n",
                    Sizes[0],Sizes[1],Sizes[2],Sizes[3]);
               printf ("getRawBase(0) = %d getRawBase(1) = %d getRawBase(2) = %d getRawBase(3) = %d \n",
                    getRawBase(0),getRawBase(1),getRawBase(2),getRawBase(3));
               printf ("getLocalRawBase(0) = %d getLocalRawBase(1) = %d getLocalRawBase(2) = %d getLocalRawBase(3) = %d \n",
                    getLocalRawBase(0),getLocalRawBase(1),getLocalRawBase(2),getLocalRawBase(3));
#endif

               if (!Array_Descriptor.Array_Domain.Uses_Indirect_Addressing)
	       {
               // Make sure that the dimension of the PARTI descriptor matches 
	       // that of the P++ descriptor!
                  APP_ASSERT 
		     (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain()
		      ->nDims == Array_Descriptor.Array_Domain.Domain_Dimension );
                  APP_ASSERT 
		     (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain()
		      ->nDims == 
		      floatArray_Descriptor_Type
		      ::computeArrayDimension (Array_Descriptor) );
	       }

               for (i=0; i < Array_Descriptor.Array_Domain.Domain_Dimension; i++)
                  {
                 // Skip error checking in case of gLBnd(Array_Descriptor->BlockPartiArrayDomain,i) < 0 
                 // -1 is the error code returned by the PARTI library (meaning that the dimension was out of range)
                 // (Actually meaning that the data is not owned by this processor).
#if 1
                    int PARTI_Parallel_Descriptor_Lower_Bound = gLBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i);
#else
                 // The following modification to the PARTI_Parallel_Descriptor_Lower_Bound variable allows
                 // for the case where a non unit stride makes the first local Index of a view different
                 // from the position of first element of the local partition.  It is important only for 
                 // views which have non unit stride!
                    APP_ASSERT (SerialArray);
                 // APP_ASSERT (SerialArray->Array_Descriptor);
                    int PARTI_Parallel_Descriptor_Lower_Bound = gLBnd
		       (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(), i) 
		       +Array_Descriptor.SerialArray->Array_Descriptor.
			Array_Domain.Base[i];
#endif
                 // Trap out error return value for PARTI gLBnd
                    if ( PARTI_Parallel_Descriptor_Lower_Bound == -1 )
                       {
                         printf ("No array data located on this processor! \n");
                         printf ("Axis = %d  gLBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i) = %d \n",
                              i,gLBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i));
                       }
                 // APP_ASSERT (PARTI_Parallel_Descriptor_Lower_Bound != -1);
                    if ( PARTI_Parallel_Descriptor_Lower_Bound != -1 )
                       {
                         if (Array_Descriptor.isLeftPartition(i))
                            {
                              if ( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] != 0 )
                                 {
                                   printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Left_Number_Of_Points[i]);
                                   printf ("PARTI_Parallel_Descriptor_Lower_Bound  (for Axis = %d) = %d \n",i,PARTI_Parallel_Descriptor_Lower_Bound );
                                   printf ("Array_Descriptor.Array_Domain.Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Base[i]);
                                   printf ("Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Data_Base[i]);
                                   view ("ERROR: Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == PARTI_Parallel_Descriptor_Lower_Bound - Array_Descriptor.Array_Domain.Base[i]");
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == 0 );
                            }
                           else
                            {
                           // When the right or middle processor is close enough to the left edge of the left most processor
                           // (as in when the number of array elements is approximately the number of processors).
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (Array_Descriptor->Base[i] + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]);
                           // Divide the ghost boudary width by the Strid to compute it's contribution to the Left_Number_Of_Points
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (Array_Descriptor->Base[i] + (Array_Descriptor.Array_Domain.InternalGhostCellWidth[i] / Array_Descriptor->Stride[i]));

                           // The following logic supports the error checking of the Left_Number_Of_Points and is complex
                           // because it accounts for the interdependence of the partitioning and the stride of access.
                           // Basically if the partitioning is such that the added ghost boundary width is greater
                           // than or equal to the stride then the Left_Number_Of_Points is decremented.  This relationship
                           // is very simple if the stride is 1 but this code must handle the more general cases.
#if 0
                           // int Remainder = (PARTI_Parallel_Descriptor_Lower_Bound - Array_Descriptor->Base[i]) % Array_Descriptor->Stride[i];
                              int Stride = Array_Descriptor->Stride[i];
                           // int Remainder = (Stride - 1) - (PARTI_Parallel_Descriptor_Lower_Bound % Stride);
                              int Remainder = (Stride - 1) - (PARTI_Parallel_Descriptor_Lower_Bound % Stride);
                           // int Offset_For_Stride = ((Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) >= Array_Descriptor->Stride[i]) ? 1 : 0;
                              int Offset_For_Stride = Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i];
                              Offset_For_Stride = (Offset_For_Stride >= Array_Descriptor.Array_Domain.Stride[i]) ? 
                                                  Offset_For_Stride : 0;
                              APP_ASSERT ( Offset_For_Stride >= 0 );
                           // APP_ASSERT ( Offset_For_Stride <= Array_Descriptor.Array_Domain.Stride[i] );
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (Array_Descriptor->Base[i] + Offset_For_Stride);
                           // int Computed_Left_Number_Of_Points = PARTI_Parallel_Descriptor_Lower_Bound - Offset_For_Stride;
                           // Computed_Left_Number_Of_Points = (Computed_Left_Number_Of_Points >= 0) ? Computed_Left_Number_Of_Points : 0;
#else
#if 0
                           // int Temp_Computed_Left_Number_Of_Points = 
                           //      PARTI_Parallel_Descriptor_Lower_Bound - 
                           //      (2 * Array_Descriptor.Array_Domain.InternalGhostCellWidth[i] + Array_Descriptor->Base[i]);
                              int Ghost_Boundary_Width = Array_Descriptor.Array_Domain.InternalGhostCellWidth[i];
           // Nearly correct  int Temp_Computed_Left_Number_Of_Points = 
           //                      (PARTI_Parallel_Descriptor_Lower_Bound - Ghost_Boundary_Width)
           //                 // - (Array_Descriptor->Base[i] - Ghost_Boundary_Width)
           //                    - (Array_Descriptor->Base[i])
           //                //  + (SerialArray->Array_Descriptor->Base[i] - Ghost_Boundary_Width);
           //                //  + (SerialArray->Array_Descriptor->Base[i] + Ghost_Boundary_Width);
           //                    + (SerialArray->Array_Descriptor->Base[i]);
                           // int Offset_For_Stride = Array_Descriptor.SerialArray->Array_Descriptor->Base[i] + Ghost_Boundary_Width;
                           // int Offset_For_Stride = Array_Descriptor.SerialArray->Array_Descriptor->Base[i] - Ghost_Boundary_Width;
                              int Offset_For_Stride = 
				 Array_Descriptor.SerialArray->Array_Descriptor.
				 Array_Domain.Base[i];
                              Offset_For_Stride = (Offset_For_Stride > 0) ? Offset_For_Stride : 0;
                              int Temp_Computed_Left_Number_Of_Points = 
                                   (PARTI_Parallel_Descriptor_Lower_Bound - Ghost_Boundary_Width)
                                 - (Array_Descriptor.Array_Domain.Base[i])
                                 + Offset_For_Stride;
                              int Computed_Left_Number_Of_Points = (Temp_Computed_Left_Number_Of_Points >= 0) ?
                                   Temp_Computed_Left_Number_Of_Points : 0;
#else
#if GIVE_UP_ON_ERROR_CHECKING
                           // This force the error checking to workwhile we test another idea!
                           // printf ("TEMPORARY CODE IN ERROR CHECKING! \n");
                              int Computed_Left_Number_Of_Points = Array_Descriptor.Array_Domain.Left_Number_Of_Points [i];
#else
                           // OK - I give up - this is the simple way to do this (though it does less checking)
                              int Computed_Left_Number_Of_Points = 
                                   Array_Descriptor.Array_Domain.Local_Mask_Index [i].getBase() - 
                                   Array_Descriptor.Array_Domain.Global_Index [i].getBase();
                           // Computed_Left_Number_Of_Points -= 
                           //      (Array_Descriptor->Array_Conformability_Info == NULL) ? 0 :
                           //      Array_Descriptor->Array_Conformability_Info->Lhs_Left_Number_Of_Points_Truncated;
#endif
#endif
#endif
                              if ( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] != Computed_Left_Number_Of_Points )
                                 {
                                   printf ("Computed_Left_Number_Of_Points = %d \n",Computed_Left_Number_Of_Points);
                                // printf ("Offset_For_Stride = %d \n",Offset_For_Stride);
                                   printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Left_Number_Of_Points[i]);
                                   printf ("PARTI_Parallel_Descriptor_Lower_Bound  (for Axis = %d) = %d \n",i,PARTI_Parallel_Descriptor_Lower_Bound );
                                   printf ("Array_Descriptor.Array_Domain.Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Base[i]);
                                   printf ("Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",i,Array_Descriptor.Array_Domain.Data_Base[i]);
                                   view ("ERROR: Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == PARTI_Parallel_Descriptor_Lower_Bound - (Array_Descriptor.Array_Domain.Base[i] + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i])");
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == Computed_Left_Number_Of_Points );
                            }
                       }
                  }

            // I think that the use of the Bound[?] below does not get computed correctly
            // if we have a view of a view (so the wrong case would be processed)  We can
            // debug this case at a later date!   ?????
            // APP_ASSERT (Array_Descriptor->isView() == FALSE);
     
            // These are the bounds of the actual data (with assumed base of ZERO)
            // if we just use the Array_Descriptor->Bound[?] then we get the bound of the view
            // (if the array object was a view).  We could use the RawArraySize member function.
               int Bounds[MAX_ARRAY_DIMENSION];
               Bounds [0] = Array_Descriptor.Array_Domain.Size[0] - 1;
               int temp;
	       for ( temp=1; temp<MAX_ARRAY_DIMENSION; temp++ )
                  {
                    Bounds [temp] = (Array_Descriptor.Array_Domain.Size[temp] / Array_Descriptor.Array_Domain.Size[temp-1]) - 1;
                  }

               int SerialArray_Sizes [MAX_ARRAY_DIMENSION];
            // ??????????????????
               Array_Descriptor.SerialArray->Array_Descriptor.getRawDataSize(SerialArray_Sizes); 

               for (i=0; i < Array_Descriptor.Array_Domain.Domain_Dimension; i++)
                  {
                 // Skip error checking in case of gLBnd(Array_Descriptor->BlockPartiArrayDomain,i) < 0
                 // -1 is the error code returned by the PARTI library (meaning that the dimension was out of range)
#if 1
                    int PARTI_Parallel_Descriptor_Upper_Bound = gUBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i);
#else
                 // The following modification to the PARTI_Parallel_Descriptor_Lower_Bound variable allows
                 // for the case where a non unit stride makes the first local Index of a view different
                 // from the position of first element of the local partition.  It is important only for 
                 // views which have non unit stride!
                    APP_ASSERT (SerialArray);
                 // APP_ASSERT (SerialArray->Array_Descriptor);
                    int PARTI_Parallel_Descriptor_Upper_Bound = gUBnd
		       (Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i) -
                        ((SerialArray_Sizes[i]-1) - 
			Array_Descriptor.SerialArray->Array_Descriptor.
			Array_Domain.Bound[i]);
#endif
                 // Trap out error return value for PARTI gUBnd
                    if ( PARTI_Parallel_Descriptor_Upper_Bound == -1 )
                       {
                         printf ("PARTI_Parallel_Descriptor_Upper_Bound = %d \n",PARTI_Parallel_Descriptor_Upper_Bound);
                         printf ("SerialArray_Sizes [0-%d] = ", MAX_ARRAY_DIMENSION-1);
                         printf (IO_CONTROL_STRING_MACRO_INTEGER,ARRAY_TO_LIST_MACRO(SerialArray_Sizes));
                         printf ("\n");
                         printf ("Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Bound[%d] = %d \n",
                              i,Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Bound[i]);
                         printf ("Axis = %d  gUBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i) = %d \n",
                              i,gUBnd(Array_Descriptor.Array_Domain.getBlockPartiArrayDomain(),i));
                       }
                 // APP_ASSERT (PARTI_Parallel_Descriptor_Upper_Bound != -1);
                    if ( PARTI_Parallel_Descriptor_Upper_Bound != -1 )
                       {
                         if (Array_Descriptor.isRightPartition(i))
                            {
                              if ( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != 0 )
                                 {
                                   printf ("Array_Descriptor.Array_Domain.Right_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Right_Number_Of_Points[i]);
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] == 0 );
                            }
                           else 
                            {
                           // The following logic supports the error checking of the Left_Number_Of_Points and is complex
                           // because it accounts for the interdependence of the partitioning and the stride of access.
                           // Basically if the partitioning is such that the added ghost boundary width is greater
                           // than or equal to the stride then the Left_Number_Of_Points is decremented.  This relationship
                           // is very simple if the stride is 1 but this code must handle the more general cases.
#if 0
                              int Remainder = (Array_Descriptor.Array_Domain.Bound[i] - PARTI_Parallel_Descriptor_Upper_Bound)  % Array_Descriptor.Array_Domain.Stride[i];
                           // int Offset_For_Stride = Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i] >= Array_Descriptor.Array_Domain.Stride[i];
                              int Offset_For_Stride = ((Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) >= 
                                                        Array_Descriptor.Array_Domain.Stride[i]) ? 
                                                       (Remainder + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) : 0;
                              APP_ASSERT ( Offset_For_Stride >= 0 );
                           // APP_ASSERT ( Offset_For_Stride <= Array_Descriptor.Array_Domain.Stride[i] );
                              int Computed_Right_Number_Of_Points = Array_Descriptor.Array_Domain.Bound[i] - 
                                   (PARTI_Parallel_Descriptor_Upper_Bound + Offset_For_Stride);
                              Computed_Right_Number_Of_Points = (Computed_Right_Number_Of_Points >= 0) ? Computed_Right_Number_Of_Points : 0;

                           // if ( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != Array_Descriptor.Array_Domain.Bound[i] - 
                           //      (PARTI_Parallel_Descriptor_Upper_Bound + Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]) )
#else
#if 0
                           // int Temp_Computed_Left_Number_Of_Points = 
                           //      (PARTI_Parallel_Descriptor_Lower_Bound - Ghost_Boundary_Width)
                           // // - (Array_Descriptor.Array_Domain.Base[i] - Ghost_Boundary_Width)
                           //    - (Array_Descriptor.Array_Domain.Base[i])
                           //    + (SerialArray->Array_Descriptor.Array_Domain.Base[i] - Ghost_Boundary_Width);
                              int Ghost_Boundary_Width = Array_Descriptor.Array_Domain.InternalGhostCellWidth[i];
                           // int Temp_Computed_Right_Number_Of_Points = 
                           //      (Array_Descriptor.Array_Domain.Bound[i])
                           //    - (PARTI_Parallel_Descriptor_Upper_Bound + Ghost_Boundary_Width)
                           //    - (SerialArray->Array_Descriptor.Array_Domain.Bound[i] - Ghost_Boundary_Width);
              // Near working int Temp_Computed_Right_Number_Of_Points = 
              //                   (Array_Descriptor.Array_Domain.Bound[i])
              //                 - (PARTI_Parallel_Descriptor_Upper_Bound + Ghost_Boundary_Width);
                              int Temp_Computed_Right_Number_Of_Points = 
                                   (Array_Descriptor.Array_Domain.Bound[i])
                                 - (PARTI_Parallel_Descriptor_Upper_Bound + Ghost_Boundary_Width)
                                 + (PARTI_Parallel_Descriptor_Upper_Bound - 
                                        (SerialArray->Array_Descriptor.Array_Domain.Bound[i] - 2 * Ghost_Boundary_Width));
                              int Computed_Right_Number_Of_Points = (Temp_Computed_Right_Number_Of_Points >= 0) ?
                                                                     Temp_Computed_Right_Number_Of_Points : 0;
#else
#if GIVE_UP_ON_ERROR_CHECKING
                           // This force the error checking to workwhile we test another idea!
                           // printf ("TEMPORARY CODE IN ERROR CHECKING! \n");
                              int Computed_Right_Number_Of_Points = Array_Descriptor.Array_Domain.Right_Number_Of_Points [i];
#else
                           // OK - I give up - this is the simple way to do this (though it does less checking)
                              int Computed_Right_Number_Of_Points = 
                                   Array_Descriptor.Array_Domain.Global_Index [i].getRawBound() - 
                                   Array_Descriptor.Array_Domain.Local_Mask_Index [i].getBound();
#endif
#endif
#endif
                              if ( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != Computed_Right_Number_Of_Points )
                                 {
                                   printf ("Computed_Right_Number_Of_Points = %d \n",Computed_Right_Number_Of_Points);
                                // printf ("Offset_For_Stride = %d \n",Offset_For_Stride);
                                   printf ("Array_Descriptor.Array_Domain.Right_Number_Of_Points[%d] = %d \n",i,Array_Descriptor.Array_Domain.Right_Number_Of_Points[i]);
                                   printf ("PARTI_Parallel_Descriptor_Upper_Bound (for Axis = %d) = %d \n",i,PARTI_Parallel_Descriptor_Upper_Bound);
                                   printf ("Array_Descriptor.Array_Domain.Bound[%d] = %d \n",i,Array_Descriptor.Array_Domain.Bound[i]);
                                   view ("ERROR: Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] != Computed_Right_Number_Of_Points");
                                 }
                              APP_ASSERT( Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] == Computed_Right_Number_Of_Points );
                            }
                       }
                  }
             }  // end of block from if ( Array_Descriptor.Array_Domain.BlockPartiArrayDomain != NULL )

          if ((Array_Descriptor.Array_Domain.Global_Index[0].getBase()  !=getRawBase(0)) && 
	       (Array_Descriptor.Array_Domain.Global_Index[0].getMode() != Null_Index) &&
	       !(Array_Descriptor.Array_Domain.Uses_Indirect_Addressing))
             {
               printf ("getRawBase(0) ================================== %d \n",getRawBase(0));
               printf ("Array_Descriptor.Array_Domain.Global_Index[0].getBase() = %d \n",Array_Descriptor.Array_Domain.Global_Index[0].getBase());
               Array_Descriptor.Array_Domain.Global_Index[0].display("Array_Descriptor.Array_Domain.Global_Index[0]");
             }

          if ((Array_Descriptor.Array_Domain.Global_Index[1].getBase()!=getRawBase(1)) && (Array_Descriptor.Array_Domain.Global_Index[1].getMode() != Null_Index) )
             {
               printf ("getRawBase(1) ================================== %d \n",getRawBase(1));
               printf ("Array_Descriptor.Array_Domain.Global_Index[1].getBase() = %d \n",Array_Descriptor.Array_Domain.Global_Index[1].getBase());
               Array_Descriptor.Array_Domain.Global_Index[1].display("Array_Descriptor.Array_Domain.Global_Index[1]");
             }
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[0].getBase()==getRawBase(0)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[0].getMode()==Null_Index) || Array_Descriptor.Array_Domain.Uses_Indirect_Addressing );
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[1].getBase()==getRawBase(1)) ||
                       (Array_Descriptor.Array_Domain.Global_Index[1].getMode()==Null_Index) );
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[2].getBase()==getRawBase(2)) ||
                       (Array_Descriptor.Array_Domain.Global_Index[2].getMode()==Null_Index) );
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[3].getBase()==getRawBase(3)) ||
                       (Array_Descriptor.Array_Domain.Global_Index[3].getMode()==Null_Index) );

          if ( (Array_Descriptor.Array_Domain.Global_Index[0].getBound() != getRawBound(0)) &&
               (Array_Descriptor.Array_Domain.Global_Index[0].getMode()  == Index_Triplet)  &&
		!Array_Descriptor.Array_Domain.Uses_Indirect_Addressing )
             {
               view("ERROR: Array_Descriptor.Array_Domain.Global_Index[0].getBound() != getRawBound(0)");
               printf ("getRawBound(0) = %d \n",getRawBound(0));
               printf ("Array_Descriptor.Array_Domain.Global_Index[0].getBound() = %d \n",
                    Array_Descriptor.Array_Domain.Global_Index[0].getBound());
            // I think this should be an error!
               APP_ABORT();
             }

#if GIVE_UP_ON_ERROR_CHECKING
      //  printf ("TEMPORARY CODE IN ERROR CHECKING! \n");
#else
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[0].getBound() == getRawBound(0)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[0].getMode()  == Null_Index) ); 
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[1].getBound() == getRawBound(1)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[1].getMode()  == Null_Index) ); 
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[2].getBound() == getRawBound(2)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[2].getMode()  == Null_Index) ); 
          APP_ASSERT ( (Array_Descriptor.Array_Domain.Global_Index[3].getBound() == getRawBound(3)) || 
                       (Array_Descriptor.Array_Domain.Global_Index[3].getMode()  == Null_Index) ); 

       // Check consistancy of the Local_Mask_Index since this an important part of the message passing 
       // interpretation and general P++ operation.
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
            // The size of the local view should match the size of the local mask array
               if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                  {
                 // I can't seem to enforce this (I wonder why it is false?)
                 // Answer: Because ghost boundaies are included in the 
                 //         local_Mask_Index and NOT in the serial array view
                 // APP_ASSERT( Array_Descriptor.SerialArray->getLength(i) == 
                 //             Array_Descriptor.Array_Domain.Local_Mask_Index[i].length() );

                 // Debugging code added (7/22/2000): Error checking for the local mask index data
                    int length = Size[i];
                    if (i > 0)
                         length /= Size[i-1];

                    APP_ASSERT (Local_Mask_Index [i].getMode() != Null_Index);
                    APP_ASSERT (length  == Local_Mask_Index[i].getLength());
                    APP_ASSERT (Data_Base[i] == Local_Mask_Index[i].getBase());
                    APP_ASSERT (Data_Base[i]+length == Local_Mask_Index[i].getBound());
                    APP_ASSERT (1 == Local_Mask_Index[i].getStride());

                 // Verify that the global index is not a Null_Index
                    APP_ASSERT (Global_Index [i].getMode() != Null_Index);
                  }

               if ( Array_Descriptor.isLeftPartition(i) )
                  {
                 // If the Local_Mask_Index is a Null_Array then we want to skip this test
                 // so we only do the test if Local_Mask_Index is an Index_Triplet
                    APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != All_Index);

                 // Bugfix (4/18/95) If the view is a part of the array not owned by the local partition then the
                 // SerialArray will be a NULL array and so we must check for that case and skip
                 // the error checking if we have discovered this case.
                 // if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                    if ( (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet) &&
                         (Array_Descriptor.SerialArray->isNullArray() == FALSE) )
                       {
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() != getRawBase(i) )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBase() = %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase());
                              printf ("Array_Descriptor.Array_Domain.Base[%d] ======================= %d \n",i,Array_Descriptor.Array_Domain.Base[i]);
                              printf ("Array_Descriptor.Array_Domain.InternalGhostCellWidth[%d] ===== %d \n",
                                   i,Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]);
                              printf ("getLocalRawBase(%d) ================================= %d \n",i,getLocalRawBase(i) );
                              printf ("SerialArray->Array_Descriptor.Array_Domain.Base[%d] ===== %d \n",i,SerialArray->Array_Descriptor.Array_Domain.Base[i]);
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() == getRawBase(i) );
                       }
                  }
                 else
                  {
                 // We can't test this because we don't know if the internal boundaries are included in the Local_Mask_Index.
#if 0
                    if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                       {
                      // APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() == getLocalRawBase(i) );
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() != 
			      Array_Descriptor.SerialArray->Array_Descriptor.
			      Array_Domain.Data_Base[i] )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBase() = %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase());
                              printf ("getLocalRawBase(%d) ================================= %d \n",i,getLocalRawBase(i) );
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase()
				      == Array_Descriptor.SerialArray->
				      Array_Descriptor.Array_Domain.Data_Base[i] );
                       }
#endif
                  }

            // if (Array_Descriptor.Array_Domain.Right_Number_Of_Points [i] == 0)
               if ( Array_Descriptor.isRightPartition(i) )
                  {
                 // If the Local_Mask_Index is a Null_Array then we want to skip this test
                 // so we only do the test if Local_Mask_Index is an Index_Triplet
                    APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != All_Index);

                 // Bugfix (4/18/95) If the view is a part of the array not owned by the local partition then the
                 // SerialArray will be a NULL array and so we must check for that case and skip
                 // the error checking if we have discovered this case.
                 // if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                    if ( (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet) &&
                         (Array_Descriptor.SerialArray->isNullArray() == FALSE) )
                       {
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() != getLocalRawBound(i) )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBound() ======= %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound());
                              printf ("Array_Descriptor.Array_Domain.InternalGhostCellWidth[%d] ============ %d \n",
                                   i,Array_Descriptor.Array_Domain.InternalGhostCellWidth[i]);
                              printf ("getLocalRawBound(%d) ======================================= %d \n",i,getLocalRawBound(i) );
                              view ("ERROR: Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() != getLocalRawBound(i)");
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == getLocalRawBound(i) );
                       }
                  }
                 else
                  {
                 // We can't test this because we don't know if the internal boundaries are included in the Local_Mask_Index.
#if 0
                    if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                       {
                      // APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == getLocalBound(i) );
                      // APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == Array_Descriptor.SerialArray->Array_Descriptor->Data_Base[i] );
                         if ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() != Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Data_Base[i] + Bounds[i] )
                            {
                              printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBound() = %d \n",
                                   i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound());
                              printf ("getLocalRawBound(%d) ================================= %d \n",i,getLocalRawBound(i) );
                            }
                         APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() == Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Data_Base[i] + Bounds[i] );
                       }
#endif
                  }

            // printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBase()  = %d \n",i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() );
            // printf ("Array_Descriptor.Array_Domain.Local_Mask_Index[%d].getBound() = %d \n",i,Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() );
            // printf ("Array_Descriptor.Array_Domain.Left_Number_Of_Points [%d]  = %d \n",i,Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] );
            // printf ("Array_Descriptor.Array_Domain.Right_Number_Of_Points [%d] = %d \n",i,Array_Descriptor.Array_Domain.Right_Number_Of_Points [i] );
            // printf ("getBase(%d)  = %d \n",i,getBase(i) );
            // printf ("getBound(%d) = %d \n",i,getBound(i) );

            // If the Local_Mask_Index is a Null_Array then we want to skip this test
            // so we only do the test if Local_Mask_Index is an Index_Triplet
               APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != All_Index);
               if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() == Index_Triplet)
                  {
                    APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase()  - Array_Descriptor.Array_Domain.Left_Number_Of_Points [i] == getRawBase(i) ); 
                    APP_ASSERT ( Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBound() + Array_Descriptor.Array_Domain.Right_Number_Of_Points[i] == getRawBound(i) ); 
                  }
             }
 // End of if not defined USE_PADRE
#endif
#endif
        }  // end of block from if (Array_Descriptor.isNullArray() == FALSE) above

 // Cannot make this APP_ASSERTion since it must be allowed (example: A(I) = sqrt(A(I));)
 // APP_ASSERT(SerialArray->Array_Descriptor.Is_Contiguous_Data == TRUE);

 // endif for if PPP above
#endif

#if 0
     if (isNullArray() == TRUE)
        {
          if (isView() == TRUE)
             {
            // Even a null array needs to have a valid data point if it is a view.
            // This is required for the P++ Internal_Partitioning_Type::updateGhostBoundaries()
               APP_ASSERT(getDataPointer() != NULL);
             }
        }
#endif

  // Test the setup of the View pointer offsets (this is the same test done in the scalar indexing operators)
#if defined(PPP)
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer0 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[0]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer1 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[1]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer2 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[2]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer3 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[3]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer4 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[4]);
     APP_ASSERT (getSerialArrayDescriptor().Array_View_Pointer5 ==
                 getSerialArrayDescriptor().Array_Data + getSerialDomain().Scalar_Offset[5]);
#else
     APP_ASSERT (Array_Descriptor.Array_View_Pointer0 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[0]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer1 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[1]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer2 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[2]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer3 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[3]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer4 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[4]);
     APP_ASSERT (Array_Descriptor.Array_View_Pointer5 ==
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[5]);
#endif

#if COMPILE_DEBUG_STATEMENTS
#if defined(PPP)
   if (Optimization_Manager::Optimize_Scalar_Indexing == FALSE)
     Communication_Manager::Sync();
#endif
     if (APP_DEBUG > 5)
          printf ("Leaving floatArray::Test_Consistency! (Label = %s) \n",Label);
#endif
   }



// *************************************************************
// Conformable operations are required for all array operations
// (meaning that all the axis dimensions must be the same)
// their use allows P++ to interpret the parallel message passing
// Need one function for each type that we support!
// *************************************************************
void
floatArray::Test_Conformability ( const doubleArray & X ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of floatArray::Test_Conformability \n");
#endif

  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     if (Index::Index_Bounds_Checking == FALSE)
        {
          printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since floatArray::Test_Conformability was called! \n");
          APP_ABORT();
        }
#endif

#if defined(PPP)
  // Call this because it will trap the case of mixed width ghost boundary operations
  // Which is a temporary trap since it is hard to handle and will be implemented later
     if ( Internal_Partitioning_Type::Has_Same_Ghost_Boundary_Widths
	     ( Array_Descriptor.Array_Domain, X.Array_Descriptor.Array_Domain ) == FALSE )
        {
          printf ("ERROR in floatArray::Test_Conformability ( const doubleArray & X ) \n");
          printf ("Operands have different width ghost boundaries -- sorry -- not yet supported! \n");
          printf ("Internal Ghost Boundary widths: Lhs (%d, %d, %d, %d) Rhs (%d, %d, %d, %d) \n",
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[0],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[2],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[3],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[0], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[2], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[3] );
#if COMPILE_DEBUG_STATEMENTS
            // display("THIS");
            // X.display("X");
#endif
          printf ("Exiting ... \n");
          APP_ABORT();
        }
       else
        {
       // printf ("ERROR in floatArray::Test_Conformability ( const doubleArray & X ) \n");
       // printf ("Operands have SAME width ghost boundaries \n");
        }
#endif

     if (!isConformable(X))
        {
          printf ("********************************************************* \n"); 
          printf ("             ERROR in CONFORMABILITY TEST                 \n");
          printf ("********************************************************* \n"); 

          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("ERROR: floatArray - doubleArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("ERROR: floatArray - doubleArray (direct addressing) operation is non conformable, an error! \n");

#if COMPILE_DEBUG_STATEMENTS
       // Print out extra information if internal debugging is turned on
          printf ("********************************************************* \n"); 
          view("This (LHS in binary operation)");
          printf ("********************************************************* \n"); 
          X.view("X (RHS in binary operation)");
          printf ("********************************************************* \n"); 

       // print out the error message again since the views of the data have likely confused the user!
          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("(END OF DISPLAY) ERROR: floatArray - doubleArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("(END OF DISPLAY) ERROR: floatArray - doubleArray (direct addressing) operation is non conformable, an error! \n");
#endif
          APP_ABORT();
        }     

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving floatArray::Test_Conformability \n");
#endif
   }

bool
floatArray::isConformable ( const doubleArray & X ) const
   {
  // Conformability between array objects in array expressions is rather strict.
  // The advantage is that such operations have significant semantics and can be
  // optimized with tools like ROSE (a tool for generating optimizing preprocessors).
  // So operations like: A(I,J) = B(I,J) are conformable but operations like 
  // A(I,J) = B(J,I) are not conformable unless I and J are the same length.
  // Similarly A(0,I) = B(I) are not conformable!

     bool Return_Value = TRUE;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of floatArray::isConformable \n");
#endif
  // APP_ASSERT(Array_Descriptor != NULL);
  // APP_ASSERT(X.Array_Descriptor != NULL);

     if (usesIndirectAddressing() || X.usesIndirectAddressing())
        {
       // Conformability for indirect addressing is restricted to JUST counting 
       // the number of elements.  So A(2,I) is conformable with B(I,2) if "I" 
       // is an intArray object.  
          int Max_Dimension_Size   = elementCount();
          int X_Max_Dimension_Size = X.elementCount();

          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("NOTE: in floatArray::Test_Conformability (indirect test) -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif
             }
            else
             {
            // Test for conformability of operation between array object using indirect addressing!
               if ( Max_Dimension_Size != X_Max_Dimension_Size )
                    Return_Value = FALSE;
             }
        }
       else
        {
          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 3)
                    printf ("NOTE: in floatArray::Test_Conformability -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif

#if defined(APP)
            // If the LHS is a valid array but the RHS in an A++ operation is NULL then this is not a valid operation
            // P++ may have to allow this because of the case that operations are defined on processors that have no data
               if ( (!Array_Descriptor.isNullArray() && X.isNullArray()) )
                    Return_Value  = FALSE;
#endif
             }
            else
             {
               int length[MAX_ARRAY_DIMENSION];
               int X_length[MAX_ARRAY_DIMENSION];
               int temp;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
#if defined(PPP)
                    length[temp]   = getLength(temp) - 2*getInternalGhostCellWidth(temp);
                    X_length[temp] = X.getLength(temp) - 2*X.getInternalGhostCellWidth(temp);
#else
                    length[temp]   = getLength(temp);
                    X_length[temp] = X.getLength(temp);
#endif
                  }

               bool Error_Printed = FALSE;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
                    if ( (length[temp] != X_length[temp]) && (Error_Printed == FALSE) )
                       {
                         Return_Value  = FALSE;
                      // Avoid reprinting the error for other values of temp
                         Error_Printed = TRUE;
                         printf ("Lengths in each dimension = \n");
                         int temp2;
                         for (temp2 = 0; temp2 < MAX_ARRAY_DIMENSION; temp2++)
                              printf ("Along axis=%d -- length = %d  length of X = %d \n",temp,length[temp2],X_length[temp2]);
                       }
                  }
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving floatArray::isConformable \n");
#endif

     return Return_Value;
   }

// *************************************************************
// Conformable operations are required for all array operations
// (meaning that all the axis dimensions must be the same)
// their use allows P++ to interpret the parallel message passing
// Need one function for each type that we support!
// *************************************************************
void
floatArray::Test_Conformability ( const floatArray & X ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of floatArray::Test_Conformability \n");
#endif

  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     if (Index::Index_Bounds_Checking == FALSE)
        {
          printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since floatArray::Test_Conformability was called! \n");
          APP_ABORT();
        }
#endif

#if defined(PPP)
  // Call this because it will trap the case of mixed width ghost boundary operations
  // Which is a temporary trap since it is hard to handle and will be implemented later
     if ( Internal_Partitioning_Type::Has_Same_Ghost_Boundary_Widths
	     ( Array_Descriptor.Array_Domain, X.Array_Descriptor.Array_Domain ) == FALSE )
        {
          printf ("ERROR in floatArray::Test_Conformability ( const floatArray & X ) \n");
          printf ("Operands have different width ghost boundaries -- sorry -- not yet supported! \n");
          printf ("Internal Ghost Boundary widths: Lhs (%d, %d, %d, %d) Rhs (%d, %d, %d, %d) \n",
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[0],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[2],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[3],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[0], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[2], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[3] );
#if COMPILE_DEBUG_STATEMENTS
            // display("THIS");
            // X.display("X");
#endif
          printf ("Exiting ... \n");
          APP_ABORT();
        }
       else
        {
       // printf ("ERROR in floatArray::Test_Conformability ( const floatArray & X ) \n");
       // printf ("Operands have SAME width ghost boundaries \n");
        }
#endif

     if (!isConformable(X))
        {
          printf ("********************************************************* \n"); 
          printf ("             ERROR in CONFORMABILITY TEST                 \n");
          printf ("********************************************************* \n"); 

          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("ERROR: floatArray - floatArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("ERROR: floatArray - floatArray (direct addressing) operation is non conformable, an error! \n");

#if COMPILE_DEBUG_STATEMENTS
       // Print out extra information if internal debugging is turned on
          printf ("********************************************************* \n"); 
          view("This (LHS in binary operation)");
          printf ("********************************************************* \n"); 
          X.view("X (RHS in binary operation)");
          printf ("********************************************************* \n"); 

       // print out the error message again since the views of the data have likely confused the user!
          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("(END OF DISPLAY) ERROR: floatArray - floatArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("(END OF DISPLAY) ERROR: floatArray - floatArray (direct addressing) operation is non conformable, an error! \n");
#endif
          APP_ABORT();
        }     

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving floatArray::Test_Conformability \n");
#endif
   }

bool
floatArray::isConformable ( const floatArray & X ) const
   {
  // Conformability between array objects in array expressions is rather strict.
  // The advantage is that such operations have significant semantics and can be
  // optimized with tools like ROSE (a tool for generating optimizing preprocessors).
  // So operations like: A(I,J) = B(I,J) are conformable but operations like 
  // A(I,J) = B(J,I) are not conformable unless I and J are the same length.
  // Similarly A(0,I) = B(I) are not conformable!

     bool Return_Value = TRUE;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of floatArray::isConformable \n");
#endif
  // APP_ASSERT(Array_Descriptor != NULL);
  // APP_ASSERT(X.Array_Descriptor != NULL);

     if (usesIndirectAddressing() || X.usesIndirectAddressing())
        {
       // Conformability for indirect addressing is restricted to JUST counting 
       // the number of elements.  So A(2,I) is conformable with B(I,2) if "I" 
       // is an intArray object.  
          int Max_Dimension_Size   = elementCount();
          int X_Max_Dimension_Size = X.elementCount();

          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("NOTE: in floatArray::Test_Conformability (indirect test) -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif
             }
            else
             {
            // Test for conformability of operation between array object using indirect addressing!
               if ( Max_Dimension_Size != X_Max_Dimension_Size )
                    Return_Value = FALSE;
             }
        }
       else
        {
          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 3)
                    printf ("NOTE: in floatArray::Test_Conformability -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif

#if defined(APP)
            // If the LHS is a valid array but the RHS in an A++ operation is NULL then this is not a valid operation
            // P++ may have to allow this because of the case that operations are defined on processors that have no data
               if ( (!Array_Descriptor.isNullArray() && X.isNullArray()) )
                    Return_Value  = FALSE;
#endif
             }
            else
             {
               int length[MAX_ARRAY_DIMENSION];
               int X_length[MAX_ARRAY_DIMENSION];
               int temp;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
#if defined(PPP)
                    length[temp]   = getLength(temp) - 2*getInternalGhostCellWidth(temp);
                    X_length[temp] = X.getLength(temp) - 2*X.getInternalGhostCellWidth(temp);
#else
                    length[temp]   = getLength(temp);
                    X_length[temp] = X.getLength(temp);
#endif
                  }

               bool Error_Printed = FALSE;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
                    if ( (length[temp] != X_length[temp]) && (Error_Printed == FALSE) )
                       {
                         Return_Value  = FALSE;
                      // Avoid reprinting the error for other values of temp
                         Error_Printed = TRUE;
                         printf ("Lengths in each dimension = \n");
                         int temp2;
                         for (temp2 = 0; temp2 < MAX_ARRAY_DIMENSION; temp2++)
                              printf ("Along axis=%d -- length = %d  length of X = %d \n",temp,length[temp2],X_length[temp2]);
                       }
                  }
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving floatArray::isConformable \n");
#endif

     return Return_Value;
   }

// *************************************************************
// Conformable operations are required for all array operations
// (meaning that all the axis dimensions must be the same)
// their use allows P++ to interpret the parallel message passing
// Need one function for each type that we support!
// *************************************************************
void
floatArray::Test_Conformability ( const intArray & X ) const
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of floatArray::Test_Conformability \n");
#endif

  // Only used when EXTRA_ERROR_CHECKING is TRUE
#if (EXTRA_ERROR_CHECKING == FALSE)
     if (Index::Index_Bounds_Checking == FALSE)
        {
          printf ("A++ version (EXTRA_ERROR_CHECKING) was incorrectly built since floatArray::Test_Conformability was called! \n");
          APP_ABORT();
        }
#endif

#if defined(PPP)
  // Call this because it will trap the case of mixed width ghost boundary operations
  // Which is a temporary trap since it is hard to handle and will be implemented later
     if ( Internal_Partitioning_Type::Has_Same_Ghost_Boundary_Widths
	     ( Array_Descriptor.Array_Domain, X.Array_Descriptor.Array_Domain ) == FALSE )
        {
          printf ("ERROR in floatArray::Test_Conformability ( const intArray & X ) \n");
          printf ("Operands have different width ghost boundaries -- sorry -- not yet supported! \n");
          printf ("Internal Ghost Boundary widths: Lhs (%d, %d, %d, %d) Rhs (%d, %d, %d, %d) \n",
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[0],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               Array_Descriptor.Array_Domain.InternalGhostCellWidth[2],   Array_Descriptor.Array_Domain.InternalGhostCellWidth[3],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[0], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[1],
               X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[2], X.Array_Descriptor.Array_Domain.InternalGhostCellWidth[3] );
#if COMPILE_DEBUG_STATEMENTS
            // display("THIS");
            // X.display("X");
#endif
          printf ("Exiting ... \n");
          APP_ABORT();
        }
       else
        {
       // printf ("ERROR in floatArray::Test_Conformability ( const intArray & X ) \n");
       // printf ("Operands have SAME width ghost boundaries \n");
        }
#endif

     if (!isConformable(X))
        {
          printf ("********************************************************* \n"); 
          printf ("             ERROR in CONFORMABILITY TEST                 \n");
          printf ("********************************************************* \n"); 

          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("ERROR: floatArray - intArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("ERROR: floatArray - intArray (direct addressing) operation is non conformable, an error! \n");

#if COMPILE_DEBUG_STATEMENTS
       // Print out extra information if internal debugging is turned on
          printf ("********************************************************* \n"); 
          view("This (LHS in binary operation)");
          printf ("********************************************************* \n"); 
          X.view("X (RHS in binary operation)");
          printf ("********************************************************* \n"); 

       // print out the error message again since the views of the data have likely confused the user!
          if (usesIndirectAddressing() || X.usesIndirectAddressing())
               printf ("(END OF DISPLAY) ERROR: floatArray - intArray (indirect addressing) operation is non conformable, an error! \n");
            else
               printf ("(END OF DISPLAY) ERROR: floatArray - intArray (direct addressing) operation is non conformable, an error! \n");
#endif
          APP_ABORT();
        }     

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving floatArray::Test_Conformability \n");
#endif
   }

bool
floatArray::isConformable ( const intArray & X ) const
   {
  // Conformability between array objects in array expressions is rather strict.
  // The advantage is that such operations have significant semantics and can be
  // optimized with tools like ROSE (a tool for generating optimizing preprocessors).
  // So operations like: A(I,J) = B(I,J) are conformable but operations like 
  // A(I,J) = B(J,I) are not conformable unless I and J are the same length.
  // Similarly A(0,I) = B(I) are not conformable!

     bool Return_Value = TRUE;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 3)
          printf ("Inside of floatArray::isConformable \n");
#endif
  // APP_ASSERT(Array_Descriptor != NULL);
  // APP_ASSERT(X.Array_Descriptor != NULL);

     if (usesIndirectAddressing() || X.usesIndirectAddressing())
        {
       // Conformability for indirect addressing is restricted to JUST counting 
       // the number of elements.  So A(2,I) is conformable with B(I,2) if "I" 
       // is an intArray object.  
          int Max_Dimension_Size   = elementCount();
          int X_Max_Dimension_Size = X.elementCount();

          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("NOTE: in floatArray::Test_Conformability (indirect test) -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif
             }
            else
             {
            // Test for conformability of operation between array object using indirect addressing!
               if ( Max_Dimension_Size != X_Max_Dimension_Size )
                    Return_Value = FALSE;
             }
        }
       else
        {
          if ( (Array_Descriptor.isNullArray() || X.isNullArray()) )
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 3)
                    printf ("NOTE: in floatArray::Test_Conformability -- Array_Descriptor.isNullArray() || X.isNullArray() \n");
#endif

#if defined(APP)
            // If the LHS is a valid array but the RHS in an A++ operation is NULL then this is not a valid operation
            // P++ may have to allow this because of the case that operations are defined on processors that have no data
               if ( (!Array_Descriptor.isNullArray() && X.isNullArray()) )
                    Return_Value  = FALSE;
#endif
             }
            else
             {
               int length[MAX_ARRAY_DIMENSION];
               int X_length[MAX_ARRAY_DIMENSION];
               int temp;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
#if defined(PPP)
                    length[temp]   = getLength(temp) - 2*getInternalGhostCellWidth(temp);
                    X_length[temp] = X.getLength(temp) - 2*X.getInternalGhostCellWidth(temp);
#else
                    length[temp]   = getLength(temp);
                    X_length[temp] = X.getLength(temp);
#endif
                  }

               bool Error_Printed = FALSE;
               for (temp = 0; temp < MAX_ARRAY_DIMENSION; temp++)
                  {
                    if ( (length[temp] != X_length[temp]) && (Error_Printed == FALSE) )
                       {
                         Return_Value  = FALSE;
                      // Avoid reprinting the error for other values of temp
                         Error_Printed = TRUE;
                         printf ("Lengths in each dimension = \n");
                         int temp2;
                         for (temp2 = 0; temp2 < MAX_ARRAY_DIMENSION; temp2++)
                              printf ("Along axis=%d -- length = %d  length of X = %d \n",temp,length[temp2],X_length[temp2]);
                       }
                  }
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving floatArray::isConformable \n");
#endif

     return Return_Value;
   }


// *******************************************************
// fill function provides a way to assign a scalar to an 
// array object
// *******************************************************
floatArray & floatArray::fill ( float x )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::fill! (value = %f)\n",double(x));
#endif

     return operator=(x);
   }

// *******************************************************
// Transpose function for A++ arrays
// This is in the Range of a Matrix function but we provide 
// it for for the array class.
// *******************************************************
floatArray & transpose ( const floatArray & X )
   {
  // This function is not implemented efficiently -- we can reimplement it later!
  // Some of the functionality within Block Parti could help implement this better.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::transpose! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
     X.Test_Consistency("Called from TOP of floatArray::transpose()");
#endif

     int temp;

  // APP_ASSERT(X.Array_Descriptor != NULL);
     int Dimension[MAX_ARRAY_DIMENSION];

  // Get the dimensions of the input array object (dimension is an inlined function
  // and if it only occures once on a statement it will be inlined by the Cfront compilers
  // if it appears twice in a statement it would not be inlined -- so we initialized
  // intermediate variable with single calls to the inlined function).
     for ( temp=0; temp<MAX_ARRAY_DIMENSION; temp++ ) Dimension[temp] = X.getLength(temp);

  // Build temporary result to return value
     floatArray & Result = *(new floatArray (Dimension[1],Dimension[0]));

#if COMPILE_DEBUG_STATEMENTS
  // We don't really want to initialize this unless we are debugging the code!
     Result = 0;
#endif

  // Now we have to fixup the descriptor
     Result.Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
#if defined(PPP)
     APP_ASSERT(Result.Array_Descriptor.SerialArray != NULL);
  // APP_ASSERT(Result.Array_Descriptor.SerialArray->Array_Descriptor != NULL);
     Result.Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
  // If there is any message passing to be done to update X (if it is a temporary) the we should
  // do it before we proceed with the transpose (I think).
  // Result.Array_Descriptor->Array_Conformability_Info = getArray_Conformability_Info (X);
     if (X.isTemporary() == TRUE)
        {
       // printf ("Input to floatArray::transpose is a temporary \n");
          bool Nonzero_Ghost_Cell_Width = FALSE;
          int i;
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
               if (X.Array_Descriptor.Array_Domain.InternalGhostCellWidth [i] > 0)
                    Nonzero_Ghost_Cell_Width = TRUE;
       // Do the message passing to update the ghost boundaries
          if (Nonzero_Ghost_Cell_Width == TRUE)
               X.updateGhostBoundaries();
          if (X.Array_Descriptor.Array_Domain.Array_Conformability_Info != NULL)
             {
            // Added conventional mechanism for reference counting control
            // operator delete no longer decriments the referenceCount.
               X.Array_Descriptor.Array_Domain.Array_Conformability_Info->decrementReferenceCount();
               if (X.Array_Descriptor.Array_Domain.Array_Conformability_Info->getReferenceCount() < 
                   Array_Conformability_Info_Type::getReferenceCountBase())
                    delete X.Array_Descriptor.Array_Domain.Array_Conformability_Info;
             }
        }
  // Build a new history (start a new history) of how the ghost boundaries are used.
  // we need a new history because the transpose means that a different set of ghost boundaries
  // and a different partitioning is likely in use.
     //Result.Array_Descriptor.Array_Domain.Array_Conformability_Info = new Array_Conformability_Info_Type(Result.Array_Descriptor);
     Result.Array_Descriptor.Array_Domain.Array_Conformability_Info = new Array_Conformability_Info_Type(Result.Array_Descriptor.Array_Domain);
#endif

  // This initializes the memory and so avoids purify errors of uninitialized 
  // memory reads (umr) in the scalar indexing function.

  // Bugfix (2/13/96) can't use temporary in array operation else it will be deleted prematurely.
  // But because we mark the Result as a temporary the operator= tries to delete it prematurely
  // so we have to initialize the Result before we mark it as a temporary.
  // Result = 0;

#if 1
     if (Dimension[3] == Dimension[2] == 1)
        {
          int Base_I   = X.getBase(0);
          int Base_J   = X.getBase(1);
          int Base_K   = X.getBase(2);
          int Base_L   = X.getBase(3);
          int Bound_I  = X.getBound(0);
          int Bound_J  = X.getBound(1);
          int Stride_I = X.getStride(0);
          int Stride_J = X.getStride(1);
          for (int j=Base_J; j <= Bound_J; j += Stride_J)
               for (int i=Base_I; i <= Bound_I; i += Stride_I)
                  {
                 // printf ("Result(%d,%d) = X(%d,%d) BEFORE Result(%d,%d) = %f X(%d,%d) = %f \n",
                 //      i,j,j,i,i,j,Result(j,i),i,j,X(i,j));
                    Result(j-Base_J,i-Base_I,0,0) = X(i,j,Base_K,Base_L);
                  }
        }
       else
        {
          printf ("Transpose not implemented for arrays of dimension greater than 2! \n");
          APP_ABORT();
        }
#endif

  // APP_ASSERT (X.Array_Descriptor != NULL);
     if (X.isTemporary())
        {
       // printf ("In floatArray::transpose(): -- Calling the delete operator for the input array! \n");
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          X.decrementReferenceCount();
          if (X.getReferenceCount() < floatArray::getReferenceCountBase())
               delete &((floatArray &) X);
        }

  // Result.display("Result in floatArray::transpose()");

#if COMPILE_DEBUG_STATEMENTS
     Result.Test_Consistency("Called from BASE of floatArray::transpose()");
#endif

     return Result;
   }

// *******************************************************
// Reference function provides a means of aliasing A++
// objects (with normal problems associated with aliasing)
// *******************************************************
floatArray &
floatArray::reference ( const floatArray & X )
   {
  // USERS SHOULD BE CAREFULL: since this function returns the
  // equivalent of an alias in FORTRAN and so it behaves similarly!

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::reference! \n");
#endif

  // Check to make sure we are not referencing to ourselves and do nothing if we are.
     bool SkipReference = FALSE;
     if (this == &( (floatArray &) X))
        {
          SkipReference = TRUE;
        }

#if defined(PPP)
     if (Array_Descriptor.SerialArray == X.Array_Descriptor.SerialArray)
        {
          SkipReference = TRUE;
        }
#endif

  // if ( this != &( (floatArray &) X)) 
     if ( SkipReference == FALSE )
        {
       // When the function is called by the copy constructor then the array object
       // is not yet build so the Array_Descriptor = NULL and the Array_Data = NULL
       // This is how we deteect this case and avoid deleting the objects data 
       // (which has not been built).
#if 0
          if (Array_Descriptor != NULL)
             {
            // To make this more efficent only call delete function if
            // Array_Descriptor->Is_A_Null_Array == FALSE!
               Delete_Array_Data();
               delete Array_Descriptor;
            // Array_Descriptor->ReferenceCountedDelete();
             }
#endif

#if defined(PPP)
       // ... (9/3/97,kdb) memory leak -- we need to delete old serialArray ...
          if (Array_Descriptor.SerialArray != NULL) 
             {
#if defined(USE_PADRE)
            // We have to remove the references in PADRE to the Serial_Array object
            // which is being deleted.  This is a consequence of P++ using PADRE in a way
            // so as to prevent the redundent storage of Array_Domain objects 
            // (specifically we use PADRE in a way so that only references are stored).
               setLocalDomainInPADRE_Descriptor(NULL);
#endif
            // Added conventional mechanism for reference counting control
            // operator delete no longer decriments the referenceCount.
               Array_Descriptor.SerialArray->decrementReferenceCount();
               if (Array_Descriptor.SerialArray->getReferenceCount() < getReferenceCountBase())
	            delete Array_Descriptor.SerialArray; 
             }
          Array_Descriptor.SerialArray = X.Array_Descriptor.SerialArray;

      // ... also need to delete partitioning object because it gets 
      //  overwritten below by operator= for Array_Descriptor ...
	  if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer !=NULL)
             {
            // Bugfix (11/14/2000) we want to handle this consistant with code elsewhere plus 
            // if we decrement the count we need to ALSO delete the Partitioning_Object!
            // Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount--;
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
               APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                           Internal_Partitioning_Type::getReferenceCountBase()-1);
               if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() < 
                   Internal_Partitioning_Type::getReferenceCountBase())
                  {
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 1)
                         printf ("In floatArray::reference() deleting Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
#endif
                    delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
                  }
               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;
             }

       // We have to increment the reference coutn to avoid having the 
       // SerialArray being deleted too early. It is not equivalent to 
       // just increntent the P++ reference count array since that would not
       // effect the Serial_A++ array operations that are done within P++ operators
       // it would only effect the deletion of the Serial_A_++ arrays by the
       // P++ delete operator (there is a subtle and important difference).
       // SerialArray->IncrementReferenceCount();
          incrementRawDataReferenceCount();
#else
       // Bugfix (2/10/98) fix memory leak when A.reference(B) is used in a loop!
          Delete_Array_Data();

       // Copy the pointer to the data!
          Array_Descriptor.Array_Data = X.Array_Descriptor.Array_Data;

       // ... set this later after Array_Desccriptor has been set ...
       // Array_View_Pointer = X.Array_View_Pointer;
       // no info in the descriptor yet 
       // POINTER_LIST_INITIALIZATION_MACRO;
#endif

       // Build a new descriptor to avoid reference counting of the Array_Descriptor!
       // This also allows the reference to  d e f i n e  a new base for the reference
       // (this is handy in adaptive mesh refinement).  This is required to avoid
       // bad interactions between the reference counting used on the SerialArray 
       // and the reference counting on the array data used in views.
       // In A++ it might not be a problem but in P++ the reference must have
       // a different Array_ID than what is referenced to avoid forcing the
       // reference count to be less than zero when views are taken of the referenced
       // array subsequently.
       // Array_Descriptor = new Array_Descriptor_Type (*X.Array_Descriptor);
       // Array_Descriptor = Array_Descriptor_Type (X.Array_Descriptor);
       //   Array_Descriptor = Array_Descriptor_Type<float,MAX_ARRAY_DIMENSION> (X.Array_Descriptor);
       // ... (9/4/97,kdb) this is iniefficient and messes up reference counting 
       //  for the partitioning object ...
       //   Array_Descriptor = 
       //     floatArray_Descriptor_Type
       //	(X.Array_Descriptor);
       // ... (9/9/97,kdb) see comment below ...
       // printf ("In floatArray::reference -- X.Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      X.Array_ID(),X.getRawDataReferenceCount());
       // printf ("In floatArray::reference --   Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      Array_ID(),getRawDataReferenceCount());

       // In the case where we repeat A.refernece(B) more then once the Array_ID's are
       // the same and we can't return it to the stack of Array_ID's
          //if (Array_ID() != X.Array_ID())
          if (Array_ID() != X.Array_ID() && getRawDataReferenceCount()<getReferenceCountBase())
               Array_Domain_Type::Push_Array_ID (Array_ID());

       // This represents the dominate overhead of the reference function!
          Array_Descriptor = X.Array_Descriptor;

       // printf ("In floatArray::reference -- (AFTER assignment) Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      Array_ID(),getRawDataReferenceCount());

       // Force Array_ID's to be the same between the reference and it's object
       // Array_Descriptor.Push_Array_ID (Array_ID());
       // ... (9/9/97,kdb) must do this with Array_ID above before it is
       //  overwritten ...
       // Array_Domain_Type::Push_Array_ID (Array_ID());
       // ... don't need this anymore because operator= for descriptor 
       //  already does this ...
       //   Array_Descriptor.Array_Domain.Array_ID = X.Array_ID();

#if defined(PPP)
       // ... bug fix (11/5/96,kdb) this array needs to be added to the
       // partitioning object list ...
	  if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer !=NULL)
	    Internal_Partitioning_Type::AddArrayToPartitioning
	       (*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
	  else
	    Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

       // BUG FIX (10/1/94):
       // The reference has the lifetime of the scope of it's construction but its
       // data has the lifetime of that which it is a reference to.
          Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#if defined(PPP)
       // Bugfix (12/15/94)
          Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#endif

#if !defined(PPP)
       // Now increment the reference count (for both array data and the descriptor)!
       // Array_Descriptor_Type::Array_Reference_Count_Array [Array_Descriptor->Array_ID]++;
          incrementRawDataReferenceCount();

       // info from X aready stored in the descriptor so this works
          POINTER_LIST_INITIALIZATION_MACRO;

       // printf ("In floatArray::reference -- (at BASE) Array_ID() = %d getRawDataReferenceCount() = %d \n",
       //      Array_ID(),getRawDataReferenceCount());
#endif
        }

  // (DQ 6/24/2000): Fixed to handle input of temporary.
  // The testcode.C demonstrates the use of a temporary in a reference member function call
  // Plus we now want to compute the number of arrays in use more accurately!
  // We want to only decrement the reference count not delete the data.
  // X.displayReferenceCounts("In floatArray::reference()");
     Delete_If_Temporary ( X );

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Leaving floatArray::reference! \n");
#endif
     return *this;
   }

// *******************************************************
// UNreference function provides a means of breaking the 
// aliasing of A++ objects. It creates a deep copy of what
// it referenced previously. 
// *******************************************************
floatArray &
floatArray::breakReference()
   {
  // This function builds a new array (internally) and copies
  // the referenced data to the new array and then makes the
  // new array it's internal data and decriments the reference 
  // count on the data.

  // Part of the Deferred Evaluation functionality
     bool Force_Memory_Allocation             = TRUE;

     APP_ASSERT(getRawDataReferenceCount() >= getReferenceCountBase());

  // If the data is not referenced then there is no reference 
  // to break and so there is nothing to do.
     if (getRawDataReferenceCount() > getReferenceCountBase())
        {
          APP_ASSERT(Array_Descriptor.isView() == FALSE);

          floatArray Old_Array;          // We build a descriptor which the
                                        // next call to reference() will delete
                                        // but this could be made more efficient later.

          Old_Array.reference (*this);  // bumps up reference count on data 
                                        // destructor called on exit which decriments
                                        // the reference count again.

          Delete_Array_Data();          // decriments reference count on data

          Array_Descriptor.Array_Domain.setArray_ID (Array_Descriptor.Array_Domain.Pop_Array_ID());

          Allocate_Array_Data(Force_Memory_Allocation);

#if COMPILE_DEBUG_STATEMENTS
          Test_Consistency("Called from floatArray::breakReference()");
#endif

#if !defined(PPP)
       // Since this is a new array object is should have an initialize reference count on its
       // raw data.  This is required here because the reference counting mechanism reused the
       // value of zero for one existing reference and no references (this will be fixed soon).
          resetRawDataReferenceCount();
#endif

          *this = Old_Array; // do the assignment of values to new data
        }

     return *this;
   }

// ***********************************************************
// View function which can be called from within dbx
// ***********************************************************
void
APP_view ( const floatArray & X , const char *Label )
   {
     X.view(Label);
   }

// ***********************************************************
// Display function which can be called from within dbx
// ***********************************************************
void
APP_display ( const floatArray & X , const char *Label )
   {
     X.display(Label);
   }

// ***********************************************************
// View function provides a means of output for A++ objects
// this function provides output of internal data in A++ objects
// ***********************************************************
floatArray & floatArray::view ( const char *Label ) const
   {
  // This function has nothing to do with views in A++ (which are just subarrays)
  // this is a display function which is just more detailed in its output
  // than the regular display member function!

     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
#if COMPILE_DEFERRED_DISPLAY_AND_VIEW_FUNCTIONS
       // This function has problems with the new Solaris C++ compiler!
          floatArray_Function_16 *Execution_Object = new floatArray_Function_16 ( view_Function , floatArray::view , *this , Label );
          APP_ASSERT( Execution_Object != NULL );
#endif
        }
       else
        {
#if COMPILE_DEBUG_STATEMENTS
          printf ("floatArray::view() (CONST) (this = %p) -- %s \n",this,Label);
#else
          printf ("floatArray::view() (CONST) -- %s \n",Label);
#endif
       // printf ("Array_Descriptor is a %s pointer = %p! \n",
       //      (Array_Descriptor == NULL) ? "NULL" : "VALID",Array_Descriptor);
     
          Array_Descriptor.display(Label);
       // if (Array_Descriptor != NULL)
       //    {
       //      printf ("Going to Display the Array_Descriptor! \n");
       //      Array_Descriptor->display(Label);
       //    }
       //   else
       //    {
       //      printf ("ERROR: Array_Descriptor is NULL in floatArray::view! \n");
       //      APP_ABORT();
       //    }

#if defined(PPP)
       // P++ specific reference couting information!
          printf ("Number of references to this P++ object (user's reference count) = %d \n",getReferenceCount());

       // We need to be able to view the data even if the SerialArray is a Null pointer
       // as in the case where it has not yet been initialized for example.
          if (Array_Descriptor.SerialArray == NULL)
               printf ("(Internal) SerialArray is a NULL pointer! (THIS IS AN ERROR MOST OF THE TIME!) \n");
            else
             {
               printf ("Number of references to the Serial A++ object (P++'s reference count on the A++ object) = %d \n",
                    Array_Descriptor.SerialArray->getReferenceCount());
               printf ("(Internal) SerialArray is a %s pointer = %p! (Internal raw array data) SerialArray->getRawDataReferenceCount() = %d \n",
                    (Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID" , 
		     Array_Descriptor.SerialArray ,
                    Array_Descriptor.SerialArray->getRawDataReferenceCount() );
             }
#else
       // A++ specific reference couting information!
          printf ("Number of references to this A++ object (or serial array object) (user's reference count) = %d \n",getReferenceCount());
          printf ("(Internal) Array_Data is a %s pointer = %p! (Internal raw array data) getRawDataReferenceCount() = %d \n",
               (Array_Descriptor.Array_Data == NULL) ? "NULL" : "VALID" , Array_Descriptor.Array_Data ,
               getRawDataReferenceCount() );
#endif

#if defined(PPP)
          printf ("\n");
          printf ("\n");
          printf ("************************************ \n");
          printf ("View SerialArray local to processor! \n");
          printf ("************************************ \n");
          printf ("\n");
          if (Array_Descriptor.SerialArray != NULL)
               Array_Descriptor.SerialArray->view(Label);
#else
       // Now call display function to print out the array data!
          printf ("Call display for data! \n");
          display(Label);
#endif

          printf ("\n");
          printf ("Array_Storage is %s! \n",(Array_Storage == NULL) ? "NULL" : "NOT NULL");
          printf ("\n");
          printf ("\n");

        }

     return *((floatArray *) this);
   }

// ***********************************************************
// Display function provides a means of output for A++ objects
// ***********************************************************
floatArray & floatArray::globalDisplay ( const char *Label ) const
   {
  // This function is less detailed than the normal display function!
  // It only prints out the numerical values!

#if defined(PPP)
  // printf ("floatArray::globalDisplay() (CONST) (Array_ID = %d) -- %s \n",Array_ID(),Label);
  // printf ("SerialArray is a %s pointer = %p (%d)! \n",(Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID",SerialArray,(int)SerialArray);

#if 0
  // While debugging P++ this is an easier mode to use (fewer P++ operations!)
     APP_ASSERT( Array_Descriptor.SerialArray != NULL );
     Array_Descriptor.SerialArray->display(Label);
#else
  // Send all the data to a serial array and display the serial array as if on a single processor.
  // Build a partition object restricted to a single processor (we choose processor 0 for this).
     Partitioning_Type Single_Processor_Partition (Range(0,0));

  // Single_Processor_Partition.display("Single_Processor_Partition");
     floatArray Single_Processor_Array ( 0, Single_Processor_Partition);
  // Single_Processor_Array.Array_Descriptor.display("Single_Processor_Array");
  // APP_DEBUG = 5;
     Single_Processor_Array.redim (*this);

  /*
  // ... bug fix (10/24/96,kdb) set this partition to have the same ghost cell
  //  width as this because otherwise the default used to create
  //  Single_Processor_Array might be different than that for this and so
  //  = operation won't work ...
  */

     int ghost_cell_width[MAX_ARRAY_DIMENSION];
     int nd;
     for (nd=0;nd<MAX_ARRAY_DIMENSION;nd++)
	ghost_cell_width[nd] = this->Array_Descriptor.Array_Domain.InternalGhostCellWidth[nd];
     // ... (10/25/96,kdb) turn the following off for now because
     //  setInternalGhostCellWidth doesn't work unless bases are 0 and it's better
     //  to break display in special case than all cases ...
     Single_Processor_Array.setInternalGhostCellWidth 
       ( ARRAY_TO_LIST_MACRO(ghost_cell_width) );
  // Single_Processor_Array.view("In floatArray::globalDisplay -- Single_Processor_Array");
  // view("In floatArray::globalDisplay -- *this");
  // APP_DEBUG = 1;

  // printf ("TEMPORARY CODE IN floatArray::globalDisplay \n");
  // view("PARALLEL THIS ARRAY");
  // Single_Processor_Array.view("BEFORE ASSIGNMENT");
  // APP_DEBUG = 2;
     Single_Processor_Array = *this;
  // APP_DEBUG = 0;
  // Single_Processor_Array.view("AFTER ASSIGNMENT");

  // APP_DEBUG = 0;
  // Single_Processor_Partition.display("Single_Processor_Partition");
     Single_Processor_Array.Array_Descriptor.SerialArray->display(Label);
#endif

#else
     printf ("ERROR: floatArray::globalDisplay called in non P++ application (Label = %s) \n",Label);
     APP_ABORT();
#endif

  // printf ("Exiting in floatArray::globalDisplay \n");
  // APP_ABORT();

     return *((floatArray *) this);
   }


// *********************************************************
// There are many different objects in an array object
// (particularly for parallel array objects and even serial
// array objects using indirect addressing).  This function
// prints out the reference counts of all the different 
// parts of an array object.
// *********************************************************
floatArray &
floatArray::displayReferenceCounts (const char* label) const
   {
  // For label to be specified
     APP_ASSERT (label != NULL);

  // APP_ABORT();

     printf ("Inside of floatArray::displayReferenceCounts(%s) : (is temporary = %s) (isNullArray = %s) \n",
          label,(isTemporary() == TRUE) ? "YES" : "NO",(isNullArray() == TRUE) ? "YES" : "NO");
     printf ("     Array Reference Count (this=%p) (Array id = %d) = %d \n",this,Array_ID(),getReferenceCount());
#if defined(PPP)
     printf ("     P++ array data's reference count ((pointer to floatSerialArray) getRawDataReferenceCount()) = %d \n",
          getRawDataReferenceCount());
#endif
#if defined(SERIAL_APP)
     printf ("     SerialArray data's reference count ((pointer to float) getRawDataReferenceCount()) = %d \n",
          getRawDataReferenceCount());
#endif
#if defined(APP)
     printf ("     A++ array data's reference count ((pointer to float) getRawDataReferenceCount()) = %d \n",
          getRawDataReferenceCount());
#endif

  // display refernece counts of indirection vectors used in indirect addressing
     Array_Descriptor.Array_Domain.displayReferenceCounts(label);

#if defined(PPP)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);
  // Array_Descriptor.SerialArray->displayReferenceCounts(label);
     printf ("          SerialArray Reference Count (this=%p) (is temporary = %s) (is nullArray = %s) (Array id = %d) = %d \n",
	     Array_Descriptor.SerialArray,
          (Array_Descriptor.SerialArray->isTemporary() == TRUE) ? "YES" : "NO",
          (Array_Descriptor.SerialArray->isNullArray() == TRUE) ? "YES" : "NO",
          Array_Descriptor.SerialArray->Array_ID(),
          Array_Descriptor.SerialArray->getReferenceCount());
     printf ("          serial array data's reference count ((pointer to float) getRawDataReferenceCount()) = %d \n",
          Array_Descriptor.SerialArray->getRawDataReferenceCount());
#if defined(USE_PADRE)
     if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
          Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
               displayReferenceCounts(label);
#endif
#endif

  // Cast away const here
     return *((floatArray*) this);
   }

// ***********************************************************
// Display function provides a means of output for A++ objects
// ***********************************************************
extern void APP_Null_Initialization_Function(void);
floatArray &
floatArray::display ( const char *Label ) const
   {
  // This function is less detailed than the normal display function!
  // It only prints out the numerical values!

  // Text from static_initialization.C:
  // This function is called in the Initialization function for the array objects
  // its purpose is to force this file (which contains the APP_Global_Array_Base
  // and APP_Unit_Range variabels above) to be included at compile time and
  // thus force the static constructors to be called.  The problem was that
  // the Overture dynamic link libraries where using the APP_Unit_Range
  // variable but the users application might not be using it and so it
  // was never included and thus never initialized (static constructor called
  // at load time).  Hopefully this will not cause problems on other architectures
  // using different compilers.
     APP_Null_Initialization_Function();

#if defined(PPP)
     printf ("floatArray::display() (CONST) (Array_ID = %d) -- %s \n",Array_ID(),Label);
  // Bugfix (12/19/96) the conversion of a pointer to an int is not allowed on the 64-bit SGI compiler.
  // printf ("SerialArray is a %s pointer = %p (%d)! \n",(Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID",SerialArray,(int)SerialArray);
     printf ("SerialArray is a %s pointer = %p! \n",(Array_Descriptor.SerialArray == NULL) ? "NULL" : "VALID",Array_Descriptor.SerialArray);

// if !defined(NDEBUG)
#if 0
  // While debugging P++ this is an easier mode to use (fewer P++ operations!)
     APP_ASSERT( Array_Descriptor.SerialArray != NULL );
     Array_Descriptor.SerialArray->display(Label);
#else
     globalDisplay(Label);
  // printf ("ERROR CHECKING exiting in P++ version of floatArray::display \n");
  // APP_ABORT();
#endif

  // Now build the array on processor 0 so it can be displayed in it's more complete form for users
#else
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
#if COMPILE_DEFERRED_DISPLAY_AND_VIEW_FUNCTIONS
       // This function has problems with the new Solaris C++ compiler!
          floatArray_Function_16 *Execution_Object = new floatArray_Function_16 ( display_Function , floatArray::display , *this , Label );
          APP_ASSERT( Execution_Object != NULL );
#endif
        }
       else
        {
       // printf ("floatArray::display() (CONST) (Array_ID = %d) -- %s \n",Array_ID(),Label);
          printf ("floatArray::display() (CONST) (Array_ID = %d) -- %s \n",Array_Descriptor.Array_ID(),Label);
#if 0
          if (Array_Descriptor != NULL)
             {
#if DISPLAY_ALL_DATA
            // printf ("Going to Display the Array_Descriptor! \n");
            // Array_Descriptor.display();
#endif
             }
            else
             {
               printf ("ERROR: Array_Descriptor is NULL in display! \n");
               APP_ABORT();
             }
#endif

#if DISPLAY_ALL_DATA
          printf ("Array_Data is a %s pointer = %p (%d)! \n",(Array_Descriptor.Array_Data == NULL) ? "NULL" : "VALID",
               Array_Descriptor.Array_Data,Array_Descriptor.Array_Data);
#endif

       // Choose a  for the display of values.  Optionally the user can have the 
       // display function choose a  based on the max and min values to be displayed!
       // Bugfix (11/13/96) This has to be given the default value (which the user can set).
       // int Local_Display_Format = DECIMAL_DISPLAY_FORMAT;
          int Local_Display_Format = DISPLAY_FORMAT;

          APP_ASSERT ( (DISPLAY_FORMAT == DECIMAL_DISPLAY_FORMAT) || 
                       (DISPLAY_FORMAT == EXPONENTIAL_DISPLAY_FORMAT) ||
                       (DISPLAY_FORMAT == SMART_DISPLAY_FORMAT) );

#if MAX_MIN_CALL_IN_DISPLAY
          if (DISPLAY_FORMAT == SMART_DISPLAY_FORMAT)
             {
            // This is a better fix to avoid the max and min function deleting the temporary!
            // Actually I don't know which is better but the later avoids the creation
            // of a temporary array object!
               bool Input_Array_Is_A_Temporary = Array_Descriptor.isTemporary();

               if (Input_Array_Is_A_Temporary)
                  {
                 // Array_Descriptor.Is_A_Temporary = FALSE;
                    ((floatArray*) this)->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#if defined(PPP)
                    Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;
#endif
                  }

#if !defined(INTARRAY)
               float Min_Value = min ( fabs (*this) );
               float Max_Value = max ( fabs (*this) );
#else
               float Min_Value = min ( abs (*this) );
               float Max_Value = max ( abs (*this) );
#endif
               if ( ( (Min_Value < 0.001) && (Min_Value > 0) )  || (Max_Value >= 1000) )
                  {
                    printf ("SMART FORMATTING set Local_Display_Format = EXPONENTIAL_DISPLAY_FORMAT \n");
                    Local_Display_Format = EXPONENTIAL_DISPLAY_FORMAT;
                  }
                 else
                  {
                 // We want to avoid the use of EXPONENTIAL_DISPLAY_FORMAT for intArrays
                 // printf ("Force DECIMAL_DISPLAY_FORMAT for intArray objects! \n");
                    Local_Display_Format = DECIMAL_DISPLAY_FORMAT;
                  }

               if (Input_Array_Is_A_Temporary)
                  {
                 // Array_Descriptor.Is_A_Temporary = TRUE;
                    ((floatArray*) this)->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
#if defined(PPP)
                    Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
#endif
                  }
             }
#else
          printf ("WARNING: In floatArray::display() -- Smart display turned OFF! \n");
          Local_Display_Format = EXPONENTIAL_DISPLAY_FORMAT;
#endif

       // printf ("Local_Display_Format = %d \n",Local_Display_Format);
          APP_ASSERT ( (Local_Display_Format == DECIMAL_DISPLAY_FORMAT) || 
                       (Local_Display_Format == EXPONENTIAL_DISPLAY_FORMAT) );
       // printf ("Call the MDI function! \n");
#if !defined(USE_EXPRESSION_TEMPLATES)
          MDI_float_Print_Array ( Array_Descriptor.Array_Data , (array_domain*)(&Array_Descriptor.Array_Domain) , Local_Display_Format );
#else
       // APP_DEBUG = 2;
          MDI_Display();
       // APP_DEBUG = 0;
// end of !defined(USE_EXPRESSION_TEMPLATES)
#endif
        }
#endif

     return *((floatArray *) this);
   }

#if 1
// We are forced to at least temporarily disable some of the deferred evaluation
// features since they are inconsistant with the use of expression template implementation.
// ************************************************************
// Do nothing here since we only want to have the linked list of 
// Expression_Tree_Node_Type objects built! 
// it is not important to attached the expresion tree to the intermediate
// array values (though this was done in the work for Sandia originally).
// If we wanted to do so then this is the place to do it!
// ************************************************************
void
floatArray::Add_Defered_Expression ( Expression_Tree_Node_Type* X ) const 
   {
    // Avoid the compiler's warning about lack of use by using X in a meaningless statement
    Expression_Tree_Node_Type* Avoid_Compiler_Warning = X;

#if COMPILE_DEBUG_STATEMENTS
       if (APP_DEBUG > 3)
            printf ("Inside of floatArray::Add_Defered_Expression (Expression_Tree_Node_Type* X)! \n");
#endif
   }
#endif

// ************************************************************
// Required for support of the defered evaluation!
// ************************************************************
int
floatArray::Array_ID () const 
   {
     return Array_Descriptor.Array_ID();
   }

// ************************************************************
// setBase changes the base of an array object (for all dimensions)
// Even the base of a view can be changed!
// ************************************************************
floatArray &
floatArray::setBase( int New_Base_For_All_Axes )
   {
     Array_Descriptor.setBase(New_Base_For_All_Axes);
     return *this;
   }

// ************************************************************
// setBase changes the base of an array object. Even the base 
// of a view can be changed!
// ************************************************************
floatArray &
floatArray::setBase( int New_Base , int Axis )
   {
     Array_Descriptor.setBase (New_Base,Axis);
     return *this;
   }

#if 0
// ************************************************************
// setParallelBase changes the base of an array object. Even the base 
// of a view can be changed!
// ************************************************************
floatArray &
floatArray::setParallelBase( int New_Base , int Axis )
   {
   // ... this doesn't change the SerialArray values ...
#if COMPILE_DEBUG_STATEMENTS
  // Enforce bound on Alt_Base depending on INT_MAX and INT_MIN
     static int Max_Base = INT_MAX;
     static int Min_Base = INT_MIN;

  // error checking!
     APP_ASSERT((New_Base > Min_Base) && (New_Base < Max_Base));
#endif

  // If there is an outstanding reference then we have to
  // break the reference by forcing a copy of the descriptor.
  // Then we can modify the new descriptor.
     if (Array_Descriptor.referenceCount > getReferenceCountBase())
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("ReferenceCount = %d -- Breaking reference to other descriptor! \n",Array_Descriptor.referenceCount);
#endif
          printf ("This should be unreachable code! \n");
          APP_ABORT();
          Array_Descriptor.referenceCount--;
        }

     int i = 0;
     int Scalar_Offset = 0;
     int Difference = New_Base - (Array_Descriptor.Array_Domain.Data_Base[Axis] + 
	Array_Descriptor.Array_Domain.Base[Axis]);

#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
  // Adjust the Data_Base on the LOCAL SerialArray relative to the change in the 
  // GLOBAL base
     Array_Descriptor.Array_Domain.Global_Index     [Axis]      += Difference;
     Array_Descriptor.Array_Domain.Local_Mask_Index [Axis]      += Difference;
#endif

     Scalar_Offset = Difference * Array_Descriptor.Array_Domain.Stride[Axis];
     if (Axis>0) Scalar_Offset *= Array_Descriptor.Array_Domain.Size[Axis-1];

     APP_ASSERT (Array_Descriptor.isView() || (Array_Descriptor.Array_Domain.Base[Axis] == 0) );

     Array_Descriptor.Array_Domain.Data_Base [Axis] = New_Base - Array_Descriptor.Array_Domain.Base[Axis];
     Array_Descriptor.Array_Domain.User_Base [Axis] += Difference;

     for (i = Axis;i<MAX_ARRAY_DIMENSION;i++)
       Array_Descriptor.Array_Domain.Scalar_Offset[i] -= Scalar_Offset; 

#if defined(PPP)
     // ... might not need this but shouldn't hurt ...
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;
#else
     POINTER_LIST_INITIALIZATION_MACRO;
#endif

     return *this;
   }
#endif

// ********************************************************************
// ********************************************************************
// Get base for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  It is an error to use this function unless all bases
// have the same value.
// ********************************************************************
int
floatArray::getBase() const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);

  // Check for the same value in each dimension!
  // APP_ASSERT( (Array_Descriptor->Base [0] == Array_Descriptor->Base [1]) && 
  //         (Array_Descriptor->Base [2] == Array_Descriptor->Base [3]) &&
  //         (Array_Descriptor->Base [0] == Array_Descriptor->Base [2]) );

     int temp = 0;
     for (temp=1;temp<MAX_ARRAY_DIMENSION;temp++)
          APP_ASSERT(Array_Descriptor.Array_Domain.User_Base[0] == Array_Descriptor.Array_Domain.User_Base[temp]);

     Temp_Base = Array_Descriptor.Array_Domain.User_Base [0];
  // Temp_Base = Array_Descriptor.Array_Domain.Data_Base [0] + Array_Descriptor.Array_Domain.Base [0];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getBase(0));

     return Temp_Base;
   }

int
floatArray::getRawBase() const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);

  // Check for the same value in each dimension!
  // APP_ASSERT( (Array_Descriptor->Base [0] == Array_Descriptor->Base [1]) && 
  //         (Array_Descriptor->Base [2] == Array_Descriptor->Base [3]) &&
  //         (Array_Descriptor->Base [0] == Array_Descriptor->Base [2]) );

     int temp = 0;
     for (temp=1;temp<MAX_ARRAY_DIMENSION;temp++)
        APP_ASSERT
	   (Array_Descriptor.Array_Domain.Base[0] + Array_Descriptor.Array_Domain.Data_Base[0] == 
	    Array_Descriptor.Array_Domain.Base[temp] + Array_Descriptor.Array_Domain.Data_Base[temp]);  

     Temp_Base = Array_Descriptor.Array_Domain.Data_Base [0] + Array_Descriptor.Array_Domain.Base [0];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getRawBase(0));

     return Temp_Base;
   }

// ********************************************************************
// Get base for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  The Base can be accessed seperately for each dimension.
// ********************************************************************
int
floatArray::getDataBase( int Axis ) const
   {
     int Temp_Base = 0;

     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     Temp_Base = Array_Descriptor.Array_Domain.Data_Base[Axis];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getDataBase(Axis));

     return Temp_Base;
   }

int
floatArray::getBase( int Axis ) const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // The global base is returned for views to comform with HPF indexing of views!
  // Bug fix (7/27/94) views of views are incorrect
  // Temp_Base = Array_Descriptor->Base[Axis]; 
  // Temp_Base = Array_Descriptor->Data_Base[Axis]; 
  // Temp_Base = Array_Descriptor->Data_Base[Axis]+Array_Descriptor->Base[Axis]; 
     Temp_Base = Array_Descriptor.Array_Domain.User_Base[Axis];

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getBase(Axis));

     return Temp_Base;
   }

int
floatArray::getRawBase( int Axis ) const
   {
     int Temp_Base = 0;

  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // The global base is returned for views to comform with HPF indexing of views!
  // Bug fix (7/27/94) views of views are incorrect
  // Temp_Base = Array_Descriptor->Base[Axis]; 
  // Temp_Base = Array_Descriptor->Data_Base[Axis]; 
     Temp_Base = Array_Descriptor.Array_Domain.Data_Base[Axis]+Array_Descriptor.Array_Domain.Base[Axis]; 

  // double check for consistant result!
     APP_ASSERT (Temp_Base == Array_Descriptor.getRawBase(Axis));

     return Temp_Base;
   }

// ********************************************************************
// Get bound for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
floatArray::getBound( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // Bugfix (12/1/94) incorrect bound was combuted for a view!
  // return Array_Descriptor->Data_Base[Axis]+(Array_Descriptor->Bound[Axis]-Array_Descriptor->Base[Axis]); 
  // int Temp_Bound = Array_Descriptor->Data_Base[Axis]+Array_Descriptor->Bound[Axis]; 
     int Temp_Bound = Array_Descriptor.Array_Domain.User_Base[Axis]+
	(Array_Descriptor.Array_Domain.Bound[Axis]-Array_Descriptor.Array_Domain.Base[Axis]) /
	Array_Descriptor.Array_Domain.Stride[Axis]; 

  // double check for consistant result!
     APP_ASSERT (Temp_Bound == Array_Descriptor.getBound(Axis));

     return Temp_Bound;
   }

int
floatArray::getRawBound( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // Bugfix (12/1/94) incorrect bound was combuted for a view!
  // return Array_Descriptor.Array_Domain.Data_Base[Axis]+(Array_Descriptor.Array_Domain.Bound[Axis]-Array_Descriptor.Array_Domain.Base[Axis]); 
     int Temp_Bound = Array_Descriptor.Array_Domain.Data_Base[Axis]+ Array_Descriptor.Array_Domain.Bound[Axis]; 

  // double check for consistant result!
     APP_ASSERT (Temp_Bound == Array_Descriptor.getRawBound(Axis));

     return Temp_Bound;
   }

// ********************************************************************
// Get stride for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
floatArray::getStride( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

  // int Temp_Stride = Array_Descriptor.Array_Domain.Stride[Axis]; 
     int Temp_Stride = 1;

  // double check for consistant result!
     APP_ASSERT (Temp_Stride == Array_Descriptor.getStride(Axis));

     return Temp_Stride;
   }

int
floatArray::getRawStride( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     int Temp_Stride = Array_Descriptor.Array_Domain.Stride[Axis]; 

  // double check for consistant result!
  // ... bug fix (10/9/96,kdb) the raw strides should be the same ...
  //   APP_ASSERT (Temp_Stride == Array_Descriptor->getStride(Axis));
     APP_ASSERT (Temp_Stride == Array_Descriptor.getRawStride(Axis));

     return Temp_Stride;
   }

// ********************************************************************
// Get number of dimensions of the array objects (note that a 1x2 array is 2 dimensional)
// ********************************************************************
int
floatArray::numberOfDimensions () const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.numberOfDimensions();
   }

// ********************************************************************
// Get length for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
floatArray::getLength( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     return Array_Descriptor.getLength(Axis);
   }

// ********************************************************************
// Get raw data size for use in accessing the A++ data directly from 
// a pointer (obtained via the getDataPointer member function).
// ********************************************************************
int
floatArray::getRawDataSize( int Axis ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     return Array_Descriptor.getRawDataSize(Axis);
   }

// ********************************************************************
// Array size by axis - Works correctly for views too!
// This function has been devalued in it present form and will
// return a Range object in the future (maybe an Internal_Index).
// This function has returned after having been devalued (it now returns
// a Range object).  Geoff had suggested this some time ago.
// This function does not work for indirect addressing.
// ********************************************************************
Range
floatArray::dimension( int Axis ) const
   {
  // This function is called so often that it shouuld be inlined
  // alternatively the lower level function might be called instead 
  // of this one (then that function should be inlined -- and it is).

  // printf ("Inside of floatArray::Dimension(%d) \n",Axis);
  // APP_ASSERT(Array_Descriptor != NULL);
     APP_ASSERT((Axis >= 0) && (Axis < MAX_ARRAY_DIMENSION));

     return Array_Descriptor.dimension( Axis );
   }

#if defined(APP) || defined(PPP)
// ********************************************************************
// ********************************************************************
// These functions are specific to P++ and provide informationabout the 
// local partition instead of the global distributed array.
// ********************************************************************
// ********************************************************************

// ********************************************************************
// Get LOCAL Range for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  The dimension can be accessed seperately for each dimension.
// ********************************************************************
Range
floatArray::localDimension( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->dimension( Axis );
#else
     return dimension( Axis );
#endif
   }

// ********************************************************************
// Get LOCAL base for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).  The Base can be accessed seperately for each dimension.
// ********************************************************************
int
floatArray::getLocalBase( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getBase(Axis);
#else
     return getBase(Axis);
#endif
   }

// ********************************************************************
// Get LOCAL bound for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
floatArray::getLocalBound( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getBound(Axis);
#else
     return getBound(Axis);
#endif
   }

int
floatArray::getLocalRawBase( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getRawBase(Axis);
#else
     return getRawBase(Axis);
#endif
   }

int
floatArray::getLocalRawBound( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getRawBound(Axis);
#else
     return getRawBound(Axis);
#endif
   }

// ********************************************************************
// Get LOCAL stride for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
floatArray::getLocalStride( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getStride(Axis);
#else
     return getStride(Axis);
#endif
   }

int
floatArray::getLocalRawStride( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getRawStride(Axis);
#else
     return getRawStride(Axis);
#endif
   }

// ********************************************************************
// Get LOCAL stride for use in building A++ Index objects (not applicable to
// manipulation of the raw data obtained from getDataPointer member
// function).
// ********************************************************************
int
floatArray::getLocalLength( int Axis ) const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getLength(Axis);
#else
     return getLength(Axis);
#endif
   }

// ********************************************************************
// total array size (total number of elements in array (or view))!
// ********************************************************************
int
floatArray::getLocalSize() const
   {
#if defined(PPP)
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);
     return Array_Descriptor.SerialArray->getSize();
#else
     return getSize();
#endif
   }
#endif

// ********************************************************************
// total array size (total number of elements in array (or view))!
// ********************************************************************
int
floatArray::getSize() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
  // using the size is incorrect since the size is not modified when we take a view!
  // return Array_Descriptor->Size[3]; 
  // I think this is the only way! Or computing it directly!
  // The Array_Size function didn't propoerly acount for non unit strides - but this is fixed now!
     return Array_Descriptor.Array_Size(); 
   }

// ********************************************************************
// total array size (total number of elements in array (or view))!
// ********************************************************************
int
floatArray::elementCount() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
  // using the size is incorrect since the size is not modified when we take a view!
  // return Array_Descriptor->Size[3]; 
  // I think this is the only way! Or computing it directly!
  // The Array_Size function didn't propoerly acount for non unit strides - but this is fixed now!
     return Array_Descriptor.Array_Size(); 
   }

// ********************************************************************
/* Number of columns and rows useful for 2D arrays (part of defined interface)! */
// ********************************************************************
int
floatArray::cols() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.getLength(1); 
   }

// ********************************************************************
/* Number of columns and rows useful for 2D arrays (part of defined interface)! */
// ********************************************************************
int
floatArray::rows() const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.getLength(0); 
   }

bool
floatArray::isSameBase ( const floatArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameBase(X.Array_Descriptor);
   }

bool
floatArray::isSameBound ( const floatArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameBound(X.Array_Descriptor);
   }

bool
floatArray::isSameStride ( const floatArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameStride(X.Array_Descriptor);
   }

bool
floatArray::isSameLength ( const floatArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSameLength(X.Array_Descriptor);
   }

#if defined(APP) || defined(PPP)
bool
floatArray::isSameGhostBoundaryWidth ( const floatArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameGhostBoundaryWidth(X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameGhostBoundaryWidth
	(X.Array_Descriptor.Array_Domain);
   }
bool
floatArray::isSameDistribution ( const intArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameDistribution (X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameDistribution 
	(X.Array_Descriptor.Array_Domain);
   }
bool
floatArray::isSameDistribution ( const floatArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameDistribution (X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameDistribution 
	(X.Array_Descriptor.Array_Domain);
   }
bool
floatArray::isSameDistribution ( const doubleArray & X ) const
   {
  // APP_ASSERT(Array_Descriptor != NULL);
     //return Array_Descriptor.isSameDistribution (X.Array_Descriptor);
     return Array_Descriptor.Array_Domain.isSameDistribution 
	(X.Array_Descriptor.Array_Domain);
   }
#endif

bool
floatArray::isSimilar ( const floatArray & X ) const
   {
  // This function is a dimension independent test of equality
  // between the bases of each axis of two array descriptors.

  // APP_ASSERT(Array_Descriptor != NULL);
     return Array_Descriptor.isSimilar(X.Array_Descriptor);
   }

#if 0
// ********************************************************************
// Control the ablity to resize and array throught assignment
// This whole process is greatly cleaned up over that of M++!
// A++ array objects can not be redimensioned through assignment
// ********************************************************************
int floatArray::lock()
   {
     printf ("Sorry, floatArray::lock not implemented yet! \n");
  // APP_ABORT();
     return 0;
   }

int floatArray::unlock()
   {
     printf ("Sorry, floatArray::unlock not implemented yet! \n");
  // APP_ABORT();
     return 0;
   }
#endif

// ********************************************************************
// dimensioning member functions: allow the user to reset the size of an
// existing array (redim does not preserve the original data (see resize)).
// ********************************************************************
// floatArray & floatArray::redim ( int i , int j , int k , int l )
floatArray &
floatArray::redim ( ARGUMENT_LIST_MACRO_INTEGER )
   {
  // It is the responcibility of the user to be certain that
  // no references to the current data exist! Same as in any array class!

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

     return redim (Integer_List);
   }

floatArray &
floatArray::redim ( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
  // This is the main function called to handle the redimensioning of array objects.
  // Several other interface functions each call this function to do the heavy lifting
  // This function does not change the partitioning object in use if it is associated 
  // with thearray object. If there is not partitioning object then this function does 
  // not add one.

     int temp_index = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  floatArray::redim(int*) ");
          int temp = 0;
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }

     Test_Consistency("Called from TOP of floatArray::redim(int*)");

  // Error checking for inputs
     for (temp_index = 0; temp_index > MAX_ARRAY_DIMENSION; temp_index++)
        {
          if (Integer_List[0] == 0)
             {
            // Case of redim to NULL array object!
               APP_ASSERT (Integer_List[temp_index] == 0);
             }
            else
             {
            // Case of redim to non-NULL array object!
               APP_ASSERT (Integer_List[temp_index] > 0);
             }
        }
#endif

#if EXTRA_ERROR_CHECKING
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
       // There is currently no execution object that can perform this operation
       // so it cannot be processed in defered evaluation mode!
          printf ("ERROR: DEFER_EXPRESSION_EVALUATION == TRUE in floatArray::redim() \n");
          APP_ABORT();
        }
#endif

  // printf ("TOP of redim() getRawDataReferenceCount() = %d \n",getRawDataReferenceCount());

  // Note that this only handles the case where the first parameter is 
  // ZERO! The purpose of this code is to permit views to be turned
  // into NULL array objects even though a it makes no sense (that we 
  // know of) to redim a view.
     int redim_to_zero = (Integer_List[0] != 0) ? FALSE : TRUE;
     if (Index::Index_Bounds_Checking)
	{
	  if ( Array_Descriptor.isView() == TRUE && !redim_to_zero )
	     {
	       printf ("ERROR: can only redim a view to zero (forming a NULL array) \n");
	       APP_ABORT();
	     }
	}

#if EXTRA_ERROR_CHECKING
  // Check the input values to make sure that we are correctly handling the null array case
     if (redim_to_zero == TRUE)
        {
          int i;
       // We can't insure that if one of the values is zero that all others will be zero!
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
               APP_ASSERT (Integer_List[i] >= 0);
        }
       else
        {
          int i;
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
               APP_ASSERT (Integer_List[i] >= 1);
        }
#endif

#if defined(PPP)
  // Declaration specific to P++ (the result could be a NULL pointer)
     Internal_Partitioning_Type* currentPartition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("In redim: Remove the associatation with the currentPartition \n");
#endif
     if (currentPartition != NULL)
          Internal_Partitioning_Type::DeleteArrayToPartitioning(*currentPartition,*this);
       else
          Internal_Partitioning_Type::DeleteArrayToPartitioning(*this);

#if COMPILE_DEBUG_STATEMENTS
     int numberOfReferencesBeforeRedim = (currentPartition != NULL) ? currentPartition->referenceCount : 0;
#endif
#endif

  // delete current array info!
  // printf ("BEFORE Delete_Array_Data() getRawDataReferenceCount() = %d \n",getRawDataReferenceCount());
  // We should be able to remove this once we have a non-zero base reference count value!
  // The problem is that the inialization of the Domain assumes that the refeence count is zero if the Array_Data == NULL
  // It used to be that the descriptor's destructor would zero the reference count but now 
  // this is not called because the Array_Descriptor_Type is a member of the array object (instead of a pointer).
     Delete_Array_Data();
  // printf ("AFTER Delete_Array_Data() Array_ID() = %d  getRawDataReferenceCount() = %d \n",Array_ID(),getRawDataReferenceCount());

#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("In redim: This should have already been done in the Delete_Array_Data() member function \n");
#endif

#if defined(PPP)
  // This should have already been done in the Delete_Array_Data() member function
     Array_Descriptor.SerialArray = NULL;
#else
  // This should have already been done in the Delete_Array_Data() member function
     Array_Descriptor.Array_Data  = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("#1 currentPartition->referenceCount              = %d \n",currentPartition->referenceCount);
#endif
#endif

  // This copies the old data so we can reuse it this is a
  // relatively expensive operation since the whole object is copied
  // This cales the copy constructor (which may not be the right thing to do)
  // Array_Descriptor_Type Old_Array_Descriptor = Array_Descriptor;
  // Alternatively we can just save the little amount of data from the
  // old descriptor as is required.
     int     Old_Array_ID               = Array_ID();
     bool Old_builtUsingExistingData = Array_Descriptor.Array_Domain.builtUsingExistingData;
#if defined(PPP)

#if 0
  // It is not possible to have a partitioning object be associated with a NullArray object
  // so we don't want to throw away the existing partitioning object.
     if (redim_to_zero == TRUE)
        {
       // If we are going to make this a NULL array then we want to give up the 
       // partitioning object (since we will get a new one if this object is ever 
       // used in an subsequent assignment)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
             {
            // printf ("In floatArray::redim --- delete Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer commented out! \n");

            // Additional error checking (11/14/2000)
               APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                           Internal_Partitioning_Type::getReferenceCountBase());

               Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
               if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() <
                   Internal_Partitioning_Type::getReferenceCountBase())
                    delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
             }
          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;

          APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL);
        }
#endif

  // Internal_Partitioning_Type *Old_Partition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
  // printf ("In redim: Old_Partition = %p \n",Old_Partition);

#if 1
  // This should be done by the call to the ArrayDomain::partition() function 
  // within the Array_Descriptor.Initialize_Descriptor
#if PRINT_SOURCE_CODE_IMPLEMENTATION_WARNINGS
     printf ("Put this code into the ArrayDomain::partition() function \n");
#endif

  // Now we want to remove all the existing distribution descriptor data so that it
  // will not be reused when we build a new and (likely) different size array object.
#if defined(USE_PADRE)
  // Let the allocation of data reinitialize the PADRE object pointer with a new PADRE_Descriptor
     if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
        {
          Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->decrementReferenceCount();
          if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->getReferenceCount() <
              Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->getReferenceCountBase())
               delete Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer;
        }
     Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer = NULL;

#else
     if (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition != NULL)
        {
          APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition->referenceCount >= 1);
          delete_DECOMP(Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition);  
        }
     Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition = NULL;

     if (Array_Descriptor.Array_Domain.BlockPartiArrayDomain!= NULL)
        {
       // Shouldn't the upper limit be 1 instead of 0?
          APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDomain->referenceCount >= 0);
          delete_DARRAY(Array_Descriptor.Array_Domain.BlockPartiArrayDomain);  
        }
     Array_Descriptor.Array_Domain.BlockPartiArrayDomain = NULL;

  // End USE_PADRE not defined
#endif
#endif

     APP_ASSERT (Array_Descriptor.SerialArray == NULL);

  // Reinitialize the descriptor with data about the size of the new array (include the partition object for P++)
  // This function does not assume that Old_Partition is a valid pointer (could be NULL pointer)
     Array_Descriptor.Initialize_Descriptor ( MAX_ARRAY_DIMENSION, Integer_List, currentPartition );

  // Now decrement the reference count to make up to how the last function incremented it
  // We know that we can do this because the same partitioning object is just reused.
     if (currentPartition != NULL)
          currentPartition->decrementReferenceCount();

#if defined(USE_PADRE)
     APP_ASSERT (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer == NULL);
#else
     APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition == NULL);
     APP_ASSERT (Array_Descriptor.Array_Domain.BlockPartiArrayDomain        == NULL);
  // End of USE_PADRE not defined
#endif

  // Error checking (make sure we have not dropped the partitioning object)
     APP_ASSERT ( ( (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL) && 
                    (currentPartition != NULL) ) || 
                  (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == currentPartition));

  // End of PPP defined
#else
  // if PPP not defined
     APP_ASSERT (Array_Descriptor.Array_Data == NULL);

  // We have to return the array id if we have deleted the data as part of the redim process.
     if (getRawDataReferenceCount() < getRawDataReferenceCountBase())
        {
       // Make sure the reference count is not too small (should be only one less than the reference count base)
          APP_ASSERT (getRawDataReferenceCount() >= getRawDataReferenceCountBase() - 1);

       // Then set it to the reference count base (from zero references to a
       // single reference since we will allocate data next)
          resetRawDataReferenceCount();

          Array_Domain_Type::Push_Array_ID (Old_Array_ID);
        }

  // printf ("In redim #3: Array_ID() = %d  and Old_Array_ID = %d \n",Array_ID(),Old_Array_ID);

  // Reinitialize the descriptor with data about the size of the new array (include the partition object for P++)
     Array_Descriptor.Initialize_Descriptor ( MAX_ARRAY_DIMENSION, Integer_List );

  // Bugfix (2/13/97) This fixes what appeared to be a memory leak in the redim function
  // Since the reference count includes the initial reference we have to return
  // the Array_ID before we would otherwise (one array reference before we would otherwise).
  // Note: See the comments in the ::adopt function since the same problem is handled there as well.
     if (Old_builtUsingExistingData == TRUE)
        {
       // printf ("Redimensioning an array built using adopt \n");
       // Extra error checking (11/16/2000)
          APP_ASSERT (Array_Domain_Type::Array_Reference_Count_Array [Old_Array_ID] >= getRawDataReferenceCountBase());
          if (Array_Domain_Type::Array_Reference_Count_Array [Old_Array_ID] <= getRawDataReferenceCountBase())
             {
            // Reinitialize reference count for next use!
            // We can't use resetRawDataReferenceCount since it internally 
            // uses Array_Descriptor instead of Old_Array_Descriptor
               Array_Domain_Type::Array_Reference_Count_Array [Old_Array_ID] = getRawDataReferenceCountBase();
               Array_Domain_Type::Push_Array_ID (Old_Array_ID);
             }
        }

  // End PPP not defined
#endif

  // Passing in TRUE avoids the defered allocation of data under defered evaluation
  // which is sometimes required.  However in this case it is at present an error
  // to use redim while defered evaluation is turned ON!
  // This function allocates the data for the serial and distributed parallel
  // arrays.  In the case of P++ it allocates only the processors part of the
  // data (info obtained from block parti array descriptor).
     Allocate_Array_Data(TRUE);

#if !defined(PPP)
     Array_Descriptor.Array_Domain.ExpressionTemplateOffset = 0;
     Array_Descriptor.Array_Domain.View_Offset              = 0;

     POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if defined(PPP)
  // Now update the ghost boundaries with valid data for the neighboring processors
     updateGhostBoundaries();

  // Verify that we saved the right partitioning object if it existed or not
     APP_ASSERT ( ( (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL) && 
                    (currentPartition != NULL) ) || 
                  (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == currentPartition));
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == currentPartition);

#if COMPILE_DEBUG_STATEMENTS
  // Error checking
     int numberOfReferencesAfterRedim = (currentPartition != NULL) ? currentPartition->referenceCount : 0;
     APP_ASSERT (numberOfReferencesBeforeRedim == numberOfReferencesAfterRedim);
#endif
#endif

#if defined(APP) || ( defined(SERIAL_APP) && !defined(PPP) )
  // For P++ we only track the serial array objects not the serial array objects
     if (Diagnostic_Manager::getTrackArrayData() == TRUE)
        {
       // Since we have changed the size of the array we have to reset the diagnostic data
       // Also initialize the type code in the diagnostic data object so we know the base type of the array object
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
#ifdef DOUBLEARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_DOUBLE_ELEMENT_TYPE);
#endif
#ifdef FLOATARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_FLOAT_ELEMENT_TYPE);
#endif
#ifdef INTARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_INT_ELEMENT_TYPE);
#endif
        }
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Called from BASE of floatArray::redim(int,int,int,int)");
#endif

     return *this;
   }

// ********************************************************************
// redimension array using range objects to allow the specification 
// of both base and size of each dimension.
// ********************************************************************
floatArray &
floatArray::redim ( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     return redim (Internal_Index_List);
   }

// We need this to avoid an ERROR: Overloading ambiguity between "doubleArray::redim(const Array_Domain_Type&)" 
// and "doubleArray::redim(const Range&, const Range&, const Range&, const Range&, const Range&, const Range&)"
// so we need to implement a redim that takes a single Index object.
floatArray & 
floatArray::redim ( const Index & I )
   {
     Range I_Range = I;
     return redim (I_Range);
   }

floatArray & 
floatArray::redim ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;

     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          Integer_List[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base)+1;

     redim ( Integer_List );

  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");
  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");
  // printf ("Call setBase \n");
  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");
  // printf ("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ \n");

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          setBase (Internal_Index_List[temp]->Base,temp);

     return *this;
   }

// ********************************************************************
// redimension array using another array object as a source for info
// about base and size of each dimension.
// ********************************************************************
// template<class T , int Template_Dimension>
// floatArray & floatArray::redim ( const Array_Descriptor_Type<T,Template_Dimension> & X )
floatArray &
floatArray::redim ( const Array_Domain_Type & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  floatArray::redim (const Array_Domain_Type & X) \n");
#endif

  // Build Range objects
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // printf ("Inside of floatArray::redim (const floatArray & X) -- temp = %d \n",temp);

       // Bugfix (1/17/96) redim must account for stride in redimensioning of this array
       // just using base and bound was insufficient to get the correct size!
       // int Bound = X.getBound(temp);
       // Index_List[temp] = Internal_Index (Base,(Bound-Base)+1);
          int Base  = X.getBase(temp);
          int Length = X.getLength(temp);
          Index_List[temp] = Internal_Index (Base,Length);
          Internal_Index_List[temp] = &(Index_List[temp]);
        }

  // printf ("Inside of floatArray::redim (const floatArray & X) calling redim(Internal_Index_List) \n");

  // Call redim using Range objects
     redim (Internal_Index_List);

     return *this;
   }

// ********************************************************************
// redimension array using another array object as a source for info 
// about base and size of each dimension.
// ********************************************************************
floatArray &
floatArray::redim ( const floatArray & X ) 
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  floatArray::redim (const floatArray & X) \n");
#endif

     redim (X.Array_Descriptor.Array_Domain);
     return *this;
   }

// ********************************************************************
// This function acts like a copy constructor but for an existing object
// thus no new object is built. The default is a deep copy.  The only option
// is a shallow copy (same as a reference).
// ********************************************************************
floatArray &
floatArray::copy ( const floatArray & X , int Type_Of_Copy ) 
   {
  // This copy function does deep copies or shallow copies depending on the Type_Of_Copy input
  // APP_ASSERT( this != &((floatArray &) X) );

     if ( this != &((floatArray &) X) )
        { 
          if (Type_Of_Copy == DEEPCOPY)
             {
            // redimension and then call the assignment operator to copy the data.
               redim (X);
               operator= (X);
             }
            else
             {
               if (Type_Of_Copy == SHALLOWCOPY)
                  {
                 // call the reference member function
                    reference (X);
                  }
                 else
                  {
                    printf ("In floatArray::copy has bad Type_Of_Copy input (Use DEEPCOPY or SHALLOWCOPY)! \n");
                    APP_ABORT();
                  }
             }
        }
       else
        {
          printf ("Note: floatArray::copy handed itself as input (copy skipped)! \n");
        }

     return *this;
   }

// ********************************************************************
// The reshape function uses an existing A++ array and redimensions
// it to be a different size without changing the number of elements.
// It is an error to change the number of elements in the reshaped array.
// The number of total elements before and after reshape must be the same.
// ********************************************************************
// floatArray & floatArray::reshape ( int i , int j , int k , int l )
floatArray &
floatArray::reshape ( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  floatArray::reshape ");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }

     Test_Consistency("Called from TOP of floatArray::reshape(int,int,int,int)");
#endif

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#0 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
#endif
#endif

  // Bugfix (11/26/96) Make the error checking avaiable when the bounds checking is turned on
     int Number_Of_Elements_Before_Reshape = 0;
     if (Index::Index_Bounds_Checking != FALSE)
          Number_Of_Elements_Before_Reshape = elementCount();

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Number_Of_Elements_Before_Reshape = %d \n",Number_Of_Elements_Before_Reshape);
#endif

  // Support for leading one feature of the reshape function
     int indexPosition = 0;
     while ( ( (Integer_List[indexPosition] == 1) && (getLength(indexPosition) != 1) ) &&
             (indexPosition < MAX_ARRAY_DIMENSION) )
        {
          indexPosition++;
        }
     int numberOfLeadingOnesAddedInNewArrayShape = indexPosition;

     indexPosition = 0;
     while ( ( (Integer_List[indexPosition] != 1) && (getLength(indexPosition) == 1) ) &&
             (indexPosition < MAX_ARRAY_DIMENSION) )
        {
          indexPosition++;
        }
     int numberOfLeadingOnesRemovedInNewArrayShape = indexPosition;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("numberOfLeadingOnesAddedInNewArrayShape = %d numberOfLeadingOnesRemovedInNewArrayShape = %d \n",
               numberOfLeadingOnesAddedInNewArrayShape,numberOfLeadingOnesRemovedInNewArrayShape);
        }
#endif

  // Now modify the child partitioning to reflect the non-distributed dimensions
  // that we add with unit length (length == 1)
  // Error checking for deleting non-distributed unit dimensions
     APP_ASSERT (numberOfLeadingOnesRemovedInNewArrayShape >= 0);
     APP_ASSERT (numberOfLeadingOnesRemovedInNewArrayShape < MAX_ARRAY_DIMENSION);

  // Error checking for adding non-distributed unit dimensions
     APP_ASSERT (numberOfLeadingOnesAddedInNewArrayShape >= 0);
     APP_ASSERT (numberOfLeadingOnesAddedInNewArrayShape < MAX_ARRAY_DIMENSION);

  // Make sure that we don't think we are both added and deleting leading unit dimensions!
     APP_ASSERT ( (numberOfLeadingOnesRemovedInNewArrayShape == 0) || (numberOfLeadingOnesAddedInNewArrayShape == 0));

#if defined(PPP)
  // This function is implemented with a P++ section and an A++ section
  // START OF P++ SECTION OF RESHAPE

  // We have to call resize here since the effect of having ghost boundaries
  // prevents a trivial manipulation of the existing memory.  This is because the 
  // ghost boundaries are connected to the raw data (in the usual way).
  // As a result we have to build new partitioning objects to represent the 
  // distributions with different axes specified as distributed or not distributed
  // (not because we have different ghost boundary widths!!! (I think))

     Internal_Partitioning_Type* parentPartitioningObject = NULL;
  // Internal_Partitioning_Type* childPartitioningObject  = NULL;
     Internal_Partitioning_Type* newPartitioningObject    = NULL;

  // ... bug fix (11/6/96, kdb) this checks cause problems if the SerialArray
  // is a null array so skip them and rest of code should be okay ...
     if (!Array_Descriptor.SerialArray->Array_Descriptor.isNullArray())
        {

#if COMPILE_DEBUG_STATEMENTS
       // Handle case of removing dimensions
          if (numberOfLeadingOnesRemovedInNewArrayShape > 0)
             {
            // loop over the dimensions and verify that the dimensions we
            // will remove are not distributed (in the partition object)
               int i = 0;
               for (i = 0; i < numberOfLeadingOnesAddedInNewArrayShape; i++)
                  {
                    APP_ASSERT (Array_Domain_Type::isPartitioned(Array_Descriptor.Array_Domain,Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain,i) == TRUE);
                  }
             }
#endif

          if (numberOfLeadingOnesAddedInNewArrayShape > 0)
             {
               bool usingDefaultPartitioning = (getInternalPartitionPointer() == NULL) ? TRUE : FALSE;

               if (usingDefaultPartitioning == TRUE)
                  {
                 // Build a new partitioning object
                    parentPartitioningObject = NULL;
#if 0
                    printf ("Building new child partitioning object \n");
#endif
                    newPartitioningObject = new Internal_Partitioning_Type();

                    APP_ASSERT (newPartitioningObject->getReferenceCount() ==
                                Internal_Partitioning_Type::getReferenceCountBase());
                 // Bugfix (11/27/2000)
                 // newPartitioningObject->decrementReferenceCount();
                  }
                 else
                  {
                 // Use the copy constructor to build a new partitioning object (matching the parent)
#if 0
                    printf ("Building new child partitioning object using copy constructor from parent \n");
#endif
                    parentPartitioningObject = getInternalPartitionPointer();
                    parentPartitioningObject->incrementReferenceCount();

                    newPartitioningObject = new Internal_Partitioning_Type(*parentPartitioningObject);

                    APP_ASSERT (newPartitioningObject->getReferenceCount() ==
                                Internal_Partitioning_Type::getReferenceCountBase());
                 // Bugfix (11/27/2000)
                    newPartitioningObject->decrementReferenceCount();
                  }

            // define parent/child relationship (avoid case where they are the same partitioning object)
               APP_ASSERT (newPartitioningObject != NULL);
               APP_ASSERT (newPartitioningObject != Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
               if (parentPartitioningObject != NULL)
                  {
                    newPartitioningObject->setParentPartitioningObject(parentPartitioningObject);
                    APP_ASSERT (newPartitioningObject->isRootOfPartitionTree == FALSE);
                  }

            // Handle case of adding dimensions
            // loop over the dimensions and mark the new child partitioning
            // object to have no distribution along these leading dimensions
               int i = 0;
               for (i = 0; i < numberOfLeadingOnesAddedInNewArrayShape; i++)
                  {
                 // All added unit dimensions should have zero ghost boundary
                 // width (since the raw data does not have them)
                    int ghostBoundaryWidth = 0;
                    newPartitioningObject->partitionAlongAxis(i,FALSE,ghostBoundaryWidth);
                  }
             }
            else
             {
#if 0
               printf ("Parent and child partitioning object are NULL \n");
#endif
               parentPartitioningObject = getInternalPartitionPointer();
#if 1
               if (parentPartitioningObject != NULL)
                    parentPartitioningObject->incrementReferenceCount();
#endif
               newPartitioningObject    = parentPartitioningObject;

               if (numberOfLeadingOnesRemovedInNewArrayShape > 0)
                  {
#if 0
                    printf ("Reusing parent as child partitioning object \n");
#endif
                    if (parentPartitioningObject->parentPartitioningObject != NULL)
                       {
#if 0
                         printf ("Getting the parentPartitioning of the parent partitioning object \n");
#endif
                         newPartitioningObject = parentPartitioningObject->parentPartitioningObject;
                       }
                  }

               if (newPartitioningObject != NULL)
                    newPartitioningObject->incrementReferenceCount();
             }

       // This does not have to be TRUE
       // APP_ASSERT (newPartitioningObject != NULL);

#if 0
#if defined(PPP)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
               printf ("Reshape-#1 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
            else
               printf ("Reshape-#1 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
          if (newPartitioningObject != NULL)
               printf ("Reshape-#1 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
            else
               printf ("Reshape-#1 newPartitioningObject is NULL \n");
#endif
#endif

#if 0
       // Now we have a new partitioning object for the reshaped array
       // (correctly associated with it's parent partitioning)
          if (parentPartitioningObject == NULL)
             {
               Internal_Partitioning_Type::displayDefaultValues("parentPartitioningObject");
             }
            else
             {
               parentPartitioningObject->display("parentPartitioningObject");
             }

          if (newPartitioningObject != NULL)
               newPartitioningObject->display("newPartitioningObject");

          printf ("Need to add this (new partitioning) to the list of associated partitionings (on the parent partitioning) \n");
#endif

       // We don't need this refernece any more so delete it now!
          if (parentPartitioningObject != NULL)
             {
               APP_ASSERT (parentPartitioningObject->getReferenceCount() >= Internal_Partitioning_Type::getReferenceCountBase());

               parentPartitioningObject->decrementReferenceCount();
               if (parentPartitioningObject->getReferenceCount() <
                   Internal_Partitioning_Type::getReferenceCountBase())
                  {
                 // printf ("calling delete parentPartitioningObject \n");
                    delete parentPartitioningObject;
                  }
               parentPartitioningObject = NULL;
             }
          APP_ASSERT (parentPartitioningObject == NULL);

          int Partitioned_Dims[MAX_ARRAY_DIMENSION];
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               Partitioned_Dims[temp] = Array_Domain_Type::isPartitioned (Array_Descriptor.Array_Domain,Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain,temp);

       // ... first determine if reshape will collapse a dimension that is partitioned ...
       // find the maximum dimension of the final reshaped array
          int reshape_dim = MAX_ARRAY_DIMENSION;
          temp = MAX_ARRAY_DIMENSION-1;
          while (temp>0)
             {
               if (Integer_List[temp--] == 1)
                    reshape_dim--;
                 else
                    break;
             }

       // printf ("reshape_dim = %d \n",reshape_dim);

#if 0
       // This is no longer a constraint (at least not with leading unit dimensions)

       // Are any of the higher dimensions distributed?
       // It might be that we can remove this as a restriction will a little more work!
          for (temp=reshape_dim; temp<MAX_ARRAY_DIMENSION; temp++)
             {
               if (Partitioned_Dims[temp])
                  {
                    printf("NOTE: can't reshape so that array collapses to a smaller \n");
                    printf("   dimensionality than a distributed dimension in P++ \n");
                    printf("   The problematic dimension is %d out of (0-%d) \n", temp, MAX_ARRAY_DIMENSION-1);
                 // APP_ABORT();
                  }
             }
#endif

#if 1
       // This is no longer a constraint (at least not with leading unit dimensions)

       // The following loop is related to a mechanism in reshape which I don't think is used in 
       // parallel and might be a problem with ghost boundaries (but I'm not certain).
          int old_cntr = 0;
          int new_cntr = 0;
          do {
            // ... find which dimension of new array will have partitions
            // coresponding to old partitions and check to make sure
            // lengths are the same ...

               int old_prod = 1;
               while (!Partitioned_Dims[old_cntr]) 
                  {
                    old_prod *= getLength(old_cntr);
                    old_cntr++;
                    if (old_cntr >= MAX_ARRAY_DIMENSION) break;
                  }

            // Now "old_cntr" corresponds to new partitioned dimension or is >= MAX_ARRAY_DIMENSION

               int new_prod = 1;
               if (old_cntr > 0)
                  {
                    new_prod = Integer_List[new_cntr];
                    while (new_prod <= old_prod)
                       {
	                 new_cntr++;
                         if (new_cntr >= MAX_ARRAY_DIMENSION) break;
                         new_prod *= Integer_List[new_cntr];
                       }
                  }

            // Now "new_cntr" correspond to new partitioned dimension or is >= MAX_ARRAY_DIMENSION

               if (old_cntr == MAX_ARRAY_DIMENSION || new_cntr == MAX_ARRAY_DIMENSION)
		  break;

               if ( (getLength(old_cntr) != Integer_List[new_cntr]) && (Integer_List[new_cntr] != 1) )
                  {
                 // printf("NOTE: reshaping a distributed dimension in P++ with any length except 1 \n");
                 // printf("     getLength(old_cntr) != Integer_List[new_cntr] (%d != %d) \n",
                 //      getLength(old_cntr),Integer_List[new_cntr]);
                    printf("ERROR: can't reshape a distributed dimension in P++ with any length except 1 \n");
                    APP_ABORT();
                  }
               old_cntr++;
               new_cntr++;
             }
          while (old_cntr < MAX_ARRAY_DIMENSION && new_cntr < MAX_ARRAY_DIMENSION);
        }
#endif

  // ... save Array_ID from both parallel and serial arrays ...
     int Old_Parallel_ID = Array_ID();
     int Old_Serial_ID   = Array_Descriptor.SerialArray->Array_ID();

  // ... store pointer to data and increment reference count so the data in the
  // original SerialArray isn't deleted and then delete the SerialArray
  // so there isn't a memory leak ...
     float* Old_Data_Pointer = Array_Descriptor.SerialArray->Array_Descriptor.Array_Data;
     Array_Descriptor.SerialArray->incrementRawDataReferenceCount();

#if defined(USE_PADRE)
  // We have to remove the references in PADRE to the Serial_Array object
  // which is being deleted.  This is a consequence of P++ using PADRE in a way
  // so as to prevent the redundent storage of Array_Domain objects 
  // (specifically we use PADRE in a way so that only references are stored).
     setLocalDomainInPADRE_Descriptor(NULL);
#endif

  // printf ("In reshape: Array_Descriptor.SerialArray->getReferenceCount() = %d \n",Array_Descriptor.SerialArray->getReferenceCount() );
     APP_ASSERT (Array_Descriptor.SerialArray->getReferenceCount() >= getReferenceCountBase());

  // Added conventional mechanism for reference counting control
  // operator delete no longer decriments the referenceCount.
     Array_Descriptor.SerialArray->decrementReferenceCount();
     if (Array_Descriptor.SerialArray->getReferenceCount() < getReferenceCountBase())
          delete Array_Descriptor.SerialArray;
     Array_Descriptor.SerialArray = NULL;

#if 0
#if defined(PPP)
  // APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#2 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
       else
          printf ("Reshape-#2 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
     if (newPartitioningObject != NULL)
          printf ("Reshape-#2 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
       else
          printf ("Reshape-#2 newPartitioningObject is NULL \n");
#endif
#endif

  // ... save partitioning so reshaped array will have the same partition
  // and delete this from array list for partitioning because
  // Initialize_Array will add this back again. Also increment reference count. ...
     Internal_Partitioning_Type* old_partition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
     if (old_partition != NULL)
        {
          Internal_Partitioning_Type::DeleteArrayToPartitioning (*old_partition,*this);

       // printf ("In floatArray::reshape: Should we now be incrementing the reference count??? \n");

       // ... wrong thing to do because partion will only be deleted once for this array ...
       // old_partition->incrementReferenceCount();
        }
       else
        {
          Internal_Partitioning_Type::DeleteArrayToPartitioning (*this);
        }

#if 0
#if defined(PPP)
  // APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#3 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
       else
          printf ("Reshape-#3 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
     if (newPartitioningObject != NULL)
          printf ("Reshape-#3 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
       else
          printf ("Reshape-#3 newPartitioningObject is NULL \n");
#endif
#endif

  // Now delete the current Partitioning object???
  // Added error checking (11/19/2000)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
        {
          APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() >=
                      Internal_Partitioning_Type::getReferenceCountBase());

          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->decrementReferenceCount();
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getReferenceCount() <
              Internal_Partitioning_Type::getReferenceCountBase())
             {
            // printf ("calling delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
               delete Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
             }
          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = NULL;
        }
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL);

#if 0
#if defined(PPP)
     APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#3.5 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
     if (newPartitioningObject != NULL)
          printf ("Reshape-#3.5 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif

 //  Now attach the new partitioning object to the current array object
     if (newPartitioningObject != NULL)
        {
          printf ("Resetting the Array_Descriptor.Array_Domain.Partitioning_Object_Pointer \n");
          newPartitioningObject->incrementReferenceCount();
          Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = newPartitioningObject;
        }
#endif

#if 0
#if defined(PPP)
  // APP_ASSERT (newPartitioningObject != NULL);
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#4 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
       else
          printf ("Reshape-#4 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer is NULL \n");
     if (newPartitioningObject != NULL)
          printf ("Reshape-#4 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
       else
          printf ("Reshape-#4 newPartitioningObject is NULL \n");
#endif
#endif

#if defined(USE_PADRE)
  // What PADRE function should we call?
     if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer != NULL)
        {
          Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
	     decrementReferenceCount();
          if (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
	      getReferenceCount() <
              Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer->
	      getReferenceCountBase())
               delete Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer;
        }
     Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer = NULL;
#else
  // ... these get set to null without deleting by Initialize_Array ...
     if (Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition != NULL)  
          delete_DECOMP(Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition);  
     Array_Descriptor.Array_Domain.BlockPartiArrayDecomposition = NULL;

     if (Array_Descriptor.Array_Domain.BlockPartiArrayDomain!= NULL)  
          delete_DARRAY(Array_Descriptor.Array_Domain.BlockPartiArrayDomain);  
     Array_Descriptor.Array_Domain.BlockPartiArrayDomain = NULL;

  // End of USE_PADRE not defined
#endif

     if (APP_DEBUG > 0)
        {
          printf ("Inside of floatArray::reshape --- BEFORE Initialize_Array(MAX_ARRAY_DIMENSION,Integer_List) ");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }

  // Compute the dimension of the new array object (it might be different from the old array object!)
     int newNumberOfDimensions = Array_Domain_Type::computeDimension(Integer_List);

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#5 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
     if (newPartitioningObject != NULL)
          printf ("Reshape-#5 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif
#endif

  // printf ("In reshape: newNumberOfDimensions = %d \n",newNumberOfDimensions);

  // The newPartitioningObject could be NULL if it represents the parent 
  // (removing leading unit dimensions) and the parent represent the default partitioning
     if (newPartitioningObject == NULL)
        {
       // printf ("Calling Initialize_Descriptor and initializeArray: newPartitioningObject == NULL \n");
       // Array_Descriptor.Array_Domain.Initialize_Domain ( MAX_ARRAY_DIMENSION, Integer_List );
          Array_Descriptor.Initialize_Descriptor (newNumberOfDimensions,Integer_List,NULL);
          initializeArray ();
        }
       else
        {
       // printf ("Calling Initialize_Descriptor and initializeArray: newPartitioningObject != NULL \n");
       // Array_Descriptor.Array_Domain.Initialize_Domain ( MAX_ARRAY_DIMENSION, Integer_List,*newPartitioningObject );
       // Array_Descriptor.Array_Domain.display("newPartitioningObject != NULL");

#if 0
#if defined(PPP)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
               printf ("Reshape-#6 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
          if (newPartitioningObject != NULL)
             {
               printf ("Reshape-#6 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
               printf ("#6 newPartitioningObject->intArrayList.getLength()    = %d \n",newPartitioningObject->intArrayList.getLength());
               printf ("#6 newPartitioningObject->floatArrayList.getLength()  = %d \n",newPartitioningObject->floatArrayList.getLength());
               printf ("#6 newPartitioningObject->doubleArrayList.getLength() = %d \n",newPartitioningObject->doubleArrayList.getLength());
            // APP_ASSERT (newPartitioningObject->intArrayList.getLength()+newPartitioningObject->floatArrayList.getLength()+newPartitioningObject->doubleArrayList.getLength()+Internal_Partitioning_Type::getReferenceCountBase() == newPartitioningObject->referenceCount);
             }
#endif
#endif

          APP_ASSERT (newPartitioningObject != NULL);
          APP_ASSERT (newPartitioningObject != Array_Descriptor.Array_Domain.Partitioning_Object_Pointer);
          Array_Descriptor.Initialize_Descriptor (newNumberOfDimensions,Integer_List,newPartitioningObject);

       // The serialArray is not allocated and this leads to an assertion failure
       // Array_Descriptor.display("newPartitioningObject != NULL");

#if 0
#if defined(PPP)
          if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
               printf ("Reshape-#7 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
          if (newPartitioningObject != NULL)
               printf ("Reshape-#7 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif
#endif

       // This causes the partitioning object to be initialized again (and its reference count incremented again)
       // initializeArray (*newPartitioningObject);
       // initializeArray ();
          initializeArray (*newPartitioningObject);

#if 0
          printf ("Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getLocalGhostCellWidth(0) = %d \n",
                   Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getLocalGhostCellWidth(0));
          printf ("Array_Descriptor.Array_Domain.InternalGhostCellWidth [0] = %d \n",
                   Array_Descriptor.Array_Domain.InternalGhostCellWidth [0]);
#endif
          APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->getLocalGhostCellWidth(0) == 
                      Array_Descriptor.Array_Domain.InternalGhostCellWidth [0]);

          APP_ASSERT (Array_Descriptor.SerialArray != NULL);

       // view("newPartitioningObject != NULL");
        }

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#8 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
     if (newPartitioningObject != NULL)
          printf ("Reshape-#8 newPartitioningObject->referenceCount = %d \n",newPartitioningObject->referenceCount);
#endif
#endif

  // ********************************************************
  // **********************  Clean Up  **********************
  // ********************************************************

  // We don't need this refernece any more so delete it now!
     if (newPartitioningObject != NULL)
        {
          APP_ASSERT (newPartitioningObject->getReferenceCount() >= Internal_Partitioning_Type::getReferenceCountBase());
          newPartitioningObject->decrementReferenceCount();
          if (newPartitioningObject->getReferenceCount() <
              Internal_Partitioning_Type::getReferenceCountBase())
             {
               printf ("calling delete newPartitioningObject \n");
               delete newPartitioningObject;
             }
          newPartitioningObject = NULL;
        }
     APP_ASSERT (newPartitioningObject == NULL);

#if 0
#if defined(PPP)
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL)
          printf ("Reshape-#9 Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount = %d \n",Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->referenceCount);
#endif
#endif

#if COMPILE_DEBUG_STATEMENTS
     int i = 0;

  // Check that the leading unit dimensions added have ZERO ghost
  // boundary width so that no data movement is required
     for (i = 0; i < numberOfLeadingOnesAddedInNewArrayShape; i++)
        {
       // All added dimensions should have zero ghost boundary width (since the ghost boundaries
       // are allocated on the exterior boundary of the array even for nondistributed dimensions)
       // printf ("Final resulting array in reshape(): getGhostBoundaryWidth(%d) = %d \n",
       //      i,getGhostBoundaryWidth(i));
          APP_ASSERT (getGhostBoundaryWidth(i) == 0);
        }

  // Check that the ghost boundary widths of the trailing 
  // dimensions of a array object are zero as well
     for (i = numberOfDimensions(); i < MAX_ARRAY_DIMENSION; i++)
        {
       // All added dimensions should have zero ghost boundary width (since the ghost boundaries
       // are allocated on the exterior boundary of the array even for nondistributed dimensions)
       // printf ("Final resulting array in reshape(): getGhostBoundaryWidth(%d) = %d \n",
       //      i,getGhostBoundaryWidth(i));
          APP_ASSERT (getGhostBoundaryWidth(i) == 0);
        }
#endif

     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     Array_Domain_Type::Push_Array_ID ( Array_Descriptor.SerialArray->Array_ID() );
     Array_Descriptor.SerialArray->Array_Descriptor.Array_Domain.setArray_ID (Old_Serial_ID);

     Array_Domain_Type::Push_Array_ID ( Array_ID() );
     Array_Descriptor.Array_Domain.setArray_ID (Old_Parallel_ID);

  // ... Array_Data wasn't allocated with a new ...
     free (Array_Descriptor.SerialArray->Array_Descriptor.Array_Data);
     Array_Descriptor.SerialArray->Array_Descriptor.Array_Data = Old_Data_Pointer;

     SERIAL_POINTER_LIST_INITIALIZATION_MACRO

  // printf ("End of P++ section in floatArray::reshape() \n");
  // END OF P++ SECTION OF RESHAPE
#else
  // START OF A++ SECTION OF RESHAPE

  // if (Array_Descriptor.isView())
  //    {
  //      printf ("ERROR: in floatArray::reshape -- Can't reshape a view of another A++ array object \n");
  //      APP_ABORT();
  //    }
  //
  // APP_ASSERT( Array_Descriptor.isView() == FALSE );

  // ... We don't really have to save the whole descriptor here so now we
  // just save the little bit of data we require! ...
     int Old_Array_ID = Array_ID();

     if (Array_Descriptor.isView())
        {
       // ... make sure that either all leading dimensions span entire size or
       // that only added leading dimensions have length 1 ...

          int reshape_okay = TRUE;

       // Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List_Non_View;
          int Integer_List_Non_View[MAX_ARRAY_DIMENSION];
          int View_Bases[2*MAX_ARRAY_DIMENSION];
          int View_Sizes[2*MAX_ARRAY_DIMENSION];
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
             {
               Integer_List_Non_View[temp] = Integer_List[temp];
	    // ... initialize these so non short span case will work the same as before ...
               View_Bases[temp] = 0;
               View_Sizes[temp] = Integer_List[temp];
             }

       // ... first check to see if all dimensions of view except the last span the entire array ...

          int short_span = FALSE;
          int numdims = numberOfDimensions();

          for (temp=0; temp < numdims-1; temp++)
               if (getLength(temp) < getRawDataSize(temp))
                    short_span = TRUE;

       // ... if some leading dimensions don't span the entire array then
       // the only reshape allowed is to add leading dimensions of length 1 ...

          if (short_span)
             {
               int Old_Lengths[MAX_ARRAY_DIMENSION];
               for (temp=0; temp<numdims; temp++)
                    Old_Lengths[temp] = getLength(temp);

               int ncntr = 0;
               int ocntr = 0;

               do {
                    if (Integer_List[ncntr] != 1)
                         break;
                    ncntr++;
                  }
               while (ncntr < MAX_ARRAY_DIMENSION);

            // ... at this point ncntr is either the first nonunit dimension
            // in the reshape or is equal to MAX_ARRAY_DIMENSION ...

            // ... find first nonunit dimension in old list ...
               do {
                    if (Old_Lengths[ocntr] > 1)
                         break;
                    ocntr++;
                  }
               while (ocntr < numdims);

            // ... ocntr is now the first nonunit dimension before reshaping.
            // This can't be equal to numdims since short_span is true
            // but double check logic. ...
               APP_ASSERT (ocntr < numdims);

               while ((ocntr < numdims) && (ncntr < MAX_ARRAY_DIMENSION))
                  {
                    if (Old_Lengths[ocntr] != Integer_List[ncntr]) 
                       {
                         reshape_okay = FALSE;
                         break;
                       }
                    ocntr++;
                    ncntr++;
                 // ... increase ocntr up to numdims if old dimension is length 1 ...
                    if (ocntr<numdims) 
                       {
                         while (Old_Lengths[ocntr]==1) 
                            {
                              ocntr++;
                              if (ocntr >= numdims) break;
                            }
                       }
                    if (ncntr<MAX_ARRAY_DIMENSION) 
                       {
                         while (Integer_List[ncntr]==1) 
                            {
                              ncntr++;
                              if (ncntr<MAX_ARRAY_DIMENSION) break; 
                            }
                       }
                  }

               if (reshape_okay)
                    if (ncntr < MAX_ARRAY_DIMENSION)
                         Integer_List_Non_View[ncntr] = getRawDataSize(ocntr);

               if (reshape_okay)
                    fix_view_bases ( View_Bases, View_Sizes, numdims, Old_Lengths, Integer_List);
             }
            else 
             {
            // ... non short span case so see if corresponding reshape of 
            // corresponding nonview is possible by checking to see if 
            // old nonview size is divisible by reshape dimensions ...

               int old_size = 1;
               for (temp=0; temp<numdims; temp++)
                    old_size *= getRawDataSize(temp);

               temp = MAX_ARRAY_DIMENSION-1;
               do {
                    if (Integer_List[temp] > 1) break;
                    temp--;
                  }
               while (temp >= 0);

            // ... if all values of Integer_List are 1 then last_non_unit will be -1 ...
               int last_non_unit = temp;

               int left_over = old_size;
               temp=0; 
	       while (temp<last_non_unit)
                  {
                    if (left_over % Integer_List[temp] != 0) 
                       {
                         reshape_okay = FALSE;
                         break;
                       }
                    left_over /= Integer_List[temp++];
                  }

            // ... if last non unit is -1 leftover will be one and reset will
            // be unecessary but easier to do ...
               if (last_non_unit == -1)
                    last_non_unit = 0;

               if (reshape_okay)
                    fix_view_bases_non_short_span (View_Bases, View_Sizes, numdims, Integer_List);

               if (reshape_okay)
                    View_Sizes[last_non_unit] = left_over;
             }

          if (!reshape_okay)
             {
               printf("ERROR: can't reshape this view because corresponding original \n");
               printf("       array can't be reshaped to produce the shaped view.  \n");
               APP_ABORT();
             }

          Array_Descriptor.Initialize_Descriptor (MAX_ARRAY_DIMENSION,Integer_List);
       // Array_Descriptor.Fixup_Descriptor_With_View (MAX_ARRAY_DIMENSION,View_Sizes,View_Bases);
          Array_Descriptor.reshape (MAX_ARRAY_DIMENSION,View_Sizes,View_Bases);
        }
       else
        {
       // printf ("In reshape(): Calling Initialize_Descriptor -- Array_ID() = %d \n",Array_ID());
          Array_Descriptor.Initialize_Descriptor (MAX_ARRAY_DIMENSION,Integer_List);
        }

  // Since we are reusing the existing array_ID we have to give back the new one 
  // and reset the reference count associated with it since it is not used.
     decrementRawDataReferenceCount();

  // printf ("Before push Array_ID() in reshape(): Array_ID() = %d Old_Array_ID = %d \n",Array_ID(),Old_Array_ID);

  // Bugfix (7/29/96) Fix for growing Reference_Count_Array length
     Array_Domain_Type::Push_Array_ID ( Array_ID() );

  // Reuse the original array ID (after we gave back the one associated with the new array descriptor).
     Array_Descriptor.Array_Domain.setArray_ID (Old_Array_ID);

  // printf ("After setArray_ID: Array_ID() = %d \n",Array_ID());

     Array_Descriptor.Array_Domain.ExpressionTemplateOffset = 0;
     Array_Descriptor.Array_Domain.View_Offset = 0;
     POINTER_LIST_INITIALIZATION_MACRO;

  // printf ("End of reshape(): Array_ID() = %d \n",Array_ID());
  // END OF A++ SECTION OF RESHAPE
#endif

  // Bugfix (11/26/96) Make the error checking avaiable when the bounds checking is turned on
     int Number_Of_Elements_After_Reshape = 0;
     if (Index::Index_Bounds_Checking != FALSE)
        {
          Number_Of_Elements_After_Reshape = elementCount();
          if (Number_Of_Elements_Before_Reshape != Number_Of_Elements_After_Reshape)
             {
               printf ("ERROR: in floatArray::reshape -- Number_Of_Elements_Before_Reshape != Number_Of_Elements_After_Reshape! \n");
               printf ("       Should have used resize (to preserve data values) or redim (to clear data) \n");
               APP_ABORT();
             }
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Called from BOTTOM of floatArray::reshape(int*)");
#endif

  // view ("BASE OF RESHAPE");
  // printf ("Exiting at base of reshape \n");
  // APP_ABORT();

     return *this;
   }

floatArray & floatArray::reshape ( ARGUMENT_LIST_MACRO_INTEGER )
   {
     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO
     
     reshape ( Integer_List );

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::reshape(ARGUMENT_LIST_MACRO_CONST_REF_RANGE)");
#endif

     return *this;
   }

// ********************************************************************
// this figures out what the new bases will need to be so view is
// accessed okay when only change to shape is an added or removed 1
// ********************************************************************
void
floatArray::fix_view_bases (
   int* View_Bases, 
   int* View_Sizes, 
   int numdims,
   const int* Old_Lengths,
   const int* Integer_List)
{
  int temp; 
  int ocntr;
  int ncntr;
  int vcntr;

  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
  {
    View_Bases[temp] = getRawBase(temp)-getDataBase(temp);
    View_Sizes[temp] = getRawDataSize(temp);
  }
  for (temp = MAX_ARRAY_DIMENSION; temp<2*MAX_ARRAY_DIMENSION; temp++)
  {
    View_Bases[temp] = 0;
    View_Sizes[temp] = 1;
  }

  ocntr = ncntr = vcntr = 0;

  while (ocntr < numdims && ncntr < MAX_ARRAY_DIMENSION)
  {
    if (Old_Lengths[ocntr] == Integer_List[ncntr])
    {
      ocntr++;
      ncntr++;
      vcntr++;
    }
    else if (Integer_List[ncntr] == 1)
    {
      // extra 1 added in reshape
      for (temp = 2*MAX_ARRAY_DIMENSION-1; temp>vcntr; temp--)
      {
	View_Bases[temp] = View_Bases[temp-1];
	View_Sizes[temp] = View_Sizes[temp-1];
      }
      View_Bases[vcntr] = 0;
      View_Sizes[vcntr] = 1;
      ncntr++;
      vcntr++;
    }
    else
    {
      // dimension of length 1 lost from reshape
      View_Bases[vcntr] += View_Bases[vcntr+1] * View_Sizes[vcntr];
      View_Sizes[vcntr] *= View_Sizes[vcntr+1];
      for (temp=vcntr+1; temp < 2*MAX_ARRAY_DIMENSION -1; temp++)
      {
	View_Bases[temp] = View_Bases[temp+1];
	View_Sizes[temp] = View_Sizes[temp+1];
      }
      ocntr++;
      vcntr++;
    }
  }

  // now compress sizes and view bases if too many dimensions
  // have been added
  while (vcntr >= MAX_ARRAY_DIMENSION)
  {
    View_Bases[vcntr-1] += View_Bases[vcntr] * View_Sizes[vcntr-1];
    View_Sizes[vcntr-1] *= View_Sizes[vcntr];
    vcntr--;
  }
}

// ********************************************************************
// this figures out what the new bases will need to be so view is
// accessed okay when dimensions of length other than 1 are possibly
// added or changed but all dimensions but the last span the whole
// length both before and after the reshape except the last
// ********************************************************************
void
floatArray::fix_view_bases_non_short_span ( int* View_Bases, int* View_Sizes, int numdims, const int* Integer_List)
{
  int temp; 

  // ... get sizes and bases from before reshape ...
  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
  {
    View_Sizes[temp] = getRawDataSize(temp);
    View_Bases[temp] = getRawBase(temp)-getDataBase(temp);
  }


  // ... only the last dimension should have a non-zero base ...

  for (temp=0; temp<numdims-1; temp++) APP_ASSERT (View_Bases[temp] == 0);


  // ... put all the offset in the last non unit dimension since this will
  //  be the first dimension guaranteed to work after resetting the rest ...

  int save_base = View_Bases[numdims-1];
  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++) View_Bases[temp] = 0; 

  int total_size = 1;
  for (temp=0; temp<numdims-1; temp++) total_size *= View_Sizes[temp];


  int last_non_unit = 0;
  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
    if (Integer_List[temp]>1) last_non_unit = temp;


  // ... find the size unp to the last nonunit dimension to divide
  //  by since this will be multiplied back in to get the offset ...

  int total_size2 = 1;
  for (temp=0; temp<last_non_unit-1; temp++) total_size2 *= Integer_List[temp];
  
  View_Bases[last_non_unit] = save_base * total_size / total_size2; 


  // ... now reset sizes for after the reshape. The last_non_unit size
  //  will be reset out this routine since this is the only partial
  //  dimension ...

  for (temp=0; temp<MAX_ARRAY_DIMENSION; temp++)
    View_Sizes[temp] = Integer_List[temp];
}

// ********************************************************************
// This reshape function uses Range object to allow both the base and 
// dimensions to be set.
// ********************************************************************
// floatArray & floatArray::reshape ( const Range & I , const Range & J , const Range & K , const Range & L )
floatArray &
floatArray::reshape ( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     reshape (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::reshape(ARGUMENT_LIST_MACRO_CONST_REF_RANGE)");
#endif

     return *this;
   }

floatArray &
floatArray::reshape ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;

     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp]->Stride == 1);
          Integer_List[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base)+1;
        }

     reshape ( Integer_List );

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          setBase (Internal_Index_List[temp]->Base,temp);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::reshape(Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif

     return *this;
   }

// ********************************************************************
// This reshape function uses an existing array object to get both the
// base and dimensions to be set.
// ********************************************************************
floatArray &
floatArray::reshape ( const floatArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  floatArray::reshape (const floatArray & X) \n");
#endif

  // Build Range objects
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // Index_List[temp] = Internal_Index (X.getBase(temp),X.getBound(temp));
          int Base  = X.getBase(temp);
          int Bound = X.getBound(temp);
          Index_List[temp] = Internal_Index (Base,(Bound-Base)+1);
          Internal_Index_List[temp] = &(Index_List[temp]);
        }

  // Call reshape using Range objects
     reshape (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::reshape(floatArray)");
#endif

     return *this;
   }


// ********************************************************************
// This resize member function works the same as redim except it 
// preserves the data (i.e. it copies the data to the old data to
// the new array (truncating the data along dimensions that are made 
// smaller by the resizing of the old array object)).
// ********************************************************************
floatArray &
floatArray::resize ( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
   {
  // The resize function uses an existing A++ array and redimensions
  // it to be a different size while preserving as much of the data as possible.

  // Bugfix (10/7/96) This function now calls the resize function that takes range
  // objects.  Thus only a single function implements the details of the resize
  // functionality and all the others call it.  Aren't we clever!

     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  floatArray::resize ");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" %d",Integer_List[temp]);
          printf ("\n");
        }
#endif

  // Build Range objects from the list of integers
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
     {
        int Base  = 0;
        int Length = Integer_List[temp];
        Index_List[temp] = Internal_Index (Base,Length); 
	Internal_Index_List[temp] = &(Index_List[temp]); 
     }

  // Call resize using Range objects
     resize (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::resize(Integer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif

     return *this;
   }

// floatArray & floatArray::resize ( int i , int j , int k , int l )
floatArray & 
floatArray::resize ( ARGUMENT_LIST_MACRO_INTEGER )
   {
  // The resize function uses an existing A++ array and redimensions
  // it to be a different size without changing the number of elements.
  // It is an error to change the number of elements in the reshaped array.

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

     resize (Integer_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::resize(ARGUMENT_LIST_MACRO_INTEGER)");
#endif

     return *this;
   }

// ********************************************************************
// This is the main resize funtion all the rest are just interface functions to this function
// ********************************************************************
floatArray & 
floatArray::resize ( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List )
   {
     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  floatArray::resize RANGE LIST(base,bound) pairs \n");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" (%d,%d) ",Internal_Index_List[temp]->Base,Internal_Index_List[temp]->Bound);
          printf ("\n");
        }
#endif

     floatArray* New_Array = NULL;

#if defined(PPP)
  // If within P++ we have used a partition object save it and use it for the final resized array
  // first we us in in the new array we build then we make the current array a nullArray and then
  // we assign the the New_Array to the current one and this will distribute the current array
  // the same as the New_Array and give it the same bases as the New_Array.

     Internal_Partitioning_Type* old_partition = Array_Descriptor.Array_Domain.Partitioning_Object_Pointer;
  // printf ("##### old_partition = %p \n",old_partition);

     if (old_partition != NULL)
        {
       // It might be a performance issue to redistribute the array in this step
       // it might be better to specify the partitioning object when the New_Array
       // is constructed so that we avoid the additional data movement. 
       // This is an optimization for later.
       // New_Array.partition(*old_partition);

       // this will setup the bases correctly
          New_Array = new floatArray (Internal_Index_List,*old_partition);
        }
       else
        {
          New_Array = new floatArray (Internal_Index_List);
        }
#else
  // this will setup the bases correctly
     New_Array = new floatArray (Internal_Index_List);
#endif

     APP_ASSERT (New_Array != NULL);

  // Can't resize a view (it makes no sense)
     if (Array_Descriptor.isView() == TRUE)
        {
          printf ("WARNING in floatArray::resize: it make little sense to resize a view! \n");
          printf ("     Hint: Check for a view explicitly to avoid calling resize. \n");
          APP_ABORT();
        }

  // APP_ASSERT( Array_Descriptor.isView() == FALSE );

  // Save old base for each dimension
  // This could be made more efficent by avoiding the function call!
     int OldBase  [MAX_ARRAY_DIMENSION];
     int OldBound [MAX_ARRAY_DIMENSION];
     int Intersection_Base  [MAX_ARRAY_DIMENSION];
     int Intersection_Bound [MAX_ARRAY_DIMENSION];
     bool Is_An_Intersection = TRUE;
     Range Range_List [MAX_ARRAY_DIMENSION];

  // The internal A++/P++ interface requires an array of pointers to Internal_Index objects
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Assignment_Index_List;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          OldBase [temp] = getBase(temp);
          OldBound[temp] = getBound(temp);
          Intersection_Base [temp] =
 	     (OldBase[temp]  < Internal_Index_List[temp]->Base)  ? Internal_Index_List[temp]->Base  : OldBase[temp];
          Intersection_Bound[temp] =
             (OldBound[temp] > Internal_Index_List[temp]->Bound) ? Internal_Index_List[temp]->Bound : OldBound[temp];
          if (Intersection_Bound[temp] < Intersection_Base [temp])
               Is_An_Intersection = FALSE;

       // Bugfix (1/27/96) resize did not work for case of Null array
          if( Is_An_Intersection )
               Range_List [temp] = Range ( Intersection_Base[temp] , Intersection_Bound[temp] );
          else
               Range_List [temp] = Range ( 0, 0, 1, Null_Index );
          Assignment_Index_List [temp] = &(Range_List [temp]);
        }

     if (Is_An_Intersection)
        {
       // We can't do this assignment if there is no intersection
          (*New_Array) (Assignment_Index_List) = (*this)(Assignment_Index_List);
        }

#if defined(PPP)
  // Fix to Stefan's resize bug (this fix made this function much simpler)
  // Redimension to a null array then use the assignment operator
     redim(0);

  // Assign the new data to the *this array so that the redimensioning will be done automatically
  // This will pickup the Rhs's partitioning (I verified this as well)
     (*this) = (*New_Array);

  // Bug fix (6/9/2000) Commented out because it does not comile when not using PADRE
  // But not the same PADRE descriptor
  // APP_ASSERT (Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer !=
  //             New_Array->Array_Descriptor.Array_Domain.parallelPADRE_DescriptorPointer);
#else
  // Bug fix (2/14/94) suggested by Marc Reider
  // Save old data and descriptor to assign them to the local 
  // array object which will be deleted when we leave scope!
  // Let this local variable delete the old data 
  // and descriptor when it goes out of scope.
     float *Temp_Data                         = Array_Descriptor.Array_Data;
     Array_Descriptor.Array_Data           = New_Array->Array_Descriptor.Array_Data;
     New_Array->Array_Descriptor.Array_Data = Temp_Data;
  // ... (11/19/98; kdb) switch array ID's also for serial case only because 
  // they are attached to the data that is being switched ...
     int Temp_ID = Array_Descriptor.Array_Domain.internalArrayID;
     Array_Descriptor.Array_Domain.internalArrayID = 
	New_Array->Array_Descriptor.Array_Domain.internalArrayID;
     New_Array->Array_Descriptor.Array_Domain.internalArrayID = Temp_ID;

     Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List;

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          APP_ASSERT (Internal_Index_List[temp]->Stride == 1);
          Integer_List[temp] = (Internal_Index_List[temp]->Bound - Internal_Index_List[temp]->Base)+1;
        }

  // ... (11/17/98;kdb) put Array ID back here because Initialize_Descriptor 
  // will grab a new one and it might as well be the same one it had ...

  // Always reuse the existing Array ID (not clear if this will work need to test it)
     Array_Domain_Type::Push_Array_ID (Array_ID());

  // Why don't we have a function which takes Internal_Index objects?
     Array_Descriptor.Initialize_Descriptor(MAX_ARRAY_DIMENSION,Integer_List);

     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
          setBase(Internal_Index_List[temp]->Base,temp);

     POINTER_LIST_INITIALIZATION_MACRO;
#endif

  // Now delete the new array we allocated at the start
     APP_ASSERT(New_Array != NULL);
     delete New_Array;
     New_Array = NULL;

#if defined(APP) || ( defined(SERIAL_APP) && !defined(PPP) )
  // For P++ we only track the serial array objects not the serial array objects
     if (Diagnostic_Manager::getTrackArrayData() == TRUE)
        {
       // Since we have changed the size of the array we have to reset the diagnostic data
       // Now initialize the type code in the diagnostic data object so we know the base type of the array object
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
#ifdef DOUBLEARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_DOUBLE_ELEMENT_TYPE);
#endif
#ifdef FLOATARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_FLOAT_ELEMENT_TYPE);
#endif
#ifdef INTARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->initialize(Array_Descriptor.Array_Domain,APP_INT_ELEMENT_TYPE);
#endif
        }
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::resize");
#endif

     return *this;
   }

floatArray &
floatArray::resize ( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
   {
     RANGE_ARGUMENTS_TO_RANGE_LIST_MACRO

     int temp = 0;
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of  floatArray::resize RANGE(base,bound) pairs \n");
          for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
               printf (" (%d,%d) ",Internal_Index_List[temp]->Base,Internal_Index_List[temp]->Bound);
          printf ("\n");
        }
#endif

     resize (Internal_Index_List);  // this will setup the bases correctly

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::resize(int,int,int,int)");
#endif

     return *this;
   }

// ********************************************************************
// This resize function uses an existing array object to get both the
// base and dimensions to be set.
// ********************************************************************
floatArray &
floatArray::resize ( const floatArray & X )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of  floatArray::resize (const floatArray & X) \n");
#endif

  // Build Range objects
     Internal_Index Index_List [MAX_ARRAY_DIMENSION];
     Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
       // Index_List[temp] = Internal_Index (X.getBase(temp),X.getBound(temp));
          int Base  = X.getBase(temp);
          int Bound = X.getBound(temp);
          Index_List[temp] = Internal_Index (Base,(Bound-Base)+1);
          Internal_Index_List[temp] = &(Index_List[temp]);
        }

  // Call resize using Range objects
     resize (Internal_Index_List);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::resize(floatArray)");
#endif

     return *this;
   }

// **************************************************************************
// Function used in the member functions for operator()(Index)
// **************************************************************************
bool
floatArray::Is_Built_By_Defered_Evaluation() const
   {
  // This can be simplified (there is a member function for this)
     return Array_Descriptor.Array_Domain.Is_Built_By_Defered_Evaluation;
   }



// Expantion of previous macro to handle cross product of types
// normally inlined in inline_support.h
floatArray*
floatArray::Build_Temporary_By_Example ( const intArray & Lhs )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::Build_Temporary_By_Example (Lhs) \n");
     Lhs.Test_Consistency("Lhs input in floatArray::Build_Temporary_By_Example");
#endif

     floatArray *Temporary_Array = NULL;
     bool Force_Memory_Allocation = !Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION;

#if defined(PPP)
     floatSerialArray* Null_Array = NULL;
#else
     float* Null_Array = NULL;
#endif


#if defined(PPP)
  // This is part of an expensive O(n^2) operation so use it saringly as a test
     APP_ASSERT (SerialArray_Domain_Type::checkForArrayIDOnStack (Lhs.Array_ID()) == 0);
#endif

  // Call a constructor specific to building a temporary
  // we can distinquish it by handing it a pointer to the member function?
     bool AvoidBuildingIndirectAddressingView = TRUE;
     Temporary_Array = new floatArray ( Null_Array,
                                       &(Lhs.Array_Descriptor.Array_Domain),
                                       AvoidBuildingIndirectAddressingView);

  // This would be a very slow way to handle this -- and we want to
  // avoid the redudent overhead of initializing the descriptor twice
  // Temporary_Array->Array_Descriptor.Build_Temporary_By_Example(Lhs.Array_Descriptor.Array_Domain);
     APP_ASSERT(Temporary_Array != NULL);

  // printf ("In floatArray::Build_Temporary_By_Example: Temporary_Array->Array_ID() != Lhs.Array_ID() (%d != %d) \n",
  //      Temporary_Array->Array_ID(),Lhs.Array_ID());

     APP_ASSERT(Temporary_Array->Array_ID() != Lhs.Array_ID());
     APP_ASSERT(Temporary_Array->getRawDataReferenceCount() == Temporary_Array->getReferenceCountBase());

  // Later if we change now the base is set in assignement we might want to change this!
  // ... (4/23,98, kdb) base is already set and might not be set to
  // APP_Global_Array_Base if indirect addressing is used ...
  // Temporary_Array->setBase(APP_Global_Array_Base);

  // We have to set the resulting array to be a temporary array
     Temporary_Array->setTemporary(TRUE);
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

  // We can't generate a temporary which requires indirect addressing 
  // (i.e. the temporary returns is a gathered quantity).
     APP_ASSERT(Temporary_Array->usesIndirectAddressing() == FALSE);

  // Build the space for the size of array indicated by the descriptor (just built above)
     Temporary_Array->Allocate_Array_Data(Force_Memory_Allocation);

  // When we build a temporary by example using Lhs we should make sure we return a 
  // temporary!  Make sure it is still a temporary after calling Allocate_Array_Data()
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

#if !defined(PPP)
  // Set up the Array_View_Pointers for scalar indexing
     TEMPORARY_POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if INITIALIZE_TEMPORARY_MEMORY
  // printf ("START: Initialize temporary array! \n");

  // Save the where mask so that the whole array will be initialized!
     intfloatArray *Temp_Where_Mask = Where_Statement_Support::Where_Statement_Mask;
     Where_Statement_Support::Where_Statement_Mask = NULL;
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;

  // Initialize the new array
     *Temporary_Array = 0;

  // Now restore the where mask as if nothing had ever happened!
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
     Where_Statement_Support::Where_Statement_Mask = Temp_Where_Mask;
     Temp_Where_Mask = NULL;
  // printf ("END: Initialize temporary array! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
  // Initialize the new array (temp code)
  // *Temporary_Array = 0;

     Temporary_Array->Test_Consistency("floatArray::Build_Temporary_By_Example");

  // Helpful mechanism for debugging communication models (VSG and Overlap updates models)
     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In floatArray::Build_Temporary_By_Example(): return array - local range (%d,%d,%d) \n",
               Temporary_Array->getBase(0),
               Temporary_Array->getBound(0),
               Temporary_Array->getStride(0));
        }
#endif

#if 0
  // Error checking (part of debugging)
     Temporary_Array->view("floatArray::Build_Temporary_By_Example -- Temporary_Array->view()");
  // APP_ABORT();
#endif

     return Temporary_Array;
   }

// normally inlined in inline_support.h
floatArray*
floatArray::Build_Temporary_By_Example ( const floatArray & Lhs )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::Build_Temporary_By_Example (Lhs) \n");
     Lhs.Test_Consistency("Lhs input in floatArray::Build_Temporary_By_Example");
#endif

     floatArray *Temporary_Array = NULL;
     bool Force_Memory_Allocation = !Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION;

#if defined(PPP)
     floatSerialArray* Null_Array = NULL;
#else
     float* Null_Array = NULL;
#endif


#if defined(PPP)
  // This is part of an expensive O(n^2) operation so use it saringly as a test
     APP_ASSERT (SerialArray_Domain_Type::checkForArrayIDOnStack (Lhs.Array_ID()) == 0);
#endif

  // Call a constructor specific to building a temporary
  // we can distinquish it by handing it a pointer to the member function?
     bool AvoidBuildingIndirectAddressingView = TRUE;
     Temporary_Array = new floatArray ( Null_Array,
                                       &(Lhs.Array_Descriptor.Array_Domain),
                                       AvoidBuildingIndirectAddressingView);

  // This would be a very slow way to handle this -- and we want to
  // avoid the redudent overhead of initializing the descriptor twice
  // Temporary_Array->Array_Descriptor.Build_Temporary_By_Example(Lhs.Array_Descriptor.Array_Domain);
     APP_ASSERT(Temporary_Array != NULL);

  // printf ("In floatArray::Build_Temporary_By_Example: Temporary_Array->Array_ID() != Lhs.Array_ID() (%d != %d) \n",
  //      Temporary_Array->Array_ID(),Lhs.Array_ID());

     APP_ASSERT(Temporary_Array->Array_ID() != Lhs.Array_ID());
     APP_ASSERT(Temporary_Array->getRawDataReferenceCount() == Temporary_Array->getReferenceCountBase());

  // Later if we change now the base is set in assignement we might want to change this!
  // ... (4/23,98, kdb) base is already set and might not be set to
  // APP_Global_Array_Base if indirect addressing is used ...
  // Temporary_Array->setBase(APP_Global_Array_Base);

  // We have to set the resulting array to be a temporary array
     Temporary_Array->setTemporary(TRUE);
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

  // We can't generate a temporary which requires indirect addressing 
  // (i.e. the temporary returns is a gathered quantity).
     APP_ASSERT(Temporary_Array->usesIndirectAddressing() == FALSE);

  // Build the space for the size of array indicated by the descriptor (just built above)
     Temporary_Array->Allocate_Array_Data(Force_Memory_Allocation);

  // When we build a temporary by example using Lhs we should make sure we return a 
  // temporary!  Make sure it is still a temporary after calling Allocate_Array_Data()
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

#if !defined(PPP)
  // Set up the Array_View_Pointers for scalar indexing
     TEMPORARY_POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if INITIALIZE_TEMPORARY_MEMORY
  // printf ("START: Initialize temporary array! \n");

  // Save the where mask so that the whole array will be initialized!
     intfloatArray *Temp_Where_Mask = Where_Statement_Support::Where_Statement_Mask;
     Where_Statement_Support::Where_Statement_Mask = NULL;
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;

  // Initialize the new array
     *Temporary_Array = 0;

  // Now restore the where mask as if nothing had ever happened!
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
     Where_Statement_Support::Where_Statement_Mask = Temp_Where_Mask;
     Temp_Where_Mask = NULL;
  // printf ("END: Initialize temporary array! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
  // Initialize the new array (temp code)
  // *Temporary_Array = 0;

     Temporary_Array->Test_Consistency("floatArray::Build_Temporary_By_Example");

  // Helpful mechanism for debugging communication models (VSG and Overlap updates models)
     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In floatArray::Build_Temporary_By_Example(): return array - local range (%d,%d,%d) \n",
               Temporary_Array->getBase(0),
               Temporary_Array->getBound(0),
               Temporary_Array->getStride(0));
        }
#endif

#if 0
  // Error checking (part of debugging)
     Temporary_Array->view("floatArray::Build_Temporary_By_Example -- Temporary_Array->view()");
  // APP_ABORT();
#endif

     return Temporary_Array;
   }

// normally inlined in inline_support.h
floatArray*
floatArray::Build_Temporary_By_Example ( const doubleArray & Lhs )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray::Build_Temporary_By_Example (Lhs) \n");
     Lhs.Test_Consistency("Lhs input in floatArray::Build_Temporary_By_Example");
#endif

     floatArray *Temporary_Array = NULL;
     bool Force_Memory_Allocation = !Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION;

#if defined(PPP)
     floatSerialArray* Null_Array = NULL;
#else
     float* Null_Array = NULL;
#endif


#if defined(PPP)
  // This is part of an expensive O(n^2) operation so use it saringly as a test
     APP_ASSERT (SerialArray_Domain_Type::checkForArrayIDOnStack (Lhs.Array_ID()) == 0);
#endif

  // Call a constructor specific to building a temporary
  // we can distinquish it by handing it a pointer to the member function?
     bool AvoidBuildingIndirectAddressingView = TRUE;
     Temporary_Array = new floatArray ( Null_Array,
                                       &(Lhs.Array_Descriptor.Array_Domain),
                                       AvoidBuildingIndirectAddressingView);

  // This would be a very slow way to handle this -- and we want to
  // avoid the redudent overhead of initializing the descriptor twice
  // Temporary_Array->Array_Descriptor.Build_Temporary_By_Example(Lhs.Array_Descriptor.Array_Domain);
     APP_ASSERT(Temporary_Array != NULL);

  // printf ("In floatArray::Build_Temporary_By_Example: Temporary_Array->Array_ID() != Lhs.Array_ID() (%d != %d) \n",
  //      Temporary_Array->Array_ID(),Lhs.Array_ID());

     APP_ASSERT(Temporary_Array->Array_ID() != Lhs.Array_ID());
     APP_ASSERT(Temporary_Array->getRawDataReferenceCount() == Temporary_Array->getReferenceCountBase());

  // Later if we change now the base is set in assignement we might want to change this!
  // ... (4/23,98, kdb) base is already set and might not be set to
  // APP_Global_Array_Base if indirect addressing is used ...
  // Temporary_Array->setBase(APP_Global_Array_Base);

  // We have to set the resulting array to be a temporary array
     Temporary_Array->setTemporary(TRUE);
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

  // We can't generate a temporary which requires indirect addressing 
  // (i.e. the temporary returns is a gathered quantity).
     APP_ASSERT(Temporary_Array->usesIndirectAddressing() == FALSE);

  // Build the space for the size of array indicated by the descriptor (just built above)
     Temporary_Array->Allocate_Array_Data(Force_Memory_Allocation);

  // When we build a temporary by example using Lhs we should make sure we return a 
  // temporary!  Make sure it is still a temporary after calling Allocate_Array_Data()
     APP_ASSERT(Temporary_Array->isTemporary() == TRUE);

#if !defined(PPP)
  // Set up the Array_View_Pointers for scalar indexing
     TEMPORARY_POINTER_LIST_INITIALIZATION_MACRO;
#endif

#if INITIALIZE_TEMPORARY_MEMORY
  // printf ("START: Initialize temporary array! \n");

  // Save the where mask so that the whole array will be initialized!
     intfloatArray *Temp_Where_Mask = Where_Statement_Support::Where_Statement_Mask;
     Where_Statement_Support::Where_Statement_Mask = NULL;
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = FALSE;

  // Initialize the new array
     *Temporary_Array = 0;

  // Now restore the where mask as if nothing had ever happened!
     Temporary_Array->Array_Descriptor.Array_Domain.Is_A_Temporary = TRUE;
     Where_Statement_Support::Where_Statement_Mask = Temp_Where_Mask;
     Temp_Where_Mask = NULL;
  // printf ("END: Initialize temporary array! \n");
#endif

#if COMPILE_DEBUG_STATEMENTS
  // Initialize the new array (temp code)
  // *Temporary_Array = 0;

     Temporary_Array->Test_Consistency("floatArray::Build_Temporary_By_Example");

  // Helpful mechanism for debugging communication models (VSG and Overlap updates models)
     if (Diagnostic_Manager::getMessagePassingInterpretationReport() > 0)
        {
          printf ("In floatArray::Build_Temporary_By_Example(): return array - local range (%d,%d,%d) \n",
               Temporary_Array->getBase(0),
               Temporary_Array->getBound(0),
               Temporary_Array->getStride(0));
        }
#endif

#if 0
  // Error checking (part of debugging)
     Temporary_Array->view("floatArray::Build_Temporary_By_Example -- Temporary_Array->view()");
  // APP_ABORT();
#endif

     return Temporary_Array;
   }


// ***********************************************************************************
// This function is used in the abstract binary operators to control the reuse of
// temporaries.  If the Lhs or Rhs is a temporary then it can be reused -- else
// a real temporary must be allocated for use within the expression evaluation.
// Temporaries are marked in the descriptor as being temporaries so that they can
// be readily identified as such.  It is possible to provide such functionality
// as a seperate class but I have never seen it done in such a way as to be practical
// for a large and meaningful array class.
// ***********************************************************************************

// normally inlined in inline_support.h
floatArray &
floatArray::Build_New_Array_Or_Reuse_Operand ( const floatArray & Lhs , const floatArray & Rhs ,
                                              Memory_Source_Type & Result_Array_Memory )
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray &floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs (Lhs,Rhs,Memory_Type) \n");

  // Error checking
  // APP_ASSERT(Lhs.Array_Descriptor && Rhs.Array_Descriptor);
  // Lhs.view("Lhs in (AT TOP) floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
  // Rhs.view("Rhs in (AT TOP) floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
#endif

     floatArray *Temporary_Array = NULL;

  // New code with faster logic (13/10/94).
  // Most common case of Rhs as temporary placed first
  // Bug fix (11/5/94) P++ relies on the order of preference in reuse of temporaries
  // this is a bad sort of dependence (I hate it).  It should be fixed but I'm not clear
  // how that should be done.
     if (Lhs.isTemporary())
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("In floatArray::Build_New_Array_Or_Reuse_Operand - Reusing Lhs array object to hold temporary \n");
#endif
          Temporary_Array     = &(floatArray &) Lhs;
          Result_Array_Memory = Memory_From_Lhs;

       // Bugfix (12/3/2000) must record the new reference
          Temporary_Array->incrementReferenceCount();
        }
       else
        {
          if (Rhs.isTemporary())
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("In floatArray::Build_New_Array_Or_Reuse_Operand - Reusing Rhs array object to hold temporary \n");
#endif
               Temporary_Array     = &(floatArray &) Rhs;
               Result_Array_Memory = Memory_From_Rhs;

            // Bugfix (12/3/2000) must record the new reference
               Temporary_Array->incrementReferenceCount();
             }
            else
             {
#if COMPILE_DEBUG_STATEMENTS
               if (APP_DEBUG > 0)
                    printf ("Building a new array object to hold temporary \n");
               Lhs.Test_Consistency ("floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
            // Lhs.view("Lhs in (AT TOP) floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
            // Rhs.view("Rhs in (AT TOP) floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
#endif
            // We use the Lhs because this simplifies the final assignment process
            // by making the resulting temporary aligned with the Lhs of the operator=
            // this technique reduces the communication require for the parallel array 
            // statements.
               Temporary_Array     = floatArray::Build_Temporary_By_Example (Lhs);
               Result_Array_Memory = Newly_Allocated_Memory;
             }
        }

#if COMPILE_DEBUG_STATEMENTS
  // Lhs.view("Lhs in (AT BOTTOM) floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
  // Rhs.view("Rhs in (AT BOTTOM) floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
  // Temporary_Array->view("Temporary_Array in (AT BOTTOM) floatArray::Build_New_Array_Or_Reuse_Lhs_Or_Rhs");
#endif

     return *Temporary_Array;
   }

// ***********************************************************************************
// This function is used in the abstract unary operators to control the reuse of
// temporaries.  If the Lhs or Rhs is a temporary then it can be reused -- else
// a real temporary must be allocated for use within the expression evaluation.
// Temporaries are marked in the descriptor as being temporaries so that they can
// be readily identified as such.  It is possible to provide such functionality
// as a seperate class but I have never seen it done in such a way as to be practical
// for a large and meaningful array class.
// ***********************************************************************************

// normally inlined in inline_support.h
floatArray &
floatArray::Build_New_Array_Or_Reuse_Operand ( const floatArray & X , Memory_Source_Type & Result_Array_Memory )
   {
     floatArray *Temporary_Array = NULL;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of floatArray &floatArray::Build_New_Array_Or_Reuse_Operand (Operand,Memory_Type) \n");

  // APP_ASSERT(X.Array_Descriptor);
#endif

     if (X.isTemporary())
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("In floatArray::Build_New_Array_Or_Reuse_Operand - Reusing X array object to hold temporary \n");
#endif
          Temporary_Array     = &(floatArray &) X;
          Result_Array_Memory = Memory_From_Operand;

       // Bugfix (12/3/2000) must record the new reference
          Temporary_Array->incrementReferenceCount();
        }
       else
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("Building a new array object to hold temporary \n");
          X.Test_Consistency ("floatArray::Build_New_Array_Or_Reuse_Operand");
#endif
          Temporary_Array     = floatArray::Build_Temporary_By_Example (X);
          Result_Array_Memory = Newly_Allocated_Memory;
        }

     return *Temporary_Array;
   }

void
Delete_If_Temporary ( const floatArray & X )
   {
  // Constants can never be a temporary - it is the law! 
  // I admit that it seems questionable to delete an object
  // that is passed in by a const ref but mutable types will 
  // make this a more acceptable thing to do when they 
  // appear in C++ (next version -- I think)

// #if !defined(SERIAL_APP) 
  // These behavior was reverified on (2/26/96) while fixing memory leaks in P++.
  // We only activate the temporary management for the A++ and P++ objects
  // not for the Serial_A++ objects.  This is to aviod the redundent
  // management of P++ arrays and Serial_A++ arrays that are used internally in
  // P++.  The way we avoid this temporary management of the Serial_A++ objects is
  // to eliminate the body of this function when it is used to generate the
  // Serial_A++ member function

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("################################################################### \n");
          printf ("############# Inside of floatArray::Delete_If_Temporary! ########### \n");
          printf ("################################################################### \n");
        }
#endif

  // Bug fix (11/30/93) Views have to have local scope else they are
  // deleted too soon when passed by reference to an expression.
  // Since they have no data associated with them they are not
  // a problem with their longer lifetime! (only a few words are
  // required to hold a view where as a temporary has array data
  // associated with it).

     if (X.isTemporary())
        {
#if COMPILE_DEBUG_STATEMENTS
          if ( (APP_DEBUG > 0) || (Diagnostic_Manager::getReferenceCountingReport() > 0) )
               printf ("Inside of Delete_If_Temporary (DELETING floatArray object (id=%d)) X.getReferenceCount() = %d \n",
                    X.Array_ID(),X.getReferenceCount());
#endif

       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          X.decrementReferenceCount();
          if (X.getReferenceCount() < floatArray::getReferenceCountBase())
             {
            // printf ("Deleting the array object (floatArray)! (floatArray::getReferenceCountBase() = %d) \n",floatArray::getReferenceCountBase());

            // Added (12/5/2000) to simplify use in operator.C
#if defined(PPP) && defined(USE_PADRE)
            // Handle case where PADRE is used
            // when using PADRE we have to clear the use of the SerialArray_Domain before
            // deleting the SerialArray object.
               X.setLocalDomainInPADRE_Descriptor(NULL);
#endif

               delete & (floatArray &) X;    // Notice that we cast away const here!
             }
        }
#if COMPILE_DEBUG_STATEMENTS
       else
        {
          if ( (APP_DEBUG > 0) || (Diagnostic_Manager::getReferenceCountingReport() > 0) )
               printf ("Inside of Delete_If_Temporary (NOT A TEMPORARY floatArray object (id=%d)) X.getReferenceCount() = %d \n",
                    X.Array_ID(),X.getReferenceCount());
        }
#endif
   }

void
Delete_Lhs_If_Temporary ( const floatArray & Lhs )
   {
  // The Solaris C++ compiler v3.0 can't inline a function with a static variable we get a
  // "sorry not implemented: cannot expand inline function with static Last_Lhs_floatArray_Operand" message.
  // So it is a variable with file scope (later we should make it a static data member).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
       // printf ("Inside of Delete_Lhs_If_Temporary! \n");
          printf ("################################################################### \n");
          printf ("########### Inside of floatArray::Delete_Lhs_If_Temporary! ######### \n");
          printf ("################################################################### \n");
        }
#endif

  // Last_Lhs_floatArray_Operand is given file scope! We could make it a static member of the class?
     if (Last_Lhs_floatArray_Operand != NULL)
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("Inside of Delete_Lhs_If_Temporary (DELETING THE LAST LHS)! \n");
#endif
       // I don't think this function is ever called called so as to delete anything!
       // printf ("Exiting from Delete_Lhs_If_Temporary ( const floatArray & Lhs ) ... \n");
       // exit(1);

       // Added (12/5/2000) to simplify use in operator.C
#if defined(PPP) && defined(USE_PADRE)
       // Handle case where PADRE is used
       // when using PADRE we have to clear the use of the SerialArray_Domain before
       // deleting the SerialArray object.
          Last_Lhs_floatArray_Operand->setLocalDomainInPADRE_Descriptor(NULL);
#endif

       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          Last_Lhs_floatArray_Operand->decrementReferenceCount();
          if (Last_Lhs_floatArray_Operand->getReferenceCount() < floatArray::getReferenceCountBase())
               delete Last_Lhs_floatArray_Operand;
       // Last_Lhs_floatArray_Operand = NULL;
        }

  // Bug fix (11/30/93) Views have to have local scope else they are
  // deleted too soon when passed by reference to an expression.
  // Since they have no data associated with them they are not
  // a problem with their longer lifetime! (only a few words are
  // required to hold a view where as a temporary has array data
  // associated with it).

  // Last_Lhs_floatArray_Operand = (Lhs.Array_Descriptor.Array_Domain.Is_A_Temporary) ? &((floatArray &) Lhs) : NULL;

  // This might be a memory leak for P++ since views can be temporaries and must be deleted (sometimes)
     Last_Lhs_floatArray_Operand = (Lhs.Array_Descriptor.Array_Domain.Is_A_Temporary && !Lhs.Array_Descriptor.Array_Domain.Is_A_View) ? &((floatArray &) Lhs) : NULL;

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Leaving Delete_Lhs_If_Temporary! \n");
        }
#endif
   }

#if defined(PPP) 
floatSerialArray
floatArray::getLocalArrayWithGhostBoundaries () const
#else
floatArray
floatArray::getLocalArrayWithGhostBoundaries () const
#endif
   {
  // return A++ array that includes ghost cells if P++ or a shallow copy 
  // of itself if A++

  //APP_ASSERT(!Array_Descriptor.Is_A_View);

#if defined(PPP) 
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);

     if ((!Array_Descriptor.Array_Domain.Is_A_View) && 
	 (!Array_Descriptor.Array_Domain.Is_A_Null_Array) &&
	 (!getSerialDomain().Is_A_Null_Array))
        {
          Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
          int i;
          for (i=0;i<MAX_ARRAY_DIMENSION;i++)
             {
               Internal_Index_List[i] = new Range(getLocalFullRange(i));
               APP_ASSERT (Internal_Index_List[i] != NULL);
             }

       // Performance optimization (11/30/2000)
       // floatSerialArray ReturnArray;
       // ReturnArray.adopt(getDataPointer(),Internal_Index_List);
          APP_ASSERT (getDataPointer() != NULL);
#if 1
          printf ("Inside of floatArray::getLocalArrayWithGhostBoundaries(): Skipping significant optimization! \n");
          floatSerialArray ReturnArray;
          ReturnArray.adopt(getDataPointer(),Internal_Index_List);
#else
          floatSerialArray ReturnArray (getDataPointer(),Internal_Index_List);
#endif
          for (i=0; i < MAX_ARRAY_DIMENSION; i++) 
             {
            // Range objects don't have referenceCounting! (should they?)
               delete Internal_Index_List[i];
             }
          return floatSerialArray(ReturnArray,SHALLOWCOPY);
        }
       else
        {
          return floatSerialArray(*Array_Descriptor.SerialArray,SHALLOWCOPY);
        }
  // printf("getLocalArrayWithGhostBoundaries doesn't work in parallel right now\n");
#else
     return floatArray(*this,SHALLOWCOPY);
#endif
   }

#if defined(PPP) 
floatSerialArray*
floatArray::getLocalArrayWithGhostBoundariesPointer () const
#else
floatArray*
floatArray::getLocalArrayWithGhostBoundariesPointer () const
#endif
   {
  // return A++ array that includes ghost cells if P++ or a shallow copy 
  // of itself if A++

  //APP_ASSERT(!Array_Descriptor.Is_A_View);

#if defined(PPP) 
     APP_ASSERT(Array_Descriptor.SerialArray != NULL);

     APP_ASSERT(Array_Descriptor.SerialArray->isTemporary() == FALSE);

     if ((!Array_Descriptor.Array_Domain.Is_A_View) && 
	 (!Array_Descriptor.Array_Domain.Is_A_Null_Array) &&
	 (!getSerialDomain().Is_A_Null_Array))
        {
          Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List;
          int i;
          for (i=0;i<MAX_ARRAY_DIMENSION;i++)
             {
               Internal_Index_List[i] = new Range(getLocalFullRange(i));
               APP_ASSERT (Internal_Index_List[i] != NULL);
             }

       // Performance optimization (11/30/2000)
          APP_ASSERT (getDataPointer() != NULL);
#if 1
          printf ("Inside of floatArray::getLocalArrayWithGhostBoundariesPointer(): Skipping significant optimization! \n");
          floatSerialArray* ReturnArray = new floatSerialArray();
          APP_ASSERT (ReturnArray != NULL);
          ReturnArray->adopt(getDataPointer(),Internal_Index_List);
#else
          floatSerialArray* ReturnArray = new floatSerialArray (getDataPointer(),Internal_Index_List);
          APP_ASSERT (ReturnArray != NULL);
#endif
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
            // Range objects don't have referenceCounting! (should they?)
               delete Internal_Index_List[i];
             }
       // return new floatSerialArray(ReturnArray,SHALLOWCOPY);
          return ReturnArray;
       }
      else
       {
         return new floatSerialArray(*Array_Descriptor.SerialArray,SHALLOWCOPY);
       }
  // printf("getLocalArrayWithGhostBoundaries doesn't work in parallel right now\n");
#else
     return new floatArray(*this,SHALLOWCOPY);
#endif
   }

void
floatArray::testArray()
   {
  // This function writes over the existing data in the "this" array
  // and is provided as a more robust test of the internal descriptor data
  // than the inpection only based Test_Consistency() member function.

  // Call the nondestructive test since it is easy to do!
#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("floatArray::testArray");
#else
     printf ("NOTE: internal debugging turned OFF -- so testArray error checking is not meaningful! \n");
#endif

  // build a reference to the "this" array
     floatArray & X = *this;

  // Test use of assignment operator
     X = 1;

#if 0
  // This does not work for P++ arrays
  // test scalar indexing of the whole array
     float* arrayPointer  = Array_Descriptor.Array_View_Pointer5;
     APP_ASSERT (Array_Descriptor.Array_View_Pointer5 == 
                 Array_Descriptor.Array_Data + Array_Descriptor.Array_Domain.Scalar_Offset[5]);
#endif

     int i=0;
     int j=0;
     int k=0;
     int l=0;
     int m=0;
     int n=0;

     APP_ASSERT (MAX_ARRAY_DIMENSION == 6);

  // Example of 6D indexing
     for (n=getBase(5); n <= getBound(5); n += getRawStride(5))
        {
          int offset_m = (n*getRawDataSize(4));
          for (m=getBase(4); m <= getBound(4); m += getRawStride(4))
             {
               int offset_l = offset_m+(m*getRawDataSize(3));
               for (l=getBase(3); l <= getBound(3); l += getRawStride(3))
                  {
                    int offset_k = offset_l+(l*getRawDataSize(2));
                    for (k=getBase(2); k <= getBound(2); k += getRawStride(2))
                       {
                         int offset_j = offset_k+(k*getRawDataSize(1));
                         for (j=getBase(1); j <= getBound(1); j += getRawStride(1))
                            {
                              int offset_i = offset_j+(j*getRawDataSize(0));
                              for (i=getBase(0); i <= getBound(0); i += getRawStride(0))
                                 {
                                // if (arrayPointer[offset_i+i])  // (example of precomputed invariant indexing)
                                // printf ("In testArray(): i = %d j = %d k = %d l = %d m = %d n = %d \n",
                                //      i,j,k,l,m,n);
				   X(i,j,k,l,m,n) = 1;
                                // arrayPointer[offset_i+i] = 2;
                                 }
                            }
                       }
                  }
             }
        }
   }


#undef FLOATARRAY

#define INTARRAY
// *********************************************************
// *********************************************************
// ***********  STATIC VARIABLE INITIALIZEATION  ***********
// *********************************************************
// *********************************************************

#if !defined(PPP)
// *********************************************************
// Hash tables can be used to to avoid redundent allocation 
// and deallocation associated with the use of temporaries.
// Temporaries are created and saved for reuse when the same 
// size temporary is required again. No smart system for aging
// of hashed memory is used to avoid the acumulation of reserved
// memory for reuse.  Also no measurable advantage of this 
// feature has been observed.
// *********************************************************
// intArray_Data_Hash_Table intArray::Hash_Table;
#endif

// *********************************************************
// A++/P++ arrays can be optionally set to always initialize their
// data to a user defined value on construction.  This feature is generally 
// turned off to avoid the performance overhead of unrequired 
// initialization. The value used for the optional initialization
// is defined in intArray::PREINITIALIZE_VALUE -- but may be 
// redefined by the user.  The default value is
// INT_MAX -- this is choosen because it is a value more likely
// to allow users to catch errors in there codes.
// This feature of A++/P++ arrose out of discussions with Bill Rider.
// *********************************************************
bool intArray::PREINITIALIZE_OBJECT_IN_CONSTRUCTOR = FALSE;
int      intArray::PREINITIALIZE_VALUE                 = (int) INT_MAX;
bool intArray::USE_DESCRIPTOR_CACHING              = FALSE;

// *********************************************************
// Constants to allow different formating of array data in
// the A++ display member function
// *********************************************************
const int intArray::DECIMAL_DISPLAY_FORMAT     = 0;
const int intArray::EXPONENTIAL_DISPLAY_FORMAT = 1;
const int intArray::SMART_DISPLAY_FORMAT       = 2;
// On the HP machines their C++ compiler initializes const static
// variable AFTER non-const static variables thus the DISPLAY_FORMAT
// gets garbage.  To fix this we initialize DISPLAY_FORMAT with the 
// value 2 directly!
// int intArray::DISPLAY_FORMAT = intArray::SMART_DISPLAY_FORMAT;
int intArray::DISPLAY_FORMAT = 2;

// *********************************************************
/* Constants used to define specific operations              */
/* (used within runtime system for control of optimizations) */
// *********************************************************
const int intArray::Plus             = 0;
const int intArray::Minus            = 1;
const int intArray::Times            = 2;
const int intArray::Divided_By       = 3;
const int intArray::Modulo           = 4;
const int intArray::cos_Function     = 5;
const int intArray::sin_Function     = 6;
const int intArray::tan_Function     = 7;
const int intArray::acos_Function    = 8;
const int intArray::asin_Function    = 9;
const int intArray::atan_Function    = 10;
const int intArray::cosh_Function    = 11;
const int intArray::sinh_Function    = 12;
const int intArray::tanh_Function    = 13;
const int intArray::acosh_Function   = 14;
const int intArray::asinh_Function   = 15;
const int intArray::atanh_Function   = 16;
const int intArray::log_Function     = 17;
const int intArray::log10_Function   = 18;
const int intArray::exp_Function     = 19;
const int intArray::sqrt_Function    = 20;
const int intArray::fabs_Function    = 21;
const int intArray::abs_Function     = 22; 
const int intArray::ceil_Function    = 23;
const int intArray::floor_Function   = 24;
const int intArray::atan2_Function   = 25;
const int intArray::Unary_Minus      = 26;
const int intArray::fmod_Function    = 27;
const int intArray::mod_Function     = 28;
const int intArray::pow_Function     = 29;
const int intArray::sign_Function    = 30;
const int intArray::min_Function     = 31;
const int intArray::max_Function     = 32;
const int intArray::Not              = 33;
const int intArray::LT               = 34;
const int intArray::GT               = 35;
const int intArray::LTEQ             = 36;
const int intArray::GTEQ             = 37;
const int intArray::EQ               = 38;
const int intArray::NOT_EQ           = 39;
const int intArray::AND              = 40;
const int intArray::OR               = 41;

const int intArray::Scalar_Plus             = 42;
const int intArray::Scalar_Minus            = 43;
const int intArray::Scalar_Times            = 44;
const int intArray::Scalar_Divided_By       = 45;
const int intArray::Scalar_Modulo           = 46;
const int intArray::Scalar_cos_Function     = 47;
const int intArray::Scalar_sin_Function     = 48;
const int intArray::Scalar_tan_Function     = 49;
const int intArray::Scalar_acos_Function    = 50;
const int intArray::Scalar_asin_Function    = 51;
const int intArray::Scalar_atan_Function    = 52;
const int intArray::Scalar_cosh_Function    = 53;
const int intArray::Scalar_sinh_Function    = 54;
const int intArray::Scalar_tanh_Function    = 55;
const int intArray::Scalar_acosh_Function   = 56;
const int intArray::Scalar_asinh_Function   = 57;
const int intArray::Scalar_atanh_Function   = 58;
const int intArray::Scalar_log_Function     = 59;
const int intArray::Scalar_log10_Function   = 60;
const int intArray::Scalar_exp_Function     = 61;
const int intArray::Scalar_sqrt_Function    = 62;
const int intArray::Scalar_fabs_Function    = 63;
const int intArray::Scalar_abs_Function     = 64;
const int intArray::Scalar_ceil_Function    = 65;
const int intArray::Scalar_floor_Function   = 66;
const int intArray::Scalar_atan2_Function   = 67;
const int intArray::Scalar_Unary_Minus      = 68;
const int intArray::Scalar_fmod_Function    = 69;
const int intArray::Scalar_mod_Function     = 70;
const int intArray::Scalar_pow_Function     = 71;
const int intArray::Scalar_sign_Function    = 72;
const int intArray::Scalar_min_Function     = 73;
const int intArray::Scalar_max_Function     = 74;
const int intArray::Scalar_Not              = 75;
const int intArray::Scalar_LT               = 76;
const int intArray::Scalar_GT               = 77;
const int intArray::Scalar_LTEQ             = 78;
const int intArray::Scalar_GTEQ             = 79;
const int intArray::Scalar_EQ               = 80;
const int intArray::Scalar_NOT_EQ           = 81;
const int intArray::Scalar_AND              = 82;
const int intArray::Scalar_OR               = 83;

// These are considered to terminate a Statement!
const int intArray::Assignment        = 84;
const int intArray::replace_Function  = 85;
const int intArray::Plus_Equals       = 86;
const int intArray::Minus_Equals      = 87;
const int intArray::Times_Equals      = 88;
const int intArray::Divided_By_Equals = 89;
const int intArray::Modulo_Equals     = 90;
const int intArray::sum_Function      = 91;
const int intArray::Scalar_Assignment        = 92;
const int intArray::Scalar_replace_Function  = 93;
const int intArray::Scalar_Plus_Equals       = 94;
const int intArray::Scalar_Minus_Equals      = 95;
const int intArray::Scalar_Times_Equals      = 96;
const int intArray::Scalar_Divided_By_Equals = 97;
const int intArray::Scalar_Modulo_Equals     = 98;
const int intArray::Scalar_sum_Function      = 99;

const int intArray::indexMap_Function = 100;
const int intArray::view_Function     = 101;
const int intArray::display_Function  = 102;

// Bitwise operators
const int intArray::BitwiseComplement       = 103;
const int intArray::BitwiseAND              = 104;
const int intArray::BitwiseOR               = 105;
const int intArray::BitwiseXOR              = 106;
const int intArray::BitwiseLShift           = 107;
const int intArray::BitwiseRShift           = 108;
const int intArray::Scalar_BitwiseAND        = 109;
const int intArray::Scalar_BitwiseOR         = 110;
const int intArray::Scalar_BitwiseXOR        = 111;
const int intArray::Scalar_BitwiseLShift     = 112;
const int intArray::Scalar_BitwiseRShift     = 113;
const int intArray::BitwiseAND_Equals       = 114;
const int intArray::BitwiseOR_Equals        = 115;
const int intArray::BitwiseXOR_Equals       = 116;
const int intArray::Scalar_BitwiseAND_Equals = 117;
const int intArray::Scalar_BitwiseOR_Equals  = 118;
const int intArray::Scalar_BitwiseXOR_Equals = 119;

// Conversion operators
const int intArray::convertTo_intArrayFunction    = 120;
const int intArray::convertTo_floatArrayFunction  = 121;
const int intArray::convertTo_doubleArrayFunction = 122;

// *********************************************************
// *********************************************************
// ****  BASEARRAY CLASS constructor and destructor  *****
// *********************************************************
// *********************************************************

#if defined(DOUBLEARRAY)

#if 1
BaseArray::BaseArray()
   {
  // Constructor
   };
#endif

#if 0
BaseArray::~BaseArray()
   {
  // Destructor
   };
#endif

// if DOUBLEARRAY
#endif

// *********************************************************
// *********************************************************
// ********  NEW OPERATOR INITIALIZEATION SUPPORT  *********
// *********************************************************
// *********************************************************

void
intArray::freeMemoryInUse() 
   {
  // *********************************************************
  // This function is useful in conjuction with the Purify (from Pure Software Inc.)
  // it frees memory allocated for use internally in A++ intArray objects.
  // This memory is used internally and is reported as "in use" by Purify
  // if it is not freed up using this function.  This function works with 
  // similar functions for each A++ object to free up all of the A++ memory in 
  // use internally.
  // *********************************************************

#if defined(USE_TAU)
     TAU_PROFILE("intArray::freeMemoryInUse()", "void(void)", TAU_APP_MEMORY_POOL_MANAGEMENT);
#endif

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        printf ("Inside of intArray::freeMemoryInUse() \n");
#endif 

#if 1
  // used in abstract_op.C to hold last temporary in cases where it must 
  // have a lifetime beyond the current statement.
#if !defined(PPP)
  // freeup space from last temporary!
     if (Last_Lhs_intArray_Operand != NULL)
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("Delete Last_Lhs_intArray_Operand  Last_Lhs_intArray_Operand = %p \n",Last_Lhs_intArray_Operand);
#endif 
       // Added conventional mechanism for reference counting control
       // operator delete no longer decriments the referenceCount.
          Last_Lhs_intArray_Operand->decrementReferenceCount();
          if (Last_Lhs_intArray_Operand->getReferenceCount() < getReferenceCountBase())
               delete Last_Lhs_intArray_Operand;
          Last_Lhs_intArray_Operand = NULL;
        }
       else
        {
#if COMPILE_DEBUG_STATEMENTS
          if (APP_DEBUG > 0)
               printf ("No Last_Lhs_intArray_Operand to delete! \n");
#endif 
        }
#endif

     int i;
     for (i=0; i < Max_Number_Of_Memory_Blocks-1; i++)
        {
          if (Memory_Block_List [i] != NULL)
             {
#if 1
               free ((char*) (Memory_Block_List[i]));
#else
               delete ((char*) (Memory_Block_List[i]));
#endif
             }
        }
#else
     printf ("intArray::freeMemoryInUse() Commented Out! \n");
#endif
   }

// *********************************************************
// *********************************************************
// ***********  INITIALIZATION FOR CONSTRUCTORS  ***********
// *********************************************************
// *********************************************************

// inline void
// intArray::preInitialize_Array ( int Number_Of_Valid_Dimensions ,
//                                  const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                                  bool Force_Memory_Allocation )
inline void
intArray::preInitializeArray ()
   {
// *************************************************************************
// This function is used internally in the Initialize_Array_Functions below
// *************************************************************************

#if defined(APP) || ( defined(SERIAL_APP) && !defined(PPP) )
  // For P++ we only track the serial array objects not the serial array objects
     if (Diagnostic_Manager::getTrackArrayData() == TRUE)
        {
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
#ifdef DOUBLEARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_DOUBLE_ELEMENT_TYPE);
#endif
#ifdef FLOATARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_FLOAT_ELEMENT_TYPE);
#endif
#ifdef INTARRAY
          Diagnostic_Manager::diagnosticInfoArray[Array_ID()]->setTypeCode(APP_INT_ELEMENT_TYPE);
#endif
          APP_ASSERT (Diagnostic_Manager::diagnosticInfoArray[Array_ID()] != NULL);
        }
#endif

#if defined(PPP)
     Array_Descriptor.SerialArray = NULL;
#else
     Array_Descriptor.Array_Data  = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

  // There are no auxilary references at this point
     referenceCount = getReferenceCountBase();

  // printf ("Allocation should be done in the Array_Descriptor object! \n");

  // If Force_Memory_Allocation == TRUE then the constructor has to allocate
  // space even if DEFER_EXPRESSION_EVALUATION == TRUE
  // This function allocates the data for the serial and distributed parallel
  // arrays.  I the case of P++ is allocates only this processors part of the
  // data (info obtained from block parti array descriptor).
     Allocate_Array_Data (TRUE);

#if 1
#if defined(PPP)
  // Error checking!
     if ( Communication_Manager::Number_Of_Processors == 1 )
        {
          for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
               if ( getLength(i) != Array_Descriptor.SerialArray->getLength(i) )
                  {
                 // printf ("Offset_For_Ghost_Boundary_Width = %d \n",Offset_For_Ghost_Boundary_Width);
                    printf ("getLength(%d) = %d  != Array_Descriptor.SerialArray->getLength(i) = %d \n",
                         i,getLength(i),Array_Descriptor.SerialArray->getLength(i));
                    printf ("getInternalGhostCellWidth(%d) = %d \n",i,getInternalGhostCellWidth(i));
                    view("In Initialization");
                    APP_ABORT();
                  }
             }
        }
#endif
#endif

#if !defined(PPP)
     POINTER_LIST_INITIALIZATION_MACRO;
#endif

     if (PREINITIALIZE_OBJECT_IN_CONSTRUCTOR)
        {
#if COMPILE_DEBUG_STATEMENTS
       // printf ("NOTE: PREINITIALIZING THE ARRAY AS PART OF INITIALIZATION (PREINITIALIZE_VALUE = %f) \n",(float)PREINITIALIZE_VALUE);
#endif
          operator=(PREINITIALIZE_VALUE);
        }

     Array_Storage = NULL;
     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
       // STARTING LIST FOR LIFETIME EXTENSION
          new intArray_Operand_Storage ( *this );
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from intArray::preInitializeArray");
#endif
   }

// inline void
// intArray::Initialize_Array ( int Number_Of_Valid_Dimensions , 
//                               const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                               bool Force_Memory_Allocation )
inline void
intArray::initializeArray ()
   {
// *************************************************************************
// This function is used internally in the constructors below
// *************************************************************************

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of intArray::initializeArray() (this = %p)\n",this);
        }
#endif

  // Call a common function to both initializeArray functions
     preInitializeArray ();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
     Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from intArray::initializeArray");
#endif
   }

#if defined(APP) || defined(PPP)
// *************************************************************************
// This function is used internally in the constructors below (for P++ 
// this allows the specification of an existing parallel partitioning object)
// *************************************************************************
// inline void
// intArray::Initialize_Array ( int Number_Of_Valid_Dimensions , 
//                               const Integer_Array_MAX_ARRAY_DIMENSION_Type Array_Size ,
//                               const Partitioning_Type & Partition , 
//                               bool Force_Memory_Allocation )
inline void
intArray::initializeArray ( const Internal_Partitioning_Type & Partition )
   {
  // Note that since we have moved the Array_Descriptor to be an object in the array object instead
  // of pointed to from the array object there is less fr this function to do and so the
  // Number_Of_Valid_Dimensions and the Array_Size input variables are no longer used
  // (except for printing debugging information).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 1)
        {
          printf ("Inside of intArray::initializeArray(Internal_Partitioning_Type&) (this = %p)\n",this);
       // printf (" (this = %p) \n",this);
        }
#endif

     if (&Partition);

#if 0
// (11/19/2000) The partitioning object should already be initialized
#if defined(PPP)
  // Initialize to use the input partitioning object
     Array_Descriptor.Array_Domain.Partitioning_Object_Pointer = &((Internal_Partitioning_Type&)Partition);

  // Bugfix (11/12/2000) It seems that incrementing the reference count was forgotten here!
     Array_Descriptor.Array_Domain.Partitioning_Object_Pointer->incrementReferenceCount();
#endif
#endif

  // Call a common function to both Initialize_Array functions
     preInitializeArray ();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
     APP_ASSERT (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer != NULL);
     Internal_Partitioning_Type::AddArrayToPartitioning(*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from intArray::initializeArray(Internal_Partitioning_Type&)");
#endif
   }

inline void
intArray::initializeArray ( const Partitioning_Type & Partition )
   {
  // Note that since we have moved the Array_Descriptor to be an object in the array object instead
  // of pointed to from the array object there is less fr this function to do and so the
  // Number_Of_Valid_Dimensions and the Array_Size input variables are no longer used
  // (except for printing debugging information).

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Inside of intArray::initializeArray (Partitioning_Type&) ");
       // printf (" (this = %p) \n",this);
        }
#endif

  // Call the version taking the Internal_Partitioning_Type
     initializeArray (*(Partition.getInternalPartitioningObject()));
   }
#endif


// *********************************************************
// *********************************************************
// ********************  CONSTRUCTORS  *********************
// *********************************************************
// *********************************************************

// ***************************************************************
// This constructor is used by the Defered Evaluation code to build
// A++ objects from a pointer to data and a descriptor.
// ***************************************************************
#if 0
// This function is commented out since we are testing 
// the current compilation of P++
// This function is called in lazy_operand.C!
// I don't think it is implemented correctly and I don't want to support it.

#if defined(PPP)
intArray::intArray( const intSerialArray* SerialArray_Pointer , 
   intArray_Descriptor_Type* 
   Array_Descriptor_Pointer, Operand_Storage* Array_Storage_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
// This may not be the right Array_Descriptor constructor to use???
// : Array_Descriptor(SerialArray_Pointer,Array_Descriptor_Pointer,Array_Storage_Pointer)
   : Array_Descriptor()
#endif
#else
intArray::intArray( const int* Array_Data_Pointer , 
   intArray_Descriptor_Type* 
   Array_Descriptor_Pointer , Operand_Storage* Array_Storage_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
// This may not be the right Array_Descriptor constructor to use???
// : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer,Array_Storage_Pointer)
   : Array_Descriptor()
#endif
#endif
   {
#if defined(USE_TAU)
     TAU_PROFILE("intArray::intArray()", "void(int*,intArray_Descriptor_Type*)", TAU_APP_CONSTRUCTORS);
#endif
  // This function is not used except in the lazy evaluation (one of them files)!

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
#if defined(PPP)
          printf ("Using the constructor 'intArray (intSerialArray*,Array_Descriptor_Type*,Operand_Storage*)'! \n");
       // printf ("Using the constructor 'intArray (intSerialArray*,Array_Domain_Type*,Operand_Storage*)'! \n");
#else
          printf ("Using the constructor 'intArray (int*,Array_Descriptor_Type*,Operand_Storage*)'! \n");
       // printf ("Using the constructor 'intArray (int*,Array_Domain_Type*,Operand_Storage*)'! \n");
#endif
        }
#endif

  // **********************************************************************************************
     printf ("I think this function is not used except in lazy evaluation \n");
     printf ("    It uses an older construction mechanism that uses the operator= \n");
     printf ("    Untill this is corrected I think this function should be disabled! \n");
     printf ("Exiting in intArray (intSerialArray*,Array_Descriptor_Type*,Operand_Storage*) \n");
     APP_ABORT();
  // **********************************************************************************************

  // This forces a copy of the descriptor data into the descriptor member in the array
  // at some point this will be an important issue to optimize since we want to avoid
  // building a descriptor to initialize the array's descriptor only to then
  // throw away the first descriptor.  So this is an efficency issue.
     Array_Descriptor = *Array_Descriptor_Pointer;
#if defined(PPP)
     Array_Descriptor.SerialArray      = (intSerialArray*) SerialArray_Pointer;
#else
     Array_Descriptor.Array_Data       = (int*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
#endif
     Array_Storage    = Array_Storage_Pointer;
     referenceCount   = getReferenceCountBase();
   }
// commented out!
#endif

// *******************************************************************************
// This is the default constructor it builds a NULL array (an array with no data).
// *******************************************************************************
intArray::intArray() 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor()
#endif
   {
  // Note that a nullArray does not have a partitioning object since it's partitioning will 
  // defined only at the point where it has data (i.e. not yet)

  // Possible improvement to this implementation:
  //    1: Call the initializeArray function!

#if defined(USE_TAU)
     TAU_PROFILE("intArray::intArray()", "void(void)", TAU_APP_CONSTRUCTORS);
#endif

  // The default constructor for the Array_Descriptor sets up a NULL Array
  // (meaning an array with no data) so we have Array_Data = NULL.

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Call intArray::intArray() DEFAULT Constructor (this = %p) \n",this);
#endif

     Array_Storage    = NULL;
     referenceCount   = getReferenceCountBase();

#if defined(PPP)
  // Should this be NULL or a pointer to a NULL intSerialArray
  // Bugfix (12/14/94) a NULL P++ array contains a pointer to a NULL A++ array
  // It would be more efficient if it could be a NULL pointer but it would
  // make the implementation more complex so we force a P++ NULL array to 
  // have an A++ NULL array (since then we have to check the pointer for NULL
  // and we can't assert that the ponter is always non-NULL).
     Array_Descriptor.SerialArray = new intSerialArray();
#else
     Array_Descriptor.Array_Data = NULL;
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif

     Array_Storage    = NULL;
     referenceCount   = getReferenceCountBase();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
  // Internal_Partitioning_Type::DefaultintArrayList.addElement(*this);
     Internal_Partitioning_Type::AddArrayToPartitioning(*this);
#endif

  // printf ("At BASE of default constructor intArray::intArray() Array_ID() = %d  getRawDataReferenceCount() = %d \n",Array_ID(),getRawDataReferenceCount());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from default constructor intArray::intArray()");
#endif
   }

// ***************************************************************
// This function allows the construction of an A++ array object 
// using an existing meory pointer.
// ***************************************************************
#if defined(PPP)
// intArray::intArray ( int* Data_Pointer , int i , const Range & Range_I , 
//                                           int j , const Range & Range_J ,
//                                           int k , const Range & Range_K ,
//                                           int l , const Range & Range_L )
intArray::intArray ( const int* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE)
#endif
   {
  // To use existing data in the parallel environment we have to specify the global size
  // and the base/bound (using the Range object).  The base of the global array is set to 
  // ZERO.  It can be reset after construction if required.

#if defined(USE_TAU)
     TAU_PROFILE("intArray::intArray()", "void(int*,int,int,int,int,int,int)", TAU_APP_CONSTRUCTORS);
#endif
  // This constructor uses existing data and builds a P++ array that encloses it
  // Range objects are used to specify the local processor's partition of the data

     INTEGER_AND_RANGE_ARGUMENTS_TO_INTEGER_AND_CONST_REF_RANGE_LIST_MACRO

     printf ("Sorry, not implemented: intArray::intArray ( const int* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE ) \n");
     printf ("     We can't yet support arbitrary distributions such as has been specified ... \n");
     APP_ABORT();

  // Initialize the pointers befor calling adopt
  // Array_Descriptor = NULL;
     Array_Descriptor.SerialArray      = NULL;
     referenceCount   = getReferenceCountBase();

  // Build default partition for use within adopt.  This is not likely the
  // correct partition to use here so this should be passed in as an option when the
  // parallel adopt function is implemented.
     Partitioning_Type Partition;
  // It is simple to just call the adopt function!
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase());
     adopt ( Data_Pointer , Partition, Integer_List , Internal_Index_List );
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

     APP_ASSERT (Array_Descriptor.Array_Domain.builtUsingExistingData == TRUE);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor intArray::intArray(int*,ARGUMENT_LIST_MACRO_INTEGER_AND_CONST_REF_RANGE)");
#endif
   }

// end of if defined(PPP)
#else
// else for if not defined(PPP)

// intArray::intArray ( int* Data_Pointer , int i , int j , int k , int l )
intArray::intArray ( const int* Data_Pointer , ARGUMENT_LIST_MACRO_INTEGER ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_INTEGER)
#endif
   {
#if defined(USE_TAU)
     TAU_PROFILE("intArray::intArray()", "void(int*,int,int,int,int,int,int)", TAU_APP_CONSTRUCTORS);
#endif

  // Should we call the more general initialization 
  // (it would allocate data -- so I guess not!)
     referenceCount   = getReferenceCountBase();
     Array_Storage    = NULL;
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor intArray::intArray(int*,ARGUMENT_LIST_MACRO_INTEGER)");
#endif
   }
#endif

// *****************************************************************
// Constructor using existing memory and Range objects
// *****************************************************************
#if !defined(PPP)
intArray::intArray ( const int* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor (Data_Pointer,VARIABLE_LIST_MACRO_CONST_REF_RANGE)
#endif
   {
  // Should we call the more general initialization 
  // (though it would allocate data so I guess not)
     referenceCount   = getReferenceCountBase();
     Array_Storage    = NULL;
     APP_ASSERT (getRawDataReferenceCount() == getReferenceCountBase()+1);

  // printf ("Exiting in intArray::intArray ( const int* Data_Pointer , ARGUMENT_LIST_MACRO_CONST_REF_RANGE ) \n");
  // APP_ABORT();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor intArray::intArray(int*,ARGUMENT_LIST_MACRO_CONST_REF_RANGE)");
#endif
   }
#endif

// ************************************************************
// Copy constructor should not be used often since it really 
// makes a deep copy (as a good copy constructor should)!
// ************************************************************
intArray::intArray( const intArray & X , int Type_Of_Copy ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(X.Array_Descriptor,Type_Of_Copy)
#endif
   {
  // If the user passes parameters by value (instead of by reference) then we 
  // are forced to abide by his/her wishes and do the required copying.  It is most
  // likely however that he/she wants to pass by reference for better efficiency.
  // There is nothing that the array class should do to provide what we might think
  // the user wants since passing by value provides a level of protection against 
  // function side effects that the user might have specifically choosen.

  // There are different types of copies:
  //    Shallow Copy
  //        Don't really copy anything (just make a new reference to the existing data)
  //        This is NOT the default!
  //        Supported value: SHALLOWCOPY
  //    Deep Copy
  //        Deep Collapsed Copy
  //             Current functionality of the Deep Copy option.
  //             This IS the default!
  //             Supported value: DEEPCOPY or DEEPCOLAPSEDCOPY
  //        Deep Aligned Copy
  //             Build copy to be same size as original array (might be inefficient)
  //             Supported value: DEEPALIGNEDCOPY
  //        Deep Collapsed and Aligned Copy
  //             This requires additional support from PADRE (table based distributions)
  //             Supported value: DEEPCOLAPSEDALIGNEDCOPY

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("*********************************************** \n");
          printf ("*********************************************** \n");
          printf ("Using the copy constructor intArray(const intArray & X) (X.Array_ID() = %d) \n",X.Array_ID());
          printf ("*********************************************** \n");
          printf ("*********************************************** \n");
        }
     X.Test_Consistency ("X called from COPY constructor intArray::intArray(intArray)");
#endif

#if !defined(PPP)
  // This does not make sense for P++ (I think)???
  // Since this is a new array object it should have an initialize referenced count on its
  // raw data.  This is required here because the reference counting mechanism reused the
  // value of zero for an existing reference and no references (this will be fixed soon).
  // (5/1/2000) The reference count base is now 1 so it is fixed now -- I suspect this is no longer required!
     resetRawDataReferenceCount();
#endif

#if defined(PPP)
     Array_Descriptor.SerialArray = NULL;
#else
  // Since we will allocate new data we need to initialize this to NULL
  // prior to calling the Allocate_Array_Data member function
     Array_Descriptor.Array_Data  = NULL;
  // ... bug fix (10/9/96,kdb) this was fixed a while ago but got lost.  The
  // descriptor pointer needs to be initialized as well as the data pointer ...
     POINTER_LIST_NULL_INITIALIZATION_MACRO;
#endif
     Array_Storage  = NULL;
     referenceCount = getReferenceCountBase();

#if 0
  // error checking
     if ( (Type_Of_Copy != DEEPCOPY) && (Type_Of_Copy != SHALLOWCOPY) )
        {
          printf ("ERROR: Type_Of_Copy neither DEEPCOPY nor SHALLOWCOPY \n");
          APP_ABORT();
        }
#endif

#if 0
  // Example source code (from Brian) showing how to build the ALIGNED_COPY mechanism
     cout<<" J.getRawBase(0)= "<<J.getRawBase(0)<<"  J.getRawBound(0)= "<<J.getRawBound(0)<<"  J.getRawStride(0)= "<<J.getRawStride(0)<<endl;
     J.getFullRange(0).display("J.getFullRange(0)");
     intArray TT(Range(J.getFullRange(0).getBase(),J.getFullRange(0).getBound()));
     J.dimension(0).display("J.dimension(0)");  
     intArray T = TT(Range(J.getRawBase(0),J.getRawBound(0),J.getRawStride(0)));
#endif

  // Code in progress to redo how we handle different cases of Type_Of_Copy and include additional cases
     bool Force_Memory_Allocation = TRUE;
     int Old_Array_Id                = Array_Descriptor.Array_ID();

#if defined(PPP)
  // Add this array to the list of arrays associated with this partition
  // so that we can control the distribution of the arrays using the
  // operations on the partitioning object.
  // This must be called before the Allocate_Array_Data function
     if (Array_Descriptor.Array_Domain.Partitioning_Object_Pointer == NULL)
        {
          Internal_Partitioning_Type::AddArrayToPartitioning(*this);
        }
       else
        {
          Internal_Partitioning_Type::AddArrayToPartitioning (*Array_Descriptor.Array_Domain.Partitioning_Object_Pointer,*this);
        }
#endif

  // The copy constructor supports several different types of copy semantics
     switch (Type_Of_Copy)
        {
          case SHALLOWCOPY:
            // This is the simplist case of the copy constructor (but not often very useful)
               reference (X);
               break;

          case DEEPCOLAPSEDCOPY:
          case DEEPCOPY:
            // printf ("In Array copy constructor - the Array_Descriptor should allocate the data! \n");

            // The copy constructor has to allocate space even if 
            // DEFER_EXPRESSION_EVALUATION == TRUE
               setTemporary(FALSE);

            // (19/2/98) This is a fix to skip the allocation of data and force it to be
            // allocated by the operator= only if required.  The result is more efficient code.
            // If the input is a temporary then this code could be written more efficiently!
            // printf ("Inefficent Operation: COPY constructor is forced to allocate data even if input is a temporary! \n");
               Allocate_Array_Data ( Force_Memory_Allocation );

               APP_ASSERT (isTemporary() == FALSE);

            // Error checking (make sure not a view)
            // Since we just made a copy this object is NOT a view! 
               if (Array_Descriptor.usesIndirectAddressing())
                  {
                 // printf ("WARNING: copy constructor built a view using intArrays (correcting)! \n");
                 // Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                 // for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                 //      Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 0)
                       {
                         printf ("WARNING: copy constructor built a view using intArrays (correcting by deleting indirection intArrays)! \n");
                       }
#endif
                    Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                    for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                       {
                      // (5/1/2000) valid pointers were previously just set to NULL.
                      // This caused a bug when the reference count of the indirection 
                      // intArray was not decremented properly and the delete operator
                      // called when there are no more references.
                         if (Array_Descriptor.Array_Domain.Index_Array[i] != NULL)
                            {
                              Array_Descriptor.Array_Domain.Index_Array[i]->decrementReferenceCount();
                              if (Array_Descriptor.Array_Domain.Index_Array[i]->getReferenceCount() < intArray::getReferenceCountBase())
                                   delete Array_Descriptor.Array_Domain.Index_Array[i];
                              Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
                            }
                       }
                  }

#if !defined(PPP)
            // this can't be a view
               POINTER_LIST_INITIALIZATION_MACRO;
#endif

            // Call operator=
            // If the operator= can just steal the data and void a deep copy then it will
            // do so and then delete the memory allocated a few lines above!
            // printf ("Assignement commented out in intArray::COPY CONSTRUCTOR! \n");
            // printf ("Assignement in intArray::COPY CONSTRUCTOR! \n");
            // APP_DEBUG = 1;
               *this = X;
            // APP_DEBUG = 0;
               break;

          case DEEPALIGNEDCOPY:
            // intArray Copy (Range(X.getFullRange(0).getBase(),X.getFullRange(0).getBound()));
            // printf ("DEEPALIGNEDCOPY not supported yet! \n");
            // APP_ABORT();
            // printf ("In Array copy constructor - the Array_Descriptor should allocate the data! \n");

            // The copy constructor has to allocate space even if 
            // DEFER_EXPRESSION_EVALUATION == TRUE
               setTemporary(FALSE);

            // (19/2/98) This is a fix to skip the allocation of data and force it to be
            // allocated by the operator= only if required.  The result is more efficient code.
            // If the input is a temporary then this code could be written more efficiently!
            // printf ("Inefficent Operation: COPY constructor is forced to allocate data even if input is a temporary! \n");
               Allocate_Array_Data ( Force_Memory_Allocation );

               APP_ASSERT (isTemporary() == FALSE);

            // Error checking (make sure not a view)
            // Since we just made a copy this object is NOT a view! 
               if (Array_Descriptor.usesIndirectAddressing())
                  {
                 // printf ("WARNING: copy constructor built a view using intArrays (correcting)! \n");
                 // Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                 // for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                 //      Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
#if COMPILE_DEBUG_STATEMENTS
                    if (APP_DEBUG > 0)
                       {
                         printf ("WARNING: copy constructor built a view using intArrays (correcting be deleting indirection intArrays)! \n");
                       }
#endif
                    Array_Descriptor.Array_Domain.Uses_Indirect_Addressing = FALSE;
                    for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
                       {
                      // (5/1/2000) valid pointers were previously just set to NULL.
                      // This caused a bug when the reference count of the indirection 
                      // intArray was not decremented properly and the delete operator
                      // called when there are no more references.
                         if (Array_Descriptor.Array_Domain.Index_Array[i] != NULL)
                            {
                              Array_Descriptor.Array_Domain.Index_Array[i]->decrementReferenceCount();
                              if (Array_Descriptor.Array_Domain.Index_Array[i]->getReferenceCount() < intArray::getReferenceCountBase())
                                   delete Array_Descriptor.Array_Domain.Index_Array[i];
                              Array_Descriptor.Array_Domain.Index_Array[i] = NULL;
                            }
                       }
                  }

#if !defined(PPP)
            // this can't be a view
               POINTER_LIST_INITIALIZATION_MACRO;
#endif

            // Call operator=
            // If the operator= can just steal the data and void a deep copy then it will
            // do so and then delete the memory allocated a few lines above!
            // printf ("Assignement commented out in intArray::COPY CONSTRUCTOR! \n");
            // APP_DEBUG = 1;

            // printf ("Now call the assignement operator in intArray::COPY CONSTRUCTOR! \n");
#if 1
               *this = X;
#else
               printf ("#####  ASSIGNING TO A SCALAR VALUE!!!!!  ##### \n");
               *this = 1;
#endif

            // APP_DEBUG = 0;
               break;

          case DEEPCOLAPSEDALIGNEDCOPY:
               printf ("DEEPCOLAPSEDALIGNEDCOPY not supported yet! \n");
               APP_ABORT();
               break;

          default:
               printf ("ERROR: default reached in COPY Constructor Type_Of_Copy = %d not known \n",Type_Of_Copy);
               APP_ABORT();
               break;
        }

#if defined(PPP)
  // Now update the ghost boundaries with valid data for the neighboring processors
  // Not sure that this is required since the initialization of the local arrays 
  // should have updated the boundaries (at least is special cases).
     updateGhostBoundaries();
#endif

     if (Expression_Tree_Node_Type::DEFER_EXPRESSION_EVALUATION)
        {
          new intArray_Operand_Storage ( *this );
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from COPY constructor intArray::intArray(intArray)");
#endif
   }

#ifdef USE_STRING_SPECIFIC_CODE

#if defined(APP) || defined(SERIAL_APP)
// ************************************************************
// Copy constructor should not be used often since it really 
// makes a deep copy (as a good copy constructor should)!
// ************************************************************
// intArray::intArray( const char* dataString ) 
intArray::intArray( const AppString & dataString ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(dataString)
#else
   : Array_Descriptor(dataString)
#endif
   {
     initializeArray ();

#if 1
     char* numberString = strdup(dataString.getInternalString());

  // Now fill in the newly declared array
     char* delimiterList = " {},";
     char* nextSubString = NULL;
     int counter = 0;

     int* dataPointer = getDataPointer();

  // char* nextSubString = strtok(dataString,delimiterList);
  // parseString (nextSubString,numbersString);
     if ( (nextSubString = strtok(numberString,delimiterList)) != NULL )
        {
          printf ("counter = %d nextSubString = %s \n",counter,nextSubString);
#ifdef DOUBLEARRAY
          dataPointer[counter] = atof(nextSubString);
#endif
#ifdef FLOATARRAY
          dataPointer[counter] = atof(nextSubString);
#endif
#ifdef INTARRAY
          dataPointer[counter] = atoi(nextSubString);
#endif
          while ( (nextSubString = strtok(NULL,delimiterList)) != NULL )
             {
               counter++;
               dataPointer[counter] = atoi(nextSubString);
            // printf ("counter = %d nextSubString = %s \n",counter,nextSubString);
             }
        }
#else
     printf ("intArray ( const AppString & dataString ) not compiled unless USE_STRING_SPECIFIC_CODE used in compiling A++/P++! \n");
     APP_ABORT();
#endif

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from constructor intArray::intArray(char*)");
#endif
   }

// if defined(APP) || defined(SERIAL_APP)
#endif

// if USE_STRING_SPECIFIC_CODE 
#endif

// *************************************************************************
/* This function is too large for inlining using the AT&T compiler!
   But we might be able to inline the Array_Descriptor_Type at some point
   and that might be worth while since this function is called a lot in A++ */
// *************************************************************************
intArray::intArray ( int i ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }

#if (MAX_ARRAY_DIMENSION >= 2)
intArray::intArray ( int i , int j ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 3)
intArray::intArray ( int i , int j , int k ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 4)
intArray::intArray ( int i , int j , int k , int l ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 5)
intArray::intArray ( int i , int j , int k , int l , int m )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 6)
intArray::intArray ( int i , int j , int k , int l , int m , int n ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 7)
intArray::intArray ( int i , int j , int k , int l , int m , int n , int o ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 8)
intArray::intArray ( int i , int j , int k , int l , int m , int n , int o , int p ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,p+APP_Global_Array_Base-1))
#endif
   {
     initializeArray();
   }
#endif

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
intArray::intArray( const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor (MAX_ARRAY_DIMENSION,Integer_List)
#endif
   {
     initializeArray();
   }

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
// intArray::intArray( int Array_Size_I , int Array_Size_J , int Array_Size_K ,
//                       int Array_Size_L , bool Force_Memory_Allocation )
intArray::intArray( ARGUMENT_LIST_MACRO_INTEGER , bool Force_Memory_Allocation ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor (VARIABLE_LIST_MACRO_INTEGER)
#endif
   {
  // ZERO is an acceptable value for the Array size!

  // Avoid compiler warning for unused input variable
     if (&Force_Memory_Allocation);

     INTEGER_ARGUMENTS_TO_INTEGER_LIST_MACRO

#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
        {
          printf ("Using the constructor intArray::intArray (ARGUMENT_LIST_MACRO_INTEGER, bool) ");
          for (int index_var=0; index_var < MAX_ARRAY_DIMENSION; index_var++)
               printf ("int=%d,",Integer_List[index_var]);
          printf (" (this = %p) \n",this);
          printf ("\n");
        }
#endif

     initializeArray();
   }

#if defined(APP) || defined(PPP)
// *************************************************************************
/* This function is too large for inlining using the AT&T compiler!
   But we might be able to inline the Array_Descriptor_Type at some point
   and that might be worth while since this function is called a lot in A++ */
// *************************************************************************
intArray::intArray ( int i , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }

#if (MAX_ARRAY_DIMENSION >= 2)
intArray::intArray ( int i , int j , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 3)
intArray::intArray ( int i , int j , int k , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray(Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 4)
intArray::intArray ( int i , int j , int k , int l , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 5)
intArray::intArray ( int i , int j , int k , int l , int m , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 6)
intArray::intArray ( int i , int j , int k , int l , int m , int n , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 7)
intArray::intArray ( int i , int j , int k , int l , int m , int n , int o , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 8)
intArray::intArray ( int i , int j , int k , int l , int m , int n , int o , int p , const Partitioning_Type & Partition ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,m+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,n+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,o+APP_Global_Array_Base-1),
                      Range(APP_Global_Array_Base,p+APP_Global_Array_Base-1),
                      *Partition.getInternalPartitioningObject())
#endif
   {
     initializeArray (Partition);
   }
#endif

// *************************************************************
// A++ array object constructor used internally in A++
// *************************************************************
// intArray::intArray( int Array_Size_I , int Array_Size_J , int Array_Size_K ,
//                       int Array_Size_L , const Partitioning_Type & Partition , bool Force_Memory_Allocation )
intArray::intArray( ARGUMENT_LIST_MACRO_INTEGER ,
                      const Partitioning_Type & Partition ,
                      bool Force_Memory_Allocation )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
// : Array_Descriptor(Range(APP_Global_Array_Base,i+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,j+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,k+APP_Global_Array_Base-1),
//                    Range(APP_Global_Array_Base,l+APP_Global_Array_Base-1),
//                    *Partition.getInternalPartitioningObject())
   : Array_Descriptor(COMPUTE_RANGE_ARGUMENTS_MACRO,
                      *Partition.getInternalPartitioningObject())
#endif
   {
  // Avoid compiler generated warning about unused input variable
     if (&Force_Memory_Allocation);

  // ZERO is an acceptable value for the Array size!
     initializeArray(Partition);
   }
#endif

intArray::intArray( ARGUMENT_LIST_MACRO_CONST_REF_RANGE ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(VARIABLE_LIST_MACRO_CONST_REF_RANGE)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Inside of constructor intArray::intArray( ARGUMENT_LIST_MACRO_CONST_REF_RANGE )! \n");
#endif

     initializeArray();
   }

intArray::intArray( const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Internal_Index_List)
#endif
   {
     initializeArray();
   }

#if defined(PPP) || defined (APP)
intArray::intArray( 
   const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Internal_Index_List, 
   const Internal_Partitioning_Type & partition )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Internal_Index_List,partition)
#endif
   {
     initializeArray(partition);
   }
#endif

#if (MAX_ARRAY_DIMENSION >= 2)
// *************************************************************
// We need this constructor to avoid confusion with the copy 
// constructor (ambiguous call problem due to promotion of Range
// to A++ array object).
// *************************************************************
//intArray::intArray ( const Range & Range_I , int j ) 
//   : Array_Descriptor(Range_I,Range(APP_Global_Array_Base,j))
intArray::intArray ( const Range & Range_I , int j ) 
   : Array_Descriptor(Range_I,Range(APP_Global_Array_Base,j-1))
#if defined(USE_EXPRESSION_TEMPLATES)
   , InArray<int>(this)
#endif
   {
     initializeArray();
   }
#endif

#if !defined(PPP)
//============================================================================
//============  Constructor used in operator()(Internal_Index)  ==============
//============================================================================
intArray::intArray( const int* Array_Data_Pointer,
                      const Array_Domain_Type & X,
                      const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this,X,Index_List)
#else
// : Array_Descriptor(Array_Data_Pointer,X,Index_List)
   : Array_Descriptor(X,Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
     Array_Descriptor.Array_Data   = (int*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor intArray (int*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

     if (Array_ID() != X.Array_ID())
        {
          view("this: In intArray::intArray(int*,const Array_Domain_Type & X,const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List)");
          X.display("X: In intArray::intArray(int*,const Array_Domain_Type & X,const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List)");
        }
     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (int*,Array_Descriptor_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }

//============================================================================
intArray::intArray( const int* Array_Data_Pointer,
                      const Array_Domain_Type & X,
                      const Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Indirect_Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this,X,Indirect_Index_List)
#else
   : Array_Descriptor(X,Indirect_Index_List)
// : Array_Descriptor(Array_Data_Pointer,X,Indirect_Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
     Array_Descriptor.Array_Data   = (int*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor intArray (int*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (int*,Array_Descriptor_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
 // end of not PPP
#endif

//============================================================================
#if defined(PPP)
intArray::intArray( const intSerialArray* SerialArray_Pointer,
                      const Array_Domain_Type & X,
                      const Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this,X,Index_List)
#else
   : Array_Descriptor(X,Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif

     Array_Descriptor.SerialArray = (intSerialArray*) SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

#if COMPILE_DEBUG_STATEMENTS
     if (SerialArray_Pointer != NULL)
        {
       // APP_ASSERT(SerialArray_Pointer->getDataPointer() != NULL);

          if (APP_DEBUG > 5)
               view("Using the constructor intArray (intSerialArray*,Array_Domain_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }
#endif

     APP_ASSERT(Array_ID() == X.Array_ID());
     
  // ... add this fix from other constructor (2/14/96, kdb) ...
  // ... The local part of an indexed view might be a Null Array on some 
  // processors.  On those processors all the Local_Mask_Index objects must 
  // be Null_Index objects. ...
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);
     if (Array_Descriptor.SerialArray->isNullArray() == TRUE)
        {
#if 0
          for (int i=0; i < MAX_ARRAY_DIMENSION; i++)
               Array_Descriptor.Array_Domain.Local_Mask_Index [i] = Internal_Index (0,0,1,Null_Index);
#else
          Array_Descriptor.Array_Domain.resetDomainForNullArray();
#endif

       // (12/13/2000) Added test
          APP_ASSERT (getLeftNumberOfPoints(0) == 0);
          APP_ASSERT (getRightNumberOfPoints(0) == 0);
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (intSerialArray*,Array_Descriptor_Type*,Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }

//============================================================================
intArray::intArray( const intSerialArray* SerialArray_Pointer, 
                      const Array_Domain_Type & X,  
                      const Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type 
		      Indirect_Index_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this,X,Indirect_Index_List) 
#else
   : Array_Descriptor(X,Indirect_Index_List)
// : Array_Descriptor(SerialArray_Pointer,X,Indirect_Index_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (intSerialArray*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
  // Array_Descriptor.Array_Domain = *Array_Domain_Pointer;
  // Array_Descriptor.Array_Data   = 
  //	(int*) SerialArray_Pointer.Array_Descriptor.Array_Data;
     Array_Descriptor.SerialArray = (intSerialArray*)SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

  // New test (12/13/2000)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     if (SerialArray_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor intArray (intSerialArray*,Array_Domain_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // New test (12/13/2000) if this is false then consider calling "getDomain().resetDomainForNullArray();"
          APP_ASSERT (Array_Descriptor.SerialArray->isNullArray() == FALSE);
        }

     APP_ASSERT(Array_ID() == X.Array_ID());

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (intSerialArray*,Array_Descriptor_Type*,Indirect_Index_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
//============================================================================
intArray::intArray( const intSerialArray* SerialArray_Pointer,
                      const Integer_Array_MAX_ARRAY_DIMENSION_Type Integer_List )
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this,Integer_List)
#else
   : Array_Descriptor(MAX_ARRAY_DIMENSION,Integer_List)
// : Array_Descriptor(SerialArray_Pointer,MAX_ARRAY_DIMENSION,Integer_List)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)'! \n");
#endif
     Array_Descriptor.SerialArray = (intSerialArray*)SerialArray_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

  // New test (12/13/2000)
     APP_ASSERT (Array_Descriptor.SerialArray != NULL);

     if (SerialArray_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor intArray (intSerialArray*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // New test (12/13/2000) if this is false then consider calling "getDomain().resetDomainForNullArray();"
          APP_ASSERT (Array_Descriptor.SerialArray->isNullArray() == FALSE);
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (intSerialArray*,Integer_Pointer_Array_MAX_ARRAY_DIMENSION_Type)");
#endif
   }
  // end of PPP only section
#endif

//============================================================================

#if !defined(PPP)
// ... this looks like it should only work if not PPP ...
// Support for the following ...
// Temporary_Array = new intArray ( Null_Array , 
//                                   &(Lhs.Array_Descriptor.Array_Domain), 
//                                   AvoidBuildingIndirectAddressingView);

intArray::intArray( const int* Array_Data_Pointer , const Array_Domain_Type* Array_Domain_Pointer, bool AvoidBuildingIndirectAddressingView ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView) 
#else
   : Array_Descriptor(*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
// : Array_Descriptor(Array_Data_Pointer,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Domain_Type*)'! \n");
#endif
     Array_Descriptor.Array_Data   = (int*) Array_Data_Pointer;
     referenceCount                = getReferenceCountBase();
     Array_Storage                 = NULL;
     POINTER_LIST_INITIALIZATION_MACRO;

#if !defined(PPP)
  // Since this is a new array object is should have an initialize reference count on its
  // raw data.  This is required here because the reference counting mechanism reused the 
  // value of zero for one existing reference and no references (this will be fixed soon).
     resetRawDataReferenceCount();
#endif
     if (Array_Data_Pointer != NULL)
        {
          if (APP_DEBUG > 5)
               view("Using the constructor intArray (int*,Array_Domain_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
       // If we have valid data then it should have a reference count showing that
       // there is an external reference.
          incrementRawDataReferenceCount();
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (int*,Array_Descriptor_Type*,bool)");
#endif
   }
#endif // end of not PPP

//============================================================================

#if defined(PPP)
// Support for the following ...
// Temporary_Array = new intArray ( Null_Array , 
//                                   &(Lhs.Array_Descriptor.Array_Domain), 
//                                   AvoidBuildingIndirectAddressingView);

intArray::intArray(
     intSerialArray* SerialArray_Pointer , 
     const Array_Domain_Type* Array_Domain_Pointer, 
     bool AvoidBuildingIndirectAddressingView ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView) 
#else
   : Array_Descriptor(*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
// : Array_Descriptor(SerialArray_Pointer,*Array_Domain_Pointer,AvoidBuildingIndirectAddressingView)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Domain_Type*)'! \n");
#endif
     Array_Descriptor.SerialArray   = (intSerialArray*)SerialArray_Pointer;
     referenceCount                 = getReferenceCountBase();
     Array_Storage                  = NULL;

     if (SerialArray_Pointer != NULL)
        {
          APP_ASSERT (SerialArray_Pointer != NULL);
#if 1
       // We need to adjust the base of the local array for account for the base of the 
       // parallel array object.  This makes more sense than the other way around.
          int i = 0;
          for (i=0; i < MAX_ARRAY_DIMENSION; i++)
             {
            // set the bases of the SerialArray to match that of the ParallelArray
            // built using the input Array_Domain_Pointer
            // APP_ASSERT (Array_Descriptor.Array_Domain.Global_Index[i].getMode()     != Null_Index); 
            // APP_ASSERT (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != Null_Index); 
               int Global_Difference = 0;
               int Local_Difference  = 0;

               if (Array_Descriptor.Array_Domain.Global_Index[i].getMode() != Null_Index) 
                    Global_Difference = 
                         Array_Descriptor.Array_Domain.Global_Index[i].getBase() -
                         Array_Descriptor.Array_Domain.getRawBase(i);

               if (Array_Descriptor.Array_Domain.Local_Mask_Index[i].getMode() != Null_Index) 
                    Local_Difference = 
                         Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase() -
                         SerialArray_Pointer->Array_Descriptor.Array_Domain.getRawBase(i);
#if 0
               printf ("SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",
                    i,SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i]);
               printf ("Array_Descriptor.Array_Domain.Data_Base[%d] = %d \n",
                    i,Array_Descriptor.Array_Domain.Data_Base[i]);
               printf ("Array_Domain_Pointer->Data_Base[%d] = %d \n",
                    i,Array_Domain_Pointer->Data_Base[i]);
               printf ("Array_Domain_Pointer->getBase(%d) = %d \n",
                    i,Array_Domain_Pointer->getBase(i));
               printf ("SerialArray_Pointer->getBase(%d) = %d \n",
                    i,SerialArray_Pointer->getBase(i));
            // int newBase = Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase();
            // printf ("newBase = %d \n",newBase);
            // ((intSerialArray*)SerialArray_Pointer)->setBase(newBase,i);
            // SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] = newBase;;
               printf ("Global_Difference = %d \n",Global_Difference);
               printf ("Local_Difference  = %d \n",Local_Difference);
            // Array_Descriptor.Array_Domain.Data_Base[i] = 
            //      Array_Descriptor.Array_Domain.Global_Index[i].getBase();
            // SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] = 
            //      Array_Descriptor.Array_Domain.Local_Mask_Index[i].getBase();
#endif
               Array_Descriptor.Array_Domain.Data_Base[i] += Global_Difference;
               Array_Descriptor.Array_Domain.User_Base[i] += Global_Difference;
               SerialArray_Pointer->Array_Descriptor.Array_Domain.Data_Base[i] += Local_Difference;
               SerialArray_Pointer->Array_Descriptor.Array_Domain.User_Base[i] += Local_Difference;
             }
#endif

          SERIAL_POINTER_LIST_INITIALIZATION_MACRO;

          if (APP_DEBUG > 5)
               view("Using the constructor intArray (int*,Array_Domain_Type*)");

#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif

#if 0
       // Test (11/12/2000) Maybe this should be in the descriptor?
       // Added to reflect that temoraries will be deleted when used within serial array operations
       // and we want them to last until they are deleted by the parallel array object.
          if (SerialArray_Pointer->isTemporary() == TRUE)
             {
               SerialArray_Pointer->incrementReferenceCount();
               APP_ASSERT (SerialArray_Pointer->getReferenceCount() > 1);
             }
#endif
        }

  // We might need this!
  // resetRawDataReferenceCount();
  // incrementRawDataReferenceCount();

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (int*,Array_Descriptor_Type*)");
#endif
   }
#endif  // end of PPP only


//============================================================================

#if !defined(PPP)
#if 0
// All of these are commented out!!!
intArray::intArray
   ( const int* Array_Data_Pointer , 
     const intArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (int*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor intArray (int*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (int*,Array_Descriptor_Type*)");
#endif
   }

intArray::intArray
   ( const int* Array_Data_Pointer , 
     const floatArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (int*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor intArray (int*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (int*,Array_Descriptor_Type*)");
#endif
   }

intArray::intArray
   ( const int* Array_Data_Pointer , 
     const doubleArray_Descriptor_Type* 
     Array_Descriptor_Pointer ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#else
   : Array_Descriptor(Array_Data_Pointer,Array_Descriptor_Pointer)
#endif
   {
#if COMPILE_DEBUG_STATEMENTS
     if (APP_DEBUG > 0)
          printf ("Using the constructor 'intArray (int*,Array_Descriptor_Type*)'! \n");
#endif
     Array_Descriptor = *Array_Descriptor_Pointer;
     Array_Descriptor.Array_Data       = (int*) Array_Data_Pointer;
     POINTER_LIST_INITIALIZATION_MACRO;
     if (Array_Data_Pointer != NULL)
        {
          display("Using the constructor intArray (int*,Array_Descriptor_Type*)");
#if defined(USE_EXPRESSION_TEMPLATES)
          APP_ASSERT (Array_Descriptor.ExpressionTemplateDataPointer != NULL);
#endif
        }

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency("Constructor intArray::intArray (int*,Array_Descriptor_Type*)");
#endif
   }
  // end of if 0
#endif
  // end of !PPP
#endif



// *********************************************************
// *********************************************************
// ******************  MEMBER FUNCTIONS  *******************
// *********************************************************
// *********************************************************

intArray &
intArray::seqAdd ( int Base , int Stride )
   {
// ***************************************************************
// This function allows the initialization of an array with 
// incremeted values.
// ***************************************************************

#if defined(USE_TAU)
     TAU_PROFILE("intArray::seqAdd()", "void(int,int)", TAU_APP_USER_FUNCTIONS);
#endif
  // This function intializes the data to be sequentially valued starting
  // at the Base value and continuing with Stride to the end of the array.
  // It does not touch the array data directly since this is the job of the 
  // MDI functions (or the operator() which take scalars).  This function uses the
  // operator() member function to initialize the actual data since in the CM-5 
  // implementation the data is not directly addressable at the C++ level!

  // because this function is implemented using scalar indexing it is very slow
  // especially in the P++ parallel environment.

#if COMPILE_DEBUG_STATEMENTS
     Test_Consistency ("Called from intArray::seqAdd(Base,Stride)");
#endif

#if !defined(CRAY)
     int Counter = Base;

  // The use of multiple function call here is not very important 
  // since this is not often a time critical function and would be inlined!
#if 0
     APP_ASSERT (MAX_ARRAY_DIMENSION == 4);

     printf ("We really should use the dimension independent case!  Exiting ... \n");
     APP_ABORT();

     int Base_I = getBase(0);
     int Base_J = getBase(1);
     int Base_K = getBase(2);
     int Base_L = getBase(3);

     int Bound_I = getBound(0);
     int Bound_J = getBound(1);
     int Bound_K = getBound(2);
     int Bound_L = getBound(3);

     for (int l=Base_L; l <= Bound_L; l++)
        {
          for (int k=Base_K; k <= Bound_K; k++)
             {
               for (int j=Base_J; j <= Bound_J; j++)
                  {
                    for (int i=Base_I; i <= Bound_I; i++)
                       {
                         (*this)(i,j,k,l) = Counter;
                         Counter += Stride;
                       }
                  }
             }
        }
#else
     APP_ASSERT (MAX_ARRAY_DIMENSION <= 8);
  // Dimension independent code!
     int Array_Base[MAX_ARRAY_DIMENSION];
     int Array_Bound[MAX_ARRAY_DIMENSION];
     int temp;
     for (temp=0; temp < MAX_ARRAY_DIMENSION; temp++)
        {
          Array_Base [temp] = getBase (temp);
          Array_Bound[temp] = getBound(temp);
        }

#if defined(PPP)
  // Get a view of the whole serial array including ghost boundaries so 
  // that they can be initialized properly without any communication.
     const intSerialArray & localArray = getLocalArrayWithGhostBoundaries();

  // these are used to simplify code
     int localArrayBase0  = Array_Descriptor.Array_Domain.getLocalMaskIndex(0).getBase();
     int localArrayBound0 = Array_Descriptor.Array_Domain.getLocalMaskIndex(0).getBound();
#if MAX_ARRAY_DIMENSION > 1
     int localArrayBase1  = Array_Descriptor.Array_Domain.getLocalMaskIndex(1).getBase();
     int localArrayBound1 = Array_Descriptor.Array_Domain.getLocalMaskIndex(1).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 2
     int localArrayBase2  = Array_Descriptor.Array_Domain.getLocalMaskIndex(2).getBase();
     int localArrayBound2 = Array_Descriptor.Array_Domain.getLocalMaskIndex(2).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 3
     int localArrayBase3  = Array_Descriptor.Array_Domain.getLocalMaskIndex(3).getBase();
     int localArrayBound3 = Array_Descriptor.Array_Domain.getLocalMaskIndex(3).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 4
     int localArrayBase4  = Array_Descriptor.Array_Domain.getLocalMaskIndex(4).getBase();
     int localArrayBound4 = Array_Descriptor.Array_Domain.getLocalMaskIndex(4).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 5
     int localArrayBase5  = Array_Descriptor.Array_Domain.getLocalMaskIndex(5).getBase();
     int localArrayBound5 = Array_Descriptor.Array_Domain.getLocalMaskIndex(5).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 6
     int localArrayBase6  = Array_Descriptor.Array_Domain.getLocalMaskIndex(6).getBase();
     int localArrayBound6 = Array_Descriptor.Array_Domain.getLocalMaskIndex(6).getBound();
#endif
#if MAX_ARRAY_DIMENSION > 7
     int localArrayBase7  = Array_Descriptor.Array_Domain.getLocalMaskIndex(7).getBase();
     int localArrayBound7 = Array_Descriptor.Array_Domain.getLocalMaskIndex(7).getBound();
#endif
#endif

  // Avoid compiler warnings by only declaring the ones that we use (1-MAX_ARRAY_DIMENSION)
     int i;
#if MAX_ARRAY_DIMENSION > 1
     int j;
#endif
#if MAX_ARRAY_DIMENSION > 2
     int k;
#endif
#if MAX_ARRAY_DIMENSION > 3
     int l;
#endif
#if MAX_ARRAY_DIMENSION > 4
     int m;
#endif
#if MAX_ARRAY_DIMENSION > 5
     int n;
#endif
#if MAX_ARRAY_DIMENSION > 6
     int o; 
#endif
#if MAX_ARRAY_DIMENSION > 7
     int p;
#endif

  // With more work we could make this more thoughly dimension independent
  // by using the same techniques as in the MDI code!
  // int i; int j; int k; int l; int m; int n; int o; int p;
     switch (numberOfDimensions())
        {
          case 0 : // Do nothing (nothing to do)!
               break;
          case 1 :
#if defined(PPP)
               for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                  {
                    if ((i >= localArrayBase0) && (i <= localArrayBound0))
                         localArray(i) = Counter;
                    Counter += Stride;
                  }
#else
               for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                  {
                    (*this)(i) = Counter;
                    Counter += Stride;
                  }
#endif
               break;
#if MAX_ARRAY_DIMENSION > 1
          case 2 :
#if defined(PPP)
               for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                    for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                       {
                         if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                             (j >= localArrayBase1) && (j <= localArrayBound1))
                              localArray(i,j) = Counter;
                         Counter += Stride;
                       }
#else
               for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                    for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                       {
                         (*this)(i,j) = Counter;
                         Counter += Stride;
                       }
#endif
               break;
#endif
#if MAX_ARRAY_DIMENSION > 2
          case 3 :
#if defined(PPP)
               for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                    for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                         for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                            {
                              if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                  (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                  (k >= localArrayBase2) && (k <= localArrayBound2))
                                   localArray(i,j,k) = Counter;
                              Counter += Stride;
                            }
#else
               for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                    for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                        for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                           {
                             (*this)(i,j,k) = Counter;
                             Counter += Stride;
                           }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 3
          case 4 :
#if defined(PPP)
               for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                    for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                         for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                              for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                 {
                                   if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                       (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                       (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                       (l >= localArrayBase3) && (l <= localArrayBound3))
                                        localArray(i,j,k,l) = Counter;
                                   Counter += Stride;
                                 }
#else
               for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                   for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                        for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                             for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                {
                                  (*this)(i,j,k,l) = Counter;
                                  Counter += Stride;
                                }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 4
          case 5 :
#if defined(PPP)
               for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                    for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                         for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                              for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                   for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                      {
                                        if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                            (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                            (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                            (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                            (m >= localArrayBase4) && (m <= localArrayBound4))
                                             localArray(i,j,k,l,m) = Counter;
                                        Counter += Stride;
                                      }
#else
               for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                   for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                        for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                             for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                  for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                     {
                                       (*this)(i,j,k,l,m) = Counter;
                                       Counter += Stride;
                                     }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 5
          case 6 :
#if defined(PPP)
               for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                    for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                         for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                              for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                   for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                        for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                           {
                                             if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                 (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                 (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                 (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                 (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                 (n >= localArrayBase5) && (n <= localArrayBound5))
                                                  localArray(i,j,k,l,m,n) = Counter;
                                             Counter += Stride;
                                           }
#else
               for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                   for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                        for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                             for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                  for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                       for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                          {
                                            (*this)(i,j,k,l,m,n) = Counter;
                                            Counter += Stride;
                                          }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 6
          case 7 :
#if defined(PPP)
               for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                    for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                         for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                              for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                   for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                        for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                             for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                {
                                                  if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                      (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                      (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                      (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                      (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                      (n >= localArrayBase5) && (n <= localArrayBound5) &&
                                                      (o >= localArrayBase6) && (o <= localArrayBound6))
                                                       localArray(i,j,k,l,m,n,o) = Counter;
                                                  Counter += Stride;
                                                }
#else
               for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                   for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                        for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                             for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                  for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                       for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                            for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                               {
                                                 (*this)(i,j,k,l,m,n,o) = Counter;
                                                 Counter += Stride;
                                               }
#endif
                   break;
#endif
#if MAX_ARRAY_DIMENSION > 7
          case 8 :
#if defined(PPP)
               for (p=Array_Base[7]; p <= Array_Bound[7]; p++)
                    for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                         for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                              for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                                   for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                        for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                             for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                                  for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                     {
                                                       if ((i >= localArrayBase0) && (i <= localArrayBound0) &&
                                                           (j >= localArrayBase1) && (j <= localArrayBound1) &&
                                                           (k >= localArrayBase2) && (k <= localArrayBound2) &&
                                                           (l >= localArrayBase3) && (l <= localArrayBound3) &&
                                                           (m >= localArrayBase4) && (m <= localArrayBound4) &&
                                                           (n >= localArrayBase5) && (n <= localArrayBound5) &&
                                                           (o >= localArrayBase6) && (o <= localArrayBound6) &&
                                                           (p >= localArrayBase7) && (p <= localArrayBound7))
                                                            localArray(i,j,k,l,m,n,o,p) = Counter;
                                                       Counter += Stride;
                                                     }
#else
               for (p=Array_Base[7]; p <= Array_Bound[7]; p++)
                   for (o=Array_Base[6]; o <= Array_Bound[6]; o++)
                        for (n=Array_Base[5]; n <= Array_Bound[5]; n++)
                             for (m=Array_Base[4]; m <= Array_Bound[4]; m++)
                                  for (l=Array_Base[3]; l <= Array_Bound[3]; l++)
                                       for (k=Array_Base[2]; k <= Array_Bound[2]; k++)
                                            for (j=Array_Base[1]; j <= Array_Bound[1]; j++)
                                                 for (i=Array_Base[0]; i <= Array_Bound[0]; i++)
                                                    {
                                                      (*this)(i,j,k,l,m,n,o,p) = Counter;
                                                      Counter += Stride;
                                                    }
#endif
                   break;
#endif
          default: printf ("ERROR: Default reached in switch statement in intArray::seqAdd \n");
                   APP_ABORT();
        }
#endif
#else
     printf ("ERROR: FUNCTION DISABLED ON CRAY Y-MP -- intArray::seqAdd function generates internal compiler error \n");
     printf ("       NO WORK AROUND HAS BEEN FOUND! \n");
     APP_ABORT();
#endif

     return *this;
   }

#if defined(INTARRAY)
#if 0
// *****************************************************************************************
// Function not supported since it allows to two paths to build an intArray: intArray(1) 
// and intArray(Index(1)) which is ambiguous to the C++ compiler if required for autopromotion!
// It might be allowed now that there are special operator() for each possilbe case of mixing scalar
// with intArray in the indirect addressing of A++ array object!
// *****************************************************************************************
intArray::intArray ( const Internal_Index & X ) 
#if defined(USE_EXPRESSION_TEMPLATES)
   : InArray<int>(this)
#endif
   {
  // Convert an Index to an intArray to support mixed intArray and Index object indexing!
  // Later this function will access the chache of readonly intArray objects 
  // for use with indexing!

#if EXTRA_ERROR_CHECKING
     if (X.getMode() == All_Index)
        {
          printf ("ERROR: Can't convert Index object with mode All_Index to intArray! \n");
          X.display();
          printf ("ERROR in intArray::intArray ( const Index & X ) (see explanation above!) \n");
          APP_ABORT();
        }
#endif

  // Build a descriptor for a 1D array! Null_Index generates a Null intArray
     if (X.getMode() == Null_Index)
          //Array_Descriptor = new Array_Descriptor_Type ();
          Array_Descriptor = 
	     new intArray_Descriptor_Type();
       else
          Array_Descriptor = 
	     new intArray_Descriptor_Type
	        (X.length(),1,1,1);
          //Array_Descriptor = new Array_Descriptor_Type (X.length(),1,1,1);

  // APP_ASSERT( Array_Descriptor != NULL );

  // Allocate array memory!
     Allocate_Array_Data (TRUE);
     Array_Storage  = NULL;
     referenceCount = getReferenceCountBase();

     if (X.getMode() == Index_Triplet)
          seqAdd (X.getBase(),X.getStride());
   }
#endif

// *****************************************************************************************
// This function initializes the elements of the result array with the  i n d e x  positions
// of the nonzero entries of the Lhs array.  It is used to build an  i n d e x  map into
// an array.  Typically it is used on the intArray result from a relational operator!
// For example: intArray indexMap = (A == 5).Build_indexMap();  
// indexMap is an array (of length cooresponding to the number of elements of A with 
// value 5) with values equal to the  i n d e x  position in A where the values was 5.
// Thus function only makes sense in 1D - so we only handle that case!
// later we will make it ret