
// tps (01/14/2010) : Switching from rose.h to sage3.
#include "sage3basic.h"
#include "attachPreprocessingInfo.h"

// DQ (10/14/2010):  This should only be included by source files that require it.
// This fixed a reported bug which caused conflicts with autoconf macros (e.g. PACKAGE_BUGREPORT).
#include "rose_config.h"

// DQ (12/31/2005): This is OK if not declared in a header file
using namespace std;

// #ifndef USE_ROSE
// Local typedefs used in this file only...
typedef boost::wave::cpplexer::lex_token<>  token_type;
typedef std::vector<token_type>             token_container;
typedef std::list<token_type>               token_list_container;
typedef std::vector<std::list<token_type> > token_container_container;
// #endif

// DQ (11/28/2009): I think this is equivalent to "USE_ROSE"
// DQ (11/28/2008): What does this evaluate to???  Does this mix C++ constants with CPP values (does this make sense? Is "true" defined?)
// #if CAN_NOT_COMPILE_WITH_ROSE != true
// #if !CAN_NOT_COMPILE_WITH_ROSE
#ifndef USE_ROSE
#endif

///////////////////////////////////////////////////////////////////////////////
//  Include Wave itself
#include <boost/wave.hpp>
///////////////////////////////////////////////////////////////////////////////
// Include the lexer stuff
#include <boost/wave/cpplexer/cpp_lex_token.hpp>    // token class
#include <boost/wave/cpplexer/cpp_lex_iterator.hpp> // lexer class

#include "advanced_preprocessing_hooks.h"
#include "attributeListMap.h"

#include <boost/filesystem.hpp>		// exsits()

//Include files to get the current path
#include <unistd.h>

#ifndef _MSC_VER
#include <sys/param.h>
#endif

// #include <iostream>
// #include <fstream>
// #include <string>


#if 0
// DQ (11/30/2008): This does not appear to be used!

std::list<SgNode*>
findNodes(SgNode* astNode)
   {
     std::list<SgNode*> returnList;

     if(isSgFile(astNode)!=NULL)
          returnList.push_back(astNode);

     return returnList;
   }
#endif

#if 0
// DQ (12/16/2008): comment out while I debug the non-wave support.

// AS (011306) Support for Wave preprocessor
void
attachPreprocessingInfo(SgSourceFile *sageFilePtr, std::map<std::string,ROSEAttributesList*>* attrMap)
   {
  // DQ (7/6/2005): Introduce tracking of performance of ROSE.
     TimingPerformance timer ("AST Comment Processing (using Wave, inner part):");

  // Dummy attribute
     AttachPreprocessingInfoTreeTraversalInheritedAttrribute inh;
  // AttachPreprocessingInfoTreeTraversalInheritedAttrribute inh(NULL);

  // Make sure that the argument is not a NULL pointer
     ROSE_ASSERT(sageFilePtr);

  // DQ (12/16/2008): comment out while I debug the non-wave support.
#if 0
  // Create tree traversal object for attaching the preprocessing information (using Wave)
     AttachPreprocessingInfoTreeTrav tt(attrMap);

  // Run tree traversal on specified source file
     tt.traverseWithinFile(sageFilePtr,inh);
#else
     printf ("Wave support not implemented in new support for CPP directives and comment handling. \n");
     ROSE_ASSERT(false);
#endif
   }
#endif


void
attachPreprocessingInfoUsingWave (SgSourceFile *sageFilePtr, AttributeMapType& attributeMapForAllFiles)
   {
#ifndef  CXX_IS_ROSE_CODE_GENERATION

// CH (4/7/2010): Wave issue fixed.
//#ifndef _MSCx_VER
//#pragma message ("WARNING: Wave support not ported to Windows MSVC.")
//	   printf ("ERROR: Wave support not ported to Windows MSVC. \n");
//	   ROSE_ASSERT(false);
//#else
     ROSE_ASSERT(sageFilePtr != NULL);
     std::string sourceFileName = sageFilePtr->getFileName();

     //SageInterface::buildFile(..) generates files in memory where the source file has not yet 
     //been written to disk. We consider any case where the file does not exist on disk to be this
     //case.
     if( ! boost::filesystem::exists(sourceFileName) ) 
       return;

  // DQ (11/30/2008): 
  //    1) Where are the tokens generated by Wave?
  //    2) Where are the PreprocessorInfo objects generated?
  //    3) Why is the commandline processed (redundantly with information already in SgSourceFile)?

     std::cerr << "Using WAVE" << std::endl;

  // DQ (7/6/2005): Introduce tracking of performance of ROSE.
     TimingPerformance timer ("AST Comment and CPP Directive Processing (using Wave, outer part):");

  // Build the AST used by ROSE
  // SgProject* project = frontend(argc,argv);
     std::vector<std::string>  includeSpecifierlist;

  // Build the list that we will hand off to boost-wave
  // std::vector<std::string> includeSpecifierlist;
     std::vector<std::string> macroList;
     std::vector<std::string> preincludeList;

#if 0
// .mine
     string predefinedMacros          = CXX_SPEC_DEF;
    
     if (SgProject::get_verbose() >= 1)
         std::cout << "XXXXXXXXXXXX: " << CXX_SPEC_DEF << std::endl;

  // DQ (11/30/2008): This information is already available in the SgSourceFile 
  // or SgProject IR nodes so it is not required to reparse the commandline here.

     vector<string> predefinedMacroList = CommandlineProcessing::generateArgListFromString(predefinedMacros);
#else
  // DQ (12/22/2008): I expect that this is the better version...
     const char* predefinedMacroListRaw[] = CXX_SPEC_DEF;
     vector<string> predefinedMacroList(predefinedMacroListRaw, predefinedMacroListRaw + sizeof(predefinedMacroListRaw) / sizeof(*predefinedMacroListRaw));
#endif
  // for (vector<string>::iterator i = predefinedMacroList.begin(); i != predefinedMacroList.end(); i++)
     vector<string>::iterator i = predefinedMacroList.begin();
     while (i != predefinedMacroList.end())
        {
       // AS(03/12/08) CXX_SPEC_DEF has been changed to only contain macro defs
          if (i->substr(0,2) == "-D")
             {
               string macro = i->substr(2);
	       
               if (SgProject::get_verbose() >= 1)
                    printf ("Adding predefined macro to the macroList macro = %s \n",macro.c_str());

               macroList.push_back(macro);
             }
            else
             {
               string preincludeMarker = "--preinclude";
               if (i->substr(0,preincludeMarker.size()) == preincludeMarker)
                  {
                    i++;
                 // The following option is the file name associated with the "--preinclude" option
                    preincludeList.push_back(*i);

                    if(SgProject::get_verbose() >= 1)
                         std::cout << "Predefined macro: " << *i << std::endl;
                  }
                 else
                  {
                    if(i->empty())
                       {
                       }
                      else
                       {
                         printf ("Found a non -D macro definition  (and non preinclude file) in the predefined macro list substring = %s *i = %s \n",i->substr(0,2).c_str(),i->c_str());
                       }
                  }
             }

          i++;
        }


  // Now add the entries specified on the commandline
     if (SgProject::get_verbose() >= 1)
          std::cout << "INCLUDES FROM COMMANDLINE" << std::endl;

     std::vector<std::string> commandLine = sageFilePtr->get_originalCommandLineArgumentList();
     for (vector<string>::iterator i = commandLine.begin(); i != commandLine.end(); i++)
        {
          ROSE_ASSERT((*i)[0] != ' ');
       // printf ("Command line argument: *i = %s \n",i->c_str());
          if (i->substr(0,2) == "-I")
             {
               includeSpecifierlist.push_back(*i);
	       if(SgProject::get_verbose() >= 1)
                    std::cout << *i << std::endl;
             }
          if (i->substr(0,2) == "-D")
             {
               string macro = i->substr(2);
	                                   
	       if(SgProject::get_verbose() >= 1)
                   printf ("Adding macro to the macroList macro = %s \n",macro.c_str());
               macroList.push_back(macro);
             }
        }

     if(SgProject::get_verbose() >= 1)
          std::cout << "DONE INCLUDES FROM COMMANDLINE" << std::endl;

     std::vector<SgNode*> accessFunctionsList;

  // DQ (11/30/2008): Why are we getting all the SgFloatValExp and SgDoubleValExp IR nodes?

  // Build list of value expressions 
     std::vector<SgNode*> valueExp = NodeQuery::querySubTree (sageFilePtr,&queryFloatDoubleValExp);

  // Open and read in the specified input file.

     if (SgProject::get_verbose() >= 1)
        {
          std::cout << "Source file name: \"" << sourceFileName << "\"" << std::endl;
          std::cout << "Source file name: \"" << sageFilePtr->getFileName()<< "\"" <<  std::endl;
        }

  // Here we open the input file for processing using WAVE.
  // sourceFileName = string(CurrentPath)+"/"+sourceFileName;
     std::ifstream instream(sourceFileName.c_str());
     std::string instring;

     if (!instream.is_open())
        {
          std::cerr << "Could not open input file: " << sourceFileName << std::endl;
          ROSE_ASSERT(false);
        }

  // DQ (11/30/2008): What does this do? Please document why this is required.
     instream.unsetf(std::ios::skipws);
     instring = std::string(std::istreambuf_iterator<char>(instream.rdbuf()),std::istreambuf_iterator<char>());

  // DQ (11/30/2008): Is there no namespace for the Wave types?
  // Also which of these three statements builds the token list?

  // The template boost::wave::cpplexer::lex_token<> is the token type to be used by the Wave library.
     ::token_type x;

  // The template boost::wave::cpplexer::lex_iterator<> is the lexer type to
  // be used by the Wave library.
     typedef boost::wave::cpplexer::lex_iterator< ::token_type> lex_iterator_type;

  // This is the resulting context type to use. The first template parameter
  // should match the iterator type to be used during construction of the
  // corresponding context object (see below).
     typedef boost::wave::context<std::string::iterator,lex_iterator_type, boost::wave::iteration_context_policies::load_file_to_string, advanced_preprocessing_hooks > context_type;

  // The preprocessor iterator shouldn't be constructed directly. It is 
  // to be generated through a wave::context<> object. This wave:context<> 
  // object is to be used additionally to initialize and define different 
  // parameters of the actual preprocessing (not done here).
  //
  // The preprocessing of the input stream is done on the fly behind the 
  // scenes during iteration over the context_type::iterator_type stream.
    
     ROSE_ASSERT(sourceFileName.size() > 0);

     //Files, like for instance those generated by SageInterface::buildFile(..),
     //can be empty. In those cases ship wave
     if(instring.begin() == instring.end())
       return;
       

  // DQ (11/30/2008): What does this do?
     context_type ctx (instring.begin(), instring.end(), sourceFileName.c_str());

  // std::cout << "Current file name: " << get_current_filename()

  // DQ (11/30/2008): Andreas just mentioned that the AttributeListMap is not required and could be eliminated.

  // This get_hooks() member function was added by the Author of boost-wave to handle 
  // a problem pointed out by Andreas.
     AttributeListMap attributeListMap(sageFilePtr);
     ctx.get_hooks().attributeListMap = &attributeListMap;

  // printf ("specify the languge \n");

  // Preserve comments through preprocessing so that the output token-stream
  // contains the comments.
     if (SgProject::get_verbose() >= 1)
          std::cout << "BEFORE ADDING PREDEFINES" << std::endl;

     if( sageFilePtr->get_C_only() == true){
       // Tentaive support for C. For now treat it like C99 since Wave does not
       // have an option for just C.
          ctx.set_language(boost::wave::support_c99);
     }else if( sageFilePtr->get_C99_only() == true ){
          ctx.set_language(boost::wave::support_c99);
     }else{
          ctx.set_language(boost::wave::support_cpp);
     }

     ctx.set_language(boost::wave::enable_long_long(ctx.get_language()));
//     ctx.set_language(boost::wave::enable_preserve_comments(ctx.get_language()));
     ctx.set_language(boost::wave::enable_variadics(ctx.get_language()));
  // Force a specific file to be included before all others

    if( sageFilePtr->get_C_only() == true){
       // Tentaive support for C. For now treat it like C99 since Wave does not
       // have an option for just C.
          ctx.add_macro_definition(std::string("ROSE_LANGUAGE_MODE=0"),true);
     }else if( sageFilePtr->get_C99_only() == true ){
          ctx.add_macro_definition(std::string("ROSE_LANGUAGE_MODE=0"),true);
     }else{
          ctx.add_macro_definition(std::string("ROSE_LANGUAGE_MODE=1"),true);
     }

     if (SgProject::get_verbose() >= 1)
          std::cout << "MIDDLE OF ADDING PREDEFINES" << std::endl;

     for (std::vector<std::string>::iterator it_beg = macroList.begin(); it_beg != macroList.end(); ++it_beg)
        {
          if (SgProject::get_verbose() >= 1)			  
              	std::cout << "Predef macro:\"" << *it_beg << "\""<<std::endl;
          if ((*it_beg)!="")
               ctx.add_macro_definition(*it_beg,true);
        }
          
     if (SgProject::get_verbose() >= 1)
          std::cout << "AFTER ADDING PREDEFINES" << std::endl;

  // Add include paths specified on commandline to the context object 
     std::vector<string>::const_iterator firstInclude = includeSpecifierlist.begin();
     std::vector<std::string>::const_iterator lastInclude = includeSpecifierlist.end();

     if (SgProject::get_verbose() >= 1)
          printf ("Adding the /usr/include/ file \n");

  // DQ (4/7/2006): Not sure we want to do this, if we did want to do so then it should 
  // be in the list of EDG as well and in which case, what order should it be placed?

     string internalIncludePaths[]          = CXX_INCLUDE_STRING;
  // if(SgProject::get_verbose() >= 1)
  //      std::cout << "INTERNAL INCLUDE PATHS " << CXX_INCLUDE_STRING << std::endl;

     vector<string> internalIncludePathList(internalIncludePaths, internalIncludePaths + sizeof(internalIncludePaths)/sizeof(string));
  // internalIncludePathList.push_back("-I"+string(CurrentPath)+"/");

     string includeBase = findRoseSupportPathFromBuild("include-staging", "include");
     for (vector<string>::iterator i = internalIncludePathList.begin(); i != internalIncludePathList.end(); i++)
        {
          ROSE_ASSERT (!i->empty());
          string fullPath = (*i)[0] == '/' ? *i : (includeBase + "/" + *i);
           
          ctx.add_sysinclude_path(fullPath.c_str()); 
        }

     std::string sys_include = "/usr/include/";
     ctx.add_sysinclude_path(sys_include.c_str());

     if (SgProject::get_verbose() >= 1)
          printf ("DONE: Adding the /usr/include/ file \n");

     while(firstInclude != lastInclude)
        {
          string includeDir=(*firstInclude).substr(2,(*firstInclude).length());
          ctx.add_sysinclude_path((*firstInclude).substr(2,(*firstInclude).length()).c_str()); 
          ctx.add_include_path((*firstInclude).c_str());
          ++firstInclude;
        }

  // DQ (11/30/2008): What bug does this refer to in ROSE? 
  // variable needed by the program to account for the bug in the column 
  // position of value expressions within ROSE.
     context_type::token_type lastOperatorToken(boost::wave::T_RIGHTPAREN,")",boost::wave::util::file_position_type("",0,0));

  // Attaching an attribute list to the current hooks object so that 
  // preprocessing infos can be extracted
     map<std::string,ROSEAttributesList*> currentMapOfAttributes;

  // std::string x,y;
  // current file position is saved for exception handling
     boost::wave::util::file_position_type current_position;

  // DQ (11/30/2008): Andreas says this AST Query is part of the alternative approach to extract 
  // the strings used for floating point values (this work later was implemented in EDG directly).
  // So this feature of the Wave preprocessing is not used currently, but it appears to be 
  // exectuted (it should be commented out).
     accessFunctionsList = NodeQuery::querySubTree (sageFilePtr,&queryFloatDoubleValExp);

     std::cerr << "For some reason we have " << std::endl;

  // Locate all value expression with Wave and set the string value of the
  // corresponding value expressions within the ROSE AST to the string value found
  // by Wave.
     context_type::iterator_type first = ctx.begin();
     context_type::iterator_type last  = ctx.end();

  // analyze the input file, print out the preprocessed hooks
     if (SgProject::get_verbose() >= 1)
          printf ("Adding the preinclude file \n");

     ROSE_ASSERT(preincludeList.size() == 1);
     for (vector<string>::reverse_iterator i = preincludeList.rbegin(); i != preincludeList.rend(); ++i)
        {
          vector<string>::reverse_iterator copyOf_i = i;
          copyOf_i++;

          if (SgProject::get_verbose() >= 1)
               printf ("Adding preinclude file = %s \n",i->c_str());

// DQ (8/29/2009): It appears that this test fails to compile using ROSE (some template name contains "____L" as a substring).
#ifndef USE_ROSE
       // DQ (4/7/2006): This currently fails
          first.force_include( i->c_str(), copyOf_i == preincludeList.rend() );
       // first.force_include( i->c_str(), false);
#endif

          if (SgProject::get_verbose() >= 1)
               printf ("DONE: Adding preinclude file = %s \n",i->c_str());
        }
                                 
     if (SgProject::get_verbose() >= 1)
          printf ("DONE: Adding the preinclude file \n");

		// Start Lexing
     try{ 
// DQ (8/29/2009): It appears that this test fails to compile using ROSE (some template name contains "____L" as a substring).
#ifndef USE_ROSE
          while (first != last)
#else
          while (true)
#endif
             {
               using namespace boost::wave;

               try{
// DQ (8/29/2009): It appears that this test fails to compile using ROSE (some template name contains "____L" as a substring).
// Each reference to "first" appears to generate an error. It appears that this test fails to compile using ROSE.
#ifndef USE_ROSE
                    current_position = (*first).get_position();

                    if (first->get_position().get_file()!="<built-in>")
                       {
                      // std::cout << first->get_position().get_file() << " l" << first->get_position().get_line()
                      //           << " " << (*first).get_value() << std::endl;
                       }

                    token_id id = token_id(*first);

                 // Attach comments found by Wave to the AST
                    if ((T_CCOMMENT == id) | (T_CPPCOMMENT == id))
                       {
                         attributeListMap.found_directive(*first);
                       }

                    wave_tokenStream.push_back(*first);
                    first++;
#endif
	               }

	            catch (boost::wave::cpp_exception &e)
                  {
                 // some preprocessing error
                 // This is a problem for using compass with emacs (see testEmacs.C).
                 // cerr  << "WAVE 1: " << e.file_name() << "(" << e.line_no() << "): "
                 //       << e.description() << endl;
	               }

               catch (boost::wave::cpplexer::lexing_exception &e)
                  {
                 // some lexing error
                    cerr << "WAVE 2:" << e.file_name() << "(" << e.line_no() << "): "
                         << e.description() << endl;
                  }
             }
        }

     catch (boost::wave::cpp_exception &e)
        {
       // some preprocessing error
          cerr << "WAVE 3 (boost::wave::cpp_exception): " << e.file_name() << "(" << e.line_no() << "): "
               << e.description() << endl;
        }

     catch (boost::wave::cpplexer::lexing_exception &e)
        {
       // some lexing error
          cerr << "WAVE 4 (boost::wave::cpplexer::lexing_exception):" << e.file_name() << "(" << e.line_no() << "): "
               << e.description() << endl;
        }
     catch (std::exception &e)
        {
       // use last recognized token to retrieve the error position
          cerr << "WAVE 5 (std::exception):" << current_position.get_file() 
               << "(" << current_position.get_line() << "): "
               << "exception caught: " << e.what()
               << endl;
        }
     catch (...)
        {
       // use last recognized token to retrieve the error position
          cerr << "WAVE 6 (all other exceptions):" << current_position.get_file() 
               << "(" << current_position.get_line() << "): "
               << "unexpected exception caught." << endl;
        }
		// End Lexing

     attributeListMap.attach_line_to_macro_call();

#if 1
	// King84 (2010.09.23): We capture the raw token stream because the tokens that aren't pre-processed tokens don't show up in the individual file's list of tokens.  Also, #line directives get obeyed and mapped into different files.  If we want to reproduce the original file failthfully, we have to use the raw list.  I leave the rest here for future reference, since it took some figuring out to get right.
     if (SgProject::get_verbose() >= 1)
	     std::cout << "File " << sourceFileName << " has " << ctx.get_hooks().tokens.size() << " tokens." << std::endl;
	 for (std::list< token_type >::iterator i = ctx.get_hooks().tokens.begin(); i != ctx.get_hooks().tokens.end(); ++i)
	 {
		sageFilePtr->get_rawTokenStream().push_back(*i);
	 }
#else
//     sageFilePtr->get_rawTokenStream().clear();
     assert(attributeListMap.currentMapOfAttributes.find(sourceFileName) != attributeListMap.currentMapOfAttributes.end());
	 for (std::vector<PreprocessingInfo*>::iterator i = attributeListMap.currentMapOfAttributes[sourceFileName]->getList().begin(); i != attributeListMap.currentMapOfAttributes[sourceFileName]->getList().end(); ++i)
	 {
		// King84 (2010.09.23): We aren't doing tokens, so we cheat by stringizing everything.  I guess we could get the tokens out of here, but I'm lazy, since we aren't doing this for real anyway
        {
            token_type holder = token_type(boost::wave::T_CPPCOMMENT, (**i).getString().c_str(), boost::wave::util::file_position_type(BOOST_WAVE_STRINGTYPE(), 0, 0));
			sageFilePtr->get_rawTokenStream().push_back( holder );
        }
	 }
#endif

#if 0
  // Get all SgFile nodes in the AST so that the attributes can be attached to them
  // std::vector<SgNode*> sgFileList =     NodeQuery::querySubTree(project,&findNodes);
     std::vector<SgNode*> sgFileList =     NodeQuery::querySubTree(sageFilePtr,&findNodes);

  // Attache the map of attributes belonging to the current file to the AST
     for(std::vector<SgNode*>::iterator it = sgFileList.begin(); it != sgFileList.end(); ++it)
        {
          SgFile* sgFile = isSgFile(*it);
          attachPreprocessingInfo(sgFile,&attributeListMap.currentMapOfAttributes);
        }
#else
   // AS(01/04/07) Create a global map of filenames to PreprocessingInfo*'s as it is inefficient
   // to get this by a traversal of the AST
     for(AttributeListMap::attribute_map_type::iterator it_files = attributeListMap.currentMapOfAttributes.begin(); it_files != attributeListMap.currentMapOfAttributes.end(); ++it_files)
        {
          std::string filename2 = it_files->first;

          /*
          Sg_File_Info* sourceFileInfo = sageFilePtr->get_file_info();
          int sourceFileNameId = (sageFilePtr->get_requires_C_preprocessor() == true) ? Sg_File_Info::getIDFromFilename(filename2) : sourceFileInfo->get_file_id();
          int sourceFileNameId = (sageFilePtr->get_requires_C_preprocessor() == true) ? 
            Sg_File_Info::getIDFromFilename(sageFilePtr->generate_C_preprocessor_intermediate_filename(filename2)) : 
            sourceFileInfo->get_file_id();
            */


          ROSEAttributesList*  attrList = it_files->second;
          mapFilenameToAttributes[filename2] = attrList;

		  // TODO:
		  // King84 (2010.09.22) Add preprocessing info vector to file object, so we can access it later for unparsing

          if (SgProject::get_verbose() >= 1)
            std::cout << "source file name:" << sageFilePtr->generate_C_preprocessor_intermediate_filename(filename2) << std::endl;
//          std::vector<PreprocessingInfo*>* preproc_info = new std::vector<PreprocessingInfo*>();
    //      attributeMapForAllFiles[sourceFileNameId] = attrList;

#if 1
          for (std::vector<PreprocessingInfo*>::iterator it_preproc = attrList->getList().begin(); it_preproc != attrList->getList().end(); ++it_preproc)
             {
               //preproc_info->push_back(*it_preproc);
//               returnListOfAttributes->addElement(**it_preproc);
               ROSE_ASSERT(*it_preproc != NULL);
               if( SgProject::get_verbose() >= 1 )
                 std::cerr << "Added Macro " << (*it_preproc)->getString() << std::endl;
             }
#endif

          if (SgProject::get_verbose() >= 1)
             {
               std::cout << "Size of vector: " << attrList->size() << std::endl;
               std::cout << "Iterating over filename:" << filename2 << std::endl;
             }
        }

     if (SgProject::get_verbose() >= 1)
          std::cout << "Size of mapFilenameToAttributes:" << mapFilenameToAttributes.size() << std::endl;

#endif

// endif for ifdef _MSCx_VER
//#endif

// endif for ifndef  CXX_IS_ROSE_CODE_GENERATION
#endif

#if 0
     printf ("Ending at base of attachPreprocessingInfoUsingWave(SgSourceFile*) \n");
     ROSE_ABORT();
#endif
   }


// DQ (4/5/2006): Older version not using Wave preprocessor
// This is the function to be called from the main function
// DQ: Now called by the SgFile constructor body (I think)
void
attachPreprocessingInfo(SgSourceFile *sageFilePtr)
   {
     ROSE_ASSERT(sageFilePtr != NULL);

#if 0
     printf ("Inside of attachPreprocessingInfo(): wave = %s file = %p = %s \n",
          sageFilePtr->get_wave() ? "true" : "false",sageFilePtr,sageFilePtr->get_sourceFileNameWithPath().c_str());
#endif

#ifndef  CXX_IS_ROSE_CODE_GENERATION
  // DQ (7/6/2005): Introduce tracking of performance of ROSE.
     TimingPerformance timer ("AST Comment and CPP Directive Processing (not using Wave):");

  // Dummy attribute (nothing is done here since this is an empty class)
     AttachPreprocessingInfoTreeTraversalInheritedAttrribute inh;

  // DQ (4/19/2006): Now supporting either the collection or ALL comments and CPP directives 
  // into header file AST nodes or just the collection of the comments and CPP directives 
  // into the source file.
  // printf ("sageFilePtr->get_collectAllCommentsAndDirectives() = %s \n",sageFilePtr->get_collectAllCommentsAndDirectives() ? "true" : "false");

     bool processAllFiles = sageFilePtr->get_collectAllCommentsAndDirectives();
     AttachPreprocessingInfoTreeTrav tt(sageFilePtr,processAllFiles);

  // When using Wave get all the preprocessing dirctives for all the files.
     if ( sageFilePtr->get_wave() == true )
     {
       attachPreprocessingInfoUsingWave(sageFilePtr, tt.get_attributeMapForAllFiles() );

     }

  // DQ (12/19/2008): Added support for Fortran CPP files.
  // If this is a Fortran file requiring CPP processing then we want to call traverse, instead of 
  // traverseWithinFile, so that the whole AST will be processed (which is in a SgSourceFile 
  // using a name without the "_preprocessed" suffix, though the statements in the file are 
  // marked with a source position from the filename with the "_preprocessed" suffix).
     bool requiresCPP = sageFilePtr->get_requires_C_preprocessor();

     if (processAllFiles == true || requiresCPP == true)
        {
          tt.traverse(sageFilePtr, inh);
        }
       else
        {
          tt.traverseWithinFile(sageFilePtr,inh);
        }

  // endif for ifndef  CXX_IS_ROSE_CODE_GENERATION
#endif

#if 0
     // This is pointless since at this point the last step of the traversla has reset the lists (state held in tt).
     // DQ (10/27/2007): Output debugging information
     if ( SgProject::get_verbose() >= 3 )
     {
       if (processAllFiles == true)
         tt.display("Output from collecting ALL comments and CPP directives (across source and header files)");
       else
         tt.display("Output from collecting comments and CPP directives in source file only");
     }
#endif
   }


// EOF








