/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../../Container/Container.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../../io/io.h"
#include "./ModelProcessorx.h"

void CreateParameters(Parameters** pparameters,IoModel* iomodel,const int solution_type,int analysis_type,int analysis_counter){
	
	int         i;
	int         numoutputs;
	Parameters *parameters       = NULL;
	double     *requestedoutputs = NULL;
	
	if(*pparameters)return; //do not create parameters twice!

	/*Initialize dataset: */
	parameters = new Parameters(ParametersEnum);
		
	/*Copy some constants from iomodel */
	parameters->AddObject(iomodel->CopyConstantObject(DimEnum));
	parameters->AddObject(iomodel->CopyConstantObject(FlowequationIshutterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(FlowequationIsmacayealpattynEnum));
	parameters->AddObject(iomodel->CopyConstantObject(FlowequationIsstokesEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsOutputFrequencyEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticRestolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticReltolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticAbstolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticMaxiterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SteadystateReltolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SteadystateMaxiterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ConstantsYtsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingTimeStepEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingFinalTimeEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingTimeAdaptEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingCflCoefficientEnum));
	parameters->AddObject(iomodel->CopyConstantObject(PrognosticHydrostaticAdjustmentEnum));
	parameters->AddObject(iomodel->CopyConstantObject(PrognosticStabilizationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticPenaltyFactorEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalPenaltyFactorEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsLowmemEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MeshAverageVertexConnectivityEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ConstantsReferencetemperatureEnum));
	parameters->AddObject(iomodel->CopyConstantObject(BalancethicknessStabilizationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(HydrologyStabilizationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(GroundinglineMeltingRateEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalMaxiterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalStabilizationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalPenaltyThresholdEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalPenaltyLockEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticRiftPenaltyThresholdEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticStokesreconditioningEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticShelfDampeningEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DiagnosticViscosityOvershootEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsWaitonlockEnum));
	parameters->AddObject(iomodel->CopyConstantObject(NumberOfElementsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsIoGatherEnum));
	parameters->AddObject(iomodel->CopyConstantObject(GroundinglineMigrationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsdiagnosticEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsprognosticEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsthermalEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsgroundinglineEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MaterialsRheologyLawEnum));

	/*some parameters that did not come with the iomodel: */
	parameters->AddObject(new IntParam(SolutionTypeEnum,solution_type));
	parameters->AddObject(new IntParam(AnalysisTypeEnum,analysis_type));
	parameters->AddObject(new IntParam(AnalysisCounterEnum,analysis_counter));
	parameters->AddObject(new DoubleParam(TimeEnum,0.0));  //start at time 0 by default for all solutions

	/*Requested output?*/
	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,DiagnosticRequestedOutputsEnum);
	parameters->AddObject(new IntParam(DiagnosticNumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(DiagnosticRequestedOutputsEnum,requestedoutputs,numoutputs));
	xfree((void**)&requestedoutputs);
	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,TransientRequestedOutputsEnum);
	parameters->AddObject(new IntParam(TransientNumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(TransientRequestedOutputsEnum,requestedoutputs,numoutputs));
	xfree((void**)&requestedoutputs);
	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,SteadystateRequestedOutputsEnum);
	parameters->AddObject(new IntParam(SteadystateNumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(SteadystateRequestedOutputsEnum,requestedoutputs,numoutputs));
	xfree((void**)&requestedoutputs);
	
	/*Before returning, create parameters in case we are running Qmu or control types runs: */
	CreateParametersControl(&parameters,iomodel,solution_type,analysis_type);
	CreateParametersQmu(&parameters,iomodel,solution_type,analysis_type);

	/*Go through all parameters, and convert units to SI: */
	parameters->UnitConversion(ExtToIuEnum);

	/*Assign output pointer: */
	*pparameters=parameters;
}
