md=setmesh(model,'../Exp/Square.exp',170000);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=extrude(md,3,1);
md=setflowequation(md,'pattyn','all');

%control parameters
md.inversion.iscontrol=1;
md.inversion.control_parameters={'FrictionCoefficient'};
md.inversion.min_parameters=1*ones(md.numberofnodes,1);
md.inversion.max_parameters=200*ones(md.numberofnodes,1);
md.inversion.nsteps=2;
md.inversion.cost_functions=[102*ones(md.inversion.nsteps,1)  501*ones(md.inversion.nsteps,1)];
md.inversion.cost_functions_coefficients=ones(md.numberofnodes,2); md.inversion.cost_functions_coefficients(:,2)=2*10^-7;
md.inversion.gradient_scaling=3*ones(md.inversion.nsteps,1);
md.inversion.maxiter_per_step=2*ones(md.inversion.nsteps,1);
md.inversion.step_threshold=0.3*ones(md.inversion.nsteps,1);
md.timestepping.time_step=0;
md.inversion.vx_obs=md.initialization.vx; md.inversion.vy_obs=md.initialization.vy;

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,SteadystateSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'FrictionCoefficient' 'Pressure' 'Vel' 'Vx' 'Vy' 'Vz' 'Temperature' 'BasalforcingsMeltingRate'};
field_tolerances={1e-08,1e-07,1e-08,1e-08,1e-08,1e-08,1e-08,1e-07,1e-08,1e-05};
field_values={...
	PatchToVec(md.results.SteadystateSolution.Gradient1),...
	md.results.SteadystateSolution.J,...
	PatchToVec(md.results.SteadystateSolution.FrictionCoefficient),...
	PatchToVec(md.results.SteadystateSolution.Pressure),...
	PatchToVec(md.results.SteadystateSolution.Vel),...
	PatchToVec(md.results.SteadystateSolution.Vx),...
	PatchToVec(md.results.SteadystateSolution.Vy),...
	PatchToVec(md.results.SteadystateSolution.Vz),...
	PatchToVec(md.results.SteadystateSolution.Temperature),...
	PatchToVec(md.results.SteadystateSolution.BasalforcingsMeltingRate)
};
