md=setmesh(model,'../Exp/Square.exp',150000);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=extrude(md,3,2);
md=setflowequation(md,'macayeal','all');
md.cluster=none;
md.timestepping.time_step=0;
md=solve(md,SteadystateSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure','Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13
};
field_values={...
	PatchToVec(md.results.SteadystateSolution.Vx),...
	PatchToVec(md.results.SteadystateSolution.Vy),...
	PatchToVec(md.results.SteadystateSolution.Vz),...
	PatchToVec(md.results.SteadystateSolution.Vel),...
	PatchToVec(md.results.SteadystateSolution.Pressure),...
	PatchToVec(md.results.SteadystateSolution.Temperature),...
	PatchToVec(md.results.SteadystateSolution.BasalforcingsMeltingRate),...
	};
