md=setmesh(model,'../Exp/Square.exp',350000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,1);
md=setflowequation(md,'macayeal','all');
md.cluster=none;

md.timestepping.time_step=1;
md.output_frequency=1;
md.timestepping.final_time=4;

%Set up transient
smb = ones(md.numberofnodes,1)*3.6;
smb=[ smb smb*-1 ];

md.surfaceforcings.mass_balance= smb;
md.surfaceforcings.mass_balance(end+1,:)=[1.5 3];
md.transient.isthermal=0;

md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vz1','Vel1','Pressure1','Bed1','Surface1','Thickness1','SurfaceforcingsMassBalance1', ...
	'Vx2','Vy2','Vz2','Vel2','Pressure2','Bed2','Surface2','Thickness2','SurfaceforcingsMassBalance2', ...
	'Vx3','Vy3','Vz3','Vel3','Pressure3','Bed3','Surface3','Thickness3','SurfaceforcingsMassBalance3',...
	'Vx4','Vy4','Vz4','Vel4','Pressure4','Bed4','Surface4','Thickness4','SurfaceMassbalance4'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};

field_values={...
	PatchToVec(md.results.TransientSolution(1).Vx),...
	PatchToVec(md.results.TransientSolution(1).Vy),...
	PatchToVec(md.results.TransientSolution(1).Vz),...
	PatchToVec(md.results.TransientSolution(1).Vel),...
	PatchToVec(md.results.TransientSolution(1).Pressure),...
	PatchToVec(md.results.TransientSolution(1).Bed),...
	PatchToVec(md.results.TransientSolution(1).Surface),...
	PatchToVec(md.results.TransientSolution(1).Thickness),...
	PatchToVec(md.results.TransientSolution(1).SurfaceforcingsMassBalance),...
	PatchToVec(md.results.TransientSolution(2).Vx),...
	PatchToVec(md.results.TransientSolution(2).Vy),...
	PatchToVec(md.results.TransientSolution(2).Vz),...
	PatchToVec(md.results.TransientSolution(2).Vel),...
	PatchToVec(md.results.TransientSolution(2).Pressure),...
	PatchToVec(md.results.TransientSolution(2).Bed),...
	PatchToVec(md.results.TransientSolution(2).Surface),...
	PatchToVec(md.results.TransientSolution(2).Thickness),...
	PatchToVec(md.results.TransientSolution(2).SurfaceforcingsMassBalance),...
	PatchToVec(md.results.TransientSolution(3).Vx),...
	PatchToVec(md.results.TransientSolution(3).Vy),...
	PatchToVec(md.results.TransientSolution(3).Vz),...
	PatchToVec(md.results.TransientSolution(3).Vel),...
	PatchToVec(md.results.TransientSolution(3).Pressure),...
	PatchToVec(md.results.TransientSolution(3).Bed),...
	PatchToVec(md.results.TransientSolution(3).Surface),...
	PatchToVec(md.results.TransientSolution(3).Thickness),...
	PatchToVec(md.results.TransientSolution(3).SurfaceforcingsMassBalance),...
	PatchToVec(md.results.TransientSolution(4).Vx),...
	PatchToVec(md.results.TransientSolution(4).Vy),...
	PatchToVec(md.results.TransientSolution(4).Vz),...
	PatchToVec(md.results.TransientSolution(4).Vel),...
	PatchToVec(md.results.TransientSolution(4).Pressure),...
	PatchToVec(md.results.TransientSolution(4).Bed),...
	PatchToVec(md.results.TransientSolution(4).Surface),...
	PatchToVec(md.results.TransientSolution(4).Thickness),...
	PatchToVec(md.results.TransientSolution(4).SurfaceforcingsMassBalance),...
	};
