md=setmesh(model,'../Exp/Square.exp',180000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=extrude(md,3,2);
md.cluster=none;
md=setflowequation(md,'stokes','all');
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-08,1e-08,1e-08,1e-08,1e-08};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vz),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
