md=mesh(model,'../Exp/Pig.exp',10000);
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');

%impose hydrostatic equilibrium (required by Stokes)
md.geometry.bed=-md.materials.rho_ice/md.materials.rho_water*md.geometry.thickness;
md.geometry.surface=md.geometry.bed+md.geometry.thickness;
md=extrude(md,3,1);
md=setflowequation(md,'stokes','all');
md=modelextract(md,md.mask.elementonfloatingice);

%control parameters
md.inversion.iscontrol=1;
md.inversion.control_parameters={'MaterialsRheologyBbar'};
md.inversion.min_parameters=10^6*ones(md.numberofnodes,1);
md.inversion.max_parameters=2*10^9*ones(md.numberofnodes,1);
md.inversion.nsteps=2;
md.inversion.cost_functions=101*ones(md.inversion.nsteps,1);
md.inversion.cost_functions_coefficients=ones(md.numberofnodes,1);
md.inversion.gradient_scaling=10^8*ones(md.inversion.nsteps,1);
md.inversion.maxiter_per_step=2*ones(md.inversion.nsteps,1);
md.inversion.step_threshold=0.99*ones(md.inversion.nsteps,1);
md.inversion.vx_obs=md.initialization.vx; md.inversion.vy_obs=md.initialization.vy;

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'MaterialsRheologyB' 'Pressure' 'Vel' 'Vx' 'Vy'};
field_tolerances={1e-11,1e-12,1e-12,1e-09,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Gradient1),...
	md.results.DiagnosticSolution.J,...
	PatchToVec(md.results.DiagnosticSolution.MaterialsRheologyB),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy)
};
