function [sx,sy,s]=slope(md)
%SLOPE - compute the surface slope
%
%   Usage:
%      [sx,sy,s]=slope(md)

%load some variables (it is much faster if the variab;es are loaded from md once for all) 
if (md.dim==2),
	numberofelements=md.numberofelements;
	numberofnodes=md.numberofnodes;
	index=md.elements;
	x=md.x; y=md.y;
else
	numberofelements=md.numberofelements2d;
	numberofnodes=md.numberofnodes2d;
	index=md.elements2d;
	x=md.x2d; y=md.y2d;
end

%compute nodal functions coefficients N(x,y)=alpha x + beta y + gamma
[alpha beta]=GetNodalFunctionsCoeff(index,x,y);

summation=[1;1;1];
sx=(md.geometry.surface(index).*alpha)*summation;
sy=(md.geometry.surface(index).*beta)*summation;
s=sqrt(sx.^2+sy.^2);

if md.dim==3,
	sx=project3d(md,sx,'element');
	sy=project3d(md,sy,'element');
	s=sqrt(sx.^2+sy.^2);
end
