%GEOMETRY class definition
%
%   Usage:
%      geometry=geometry();

classdef geometry
	properties (SetAccess=public) 
		surface           = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',SurfaceEnum);
		thickness         = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',ThicknessEnum);
		bed               = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',BedEnum);
		bathymetry        = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1,'enum',BathymetryEnum);
		hydrostatic_ratio = modelfield('default',NaN,'marshall',true,'format','DoubleMat','mattype',1);
	end
	methods
		function obj = geometry(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
	end
end
