function average=averaging(md,data,iterations)
%AVERAGING - smooths the input over the mesh
%
%   This routine takes a list over the elements or the nodes in input
%   and return a list over the nodes.
%   For each iterations it computes the average over each element (average 
%   of the vertices values) and then computes the average over each node
%   by taking the average of the element around a node weighted by the
%   elements volume
%
%   Usage:
%      smoothdata=averaging(md,data,iterations)
%
%   Examples:
%      velsmoothed=averaging(md,md.initialization.vel,4);
%      pressure=averaging(md,md.initialization.pressure,0);

if length(data)~=md.numberofelements & length(data)~=md.numberofnodes
	error('averaging error message: data not supported yet');
end

%initialization
weights=zeros(md.numberofnodes,1);
data=data(:);

%load some variables (it is much faster if the variab;es are loaded from md once for all)
index=md.elements;
numberofnodes=md.numberofnodes;
numberofelements=md.numberofelements;

%build some variables
line=index(:);
if md.dim==3
	rep=6;
	areas=GetAreas(index,md.x,md.y,md.z);
else
	rep=3;
	areas=GetAreas(index,md.x,md.y);
end
summation=1/rep*ones(rep,1);
linesize=rep*numberofelements;

%update weights that holds the volume of all the element holding the node i
weights=sparse(line,ones(linesize,1),repmat(areas,rep,1),numberofnodes,1);

%initialization
if length(data)==numberofelements
	average_node=sparse(line,ones(linesize,1),repmat(areas.*data,rep,1),numberofnodes,1);
	average_node=average_node./weights;
else
	average_node=data;
end

%loop over iteration
for i=1:iterations
	average_el=average_node(index)*summation;
	average_node=sparse(line,ones(linesize,1),repmat(areas.*average_el,rep,1),numberofnodes,1);
	average_node=average_node./weights;
end

%return output as a full matrix (C code do not like sparse matrices)
average=full(average_node);
