md=mesh(model,'../Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'macayeal','all');
md.cluster=none;

%redo the parameter file for this special shelf. 
%constant thickness, constrained (vy=0) flow into an icefront, 
%from 0 m/yr at the grounding line.

%tighten
md.diagnostic.restol=10^-4;

%needed later
ymin=min(md.y);
ymax=max(md.y);
xmin=min(md.x);
xmax=max(md.x);

di=md.materials.rho_ice/md.materials.rho_water;

h=1000;
md.thickness=h*ones(md.numberofnodes,1);
md.bed=-md.materials.rho_ice/md.materials.rho_water*md.thickness;
md.surface=md.bed+md.thickness;

%Initial velocity and pressure
md.initialization.vx=zeros(md.numberofnodes,1);
md.initialization.vy=zeros(md.numberofnodes,1);
md.initialization.vz=zeros(md.numberofnodes,1);
md.initialization.pressure=zeros(md.numberofnodes,1);

%Materials
md.initialization.temperature=(273-20)*ones(md.numberofnodes,1);
md.materials.rheology_B=paterson(md.initialization.temperature);
md.materials.rheology_n=3*ones(md.numberofelements,1);

%Boundary conditions:
md.diagnostic.spcvx=NaN*ones(md.numberofnodes,1);
md.diagnostic.spcvy=NaN*ones(md.numberofnodes,1);
md.diagnostic.spcvz=NaN*ones(md.numberofnodes,1);

%constrain flanks to 0 normal velocity
pos=find(md.x==xmin | md.x==xmax);
md.diagnostic.spcvx(pos)=0;
md.diagnostic.spcvz(pos)=NaN;

%constrain grounding line to 0 velocity
pos=find(md.y==ymin);
md.diagnostic.spcvx(pos)=0;
md.diagnostic.spcvy(pos)=0;

%icefront
nodeonicefront=zeros(md.numberofnodes,1);
pos=find(md.y==ymax); nodeonicefront(pos)=1;
pos=find(nodeonicefront(md.segments(:,1)) | nodeonicefront(md.segments(:,2))); diagnostic.icefront=md.segments(pos,:);
diagnostic.icefront=[diagnostic.icefront 1*md.mask.elementonfloatingice(diagnostic.icefront(:,end))];
md.diagnostic.icefront=diagnostic.icefront;

md=solve(md,DiagnosticSolutionEnum);

%create analytical solution: strain rate is constant = ((rho_ice*g*h)/4B)^3 (Paterson, 4th Edition, page 292.
%ey_c=(md.materials.rho_ice*md.constants.g*(1-di)*md.thickness./(4*md.materials.rheology_B)).^3;
%vy_c=ey_c.*md.y*md.constants.yts;

%Fields and tolerances to track changes
field_names     ={'Vy'};
field_tolerances={1e-13};
field_values={PatchToVec(md.results.DiagnosticSolution.Vy)};
