function md=tres(md,string)
%TRES - transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%    Example: md=tres(md,'diagnostic');

%check number of arguments

if strcmpi(string,'diagnostic'),
	if md.dim==2,
		if isfield(md.results.DiagnosticSolution,'VxAverage'),
			md.initialization.vx=PatchToVec(md.results.DiagnosticSolution.VxAverage);
		else
			md.initialization.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
		end
		if isfield(md.results.DiagnosticSolution,'VyAverage'),
			md.initialization.vy=PatchToVec(md.results.DiagnosticSolution.VyAverage);
		else
			md.initialization.vy=PatchToVec(md.results.DiagnosticSolution.Vy);
		end
	else 
		md.initialization.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
		md.initialization.vy=PatchToVec(md.results.DiagnosticSolution.Vy);
		if isfield(md.results.DiagnosticSolution,'Vz'),
			md.initialization.vz=PatchToVec(md.results.DiagnosticSolution.Vz);
		else
			md.initialization.vz=zeros(md.numberofnodes,1);
		end
	end
	md.initialization.vel=PatchToVec(md.results.DiagnosticSolution.Vel);

	if isfield(md.results.DiagnosticSolution,'Pressure'),
		md.initialization.pressure=PatchToVec(md.results.DiagnosticSolution.Pressure);
	end
	if md.rifts.numrifts,
		if isfield(md.results.DiagnosticSolution,'riftproperties'),
			md.rifts.riftproperties=md.results.DiagnosticSolution.riftproperties;
		end
	end
	if md.inversion.iscontrol==1,
		for inversion.control_parameters=md.inversion.control_parameters
			%Will need to be updated... good luck ;)
			md.(EnumToModelField(inversion.control_parameters))=PatchToVec(md.results.DiagnosticSolution.(EnumToString(inversion.control_parameters)));
		end
	end

elseif strcmpi(string,'dakota'),
	md.qmu.results=md.results.dakota;

elseif strcmpi(string,'flaim'),
	md.flaim.solution=md.results.FlaimSolution.solution;
	md.flaim.quality =md.results.FlaimSolution.quality;

elseif strcmpi(string,'transient'),
	results=md.results.TransientSolution;
	results2.Vel=NaN;
	count=1;
	for i=1:length(results),
		if ~isempty(md.results.TransientSolution(i).Vel),
			results2(count).Vel=PatchToVec(md.results.TransientSolution(i).Vel);
			results2(count).Surface=PatchToVec(md.results.TransientSolution(i).Surface);
			results2(count).Thickness=PatchToVec(md.results.TransientSolution(i).Thickness);
			results2(count).Bed=PatchToVec(md.results.TransientSolution(i).Bed);
			results2(count).Vx=PatchToVec(md.results.TransientSolution(i).Vx);
			results2(count).Vy=PatchToVec(md.results.TransientSolution(i).Vy);
			results2(count).time=md.results.TransientSolution(i).time;
			results2(count).step=md.results.TransientSolution(i).step;
			if ~strcmpi(md.groundingline.migration,'None'),
				results2(count).ElementOnIceShelf=md.results.TransientSolution(i).ElementOnIceShelf;
			end
			count=count+1;
		end
	end
	md.results.TransientSolution=results2;
	clear results,results2;
elseif strcmpi(string,'steadystate'),
	md.initialization.vx=PatchToVec(md.results.SteadystateSolution.Vx);
	md.initialization.vy=PatchToVec(md.results.SteadystateSolution.Vy);
	if isfield(md.results.SteadystateSolution,'Vz'),
		md.initialization.vz=PatchToVec(md.results.SteadystateSolution.Vz);
	end

	md.initialization.vel=PatchToVec(md.results.SteadystateSolution.Vel);
	md.initialization.pressure=PatchToVec(md.results.SteadystateSolution.Pressure);
	md.initialization.temperature=PatchToVec(md.results.SteadystateSolution.Temperature);
	md.basalforcings.melting_rate=PatchToVec(md.results.SteadystateSolution.BasalforcingsMeltingRate);

	if md.inversion.iscontrol==1,
		for inversion.control_parameters=md.inversion.control_parameters
			md.(EnumToModelField(inversion.control_parameters))=PatchToVec(md.results.SteadystateSolution.(EnumToString(inversion.control_parameters)));
		end
	end

elseif strcmpi(string,'thermal'),
	md.initialization.temperature=PatchToVec(md.results.ThermalSolution.Temperature);
	md.basalforcings.melting_rate=PatchToVec(md.results.ThermalSolution.BasalMeltingRate);
elseif strcmpi(string,'hydrology'),
	md.initialization.watercolumn=PatchToVec(md.results.HydrologySolution.Watercolumn);

else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
