function flag=outflow(md);
%OUTFLOW - flag nodes on outflux boundary
%
%   Usage:
%      flag=outflow(md);

A=md.segments(:,1);
B=md.segments(:,2);
Nx=-(md.y(A)-md.y(B));
Ny=  md.x(A)-md.x(B);
Vx=(md.initialization.vx(A)+md.initialization.vx(B))/2;
Vy=(md.initialization.vy(A)+md.initialization.vy(B))/2;

%dot product
VdotN=Vx.*Nx+Vy.*Ny;

flag=zeros(md.numberofnodes,1);
flag(A(find(VdotN>0)))=1;
