function femmodel=gradient_core(femmodel,varargin),
%GRADIENT_CORE - Brief compute inverse method gradient direction
% 
%   Usage:
%       femmodel=gradient_core(femmodel,varargin);
% 
%   Examples:
%      femmodel=gradient_core(femmodel);
%      femmodel=gradient_core(femmodel,step,search_scalar);

if nargin==3,
	step=varargin{1};
	search_scalar=varargin{2};
elseif nargin==1
	step=0;
	search_scalar=0;;
else
	help gradient_core
	error('bad usage');
end

	%recover parameters common to all solutions
	num_controls=femmodel.parameters.InversionNumControlParameters;
	control_type=femmodel.parameters.InversionControlParameters;
	control_steady=femmodel.parameters.ControlSteady;
	gradient_scaling_list=femmodel.parameters.InversionGradientScaling;

	for i=1:num_controls,

		issmprintf(VerboseControl,['   compute gradient of J with respect to %s'],EnumToString(control_type(i)));
		grad=Gradj(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,control_type(i));

		if control_steady,
			femmodel=diagnostic_core(femmodel);
		end

		if (step>1 && search_scalar==0),
			issmprintf(VerboseControl,'%s',['   orthogonalization']);
			old_gradient=ControlInputGetGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,control_type(i));
			new_gradient=Orth(grad,old_gradient);
		else
			issmprintf(VerboseControl,'%s',['   normalizing direction']);
			new_gradient=Orth(grad,[]);
		end

		 %Get scaling factor of current control:
		 norm_grad=norm(new_gradient,inf);
		 if(norm_grad<=0),     error(['||∂J/∂α||∞ = 0   gradient norm of J with respect to ' EnumToString(control_type(i))  ' is zero']); end
		 if(isnan(norm_grad)), error(['||∂J/∂α||∞ = NaN gradient norm of J with respect to ' EnumToString(control_type(i))  ' is NaN' ]); end
		 if(i==1 | (gradient_scaling_list(step,i)/norm_grad)<gradient_scaling) gradient_scaling=gradient_scaling_list(step,i)/norm_grad; end

		%plug back into inputs:
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=ControlInputSetGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,  femmodel.parameters,control_type(i),new_gradient);
	end

	%Scale all gradients
	for i=1:num_controls,
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=ControlInputScaleGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,  femmodel.parameters,control_type(i),gradient_scaling);
	end
